﻿:Namespace Utils
    :Namespace numbers
          hex←{⎕IO←0                              ⍝ Hexadecimal from decimal.
              ⍺←{⍵}                               ⍝ no width specification.
              1≠≡,⍵:⍺ ∇¨⍵                         ⍝ simple-array-wise:
              n←⍬⍴⍺,2*⌈2⍟2⌈16⍟1+⌈/|,⍵             ⍝ default width.
              ↓[0]'0123456789abcdef'[(n/16)⊤⍵]    ⍝ character hex numbers.
          }
          dec←{⎕ML ⎕IO←0                                  ⍝ Decimal from hexadecimal
              ⍺←0                                         ⍝ unsigned by default.
              1<⍴⍴⍵:↑⍺ ∇¨↓⍵                               ⍝ vector-wise:
              0=⍴⍵:0                                      ⍝ dec'' → 0.
              1≠≡,⍵:⍺ ∇¨⍵                                 ⍝ simple-array-wise:
              ' '=⊃⍵:⍺ ∇ 1↓⍵                              ⍝ ignoring leading and
              ' '=⊃⌽⍵:⍺ ∇ ¯1↓⍵                            ⍝ ... trailing blanks.
              ' '∊⍵:⍺ ∇¨{1↓¨(⍵=' ')⊂⍵}' ',⍵               ⍝ blank-separated:
              v←16|'0123456789abcdef0123456789ABCDEF'⍳⍵   ⍝ hex digits.
              (16⊥v)-⍺×(8≤⊃v)×16*⊃⍴,v                     ⍝ (signed) decimal number.
          }
    :EndNamespace
    :Namespace text
          wrap←{⎕IO←0                     ⍝ Wrap word vector at ⍺ cols.
              ⍺←⎕PW                       ⍝ default ⎕PW-wrap.
              ⍺≥⍴⍵:⍵                      ⍝ short enough vector: finished.
              gaps←(' '=(⍺+1)↑⍵)/⍳⍺+1     ⍝ indices of blanks.
              take←¯1↑⍺,(⍺≥gaps)/gaps     ⍝ chars to take.
              drop←take+' '=take⊃⍵        ⍝ chars to drop.
              head←(take↑⍵),3⊃⎕AV         ⍝ first line and <LF> then,
              head,⍺ ∇ drop↓⍵             ⍝ wrapped following lines.
          }
    :EndNamespace
:EndNamespace