﻿:Namespace SALTUtils ⍝ V2.811
⍝ Utility Functions used by SALT and User Commands code
⍝ 2016 05 30 DanB: added ⍳ underbar in ⎕Uxxxx list, use ⌶ for Xcase
⍝ 2016 06 17 DanB: use ⎕SIGNAL 0 to clear ⎕DM
⍝ 2016 06 20 DanB: Dir excludes hidden files for V15 too
⍝ 2016 07 21 DanB: use ⎕MAP instead of ⎕NREAD in GetUnicodeFile
⍝ 2016 08 31 DanB: added .dyalog to script name in help
⍝ 2016 10 06 DanB: fixed help values display
⍝ 2016 10 28 DanB: modified xCase to work on nested arrays
⍝ 2017 01 12 Adam: use 4070⌶ on Windows
⍝ 2017 01 17 Adam: use 3503⌶
⍝ 2017 01 24 Adam: fix broken save
⍝ 2017 02 23 Adam: bump version to 2.2 for 16.0
⍝ 2017 03 02 Adam: add support for ⊂_ and ⎕⋄ and change to OS specific file sep
⍝ 2017 03 08 Adam: rephrase "N arguments or less" → "up to N arguments", added OS
⍝ 2017 03 10 Jay: trailing / on cache folder
⍝ 2017 03 15 Adam: fold all help text, uppercase group names, and allow ]? to find them with partial spec
⍝ 2017 03 15 Adam: added UNICODE, CLASSIC, AMD64, X86, Fonts
⍝ 2017 03 16 Adam: UCMD ⎕SIGNAL 0
⍝ 2017 05 22 Adam: Remove unofficial release notes
⍝ 2017 05 23 Adam: added ARM
⍝ 2017 05 24 Adam: disable display of Event in EditorFix, proper ]?disambiguation per [14560], MODE 8→24
⍝ 2017 05 25 Adam: Always show CamelCase ucmd names
⍝ 2017 06 02 Adam: ]wsdoc and ]documentation now refer to ]ws.document
⍝ 2017 06 15 Adam: ] now gives general help
⍝ 2017 06 19 Adam: [14684] added USERDIR
⍝ 2017 06 23 MKrom: Return contents of first folder on workdir when ]list has no filters
⍝ 2017 07 06 Adam: Full path to USERDIR so it can be called from SALT
⍝ 2017 07 19 Adam: [14756] trap EditorFix errors and exceptions; added DYALOG (install folder)
⍝ 2017 07 24 Adam: [14756] more helpful file error messages and save ⎕DMX
⍝ 2017 07 25 Adam: catch errors during EditorFix and present the user with options (requires r30520 for Abort to work)
⍝ 2017 08 03 Adam: [13126,14884] Uncaptured ucmd result is shy but prints to STDERR, shy EditorFix
⍝ 2017 08 08 Adam: [14884] EditorFix now has dummy default result
⍝ 2017 08 15 Adam: [14920] errorsHaveLeadingBS←1 for future ability to remove it
⍝ 2017 09 06 Adam: Added BITS
⍝ 2017 10 09 Adam: Removed ]uversion → ]version ref
⍝ 2017 01 31 Adam: Revert STDERR output
⍝ 2018 02 06 Adam: Make sure name is available when trapping ]? errors
⍝ 2018 02 15 Adam: tty msgbox text update; offer linking
⍝ 2018 03 06 Mkrom: AfterFix enhanced for ]link
⍝ 2018 03 10 Mkrom: ]link code moved to separate location
⍝ 2018 03 28 Adam: [14920] Remove leading BS in error msgs
⍝ 2018 04 03 Adam: [14920] Only remove BS if present
⍝ 2018 04 09 Adam: [14920] Default to no BS in errmsgs
⍝ 2018 04 17 Adam: Move Delify and Dedelify from SALT
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -?? and ]?? → ] and ]?+ → ]??
⍝ 2018 04 19 Adam: Also allow ] -??. UCMD strips trailing blanks and comments. Tweak general help text after listings. Stop special-casing ]Help.
⍝ 2018 04 20 Adam: Stop special-casing ]Help, but special-case ]Help -, only show technical info with help if DEBUG is on
⍝ 2018 04 24 Adam: Special-case ]Help '
⍝ 2018 04 25 Adam: split compound lines in dir
⍝ 2018 04 26 Adam: [15778] trap failing Dir due to bad filenames
⍝ 2018 05 01 Adam: tweak ] and ] -?, assume Windows scales fonts, ]cmd -? with ]udebug on shows version and revision and source
⍝ 2018 05 16 Adam: Help delimiter line across entire session, text tweak
⍝ 2018 05 18 Adam: Warning about version number
⍝ 2018 05 23 Adam: Ucmd group name descriptions
⍝ 2018 05 28 Brian: Version-sensitive SALTsetFile
⍝ 2018 05 29 Adam: Refresh ucmds if not found when asking for help
⍝ 2018 06 04 Adam: [15921] Invalid → Ambiguous
⍝ 2018 06 05 Adam: Remove some "", code tweaks, lines above group help
⍝ 2018 06 07 Adam: Move comment stripping from UCMD to Spice
⍝ 2018 06 12 Andy: add note about lin between version number and contents of docbin
⍝ 2018 06 18 Adam: fix ]?cmd and general help, remove line after ]-disambiguation
⍝ 2018 06 19 Adam: max 80-char and empty row after header line in help [15664] preserve BS except errmsg and ⎕←
⍝ 2018 06 20 Adam: max 79-char line
⍝ 2018 07 30 Adam: fix [USER]
⍝ 2018 08 22 Adam: [16278] Trap all errors when making ucmd cache
⍝ 2018 10 18 Adam: Give ucmds invisible result if no-result
⍝ 2018 11 06 Adam: handle one-liner dervs
⍝ 2018 12 18 Adam: make [ws] case-insensitive
⍝ 2018 12 19 Adam: Add ⎕DMX message to EditorFix error box, set DEBUG if UNSET
⍝ 2019 01 08 Adam: Lazy ARM
⍝ 2019 01 16 Adam: Better msg for - without DEBUG
⍝ 2019 01 21 Adam: Fix lowercase failing on ⍬
⍝ 2019 01 29 Adam: help
⍝ 2019 02 04 Adam: make ]path/path -? work
⍝ 2019 03 03 Adam: Still Link even if no SALT; also abide by Link DEBUG
⍝ 2019 03 18 MKrom: handle ⎕ML←3 for DEBUG←2
⍝ 2019 04 08 Adam: On Win, get HOME from I-beam
⍝ 2019 04 15 Adam: Handle odd spacing aon fns with ∇s
⍝ 2019 04 24 Adam: Handle interrups in EditorFix
⍝ 2019 10 29 Adam: Add calls to Editor events
⍝ 2019 11 28 Adam: Add callback to ⎕SE.Link.Sync
⍝ 2020 02 13 Adam: Handle multiple Editor callback hooks in order
⍝ 2020 02 20 Adam: Make hook calls relative to ⎕SE
⍝ 2020 03 06 Adam: Generalise Editor callbacks to Link
⍝ 2020 04 29 Adam: [18066] Prune old ucmd names
⍝ 2020 05 11 Adam: [18072] Centralised checking of hooks
⍝ 2020 05 27 Adam: Add VERSION, V18, and handling of Hoof (○¨)
⍝ 2020 06 11 Adam: Trap more issues when building ucmd cache
⍝ 2020 06 23 Adam: Fix -? display issues with ]udebug on
⍝ 2020 07 14 Adam: Use ⎕C if available, add fCase
⍝ 2020 07 16 Adam: Recursive 819 ⌶-based ⎕C-fallback
⍝ 2021 01 20 Adam: Handle disappeared ucmds
⍝ 2021 01 21 Adam: Better message for urefresh
⍝ 2021 02 17 Adam: Assume ]TOOLS.Version for ]Version, save ⎕DMX as ⎕SE.SALTUtils.dmx upon error, ignore spaces in ucmd names
⍝ 2021 02 18 Adam: [18864] Use "UserCommand25.190C32.cache" style cache file, autocomplete: suggest official letter case, ⎕C
⍝ 2021 02 18 Andys: Bumped the version number after branching SALT for 17.1 & 18.0
⍝ 2021 02 23 Adam: Delay showing rebuilding ucmd cache msg, but show on Win too
⍝ 2021 03 09 Adam: Line break after rebuilding ucmd cache msg when under RIDE
⍝ 2021 03 25 Andys: Need to refer to ⎕SE.SALTUtils.V18 rather than V18
⍝ 2021 04 08 Adam: Skip rebuilding ucmd cache msg if DYALOGQUIETUCMDBUILD="1"
⍝ 2021 04 12 Adam: Escape all regex in globs
⍝ 2021 04 28 Adam: [18864] Remove wrong "." in ucmd cache file name
⍝ 2021 05 11 Adam: [15801] Always look for envvars
⍝ 2021 05 26 Adam: Defend against value error on tell with threading
⍝ 2021 06 15 Adam: Use RIDE 4.4's new ability to handle ⍞
⍝ 2021 06 17 Adam: Always report UCMD errors
⍝ 2021 06 30 Adam: Allow errors on cache build if DEBUG
⍝ 2021 08 10 Adam: Streamline tracing into ucmds
⍝ 2021 08 12 Adam: Adjustments for help and commands using ##.##
⍝ 2021 08 15 Adam: Expose ##.##.List
⍝ 2021 09 17 Adam: Move USetup here, more informative message when no-op user code
⍝ 2021 10 08 Adam: [19375] Ignore missing ⎕SE.Dyalog.Hooks
⍝ 2021 10 11 Adam: Handle assignment of help requests, "(none found)" if no version number found
⍝ 2021 10 17 Adam: Change easy-trace tech from ⎕LOCK to one-liner dfn and set class stop in UCMD
⍝ 2021 11 10 Adam: Output full error msg on ucmd error, use ⎕DMX for LastResult
⍝ 2021 11 11 Adam: Handle disappeared command
⍝ 2022 01 05 Adam: Clearer instructions for more help, per https://github.com/Dyalog/ride/issues/826
⍝ 2022 03 03 Adam: Fix USetup by localising ⎕ML
⍝ 2022 03 03 Adam: Fix USetup by undoing ↑ vs ⊃ swaps
⍝ 2022 09 08 Adam: Fix Load calling syntax
⍝ 2023 01 04 Adam: [20255] Replace ⎕NGET f 256 with ⎕NGET⎕OPT'ContentType' 'APLcode'
⍝ 2023 02 14 Adam: Try to break ⎕DMX's link to # (or wherever) by going via ⎕JSON, and keep display form
⍝ 2023 05 17 Adam: Do NOT do overlapping matches to remove strings before detecting -??s
⍝ 2023 05 31 Adam: Remove leftover ⎕SE→# ref, create non-dangling ref to input
⍝ 2023 06 21 Adam: Move ⎕SE.Dyalog.Utils from SALT to qSE
⍝ 2023 07 09 Adam: Fix off-by-one error when constructing grammatical sentence, allow stops in EditorFix
⍝ 2023 07 19 Adam: Remove kept result, which could be a  ⎕SE→# ref
⍝ 2023 08 10 Adam: Always InjectReferences
⍝ 2023 09 06 Adam: better UCMD comments
⍝ 2023 09 20 Adam: Defer USetup when called from ⎕SE.StartupSession
⍝ 2023 09 22 Adam: Try to clear ⎕DMX after user command termination
⍝ 2023 12 04 Adam: More defences against ⎕DMX having ⎕SE-# cross references
⍝ 2023 12 25 Adam: Reset ⎕ML & ⎕IO every time a ucmd file is loaded, and when done
⍝ 2024-05-15 Adam: Use ⎕C instead of the I-beam it replaced
⍝ This is the code used for User commands and utilities for SALT.
⍝ It uses undocumented features that may be removed in future versions, do NOT rely on these to be present in the future,
⍝ they may be decommisioned and changed by other features.

    errorsHaveLeadingBS←1
    ⎕io←1 ⋄ ⎕wx←⎕ml←3 ⋄ CR←⎕av[4] ⋄ BS←⎕TC[errorsHaveLeadingBS/1] ⋄ ⎕USING←0⍴⊂''
    SETCOMPILED←SETTS←MONITOR←DEBUG←0 ⋄ MONITORNAME←'#.UCMDMonitor'
    MODE←24⍝8
   ⍝ MODE is used to: 0=display ]? names all together, 1=show min length, 2=no DOT-names, 3=both,
   ⍝ 4=fixed column display, 8=by group, 16=add commands #, 32=accept abbreviations, 64=compile code

    APLV←'.'⎕WG'APLVersion'
    WIN←'Win'≡OS←3↑1⊃APLV
    ∇ arm←ARM
      ⎕EX'ARM'
      :If 'Lin'≡OS
          ARM←'arm'≡3↑⊃⎕SH'uname -m'
      :Else
          ARM←0
      :EndIf
      arm←ARM
    ∇
    UNICODE←~CLASSIC←82=⎕DR''
    UC←⍬⍴UNICODE⌽'CU'
    X86←~AMD64←'64'≡¯2↑1⊃APLV
    BITS←32×1+AMD64
    LINDEL←(~WIN)↓13 10
    VERSION←2⊃'.'⎕VFI 2⊃APLV
    VCODE←(∊⍕¨2↑VERSION),UC,(⍕BITS)
    (V14 V18)←14 18≤1⊃VERSION
    FS←'/\'[1+WIN]  ⋄ PATHDEL←':;'[1+WIN],'∘'
    USERDIR←{⍵:(⊢↓⍨1-'\'⍳⍨⌽)2⊃4070⌶⍬ ⋄ '/',⍨2⎕NQ #'GetEnvironment' 'HOME'}WIN
    DYALOG←2 ⎕NQ'.' 'GetEnvironment' 'DYALOG' ⍝ install folder
    AZaz←' ',⎕A,[0.1]'abcdefghijklmnopqrstuvwxyz' ⍝ used for sorting caseless

    modeBit←{⍬⍴2 (2*⍵) ⊤MODE}       ⍝ bit 0 is rightmost bit
    RSI←{(⍵+1)⊃⎕RSI}
    UCauto←{11::0 ⋄ 1⊣2350⌶⎕null}0  ⍝ UCMD autocomplete available?
    0(400⌶)3×modeBit 6              ⍝ compile all programs if possible

    NewObjectsFolder←''             ⍝ store new objects here if set (in Settings)
    LastResultVarName←'⎕DMX.LastResult'

    :section SPICE ⍝             ===== SPICE/UCMD related code =====

⍝ User Commands version
⍝ BEWARE: installation image build processes require the following line to keep its structure
⍝ BEWARE2: do not change this without ensuring that the docbin repository has been updated to contain
⍝        : a suitably named release notes document
    UVersion←2.7

    UCMDCACHEFILE←'UserCommand',(⍕⌊10×UVersion),'.',VCODE,'.cache' ⍝ e.g. UserCommand25.190C32.cache

    (cGroup cLname cName cDesc cParse cObjName cFullName cMinLen)←⍳8 ⍝ column indices for the UCMD list

   ⍝ List of commands that have been renamed from 1.34
    _←,'urefresh'      'SALT.refresh'
    NewNames←_←(2,⍨.5×⍴_)⍴_

    Header←{('─'⍴⍨79⌊⎕PW)''⍵}

    ∇ r←UCMDGeneralHELP
      r←Header'General Help for User Commands'
      r,←1↓¨(1⊃1+⎕LC)↓⎕NR'UCMDGeneralHELP'
⍝
⍝]cmd             ⍝ Execute Cmd command
⍝]⎕←cmd           ⍝ Display Cmd's result line-by-line
⍝]var←cmd         ⍝ Capture Cmd's result in var
⍝
⍝]grp -?          ⍝ Brief information on commands in group "GRP"
⍝]grp.cmd -?      ⍝ Brief information on command "Cmd" of the "GRP" group
⍝]grp.cmd -??     ⍝ Detailed information on command
⍝]grp.cmd -???    ⍝     add question marks for more info
⍝
⍝]                ⍝ This help message
⍝] -?             ⍝ List all commands
⍝] -??            ⍝ List all commands with summaries
⍝
⍝]X*YZ* -?        ⍝ List commands or groups that match a pattern
⍝]/path/dir -?    ⍝ List commands in /path/dir
⍝]ucmd -?         ⍝ List commands for working with user commands
⍝
    ∇

    noDotNames←{~modeBit 1:⍵ ⋄ ~∨/b←'.'∊¨⍵:⍵ ⋄ ~∨/b←b\m←m∨.∧1<+⌿m←s∘.≡∪s←{⍵↑⍨⍵⍳'.'}¨b/⍵:⍵  ⋄ (∪m/s),(~b)/⍵}
    showNames ←{modeBit 2:⎕PW ¯2 ⎕SE.Dyalog.Utils.showCol{⍵[AZaz⍋⊃⍵]}⍵ ⋄ </modeBit¨1 3:⍺ byGroup ⍵ ⋄ ⎕PW 8 WidthFit{⍵[AZaz⍋⊃⍵]}⍵}
    Where←{⍵/⍳⍴⍵}

    ∇ r←list byGroup names;grps;cut;⎕ML;i;width
     ⍝ Regroup Names (col 1) in list by Group (col 2)
      (grps names)←↓⍉list[AZaz⍋⍕list[;i];i←cGroup cName]
      ⎕ML←1 ⋄ cut←1,2≢/grps ⋄ width←⎕PW-4+⌈/∊⍴¨grps
      r←0 ¯1↓⍕(uCase cut/grps),[1.1]width{0 ¯2↓0 2↓⍕⍪⍺ Fold ⍵}¨cut⊂{((b⍳1)×∨/b←'.'=⍵)↓⍵}¨names
    ∇

    ∇ com←displayNames(arg list);c;cs;dn;i;L;ll;ord;t;pat;plus;mincase;empty
    ⍝ List all the cmds available. arg is ]?'s arg, list is the list of all UCMDs, ln is the lowercase version of names
      mincase←list[;cMinLen]{l←(⍴⍵)⌊|⍺ ⋄ (uCase l↑s),l↓s←⍵}¨⍣(2|MODE)⊢list[;cLname] ⍝ Adjust casing to show min required letters?
      com←0 ⍝ result if nothing to show
      plus←'+'∊(1↑arg),¯1↑arg ⋄ empty←0∊⍴arg←arg~plus/'+'
    ⍝ The list may be reduced using a limited regular expression and the display may be expanded with a +
      :If pat←(plus>empty)∨∨/'?*'∊arg
          (mincase list)←(⊂({⍺,'.',⍵}/list[;cLname,⍨('.'∊arg)/cGroup])limRegexFind arg)∘⌷¨mincase list
      :EndIf
    ⍝ We display a tabular list if a pattern (or nothing) was requested AND no + specified
      :If (pat∨empty)∧~plus
          →0/⍨0∊⍴mincase  ⍝ skip this if none found, the calling program can then try groups
          ll←CR
          ll,←CR,']            ⍝ for general user command help'
          ll,←CR,'] -??        ⍝ for brief info on each command'
          ll,←CR,']grp -?      ⍝ for info on the "GRP" group'
          ll,←CR,']grp.cmd -?  ⍝ for info on the "Cmd" command of the "GRP" group'
     
          :If modeBit 3
          :OrIf 0∊+/PATHDEL∊⍨t←CMDDIR   ⍝ only 1 folder? must be SALT's
              com←(modeBit 4)/CR,((⍕≢list),' commands:'~'s'/⍨1=≢list),CR
              com←ll,⍨com,,CR,list showNames noDotNames⍣(~pat)⊢mincase
          :Else ⍝ multiple paths, show cmds for each - this is a bit more work:
              dn←⍒∊L←⍴¨c←∪{⍵⊂⍨~⍵∊PATHDEL}t,PATHDEL[1],BootPath'spice'
              com←'' ⍝ we search by path length to cover the case \X,\X\Y
              t←c[dn]∘{1⍳⍨⍺≡¨L[dn]↑¨⊂⍵}¨list[;cFullName] ⍝ INDEXERR if no matching folder for a cmd
              :If ∨/t>⍴dn ⍝ then try switching file separator
                  c←{(FS,FS,⍵)[('/\',⍵)⍳⍵]}¨c
                  t←c[dn]∘{1⍳⍨⍺≡¨L[dn]↑¨⊂⍵}¨list[;cFullName]
              :EndIf
              :For i :In ⍳⍴c{⍺}ord←dn[t]
                  :If ∨/cs←i=ord
                      com,←∊CR,¨(⎕PW-1)Fold(0⍕+/cs),' commands in ',(i⊃c),':',CR
                      com,←CR,⍨,CR,list showNames{⍵[AZaz⍋⊃⍵]}noDotNames⍣(~pat)⊢cs⌿mincase
                  :EndIf
              :EndFor
              com←com,ll
          :EndIf
      :ElseIf plus               ⍝ display 1 line summary per cmd
          com←arg helpfor list
      :ElseIf ~isRelPath arg     ⍝ is this a request for help on a path or a specific command?
          com←arg helpfor 2⊃GetUCMDList arg'*'
      :EndIf
      :If 0≢com
          com←∊Header CR,com
      :EndIf
    ∇

    ∇ desc←{stem}describeSwitches switches;w;t;s;n;sn;i;details;line;⎕ML
    ⍝ Describe the switches in layman's terms
      ⎕ML←1 ⋄ i←+/s←t=1↑t←rlb switches
      line←(i>0)/i{6::'Accepts modifier',(1<⍺)/'s' ⋄ stem}details←desc←''
      :For w :In {⍵[⍋↑⍵]}rtb¨s⊂t
          :If (⍴s←w)≥i←⌊/w⍳'=:∊'             ⍝ does this switch have any extra definition?
              s[i]←'=' ⋄ n←⍴s←(i+</s⍳'[=')↑s ⍝ is the value optional?
              :If n<⍴w                       ⍝ is there a validation to perform?
                  sn←1⌽'''''',1↓s~'[=]'      ⍝ the switch name
                  :If w[i]='='
                      details,←∊CR,¨⎕PW Fold' Modifier ',sn,' accepts only values ',↑{⍺,', ',⍵}/{1⌽'""',⍵~'''"'}¨{⎕ML←3 ⋄ b←≠\⍵∊'''"' ⋄ (b∨⍵≠' ')⊂⍵}n↓w
                  :ElseIf w[i]='∊'
                      details,←∊CR,¨⎕PW Fold' Modifier ',sn,' accepts values consisting only of characters in the set ',{(1↑⍵)∊'''"':⍵ ⋄ '"',⍵,'"'}n↓w
                  :Else
                      details,←CR,'The default value of modifier ',sn,' is ',{(1↑⍵)∊'''"':⍵ ⋄ '"',⍵,'"'}n↓w
                  :EndIf
              :EndIf
          :EndIf
          :If ⎕PW<1+(⍴line)+⍴s      ⍝ exceeding ⎕PW?
              desc,←CR,line ⋄ line←s ⍝ yes, start a new line
          :Else
              line,←' ',s           ⍝ no, append to current line
          :EndIf
      :EndFor
      desc,←((0=⍴t)≥CR∊desc)↓CR,t←line,details
    ∇

    setFlag←{2 ⎕NQ'.' 'SetDFlags'⍵}

⍝ This function splits the number of arguments from the switches definition and reformats nicely
    splitRule←{' '∧.=R←rlb ⍵:'' ⋄ (1↑⍵)∊⎕d:rlb¨R splitOn1st' ' ⋄ '' R}

⍝ This function finds the position of a command
    ∇ pos←{exact}findCmdPos name;n;g;rl;glen;b
      exact←{6::⍵ ⋄ exact}~ASN ⍝ exact match?
      :If ~'.'∊name
          →0↑⍨exact∨⍴pos←Where List[;cLname]∊⊂name          ⍝ find an exact match
          pos←Where((List[;cMinLen]⌈⍴name)↑¨List[;cLname])∊⊂name ⍝ find all matches
      :Else
          (g n)←name splitOn1st'.' ⋄ glen←exact×⍴¨List[;cGroup]
          →0↓⍨⍴pos←Where b←((glen⌈⍴g)↑¨List[;cGroup])∊⊂g    ⍝ group found?
          rl←b⌿List[;cLname cMinLen]                        ⍝ reduced list
          →0↑⍨exact∨⍴pos←Where b\rl[;1]∊⊂n                  ⍝ find an exact match
          pos←Where b\((rl[;2]⌈⍴n)↑¨rl[;1])∊⊂n              ⍝ try on all names
      :EndIf
    ∇

    ∇ PreUCMD;cmd;input
      input←⎕SE.input
      'input'⎕SE.⎕NS'⎕SE.SALTUtils.input' ⍝ replace input variable with namespace holding that variable
     
      ⎕SE.input.input←rlb ⎕SE.input.input
      ⎕SE.input.input←'^(?:([\w∆⍙]*)\s*(←)\s*)?(.*) -(\?+)$'⎕R'\1\2\4\3'⊢⎕SE.input.input
      cmd←'"[^"]*"|''[^'']*''' ' *(⍝.*)?$'⎕R'&' ''⊢⎕SE.input.input
     
      :Select cmd
      :Case '' ⍝ ] now gives general help
          ⎕SE.input.input←'??'
      :Case '-?' ⍝ ] -? is like ]?
          ⎕SE.input.input←,'?'
      :CaseList '??' '-??' ⍝ ]?? and ] -?? now gives more help on each cmd
          ⎕SE.input.input←'?+'
      :Case '?+'
          ⎕←']?+ is deprecated. Please use ]??'
          →0
      :EndSelect
     
      :If 0=⎕NC'⎕SE.THIS' ⋄ ⎕SE.THIS←⎕IO⊃1↓⎕RSI ⋄ :EndIf     ⍝ record calling environment
     
⍝ ]var←Cmd accepted; see if it makes sense if present. No spaces allowed.
      ⎕SE.input.notQ←'⎕←'≢⎕SE.input.nma←(~' '∊⎕SE.input.nma)/⎕SE.input.nma←(⌽∨\⌽<\('←'=⎕SE.input.input)>∨\⎕SE.input.input∊'''"')/⎕SE.input.input
      ⎕SE.input.dcl←'*'∊6⍴⎕STACK ⍝ were we at Desk Calculator Level?
      :If ⎕SE.input.notQ∧(1<⍴⎕SE.input.nma)>0 2 9∊⍨⎕SE.THIS.⎕NC ¯1↓⎕SE.input.nma     ⍝ is the assignment legal?
          ⎕SE.input.R←'* assignment syntax error' ⋄ ⎕SE.input.R ⎕SIGNAL ⎕SE.input.dcl↓2 ⋄ ⎕←⎕SE.input.R ⋄ →
      :EndIf
      ⎕SE.input.input←(≢⎕SE.input.nma)↓⎕SE.input.input
     
      ⎕SE.input.rgn←⎕SE.input.dcl,⍨⎕SE.input.dcl≤⎕SE.input.notQ×⍴⎕SE.input.nma
      ⎕SE.SALTUtils.Spice ⎕SE.input.input
      ⎕SE.input.mon←0
      ⎕SE.input.hasR←1
    ∇

    ∇ {rgn}Spice msg;cmd;cs;details;help;helpfor;i;name;names;nargs;reset;rez;rules;switches;syntax;t;stop;swd;ASN;dot;List;anywhereMatches;exact;leading;anywhere;all;before;after;full;cands;or;triedRefresh;code;c
    ⍝ Called by the UCMD program. This program can also be used directly with a string as argument.
      ⎕SE.input.finished←1
      (⎕SE.input.rgn ASN)←2↑⎕SE.input.rgn  ⍝ Is the result used (1) or simply displayed (0) ? do we Allow Short Names?
      ASN←(modeBit 5)∨UCauto<ASN ⍝ In this version we disregard "Allow Short Names" if autocomplete is in effect
     
    ⍝ Put a stop before the call if requested
      cmd←'"[^"]*"|''[^'']*''' ' *(⍝.*)?$'⎕R'&' ''⊢msg
      cmd↓⍨←¯2×stop←×DEBUG×' -'≡¯2↑cmd
      :If 0<i←+/∧\'?'=cmd←{(']'=1↑⍵)↓⍵}rlb cmd
          cmd←cmd[⍳i],' ',rlb i↓cmd ⍝ ensure only one space
      :EndIf ⍝ accept ?cmd
     
      :If (i>1)∧i=¯1+⍴cmd           ⍝ ]?? ≡ ]help
      :OrIf ''≡cmd                  ⍝ just ]
          ⎕SE.input.R←UCMDGeneralHELP
          →LAYOUT    ⍝ more than 1 "?" alone or 'help': general help
      :EndIf
      ⎕SE.input.R←0
     
      (cmd ⎕SE.input.arg)←cmd splitOn1st' ' ⋄ cmd←lCase cmd
     
      :If ~×DEBUG
      :AndIf 'help'≡cmd
      :AndIf ×≢'(^| )(-|'')( |$)'⎕S'&'⊢⎕SE.input.arg
          ⎕SE.input.arg←'(^| )(-|'')( |$)'⎕R'\1"\2"\3'⊢⎕SE.input.arg
      :ElseIf ~×DEBUG
      :AndIf ' -'≡¯2↑rtb ⎕SE.input.arg
          ⎕SE.input.R←,⊂'* Cannot trace user command with trailing "-" when debugging is disabled'
          ⎕SE.input.R,←⊂'      ]UDebug on  ⍝ to enable debugging'
          →LAYOUT
      :EndIf
     
     ⍝ In 13.1 ⎕DMX is introduced and used in some ucmds (e.g. ]DMX). We take a copy here
      :Trap DMX←0        ⍝ this may fail if ⎕DMX contains unusual objects
          'DMX'⎕SE.input.(⎕NS∘(⎕JSON⍣2))⎕DMX
      :EndTrap
     
⍝ If the UCMDs' location has not been enabled it will fail unless we automatically boot Spice:
      :If ~reset←0≠⎕NC'⎕SE.Dyalog.SALT.List'
      :OrIf reset←('ureset'≡cmd)>'?'∊⎕SE.input.arg      ⍝ allow 'ureset' to force reset
          CMDDIR←{0∊⎕NC'CMDDIR':⍵ ⋄ CMDDIR}0
          t←⎕SI∊⍨⊂'GetUCMDList'     ⍝ is this a recursive call thru ⎕FIX?
      :OrIf t<CMDDIR≢⎕SE.SALT.Settings'cmddir'  ⍝ has the Spice folder changed?
          (1+reset/stop↑⎕LC)⎕STOP 1⊃⎕SI
          ResetUCMDcache-reset      ⍝ force reset
          setAutocomplete List←⎕SE.Dyalog.SALT.List
          ⎕SE.input.R←(⍕1↑⍴List),' commands reloaded'
          →reset⍴LAYOUT
          ⎕SE.input.R←0
      :EndIf
     
      List←⎕SE.input.List←⎕SE.Dyalog.SALT.List
     
      helpfor←{
          ⎕ML←1
          0∊⍴⍵:'No files found for "',⍺,'"'
          c←{⍵[AZaz⍋⍕⍵[;1 2];]}⍵[;cGroup cName cDesc]
          c[;1]←uCase c[;1]
     ⍝c⍪⍨←'Group' 'Name' 'Description',[0.5]¨'─'
     ⍝∘∘∘⎕SE.SALT.SALTFOLDER,'spice/UcmdGroups -nolink -noname'
          groupInfo←⎕CSV(⎕SE.SALT.Load ⎕SE.SALT.SALTFOLDER,'spice/UcmdGroups.csv -source')'N'
          Head←groupInfo∘{l←⊃⊃⍵ ⋄ '' ''⍪((,∘':'¨@2⍤1⊢⍺)⍪(l,':')'')[⍺[;1]⍳⊂l;]⍪↑' ',¨@1¨1↓¨⍵}
          c←⊃⍪⌿Head¨(1,2≢/c[;1])⊂↓c
     ⍝c[1+Where 2≡/c[;1];1]←⊂'' ⍝ blank out all but 1st group names
          c←,CR,⍨⍕c
          c,←CR,']            ⍝ for general user command help'
          c,←CR,']grp -?      ⍝ for info on the "GRP" group'
          c,←CR,']grp.cmd -?  ⍝ for info on the "Cmd" command of the "GRP" group'
          c
      }
     
⍝ One line help
      details←0
      :If help←'?'=1↑⎕SE.input.com←cmd ⍝ ]??cmd
          ASN←1 ⍝ short names allowed for help since autocomplete does not work when using the old ]? syntax
          ⎕SE.input.R←displayNames ⎕SE.input.arg List
          →LAYOUT⍴⍨0≢⎕SE.input.R
          details←¯1+'?'+.=⎕SE.input.com
          ⎕SE.input.com←lCase 1⊃⎕SE.input.arg splitOn' ' ⍝ the 1st word after '?' is the command to get help on
      :ElseIf help←×details←≢∊'"[^"]*"' '''[^'']*''' '(^|\s)-(\?+)(\s|$)'⎕S'' '' '\2'⊢⎕SE.input.arg ⍝ ]cmd -??
          ⎕SE.input.R←displayNames ⎕SE.input.arg List
          →LAYOUT⍴⍨0≢⎕SE.input.R
          details-←1
          ⎕SE.input.com←lCase ⎕SE.input.com
      :EndIf
      :If help
     
          triedRefresh←0
     Disambiguate:
          :If '.'∊⎕SE.input.com
              full←(uCase List[;cGroup]),¨'.',¨List[;cName]
              all←List[;cGroup],¨'.',¨List[;cLname]
              before after←⎕SE.input.com splitOn1st'.'
              :If '*'∊⎕SE.input.com
                  leading←(⍳≢all)∊all limRegexFind ⎕SE.input.com
                  anywhere←(⍳≢all)∊all limRegexFind'*',⎕SE.input.com
              :Else
                  leading←before∘(1⊃⍷)¨List[;cGroup]
                  leading∧←after∘(1⊃⍷)¨List[;cLname]
                  anywhere←before∘(∨/⍷)¨List[;cGroup]
                  anywhere∧←after∘(∨/⍷)¨List[;cLname]
              :EndIf
          :Else
              full←(uCase List[;cGroup]),¨'.',¨List[;cName]
              full,←uCase∪List[;cGroup]
              all←List[;cLname],∪List[;cGroup]
              :If '*'∊⎕SE.input.com
                  leading←(⍳≢all)∊all limRegexFind ⎕SE.input.com
                  anywhere←(⍳≢all)∊all limRegexFind'*',⎕SE.input.com
              :Else
                  leading←⎕SE.input.com∘(1⊃⍷)¨all
                  anywhere←⎕SE.input.com∘(∨/⍷)¨all
              :EndIf
          :EndIf
          exact←⎕SE.input.com∘≡¨all
          cands←full/⍨1⊃0,⍨{⍵/⍨∨/¨⍵}exact leading anywhere
          :Select ≢cands
          :Case 0
              :If triedRefresh
                  triedRefresh←0
              :ElseIf 'auto'≡⎕SE.SALT.Settings'newcmd'
                  triedRefresh←1
                  ResetUCMDcache 0      ⍝ force reset
                  setAutocomplete List←⎕SE.Dyalog.SALT.List
                  →Disambiguate
              :EndIf
     
              ⎕SE.input.R←⊂'No commands or groups match ]',⎕SE.input.com
              ⎕SE.input.R,←⊂''
              ⎕SE.input.R,←⊂']            ⍝ for general user command help'
              ⎕SE.input.R,←⊂'] -?         ⍝ for list of available user commands'
              ⎕SE.input.R,←⊂'] -??        ⍝ for brief info on each command'
              ⎕SE.input.R,←⊂']grp -?      ⍝ for info on the "GRP" group'
              ⎕SE.input.R,←⊂']grp.cmd -?  ⍝ for info on the "Cmd" command of the "GRP" group'
              →LAYOUT
          :Case 1
              ⎕SE.input.com←lCase 1⊃cands
          :Else
              ⎕SE.input.R←⊂']',⎕SE.input.com,' could be one of:'
              ⎕SE.input.R,←⊂''
              ⎕SE.input.R,←'      ]'∘,¨cands
              →LAYOUT
          :EndSelect
     
         ⍝ Is this a group?
          :If ~0∊⍴i←Where(⎕SE.input.com~'?*')∘(1⊃⍷)¨List[;cGroup]
              ⎕SE.input.R←helpfor List[i;]
              →LAYOUT
          :EndIf
      :EndIf
     
⍝ We need to bring in the command if it is unknown and AUTOmatic search is ON
      :If ⍬≡i←findCmdPos ⎕SE.input.com    ⍝ look for 1 name; if not found
      :AndIf ⍱/'*?'∊⎕SE.input.com         ⍝ and no filter used
      :AndIf 'auto'≡⎕SE.SALT.Settings'newcmd'
          ResetUCMDcache 0
          setAutocomplete List←⎕SE.Dyalog.SALT.List
          i←findCmdPos ⎕SE.input.com ⍝ try again
      :EndIf
     
⍝ If the command is still not found and help is wanted we look into groups and similar names
      :If 1≠≢i
          :If 'version'≡⎕SE.input.com
              ⍞←'* Assuming "TOOLS.Version"; to see a list of all valid user commands that start with "',⎕SE.input.com,'", type ',CR,'      ]',⎕SE.input.com,'* -?',2⍴CR
              i←findCmdPos'tools.version'
          :Else
              :If help∧0∊⍴i
                  t←{⍺,'.',⍵}/List[;cLname,⍨(dot←'.'∊⎕SE.input.com)/cGroup]
              :AndIf 0∊⍴i←t limRegexFind ⎕SE.input.com ⍝ look into commands
              :AndIf ~dot ⍝ group name?
                  i←List[;cGroup]limRegexFind ⎕SE.input.com       ⍝ look into groups
              :EndIf
     
              :If 0∊⍴i ⍝ not found; has it been renamed?
              :AndIf 0<⍴i←NewNames[;1]{b⍳⍳1=+/b←(⊂⍵)∊⍨(⍴⍵)↑¨⍺}⎕SE.input.com
                  ⎕SE.input.R←BS,'* Command ',⊃{⍺,' has been renamed ',⍵}/,NewNames[i;]
                  →LAYOUT
              :EndIf
     
              :If 1<t←⍴i
              :OrIf 1<t←⍴i←Where((⍴⎕SE.input.com)↑¨List[;cGroup])∊⊂⎕SE.input.com
                  ⎕SE.input.R←BS,'* Ambiguous user command; to see a list of all valid user commands that start with "',⎕SE.input.com,'", type ',CR,'      ]',⎕SE.input.com,'* -?'
                  →LAYOUT
              :ElseIf 0∊t
                  ⎕SE.input.R←BS,'* Invalid user command; to see a list of all user commands type',CR,'      ] -?'
                  →LAYOUT
              :EndIf
          :EndIf
      :EndIf
     
      :If help ⍝ Special case '?'
          :If 1<⍴,i
              ⎕SE.input.R←helpfor List[,i;] ⋄ →0
          :EndIf
     
          :Trap DEBUG↓0
              name←cName⊃,List[i;] ⍝ make sure we have the name in case it errors
            ⍝ If parsing rules are given display them here
              syntax←''
              :If ''≢rules←splitRule cParse⊃,List[i;]
                  (nargs switches)←rules
                  syntax←CR,'Syntax: ',{''≡⍵:⍵ ⋄ a,←' argument',(1<n←⌈/2⊃'-'⎕VFI a←⍵~sl←'sSlL')/'s'
                      l←¯2⌽((1+n=1)⊃'last' 'all'),' arguments merged) ('
                      ∊'up to 'a l' '/⍨∊1,¨⍨∨/2 2⍴sl∊⍵}nargs
                  syntax,←CR{(0∊⍴⍵)↓⍺,⍵}describeSwitches switches
              :EndIf
              c←cFullName⊃,List[i;] ⋄ cs←⎕SE.input.⎕NS''             ⍝ only used to define space in it
              ⎕SE.input.R←BS,⎕SE.input.spc←⎕SE.SALT.Load'"',c,'" -target=cs'   ⍝ grab the cmd space, define in cs, keep ref to it
              →0/⍨326≠⎕DR ⎕SE.input.spc
              cs.Group←cGroup⊃,List[i;]
     
              :Trap 0 ⍝ can we put a stop on line 1 of the help fn?
                  (⍳stop)⎕SE.input.spc.⎕STOP'Help'
              :Else
                  (stop/HelpStop)⎕STOP ⎕IO⊃⎕SI
              :EndTrap
     HelpStop: ⍝ Stop here when stop requested for Help with Classes. Now TRACE into the next lines.
              :Trap 2  ⍝ try the detailed syntax
                  ⎕SE.input.com←details ⎕SE.input.spc.Help name
              :Else    ⍝ OK, the "old" way then
                  ⎕SE.input.com←⎕SE.input.spc.Help name
              :EndTrap
             ⍝ The user may have decided to return a VTV instead of a char string, or maybe a char matrix
              name←(uCase cGroup⊃,List[i;]),'.',name ⍝ include the group name
              ⎕SE.input.com←{(0∊⍴⍵)∨326≠⎕DR ⍵:,CR,⍵ ⋄ ↑,/CR,¨⍵}⎕SE.input.com
              ⎕SE.input.com←{⌽⍵↓⍨0⌊1-⊥⍨CR=⍵}⍣2⊢⎕SE.input.com,CR ⍝ ensure exactly one leading and trailing CR
              :If DEBUG>0
                  syntax,⍨←↑'\$.*?(\d+).*\$'⎕S'\1\r'↑⌽⎕SRC ⎕SE.input.spc            ⍝ revision
                  syntax,⍨←'Version: ',{0=≢⍵:'(none found)' ⋄ ↑⍵}'V *(\d+\.\d+)'⎕S'\1'⍠1↑⎕SRC ⎕SE.input.spc ⍝ version
                  syntax,⍨←'Source: ',c,'.dyalog',CR
                  ⎕SE.input.com←syntax,CR,⎕SE.input.com ⍝ revision number
              :EndIf
              ⎕SE.input.com←(≢CR)↓(∊CR∘,¨Header']',name),CR,⎕SE.input.com
              ⎕SE.input.R←⎕SE.input.com
          :Else
              ⎕SE.input.R←BS,'* Unable to produce Help for command ',name,':',{('⍎'=1↑⍵)↓⍵}⎕IO⊃⎕DM
          :EndTrap
          →LAYOUT
      :Else
          :Trap DEBUG↓⎕SE.input.mon←0
⍝ We need to know the calling space. If we were called by <UCMD> this is in 'THIS'
              :If t←'⎕SE.UCMD'≡3⊃⎕XSI,0 ⍝ called by ⎕SE.UCMD?
              :AndIf 9=⎕NC'⎕SE.THIS'
                  cs←⎕SE.THIS ⍝ use what we know
              :Else
                  cs←RSI 1+t                          ⍝ could be a user call
              :EndIf
              c←⍎'c'⎕SE.input.⎕NS'' ⍝ we need a NAMED ns to get a full pathname
⍝ If we are debugging we use the object in the ws instead if possible
              :If DEBUG>0
              :AndIf 9=cs.⎕NC t←(⎕SE.input.com←cObjName⊃,List[i;]),'.SALT_Data'
              :AndIf List[⍬⍴i;cFullName]≡⍬⍴splitName(cs⍎t).SourceFile
                  ⎕SE.input.spc←cs⍎⎕SE.input.com ⋄ ⎕←1⌽'"* Debugging workspace object "',⎕SE.input.com
                  ⎕SE.input.spc.##.THIS←cs ⍝ THIS must be defined for some cmds
              :Else
                  ⎕SE.input.R←BS,⎕SE.input.spc←0 c ⎕SE.SALT.Load t←'"',(cFullName⊃,List[i;]),SALTEXT,'"'
                  →0/⍨326≠⎕DR ⎕SE.input.spc ⍝ return msg if it failed
              :EndIf
              cmd←,⎕SE.input.spc.List
              →0/⍨0=≢' ' 0~⍨∊cmd
              :If 1<+/t←(,¨cmd.Name)∊⊂⎕SE.input.com←cName⊃,List[i;] ⍝ more than 1 cmd with same name?
                  t←t∧(lCase cmd.Group)∊⊂cGroup⊃,List[i;] ⍝ then use the group
              :EndIf
              :If ''≢rules←⌽splitRule cmd[t⍳1].Parse
⍝ We have to prepare the parser for the number of arguments
                  (2⊃rules){(0<⍴⍺)/⍵,⍺}←'nargs='
                  ⎕SE.input.arg←(⎕NEW ⎕SE.Parser rules).Parse ⎕SE.input.arg
              :EndIf
     
              :If ⎕SE.input.mon←⎕SE.input.com≢'UMonitor'
              :AndIf ⎕SE.input.mon←(9.1=⎕NC⊂'⎕SE.input.spc')∧(MONITOR>0)∧0<⍴⎕SE.input.names←⎕SE.input.spc.⎕NL-4.1 3.1
                  (¯1+⍳999)∘⎕SE.input.spc.⎕MONITOR¨⎕SE.input.names ⋄ ⎕SE.input.mon←¯1
              :EndIf
              c.THIS←cs   ⍝ ensure we have a reference to the calling environment
              c.RIU←⍬⍴⎕SE.input.rgn ⍝ and let know if the result is used
              c.SourceFile←cFullName⊃,List[i;]
              c.Group←cGroup⊃,List[i;]
              c.WIN←WIN
              c.DMX←c.⎕JSON⍣2⊢DMX
     
             ⍝ Create a program to call the user's code
     
             ⍝ Run the code, cover non result case.
             ⍝ Note that this uses a special feature of Dyalog which may not be there in a future release.
             ⍝ Should you choose to use it you should put it in a cover function in case it is decommissioned.
     
             ⍝ The following does the actual call to the user code.
             ⍝ It runs the <Run> function passing as arguments the command to run and
             ⍝ either the text that followed the command on the ]command line OR
             ⍝ a namespace containing the arguments and the switches.
             ⍝ For example, the command line
             ⍝   ]mycmd  arg1 a2 -swx  -sw2=abc
             ⍝ would generate com←'mycmd' and arg←' arg1 a2 -swx  -sw2=abc'
             ⍝  OR, if the parsing rules are in effect:
             ⍝ arg←⎕NS '' ⋄ arg.Arguments←'arg1' 'a2' ⋄ arg.swx←1 ⋄ arg.sw2←'abc'
              ⎕SE.SALTUtils.CallUserCode←{0∩DEBUG::TrapUCMD ⋄ 85::⎕SE.input.hasR←0 ⋄ ⎕SE.input.R←0 ⎕SE.input.(85⌶)'spc.Run com arg'}
              ⍬ ⎕SE.⎕STOP'UCMD' ⍝ reset any leftover stop
             ⍝ Is a stop requested before executing the code?
              :If stop
                  :Trap 0 ⍝ can we put a stop on line 1 of the user fn?
                      2 ⎕SE.input.spc.⎕STOP'Run'
                  :Else   ⍝ no, must be a fn in a class, let's stop before stepping into it instead
                      2 ⎕STOP'⎕SE.UCMD'
                  :EndTrap
              :EndIf
     
          :Else
              TrapUCMD
              →LAYOUT
          :EndTrap
      :EndIf
      →0
     LAYOUT:
      CallUserCode←{} ⍝ Nothing needs to be run here: make silent no-op
      ⎕SE.input.finished←0
    ∇

    ∇ PostUCMD;BS;name
      :If ~⎕SE.input.hasR
          ⎕SE.input.R←0 0⍴0
      :EndIf
      :If ⎕SE.input.finished
          :If (0≠⎕SE.input.mon)∧⎕SE.input.com≢'UMonitor'
              :Trap DEBUG↓⎕SE.input.mon←0
                  i←(0<+/∘,¨0 1∘↓¨i)/(spc.⎕CR¨⎕SE.input.names){⍺ ⍵}¨i←spc.⎕MONITOR¨⎕SE.input.names
                  ⍎name,'←i',(2=⎕NC name)/' MergeMD ',name←MONITORNAME ⍝ set or add data
              :Else
                  TrapUCMD
              :EndTrap
          :EndIf
      :ElseIf ~⎕SE.input.rgn
          ⎕SE.input.R←⊃⎕SE.Dyalog.Utils.layoutText ⎕SE.input.R
      :EndIf
     
      ⎕SIGNAL 0                                                        ⍝ reset ⎕DM
      BS←⎕UCS 8
      :If (0 2∊⍨10|⎕DR ⎕SE.input.R)∧1∊⍴⍴⎕SE.input.R
      :AndIf (2↑⎕SE.input.R)≡BS,'*'                                    ⍝ error signature
          ⎕SE.input.R~←BS
          ⎕SE.input.R ⎕SIGNAL ⎕SE.input.dcl↓911 ⋄ ⎕←⎕SE.input.R ⋄ →0   ⍝ signal error only if called by a program
      :EndIf
     
      :If ~(1=≢⎕SE.input.nma)∨~⎕SE.input.hasR                              ⍝ ]←cmd    discard result or nothing to display
          :If 0∊⍴⎕SE.input.nma ⋄ ⎕SE.r←⎕SE.input.R                         ⍝ no '←'   return result by this fn
          :ElseIf ~⎕SE.input.notQ ⋄ {⎕←⌽rlb⌽⍵}¨↓⎕FMT ⎕SE.input.R           ⍝ ]⎕←      display line by line
          :Else ⋄ {⎕SE.THIS⍎⎕SE.input.nma,'⍵'}⎕SE.input.R                  ⍝ ]xx←cmd  store result in xx in calling namespace
          :EndIf
      :EndIf
      ⎕SE.input.⎕EX'c.THIS' 'R'              ⍝ Avoid leaving a reference from ⎕SE.input.c.THIS → # (cannot clear workspace)
      ⎕SE.SALTUtils.keepinput←⎕SE.input      ⍝ ChartWizard was instantiated as a child of input.c
      ⎕SIGNAL 0                                                        ⍝ reset ⎕DM
    ∇

    ∇ TrapUCMD;dmxDF
      ⎕SIGNAL 0/⍨999<⎕DMX.EN ⍝ erase interrupt info
      dmx←⎕DMX
      dmxDF←⍕⎕DMX
      :Trap 0
          dmx←⎕JSON⍣2⊢dmx
      :Else
          ⎕SIGNAL 0
          dmx←⎕JSON⍣2⊢dmx
      :EndTrap
      dmx.⎕DF dmxDF
      ⍝⎕SIGNAL 0                                                        ⍝ reset ⎕DM
      ⍝⎕DMX.(⎕EX ⎕NL ¯2)
      ⍝{names←⍕'('(⍵.⎕NL ¯2)')' ⋄ ⍎'⎕DMX.',names,'←⍵.',names}dmx
      ⎕SE.input.R←BS,'* Command Execution Failed: ',⎕SE.input.mon{⍺=1:'Cannot monitor classes' ⋄ ('⍎'=1↑⍵)↓⍵}dmx.(OSError{⍵,2⌽(×≢⊃⍬⍴2⌽⍺,⊂'')/'") ("',⊃⍬⍴2⌽⊆⍺}Message{⍵,⍺,⍨': '/⍨×≢⍺}⊃⍬⍴DM,⊂'')
      MONITOR∧←⎕SE.input.mon≠1 ⍝ turn it off to prevent further problems
    ∇

      MergeMD←{0∊⍴ra←⍵:⍺ ⋄ ∧/keep←~merge←⊃∊/(new old)←1⊃¨¨⍺ ⍵:⍵,⍺ ⍝ all new
          ra[2,⍨¨old⍳merge/new]+←0,¨0 1∘↓¨2⊃¨merge/⍺ ⋄ ra,keep/⍺
      }

    ∇ setAutocomplete list;ev
      →V14↓0
      ev←(uCase list[;1]){⍺,'.',⍵}¨list[;3]
      :Trap 11 ⍝ just in case this Ibeam is not defined
          {}2350⌶']',¨ev,list[;3]{⍺/⍨∨/m/⍨1=+⌿m←⍵∘.≡∪⍵}list[;2]
      :EndTrap
     
    ∇

    ∇ str←default VerifyNEstring str;ok
     ⍝ Verify that the string is not empty
      ok←{⍱/0 2∊10|⎕DR ⍵:0 ⋄ 1≢≡⍵:0 ⋄ ~0∊⍴⍵}str←default{⍵,(0∊⍴⍵)/⍺}str~' '
      'Name and Group must be a non empty character string'⎕SIGNAL ok↓11
     ⍝ This line needed for CC
    ∇

    ∇ (cmddir list)←{tell}GetUCMDList names;folder;nc;ns;show1;t;b;gn;cn;files
    ⍝ Retrieve the list of all Spice commands
      :If show1←326∊⎕DR names
          folder←1↑(cmddir names)←names
      :Else
          folder←ClassFolder∘''¨(cmddir←⎕SE.SALT.Settings'cmddir')splitOn PATHDEL
      :EndIf
      t←↑⍪/⎕SE.SALT.List¨'"',¨folder,¨⊂FS,names,'" -rec -raw -full=2'
      files←∪(0=,⊃⍴¨t[;1])/t[;2]
      :If ~show1
          files∪←(BootPath'spice',FS)∘,¨'Spice' 'SaltInSpice' 'NewCmd'  ⍝ always there
      :EndIf
      list←⍬
      :If 0=⎕NC'tell'
          tell←0
      :EndIf
⍝ Spice keeps track of the commands in the Spice folder
      :For t :In files
          (⎕ML ⎕IO)←3 1
          :Trap DEBUG↓0
              ns←⎕SE.SALT.Load'"',t,'.dyalog" -noname -nolink'
              :If 9=⎕NC'ns'
              :AndIf 3=⌊|ns.⎕NC⊂'List'
              :AndIf ~0∊⍴nc←ns.List
                  nc←{⍵⊣⍵.(Name Group)←'' 'NONE'VerifyNEstring¨2↑⍵.(Name Group Desc Parse)←,¨⍵.(Name Group Desc Parse)}¨,nc
                  nc.ObjName←⊂{⍵↑⍨-⊥⍨'.'≠⍵}⍕ns
                  nc.FullName←⊂t
                  nc.Name←~∘'() '¨cn←nc.Name
                  nc.MinLen←{(b⍳1)×1∊b←'('=⍵}¨cn
                  list,←nc
              :EndIf
          :Else
              ⍞←CR,CR,⍨'* Error loading a User Command from ',t,': ',⎕IO⊃⎕DM
          :EndTrap
      :EndFor
      →(⍴list)↓0
      (⎕ML ⎕IO)←3 1
    ⍝ Remove duplicates, if any. Groups are important.
      list←(b←(⍳⍴t)=t⍳t←{⍺,'.',⍵}/gn←lCase⊃list.(Group Name))/list ⋄ t←b/t ⋄ gn←b⌿gn
    ⍝ At this point all we have is unique group/names. We now try to find the unique names
      list←gn,⊃list.(Name Desc Parse ObjName FullName MinLen) ⍝ get rid of namespaces
      list[;8]←list[;8]findMinLen gn
    ∇

    ∇ ml←ml findMinLen list;i;b;U;grp;nam;nu
    ⍝ Find the minimum length required to enter a command.
    ⍝ Start with the unique names
      U←∨/b/⍨1=+⌿b←nam∘.≡∪nam←list[;2] ⋄ i←1
      ml←ml-999×0=ml
      :Repeat
          b←({∨/U/⍨1=+⌿U←⍵∘.≡∪⍵}i↑¨U/nam)∨i=U/ml
          (b/U/ml)⌈←-i ⋄ i+←1
      :Until ∧/b
     ⍝ This line needed for CC
    ∇

⍝           THE UCMD fn

    ∇ r←{THIS}UCMD input           ⍝ User Command Processor
      ⎕SE.SALTUtils.PreUCMD        ⍝ no need to trace into this line
      ⎕SE.SALTUtils.CallUserCode ⍬ ⍝ trace into this line to debug user command
      ⎕SE.SALTUtils.PostUCMD       ⍝ no need to trace into this line
    ∇

    :endsection

    :section Boot
⍝ =========================   Boot   fns   =========================

    ∇ {cd}←BootSpice
    ⍝ Reset UCMD cache
      :If ~0∊⍴cd←ResetUCMDcache 1
          '⎕SE'⎕NS'UCMD'
          :If '⎕SE.StartupSession'≢⊃⊢/⎕XSI
              USetup'init' 0
          :EndIf
      :EndIf
    ∇

    ∇ {r}←USetup arg;ns;fn;exist;do;on;cb;paths;list;DEL;Folder;Arguments;info;⎕ML
      ⎕ML←1
      arg←⊆⍣(~2|⎕DR arg)⊢arg
      (Arguments info)←2↑arg,(≢arg)↓'' 0
      r←0 0⍴''
      DEL←1⊃PATHDEL
      Folder←'MyUCMDs'
     ⍝ Run system setup
      :If Arguments≡,⊃'init'
          :If 0≠⎕NC do←'⎕SE.Dyalog.Out'
             ⍝ Reinstate ]box if present
              cb←do,'.Filter'   ⍝ callbacks
              on←(⊂'on')∊(⍎do).(B R F L).state             ⍝ any active?
              '⎕se'⎕WS'Event' 'SessionPrint'(↑on↓0 cb)
             ⍝ Restore last result PFkey if it was set. Note this may be overridden below.
              :If 0≠⎕NC do←do,'.L.PFKey'
              :AndIf 0≠on←⍎do
                  {}⎕SE.SALTUtils.LastResultVarName ⎕PFKEY on
              :EndIf
          :EndIf
      :EndIf
     ⍝ Run user setup
     ⍝ We check 2 places (Unix oblige)
      paths←WIN↓'.dyalog/' ''
      paths,¨⍨←⊂DEL,USERDIR
      paths,¨←⊂Folder,'/'
      paths←∊paths
      paths,←DEL,⎕SE.SALT.Settings'workdir'
      paths(≠⊆⊣)←DEL
      paths←FixSlashes paths
      paths{⍺,⍵~⊃⌽⍺}¨←FS
      paths,¨←⊂'setup.dyalog'
      exist←⎕NEXISTS¨paths
      list←paths,[1.5]exist
      :If 1≡info
          list⍪←(⊃paths)0
          r←list[exist⍳1;]
      :ElseIf 'list'≡info
          r←list ⍝ if info requested return the filename followed by if it exists
      :ElseIf ∨/exist
          ns←fn←⎕SE.SALT.Load'-noname "',(⊃exist/paths),'"'
          :If 2=⎕NC'ns'
              ns←⎕NS'' ⋄ ns.⎕FX fn
          :EndIf
          ns.{85:: ⋄ x←'Setup',(0≠1 2⊃⎕AT'Setup')/' ⍵' ⋄ 2::1(85⌶)x ⋄ 85⌶x}⊃Arguments
      :EndIf
    ∇

    ∇ {cd}←ResetUCMDcache arg;tell;force;ev;t;uf;fol;tie;set;list;st;cf;fe;doit;problem
     ⍝ Reset the UCMD cache. tell=0: quiet, <0: force reset
     ⍝ We now add the necessary elements to make this work (Parser and Utils should be there already)
      '⎕SE.Dyalog.SALT'⎕NS cd←''
     ⍝ 2014/4/8   a new procedure is established to reduce startup time
      fol←0/cf←getEnvir'UCMDCACHEFILE'
      →0/⍨(⊂cf)∊'skip' 'SKIP' ⍝ do NOT remove this test without checking allos/bin/copyws
      :If WIN
          ev←' ',⍨'-64'{⍺/⍨∨/⍺∊⍵}1⊃t←APLV
          fol←⎕SE.SALTUtils.USERDIR,'Dyalog APL',ev,({⍵/⍨2>+\'.'=⍵}2⊃t),((80=⎕DR'')/' Unicode'),' Files'
          fol←FS,⍨{0::⍵ ⋄ 2⊃4070⌶⍬}fol ⍝ is the folder already defined internally?
      :Else
         ⍝ Ensure folder is there
          :If 0∊⍴cf ⍝ create it only if the env var is NOT specified
              :Trap 2
                  fol←'/.dyalog/',⍨getEnvir'HOME'
                  3 ⎕MKDIR fol
              :Else
                  fol←'/',⍨,⊃⎕SH'mkdir -p ~/.dyalog && echo ~/.dyalog'
              :EndTrap
          :EndIf
      :EndIf
      force←arg<0 ⋄ tell←|arg
      set←{⎕ML←1 ⋄ 1↓¨(⍵∊PATHDEL)⊂⍵}PATHDEL[1],CMDDIR←⎕SE.SALT.Settings'cmddir'
     ⍝ Running under root we won't have a HOME env var and no spice folder
      list←{⎕SE.SALT.List'"',⍵,'" -raw -full=2 -recursive'}¨set
      uf←cf,(0∊⍴cf)/fol,UCMDCACHEFILE
      fe←{0::0 ⋄ 1⊣⎕FUNTIE(1 3⍴0 ¯1)⎕FSTAC ⍵ ⎕FCREATE 0}uf  ⍝ create the file if not there
      doit←1 ⋄ problem←1 ⋄ tie←0
      :Trap 0 ⍝ the creation may have failed, e.g. because the folder did not exist
          tie←uf ⎕FSTIE 0                         ⍝ share tie it
          {⍵<3:tie ⎕FAPPEND¨⍨⍳3-⍵}2⌷⎕FSIZE tie    ⍝ ensure 2 components
         ⍝ Compare what we have in the cache file to the UCMDs' folder structure
          :If ~force
              doit←list≢⎕FREAD tie,1              ⍝ if they don't agree we'll rebuild the list
          :EndIf
          problem←0
      :EndTrap
      :Trap DEBUG↓0
          tell←tell>problem
          :If doit
              st←⎕AI[2]
              showDone←0
              WaitAndShowMsg←{
                  ⍞←⍺/CR,'Rebuilding user command cache... '⊣⎕DL 1 ⋄ showDone⊢←1
              }
              showMsgThread←tell WaitAndShowMsg&⍣(~'1'∊getEnvir'DYALOGQUIETUCMDBUILD')⊢⍬ ⍝ seconds until msg
     
          ⍝ Rebuild the cache/list
              (CMDDIR t)←1 GetUCMDList'*'
         ⍝ Update the file
              :If ~problem
                  t list ⎕FREPLACE¨tie,¨2 1
              :EndIf
              ⎕SE.Dyalog.SALT.List←t
     
              ⎕TKILL showMsgThread
              :If showDone∨DEBUG>0
                  ⍞←tell/'done',((DEBUG>0)/' in ',(⍕⎕AI[2]-st),' msecs'),CR
              :EndIf
     
          :ElseIf ~problem
              ⎕SE.Dyalog.SALT.List←⎕FREAD tie 2
          :ElseIf 0=⎕NC'⎕SE.Dyalog.SALT.List'
              ⎕SE.Dyalog.SALT.List←0 10⍴0
          :EndIf
      :Else
          ⍞←CR,'* Error building user command cache:',CR,⍨⊃,/CR,¨⎕DM
      :EndTrap
      ⎕FUNTIE tie
     
      cd←CMDDIR ⍝ return this value to caller
      setAutocomplete ⎕SE.Dyalog.SALT.List
      :If problem
          ⍞←CR,⍨CR,'* Unable to rebuild user command cache',(~fe)/': the path of ',uf,' does not exist'
      :EndIf
    ∇

    BootPath←{(p↓⍨-'/\'∊⍨¯1↑p←getEnvir'SALT'),FS,⍵}

    ∇ BootSALT;bl;files
⍝ Bring in all necessary code to run SALT if enabled
      '⎕se.Dyalog'⎕NS''               ⍝ make sure this one is there
      bl←BootPath''
      ⍝ bl BootLib'Dyalog.Utils'   - now brought in by ⎕SE.StartupSession from qSE
      bl BootLib'Parser'
      bl BootLib'UnicodeFile'         ⍝ unused by SALT itself but used by other code
      bl BootLib'SALTUtils'
      bl BootLib'SALT'
      ⎕SE.Dyalog.SEEd←⎕SE.⎕WG'Editor'
      ⎕SE.Dyalog.SEEd.⎕WX←3           ⍝ use this to store the callbacks
      ⎕SE.SALTUtils.EditorFix'Start'  ⍝ set callback in the NEWly defined ns
      ⎕SE.⎕FX ⎕CR'UCMD'               ⍝ define <UCMD> fn
     
      ⎕EX'⎕se.Dyalog.SALT.List'       ⍝ ensure UCMDs cache location empty
     
     ⍝ We don't initialize the UCMD list if we're starting and this is not a Windows version
      ⎕SE.SALTUtils.CMDDIR←BootSpice
     
⍝ Check for autostart (dyapp= on command line)
      :If 0≠⍴bl←getEnvir'DYAPP'
          ⎕←'Booting ',bl
          ⎕SE.SALT.Boot{Q,⍵,Q←1↑'"'''~⍵}bl
      :EndIf
      {0:: ⋄ ⎕SIGNAL 0}''       ⍝ reset ⎕DM
    ∇

    splitOnNL←{(13 GetUnicodeFile ⍵ ) splitOn ⎕ucs 10}

    ∇ loc BootLib target;file;name;t;tgt
⍝ Bring in a single Unicode file
      file←loc,'core',(¯1↑loc),target{⍵,⍨(-⊥⍨'.'≠⍺)↑⍺}'.dyalog'
      t←splitOnNL file
⍝ The name of the object produced MUST match the target name:
      (tgt name)←'.'splitLast target
      tgt←⎕SE⍎tgt,(0∊⍴tgt)/'##'
      {}÷target≡4↓⍕name←tgt.⎕FIX(⍠'InjectReferences' 'All')t
      name.SALT_Data←⎕SE.⎕NS''
      name.SALT_Data.(SourceFile LastWriteTime Version)←file'(unavailable)' 0
    ∇
    :endsection

    :section Editor
⍝ =====================   EDITOR fns et al  =========================

    ConfirmEdit←1 ⍝ default, reset by <Settings>

    DF←{(⍵.⎕DF df){⍵}⍕⍵{⍺}df←⍵.⎕DF ⎕NULL}    ⍝ cover non-standard ⎕DF

    ∇ {r}←{bypasschk}EditorFix args;⎕TRAP;link;files;df;file;fixed;i;id;name;nc;ns;nss;r;sd;ss;t;target;⍙;obj;src;em;error;cap;reason;text;btns;resp;export;filename;linked;fsw;old;NoSALT;debug
      :Access Shared Private
    ⍝ Callback fn for the editor
      :If 0=⎕NC'DEBUG'
          DEBUG←0
      :EndIf
      debug←DEBUG
      :If ×⎕NC'⎕SE.Link.DEBUG'
          debug⌈←⎕SE.Link.DEBUG
      :EndIf
      :Trap (~×debug)/0,1001+⍳10 ⍝ all but explicitly set stop bits
          r←⍬⊤⍬ ⍝ neutral return value; let editor do its thing
          :If ~{6::⍵ ⋄ bypasschk}0
              NoSALT←0/⍨∨/'0nN'∊getEnvir'SALT\AddSALT' ⍝ has SALT been disabled?
          :EndIf
          :If 1≡≡args
              args←0 args   ⍝ pad to get min 2
          :EndIf
     
          :If debug>1
              ⎕←{6::⍵ ⋄ (⊂t[2].SourceFile),t←⎕SE.Dyalog.⍙}'No ⍙'
          :EndIf
     
          :Select t←2⊃args
     
          :Case 'Fix' ⍝ editor callback: [3] source, [4] ns, [5] original name, [6] new name (or same)
     
              →r←debug Hook t ⍝ return 0 to force stay in Editor
     
              :If 3=⎕NC'⎕SE.Link.OnFix'
                  →r←0/⍨~⎕SE.Link.OnFix args ⍝ 0: stop and keep editor open; 1: proceed as normal
              :EndIf
     
              →NoSALT
⍝ When the editor exits we grab its SALT data for the AfterFix event
⍝ and we store it in ⎕se.Dyalog along with source ID
⍝ We can edit something IN a class.
⍝ In that case the class will be reported as being modified.
     
              nss←⍴¨ss←⊂'⍝SALTSource="'
              (target name)←args[4 5]
              :If ∨/3 4∊nc←⌊|target.⎕NC⊂name⊣id←(i←DF target),'.',name
                  :If ~0∊⍴t←fnData args[3 5]            ⍝ SALTed fn?
                      ⎕SE.Dyalog.⍙←id t(target.⎕STOP name)
                      →0
                  :EndIf
             ⍝ If it's not SALTed maybe its parent is
                  nc←9 ⋄ name←i ⋄ target←target.##
              :EndIf
              :If 2∊nc
                  →0/⍨0∊⍴t←varData⊂target name          ⍝ SALTed var?
                  ⎕SE.Dyalog.⍙←id t 0
              :ElseIf nc=9   ⍝ did we edit something IN a SALTed class?
                  :If 9=target.⎕NC ns←name,'.SALT_Data' ⍝ NS which has a SALT_Data
                  :AndIf ≡/args[5 6]                    ⍝ same name?
                      t←target.⎕OR ns                   ⍝ grab a copy
                      df←⍕target⍎name                   ⍝ and its display form
                      ⎕SE.Dyalog.⍙←id(⎕NS t)df          ⍝ being careful not to keep the original
                  :ElseIf (⍴t)≥i←(nss↑¨t←{0::⍬ ⋄ ⎕SRC target⍎⍵}name)⍳ss
                      ⍙←⎕NS''
                      ⍙.SourceFile←{(¯1+⍵⍳'"')↑⍵}{(⍵⍳'"')↓⍵}i⊃t
                      ⍙.Version←0
                      ⍙.LastWriteTime←⍕lastWrTime ⍙.SourceFile
                      ⍙.GlobalName←''
                      ⎕SE.Dyalog.⍙←id ⍙ 0
                  :EndIf
         ⍝ New object. Are we tracking them?
              :ElseIf ~0∊⍴NewObjectsFolder
                  ⎕SE.Dyalog.⍙←id 0 0     ⍝ new object signature
              :EndIf
     
          :Case 'AfterFix'
⍝ After an object has been fixed successfully check to see if it is part of a Link
⍝ If now, we check to see if it is SALTed, in which case details
⍝     have been stored in ⎕se.Dyalog.⍙
     
              :If debug=2
                  (1+1⊃⎕LC)⎕STOP 1⊃⎕SI
              :EndIf
     
              →r←debug Hook t ⍝ return 0 to skip SALT/Link processing
     
              :If 3=⎕NC'⎕SE.Link.OnAfterFix'
                  →0⍴⍨⎕SE.Link.OnAfterFix args ⍝ If linked, returns 1
              :EndIf
              ⍝ If not linked, continue with old SALT code
              →NoSALT
     
              target←fixed←df←0
              :If 2=⎕NC sd←'⎕se.Dyalog.⍙' ⍝ they were kept in this global in this ns
              :AndIf (,3)≡⍴t←⍎sd          ⍝ we need a specific signature
              :AndIf ((DF target←4⊃args),'.',5⊃args)≡1⊃(id ⍙ df)←t
             ⍝ If ⍙ is 0 it's a new object
                  :If 0≡⍙
                      ⎕←'* New object ',id,': ',⎕SE.SALT.Save id,' ',NewObjectsFolder,'/'
                  :Else
⍝ If ⍙ contains 'Name', it represents the name of the pgm fixed if it was the case.
⍝ If there is no such name then a class was fixed. Or it could be new.
                      :If 0=⍙.⎕NC'Name' ⍝ is it a class in a scripted ns?
                ⍝ ns in non scripted nss are OK
                          :If 9=target.⎕NC 5⊃args
                              target←target⍎5⊃args
                          :EndIf
                          target.SALT_Data←target.⎕NS ⎕OR'⍙' ⍝ needed in 12.1
                      :ElseIf ≢/args[5 6]       ⍝ changed a program name?
                      :AndIf (target.⎕NC 5⊃args)∊3 4
                          target.⎕FX remTag target.⎕NR 6⊃args ⋄ →0⊣⎕EX sd ⍝ remove its tag
                      :EndIf
                      fixed←Fixed target ⍙
                      :If 0 2∊⍨10|⎕DR df
                          {}target.⎕DF df       ⍝ restore ⎕DF if was present
                      :EndIf
                  :EndIf
              :EndIf
              ⎕EX sd ⍝ prevent accidents
              →L10/⍨fixed∧'⎕SE.SALTUtils'≡⍕target
     
          :CaseList 'Start' 'chk'
     
     L10: ⍝ It looks as if keeping a link to the editor outside
     ⍝ of this ns solves problems with callback settings disappearing
              :If 0=⎕SE.Dyalog.⎕NC'SEEd'
                  ⎕SE.Dyalog.SEEd←⎕SE.⎕WG'Editor'
              :EndIf
              :If t≢'Start'
              ⍝⎕←⎕SE.Dyalog.SEEd.⎕WG'Event'
              :EndIf
              ⎕SE.Dyalog.SEEd.⎕WS'Event'('Fix' 'AfterFix')(⎕IO⊃⎕XSI)
     
          :CaseList 'End' 'Stop'
              ⎕SE.Dyalog.SEEd.⎕WS'Event'('Fix' 'AfterFix')0
     
          :EndSelect
          r←1 ⍝ Allow editor to close
      :Else
          ⎕DMX.('⎕SE.SALTUtils.⍙dmx'⎕NS ⎕NL-⍳9)
          ⎕SE.SALTUtils.⍙dmx.⎕DF⍕⎕DMX
          cap←'Error saving ',5⊃args
          obj←(⍕4⊃args),'.',(5⊃args)
          src←{0::'(***INTERNAL ERROR***)' ⋄ '/'⎕R'\\'⍣⎕SE.SALTUtils.WIN∊1 ⎕NPARTS ⍙.SourceFile}⍬
          error←'a',{1<≢⍵:⍵,⍨'n'/⍨'aeiou'∊⍥⎕C⍨2⊃⍵ ⋄ 'n unknown error'}' ',⎕SE.SALTUtils.⍙dmx.(EM,{(×≢⍵)/': ',⍵}Message)
          reason←'the file not being writable' 'the filename being invalid' 'insufficient storage space' 'a strong interrupt' 'a weak interrupt'error⊃⍨19 22 34 1002 1003⍳⎕SE.SALTUtils.⍙dmx.EN
          text←⊂'Attempt to save object ',obj,' to file ',src,' failed due to ',reason,'.'
          :If ×debug
              text,←⊂⎕SE.SALTUtils.⍙dmx.(EM,({(×≢⍵)/': ',⍵}Message),{(×≢⍵)/' (',⍵,')'}1⊃⌽OSError),'.'
              text,←⊂'⎕DMX copied to ⎕SE.SALTUtils.⍙dmx'
          :EndIf
          text,←'' 'If you choose Abort, the editor will remain open.'
          text,←'' 'If you choose Retry, the file write will be attempted again.'
          text,←'' 'If you choose Ignore, the editor will close but your changes will NOT be saved to file.'
          btns←'ABORT' 'RETRY' 'IGNORE'
          resp←msgBox cap text'Error'btns
          r←3=resp ⍝ close Editor if IGNORE
          →2=resp  ⍝ retry if RETRY
      :EndTrap
    ∇

    ∇ r←debug Hook event
     ⍝ OUTPUT WARNING: Outputs errors to STDOUT as editor callbacks disturb STDERR
     ⍝                 Review instances of ⎕← when output is sorted out in 19.0
      ;⎕ML;hooksLoc;hooks;Run;hook;fns;priorities;error
      ⎕ML←1
     
     ⍝ This runs the appropriate hook from:
      hooksLoc←'⎕SE.Dyalog.Hooks.',event
      r←⍬ ⍝ default return, only overridden if a hook returns 0
      :If 0≠⎕NC'⎕SE.Dyalog.Hooks'
      :AndIf 0 ⎕SE.Dyalog.Hooks.Init event
      :AndIf ~0∊⍴hooks←⍎hooksLoc
          Run←85 ⎕SE.⌶⍨∘0 ⍝ return result, ⎕SIGNAL 85 if none
          :For hook :In ⊣/hooks
              :Trap 0 1000/⍨~×debug
                  →r←0/⍨0≡r←(Run hook)args
              :Case 85 ⍝ no result → continue
              :Else ⍝ report issues (except 85s - tough luck!)
                  error←' *** ',event,' event: ','⍎'~⍨⊃⎕DMX.DM
                  error,←' from "',hook,'" ─ set ⎕SE.SALTUtils.DEBUG←1 to stop on error',⎕UCS 10
                  ⎕←error
              :EndTrap
          :EndFor
      :EndIf
    ∇

    ∇ done←Fixed(ns ⍙);buttons;confirm;ext;fmt;here;isfn;isns;key;last;maxv;mode;n;name;new;nofile;path;prev;r;source;sourcefile;s0;t;tsinfo;upd;version;ync;z
      :Access Shared Private
    ⍝ Called after object has been fixed to update the source file
      nofile←1 ⋄ isfn←done←0 ⋄ z←,⊂'' ⋄ fmt←0
      :If isns←0∊⍙.⎕NC'Name' ⍝ Class? Namespaces have no 'Name' var
          source←⎕SRC ns ⋄ name←DF ns
      :ElseIf isfn←4 3∨.=ns.⎕NC name←⍙.Name
          source←remTag ns.⎕NR name  ⍝ remove tag line for fns
      :Else ⍝ it's a variable, hopefully palatable
          fmt←⍙.Format ⋄ source←name(fmt≡'xml')∆VCR{1=≡⍵:⍎⍵ ⋄ ⊃⍎/⍵}⍙.Pathname
      :EndIf
      :Trap 22 ⍝ the file may be gone
          key←{6::0 ⋄ ⍵.EKey}⍙
          z←fixTabs key splitOnNL ⍙.SourceFile ⋄ nofile←0
      :EndTrap
      :If ('<APLScript>'startsWith⍨1⊃z)∧':Class PageClass'startsWith⍨1⊃source
          source←z MakeAPLScript source
      :EndIf
     
      :If source≢z ⍝ Any changes?
      :AndIf (rlb¨source)≢rlb¨z ⍝ we shouldn't have to do this
     
⍝ This is an update; there are 2 cases:
     
⍝ 1. we are adding a new version: we use the next available number
⍝  We have to be careful not to add a new version from an outdated version (e.g. we loaded an
⍝  old ws containing an outdated version). For this we check that the version # is exactly the
⍝  same as the highest verno. In the case where we actually requested to reload an old version
⍝  it will be negative to denote that fact (i.e. Load will negate the verno)
⍝  In the case where a brand new version is added (we edited the very LAST version) the prompt includes
⍝  an option to overwrite the last version.
     
⍝ 2. we are replacing an existing file: we confirm if confirmation not disabled
⍝  If we attempt to overwrite with an old version we will detect it by comparing the timestamps
     
          z←s0←sourcefile←⍙.SourceFile
          :If new←last←0≠version←maxv←⍙.Version ⍝ case #1
            ⍝ There should be a version # but just in case...
              (t n ext)←splitName 2⊃(path t)←FS splitLast sourcefile
              maxv←⌈/0,path ListVersions t,'.',ext ⍝ find last verno
              last←version≥maxv ⍝ if it is > it must be because we used RemoveVersions
              version←1+maxv
              (s0 sourcefile prev)←(path,FS,t)∘,¨((⊂''),'.',¨⍕¨1 0+maxv),¨⊂'.',ext
          :EndIf
     
         ⍝ We can automate confirmation by setting 'ConfirmEdit' to be 1 (YES)
         ⍝ The 2nd element of 'ConfirmEdit', is present, is the answer to the following
         ⍝ 3 questions.
          :If ~1↑(confirm ync)←2↑ConfirmEdit,1  ⍝ has confirmation been disabled?
              ync←3⍴ync ⍝ used for answering the next 3 questions automatically
            ⍝ Confirmation required, prepare the question
              upd←⊂('Update' 'Create a new'⊃⍨1+new),' source file for ',name,'?'
              t←(nofile<new>last)/'NOTE: *** this is NOT the latest version!'
              t←t,nofile/'NOTE: *** the original file is no longer found!'
              mode←'overwritten.' 'created.'⊃⍨1+new∨nofile
              t←t('If you choose YES, file ',sourcefile,' will be ',mode)''
              buttons←'Yes' 'No',last/⊂'Cancel'
              :If last←last>nofile
                  t,←⊂'If you choose NO, file ',prev,' will be rewritten'
                  t,←'' 'If you choose CANCEL, the changes won''t be filed'
              :Else
                  t,←⊂'If you choose NO, the changes won''t be filed'
              :EndIf
          :OrIf (2+last)>ync←msgBox('You have modified ',⍕name)(upd,t)'Query'buttons
     
              :If confirm<×DEBUG
                  ⎕←'* auto response to "You have modified...":',1↑ync
              :EndIf
              :If last∧2∊1↑ync
                  sourcefile←prev ⋄ version←maxv
              :EndIf
     
            ⍝ Make sure the file is not stale.
            ⍝ NOTE: we consider the file up to date if the version is > the one on disk
            ⍝ which may happen after running REMOVEVERSIONS
              :If (maxv>n)∧0<n←⍙.Version
                  :If confirm
                      t←('This is version ',(⍕n),', the latest is ',⍕maxv)('Do you still want to save it as V',(⍕maxv+1),'?')
                      →0⍴⍨1≠msgBox'*** THIS IS NOT THE MOST RECENT VERSION !!!'t'Warn'
                  :Else
                      :If ×DEBUG
                          ⎕←'* auto response to "This is version X":',t←1↑1↓ync ⋄ →0/⍨t≠1
                      :EndIf
                  :EndIf
            ⍝ File is not new: ensure it hasn't been updated outside
              :ElseIf ~nofile
              :AndIf ⍙.LastWriteTime{⍺≢⍵:6<⍴⍺∪⎕D ⋄ 0}t←⍕lastWrTime ⍙.SourceFile   ⍝ not same as we loaded?
                ⍝ If no timestamp is found the file is probably gone, all we need to do is rewrite (with permission)
                ⍝ If its folder is also gone we can't do it and we simply tell the user when we fail to write the file.
                  :If confirm
                      t←{0∊⍴⍵:'No timestamp found for original file!' ⋄ 'Now dated ',⍵}t
                      t←⍙.SourceFile''('Was dated ',⍙.LastWriteTime,' when loaded...')(t)'Proceed anyway?'
                      →0⍴⍨1≠msgBox'Source file timestamp has changed...'t
                  :Else
                      :If ×DEBUG⊣t←¯1↑ync
                          ⎕←'* "Was dated" auto response:',t
                      :EndIf
                      →0/⍨t≠1
                  :EndIf
              :EndIf
              tsinfo←⍬
             ⍝ Insert TS/AN info
              :If (SETCOMPILED∨SETTS)∧~1∊'/SALT/'⍷uCase{s←'\'=v←⍵ ⋄ (s/v)←'/' ⋄ v}sourcefile
                  :If isfn
                      tsinfo←ns getTs,⊂name
                  :ElseIf isns
                      tsinfo←ns getTs⍣(~0∊⍴t)+t←ns.⎕NL ¯3.1
                  :EndIf
              :EndIf
              z←mergeTxt('⍝:Pragma Line 1'startsWith⍨1⊃source)↓source,tsinfo
              :Trap 22
                  z PutUTF8File(t←sourcefile)key
                  :If new
                      z PutUTF8File(t←s0)key
                  :EndIf
              :Else
                  ⎕←'*** Unable to save ',t,', SALT tag is removed'
                  ⎕←'*** Use ]SAVE to save the object manually'
                  :If isfn
                      ns.⎕FX source
                  :ElseIf isns
                      ns.⎕EX'SALT_Data'
                  :Else
                      1 varData⊂ns name
                  :EndIf
                  →0
              :EndTrap
              done←1
              :If isns
                  ⍙←ns.SALT_Data ⍝ shorthand
                  ⍙.LastWriteTime←⍕lastWrTime ⍙.SourceFile←sourcefile ⍝ update Timestamp
                  ⍙.(Version EKey)←version key
                  :If DEBUG>1
                      ⎕←'* New Tag info: ',⍙.(LastWriteTime SourceFile Version EKey)
                  :EndIf
              :Else
                  SetDelta(ns name source,isfn/⊂tsinfo)sourcefile version ⍬ fmt key
              :EndIf
          :EndIf
      :EndIf
    ∇

    mergeTxt←{11::⍬ ⋄ (-⍴L)↓⊃,/(⊂⍣(1≡≡⍵)+⍵),¨⊂⎕ucs L←LINDEL}

    ∇ r←file MakeAPLScript class;eAS;html;i;m;script
⍝ Merge PageClass source with apls file contents
      html←(i←((⍴eAS)↑¨file)⍳eAS←⊂'</APLScript>')↓file ⍝ Extract the non-APLScript part
      script←1↓(i-1)↑file
      script←({'<'∊1↑⍵~' '}¨script)/script ⍝ statements beginning with <
      :If (⍴class)≥i←class⍳⊂'⍝--- APLS Code Begins ---'
          class←¯2↓i↓class
          m←class∧.=¨' '
          class←(+/∧\m)↓(-+/∧\⌽m)↓class
      :EndIf
      r←(eAS~¨'/'),script,class,eAS,html
    ∇
    :endsection

    :section SALT
⍝ ===== SALT utilities

    ∇ {rc}←Forget(folder name version keeplast newlast noprompt);dotVer;ext;f;last;list;next;nf;ok;prev;S;stem;t;Ver
⍝ Forget Backup Versions
      :Access Shared Private
      ok←1 ⋄ dotVer←{(0<⍵)/'.',⍕⍵} ⋄ S←{(1=⍴⍺)↓'s',⍵} ⍝ add 's' to plural
      :If 12<nf←⍴t←list~keeplast/⌈/list←{⍵[⍋⍵]},version
          t←t[1],(⊂'...'),¯1↑t
      :EndIf
      (stem f ext)←splitName name ⋄ Ver←'Version',t S' ',⍕fmtVersion¨t ⋄ ext←'.',ext
      :If 0<nf
          t←('Forget Versions of ',name)(('Confirm deletion of ',(⍕nf),' version',list S':')''Ver)'Warn'
      :AndIf ok←t{⍵:1 ⋄ 1=msgBox ⍺}noprompt
          :For t :In list
              fileErase f←(folder,FS,stem,dotVer t),ext
          :EndFor
⍝ This should go to the stderr stream
          ⎕←(⍕nf),' version',list S' deleted.'
      :EndIf
      →ok↓0×rc←nf⌈⍣ok-1 ⍝ return -1 if user aborted
⍝ If a new last version results of the deletions we must make a copy to the non-versioned file
      :If newlast∨.<version ⍝ then the old current version has been deleted
      :AndIf keeplast∨newlast>0
          f←folder,FS,stem,ext ⋄ last←(folder,FS,stem,dotVer newlast+keeplast),ext
          fileCopy/keeplast⌽last f
      :EndIf
    ∇

    ∇ SetDelta(ref name version globalname xml key);ccr;d;ll;lw;nr;prev;t;targ;ts;src;isDerv
      :Access Shared Private
      lw←⍕lastWrTime name
      :If ~isDerv←~3∊⍴ref ⍝ variable
      :OrIf (4∊⍴ref)∧{0.3=1|⍬⍴⍺.⎕NC⊂⍵}/2↑ref,'.' ⍝ derv
          (targ ref src)←3↑ref
          varData(targ ref)name version lw(calcCRC src)(1⊃isDerv⌽xml'drv')key
      :ElseIf 4∊⍴ref ⍝ function
          (targ ref src ts)←ref
          nr←,remTag src
          :If 0.2=1|targ.⎕NC⊂ref ⍝ Dfn?
              ccr←calcCRC nr
              :If 1∊⍴nr ⍝ one liners must be split to accomodate the tag
                  nr←¯1↓¨nr ⋄ ll←'}'
              :Else
                  ll←¯1↑nr ⋄ nr←¯1↓nr
              :EndIf
          :Else
              ccr←calcCRC nr ⋄ ll←⍬
          :EndIf
          d←'§' ⋄ nr,←⊂'⍝∇⍣',d,name,d,(⍕version),d,lw,d,ccr,d,⍕key
          d←targ.⎕STOP ref ⋄ ts←targ.⎕AT ref ⋄ ccr←1+1 targ.(400⌶)ref
          {z←÷⍵}' '∊1↑0⍴targ.⎕FX Dedelify nr,ll ⍝ refix fn with info
         ⍝ Restore state
          d targ.⎕STOP ref ⋄ {0:: ⋄ ts targ.(1159⌶)ref}ccr targ.(400⌶)ref
      :Else ⍝ must be a ref
          prev←¯1
          :If 2∊ref.⎕NC'SALT_Data.Version'
              prev←ref.SALT_Data.Version
          :EndIf
          ref.SALT_Data←ref.⎕NS''
          ref.SALT_Data.PreviousVersion←prev
          ref.SALT_Data.SourceFile←name
          ref.SALT_Data.Version←version
          ref.SALT_Data.LastWriteTime←lw
          ref.SALT_Data.GlobalName←globalname
          ref.SALT_Data.CRC←calcCRC ⎕SRC ref
          ref.SALT_Data.EKey←key
      :EndIf
    ∇

    getTs←{'⍝)('∘,¨,/'!',¨⍵,((⍕¨⍺.⎕AT ⍵)[;4 2]~¨'*'),⍕¨1 ⍺.(400⌶)⍵} ⍝ fnname, user, ⎕TS, compiled

    ∇ space fixTs tags;⎕ML
    ⍝ Fix the timestamp/user name and compiled on the fns defined in the tags
    ⍝ Each tag describes the program name, the user name, the ts (⎕TS form) and if compiled
      →(⍴tags)↓0
      ⎕ML←1 ⋄ tags←0 1↓↑tags splitOn¨'!' ⋄ tags[;3]←num¨tags[;3] ⋄ tags[;2]~←' '
      :If ⎕SE.SALTUtils.SETTS
          :Trap 0
              {6:: ⋄ DEBUG>0:⎕←⍵}tags[;1]space.(1159⌶)⍨0 1 0 1\tags[;3 2]
          :EndTrap
      :EndIf
      :If ⎕SE.SALTUtils.SETCOMPILED
          {}(1+(4↑[2]tags)[;4]∊⊂,'1')space.(400⌶)¨tags[;1]
      :EndIf
    ∇

    ∇ dstname CopyNs source;b;cls;dref;fn;name;ns;nss;s;scrref;src;val;vars;t
⍝ Copy contents of a scripted NAMESPACE into a new non scripted one
⍝ This fn works 2 ways:
⍝ 1: with a source reference which is to be recreated wo source to the target
⍝ 2: with a source NAMED which is NOT to be recreated if its display form does not match
      :If 2=⍴,scrref←source
          name←⍕scrref←⍎/source
          →0/⍨name≢(⍕1⊃source),'.',2⊃source ⍝ skip refs
      :EndIf
      ⎕EX dstname         ⍝ ensure not there
      dref←⍎dstname ⎕NS'' ⍝ create new namespace & get its reference
      dref.(⎕IO ⎕ML ⎕WX ⎕USING ⎕CT)←scrref.(⎕IO ⎕ML ⎕WX ⎕USING ⎕CT) ⍝ ⎕vars
      vars←scrref{0∊⍴⍵:0 2⍴0 ⋄ ⍵,[1.5]⍺.⍎¨⍵}scrref.⎕NL-2
      :For name val :In ↓vars
          ⍎dstname,'.',name,'←val'
      :EndFor
      :If ∨/b←dref.{11::1 ⋄ 0∊1↑0⍴⎕FX ⍵}¨src←scrref.(⎕NR¨⎕NL-3 4)
⍝ OK, some fn didn't fix, probably because it is a ref of some sort
⍝ If it happens to be made with ∘ there is a chance it was with ','
⍝ and the result MAY be wrong, we chance it:
          name←b/scrref.⎕NL-3 4 ⋄ src←b/src
         ⍝ Find the definition in the source
          val←⎕SRC scrref
          :For fn s :InEach name src  ⍝ we can't do them all at once
              :If 1∊⍴t←('\b',fn,'←[^⋄]*')⎕S'&'⊢val ⍝ only ONE match?
                  dref⍎1⊃t ⍝ apply verbatim
              :Else ⍝ take a chance
                  dref⍎fn,'←',⍕s
              :EndIf
          :EndFor
      :EndIf
      :For cls :In scrref.⎕NL-vars←9.5 ⍝ Interfaces
          :If scrref isReal cls
              dref.⎕FIX(⍠'InjectReferences' 'All')⎕SRC scrref⍎cls
          :EndIf
      :EndFor
⍝ Naive redefinition: if base classes are present this will fail
      :For cls :In scrref.⎕NL-9.4
          :If scrref isReal cls
              dref.⎕FIX(⍠'InjectReferences' 'All')⎕SRC scrref⍎cls
          :EndIf
      :EndFor
      :For ns :In (scrref.⎕NL-9.1)~⊂'SALT_Data' ⍝ Namespaces
          :If scrref isReal ns
              (dstname,'.',ns)CopyNs(scrref ns)
          :EndIf
      :EndFor
     ⍝
    ∇
    isReal←{(⍕⍺⍎⍵)≡(⍕⍺),'.',⍵} ⍝ does the name match?

    FixWOtag←{orig≡rep←remTag ⊢orig←⍺.⎕NR ⍵:0 ⋄ 11::1 ⋄ 1⊣at (⍺.(1159⌶)) ⍺.⎕fx rep⊣at←⍺.⎕at ⍵}

    ∇ RemFile file;t
      →(file∧.=' ')/0
      RemoveVersions({q,⍵,q←'"'⍴⍨</'" '∊⍵}file),' -all -noprompt'
      t←⊃{⍺,'.',⍵}/1 0 1/splitName file
      t{22:: ⋄ ⍺ ⎕NERASE ⍺ ⎕NTIE ⍵}0
    ∇

    ∇ n←{delfiles}cleanWS tgt;lst;sons;nr;s;b;fte
    ⍝ This fn is used to remove all traces of linking starting at tgt
      delfiles←{6::0 ⋄ delfiles}0 ⍝ delete associated file(s)?
      :If n←9∊#.⎕NC'SALT_Var_Data'
          :If tgt≡#
            ⍝ If # delete all entries
              n←⍬⍴⍴fte←#.SALT_Var_Data.VD[;2] ⋄ tgt.⎕EX'SALT_Var_Data'
          :Else
            ⍝ If not # and SALT_Var_Data exists remove only appropriate entries
              nr←⍴s←'.',⍨⍕tgt ⋄ n←+/b←(nr↑¨#.SALT_Var_Data.VD[;1],¨'.')∊⊂s
              fte←b/#.SALT_Var_Data.VD[;2]
              #.SALT_Var_Data.VD←(~b)⌿#.SALT_Var_Data.VD
          :EndIf
          RemFile¨delfiles/fte
      :EndIf
      tgt.⎕EX'SALT_Data'
      →0↓⍨{0::1 ⋄ 0⊣⎕SRC ⍵}tgt ⍝ skip scripted nss
     
    ⍝ Refix all fns without their tags (keep the ⎕AT info)
      :If 0<⍴lst←tgt.⎕NL-3.1 3.2 4.1 4.2
          :If ∨/s←0=∊⍴∘⍴¨nr←{fnData⊂⍵}¨tgt.⎕NR¨lst
              n+←+/tgt FixWOtag¨s/lst
              RemFile¨delfiles/(s/nr).SourceFile
          :EndIf
      :EndIf
     
    ⍝ Recursively process any sub space
      :If 0<⍴lst←tgt.⎕NL-9.1 9.4 9.5
    ⍝ Only legitimate ones
      :AndIf ∨/lst←(DF tgt){⍺∘≡¨(⍴⍺)↑¨⍵}DF¨sons←tgt⍎¨lst
          :If 0<⍴sons←(lst/sons)~tgt
              n+←+/cleanWS¨sons
          :EndIf
      :EndIf ⍝ all nss
    ∇

    ∇ r←folder ListVersions name
      :Access Shared Private
      r←⎕IO⊃folder ListVersionsTS name
    ⍝ Version 0 equates the highest Vno if present
      r←r~(0<⌈/r)/0 ⍝ remove it if versioning in effect
    ∇

    ∇ (r ts)←folder ListVersionsTS name;ext;files;se;u;ok
      :Access Shared Private
⍝ Return version numbers and the timestamp of the associated files.
⍝ 'name' is a name always followed by an extension ONLY (no verno)
⍝ 0 as verno represents a file with no version #.
      (name r ext)←splitName lCase⍣WIN⌷name ⍝ lowercase for Windows
      se←-⍴ext←'.',ext,(0∊⍴ext)/1↓SALTEXT
      folder←folder,(FS=¯1↑FS,folder)↓FS
      r←⍬ ⍝ file names with special characters like '(' create problems under Unix
      :If 0<⍴⎕IO⊃(ts files)←2 4⊃¨⊂'a'Dir folder,name,'*',ext
        ⍝ There is a possibility that Dir reported too many names:
          ok←(1⊃¨splitName¨lCase⍣WIN⊢files)∊⊂name
      :AndIf 0<⍴⎕IO⊃(files ts)←ok∘/¨files ts
          u←(r⍳r)=⍳⍴r←{(('.'∊⍵)>' '∊v)×+/2⊃⎕VFI v←2⊃'.'splitLast ⍵}¨se↓¨files
          (r ts)←u∘/¨r ts
      :EndIf
    ∇

    ∇ path←specialName name;nwb;pfs;rp
    ⍝ Change any [name] into path
      :Access Shared Private
      →0↓⍨'['=1↑path←name
      path←getEnvir uCase nwb←((rp←name⍳']')↑name)~'[]' ⍝ uCase for Unix
      ('Folder cannot be resolved: ',name)⎕SIGNAL 922⍴⍨0∊⍴path
      rp+←FS∧.=(pfs←¯1↑path),1↑rp↓name
      :If 'dyalog'≡lCase nwb ⍝ 'Dyalog' needs the 'bin' folder removed
          path↓⍨←¯4×(FS,'bin')≡¯4↑(-pfs=FS)↓path
      :EndIf
      path,←rp↓name
    ∇

    ∇ folder←root ClassFolder folder;and;nocl;rooted;rp;rs;special;stem
⍝ Produce full path by merging root and folder name
      :Access Shared Private
⍝ [xxx] in folder names resolved using GetEnvironment including [DYALOG]
      folder↓⍨←-FS=¯1↑folder                  ⍝ remove last \
      →((rp≢FS,'*')∧≠/(FS,':')=rp←2↑folder)⍴0 ⍝ is it already formatted properly?
      and←{((-FS=¯1↑⍺)↓⍺),(0<⍴⍵)/FS,('/\'∊⍨1↑⍵)↓⍵}
      special←''
     
⍝ Special names treated here
      :If '['=1↑folder
          folder←0/root←folder
      :EndIf
      :If '['=1↑root
          special←specialName(rp←root⍳']')↑root
          folder←special and(rp↓root)and folder
      :Else
          folder←root and folder
      :EndIf
    ∇

    ∇ (dir path files)←name locateIn folders;dir;empty;files;nfs;path;t
⍝ Find the 1st occurence of file in list of folders
⍝ Return the folder it was found in the list provided, the full path and the files found
      :Access Shared Private
      empty←(' '∧.=name)∨name≡,'*' ⍝ this will force return on the first dir in the list
      :For dir :In folders
         ⍝ If ClassFolder complains about the folder name we skip it
          :Trap 11 922
              files←'a'Dir path←dir ClassFolder name⊣files←,⊂''
          :EndTrap
          :If empty∨0<⍴⎕IO⊃files
              :If ∨/'?*'∊2⊃t←FS splitLast path
                  path←1⊃t
              :EndIf
              →0
          :EndIf
      :EndFor
      dir path files←'' '',⊂,¨4⍴⊂⍬ ⍝ default not found
    ∇

    ∇ nr←remTag nr;b
     ⍝ Remove any tag line in the fn
      →0↓⍨⍴nr/⍨←b←'⍝∇⍣'∘≢¨3∘↑∘rlb¨nr
     ⍝ Some versions have a trailing ' }', others a single '}'
      →0↓⍨(1 0 1≡b)∧(⊢/nr)∊' }'(,'}')
      →0/⍨'⍝'∊{⍵/⍨=\''''≠⍵}1⊃nr
     ⍝ Merge Dfn's last line with previous
      nr←,nr[1],¨'}'
    ∇

    ∇ ns←fnData arg;b;data;line;ln;lns;⎕ML
⍝ Fetch data in fn: sourcefile:version:lastwrtime:crc. arg is (source [name])
      ns←⍴⎕ML←1 ⋄ →0↓⍨ln←⍴lns←1⊃arg←2↑arg,0
      →0↓⍨1≡≡line←ln⊃lns
      →0↓⍨ln←ln-'}'=¯1↑line
      →0↓⍨∨/b←'⍝∇⍣'∘≡∘(3∘↑)∘rlb¨lns            ⍝ do we have such a line?
      →0↓⍨4≤⍴data←1↓¨('§'=line)⊂line←(b⍳1)⊃lns ⍝ is it kosher?
      data←5↑data,0 ⍝ previous versions did not have a key
      data[2]←2⊃⎕VFI 2⊃data ⋄ data[5]{⍺≡⍵:0 ⋄ ⍺}←⊂,'0'
      ns←⎕NS'' ⋄ ns.(SourceFile Version LastWriteTime CRC EKey Name)←data[⍳5],arg[2]
    ∇

    ∇ {ns}←{rem}varData arg;b;gd;gns;gv;NI;set
    ⍝ Fetch or Set data in ws for variable given as arg (1 or 7 elements)
      NI←7 ⋄ set←1<⍴,arg ⋄ ns←⍬ ⋄ gns←¯3↓gv←'#.SALT_Var_Data.VD'   ⍝ return ⍬ if not found
      :If 0=⎕NC gv                                                 ⍝ initialize if absent
          →set↓0
          ⍎gns,'←#.⎕ns⍬ ⋄',gv,⍕'←0 ',NI,'⍴0'
      :EndIf
      gd←⍎gv                                                       ⍝ fetch whole data
      :If 0<b←NI-2⊃⍴gd
          gd←0,⍨⍣b⊢gd                                              ⍝ account for pre V2.32 versions
      :EndIf
      :If 0=⎕NC'rem'
          rem←0
      :EndIf
      (1↑arg)←⊂{'['∊ns←DF 1⊃⍵:⍵ ⋄ ns,'.',2⊃⍵}1⊃,arg
      :If ~∨/b←gd[;1]∊⍬⍴arg
          →(rem≥set)/0
          b,←~gd⍪←0
      :EndIf
      ns←⎕NS'' ⋄ ns.Name←{326∊⎕DR ⍵:2⊃⍵ ⋄ ⍵↑⍨-⊥⍨'.'≠⍵}⎕IO⊃,arg
      ns.(Pathname SourceFile Version LastWriteTime CRC Format EKey)←,b⌿gd     ⍝ find actual values
      :If rem
          gd←(~b)⌿gd
      :EndIf
      :If set
          gd[b⍳1;]←arg   ⍝ NI elements
      :EndIf
      :If rem∨set
          ⍎gv,'←gd'                                     ⍝ reset globally
      :EndIf
    ∇

    ∇ r←name ∆VCR object;xml ⍝ create a visual char represention of a variable
      xml←0
      :If 2≡|≡name
          (name xml)←name
      :EndIf
      :If xml
          r←'⌷',name,'←',(⎕UCS LINDEL)⎕SE.Dyalog.Utils.toXML object
      :Else
          r←'⌷',name,'←',⎕SE.Dyalog.Utils.repObj object
      :EndIf
    ∇

    valWithRef←{16::1 ⋄ 1∊{9∊⎕NC'⍵':1 ⋄ ≡⍵}¨∊⍵} ⍝ does this value contain a ref or ⎕OR?

    ∇ crc←calcCRC vtv;DH;n;⎕IO;⎕ML
    ⍝ Compute a CRC from a list of text vectors
      n←⍬⍴⍴DH←⊃,/LU ⋄ ⎕IO←⎕ML←1
      crc←DH[1+n⊥⍣¯1⊢(⍳⍴crc)+.×crc←∊(⎕UCS¨vtv),¨13]
    ∇

    SALTEXT←'.dyalog' ⍝ DOT MUST be part of it

    ∇ (stem ver ext)←{def}splitName name;d;n
    ⍝ Split filename into constituent parts
      ⍎(0=⎕NC'def')/'def←1' ⍝ do we assume a default?
      ext←def/1↓SALTEXT ⋄ ver←0⍴stem←name
      →0⍴⍨∧/d←(name≠'.')∨d≠¯1↑d←+\name∊'/\' ⍝ any dots?
      stem←name↓⍨n←-1+⍴ext←(-⊥⍨d)↑name ⋄ n←-⊥⍨n↓d
      →0↓⍨n{(⍺>-⍴⍵)∧(' '∊v)<(,1)≡⎕IO⊃⎕VFI v←⍺↑⍵}stem
      stem←stem↓⍨-1+⍴ver←n↑stem
    ∇

    ∇ name←remExt name;d ⍝ remove whatever extension after the last DOT (.)
      →0↓⍨∨/d←(name='.')∧⌽∧\~⌽name∊'/\'
      name↓⍨←-1+⊥⍨~d
    ∇

⍝ Add official SALT extension if none already there
    addExt←{⍺←SALTEXT ⋄ ∨/(⍵='.')∧⌽∧\~⌽⍵∊'/\':⍵ ⋄ ⍵,'.',('.'=1↑⍺)↓⍺}

    remVerno←{(f v)←'.' splitLast ⍵ ⋄ ∧/(×⍴v),v∊⎕d:f ⋄ ⍵}

    ∇ {(nam val xml)}←la fixVar src;drop;l1;⍙⍙⍙0;⎕ML ⍝ fix the source of a variable in the target space
    ⍝ Fix a variable. la is TARGET,  VALUE only, name, protected
      :If 0∊⍴nam←(3⊃la)~' '
          nam←{1↓¯1↓⍵[⍳⍵⍳'←']}⎕IO⊃1/src
      :EndIf
      ⎕ML←1 ⋄ drop←2+⍴nam ⋄ l1←2⌊⍴src
    ⍝ Find the format:
      :If xml←'<'∊1↑(drop×l1=1)↓l1⊃,src
          ⍙⍙⍙0←drop∘{⎕SE.Dyalog.Utils.fromXML ⍺↓∊⍵}
      :ElseIf '⌷'=⊃⊃src
    ⍝ Define a fn to recreate the variable
          l1←⎕FX(⊂nam,'←⍙⍙⍙0 S;_'),(1<⍴src)↓(1↑⍨⍴src)↓¨src ⍝ remove first line if more than one
          'Unable to recreate variable (too big)'⎕SIGNAL 911 if l1≢'⍙⍙⍙0'
      :Else ⍝ derv
          xml←2 ⍝ 'drv'
          :Trap 0
              :If ~la[2]
                  :If la[4]∧×la[1].⎕NC nam
                      val←'** ',nam,' is already defined'
                  :Else
                      val←nam ⋄ la[1]⍎⊃src
                  :EndIf
              :Else
                  val←⊃src
              :EndIf
          :Else
              val←'*** Unable to define derv ',nam,': ',⎕IO⊃⎕DM
          :EndTrap
          :Return
      :EndIf
      :Trap 0
          :If ~la[2]
              :If la[4]∧×la[1].⎕NC nam
                  val←'** ',nam,' is already defined'
              :Else
                  val←nam ⋄ nam(la[1].{⍎⍺,'←⍵'})⍙⍙⍙0 src
              :EndIf
          :Else
              val←⍙⍙⍙0 src
          :EndIf
      :Else
          val←'*** Unable to define variable',(' ',nam),': ',⎕IO⊃⎕DM
      :EndTrap
    ∇

    ∇ r←fmtVersion v;ab ⍝ arg can be a simple number, or a string
      :Access Shared Private
      ab←{'[',⍵,']'}  ⍝ neg numbers don't get decorators
      r←{3=10|⎕DR ⍵:ab⍣(0<⍬⍴⍵)⍕|⍵ ⋄ (0<⍴,⍵)/ab ⍵}v
    ∇

    ∇ r←fmtDate v
      :Access Shared Private
      r←0 19⍴'' ⋄ →0⍴⍨0∊⍴v
      r←v ⋄ →0⍴⍨isChar v ⍝ empty v is char: skip
      r←'I4,2(</>,ZI2),I3,2(<:>,ZI2)'⎕FMT⊃,6↑¨↓v
    ∇

    ∇ r←lastWrTime w ⍝ Last Write Time for file
      :Access Shared Private
      r←2⊃'a'Dir w
    ∇

    ∇ {r}←CC list;all;b ⍝ Code Coverage. list is the fns to set
     ⍝ or 1 to initialize all or 0 (stop & clear) or -1 (stop)
      :Access public shared
      :Trap 6
          {}CodeCov
      :Else
          ⎕SE.SALT.Load'tools\code\codecov'
      :EndTrap
      all←⎕NL-3.1 4.1
      :If 1∊b←¯1 0∊list
          r←CodeCov.CC CCdata,{(⎕MONITOR ⍵)[;2]}¨CCdata[;1]
          →b[1]/0 ⍝ do not reset numbers if ¯1
          →0,⍬∘⎕MONITOR¨all
      :ElseIf list≡1
          list←all~'CC' 'UCMD'
      :EndIf
      r←CCdata←''CodeCov.CCinit⍨⎕CR¨⊂⍣(2>≡list)⊢list
      (¯1+⍳999)∘⎕MONITOR¨list ⍝ we can't do this inside CCinit
    ∇
    :endsection

    :section Parser
⍝ ===== Parsing related fns

    ∇ parms←{patn}∆parse arg;narg;p;⍙
⍝ In this version we make use of the Parser in ⎕SE.
⍝ arg is argument, number of expected args (default any number)
      narg←''
      :If 2∊|≡arg
          (arg narg)←arg
      :EndIf
      narg←'upper prefix=⍙',(0<⍴narg)/' nargs=',narg←,⍕narg
      p←⎕NEW ⎕SE.Parser(patn narg)
      parms←p.Parse arg
      ⍙←1⌽')(',⍕'⍙'parms.⎕NL-2 ⍝ all ⍙ names
      ⍎⍙,'←parms.',⍙ ⍝ assign ⍙ names in current namespace
      parms←parms.Arguments
    ∇

    ∇ r←r ∆default value
⍝ Default CHARACTER STRING r BY value IF IT ≡0
      :Access Shared Private
      →(r≡1)⍴0 ⍝ also a valid value
      →(r≡0)↓mod
      r←value ⋄ →0
      ⍝ r IS not SCALAR 0 - ⍎ IF value IS NUMERIC
     mod:→(' '=1↑0⍴value)/0
      r←2⊃⎕VFI{b\⍵/⍨b←','≠⍵}r ⍝ accept , between values
    ∇

    ∇ str←∆propagate switches;b;sw;v
⍝ This fn will recreate a string of the switches in order to be passed on another cmd
⍝ e.g. ⎕SE.SALT.Cmd myarg,∆propagate 'VERSION'
      str←''
      :If 1∊b←0≢¨v←⍎¨sw←'⍙',¨switches splitOn' '
          str←∊(b/v){' -',1↓⍵,(1≢⍺)/'=',⍕⍺}¨b/sw
      :EndIf
    ∇
    :endsection

    :section Utils
⍝ ===== Misc Utilities

⍝ String Index with minimal length: 2='aa' 'bb' strIndex ⊂,'b'
    strIndex←{∨/b←⍺∊⍵:b⍳1 ⋄ (1=+/b)×1⍳⍨b←((⍴s)↑¨⍺)∊⊂s←,1⊃,⍵}

    ∇ r←{b}rlb w            ⍝ rem leading blanks
      :Access Shared Private
      :If 0=⎕NC'b'
          b←' '
      :EndIf
      r←(+/∧\w∊b)↓w
    ∇

    ∇ r←{b}rtb w            ⍝ rem trailing blanks
      :Access Shared Private
      :If 0=⎕NC'b'
          b←' '
      :EndIf
      r←(-⊥⍨w∊b)↓w
    ∇

    ∇ r←isChar obj
      :Access Shared Private
      r←0 2∊⍨10|⎕DR,obj
    ∇

    ∇ pos←list limRegexFind pattern;pat;from;to;t
    ⍝ Find elements in a list matching a limited regular expression
      :Trap 11
          from←'\.' '\*' '\?' '\W' '\\' ⋄ to←'\\.' '.*' '.' '\\&' '\\\\'
          pat←'^','$',⍨from ⎕R to{⍵↓⍨'+'∊1↑⍵}pattern~' ' ⍝ turn into full regex
          pos←⎕IO+∪pat ⎕S 2⊢list
      :Else
          'Bad pattern'⎕SIGNAL 902
      :EndTrap
    ∇

    ∇ lu←LU
      :Access Shared Private
      lu←'abcdefghijklmnopqrstuvwxyzàáâãåèéêëòóôõöøùúûäæü' 'ABCDEFGHIJKLMNOPQRSTUVWXYZÀÁÂÃÅÈÉÊËÒÓÔÕÖØÙÚÛÄÆÜ'
    ∇

    ∇ a←c rCase a ⍝ regressive casemap
      a←(¯1*~c)⎕C a
    ∇

    ∇ s←lCase s
      :Access Shared Private
      :Trap 0
          s←¯1 ⎕C s
      :Else
          s←0 rCase s
      :EndTrap
    ∇

    ∇ s←uCase s
      :Access Shared Private
      :Trap 0
          s←1 ⎕C s
      :Else
          s←1 rCase s
      :EndTrap
    ∇

    ∇ s←fCase s
      :Access Shared Private
      :Trap 0
          s←¯3 ⎕C s
      :Else
          s←⊃rCase/0 1 s
      :EndTrap
    ∇

    FixSlashes←{('\\' '/'⊃⍨1+WIN)⎕R('/' '\\'⊃⍨1+WIN)⊢⍵}

    ∇ r←msgBox arg;ans;Btns;Caption;choices;evt;hint;Mode;msgbox;N;No;parms;t;Text;Warn
    ⍝ Return 1, 2 or 3 for buttons pressed
      :Access Shared Private
      (Caption Text Mode Btns)←arg,(⍴arg)↓0 0 'Warn',('Yes' 'No')(⊂'OK')[Warn←1+arg[3⌊⍴arg]∊'Info' 'Msg']
      :Trap 0 ⍝ Try ⎕WC if no simple cross-platform dialog box
          r←¯60+3503⌶Caption Text Mode Btns
      :Else
          :Trap 0 ⍝ revert to ⍞ if GUI impossible
              {x←÷~3501⌶⍬}'is Ride connected?' ⍝ then no GUI
              'msgbox'⎕WC'msgBox'Caption Text Mode Btns('Event'(evt←61 62 63)1)
              r←4|evt⍳2⊃⎕DQ'msgbox'
          :Else
              Text~←⊂''
              (N No)←Warn⊃¨('nN' 'oO')('n (No)' 'o (OK)')
              choices←'yY',N,(t←3∊⍴Btns)/'cC' ⋄ hint←' y/',(1↑N),(t/'/c'),'? '
              ⎕←((⍴Text),⍳1≠≡,Text)⍴Text
              :While ~1∊ans←choices={⍞←⍵ ⋄ 1↑(⍴,⍵)↓⍞}⍕hint
                  ⎕←'** Enter one of y (Yes) or ',No,t/' or c (Cancel)'
              :EndWhile
              r←(∨/3 2⍴ans)⍳1
          :EndTrap
      :EndTrap
    ∇

    ∇ last←str afterLast chars
      :Access Shared Private
      last←(-⊥⍨~str∊chars)↑str ⍝ string after last char(s)
    ∇

    ∇ r←str splitOn1st chars;p;⎕IO
    ⍝ Split on 1st occurrence of any chars in str
      :Access Shared Private
      ⎕IO←0 ⋄ p←⌊/(,str)⍳chars ⋄ r←(p↑str)((1+p)↓str)
    ∇

    ∇ yes←string startsWith subs
      :Access Shared Private
      yes←subs≡(⍴subs)↑string
    ∇

    ∇ strs←str splitOn char;⎕ML
      :Access Shared Private
      ⎕ML←1 ⍝ char may be multiple
      strs←1↓¨(strs∊char)⊂strs←(1↑char),str
    ∇

    ∇ r←a splitLast w;p ⍝ Split on last occurrence of a in w
      :Access Shared Private
    ⍝ Assume in first pos if not there
      p←-⌊/(⌽,w)⍳a ⋄ r←(p↓w)((1+p)↑w)
    ∇

    ∇ name←name trimAt char;⎕IO
    ⍝ Truncates a character vector at the char delimiting byte.
      :Access Shared Private
      ⎕IO←0 ⋄ name↑⍨←name⍳char
    ∇

    ∇ r←isHelp string
      :Access Shared Private
      r←(string~' ')≡,'?'
    ∇

    ∇ r←num r        ⍝ only use ⎕VFI if character
      :Access Shared Private
      :If isChar r
          ((r='-')/r)←'¯' ⋄ r←2⊃⎕VFI r
      :EndIf
    ∇

    ∇ r←condEncl arg ⍝ conditional enclose
      :Access Shared Private
      r←⊂⍣(326≠⎕DR,arg)⌷arg
    ∇

    ∇ _nam Default _val
      :Access Shared Private
      ⍎(0=⎕NC _nam)/_nam,'←_val'
    ∇

    fixTabs←(⎕ucs 9)∘{∧/b←⍵≠⍺:⍵ ⋄ (b-4×~b)\b/⍵}¨ ⍝ Change Tabs into N spaces

    ⍝ "BlackJack" Partitionning: cut so +/¨⍴⍵ords is max ⍺ in each partition - works also with lines of text
      Fold←{s←1≡≡⍵ ⋄ l←s{⍺:¯2-/0,b/⍳⍴b←1,⍨' '=⍵ ⋄ 2+∊⍴¨⍵}⍵
          cut←(a↑1)⌹((2⍴a)⍴(1+a←⍴l)↑1)-<⍀b∘.>⍺+¯1↓0,b←+\l
          cut←{¯1↓∊l↑¨⍵}⍣s+cut
          ⎕ML←1 ⋄ cut⊂⍵}

    ∇ r←{options}WidthFit text;blk;n;pw;sh;sp;⎕IO;⎕ML ⍝ fit a list ⎕PW wide
      :Access Shared Private
      ⍎(0=⎕NC'options')/'options←⍬' ⋄ (pw blk sp)←options,(⍴,options)↓⎕PW,4 1 ⋄ pw←pw-sp
      ⎕ML←⎕IO←1 ⋄ sh←⊃,/⍴¨,¨text
      sh←⊃,/⍴¨text←(blk×⌈blk÷⍨sh+sp)↑¨text ⍝ adjust each word's size
      r←0⍴⊂''
      :While 0<⍴text
          r←r,,/(n←+/pw≥+\sh)↑text ⋄ (text sh)←n↓¨text sh
      :EndWhile
      r←↑r
    ∇

    Delify←(⊂,'∇'),⍨'∇'∘,¨@1 ⍝ Add ∇s to ⎕NR
    Dedelify←{'^ *∇'⎕R''@(1,≢s)⊢s←⍵↓⍨-⊥⍨''∘≡¨⍵} ⍝ Remove ∇s from ⎕NR if present

    :endsection

    :section OS
⍝ =====  Directory functions

    ∇ r←isDir w
      :Access Shared Private
      r←1∊⎕IO⊃'a'Dir w
    ∇

    ∇ r←isFile w
      :Access Shared Private
      r←0∊⎕IO⊃'a'Dir w ⍝ assume max 1 result only
    ∇

    fixBRname←('\[[^][',PATHDEL,']+\]')⎕R{specialName ⍵.Match}

    ∇ s←{dropLastFS}fixFsep w;i;ws;cd;path;om;WSsurr;sl;fs
      :Access Shared Private
    ⍝ Validate and Replace / or \ by proper OS file delimiter
      fs←(1+∨/'://'⍷w)⊃FS'/'        ⍝ remains / on Win if web protocol
      i←i/⍳⍴i←'/\'∊⍨s←w ⋄ s[i]←fs   ⍝ fix Folder separator
      ⎕SIGNAL 22⍴⍨WIN∧':\'>.=1↓3↑s  ⍝ cannot be relative path if drive specified
      sl←⍴WSsurr←'[ws]'
      :If om←(1↑s)≡,'⍵'             ⍝ turn ⍵ or ⍵/ into current workspace path
      :OrIf WSsurr≡fCase⍕sl↑s
          i+←fs=1↑s↓⍨i←(sl,1)[1+om]
          s←('⍵',fs),i↓s
          :If 'CLEAR WS'≡ws←⎕WSID   ⍝ if in clear ws, use current directory
              s[⎕IO]←'.'
          :ElseIf isRelPath ws      ⍝ if a ⎕WSID is a Windows relative path
              s←'.',fs,i,(0∊⍴i←pathOf ws)↓fs,2↓s
          :Else
              s←(pathOf ws),1↓s,(1=⍴s)/fs
          :EndIf
      :EndIf
      :If cd←(2↑s,fs)≡'.',fs        ⍝ turn ./ into same path as current directory
      :OrIf (3↑s,fs)≡'..',fs
          path←cd{⍺:⍵ ⋄ (-1+⊥⍨~⍵∊'/\')↓⍵}(-(¯1↑i)∊'/\')↓i←CD''
          s←path,(1+~cd)↓s,(1=⍴s)/fs
      :EndIf
      :If 0=⎕NC'dropLastFS'
      :OrIf dropLastFS
          s↓⍨←-fs=¯1↑s
      :EndIf
    ∇

    ∇ b←isRelPath path;s
      :Access Shared Private
    ⍝ A relative path is one not starting with / under Unix
    ⍝ or \ or [X:]\ under windows, taking into account URLs like http://
      →0↓⍨b←~1∊↑,/'://' ':\\'⍷¨⊂path
      b←~'/\'∊⍨(⎕IO+2×WIN∧':'∊s)⊃s←3↑path
    ∇

    ∇ r←pathOf filename
      :Access Shared Private
      :Trap 0
          r←¯1↓1⊃⎕NPARTS filename
          ((r∊'/\')/r)←FS
      :Else
          r←{(-1+⊥⍨~⍵∊'/\')↓⍵}filename
      :EndTrap
    ∇

    ∇ {r}←makeDir path;D
      :Access Shared Private
    ⍝ Create a new directory, ignoring messages if any
      →(⍴r←fixFsep path)↓0
      :Trap 0
          r←3 ⎕MKDIR r
      :Else
          r←⎕SH'mkdir ',((~WIN)/'-p '),D,r,D←WIN/'"'
      :EndTrap
    ∇

    ∇ {r}←remDir path
      :Access Shared Private
    ⍝ Remove a directory, ignoring messages if any
      →(⍴r←fixFsep path)↓0
      :If WIN
          r←⎕CMD'rd /Q /S "',r,'"'
      :Else
          r←⎕SH'rm -fr ',r
      :EndIf
     
    ∇

    ∇ {old}←CD new;get;set;size;t                             ⍝ Change directory.
      :Trap 0
          old←¯1↓1⊃1 ⎕NPARTS''                                ⍝ try new fn first
          old[t/⍳⍴t←old∊WIN/'/']←'\'
          →(⍴new)↓0
      :EndTrap
      :If ~WIN
          old←,⊃⎕SH'pwd' ⍝ ignore set for the nonce
      :Else
          t←'A*'[1+80=⎕DR'']
          'get'⎕NA'U Kernel32|GetCurrentDirectory',t,' U >0T' ⍝ Associate Get function.
          'set'⎕NA'U Kernel32|SetCurrentDirectory',t,' <0T'   ⍝     "     Set    "
          (size old)←get 260 260                              ⍝ Get current directory.
          :If ×⍴,new                                          ⍝ If target directory.
              ⎕SIGNAL(set⊂new)↓11                             ⍝ Domain error if fails.
          :EndIf                                                ⍝ Old dir is shy rslt.
      :EndIf
    ∇

    ∇ {r}←a fileCopy w
      :Access Shared Private
      (a w)←{q,f,q←'"'/⍨WIN>'"'∊f←fixFsep ⍵}¨a w
      r←⎕SH((⎕IO+WIN)⊃'cp ' 'copy /y '),a,' ',w
    ∇

    ∇ {r}←fileErase w;q
      :Access Shared Private
      :Trap 0
          r←1 ⎕NDELETE fixFsep w
      :Else
          r←⎕SH((⎕IO+WIN)⊃'rm ' 'erase '),q,(fixFsep w),q←('"'∊w)↓'"'
      :EndTrap
    ∇

    ∇ files←{parms}Dir path;dfa;switches;⎕IO;viz
⍝ List directory using DOS DIR command
⍝ parms may be any of
⍝ dD: list dirs only
⍝ fF: list files only
⍝ aA: list all data (timestamp, size, name)
      :Access Shared Private
      'parms'Default'' ⋄ ⎕IO←1
      path←path,(FS∊¯1↑path)/'*' ⍝ ensure * after /
      :Trap 2 22
          path←1 ⎕NPARTS path
          files←1 3 2 0 6 ⎕NINFO ⎕OPT 1∊path
          viz←0=5⊃files
          files←viz∘/¨¯1↓files
          files[1]=←1
          files[4]↓¨⍨←≢1⊃path
      :Case 22
          files←4⍴⊂⍬
      :Case 2
          files←WIN NtDirX{⍺:⍺⍺ ⍵ ⋄ ⍵⍵ ⍵}DirU path
      :EndTrap
      :If ∨/2↑dfa←∨/3 2⍴'dDfFaA'∊parms
          files←((⎕IO⊃files)=1↑dfa)∘⌿¨files
      :EndIf
      :If 0=3⊃dfa
          files←4⊃files
      :EndIf
    ∇


    ∇ files←DirU x;b;cut;dir;list;none;⎕IO;⎕ML
⍝ Unix ls: drop 1st line?, cut into sections
      ⎕IO ⎕ML←1 0
      files←0⍴¨0 '' 0 '' ⋄ none←1
      :Trap 11          ⍝ drop . with ls -l:long, d:directories, H:follow symbolic links
          none←0∊⍴list←' ',↑{('total'≡5⍴↑⍵)↓⍵}⎕SH'ls -ldH ',x,' 2>/dev/null'
      :EndTrap
      →none⍴0
      b←cut⍲1⌽cut←∧⌿' '=↑list
      dir←list[;2]='d'
      files←1⊃⌽list←0 1∘↓¨⊃⊂/b∘/¨cut list
      files←{(-⊥⍨' '=⍵)↓⍵}¨↓(⌽∧\FS≠⌽1⌷[1]files⍪' ')/files
⍝ 1st section should be permissions, last is name
      files←dir(↓⍕5↓¯1↓list)(2⊃⎕VFI,' ',5⊃list),⊂files
    ∇

    ∇ rslt←{att}NtDirX path;attrs;FileTimeToLocalFileTime;FileTimeToSystemTime;FindClose;FindFirstFileA;FindNextFileA;GetLastError;handle;keep;mask;max;next;ok;⎕IO;⎕ML
⍝ Return NT directory information
      :Access Shared Private
      ⎕ML←1 ⋄ ⎕IO←0 ⋄ rslt←4⍴⊂'' ⋄ max←2*32
      keep←(⍳32)~30 29 ⍝ all but Hidden & System
      :If 0≠⎕NC'att'
          keep,←('HS'∊att)/30 29
      :EndIf
      mask←(⍳32)∊keep
      FindDefine
      handle next←FindFirstFile path
      →(0=handle)/0 ⍝ file not found
      rslt←,⊂next
      :While 1=0⊃ok next←FindNextFile handle
          rslt,←⊂next
      :EndWhile
      :If 0 18∨.≠ok next
          ('ntdir error:',⍕next)⎕SIGNAL 11
      :EndIf
      ok←FindClose handle
      rslt←1 0 0 1 1 0 1 0/↓⍉↑rslt         ⍝ bin the unwanted elements
      (0⊃rslt)←(attrs←(32⍴2)⊤0⊃rslt)[27;]  ⍝ Get attributes into bits, note dirs
      rslt←(mask∧.≥attrs)∘/¨rslt           ⍝ discard hidden/system unless wanted
      rslt[1]←Filetime_to_TS¨¨rslt[1]      ⍝ put times into ⎕ts format
      (2⊃rslt)←max⊥max|⍉↑2⊃rslt            ⍝ combine size elements
      rslt←(~(3⊃rslt)∊1 2⍴¨'.')∘⌿¨rslt     ⍝ remove . & ..
    ∇

    ∇ rslt←Filetime_to_TS filetime;⎕IO
      :Access Shared Private
      :If 1≠0⊃rslt←FileTimeToLocalFileTime filetime(⎕IO←0)
      :OrIf 1≠0⊃rslt←FileTimeToSystemTime(1⊃rslt)0
          rslt←0 0                   ⍝ if either call failed then zero the time elements
      :EndIf
      rslt←1 1 0 1 1 1 1 1/1⊃rslt    ⍝ remove day of week
    ∇

    ∇ FindDefine;T;WIN32_FIND_DATA
      :Access Shared Private
      T←'A*'[80∊⎕DR'']
      WIN32_FIND_DATA←'{I4 {I4 I4} {I4 I4} {I4 I4} {U4 U4} {I4 I4} T[260] T[14]}'
      'FindFirstFileA'⎕NA'P kernel32.C32|FindFirstFile',T,' <0T >',WIN32_FIND_DATA
      'FindNextFileA'⎕NA'U4 kernel32.C32|FindNextFile',T,' P >',WIN32_FIND_DATA
      ⎕NA'kernel32.C32|FindClose P'
      ⎕NA'I4 kernel32.C32|FileTimeToLocalFileTime <{I4 I4} >{I4 I4}'
      ⎕NA'I4 kernel32.C32|FileTimeToSystemTime <{I4 I4} >{I2 I2 I2 I2 I2 I2 I2 I2}'
      ⎕NA'I4 kernel32.C32∣GetLastError'
    ∇

    ∇ rslt←FindFirstFile name;⎕IO;N
      :Access Shared Private
      rslt←FindFirstFileA name(⎕IO←0)
      :If 1∊(¯1+2*32 64)=0⊃rslt       ⍝ INVALID_HANDLE_VALUE 32 or 64
          rslt←0 GetLastError
      :Else
          (1 6⊃rslt)trimAt←N←⎕UCS 0   ⍝ shorten the file name at the null delimiter
          (1 7⊃rslt)trimAt←N          ⍝ and for the alternate name
      :EndIf
    ∇

    ∇ rslt←FindNextFile handle;⎕IO;N
      :Access Shared Private
      rslt←FindNextFileA handle(⎕IO←0)
      :If 1≠0⊃rslt
          rslt←0 GetLastError
      :Else
          (1 6⊃rslt)trimAt←N←⎕UCS 0   ⍝ shorten the filename
          (1 7⊃rslt)trimAt←N          ⍝ shorten the alternate name
      :EndIf
    ∇

    ∇ enc←NewEncrypt
    ⍝ Provide a new encryption instance
      :If 0=⎕NC'⎕se.Dyalog.Symmetric'
          'Dyalog'⎕SE.⎕NS''
          ⎕SE.SALT.Load'[SALT]/tools/special/symmetric -target=⎕se.Dyalog'
      :EndIf
      enc←⎕NEW ⎕SE.Dyalog.Symmetric'Rijndael'
    ∇

    ∇ num←num numReplace fromto;st;⎕IO;∆;np;p;b;sf;i;from;to
    ⍝ fromto is the list of lists of numbers to replace
      ⎕IO←0
      :For from to :InEach fromto
          ∆←-/(st sf)←(⍴to),⍴from
          :If 0<np←⍬⍴⍴p←{⍵/⍳⍴⍵}from⍷num
              :If ∆≤0
                  num[p∘.+⍳st]←np st⍴to ⋄ →∆↓0
                  b←(⍴num)⍴1 ⋄ b[p∘.+⍳sf]←np sf⍴sf↑st⍴1 ⋄ num←b/num
              :Else
                  b←((⍴num)+np×∆)⍴1 ⋄ b[i←(p+∆×⍳np)∘.+⍳st]←np st⍴st↑sf⍴1 ⋄ num←b\num
                  num[i]←np st⍴to
              :EndIf
          :EndIf
      :EndFor
    ∇

⍝ In 2014 it was decided to translate some new APL characters not in Classic in ⎕Uxxxx form.
⍝ For this we need to scan the source for these special cases. So far we have these:
⍝ Paw (U2364), Key (U2338), Variant (U2360), Iota underbar (U2378), Left shoe underbar (U2286), and Quad diamond (U233A).
⍝ 18.0 adds Hoof (U2365)  ⍝NEWGLYPH⍝
⍝ They have to be functions to be seen in ⎕SE.SALT

    ∇ s←Special(be le) ⍝ 0 1 (LE) or 1 0 (BE) or 0 0 (UTF8)
      :If 1∊be le ⍝ UCS2 values
          s←le⌽¨(35 100)(35 56)(35 96)(35 120)(34 134)(35 58),⎕SE.SALTUtils.V18/⊆(35 101) ⍝ big endian? ⍝NEWGLYPH⍝
      :Else      ⍝ UTF8 values
          s←(226 141 164)(226 140 184)(226 141 160)(226 141 184)(226 138 134)(226 140 186),⎕SE.SALTUtils.V18/⊆(226 141 165) ⍝NEWGLYPH⍝
      :EndIf
    ∇

    ∇ u←up Ux ucs2;U   ⍝ their ⎕U format in Classic. Arg same as Special.
      U←'⎕',¨'uU'[⎕IO+up],¨'2364' '2338' '2360' '2378' '2286' '233A',⎕SE.SALTUtils.V18/⊆'2365' ⍝NEWGLYPH⍝
      :If 1∊ucs2
          u←ucs2[2]{,⍺⌽⍉0 256⊤⎕UCS ⍵}¨U
      :Else
          u←'UTF-8'∘⎕UCS¨U ⍝ done this way to prevent translation when saving
      :EndIf
    ∇

    uxxxx←0∘Ux  ⋄  Uxxxx←1∘Ux

    ∇ r←{remove}GetUnicodeFile ra;b;clean;file;key;nc;tn;utf8;ucs2;from;to;transform;⎕TRAP;opt
⍝ Read a Unicode (UTF-8 or even UCS-2) file
⍝ This version allows excluding specific 1-byte characters before the translation
⍝ This prevents TRANSLATION errors in classic interpreters
      (file key)←2↑(condEncl ra),0
     ⍝ For Classic do we transform special character like RANK into ⎕Uxxxx?
      :If transform←82=⎕DR''
          transform←{6 911::1 ⋄ '1'∊⎕SE.SALT.Settings'mapprimitives'}0
      :EndIf
⍝ Try to read using the V15 system fns, if it fails, revert to the old code:
      :Trap 92 2
          opt←'ContentType'(⎕IO⊃transform⌽'Plain' 'APLCode')
          r←{⍵↓⍨-(⎕UCS 10)=¯1↑⍵}1⊃⎕NGET⍠opt⊢file
          →0
      :EndTrap
     
      clean←{⍵} ⍝ do we need to remove anything from the file?
      :If 2=⎕NC'remove'
          clean←~∘remove
      :EndIf
      r←'' ⋄ ⎕TRAP←19 'E' '→0' ⍝ ⎕MAP error if empty file
      nc←⍴r←256|83 ¯1 ⎕MAP file
      utf8←239 187 191≡3↑r ⋄ ucs2←(2 2⍴254 255 255)∧.=2↑r ⍝ 254 255=big endian
⍝ An updated SALT won't know about this new setting
      :If transform
          b←∨/ucs2 ⋄ from←Special ucs2 ⋄ to←(Uxxxx ucs2),¨⊂ucs2[1]⌽32,b/0
          nc←⍴r←r numReplace from to
      :EndIf
      :If utf8 ⍝ UTF-8 header
          r←'UTF-8'⎕UCS clean 3↓r
      :ElseIf ∨/ucs2
          r←⎕UCS clean 1↓(256*ucs2)+.×⍨(2,⍨nc÷2)⍴r
      :Else ⍝ assume UTF-8 and trap any error
          :Trap 0
              r←'UTF-8'⎕UCS clean r ⍝ decode using KEY
          :Else
              ⎕DMX.Message ⎕SIGNAL ⎕DMX.EN
          :EndTrap
      :EndIf
    ∇

    ∇ text PutUTF8File ra;file;key;tn;⎕IO;s;BOM;transform
⍝ Write Unicode text to new file on disk
      (file key)←2↑(condEncl ra),0
     ⍝ Shall we transform ⎕Uxxxx?
      transform←(82=⎕DR'')∧'1'∊⎕SE.SALT.Settings'mapprimitives'
     ⍝ Try the V15 fns first, if it fails revert to the previous code:
      :Trap 2
          {}text'UTF-8-BOM'⎕NPUT file(1+256×transform)
          →0
      :EndTrap
      :Trap 22
          0 ⎕NRESIZE tn←file ⎕NTIE ⎕IO←0
      :Else
          tn←file ⎕NCREATE 0
      :EndTrap
      s←⍴text       ⍝ do we need a BOM?
      BOM←239 187 191/⍨s≠⍴text←'UTF-8'⎕UCS text
      text←BOM,text ⍝ write unsigned UTF-8 header
      :If transform
          text←(uxxxx 0)s numReplace⍨text numReplace(Uxxxx 0)(s←Special 0)
      :EndIf
      text←⌊text-256×text>127
      text ⎕NAPPEND tn 83
      ⎕NUNTIE tn
    ∇

    ∇ r←Fonts;SPI_GETNONCLIENTMETRICS;spi;LOGFONT;NONCLIENTMETRICS;SIZE;lf;GetLastError;ncm;lfs;ncs;success;result;Caption;SmCaption;Menu;Status;Message;fonts;props
      SPI_GETNONCLIENTMETRICS←41 ⍝ hex 29
      LOGFONT←' {I4 I4 I4 I4 I4 U1 U1 U1 U1 U1 U1 U1 U1 T[32]} '
      lfs←28+32×1+80=⎕DR' '
      lf←⍎'     ⊂0  0  0  0  0  0  0  0  0  0  0  0  0   (32⍴'' '')'
      NONCLIENTMETRICS←'{U4   I4 I4 I4 I4 I4',LOGFONT,'I4 I4',LOGFONT,'I4 I4',LOGFONT,LOGFONT,LOGFONT,'I4}'
      ncs←44
      SIZE←ncs+5×lfs
     
      ncm←⍎'             SIZE 0  0  0  0  0,  lf,      0  0,  lf,      0  0,  lf,     lf,     lf,      0'
      'spi'⎕NA'u user32|SystemParametersInfo* U U =',NONCLIENTMETRICS,'U '
      ⎕NA'u kernel32|GetLastError'
     
      success result←spi SPI_GETNONCLIENTMETRICS SIZE ncm 0
      ('⎕NA error code ',⍕GetLastError)⎕SIGNAL 11/⍨0=success
     
      fonts←'Caption' 'SmCaption' 'Menu' 'Status' 'Message'
      props←⊂'PName' 'Size' 'Italic' 'Underline' 'Weight'
      r←⎕NS ⍬
      fonts r.⎕WC¨⊂'Font'('Coord' 'RealPixel')
      fonts r.⎕WS¨props{⍺ ⍵}¨¨(14 1 6 7 5⊃¨⊂)¨result[7 10 13 14 15]
    ∇

    :endsection

    :section Registry
⍝ =====  Registry functions

    ∇ r←SALTsetFile;v ⍝ file used under Unix for SALT settings
      :If 0=⎕NC'SALTSettingsFile'
          v←⎕SE.SALTUtils.((3↑⎕D∩⍨2⊃APLV),'CU'[1+UNICODE],⍕BITS)
          :If ~⎕NEXISTS r←⎕SE.SALTUtils.USERDIR,'/.dyalog/SALT.',v,'.settings'
              r←⎕SE.SALTUtils.USERDIR,'/.dyalog/SALT.settings'
          :EndIf
          SALTSettingsFile←r
      :Else  ⍝ grab cached value
          r←SALTSettingsFile
      :EndIf
    ∇

    ∇ r←getEnvir w;t;⎕ML
      :Access Shared Private
    ⍝ SALT is a special env var that is assumed to be $DYALOG/SALT if not present
      :If WIN∧'HOME'≡w
          r←1⊃⎕NPARTS 2⊃4070⌶⍬
      :ElseIf (w≡'SALT')∧t←0=⍴r←2 ⎕NQ'.' 'GetEnvironment'w
    ⍝ We want SALT but it is NOT defined so let's build it
          r←r↓⍨-FS=¯1↑r←2 ⎕NQ'.' 'GetEnvironment' 'DYALOG'
          r←r,FS,'SALT' ⍝ default
      :ElseIf t∧w≡'USER' ⍝ USER is also special
          :Trap 0
              r←(1↓2⊃'\'∘=⊂⊢)2⊃4070⌶⍬⊣⎕ML←1
          :Else
              r←⎕AN
          :EndTrap
      :ElseIf ''≢r ⍝ use envvar if specified
      :ElseIf ''≢r←2 ⎕NQ'.' 'GetEnvironment'('SALT\',w)
      :ElseIf ''≢r←2 ⎕NQ'.' 'GetEnvironment'('SALT_',w)
      :ElseIf UnixFileExists t←SALTsetFile
    ⍝ Read setting from the INI files
          r←GetUnicodeFile t
          (r t)←↓⍉↑' 'splitOn1st⍨¨r splitOn ⎕UCS 10⊣⎕ML←1
          r←rlb(r⍳⊂w)⊃t,⊂''
      :EndIf
    ∇

      UnixFileExists←{0::(,'0')≡⎕IO⊃⎕SH'test -f ',⍵,'; echo $?' ⍝ suggested by AS
          ⎕NEXISTS ⍵}

    ∇ value←regSetting arg;canbeempty;name;s;v
⍝ Return setting from the registry/environment
⍝ arg is: [1] Key, [2] default if not present or if empty, and [3] can it be empty
      arg←,condEncl arg
      (name value canbeempty)←arg,(⍴arg)↓'' '' 1
      :Access Shared Private
      :Trap 0
          :If canbeempty∨0<⍴v←getEnvir(WIN/'SALT\'),name
              value←v
          :EndIf
      :EndTrap
    ∇

    ∇ name saveSettings value;file;i;key;L;n;t;txt;v
⍝ Save name with value in registry
      :Access Shared Private
      key←3⊃SettingsTable[SettingsTable[;1]⍳⊂name;]
      :If WIN
          regPutString key value
      :Else ⍝ must be Unix world
          :Trap 22
              txt←GetUnicodeFile file←SALTsetFile
     
            ⍝ Read setting from the settings files
              n←⍴txt←(txt splitOn L←⎕UCS 10)~⊂''
              t←1⊃¨txt splitOn1st¨' '
              :If n<i←t⍳⊂key
                  txt,←0 ⍝ key not there? append dummy
              :EndIf
              txt[i]←⊂key,' ',⍕value
              txt←1↓⊃,/L,¨txt
          :Else
              txt←key,' ',⍕value
          :EndTrap
     
          txt PutUTF8File file
         ⍝ Cover case where root is doing this
          :If 0∊1↑⎕AI
              {}⎕SH'chown ',⎕AN,' ',file
          :EndIf
      :EndIf
    ∇

⍝ The following functions were modified from
⍝ APL Team Ltd ⋄ http://www.aplteam.de ⋄ mailto:kai@aplteam.com

    ∇ regClose HANDLE;RegCloseKey
      :Access Shared Private
      ⎕NA'U ADVAPI32.dll.C32|RegCloseKey U'
      {}RegCloseKey HANDLE
    ∇

    ∇ HANDLE←regGetHandle KEY;HKEY;KEY_ALL_ACCESS;rck;T
      :Access Shared Private
      HKEY←2147483649             ⍝ 'HKEY_CURRENT_USER' HEX 0x80000001
      KEY_ALL_ACCESS←983103       ⍝ HEX 0xF003F
⍝ The next line covers the case for reg & Unicode versions
      T←'A*'[⎕IO+80∊⎕DR'']
      'rck'⎕NA'I ADVAPI32.dll.C32|RegCreateKeyEx',T,' U <0T I <0T I I I >U >U'
      HANDLE←⊃2⊃rck HKEY KEY 0 '' 0 KEY_ALL_ACCESS 0 0 0
    ∇

    ∇ regPutString(SUBKEY STRING);HANDLE;Path;REG_SZ;set;T;uni
⍝ Stores the value of a Registry SUBKEY
      :Access Shared Private
      Path←(getEnvir'inifile'),'\SALT'
      HANDLE←regGetHandle Path
      STRING←,STRING
      REG_SZ←1 ⍝ String data type
      T←'A*'[uni←1+80∊⎕DR'']
      'set'⎕NA'I ADVAPI32.dll.C32|RegSetValueEx',T,' U <0T I I <0T I4'
      {}set HANDLE SUBKEY 0 REG_SZ STRING(uni×1+⊃⍴STRING)
      regClose HANDLE
    ∇
    :endsection

   ⍝ 0(400⌶)0

:EndNameSpace ⍝ SALTUtils  $Revision: 1925 $
