﻿:Namespace NStoScript
⍝ This namespace is used to convert "standard" namespaces into scripted namespaces
⍝ and it will change a NetType namespace into a class.
⍝ It will also convert some script files to the format introduced with V11
⍝ but to do so requires .Net installed.

⍝ Restrictions:
⍝ ⎕ORs or GUI objects are not permitted
⍝ Non simple Fns or derived fns cannot be processed (e.g. f1←monFn or f←1∘+)

⍝ To convert namespace NS do
⍝ NStoScript.Convert 'NS'

    (⎕IO ⎕ML)←0 1 ⋄ CRLF←(CR LF)←⎕av[3 2]
    MAXLINES←150
    Version←1.71
    ACCESS←''

    cut←{⍺←1 ⋄ ⍺↓¨(⍵=1↑⍵)⊂⍵}
    cencl←{⊂⍣(1∊≡⍵)+⍵}
    ⎕fx ⎕se.Dyalog.Utils.⎕cr 'repObj' ⍝ avoid referencing ⎕se directly
    isChar←{(10|⎕DR,⍵)∊0 2}
    isVTV←{(1∊⍴b)≤0∊b←⍴⍵:0 ⋄ ~326∊⎕DR 1/⍵:0 ⋄ ~∧/isChar¨⍵:0 ⋄ 1∧.≥⊃,/⍴∘⍴¨⍵}

    ∇ r←del ntgenopcode(path fnname);code;head
     ⍝ Generate code for an operator in a namespace
      code←code/⍨noTag¨code←path.⎕NR fnname
      head←(del/'∇')∘,¨1↑code
      code←1↓code,del 0⍴¨'∇'
      r←head,code
    ∇

    ∇ r←ns getfninfo fname
     ⍝ Return exported fn data from V10 properties window
      r←5⍴⊂⍬ ⍝ for Dfns
      :Trap 11 6 ⍝ 11 for Dfns, 6 for non NetType ns
          r←(⊂fname),2 ⎕NQ ns'GetMethodInfo'fname
      :EndTrap
    ∇

    ∇ r←ntexplain(fnname scope result args type);mtype;i;pub;sh;ctor;a;⎕ML;wm;b
     ⍝ Explain NetType fn information as returned by <getfninfo>
     ⍝ The info in the properties window comes in as:
     ⍝ arguments: result and args (name,type pairs)
     ⍝ type     : either Method or PropSet|Get
     ⍝ scope    : combination of check boxes. Note: WebMethod appears in that list
     ⍝ NB: the result is always given even is not present (1st line of the args list)
     ⍝ The window in V10 in the same as in V11
      ⎕ML←1
      b←'Static' 'Public' 'Constructor' 'WebMethod'∊scope
     ⍝ Some combinations are impossible, ex: Static (shared) and Virtual (instance)
      (pub sh ctor wm)←b/¨'shared ' 'public ' 'ctor ' 'WebMethod '
      i←'Method' 'PropSet' 'PropGet'⍳1↑type
      mtype←(~∨/b[2 3])/⊃type
      ⎕←'<',fnname,'> is a ',pub,sh,ctor,wm,mtype,(i>0)/' for ',1⊃type
     ⍝ The args should be a list of pairs
      a←1↓∊',',¨(⊂' :'),¨¨args
      ⎕←'It returns a ',result,(0<⍴args)/' and takes args ',a
    ∇

    ∇ r←ntgencoloncode(fnname scope result args type);mtype;i;pub;sh;ctor;⎕ML;wm;b;prop;res;pname;newname;acc
     ⍝ Generate NetType fn information from <getfninfo> result + new fn name if changed (for Set|Get)
     ⍝ The info in the properties window comes in as:
     ⍝ arguments: result and args (name,type pairs)
     ⍝ type     : either Method or PropSet|Get
     ⍝ scope    : combination of check boxes. Note: WebMethod appears in that list
     ⍝ NB: the result is always given even is not present (1st line of the args list)
     ⍝ The window in V10 in the same as in V11+
      r←⍴⎕ML←1
      b←'Static' 'Public' 'Constructor' 'WebMethod'∊scope
      newname←⊂''
      prop←'PropSet' 'PropGet'∊1↑type
     
     ⍝ Don't bother generating :Statements if NOT public and no props
      b[1]←∨/b[1 2 3]
      :If ∨/prop,b ⍝ ctors and webmethods are public instance
          acc←(∨/2↑b),2↓b
          r←acc/(':Access',(b[1]/' public'),b[0]/' shared')':Implements constructor' ':Access WebMethod'
     
     ⍝ Some combinations are impossible, ex: Static (shared) and Virtual (instance)
          :If ∨/prop
              pname,←(' '∧.=pname←1⊃type)/'NoPropertyNameGiven'
              r←r,⍨⊂':Property ',pname
              newname←('set' 'get')[prop⍳1]
          :EndIf
     
     ⍝ The args should be a list of pairs
          res←(∧/result∘≢¨'System.Array' 'Void' '')/result,'←'
          r,←⊂':Signature ',res,fnname,' ',1↓∊',',¨⌽¨' ',¨¨args
      :EndIf
     
      r←newname,⊂r
    ∇

    ∇ r←text extract pos
     ⍝ Extract text from text at position
     ⍝ pos is a 2D int array representing substrings in text
     ⍝
      r←pos[;1]↑¨pos[;0]↓¨⊂text
    ∇

    ∇ r←{new}chgfnname header;b;dya;sep
     ⍝ Replace fnname in header by new name
     ⍝ fnnames are
     ⍝ ∇ r←{left}fnname(right);locals
      b←⌽∨\⌽header∊'∇←'    ⍝ mask out result
      r←∨\b<header∊');⍝'   ⍝ mask out after rargs
      b←b⍱⌽∧\⌽r∨' '=header ⍝ include spaces
      r←¯1⌽≠\b∧header='('
      dya←2=+/sep←b∧r<header∊'} ('
      b←sep≥b∧dya=≠\sep
      r←((b/header),new)[⍋(b/⍳⍴b),(⍴new)⍴b⍳0]
    ∇

    ∇ r←{types}treefileInfo name;⎕USING;f
     ⍝ Return file information in form of tree
      ⎕USING←'System.IO'
      r←⍬ ⋄ f←name
      :If 9≠⎕NC'name'
          f←⎕NEW DirectoryInfo,⊂⊂name
      :EndIf
      :If f.Exists
          :If 0=⎕NC'types'
          :OrIf 0∊⍴types
              types←'*.aspx' '*.apl' '*.asax' '*.asmx'
          :EndIf
          r←⊃,/f.GetFiles¨⊂¨cencl types
          :If ×⍴f←f.GetDirectories'*.*'
              r←r,⊃,/types∘treefileInfo¨f
          :EndIf
      :EndIf
    ∇

    ∇ str←correctCR str;⎕IO;⎕ML;cr;lf
     ⍝ Change CRs into proper form
      ⎕IO←0 ⋄ ⎕ML←2
      cr←str=CR ⋄ lf←str=LF
      :If 'Windows'≡↑'#'⎕WG'APLVersion'
          str[{⍵/⍳⍴⍵}cr>1↓lf,0]←⊂CRLF ⍝ CR→CRLF
          str←∊str
      :Else ⍝ assume *nix
          str[{⍵/⍳⍴⍵}cr]←LF ⍝ CR→LF
      :EndIf
    ∇

    ∇ str←correctNL str;⎕IO;⎕ML;cr;lf;CR;LF
     ⍝ Change NLs into appropriate form
      ⎕IO←0 ⋄ ⎕ML←1
      cr←str=CR←⎕AV[3] ⋄ lf←str=LF←⎕AV[2]
      :Select ⍬⍴'#'⎕WG'APLVersion'
      :Case ⊂'Windows'
          str[lf/⍳⍴lf]←⊂CR,LF ⍝ NL→CRLF
          str←∊str
      :Case ⊂'Unix'
          ⍝ Already OK
      :EndSelect
    ∇

    ∇ str←Unixformat str;⎕IO;cr;CR;LF
     ⍝ Change CRs or CR/LF into NL form
      ⎕IO←0 ⋄ (CR LF)←⎕AV[3 2]
     ⍝ 1. Windows' CR/LF form
      str←(~CR LF⍷str)/str
     ⍝ 2. Replace CRs by LFs
      str[cr/⍳⍴cr←str=CR]←LF
    ∇

    ∇ r←{mods}Convert path;sp;B
    ⍝ Cover for <ntgennscode>
    ⍝ mods may specify whether we want to include special statements in fn
    ⍝ or fail if it contains bad objects (X)
    ⍝ S means include Access Shared statement, P is Public, B=... means include '...' as banner
      :If isChar path
      :AndIf '#'≠1↑path
          path←{'#'=1↑⍵:⍵ ⋄ '#.',⍵}(⎕IO⊃⎕NSI),'.',path
      :Else
          path←⍕path
      :EndIf
      'already in source mode'⎕SIGNAL({0::0 ⋄ ⍴⍴⎕SRC⍎⍵}path)⍴11
      :If 0=⎕NC'mods' ⋄ mods←'' ⋄ :EndIf
      ACCESS←(∨/sp)/⊂':Access',∊(sp,~sp←∨/2 2⍴'sSpP'∊mods)/' Shared' ' Public' ' Instance' ' Private'
      BANNER←0
      :If B←∨/sp←'B='⍷mods ⋄ BANNER←B←(1+sp⍳1)↓mods
          :If '⍎'=1↑B ⋄ BANNER←' '⍪' '⍪⍨⎕FMT(⎕IO⊃⎕NSI)⍎1↓B ⋄ :EndIf
      :EndIf
      r←(1('X'∊mods)BANNER)ntgennscode path
    ∇

    ∇ r←{vars}makeVars ppath;obj;tmp;t;v;⎕IO;ex;mat;C;CRfix;c;anyCR;crdef;noqio;l;isc;B;W;pd;pt;s;done;w;ML;IN;IO;nola;mix
    ⍝ Prepare a listing of all the variables
      noqio←CRfix←{⍵} ⋄ mix←'{⎕ml←1 ⋄ ↑⍵}' ⋄ C←⊂crdef←'⎕av[⎕io+3]'
      :If nola←0∊⎕NC'vars'
          vars←ppath.⎕NL ¯2.1 ⋄ crdef←'⎕av[3]'
          noqio←{IO∨←⍵≢noio←('-¯1×⎕io-' '([,(])-⎕io-' '-⎕io-' '⎕io\+'⎕R'-' '\1' '+' '')⍵ ⋄ noio}
          CRfix←crdef∘{⍺≡(s←⍴⍺)↑⍵:C,s↓⍵ ⋄ ⍵≡',',⍺:',',C ⋄ ⍵}∘noqio
          mix←'↑'
      :EndIf
      →(⍴vars←~∘' '¨↓⍣(1≥≡vars)+vars)↓⍴r←⍴⎕IO←1
    ⍝ Pick a temp name for building character vectors
      tmp←⊃(,¨'_∆⍙abdefghijkmopqrstuvwxyzcln',⎕A)~vars
      :If 0∊⍴tmp~' ' ⋄ ⎕RL←×/3/¯1↑⎕TS ⋄ tmp←⎕A[?7⍴⍴⎕A] ⋄ :EndIf  ⍝ unlikely but...
    ⍝ Find a name for CR
      C←(1+nola)⊃C,((,¨'LCNlcn'),'CR' 'NL' 'LF' 'NeWLinE')~vars,⊂tmp
      IO←ML←anyCR←ex←0 ⋄ IN←{=\b⍱(-⍴⍺)⌽b←⍺⍷⍵}
     
      :For obj :In vars
          :If isc←isChar v←ppath.⍎obj
          :AndIf (mat←2∊t)∨(1∊c←CR=v)∧1∊t←⍴⍴v ⍝ matrix or char vector with anyCRs in it?
          :AndIf mat≤90<×/⍴v                  ⍝ does it fit on a single line?
              t←⎕A,'abcdefghijklmnopqrstuvwxyz ;[]()',⎕D
          :AndIf {mat∨'     ∇ '≡7⍴⍵:1 ⋄ 0.66<(+/⍵∊t)÷⍴⍵}v    ⍝ fn or real text?
              :If mat<c≡(⍴c)↑1                ⍝ a single line?
                  r,←⊂obj,'←',C,',',noqio repObj 1↓v ⋄ anyCR←1
              :Else
                  ex←1
                  r,←⊂tmp,'←⍬'                ⍝ then do line by line
                  :If mat ⋄ s←⊂'' ⋄ t←↓v ⋄ :Else ⋄ t←(s/c)↓¨(s←1,1↓c)⊂v ⋄ anyCR←1 ⋄ s←(s/c)/¨⊂C,',' ⋄ :EndIf
                  r,←(tmp,',←',mat⍴'⊂')∘,¨s,¨CRfix∘repObj¨t
                  r,←⊂obj,'←',(mat/mix),tmp ⋄ ML∨←mat
              :EndIf
          :ElseIf (isVTV v)>1∊⍴v              ⍝ a VTV?
          ⍝ We try to minimize the length of the source by gathering strings 99 chars wide
          :AndIf 1<+/t←99{0∊⍴⍵:⍬ ⋄ n←1⌈+/⍺>+\⍵+2 ⋄ (n↑1),⍺ ∇ n↓⍵}∊⍴∘,¨v ⍝ ⍺ is max width
              r,←⊂tmp,'←⍬'
              r,←(tmp,',←')∘,¨noqio∘repObj¨t⊂v
              r,←⊂obj,'←',tmp
              ex←1 ⍝ expunge that tmp var
          :Else ⍝ some random char data...?
              t←noqio∘repObj v ⋄ done←0
              :If isc∧(1∊⍴⍴v)∧1<⍴,v
             ⍝ We now have a string made of ⎕AV[...] sequences mixed with 'strings'
             ⍝ We build a series of statements to recreate this variable, for this
             ⍝ we must cut the source on commas not within quotes or []s or ()s.
                  s←=\''''≠t
                  s←s∧0=(+\s∧t∊'[(')-+\s∧t∊'])'
              :AndIf ∨/B←s∧','=t ⋄ l←⍴W←199 ⍝ the max Width desired
                  :Repeat
                      s←t↑⍨pt←¯1+pd←W⌈B⍳1
                      :If done←pd>⍴t ⋄ l,←⊂t
                      :Else
                          pd←pd-⊥⍨~pd↑B
                          l,←⊂(pd-1)↑t
                          (t B)←pd↓¨t B
                      :EndIf
                  :Until done
                  r,←⊂tmp,'←⍬'
                  r,←(tmp,',←')∘,¨l
                  r,←⊂obj,'←',tmp
                  ex←1 ⍝ expunge that tmp var
              :Else
                  r,←⊂obj,'←',t
              :EndIf
          :EndIf
          r,←⊂''
      :EndFor
      anyCR∧←nola
      r,←anyCR ex{⍱/⍺:'' ⋄ ⊂'⎕ex',(⍲/⍺)↓'¨',∊{' ''',⍵,''''}¨⍺/⍵}C tmp ⍝ get rid of temp names
      r,⍨←anyCR/⊂C,'←⎕av[3+⎕io]' ⍝ we cannot use ⎕ucs 13 in case CR is not in ⎕av on a classic system
      →nola↓0
      t,←v←∨/t←IO ML
      r←(v/1⌽'' '',⊂⍕t/'⎕IO' '⎕ML' '←0 ⍝ *** DO NOT change these system variables here, only after the variables definition'),'⍝ === VARIABLES ===' '',r
      r,←'' '⍝ === End of variables definition ===' ''
    ∇

    ∇ {r}←{la}ntgennscode path;fixclass;nsname;obj;ref;fns;drop;base;u;Qvars;diff;⎕ML;events;type;nettype;sub;adddel;cl;b;parent;in;toinclude;Auto;ItemLINES;fail;bad;ns;BANNER;⎕IO;name
⍝ Generate code for a namespace
⍝ This fn makes the following assumptions:
⍝ - absolute path is a class 9 object
⍝ - class 9 objects others than NetTypes can be present within a NetType, their code is included as :Namespaces
⍝ - variables are private (we cannot get at their .Net attributes)
⍝ - operators are private
⍝ - Properties' set|get fns can have names different than <set_propname>
⍝ 'path' may be a char string of a ref OR a ref
     
      :If 0=⎕NC'la' ⋄ la←⍬ ⋄ :EndIf
      (fixclass fail BANNER name)←4↑la
      (⎕IO ⎕ML)←0 1
      ItemLINES←0 ⍝ Max number of [by Item] lines before fns are sent to an :Included NS
     
⍝ Cover empty calls (¨⍳0)
      :If ∧/(⍕path)∊'#. ()'     ⍝ if string is NOT a ref
          r←'*** "',path,'" is not a namespace'
          →fail⍴0
          r←⊂'⍝ ',r
      :Else
          :If ns←9=⎕NC'path' ⋄ path←{(~'['∊⍵)/⍵}⍕ref←path ⋄ :Else ⋄ ref←⍎path←path,⍨('#'≠1↑path)/'#.' ⋄ :EndIf ⍝ add #. if not there
          :If nettype←':NetType '≡type←1⌽' :',ref.⎕WG'type' ⋄ type←':Class ' ⋄ :EndIf
         ⍝ If the namespace is a temp, remove the name
          nsname←name{(~'['∊s)/s←⍵,(0∊⍴⍵)/⍺}{(-⊥⍨'.'≠⍵)↑⍵}path ⍝ keep last . section
          base←''
          :If nettype
              base←{⍵,⍨(0<⍴⍵)/': '}⍕1↓∊{⍵,⍨(×⍴⍵)⍴','}¨ref.⎕WG'BaseClass' 'Interfaces'
          :EndIf
          r←,⊂type,nsname,base,Auto←'' ⍝ timestamp here?
          r,←(BANNER≢0)/↓'⍝',' ',↑BANNER
          r,←nettype/⊂':Access public'
          u←ref.⎕USING∪nettype/'' 'System'  ⍝ to cover System.types
     
         ⍝ The base classes reference "scans" down the script for :usings and then looks for the base class.
         ⍝ It does not execute the assignment expression and then look at []USING so we need to either use
         ⍝ :Using all the time or use it only when the class is based
          :If 0<⍴base
              r,←':Using '∘,¨u,¨(0=,↑⍴¨u)⍴¨',' ⍝ change ":Using" into ":Using ,"
          :Else
              r,←(0∊⍴u)↓⊂'⎕USING←',repObj u
          :EndIf
     
         ⍝ Take care of events if any
          :If 0<⍴events←2 ⎕NQ ref'GetAllEvents'
              r,←⊂'2 ⎕NQ '''' ''SetEventInfo'' ',repObj⊃events
          :EndIf
     
         ⍝ Proceed by nameclass
         ⍝ Variables. We do them first because we need ⎕IO and ⎕ML set to 0
          r,←makeVars ref
     
         ⍝ The namespace system variables
          u←ref.⍎Qvars←' ⎕IO ⎕ML ⎕WX ⎕PP ⎕CT ⎕DIV ⎕RTL',(b←13≤⍎2↑1⊃⎕SE.SALTUtils.APLV)/' ⎕FR'
          diff←(⍴u)↑1 1 1 ⍝ make clear ⎕IO/⎕ML/⎕WX settings
          diff←diff∨0≠u-1 0 3 10 1E¯14 0 0,b/645
          r,←⊂'(',1↓(⊃,/diff/(Qvars=' ')⊂Qvars),')←',repObj diff/u
         ⍝ Starting with 13.2 ⎕RL definition is no longer generated
         ⍝ r,←(u≢7*5)/⊂'⎕RL←',(⍕u),(0≠⍴⍴u←ref.⎕RL)/'⊣{}16807⌶1' ⍝ starting 13.1 ⎕RL may be different
          r,←⊂''
     
         ⍝ Functions - account for Properties
          :If ×⍴obj←ref.⎕NL ¯3 ⍝ only fns for which a proper ⎕CR exists
              adddel←3.1=ref.⎕NC obj
              (in fns)←↓⍉↑adddel ntgenfncode¨ref,¨⊂¨obj
              bad←'⍝ Those objects cannot be recreated:',⍕(u←'⍝'∊¨⊃∘⊃¨fns)/obj
              →failed/⍨u∧fail
              :If nettype>∧/in ⍝ classes may need to be split
             ⍝ There may be other constraints like [total] size or number or lines of code
              :AndIf 0∊in←in∨MAXLINES≥+⌿⌈⌿⍣ItemLINES↑⍴¨(~in)/fns
                  toinclude←path,'_sub.Include'
                  toinclude ⎕NS(path,'.')∘,¨(~in)/obj
                  fns←in/fns
                  r,←(':Include ',toinclude,' ⍝∇⍺ path to include')''
              :EndIf
          :AndIf 0<⍴fns
             ⍝ fns←fns[⎕AV⍋↑⊃¨fns]       ⍝ regroup similar Properties
              drop←(⍳⍴fns)≠{⍵⍳⍵}⊃¨fns
              fns←(-1⌽drop)↓¨drop↓¨fns   ⍝ remove extra lines of each property
             ⍝ Insert spaces to align comments
              fns←{⎕IO←0 ⋄ ' '∨.≠⍵↑⍨c←(,⍵)⍳'⍝':⍵
                  (-5+⍴⍵)↑⍵}¨¨fns
              r,←⊃,/fns,¨⊂⊂''
          :EndIf
     
          :If ×⍴obj←ref.⎕NL ¯4
              adddel←4.1=ref.⎕NC obj
              r,←⊃,/adddel ntgenopcode¨ref,¨⊂¨obj
          :EndIf
     
          :If 0<⍴drop←ref.⎕NL ¯9.2 ¯9.6 ¯9.7 ⍝ instances and forms fail
              r,←(bad←⍕'⍝ ** Those ops cannot be recreated:',drop)''
              →fail/failed
          :EndIf
     
          ⍝ On 09/10/5 the 2 following sections (ns & classes) were reversed
          ⍝ in case the nss are :included
          sub←path,'_sub'
          ref.⎕EX obj/⍨9.1∊ref.⎕NC⊂obj←'SALT_Data' ⍝ remove SALT tag if any
          :For obj :In ref.⎕NL ¯9.1 ¯9.5
              :If nettype
               ⍝ ⎕OR is unusable when 'ref' is (NULL) so we do instead:
                  ⍎(sub ⎕NS''),'.',obj,'←',path,'.',obj
                  r,←⊂obj,'←',sub,'.',obj,' ⍝∇⍺ path for this regular sub namespace'
              :Else
                  bad←0 fail ntgennscode path,'.',obj
                  →failed/⍨fail∧'*'∊bad
                  r,←bad
              :EndIf
          :EndFor
     
          :If 0<⍴obj←ref.⎕NL ¯9.4
              sub←nsname,'_sub'
              b←⍋∊⍴¨⎕CLASS¨cl←ref⍎¨obj ⍝ grab all classes by "least based" order
              :For obj :In cl[b]
          ⍝ If sub NetType namespaces exist they must have been done by now
                  cl←⎕SRC obj
                  cl[⎕IO]↓⍨←u×Auto≡(u←-⍴Auto)↑⎕IO⊃cl ⍝ remove auto marks
                  :If ∨/b←∨/∘('⍝∇⍺'∘⍷)¨cl  ⍝ were there any previous namespace refs?
                      parent←'.',⍨¨¯1↑0 cut 1↓path                   ⍝ parent based?
                      (b/cl)←parent{s[(¯1+⍴⍺)+1⍳⍨⍺⍷s←⍵]←⊂'_sub.' ⋄ ∊s}¨b/cl
                  :EndIf
                  r,←cl,⊂''
              :EndFor
          :EndIf
     
          r,←⊂':End',1↓type
     
          :If fixclass
              :Trap 11
                  (⍎(-1+⍴nsname)↓path).⎕FIX r
                  r←1↓type,path,' created (',(⍕⍴r),' lines)'
              :Else
                  :If {6::0 ⋄ ×⎕SE.SALTUtils.DEBUG}
                      ∘∘∘
                  :Else
                      r←'Unable to create ',1↓type,path
                  :EndIf
              :EndTrap
          :EndIf
      :EndIf
      →0
     failed:r←'*** ',1↓type,path,' failed: ',bad ⍝ return msg
    ∇

    noTag←{1≠⍴⍴⍵:1 ⋄ 326∊⎕dr ⍵:1 ⋄ '⍝∇⍣'≢3↑{(+/∧\' '=⍵)↓⍵}⍵}

    ∇ (inclass body)←del ntgenfncode(path fnname);extra;code;endprop;prop;head;e0;propname;line0;new;info;pf;data
     ⍝ Generate code for a function in a nettype namespace
     ⍝ The fn returns whether a fn should BE in the class (as opposed to be :Included)
     ⍝ and the body of the fn
      inclass←0
      :If 0.3=path.⎕NC⊂,fnname ⍝ derv
          data←⎕SE.Dyalog.Utils.nkds path
          body←,⊂fnname,1⌽')←(',0 ⎕SE.Dyalog.Utils.expr data[(⊃¨data)⍳⊂fnname]
      :Else
          code←code/⍨noTag¨code←path.⎕NR fnname
          :If 3.3∊path.⎕NC⊂fnname
              body←fnname genDfnSrc code
          :Else
              head←⊂fnname{⍵,⍨('{'=1↑⍵)/⍺,'←'}(del/'∇'),⎕IO⊃code
              code←1↓code,del/⊂,'∇'
              info←path getfninfo fnname
              (new extra)←ntgencoloncode info
              inclass←0<⊃⍴extra
              endprop←⍬ ⋄ prop←':Property'
              :If prop≡(⍴prop)↑e0←⊃extra
                  propname←(⍴prop)↓e0
                  head←extra[0],new∘chgfnname¨head
                  extra←1↓extra
                  code←code,⊂':EndProperty ⍝',propname
              :EndIf
              body←head,ACCESS,extra,code
          :EndIf
      :EndIf
    ∇

      genDfnSrc←{⎕IO ⎕ML←0     ⍝ Guess source of derived function. (JS)
     
          trav←{                                  ⍝ traverse, accumulating subtrees.
              ~(,¨2 3)∨.≡⊂⍴⍵:leaf ⍵               ⍝ not a derv or train: done.
              isop 1⊃⍵:{                          ⍝ derived fn:
                  2=⍴⍵:mop ⍵                      ⍝ monadic operator
                  3=⍴⍵:dop ⍵                      ⍝ dyadic operator.
              }∇¨⍵                                ⍝ formatted subtrees.
              leaf ⍵                              ⍝ neither: give up.
          }
     
          mop←{1 ⍵}∘{                             ⍝ operator with one operand.
              (l m)(land oper)←↓⍉↑⍵               ⍝ derived function components.
              land,oper
          }
     
          dop←{1 ⍵}∘{                             ⍝ operator with two operands.
              (l m r)(land oper rand)←↓⍉↑⍵        ⍝ derived function components.
              0=r:land,oper,rand
              land,oper,'(',rand,')'
          }
     
          leaf←{0 ⍵}∘{                            ⍝ format leaf.
              (⊂⍵)∊pfns,pops:⍵                    ⍝ primitive fn/op.
              (⊂⍵)∊,¨pfns,pops:⍵                  ⍝
              '{'≡⊃⍵:,⍵                           ⍝ unnamed dfn
              1∊'←{'⍷⍵:(1+(,⍵)⍳'←')↓,⍵            ⍝ dfn←{...} → {...}
              '⎕'≡⊃⍵:⍵                            ⍝ system fn/op
              1 repObj ⍵                          ⍝ format of array operand
          }
     
          isfn←{                                  ⍝ is function?
              0=≡⍵:⍵∊pfns                         ⍝ primitive function:
              dfnop ⍵:1                           ⍝ dfn:
              ~(,¨2 3)∨.≡⊂⍴⍵:0                    ⍝ not a derv or train.
              isop 1⊃⍵:1                          ⍝ derv.
              ∇⊃⌽⍵                                ⍝ derv or train.
          }
     
          isop←{                                  ⍝ is operator?
              (⊂⍵)∊pops:1                         ⍝ primitive operator:
              (⊂⍵)∊'⎕S' '⎕R':1                    ⍝ system op.
              ~dfnop ⍵:0                          ⍝ not a d-op:
              1∊↑'⍺⍺' '⍵⍵'⍷¨⊂⍵                    ⍝ is a d-op.
          }
     
          dfnop←{'}'≡⊃⌽~∘' ',⍵}                   ⍝ dfn or dop
          pops←{92::⍬ ⋄ ⎕UCS ⍵}9018 9056 9060     ⍝ stencil, variant, rank
          pops,←'/\⌿⍀.¨∘⍨&⍣[@⌶'                   ⍝ primitive ops.
          pfns←{92::⍬ ⋄ ⎕UCS ⍵}8838 9080          ⍝ condencl, where
          pf0←'+-×÷⌊⌈|*⍟<≤=≥>≠∨∧⍱⍲!?~○'           ⍝ primitive fns (scalar).
          pf1←'⊢⊣⌷/⌿\⍀∊⍴↑↓⍳⊂⊃∩∪⊥⊤,⍒⍋⍉⌽⊖⌹⍕⍎⍪≡≢⍷'   ⍝ primitive fns (other).
          pfns,←pf0,pf1                           ⍝ primitive fns.
     
          err←⎕SIGNAL∘11                          ⍝ too hard: give up.
     
          ,⊂⍺,'←',⊃⌽trav ⍵                        ⍝ source of named function ⍵.
      }

    ∇ test;⎕IO;v;b;n;N;nv;ljust
      ⎕IO←1
      #.exNS←⎕NS''
      #.exNS.(a B ∆ CR c L)←'simple string'(3 4⍴'a')(2 5⍴⎕A)(2 3 40⍴⎕A)(12 20⍴'big mat! ')(⎕AV[4],'gfds')
      #.exNS.mix←1,⊂21,⊂2 3 4 5⍴11⍴⎕AV
      #.exNS.matmix←⍳3 6
      #.exNS.matN←4 45⍴⍳99
      #.exNS.matc1←5 49⍴⎕A,⎕AV[⍳4]
      #.exNS.matc2←3 6⍴3 4 5 1 8 9 2 4 7⍴¨⊂⎕A
      #.exNS.matc3←3 4 5 1 8 9 2 4 7⍴¨⊂⎕A
      #.exNS.matc4←⎕AV[???9999⍴⍴⎕AV]
      #.exNS.matc5←⎕AV[⎕IO+0 79 0],'????´    Í!??LÍ!'⎕AV[1+0 0 0 0 1 0],'??'
      #.exNS.matc6←'MZ?',⎕AV[⎕IO+0 58 0 0 0 91 0 0 0],'??',⎕AV[⎕IO+0 0 255 0 0 0 0 0 0 0 0 0 0],'?î?',⎕AV[⎕IO+0 75 0 0 0],'????´    Í!??LÍ!',⎕AV[1+0 0 0 0 1 0],'??',⎕AV[⎕IO+0 0 0 0 0],'?î?',⎕AV[⎕IO+0 25 3 3 2 61 0 0 0 0 0 0 0],'PE',⎕AV[⎕IO+0 0],'L??Ì^iK',⎕AV[⎕IO+0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 140 0],'?!??',⎕AV[⎕IO+1 0 0],'Ð?',⎕AV[⎕IO+0 4 0],'þî?',⎕AV[⎕IO+0 0 4 0 0 0 0 1 0 0 0 225 0 0],'çí',⎕AV[⎕IO+1 0 58 0],'@'
      #.exNS.matc7←'    ⌶ɫ%' '┼─├┤┴┬',⎕D,'┼─├┤┴┬┼─├┤┴┬' 'yz¯.⍬0YZý·⍙'
      #.exNS.v1←1 3 2 1 0 2 1 1 2 3 4 1 0 1 7 8 9 10 1 0 1 5 4 3 2 1 0
      #.exNS.v2←(⍳3),99 55 1,(⍳7),⍳3
      #.exNS.v3←(⍳3),99 55 1,⍳3
      #.exNS.v4←(⍳8),99 55 1,⍳3
      #.exNS.v5←(⍳8),99 5 5 1,⍳5
      #.exNS.v6←1 3 2 1 0 2 1,(¯1+⍳8),1 0 1 6 7 8 9 1 0 1 6 5 4 3 1 0
      #.exNS.v7←(⍳8),⍳3
      #.exNS.v8←⍳9
      #.exNS.v9←⍳3
      #.exNS.va←⍳¨⍳8
      #.exNS.vb←⊃,/⍳¨⍳8
      #.exNS._m1←⎕VR'Convert'
      #.exNS._m2←⎕CR'example'
      #.exNS._m3←⎕NR'extract'
      #.exNS._m4←⎕VR'cencl'
      #.exNS._←⎕AV[3+⎕IO]
      #.exNS.⎕FX ⎕CR'Convert'
      #.exNS.⎕FX'{(a b c)}←A(B C)D;E' 'a b c←A B C'
      #.exNS.f1←+
      #.exNS.f2←+∘3
      #.exNS.f3←+.×∘(-.=)
      #.exNS.f4←/⍨
      #.exNS.f5←+/
      #.exNS.f6←,∘(⍳3)(2 3⍴⍳6)¨⍣(∧.=)⍨
      #.exNS.ff←','∘, ⍝ FAIL!
      #.exNS.fg←(','∘,)∘+/¨ ⍝ FAIL!
      #.exNS.d1←{⍵}
      #.exNS.d2←{⍵ ⍵}
      #.exNS.d3←{⍺←1
          ⍵ ⍺}
      #.exNS.d4←{⍵ ⍺⍺ ⍵}
      {}ntgennscode #.exNS
      #.exNS.⎕DF'#.exNS'
      'exNS0'#.⎕NS ⎕OR'#.exNS'
      ⎕IO←0
      Convert #.exNS
      {}÷(#.exNS0.⎕NL⍳9)≡#.exNS.⎕NL⍳9
      v←#.exNS.⎕NL-2
      :If 0∊b←(#.exNS0⍎¨v)≡¨#.exNS⍎¨v
          ⎕←'*** Var'(v/⍨~b)'are different'
      :EndIf
      n v←#.exNS.({⍵(⎕CR¨⍵)}⎕NL-3) ⋄ N←'some'
      :If b←(⍴v)≠⍴1⊃(nv nv)←#.exNS0.({⍵(⎕CR¨⍵)}⎕NL-3)
          N←n ⋄ ljust←{(0,-⊥⍨' '∧.=m)↓m←(+/∧\m∊' ')⌽m←⎕FMT ⍵}
      :OrIf 1∊b←(ljust¨v)≢¨ljust¨nv
          ⎕←'*** Fn'(N/⍨b)'are different'
      :EndIf
     
    ∇

    ∇ test1var
      #.⎕EX'exNS' ⋄ '#.exNS'⎕NS'' ⋄ #.exNS.cv←'dsa',⎕AV[3],'ewq'
      Convert #.exNS
      ↑⎕SRC #.exNS
      '================'
      #.⎕EX'exNS' ⋄ '#.exNS'⎕NS'' ⋄ #.exNS.cm←12 15⍴'idis lipus '
      Convert #.exNS
      ↑⎕SRC #.exNS
      '================'
      #.⎕EX'exNS' ⋄ '#.exNS'⎕NS'' ⋄ #.exNS.vtv←33⍴'asdsa' 'djjj j jmmmmmdsadnmklad d wqwje wq sa' 'aewq'
      Convert #.exNS
      ↑⎕SRC #.exNS
    ∇

:EndNamespace ⍝ NStoScript  $Revision: 1516 $
