﻿:Namespace  ⍙⍙

    Version←1.21

    (⎕IO ⎕ML ⎕CT)←1 2 1E¯13
    C←⎕av[4]
    APLsCovered←'APL2PC APLX APLC' 'APL2MF' 'DYALOG' 'APLPLUS' 'VSAPL' 'STSCMF'

    _←⍬
    _,←⊂'This code is used to transfer simple objects to/from ATF files.'
    _,←⊂'Version ',2⍕Version
    _,←⊂''
    _,←⊂'To use it do'
    _,←⊂'  ⍙⍙.ATFIN ''filepath[.atf] -alphabets=aAA -APL=aaa''  '
    _,←⊂''
    _,←⊂'where APL can be any of the strings found in ⍙⍙.APLsCovered.'
    _,←⊂'-alphabets= indicates what lowercase, uppercase and underscored characters are translated to.'
    _,←⊂''
    _,←⊂'The global variable PROBLEMS is used to capture objects that cannot'
    _,←⊂'be handled.'
    _,←⊂''
    _,←⊂'The global char vector ⍙⍙.Translate contains the map from the source'
    _,←⊂'⎕AV to DYALOG''s ⎕AV. ⎕AV[N] in the source APL becomes ⎕AV[⍙⍙.Translate[N]]'
    _,←⊂'in DYALOG. This table would be slightly different for APL2MF, but that has been disabled.'
    _,←⊂'If no -APL is supplied the program will attempt to guess the source'
    _,←⊂'APL but there is no guaranty this will work.'
    _,←⊂''
    _,←⊂'To send a ws to file use'
    _,←⊂'   ⍙⍙.ATFOUT ''filepath[.atf] -objects=...'''
    _,←⊂''
    _,←⊂'If you have any problems with this code, then please'
    _,←⊂'direct your enquiries to whoever supplied your copy of Dyalog APL.'
    DESCRIBE←{⎕ml←0⋄↑⍵}_

    _ ←   0   8  10  13  32   1   2   3   4   9 159   5  37  39 224 249  95  97  98  99 100 101 102 103 104 105 106 107 108 109 110 111
    _,← 112 113 114 115 116 117 118 119 120 121 122   6   7 253  46  11  48  49  50  51  52  53  54  55  56  57  12 214  15  36 156  16
    _,← 182  65  66  67  68  69  70  71  72  73  74  75  76  77  78  79  80  81  82  83  84  85  86  87  88  89  90  17  18  19  20  21
    _,← 247  22  23  24 128  25  26  27 141  28  29  30  31 127 158 166 167 170 171 219 176 177 178 222 185 149 186 123  14 125 215 211
    _,← 254 187 142 143 188 200 201 165 153 202 154 225 133 160 131 132 134 204 135 138 130 136 137 161 140 139 164  91  47 240  92 241
    _,←  60 243  61 242  62 244 235  94  45  43 246 245  63 238 230 126 198 199 236 234  42 169 190 183 248  40 226 227 239 172 157 152
    _,← 124  59  44 231 229 252 251 237 232 233 181 146  33 174 175 250 205 207 206 162 147 148 155  34  35 208  38 210 217 191 218 192
    _,← 197 196 195 180 193 194 179  64 151 163 150 212 129  96 221 213  58 209 168 173 216 189 184 228  41  93 220 223 203 144 145 255
    Translate←_

    _←    0  37  21  22  64   1   2   3   4   5 218   6 108 125 176 180 109 129 130 131 132 133 134 135 136 137 145 146 147 148 149 150
    _,← 151 152 153 162 163 164 165 166 167 168 169   7   8 160  75   9 240 241 242 243 244 245 246 247 248 249  10  11  12  91 123  74
    _,← 187 193 194 195 196 197 198 199 200 201 209 210 211 212 213 214 215 216 217 226 227 228 229 230 231 232 233  13  14  15  16  17
    _,← 252  65  66  67  68  69  70  71  72  73  81  82  83  84  85  86  87  88  89  98  99 100 101 102 103 104 105 192  18 208  19  20
    _,← 114  23  24  25  26  27  28  29  30  31  32  33  34  35  36  38  39  40  41  42  43  44  45  46  47  48  49 173  97 234 183 235
    _,←  76 140 126 174 110 190 120 113  96  78 184 182 111 177 179 128 138 139 178 157  92 141 142 186 175  77 155 154 170 171 172 188
    _,←  79  94 107 203 202 220 221 207 205 237 253 238  90 239 254 251  50 225  51  52  53  54  55 127  56  57  80  58  59  60  61  62
    _,←  63  95 112 115 116 117 118 124 119 156 158 161 181 121 106 185 122 191 204 206 219 159 143 223  93 189 224 236 250 144 222 255
    VSAPL←_

    ⎕ex¨ 'C_'

    ∇ {Target}ATFIN arg;Filename;POS;TXT;NM;DUFF;Filenum;Block;SCRIPT;⎕ML;more;TR;t;Pa;sc;len;BlockSizes;GotObjects
     ⍝ Transfer in from an ATF file produced by e.g. )OUT on IBM
     ⍝ All system variables are saved at the end.
     ⍝ All system variable changes saved in QuadThings
     ⍝ Anything that won't fix is saved in PROBLEMS
     ⍝
      ⎕IO←1 ⋄ ⎕ML←1                               ⍝ DO NOT CHANGE ⎕IO!
      t←1↓t,ToLower t←∊' ',¨APLsCovered
      Pa←(⎕NEW ⎕SE.Parser,⊂('-alphabets:aAa -apl=',t)'upper').Parse arg
      Filename←(1⊃Pa.Arguments){⍺,(~'.'∊⍺)/⍵}'.atf'⍝ append extension if none there
      BlockSizes←⍬
     
     Try:
     ⍝ We try to determine the width of the 'records' - should be a multiple of 80 to 84
      (Filenum BlockSizes)←Pa OPEN(Filename BlockSizes)
      Block←(0,1↑BlockSizes)⍴''
      SCRIPT←0 72⍴PROBLEMS←QuadThings←''
      :If 0=⎕NC'Target' ⋄ Target←# ⋄ :EndIf
      CTarget←(⍕Target),'.'                       ⍝ where do we have to define these objects
      'Cannot define objects in this namespace'⎕SIGNAL 11 if Target≡⎕THIS
      ⎕WSID←{((0∊b)×-1+⊥⍨b←'.'≠⍵)↓⍵}Filename      ⍝ change ws here to avoid overwriting the original
      more←1
      GotObjects←0
      :While more
          :If (POS←⌊/SCRIPT[;1]⍳'Xx')≤⊃⍴SCRIPT    ⍝ Got some to be getting on with
              TXT←,0 1↓SCRIPT[⍳POS;]              ⍝ Extract block of text (drop X column)
              SCRIPT←(POS,0)↓SCRIPT               ⍝ And throw away from script
              :Select ⍬⍴TXT                       ⍝ What are we dealing with?
              :CaseList 'ACNacn'   ⍝ Variable
                  :If '⎕'=TXT[2]                  ⍝ If it is a system object
                      QuadThings,←⊂TXT            ⍝ then save it until later
                  :Else
                      CHARFN TXT
                  :EndIf
              :CaseList 'fF'                      ⍝ Function; it may use ⎕FX or not
                  NM←1↓(t←TXT⍳' ')↑TXT ⍝ What's its name?
                  :If ∨/'⎕fx'⍷⎕SE.SALTUtils.lCase TXT ⍝←CORRECT TXT ⍝ CORRECT does not seem to be needed
                      t←¯1+TXT⍳'⎕'                    ⍝ where does ⎕FX start
                      TXT←t↓TXT                       ⍝ Throw away any left arg of ⎕FX
                      :If ⍱/0 2∊10|⎕DR⍎CTarget,TXT    ⍝ Execute it - check for error
                          ⎕←'   Function: ',NM,'   *** FAILED ***' ⍝ Tell user about the problem
                          PROBLEMS,←⊂TXT              ⍝ and save copy of text
                      :Else
                          ⎕←'   Function: ',NM
                      :EndIf
                  :Else ⍝ is RANK, SHAPE, CODE
                      len←55⌊⍴TXT←(1+⍴NM)↓TXT
                      sc←⍴t←(∧\TXT[⍳len]∊' ',⎕D)/len↑TXT  ⍝ separate Rank/Shape from code
                      t←2⊃⎕VFI t
                      :If (1↑t)≠¯1+⍴t
                      :OrIf ⍱/0 2∊10|⎕DR Target.⎕FX(1↓t)⍴sc↓TXT,'    '
                          ⎕←'   Function: ',NM,'   *** FAILED ***'
                          PROBLEMS,←⊂TXT              ⍝ and save copy of text
                      :Else
                          ⎕←'   Function: ',NM
                      :EndIf
                  :EndIf
              :Else
                  -⎕←'Invalid TYPE or format in file'
              :EndSelect
              GotObjects←1
          :Else
             ⍝ We don't have a block. Try to get next block from file. If sucessful continue
             ⍝ processing, otherwise stop as we have reached end of file. Ignore * lines.
              more←~0∊⍴SCRIPT⍪←{(⍵[;1]≠'*')⌿⍵}(Pa.ALPHABETS GETNEXTBLOCK 500)[;⍳72]
          :EndIf
      :EndWhile                                   ⍝ Repeat for next block
     
      ⎕NUNTIE Filenum
     
      :If GotObjects<1<⍴BlockSizes
          ⎕←'Nothing was defined using block size: ',⍕1↑BlockSizes
          BlockSizes←1↓BlockSizes 
          →Try
      :EndIf
     
      CHARFN¨Target.QuadThings←QuadThings
      ⎕←'SUCCESS:'
      :If '*'∊4⍴⎕STACK
          ⎕←'   ⎕EX ''⍙⍙'' ⍝ to remove the transfer objects'
      :EndIf
      ⎕←'      ⎕SAVE ''',((⊢↓⍨0-'.'⍳⍨⌽)Filename),''' ⍝ to save as Dyalog Workspace'
      ⎕←'      ↑QuadThings ⍝ to see the systems variables modified'
      →(0∊⍴PROBLEMS)↑0
      ⎕←'      ↑PROBLEMS ⍝ to see unfixed objects'
      Target.PROBLEMS←PROBLEMS
    ∇

    ∇ code←CORRECT code;by;c
      :For c by :In 'Ó←' 'Ú→' 'Ã↑' 'È↓' 'Í⌊' 'Ð∇'
          ((code=c)/code)←by
      :EndFor
    ∇

    ∇ CHARFN TXT;⎕TRAP;RANK;SHAPE;DATA;i;n;TYPE;NM
     ⍝ TXT is the transfer file string that represents one variable.
     ⍝ This function creates the variable in the workspace.
      →0 if' '∧.=TXT ⍝ cover null case
      :Trap 0
          i←{⎕IO←1 ⋄ ⍺⍳⍵} ⍝ because we can't trust ⎕IO to be 1
          NM←1↓¯1↓((TXT∊'← ')i 1)↑TXT  ⍝ What's its name?
          :If 'Aa'∊⍨TYPE←1↑TXT
              Target Execute 1↓TXT
          :Else
              DATA←(TXT i' ')↓TXT
              SHAPE←'⍬⍴' ⋄ RANK←⍎(n←DATA i' ')↑DATA
              DATA←n↓DATA
              :If 0<RANK
                  n←RANK i⍨+\' '=DATA
                  SHAPE←'⍴',⍨n↑DATA
                  DATA←n↓DATA
              :EndIf
              Target Execute NM,'←',SHAPE,('NncC'⍳TYPE)⊃2/(DATA,',⍬')((⍕⎕THIS),'.DATA')
          :EndIf
          ⎕←'   Variable: ',NM
      :Else
          ⎕←'   Variable: ',NM,'   *** FAILED ***'
          PROBLEMS,←⊂('(',1↑TXT),') ',1↓TXT
      :EndTrap
    ∇

    ∇ tns Execute exp
    ⍝ Execute expression including large ones
    ⍝ tns is the target namespace. exp is the expression to execute in the target ns
    ⍝ We first try ⍎ if that fails because of a limit error we try to do it piecemeal.
      :Trap 10
          tns⍎exp
      :Else
          :If 0∊⎕NC'bigstring' ⋄ bigstring←⎕SE.SALT.Load'tools/code/bigstring -noname' ⋄ :EndIf
          tns bigstring.execute exp ⍝ this better work
      :EndTrap
    ∇

    ∇ BLOCK←aAÁ GETNEXTBLOCK LINES;⎕IO;LCOUNT;BL;colw;from;to;unique;WithAll;UntilZ;WholeSet;DiffOnly
     ⍝ For translating from .ATF files (e.g. produced by APL2 ')OUT')
     ⍝ into Dyalog APL (ASCII)
     ⍝ BLOCK will always have 80-83 columns and 0+ rows, unless the end
     ⍝ of the input file has been reached (then 0 rows).
     ⍝ Block, TR, Filenum are global.
     ⍝
      ⎕IO←0
      colw←1↓⍴Block                  ⍝ Block acts as a buffer
      :If LINES>1↑⍴Block             ⍝ has Block enough lines to meet request?
          BL←⎕NREAD Filenum,82,LINES×colw
          BL←((⌊(⍴BL)÷colw),colw)⍴BL ⍝ and reshape to lines of 80 to 83
          Block⍪←BL                  ⍝ buffer it
      :EndIf                         ⍝ Return what is asked for if possible
      BLOCK←((LCOUNT←LINES⌊1↑⍴Block),colw)↑Block
      Block←(LCOUNT,0)↓Block
     
      ⍝ Alphabets' conversion
      unique←∪,BLOCK
      WithAll←unique,⍨∊
      UntilZ←{'Á'=⍵:⎕Á ⋄ ⎕UCS(⍳26)+⎕UCS ⍵}
      WholeSet←WithAll UntilZ¨
      DiffOnly←≠/(/¨)⊢
      from to←WholeSet¨DiffOnly'aAÁ'aAÁ
      BLOCK←to[from⍳BLOCK]
    ∇

    ∇ (Filenum BS)←Pa OPEN(File BlockSizes);⎕TRAP;EM;sz;t;TR
      ⎕←'PROCESSING "',File,'" (',(⍕sz←⎕NSIZE Filenum←File ⎕NTIE 0),' bytes):'
      :If 0∊⍴BlockSizes
          :If 0∊⍴t←{(0=s|⍵)/s←79+⍳5}sz
              ⎕←'Unable to determine block size, trying with ',⍕BS←,80
          :Else ⍝ if more than 1 favor 82 then 80
              :If 1≠⍴t
                  ⎕←'Ambiguous block sizes (',(⍕t),'), attempting:',1↑t←t[⍒2 1+.×82 80∘.=t]
              :EndIf
              BS←t
          :EndIf
      :Else
          ⎕←'Attempting block size: ',⍕1↑BlockSizes
          BS←BlockSizes
      :EndIf
      TR←Pa SetTR Filenum,1↑BS               ⍝ Set up translation
      TR ⎕NXLATE Filenum
    ∇

    ∇ tr←la SetTR(fn bs);apl;i;⎕IO;n
     ⍝ Find translation to apply from looking at the file if no APL specified.
      ⎕IO←0
      :If 0≡la.APL
        ⍝ Find signature: read 1st few 100 bytes
          n←⍴i←⎕NREAD fn 83,2↑1+bs×21
          :Select {(>/⍵)⌽⍵}∪i[bs×⍳⌈n÷bs]~42 92 180 ⍝ remove *s
          :CaseList (⊂i),,¨i←32 88 ⋄ apl←'APL2PC'
          :CaseList (⊂i),,¨i←¯25 64 ⋄ apl←'APL2MF'
          :CaseList (⊂i),,¨i←4 88 ⋄ apl←'DYALOG'
          :Else ⋄ 'unknown APL'⎕SIGNAL 11
          :EndSelect
        ⍝ Reset file read pointer to beginning
          {}⎕NREAD fn 83 0 0
      :Else ⍝ ensure uppercase
          apl←ToUpper la.APL
      :EndIf
      tr←Translate
      :If apl≡'APL2MF'
     ⍝ There should be a special table for APL2MF here but fn <CORRECT> does the trick instead
          tr←VSAPL
      :EndIf
     ⍝ Reverse underscored letters and lowercase letters?
⍝      :If la.FLIPLU=(⊂apl)∊'APL2PC' 'APL2MF' ⍝ 'flip' reversed for this APL
⍝          tr[i]←26⌽tr[i←⎕AV⍳LC,⎕Á]
⍝      :EndIf
    ∇

    LC←'abcdefghijklmnopqrstuvwxyz'
    ToLower←{⎕IO←0 ⋄ b←26>i←⎕A⍳s←,⍵ ⋄ (b/s)←LC[b/i] ⋄ s}

    ToUpper←{⎕IO←0 ⋄ b←26>i←LC⍳s←,⍵ ⋄ (b/s)←⎕A[b/i] ⋄ s}

    if←/⍨

    ∇ testws;valid;allfns;dubious;chk
    ⍝ This fn verifies that no character has been missed when importing
    ⍝ code. To do so it screens out all the characters it knows are valid.
      valid←⊂LC,' ;:@#,.-[]{}/⋄!"£$%^&*()_+¨¯<≤=≥>≠∨∧×÷≡⍫⍒⍋⌽⍉⊖⍟⍱⍲⌹?⍵∊⍴~↑↓⍳○*←→↑↓⌶⍣⍞⍬⍺⌈⌊_∇∆∘''⎕⍎⍕⍺⌈⌷≡⍪≢⊢⊂⊥⊤|⍝⍀⌿⊣⊃∩∪⍷⍙⍨',⎕A,⎕D
      :If 0∊⍴allfns←⎕RSI[⎕IO].⎕NL-3 4
      :OrIf ∧/~chk←0≠∊⍴¨dubious←valid(⎕RSI[⎕IO]).{∪(,⎕CR ⍵)~⍺}¨allfns
          ⎕←'Nothing to report'
      :Else
          ⎕←'These functions have dubious characters:'
          ⎕←chk⌿allfns,[1.1]dubious
      :EndIf
    ∇

 ⍝   =====================      OUT code     =====================

    ∇ {source}ATFOUT arg;OBJS;obj;fn;class;state;⎕IO;⎕ML;val;n;X;Pa
⍝ arg is a string of filename possibly followed by -objects=...
⍝ If omitted, all objects are re-constituted.
⍝
      ⎕ML←⎕IO←1
      Pa←(⎕NEW ⎕SE.Parser,⊂'-objects=' 'upper').Parse arg
      fn←OUTINIT 1⊃Pa.Arguments
⍝ If no names explicitly chosen, transfer everything in WS.
⍝ We need to find where the objects are to start with. We cannot assume this ns was copied in a ws and used
⍝ from there, it could be called from Spice way down the stack in some unknown ns.
      :If 0=⎕NC'source' ⋄ source←⍎(⍴⎕NSI)⊃⎕NSI ⋄ :EndIf
      :If 0≡OBJS←Pa.OBJECTS
          OBJS←'⎕CT' '⎕IO' '⎕LX' '⎕PP' '⎕PW'
          OBJS,←source.⎕NL-2.1 3.1 4.1 ⍝ only traditional objects transferred to other systems
      :Else
          OBJS←{(1↓¨(⍵∊' ,')⊂⍵)~⊂''}' ',OBJS
          'Invalid object (vars & fns only)'⎕SIGNAL 11 if~∧/(⌊source.⎕NC OBJS)∊2 3 4
      :EndIf
     
      :For obj class :InEach OBJS(source.⎕NC OBJS)
⍝ Find the basic representation to recreate a variable
          :If class=¯1 ⍝ ⎕var ?
              :If '⎕'∊1↑obj
                  val←source⍎obj
              :Else
                  ⎕←obj,' skipped.' ⋄ :Continue
              :EndIf
              val←obj makeVal val
          :ElseIf class=2.1 ⍝ var
              val←obj makeVal source⍎obj
          :Else ⍝ must be a fn/op
              val←'F',obj,' ⎕FX ',⎕SE.Dyalog.Utils.repObj source.⎕NR obj
          :EndIf
⍝ Append representation in antiquated 80 column card format a la IBM
          X←'X'↑⍨-n←⌈(⍬⍴⍴val)÷71 ⋄ val←(X,n 78↑n 71⍴(n×71)↑val),n 3⍴⎕AV[185 4 3]
          val ⎕NAPPEND fn,82
      :EndFor
     
      ⎕←'Job completed. File size=',⍕⎕NSIZE fn
      ⎕NUNTIE fn
    ∇

    ∇ str←name makeVal val;dr;⎕PP
    ⍝ Make a string representation of a value
      ⎕PP←18
      :If 2|dr←⎕DR val ⍝ numeric?
          str←'N',name,(0⍕(⍴⍴val),⍴val),,' ',⍕val
      :ElseIf (10|dr)∊0 2  ⍝ character?
          str←'C',name,(0⍕(⍴⍴val),⍴val),' ',,val
      :Else ⍝ must be an array
          str←'A',name,'←',⎕SE.Dyalog.Utils.repObj val
      :EndIf
    ∇

    OutXlt←⍬ ⍝ this is a better outgoing translation table for APL2000 - unused for now
    OutXlt,←  0   8  10  13  32  12 124   7  27   9 128 142  37  39 224  23  95  97  98  99 100 101 102 103 104 105 106 107 108 109 110 111
    OutXlt,←112 113 114 115 116 117 118 119 120 121 122 144 153 253  46  22  48  49  50  51  52  53  54  55  56  57 154  29 157  36 156 155
    OutXlt,←145  65  66  67  68  69  70  71  72  73  74  75  76  77  78  79  80  81  82  83  84  85  86  87  88  89  90 165 174 172 183 127
    OutXlt,←241 193 194 195 199 200 202 203 204 205 206 207 208 210 211 212 213 217 218 219 221 175 228  18 176  21 170 123   2 125  28 169
    OutXlt,←  5 192 196 197 198 159 201 209 214 216 220 225 133 160 131 132  16  17 135 138 130 136 137 161 140 139 164  91  47 235  92 167
    OutXlt,← 60 243  61 242  62 134 250 177  45  43 246 146  63 238 251 126  24  25 226 249  42 141 143 236 248  40  11  14 239 252 230 231
    OutXlt,←254  59  44 229 234  31  30 237 232 233  15 152  33 244 245  19 158 240 178 162 147 148 171  34  35 179  38 180 181 184 185 186
    OutXlt,←187 188 189 190 191 215 222  64  20 163 150  94 129  96 223 182  58   3 168 173   4   6  26 166  41  93 227 247   1 149 151 255

    ∇ num←OUTINIT Filename
⍝ Create/rewrite file
      Filename←(-⊥⍨' '=Filename)↓Filename
      Filename←Filename{⍺,(⍵≢(-⍴⍵)↑⍺)/⍵}'.atf'
      :Trap 22
          num←Filename ⎕NCREATE 0
      :Else
          :Trap 0
              num←0 ⎕NRESIZE Filename ⎕NTIE 0
          :Else
              'Cannot create file ',Filename,' :',⎕EM ⎕EN
              →
          :EndTrap
      :EndTrap
      Translate ⎕NXLATE num
    ∇

:EndNamespace ⍝ ⍙⍙  $Revision: 1815 $
