﻿:Namespace special
⍝ Special User Commands

    ⎕IO←1 ⋄ ⎕ML←1

    ∇ r←List
      r←⎕NS¨4⍴⊂⍬
   ⍝ Name, group, short description and parsing rules
      r.Name←'scanforClassic' 'change_characters' 'dumpws' 'ctrlstruct'
      r.Group←⊂'special'
      r[1].Desc←'scan for Unicode characters in the workspace'
      r[2].Desc←'change underbar characters'
      r[3].Desc←'create a memory dump of the current APL process'
      r[4].Desc←'detect control structures missing a diamond'
      r.Parse←'' '' '1' '-folder= -types='
    ∇

    ∇ r←Run(Cmd Input);regex
      :If Cmd≡'scanforClassic'
          r←ScanForUnicode ##.THIS
      :ElseIf Cmd≡'change_characters'
          ##.THIS replaceÁby Input
          r←''
      :ElseIf Cmd≡'ctrlstruct'
          regex←'"(?i:(''[^'']*''|⍝.*$)?(?(-1)(*SKIP)(?!)' ⍝ insensitively: look for a string or a final comment; if found skip it,
          regex,←'|(?<!^)(?<![ ⋄:]) (:(?!in|ba)\w+)))"' ⍝ else look for SPACE-COLON not at the beginning of a line and not preceded by SPACE, ⋄ or :, followed by a word not beginning by in or ba(se)
          r←⎕SE.UCMD'file.find ',regex,' -regex ',Input.Propagate'folder types'
      :Else
          r←2 ⎕NQ'.' 'dumpws',Input.Arguments
      :EndIf
    ∇

    ∇ r←level Help Cmd;⎕ML
      ⎕ML←1
      :If Cmd≡'scanforClassic'
          r←'This command allows you to find characters that may cause problems in a Classic environment'
      :ElseIf Cmd≡'change_characters'
          r←⊂'This command allows you to change underbar characters by characters in another alphabet.'
          r,←⊂'The argument is the the letter "a" to replace by the lowercase alphabet or the letter "A" for the uppercase alphabet.'
          r,←⊂'You can also add a prefix if you wish, for example, doing'
          r,←⊂'   ]',Cmd,' ∆a'
          r,←⊂'will replace all words beginning with the 3rd alphabet by the 1st one (the lowercase) preceded by "∆".'
      :ElseIf Cmd≡'ctrlstruct'
          r←'This command allows you to find where code with control structures is missing diamonds (⋄) between :Words.' ''
          r,←'For example the line' '[...] :if 1 ⋄ 2 :endif' 'is wrong and should be fixed.' ''
          r,←'The statement' '      ]ctrlstruct  -folder=\mysite  =types=dyalog,mipage'
          r,←⊂'will find all the incorrect lines in files with extension dyalog or mipage in folder \mysite recursively.'
      :Else
          r←⊂'This command will dump the current workspace into a file which can be analyzed later on. This is used only when Dyalog''s support requests it.'
      :EndIf
    ∇

    ∇ list←ScanForUnicode NS;ns;fn;cr;ok;vn;var;⎕ML;src
⍝ Report any objects with chars not in ⎕AV as these won't copy into Classic.
⍝ Takes a namespace as argument.
⍝ Returns 2-column matrix with namespace.object name and distinct uncopyable chars
⍝ ACDS Dec 2007, modified by DanB
      ⎕ML←1 ⋄ ns←⎕SE.SALTUtils.DF NS ⋄ list←0 2⍴''
      :For vn :In '⎕dm' '⎕trap' '⎕lx' '⎕dmx',(NS⍎'⎕NL')¯2
          var←,⍕∊NS⍎vn
          :If ~0∊⍴cr←∪var~⎕AV
              list⍪←(ns,'.',vn)cr
          :End
      :End
     
      :For fn :In NS.⎕NL-3 4
          cr←,⍕NS.⎕CR fn
          :If ~0∊⍴cr←∪cr~⎕AV
              list⍪←(ns,'.',fn)cr
          :End
      :End
     
      :For ns :In NS.({0∊⍴⍵:⍬ ⋄ ⍎⍕⍵}⎕NL-9.1 9.4 9.5)
          :If 0≡src←{0::0 ⋄ ⎕SRC ⍵}ns
              list⍪←ScanForUnicode ns
          :Else
              :If ~0∊⍴cr←∪(,⍕src)~⎕AV
                  list⍪←(⍕ns)cr
              :EndIf
          :EndIf
      :End
    ∇

    ∇ str←checkAlphabets ns;sc;n;last;cut
     ⍝ Check code to see if the 3 alphabets and other special characters are used
      sc←,' ',⍪'∆⍙_abcdefghijklmnopqrstuvwxyz',⎕A,⎕Á,last←'ÀÄÅÆÉÑÖØÜßàáâäåæçèéêëíîïñóôöøùúûü'
      cut←∊(3,(3⍴26),⍴last)↑¨1
      n←⍕+/¨cut⊂+/1 1↓ns ⎕SE.UCMD'locate ',sc,' -exclude=tc -return=count -object=~',⍕⎕THIS
      str←'The ∆⍙_, a-z, A-Z, Á-õ (⎕Á) and À-ü characters are used in ',n,' places.'
    ∇

    ∇ {ns}replaceÁby scheme;az;replaceby;prefix;replstr;this;cns;vars;b;newvars
    ⍝ Replace the ⎕Á alphabet by another
    ⍝ Warning: the replacement of this alphabet by another may create conflicts
    ⍝ if the names generated already exist.
    ⍝ The argument is
    ⍝ 'a': replace by lowercase letters
    ⍝ 'A': replace by uppercase letters
    ⍝ If a prefix is wanted add it to the letter (a or A) above
    ⍝ Ex.:  replaceÁby '∆_A' will replace ÖØÜ by ∆_HIJ
      :If 0=⎕NC'ns' ⋄ ns←⎕IO⊃⎕RSI ⋄ :EndIf
      az←'abcdefghijklmnopqrstuvwxyz'
      replaceby←('aA'⍳¯1↑scheme)⊃az ⎕A
      this←{(-⊥⍨'.'≠⍵)↑⍵}⍕⎕THIS
    ⍝ Start by replacing all occurences by the prefix if so desired:
      :If ~0∊⍴prefix←¯1↓scheme
          {}ns ⎕SE.UCMD'locate (?<![⎕',az,⎕A,⎕Á,'])([',⎕Á,']) ',prefix,'\1 -replace -pattern -exclude=tc -objects=~',this
      :EndIf
    ⍝ Replace all other occurences by the new alphabet
      replstr←∊' ',¨⎕Á,⍪replaceby
      ns ⎕SE.UCMD'locate ',replstr,' -replace -objects=~',this
    ⍝ Replace variables in namespaces
      :For cns :In ns,childrenNss ns
          :If ~0∊⍴vars←vars⌿⍨∨/⎕Á∊⍨vars←cns.⎕NL 2
              b←vars[;1]∊⎕Á
              newvars←,' ',(↑b\⊂prefix),vars
              b←newvars∊⎕Á
              (b/newvars)←replaceby[⎕Á⍳b/newvars]
              cns⍎newvars,'←',,' ',vars
           ⍝ Erase any name containing 3rd alphabet characters
              cns.{⎕EX(∨/n∊⎕Á)⌿n←⎕NL⍳10}0
          :EndIf
      :EndFor
    ∇

    ∇ chns←childrenNss ns
    ⍝ Return the list of children namespaces
      :If ~0∊⍴chns←ns.⎕NL ¯9.1
      :AndIf ~0∊⍴chns←ns{(⍺=⍵.##)/⍵}ns⍎⍕chns
          chns,←∊childrenNss¨chns
      :EndIf
    ∇
    
:EndNamespace ⍝ ScanU  $Revision: 24063 $