﻿:Namespace APLcart ⍝ v2.08
⍝ 2021 02 04 Adam: Initial code
⍝ 2021 02 25 Adam: Trap errors when opening browser/CEF
⍝ 2021 03 24 Adam: Move API to ⎕SE.Dyalog.Utils.APLcart
⍝ 2021 04 01 Adam: Fix missing var when not refreshing
⍝ 2021 05 11 Adam: Spell ucmd APLCart, new desc
⍝ 2021 06 02 Adam: Use RIDE Browser if avail
⍝ 2021 11 04 Adam: contact info
⍝ 2022 01 31 Adam: Over 3000
⍝ 2022 02 08 Adam: show refresh msg when only refreshing
⍝ 2022 03 15 Adam: "⍝" between expression and description
⍝ 2022 04 06 Adam: insert missing space in help, truncate legend to ⎕PW

    ⎕IO←1 ⋄ ⎕ML←1

    nl←⎕UCS 13

    desc←'Access a searchable collection of over 3000 short APL phrases'
    syntax←'[<terms>] [-list[=n]] [-url] [-browser] [-popup] [-theme=b|w] [-refresh]'

    ∇ r←List
      r←⎕NS ⍬
      r.Name←'APLCart'
      r.Group←'Tools'
      r.Desc←desc
      r.Parse←'99S -browser -popup -theme=b w g -list[∊]0123456789 -url -refresh'
    ∇

    ∇ r←Run(cmd input);legend;list;help;n;url;msg;lines;hr;args;fmt;limit;theme;entries
      list←0≢input.list
      args←×≢input.Arguments
      fmt←1
     
      r←0⍴⊂''
      :If input.refresh
          entries←⍕≢⎕SE.Dyalog.Utils.APLcartTable 1
          r←'Cache refreshed (',entries,' entries)'
      :EndIf
      :If input.url∨input.browser∨input.popup∨list∨args
          theme←input.theme∊'bw'
          '-list conflicts with -url'⎕SIGNAL 11↑⍨input.url∧list
     
          url←'https://aplcart.info'
          url,←'?'/⍨args∨theme
          url,←input.theme∩'bw'
          url,←'&'/⍨args∧theme
          url,←args/'q=',1↓∊' ',¨input.Arguments
     
          :If input.browser
              :Trap 0
                  {}⎕SE.UCMD'open ',url
              :Else
                  ⍞←'*** Error opening URL ',url,nl
              :EndTrap
          :EndIf
          :If input.popup
              :If 3501⌶⍬ ⍝ RIDE connected
                  :If ¯1=3500⌶'<meta http-equiv="refresh" content="0;url=''',url,'''">'
                      ⍞←'*** Error using RIDE Browser for URL ',url,nl
                  :EndIf
              :Else
                  :Trap 0
                      hr←⍎'⎕SE.Dyalog.APLcartpopup'⎕WC'HtmlRenderer'('URL'url)
                      hr.(⎕WS'Event'('DoPopup' 'Popup'))
                      hr.Popup←'⎕SE.Dyalog.APLcartPopup'∘{
                          uu←'URL'(⊃⍬⍴2⌽⍵)
                          ×⎕NC ⍺:⍺ ⎕WS uu
                          ⍺ ⎕WC'HtmlRenderer'uu
                      }
                  :Else
                      ⍞←'*** Error creating HTMLRenderer for URL ',url,nl
                  :EndTrap
              :EndIf
          :EndIf
          :If list∨args∧input.url⍱input.popup∨input.browser
              n←≢r←⎕SE.Dyalog.Utils.APLcart input.Arguments
              help←''
              :Select input.list
              :CaseList 0(,'0') ⋄ limit←10 ⋄ help←(limit<n)/') (-list=<n> to show up to <n>; -list to show all'
              :Case 1 ⋄ limit←n ⋄ help←(10<n)/') (-list=<n> to show no more than <n>'/⍨10<n
              :Else ⋄ limit←⍎input.list ⋄ help←''
              :EndSelect
              :If 0=n
                  help←') (suggestions? mailto://ideas@aplcart.info '
              :EndIf
              r↑⍨←limit⌊n
              r[;2],⍨←⊂'⍝ '
              msg←'Showing ',(⍕≢r),' of ',(⍕n),' matches',1⌽help
              lines←{(+/∨\' '≠⌽⍵)↑¨↓⍵}0 1↓⍕r
              legend←'X, Y, Z: any type array  M, N: numeric array  I, J: integer array  A, B: Boolean array  C, D: character array  f, g, h: function  ax: bracket axis  s: scalar  v: vector  m: matrix'
              :If ⎕PW<≢legend
                  legend←'X,Y,Z:any M,N:num I,J:int A,B:Bool C,D:char f,g,h:fn ax:axis s:scal v:vec m:mat'
              :EndIf
              :If ⎕PW<≢legend
                  legend{⍵,⍨⍺↑⍨⎕PW-≢⍵}←⎕UCS 8230(3⍴46)⊃⍨1+82=⎕DR'' ⍝ truncate with ...
              :EndIf
              r←legend'',lines,''msg
              r[2,¯1+≢r]←⊂'─'⍴⍨⎕PW⌊⌈/≢¨r
          :EndIf
          r,←input.url/''url↓⍨0=≢r
          :If input.refresh
              r,⍨←⊂'Cache refreshed (',entries,' entries)'
          :EndIf
     
          r←⎕SE.Dyalog.Utils.layoutText⍣(×≢r)⊢r
          r,¨←nl
          r←∊r
          r↓⍨←¯1
          :If ''≡r
              r⍴⍨←0 0
          :EndIf
      :ElseIf ~input.refresh
          r←']',cmd,' ',syntax
      :End
    ∇

      Help←{
          r←,⊂desc
          r,←⊂''
          r,←⊂'    ]',⍵,' ',syntax
          e←,⊂']',⍵,' is a frontend for the ⎕SE.Dyalog.Utils.APLcart function.'
          0=⍺:r,''(']',⍵,' -??  ⍝ for details and examples')'',e
          r,←⊂''
          r,←⊂'<terms>     space separated search terms (use /term/ for regex)'
          r,←⊂''
          r,←⊂'-list       list all results (not valid with -url)'
          r,←⊂'-list=<n>   list no more than <n> results (default: 10)'
          r,←⊂''
          r,←⊂'-browser    open website in browser'
          r,←⊂'-popup      open website in a popup popup'
          r,←⊂'-url        return URL for online query (not valid with -list)'
          r,←⊂'-theme=b|w  use black or white theme in browser/popup (default: grey)'
          r,←⊂''
          r,←⊂'-refresh    refresh the local APLcart cache'
          r,←⊂''
          r,←⊂'Examples:'
          r,←⊂'    ]',⍵,' remove blanks -l=5  ⍝ list first five results for "remove blanks"'
          r,←⊂'    ]',⍵,' /highest|lowest/    ⍝ list up to 10 results for "highest" or "lowest"'
          r,←⊂'    ]',⍵,' -b                  ⍝ open APLcart in browser'
          r,←⊂'    ]',⍵,' -p -t=b             ⍝ open APLcart in popup window using black theme'
          r,←⊂'    ]',⍵,' -u                  ⍝ internet address for APLcart'
          r,←⊂''
          r,←e
          r,←⊂']Open https://github.com/abrudz/aplcart/blob/master/README.md  ⍝ for general APLcart documentation'
          r,←⊂']Open mailto:ideas@aplcart.info  ⍝ to suggest something'
          r
      }
:EndNamespace
