:namespace  Demo ⍝ V1.46
⍝ 2015 10 04 DanB: added the -skip modifier
⍝ 2015 11 12 Adam: moved help layout to framework
⍝ 2015 12 30 Adam: added Test (WIP)
⍝ 2016 01 12 Adam: ⍟ runs TestScript under TTY mode
⍝ 2016 05 11 DanB: fix &⍎
⍝ 2016 06 12 DanB: made ./ = ]CD for file arg
⍝ 2016 07 14 DanB: added the ability to change the PF keys
⍝ 2017 03 07 Adam: removed the ability to change the PF keys
⍝ 2017 06 19 Adam: [14684] Use USERDIR rather than ⎕AN
⍝ 2017 08 03 Adam: [14562,14862] now looks in workdirs.
⍝ 2017 11 06 Adam: removed Looney Tunes end message
⍝ 2018 03 15 MKrom: Avoid index error at end
⍝ 2018 03 15 Adam: Try adding .txt only when file not found, also search .dyalog, help now lists search locs
⍝ 2018 03 19 Adam: Bug fix
⍝ 2018 03 20 Adam: Add .demo and .demo.txt
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -??
⍝ 2018 06 11 Adam: [15948] Fix search paths
⍝ 2018 06 20 Adam: do nothing in next/prev if no script or any other error
⍝ 2019 01 29 Adam: help
⍝ 2019 06 03 Adam: Show DMX info on error
⍝ 2019 07 18 Kai:  -quiet flag introduced: with screen casts neither messages nor modification of the GUI are desriable
⍝ 2019 08 12 Adam: handle (non-)jupyter through dialog box
⍝ 2019 08 29 Adam: [17434] Prevent chopping first letter of ⎕DM, hide ]demo internals
⍝ 2024 07 25 Adam: [14563] Allow ucmds in preamble
⍝ 2024 07 25 Adam: [20053] Clarify that no special lines are allowed in preamble 

⍝ Code for doing demonstrations. Original code JD, modified by DanB & Adam.
⍝ Updated April 2013 to work in TTY mode and 2014 to include speech window and work with the RIDE.

⍝ A demo file consists in a series of statements to be
⍝ executed initially in sequence up to a line starting with &!.
⍝ For example, the file \demo.txt could contain the lines:

⍝ ⍝ Demo for demo: Prepare the form
⍝  'f' #.⎕wc 'form' 'Demo demo' ('size' (21 21))
⍝  ⎕←'Close the form'
⍝ &! ⍝ script executed initially up to here
⍝  ⎕ex 'f' ⍝ this line is shown and executed when 'Enter' is used. F12 will bring the next line.

⍝ By doing ⎕se.RunDemo.Load '\demo.txt' the lines will appear
⍝ in sequence and can be executed.

    ⎕ML←1 ⋄ ⎕IO←1
    enablePfkeys←0
    DESC←'Provide playback mechanism for live demonstrations'

    ∇ r←List
      r←⎕NS'' ⍝ there should be a -condition= to support conditional lines
      r.(Group Parse Name Desc)←'TOOLS'('1SL -tty -ppt -unload -quiet -skip=',enablePfkeys/' -pfkeys:"12 11"')'Demo'DESC
    ∇

    ∇ r←level Help Cmd;t;par;box
      r←⊂DESC
      r,←⊂'    ]',Cmd,' <demofile> [-ppt] [-tty] [-unload] [-quiet] [-skip=<text>]',enablePfkeys/' [-pfkeys=<n1>,<n2>]'
      r,←⊂''
      :If 0=level
          r,←⊂']',Cmd,' -??   ⍝ for more information'
          r,←⊂']',Cmd,' -???  ⍝ for examples'
      :Else⍝ 1≤level
          :If 1≤level
              :Select level
              :Case 1
                  par←'<demofile>  text file (path)name, presumed to be in the current directory, the user directory or in any of the workdirs if path is relative.'
                  par,←' The file is assumed to have zero to two of the extensions .txt, .dyalog, and .demo.'
                  r,←⊂par
                  r,←'' '-ppt               use presentation device (pointer) to go forward (similar to PowerPoint)'
                  r,←⊂'-tty               work in a non GUI environment.'
                  r,←⊂'-unload            remove the added menu items'
                  r,←⊂'-skip=<text>       skip sections where <text> is on the same line as the branch'
                  r,←⊂'-quiet             suppress all mesages but errors and hide the menu commands (useful for screen casts)'
                  r,←enablePfkeys/⊂'-pfkeys=<n1>,<n2>  change PFkeys used for FORWARD (default: F12) and BACKWARDS (default: F11)'
                  r,←'' 'The given file name is searched for with zero to two of the extensions .txt, .dyalog, and .demo appended. It is searched for relative to the current directory, the user directory, and the SALT workdirs:'
                  r,←'    '∘,¨runDemo.AllPaths
                  r,←'' 'Each line of a demo script (after an &! line, if present) may optionally start with an ampersand (&) followed by a special character, as follows:'
                  r,←⊂'    &!              execute script up to this line after loading the demo (for preparing the demo by opening files, creating windows, etc.)'
                  r,←⊂'    &:XXX           define label XXX used to be branched to'
                  r,←⊂'    &→XXX [SS]      go to FORWARD label XXX; when you want to skip sections without deleting their lines'
                  r,←⊂'    &←expression    type expression without displaying the expression using 2 ⎕NQ (you need to add TC if you want the expression to be executed)'
                  r,←⊂'    &''Line          displays the Line in the session as it is'
                  r,←⊂'    &⍎expression    execute expression without expression being displayed'
                  r,←⊂'    &⍝ comment      line is ignored'
                  r,←⊂'    &+xyz           replaces the line in the session, useful when you want to overwrite the expression about to be executed.'
                  r,←⊂'    &=expression    used to group expressions together so they can all be executed at once'
                  r,←⊂'    &⎕ text         make the text appear in a separate speech window (for making videos with text-to-speech in a separate window)'
                  r,←''(']',Cmd,' -??? ⍝ for examples')
              :Else
                  r,←⊂'Example:'
                  r,←'    To run the script \demo.txt:'('      ]',Cmd,' \demo')
                  box←{mat←'─'⍪⍨'─'⍪'│',⍨'│',↑⍵ ⋄ (,2 2↑¯1⌽¯1⊖mat)←'┘└┐┌' ⋄ mat←↓'    ',⍤1⊢mat}
                  t←'A demo file consists of a series of statements to be executed one by one. '
                  t,←'If there is a line starting with &!, all the lines before it are initially executed. '
                  t,←'For example, the file \demo\file.txt could contain the lines:'
                  r,←''t
                  t←⊂'⍝ Demo the demo: Prepare the form'
                  t,←⊂'''f'' #.⎕wc ''form'' ''Demo for demo'' (''size'' (21 21))'
                  t,←⊂'⎕←''Close the form'''
                  t,←⊂'&! ⍝ executes initially up to here. Hit Enter, F12 to see the next line'
                  t,←⊂'⎕ex ''f'' ⍝ executed when Enter is used (then hit F12 for the next line)'
                  r,←(box t),'By executing'('      ]',Cmd,' \demo\file')
                  t←'the file will be read and the first 3 lines will be executed when you press Enter. '
                  t,←'F12 will show the next line which will be executed when you press Enter, etc. F11 will go backwards.'
                  r,←t'' 'Subsequent lines will appear in sequence upon pressing F12, and can then be executed by pressing Enter.'
                  r,←'' 'To conditionally skip sections use &→'
                  r,←⊂'In the following example there are two sections that may be executed and we can skip either by using -skip='
                  r,←box'&→S2 noS1' 'code in section 1...' '&:S2' '&→end noS2' 'code in section 2...' '&:end'
                  r,←'If we issue'('      ]',Cmd,' .../file -skip=noS1')'then the first section will be skipped'
                  r,←'If we issue'('      ]',Cmd,' .../file -skip=noS2')'then the second section will be skipped' 'If we issue'
                  r,←('      ]',Cmd,' .../file')'both sections will be run'
                  r,←''(']',Cmd,' -?? ⍝ for syntax details')
              :EndSelect
              r,←⊂''
          :EndIf
      :EndIf
    ∇

    ∇ r←Run(Cmd Args);ref;name;tn;arg;test
      ⍝ Load Demo and Script
      :If ~enablePfkeys
          Args.pfkeys←'12 11'
      :EndIf
      r←''
      UnLoad ⋄ →Args.unload/0
      ⎕EX'⎕se.runDemo'
      ⎕SE.⎕FIX ⎕SRC runDemo
      arg←1⊃Args.Arguments,⊂r
      :If ∨/test←'*⍟'∊1↑arg
          arg←TestScript
          Args.tty←2⊃test
      :EndIf
      (##.THIS,Args.(tty ppt skip pfkeys quiet))⎕SE.runDemo.LoadScript&arg
    ∇

    ∇ UnLoad ⍝ Remove the button from the menu bar
      ⎕EX'⎕SE.mb.'∘,¨'Next' 'Prev' 'Init' 'Edit'
      ⎕SE.⎕EX'Demo'
    ∇

    :namespace runDemo
    ⍝ Ns used to run the demo.
    ⍝ It must reside in ⎕SE to survive )LOADs, )CLEARs, etc.
    ⍝ The <Run> fn above will put it there before running the demo.

        Script←'' ⋄ ⎕io←1 ⋄ Posn←0 ⋄ FS←⎕se.SALTUtils.FS
        RLB←{(+/∧\' '=⍵)↓⍵} ⋄ RTB←⌽∘RLB∘⌽
        Cut←{⎕ml←3 ⋄ (⍵≠' ')⊂⍵}
        ⍝ Derror←{m←1↓¨1↓⍵.DM ⋄ (6↑¨m)←' ' ⋄ ↑m,⍨⊂⍵.EM{⍺,(⍵∧.=' ')↓': ',⍵}⍵.Message} ⍝ ⎕DMX is the arg
        ⍝ Derror←{d←'⍎'∊1↑1⊃⍵ ⋄ f←' '⍳⍨2⊃⍵ ⋄ ↑'' '      ' '      ',¨d f f↓¨⍵} ⍝ until above fixed
        Derror←{⎕DMX.(↑(⊂((⊢↓⍨'⍎'=⊣/)⊃⊣/DM),({(''≢⍵)/': ',⍵}Message),{2⌽(''≢⊃⊢/⍵)/'") ("',(⊃⊢/⍵)}OSError),'^⍙e\[1]'⎕R'     '⊢1↓DM)}
        Last←'' ⍝ That''s all, folks!

        ∇ la LoadScript name;z;file;PPT;ns;PFkeys;allCands;exist;doubleExts;allExts;jupyter
     ⍝ Prepare the script to demo.
     ⍝ 'name' can be the name of a file (a string), be empty (the name will be asked) or already be a
     ⍝ series of statements to execute (a VTV).
          (ns TTY PPT z PFkeys ∆Quiet)←la ⋄ Path←''
          SKIP←Cut⍕z~0 ⍝ branches to execute if SKIP contains the string next to the label
         
          TTY←{0::1 ⋄ f←⎕NEW'form'(,⊂'visible' 0) ⋄ ⍵}TTY   ⍝ non GUI are automatically considered TTY
          :If ~TTY
              :If 0=⎕NC'⎕SE.mb.Next' ⍝ load the button on the menu bar if necessary
                  :If PPT  ⍝ are we using PowerPoint controls?
                      '⎕SE.mb.Next'⎕WC'menuitem' 'Next'('Event' 'Select' 'Next')('Accelerator'(40 0)) ⍝ Next PP Slide
                      '⎕SE.mb.Prev'⎕WC'menuitem' 'Prev'('Event' 'Select' 'Prev')('Accelerator'(38 0)) ⍝ Back PP Slide
                      '⎕SE.mb.SimEnter'⎕WC'menuitem' 'SimEnter'('Event' 'Select' 'SimEnter')('Accelerator'(34 0)) ⍝ Back PP -
                      '⎕SE.mb.SimEsc'⎕WC'menuitem' 'SimEnter'('Event' 'Select' 'SimEsc')('Accelerator'(33 0)) ⍝ Back PP +
                  :Else
                    ⍝ PFkeys contains the PF keys to use
                      z←111+2↑z,¯1+z←2⊃' ,'⎕VFI PFkeys~'fF'
                      :If ∆Quiet
                          '⎕SE.mb.demo'⎕WC'menu'
                          '⎕SE.mb.demo.Next'⎕WC'menuitem' 'Next'('Event' 'Select' 'Next')('Accelerator'(2↑1↑z)) ⍝ F12
                          '⎕SE.mb.demo.Prev'⎕WC'menuitem' 'Prev'('Event' 'Select' 'Prev')('Accelerator'(2↑1↓z)) ⍝ F11
                          '⎕SE.mb.demo.Init'⎕WC'menuitem' 'Init'('Event' 'Select' 'Init')
                          '⎕SE.mb.demo.Edit'⎕WC'menuitem' 'Edit'('Event' 'Select' 'Edit')
                      :Else
                          '⎕SE.mb.Next'⎕WC'menuitem' 'Next'('Event' 'Select' 'Next')('Accelerator'(2↑1↑z)) ⍝ F12
                          '⎕SE.mb.Prev'⎕WC'menuitem' 'Prev'('Event' 'Select' 'Prev')('Accelerator'(2↑1↓z)) ⍝ F11
                          '⎕SE.mb.Init'⎕WC'menuitem' 'Init'('Event' 'Select' 'Init')
                          '⎕SE.mb.Edit'⎕WC'menuitem' 'Edit'('Event' 'Select' 'Edit')
                      :EndIf
                  :EndIf
              :EndIf
          :EndIf
         
          :If 326∊⎕DR name ⍝ was a script passed as the rarg?
              Script←name ⋄ SourceFile←'' ⍝ done
          :Else ⍝ filename: get the script from the file
              :If 0≠⍴name
                  :If jupyter←'.ipynb'≡3⊃⎕NPARTS name
                      allCands←AllPaths,¨⊂name
                  :Else
                      allExts←'.dyalog' '.demo' '.txt' ''
                      doubleExts←∪,∘.,⍨allExts
                      doubleExts~←¯1↓,¨⍨allExts
                      doubleExts←{⍵⌷⍨⊂⍒≢¨⍵}doubleExts
                      allCands←,doubleExts∘.(⊢,name,⊣)AllPaths
                  :EndIf
                  exist←⎕NEXISTS allCands
                  :If ∨/exist
                      SourceFile←allCands⊃⍨exist⍳1
                  :Else
                      ⎕←'*** Unable to find file "',name,'"'
                      ⎕←'      ]Demo -???  ⍝ for info on which locations and files extensions are searched'
                      →0
                  :EndIf
              :Else ⍝ name not supplied: ask it
                  :If TTY ⋄ →0⊣⎕←'** No file name supplied' ⋄ :EndIf
                  'F'⎕WC'FileBox' 'Load Demo Script'Path('Event' 'FileBoxOK' 1)
                  :If 3>⍴z←⎕DQ'F'
                  :OrIf 'FileBoxOK'≢2⊃z
                      →0
                  :EndIf
                  jupyter←'.ipynb'≡3⊃⎕NPARTS SourceFile←3⊃z
              :EndIf
          :EndIf
          Script←ConvertNotebook⍣jupyter⊃⎕NGET SourceFile 1
          name←''
          :If 0≠⍴Script
              :If (,0)≡,∆Quiet
                  ⎕←'Loaded ',('notebook ' 'script '⊃⍨jupyter⍳⍨,1),SourceFile
              :EndIf
              NS←⍕ns ⍝ see <Init> for reason of doing this
              Init
              ⎕NQ'⎕SE' 'GotFocus' ⍝ Unix never sees this line
          :Else
              ⎕←'** File is empty'
          :EndIf
        ∇

          ConvertNotebook←{
              object←⎕JSON∊⍵
         
          ⍝CodeApl←(⊂'class' 'APL')@{0 0 0 1 0∘.∧⍨⍵[;2]∊⊂'code'}
          ⍝ToDiv←(⊂'div')@{0 1 0 0 0∘.∧⍨(⍵[;2]∊⊂,'p')∨(⍵[;2]∊⊂,'a')∧'#'=⊃∘⊃∘⌽¨⍵[;4]}
          ⍝Render←⎕XML⍠'Whitespace' 'Preserve'{0::'[could not render this cell]' ⋄ ⍺⍺ CodeApl ToDiv ⍺⍺∊⊃MarkAPL.Markdown2HTML ⍵}
          ⍝HtmlSafe←(,¨'<&')⎕R'\&lt;' '\&amp;'
              Convert←{
              ⍝end←'</div>',4⍴⎕UCS 13 10
              ⍝⍺:'<div class="lessonstep">',end,⍨Render ⍵
                  ⍺:'&⍎↑⎕SE.Dyalog.Utils.layoutText',⎕SE.Dyalog.Utils.repObj ⍵~¨⎕UCS 10
                  ⊢text←,⍕¨⊆⍵
                  0::⎕←⎕SE.Dyalog.Utils.repObj text⊣⎕←⎕JSON⍠'Compact' 0⊢⎕DMX
              ⍝lines←HtmlSafe text
                ⍝  first←⊃lines
                ⍝  first,∊'&='∘,¨1↓lines
⍝              first←'<div class="lessonexec">',end,⍨⊃lines
⍝              first,∊'<div class="lessonexec autoexec">'∘,¨,∘end¨1↓lines
              }
         
              Convert/↑object.cells.((cell_type≡'markdown')source)
          }

        ∇ Init;s_ ⍝ Initialize the demo
         ⍝ Execute each line in the file up to '&!'
         ⍝ This fn can be called from within <Load> or as a callback.
         ⍝ 'NS' is a reference to the calling namespace. We need to keep it around.
         ⍝ We can't keep it as a ref because it may prevent )LOAD or )CLEAR if it comes
         ⍝ from # (this namespace is kept in ⎕SE) so it must be a string which also means
         ⍝ that we can't run this code from an unnamed namespace.
         
          :If (⍴Script)≥Posn←(2↑¨Script)⍳⊂'&!'
              :For s_ :In (Posn-1)↑Script
                  :If ']'=⊃s_~' '
                      (⍎NS)⎕SE.UCMD s_
                  :Else
                      (⍎NS)⍎s_ ⍝ ⎕IO 1 - if this is changed problems will arise
                  :EndIf
              :EndFor
          :Else ⋄ Posn←1
          :EndIf
          :If TTY=1 ⋄ TTYMode NS ⍝ we never come back from here
          :Else
              :If 0=∆Quiet
                  ⎕←'Script Initialized...'
              :EndIf
              Next
          :EndIf
        ∇

        ∇ Next;cl;line;keys;lab;snip;a;label;cases;WaitForEmpty
          :Trap 0
              'cl'⎕WC'clipboard' ⋄ WaitForEmpty←0
         Line:
              line←Posn⊃Script,⊂'' ⍝ That's all folks!
              :If '&'≡⊃line
                  :Select 2⊃line,'?'
                  :Case '←'          ⍝ press key(s) in expression and execute
                      {~0∊⍴⍵:{2 ⎕NQ'⎕se' 22 ⍵}¨⍵,⊂'TC'},⍕⍎2↓line
                      Posn+←1
                      →0⍝Line
                  :Case '→'          ⍝ branch to script label
                      label←{(¯1+⍵⍳' ')↑⍵}2↓line
                      :If 0∊⍴cases←Cut(2+⍴label)↓line
                      :OrIf 1∊cases∊SKIP
                          Posn⌈←(1+a⍳1)×∨/a←(Script~¨' ')∊⊂'&:',label
                      :EndIf
                      →Line
                  :CaseList ':⍝'
                      Posn+←1
                      →Line
                  :Case '+'          ⍝ overwrite red line
                      line←2↓line
                      2 ⎕NQ'⎕SE' 22 'QT' ⍝ Clear 1
                  :Case '⍎'          ⍝ invisibly execute
                      ⎕RSI[⎕IO]⍎2↓line
                      Posn+←1
                      →Line
                  :Case '='          ⍝ insert lines together
                      Posn+←1
                      snip←⊂2↓line
                      :While '&='≡2↑line←Posn⊃Script
                          snip,←⊂2↓line
                          Posn+←1
                      :EndWhile
                      'cl'⎕WS'Text'snip
                      →paste
                  :Case ''''
                      ⎕←2↓line
                      Posn+←1
                      →Line
                  :Case '!'
                      line←2↓line
                  :Case '⎕'
                      snip←↓⎕FMT 99 ⎕SE.Dyalog.Utils.reshapeText 2↓line ⋄ Posn+←1
                      :While '&⎕'≡2↑line←Posn⊃Script,⊂''
                          snip,←↓⎕FMT 99 ⎕SE.Dyalog.Utils.reshapeText 2↓line ⋄ Posn+←1
                      :EndWhile
                      snip←RTB¨snip
                      a←{(0<⍵)/1⌽') (no CR',(1<⍵)/'×',⍕⍵}+/(a=1)∧∧\3>a←'&+' '&⎕'⍳2↑¨Posn↓Script
                      (⊃⌽snip),←a ⍝ show # of F12 (no CR) to do
                 ⍝ If display window is not up create it
                      :If 0=⎕NC'Dfont'
                          '⎕se.DemoDisplay'⎕WC'form' 'Comments'(1 1)(10 100)('coord' 'prop')
                          Dfont←'APL385 Unicode'Fsize 1 0 0 400 0 0
                      :EndIf
                      '⎕SE.DemoDisplay.T'⎕WC'text'snip(Fsize×↑0,⍨¨¯1+⍳⍴snip)('fontobj'Dfont)
                      →Line⊣WaitForEmpty←1
                  :EndSelect
              :EndIf ⍝ '&'≡⊃line
         
              :If WaitForEmpty<0=⍴line~' ' ⍝ skip empty lines?
                  Posn+←1
                  →(Posn≤≢Script)⍴Line
              :EndIf
         
              'cl'⎕WS'Text'line
              WaitForEmpty←0
         paste:
              2 ⎕NQ'⎕se' 22 'PT' ⍝ PASTE
              Posn←(1+⍴Script)⌊Posn+1
              '⎕SE.cbbot.bandsb2.sb.ml'⎕WS'Text'(Posn⊃Script,⊂'[No More]')
              ⎕SE.cbbot.bandsb2.sb.ml.Caption←''
          :EndTrap
        ∇

        ∇ TTYMode from;line;in;wsn;in0;lin;Svars;a;Smode;NS;c2;output;⍙e;cut;label;cases
        ⍝ We are very likely in a 79 char wide window; this has implications
        ⍝ wrt output folding and ⍞ input
          Svars←↑a⊂⍨a=1↑a←'⎕lx⎕pp⎕ct⎕lx⎕io⎕ml'
          Smode←'S'∊⎕SE.SALTUtils.APLV
          NS←⍎from ⋄ a←⍕⍳{2::1 ⋄ 85⌶⍵}'0'
          output←{∨/b←(⎕IO⊃¨e←'⎕se'⎕WG'Event')∊⊂'SessionPrint':⍵(⍎(b⍳1)(⎕IO+1)⊃e)1 ⋄ ⍵}
          ⎕FX'⍙e←{0::Derror ⎕DM ⋄ 85::'('output ',a,' NS.(85⌶)⍵}')
         
          :While ∨/a←Posn≤0 1+⍴Script
              cut←(0 1=Smode)/⎕PW,¯1↑⎕SD ⍝ where to fold
              :If '&'=1↑line←{(2×'&!'≡2↑⍵)↓⍵}Posn⊃Script,⊂Last
                  :If (c2←1↑1↓line)∊':⍝' ⍝ skip this line, it's a comment
                  :ElseIf c2='→'
                      label←{(¯1+⍵⍳' ')↑⍵}2↓line
                      :If 0∊⍴cases←Cut(2+⍴label)↓line
                      :OrIf 1∊cases∊SKIP
                          Posn⌈←(1+a⍳1)×∨/a←(Script~¨' ')∊⊂'&:',label
                      :EndIf
                  :ElseIf c2='⍎'  ⍝ silent execute
                      ⍎2↓line
                  :ElseIf c2='''' ⍝ display string
                      ⎕←2↓line
                  :EndIf
                  Posn+←1
              :Else
                  line←(-cut|⍴line)↑⍞←line←'      ',RLB line
                  ⍎(</a)/'→'
                  in←RLB in0←⍞
                  {}÷'OUT!'≢¯4↑in ⍝ allow user to cancel ⍞
                  lin←⎕SE.Dyalog.Utils.lcase{(⍵⍳' ')↑⍵}in
         
                  :If ']'=1↑in              ⍝ UCMD
                      {0::1↓⎕IO⊃⎕DM ⋄ NS ⎕SE.UCMD ⍵}in
         
                  :ElseIf ')load '≡lin      ⍝ )LOAD
                      #.⎕EX #.⎕NL⍳9 ⋄ NS←#
                      :Trap 0
                          #.⎕CY wsn←(6↓in)~'"' ⋄ Svars #.⎕CY wsn ⋄ ⎕WSID←wsn
                          ⎕←'[load simulated using ⎕CY - date not available]'
                      :Else
                          ⎕←')LOAD failed'
                      :EndTrap
         
                  :ElseIf ')copy '≡lin      ⍝ )COPY
                      ⎕←(wsn a)←{p←1⍳⍨(⍵=' ')∧(≠\p)≥1↑p←'"'=⍵ ⋄ ('"'~⍨(p-1)↑⍵)(p↓⍵)}RLB 6↓in
                      :Trap ⎕SE.SALTUtils.DEBUG↓0
                          :If a∧.=' '
                              NS.⎕CY wsn
                          :Else
                              (⊃{⎕ML←3 ⋄ ⍵⊂⍨⍵≠' '}a)NS.⎕CY wsn
                          :EndIf
                          ⎕←'[copy simulated using ⎕CY - date not available]'
                      :Else
                          ⎕←')COPY failed:',⎕IO⊃⎕DM
                      :EndTrap
         
                  :ElseIf ')ed '≡lin        ⍝ )ED
                      NS.⎕ED 4↓in
         
                  :ElseIf ')clear '≡lin     ⍝ )CLEAR
                      #.⎕EX #.⎕NL⍳9 ⋄ NS←#
                      ⎕WSID←⎕←'CLEAR WS'
         
                  :ElseIf ')cs '≡lin        ⍝ )CS
                      :If ' '∧.=a←4↓in ⋄ ⎕←NS←#
                      :ElseIf 9.1∊NS.⎕NC⊂a ⋄ ⎕←NS←NS⍎a
                      :Else ⋄ ⎕←'Namespace does not exist'
                      :EndIf
         
                  :ElseIf ')ns '≡lin        ⍝ )NS
                      :If ' '∧.=a←4↓in ⋄ ⎕←NS
                      :Else
                          ⎕←{⎕SE.SALTUtils.DEBUG↓0::Derror ⎕DM ⋄ ⍵ NS.⎕NS''}a
                      :EndIf
         
                  :ElseIf ')'=1↑in          ⍝ It is a System Command
                      ⎕←'[System Command - ]demo unable to process]'
         
                  :ElseIf '&'≠1↑in          ⍝ other & lines are ignored in TTY mode
                      ⍙e in
                  :EndIf
                  Posn←Posn+≡/{⍵↓⍨-⊥⍨' '=⍵}¨in0 line ⍝ If the line was used, move on
              :EndIf
          :EndWhile
        ∇

        ∇ Edit;script;txt;n
          script←Script
          ⎕ED'script'
          :If ~0∊⍴Script←script
          :AndIf ∨/'yY'∊1↑n↓⍞⊣n←⍴⍞←'Write back onto "',SourceFile,'"? '
              txt←∊Script,¨⊂⎕AV[4 3]
              txt ⎕SE.SALTUtils.PutUTF8File SourceFile
              ⎕←'* Written',(⍴Script),'lines.'
          :EndIf
        ∇

        Fsize←28 ⍝ font size

        ∇ Prev;cl;txt
          :Trap 0
              'cl'⎕WC'clipboard'
              :If 1<Posn←1⌈Posn-2
                  :While '&'=1↑txt←Posn⊃Script
                      Posn-←1
                  :Until Posn=1
              :EndIf
              'cl'⎕WS'Text'(Posn⊃Script)
              2 ⎕NQ'⎕se' 22 'PT'
              Posn+←1
              '⎕SE.cbbot.bandsb2.sb.ml'⎕WS'Text'(Posn⊃Script,⊂'[No More]')
              ⎕SE.cbbot.bandsb2.sb.ml.Caption←''
          :EndTrap
        ∇

        ∇ paths←AllPaths
          paths←(⊃1 ⎕NPARTS'')⎕SE.SALTUtils.USERDIR
          paths,←(⊢⊆⍨∘~∊∘⎕SE.SALTUtils.PATHDEL)⎕SE.SALT.Settings'workdir'
          paths←(⊂''),{'\'@(=∘'/')⍣⎕SE.SALTUtils.WIN⊢⍵,'/'/⍨~'/\'∊⍨⊃⌽⍵}¨paths
        ∇

    :Endnamespace

    ∇ s←TestScript
      s←1↓¨2↓⎕NR'TestScript'
⍝⍝ Demo the demo: Prepare the form
⍝ ⎕←'These lines'
⍝ ⎕←'executed initially'
⍝&! ⍝ script executed initially up to here. Hit Enter then F12 to see the next line
⍝⍝ Next line uses →
⍝&→LAB
⍝these
⍝lines
⍝skipped
⍝&:LAB
⍝
⍝⍝ following is 2 lines of text appearing in the session:
⍝&'line1
⍝&'line2...
⍝
⍝⍝ this is done silently: ⍳9
⍝&⍎⍳9
⍝
⍝&⍝ this is ignored
⍝
⍝&→END TTY
⍝'abc' ⍝ this will be replaced (Hit F12, not Enter)
⍝&+'def'
⍝
⍝⍝ multiple lines are put in the clipboard
⍝
⍝&=⍳2
⍝&=⍳3
⍝&=⍳4
⍝
⍝
⍝&⎕ make this text appear in a speech window
     
⍝&⎕This shown separately in a speech window
⍝'in preparation for this line'
⍝&:END
    ∇

    ∇ r←Test dummy;assert;file;script;tn
      {1 ⎕NQ'⎕SE' 'KeyPress',⍵}¨7⍴⊂⊂'ER'
      :Trap r←0
          ⎕SE.UCMD'Demo ⍟ -skip=TTY'
          r←1
      :EndTrap
     
      →0
      file←⎕SE.SALTUtils.USERDIR,'TestScript.txt'
      :Trap 22
          tn←file ⎕NCREATE 0
      :Else
          tn←file ⎕NTIE 0
          file ⎕NERASE tn
          tn←file ⎕NCREATE 0
      :End
      script←∊TestScript,¨⎕UCS 10
      script ⎕NAPPEND tn,160
      ⎕NUNTIE tn
      r←0
      {1 ⎕NQ'⎕SE' 'KeyPress',⍵}¨⊂¨'ER' 'F12' 'F12'
      ⍝:Trap 0
      ⎕SE.UCMD List.Name,' ',file
      r←1
      ⍝:EndTrap
      tn←file ⎕NTIE 0
      file ⎕NERASE tn
    ∇
:Endnamespace ⍝ Demo  $Revision: 1888 $
