﻿:Namespace KeyPress ⍝ V1.12
⍝ 1995 04 03 RexSwain: Independent Consultant, Tel (+1) 203-868-0131
⍝ 1995 08 15 RexSwain: Simplify and improve handling of System and APL fonts
⍝ 2017 03 02 MBaas: Initial code for KP as UCMD
⍝ 2017 03 09 MBaas: Runs in classic, using 4 digits for hex-codes in non-classic, easy BCol-Fiddling
⍝ 2017 03 10 MBaas: Adjustments to positioning, colour and fonts
⍝ 2017 03 15 Adam: Shorten printed labels, add spacing, adjust fonts, spin off thread if called from session, help text fixes
⍝ 2017 03 16 Adam: Fix help level ?? → ?, remove outputted newline, fix RIU issue
⍝ 2017 03 22 Adam: Made colours consistent
⍝ 2017 09 04 Kai: Pressing <escape> or <Alt+F4> twice closes the dialog box; no threads needed by moving logic to a callback; honour scaling
⍝ 2017 10 02 MBaas: more help; honouring scaling by using ScaledPixel
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -??
⍝ 2018 04 19 Adam: help text updates
⍝ 2018 05 01 Adam: add SVN tag 
⍝ 2019 01 16 Adam: help
⍝ 2019 02 14 Andy: replace http with https

    BCol_Form←¯16   ⍝ = Button Face      188 188 188      ⍝ background of the form
    BCol_Label←¯16  ⍝ = Button Face      166 166 166     ⍝ labels for the various fields
    BCol_Result←¯21 ⍝ = Button Highlight 208 208 208    ⍝ interpreted elements of the message
    BCol_RawMsg←¯21 ⍝ = Button Highlight 208 208 208    ⍝ the event message    (original col was 127 255 255)

    DESC←'Return message arguments of KeyPress events'

    ⎕IO←1 ⋄ ⎕ML←1

    ∇ r←List
      :If ⎕SE.SALTUtils.WIN
          r←⎕NS ⍬
          r.Name←'KeyPress'
          r.Group←'MSWIN'
          r.Desc←DESC
          r.Parse←''
      :Else
          r←⍬
      :EndIf
    ∇

    ∇ r←level Help Cmd;h
    r←DESC('    ]',Cmd)''    
      :If 0<level
          h←'Displays GUI and waits for KeyPress events. '
          h,←'Whenever the event is triggered (i.e. a key is pressed), it displays the arguments. '
          h,←'If run from the session, this data will also be displayed in the session. '
          r,←h''
          r,←⊂'Keypress event information includes the key number for a particular key. This is needed when:'
          r,←⊂' ∘  setting up an Accelerator property for a GUI object.'
          r,←⊂' ∘  editing the keyboard translate .DIN files for the IME to enable keyboard layout customisation.'
          r,←⊂' ∘  performing some action in the keypress event callback for a particular key.'
          r,←'' 'For more information on the event message vector, see the Dyalog for Microsoft Windows Object Reference Guide:'
          h←'    ]Open https://help.dyalog.com/'
          h,←1↓∊2↑'.'(=⊂⊢)'.',2⊃⎕SE.SALTUtils.APLV
          h,←'/Content/GUI/MethodOrEvents/KeyPress.htm'
          r,←h'' 'Thanks to Rex Swain, Independent Consultant, Tel +1-203-868-0131'
      :Else
          r,←⊂']',Cmd,' -?? ⍝ for more information'
      :EndIf
    ∇

    ∇ {R}←Run dummy;Q;Z;C;H;W;VP;HP;VZ;HZ;X;sz;JR;E;P;ref;corr;parent
      R←⍬
     
⍝ ----- Create form ---------------------------------------------------
     
      parent←⎕SE.⎕NS''
      parent.⎕WX←3
      ref←parent.⎕NEW'Form'(('Caption' 'KeyPress Event')('Coord' 'ScaledPixel')('MinButton' 0)('MaxButton' 0)('Sizeable' 0))
      ref.BCol←BCol_Form
      ref.∆LastKey←''
     
     
⍝ ----- Query System and APL fonts ------------------------------------
     
     
      'SYS'ref.⎕WC ⎕SE.SALTUtils.Fonts.Message ⍝ Create copy of font as object
      'SYS'ref.⎕WS('Size' 13)('Weight' 800)
      Q←'⎕SE'⎕WG'Font'                     ⍝ Want session/APL font for Labels
      'APL'ref.⎕WC(⊂'Font'),Q              ⍝ Create copy of font as object
     
      Z←ref.⎕WG⊂'TextSize' 'Z' 'SYS'       ⍝ Size of one char in System font
      C←ref.⎕WG⊂'TextSize' '⎕' 'APL'       ⍝ Size of one char in APL font
     
      H←C[1]⌈Z[1]                          ⍝ Larger height (×1.5 for border)
      ref.H←H
      W←C[2]                               ⍝ Width of one APL character
      VP←H×¯1.5+2×⍳8                       ⍝ Vertical positions
     
⍝ ----- Resize form ---------------------------------------------------
     
      C←1⊃'.'⎕WG'DevCaps'                  ⍝ Screen size in pixels
      Z←(⊃¯1↑VP)(800)                      ⍝ For now, unnecessarily wide
      ref.⎕WS('Font' 'SYS')('Size'Z)
     
⍝ ----- Create column 1: left-hand labels -----------------------------
     
      HP←W                                 ⍝ Horizontal position
      VZ←H×1.5                             ⍝ Vertical size
      HZ←⍬                                 ⍝ Horizontal size
     
      Q←('Size'(VZ HZ))('BCol'BCol_Label)
      'L1'ref.⎕WC'Label' ' [1] Object:'('Posn'(1⊃VP)HP),Q
      'L2'ref.⎕WC'Label' ' [2] Event:'('Posn'(2⊃VP)HP),Q
      'L3'ref.⎕WC'Label' ' [3] Input Code:'('Posn'(3⊃VP)HP),Q
      'L4'ref.⎕WC'Label' ' [4] Char Code:'('Posn'(4⊃VP)HP),Q
      'L5'ref.⎕WC'Label' ' [5] Key Number:'('Posn'(5⊃VP)HP),Q
      'L6'ref.⎕WC'Label' ' [6] Shift State:'('Posn'(6⊃VP)HP),Q
     
      Q←'To exit click the close box or press either <Escape> or <Alt+F4> twice'
      'LC'ref.⎕WC'Label'Q('Posn'(7⊃VP)W)('Size'VZ ⍬)('FCol' 0 0 255)
     
      X←¯1↓'Label'⎕WN ref                  ⍝ Names of all child labels except last one
      sz←2⊃¨¨X ⎕WG¨⊂'Posn' 'Size'          ⍝ Horizontal posn and size of each
      X ⎕WS¨⊂'Size'⍬(⌈/2⊃¨sz)
      sz←⌈/+/¨sz                           ⍝ Largest Posn+Size
     
     
⍝ ----- Create column 2: APL "edit" boxes -----------------------------
     
      HP←sz                                ⍝ Horiz positions (column 2)
      Q←' KeyPress' ' Ctrl+Shift+Enter'
      HZ←W×2+(↑∘⍴∘,)¨Q
      Q←('Font' 'APL')('Border' 0)('BCol'BCol_RawMsg)
      JR←⊂'Justify' 'Right'
      'K1'ref.⎕WC'Label'('Posn'((1⊃VP)HP))('Size'(VZ,1⊃HZ)),Q
      'K2'ref.⎕WC'Label'('Posn'((2⊃VP)HP))('Size'(VZ,1⊃HZ)),Q
      'K3'ref.⎕WC'Label'('Posn'((3⊃VP)HP))('Size'(VZ,1⊃HZ)),Q
      'K4'ref.⎕WC'Label'('Posn'((4⊃VP)HP))('Size'(VZ,1⊃HZ)),Q
      'K5'ref.⎕WC'Label'('Posn'((5⊃VP)HP))('Size'(VZ,1⊃HZ)),Q
      'K6'ref.⎕WC'Label'('Posn'((6⊃VP)HP))('Size'(VZ,1⊃HZ)),Q
      Q←(¯1↓Q),⊂'BCol'BCol_Result
     
⍝ ----- Explain input code --------------------------------------------
      E←('Caption' ' ≡')('Font' 'APL')('Size'VZ(W×2.5))('BCol'BCol_Label)
      :If ⎕SE.SALTUtils.CLASSIC
          P←(3⊃VP),HP+1⊃HZ⍝+W×0.5
          'Y1'ref.⎕WC'Label'('Posn'P),E
          Z←'Y1'ref.⎕WG'Size'
          P[2]+←Z[2]
          'K8'ref.⎕WC'Label'('Posn'P)('Size'(VZ,2⊃HZ)),Q
      :EndIf
     
⍝ ----- Create more ASCII stuff ---------------------------------------
     
      P←(4⊃VP),HP+(1⊃HZ)+W×0.5
      X←('Size'VZ ⍬)('BCol'BCol_Label)
      'D1'ref.⎕WC'Label' ' decimal'('Posn'P),X
      Z←'D1'ref.⎕WG'Size'
      P[2]+←Z[2]
      'D3'ref.⎕WC'Label'('Posn'P),E,⊂'BCol'BCol_Label
      Z←'D3'ref.⎕WG'Size'
      P[2]+←Z[2]
      'K7'ref.⎕WC'Label'('Posn'P)('Size'(VZ,0.5×2⊃HZ)),Q
      P[2]+←(0.5×2⊃HZ)
      'D2'ref.⎕WC'Label' ' hex'('Posn'P),X
     
⍝ ----- Create shift state buttons ------------------------------------
     
      P←(6⊃VP),HP+(1⊃HZ)
      'B0'ref.⎕WC'Label'('Posn'P),E
      Z←'B0'ref.⎕WG'Size'
      P[2]+←Z[2]
      'KS'ref.⎕WC'Label'('Posn'P)('Size'(VZ,2⊃HZ))('BCol'BCol_Result)
     
⍝ ----- Resize width of form ------------------------------------------
     
      X←(⎕WN ref)~'Font'⎕WN ref
      X←2⊃¨¨X ⎕WG¨⊂'Posn' 'Size'
      X←W+⌈/+/¨X                    ⍝ Largest Posn+Size, plus right-hand pad
      corr←⌊{(1⊃⍵)×0.001×¯100+4⊃⍵}'.'⎕WG'DevCaps'  ⍝ Honour scaling
      P←⌈0.30000000000000004 0.9×(C-(⊃¯1↑VP),X)-corr
      ref.⎕WS('Size'⍬ X)('Posn'P)  ⍝ Fix overall width and position
      ref.⎕WS'Event' 'KeyPress' '##.OnKeyPress'(parent ref)
      parent.⎕FX ⎕CR'OnKeyPress'
      ⎕NQ ref'GotFocus'
     ⍝Done
    ∇

    ∇ r←x OnKeyPress(object event input char key shiftState);kl;H;None;parent;ref
      (parent ref)←x
      None←{''≡⍵:'[none]' ⋄ ⍵}
      H←⎕D,6⍴⎕A                         ⍝ Hex digits
      :If ('EP'≡input)∧shiftState=0
          :If 'EP' 0≡ref.∆LastKey    ⍝ <Escape> ?!
              ref.Close
              :Return
          :Else
              ref.∆LastKey←'EP' 0
          :EndIf
      :ElseIf (115≡key)∧shiftState=4    ⍝ <Alt+F4> ?!
          :If 'ALT+F4' 4≡ref.∆LastKey
              ref.Close
              :Return
          :Else
              ref.∆LastKey←'ALT+F4' 4
          :EndIf
      :Else
          ref.∆LastKey←''
      :EndIf
     
      kl←⎕KL input
      'K1'ref.⎕WS'Caption'(' n/a')
      'K2'ref.⎕WS'Caption'(' ',event)
      'K3'ref.⎕WS'Caption'(' ',None input)
      :If ⎕SE.SALTUtils.CLASSIC
          'K8'ref.⎕WS'Caption'(' ',kl)
      :EndIf
      'K4'ref.⎕WS'Caption'(' ',⍕char)
      'K7'ref.⎕WS'Caption'(' ',H[1+((4-2×⎕SE.SALTUtils.CLASSIC)⍴16)⊤char])
      'K5'ref.⎕WS'Caption'(' ',⍕key)
      'K6'ref.⎕WS'Caption'(' ',None⍕shiftState)
      'KS'ref.⎕WS'caption'(' ',ShiftS←None ¯1↓∊((2 2 2⊤shiftState)/'Alt' 'Ctrl' 'Shift'),¨'+')
      r←'Input: ',None input,⎕SE.SALTUtils.CLASSIC/'[',kl,']'
      r,←', Char: ',⍕char
      r,←', Key: ',⍕key
      r,←', Shift: ',(⍕shiftState),'=',ShiftS
      ⎕←r
    ∇

:EndNamespace ⍝ KeyPress  $Revision$
