﻿:namespace Latest ⍝ V1.11
⍝ Implement "Latest" as a User Command. Adapted from Ray Cannons UCMDS.
⍝ 2015 05 28 Adam: Help Mat → VTV
⍝ 2015 06 01 Adam: Improved Help + made auto PW
⍝ 2015 10 18 DanB: added abitilty to specify negative numbers
⍝ 2015 11 12 Adam: moved help layout to framework
⍝ 2015 11 19 Adam: Test; Examples that actually work if user presses Enter on them; Clearer help on -format
⍝ 2015 12 30 Adam: Updated help to include negative numbers
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -??
⍝ 2019 02 01 Adam: help

    ⎕ml←1 ⋄ ⎕io←1
    DESC←'List functions modified since a specified date (default is today), most-recently-changed first'

    ∇ r←List
      r←⎕NS''
      r.Name←'Latest'
      r.Desc←DESC
      r.Parse←'1S -by= -last= -format[=]no NO'
      r.Group←'FN'
    ∇

    ∇ r←level Help Cmd
      r←⊂DESC
      r,←⊂'    ]',Cmd,' [<date>] [-by=<author>] [-last=<n>] [-format=no]'
      :if level=0
      r,←⊂''
      r,←⊂']',Cmd,' -?? ⍝ for more information and examples'
      :else
          Eg←{''('    ',':',⍨⊃⌽⍵)('        ]',Cmd,' ',⊃⍵)}
          r,←⊂''
          r,←⊂'<date>        date from which changes are listed. Possible formats are:'
          r,←⊂'              ∘  YYYYMMDD'
          r,←⊂'              ∘  MMDD (initial zero can be omitted for months 1 to 9)'
          r,←⊂'              ∘  negative number of units, immediately followed by a single unit character ─ one of d(ay), w(eek) or m(onth)'
          r,←⊂''
          r,←⊂'-by=<author>  restrict list to functions last edited by <author> (multiple authors must be space-delimited and the list must enclosed in "").'
          r,←⊂'-last=<n>     limit list to <n> most recent changes'
          r,←⊂'-format=no    return as vector of vectors'
          r,←⊂''
          r,←⊂'Examples:'
          r,←Eg'' 'Today'
          r,←Eg' 213' 'Since 13th of February this year'
          r,←Eg' ¯10' 'Since 10 days ago'
          r,←Eg' ¯2w' 'Since 2 weeks ago'
          r,←Eg(' ¯1m -by=',⎕AN)'Since a month ago by you'
          r,←Eg' -last=3' 'The last three programs edited'
          r,←'' 'By default the result is formatted using ⎕PW, but can be returned as a list by using -format=no. Under program control a list is returned, can be formatted using ⎕PW by using -format.'
     
      :EndIf
    ∇

    ∇ r←Run(Cmd Args)
      r←Latest Args
    ∇


    ∇ r←Latest crit;so;dates;from;ti;b;date;n;nada;DtoI;ItoD;last
     ⍝ Returns a list of fns/operators last modified or a string (message)
      :If 9=##.⎕NC'THIS' ⋄ from←##.THIS ⋄ :Else ⋄ from←⎕IO⊃⎕RSI ⋄ :EndIf
     ⍝ A negative number goes back.
      :If '¯'∊n←⍕crit.Arguments
          DtoI←{2 ⎕NQ'.' 'DateToIDN'⍵} ⋄ ItoD←{2 ⎕NQ'.' 'IDNToDate'⍵}
          so←DtoI ⎕TS
          date←100⊥¯1↓ItoD so+7 7 30 30 1['wWmM'⍳¯1↑n~' ']×2⊃⎕VFI n~'wWmM'
      :Else
          so←0 100 100⊤100⊥¯3↑2⊃⎕VFI n ⋄ date←100⊥so+(so=0)×3⍴⎕TS
      :EndIf
     
      :If nada←0∊⍴r←from listObjs 3.1 4.1
          ti←0 1 0 1/⎕AT↑r
          :If (crit.by≢0)∧0∊last←0⌈0 crit.Switch'last'
              b←ti[;2]∊{1↓¨(⍵∊' ,')⊂⍵}' ',crit.by
              (ti r)←b∘⌿¨ti r
          :EndIf
          so←⍒dates←,100⊥⍉1 1 1 0 0 0 0/↑ti[;1]
          :If 0∊last
              r←r[(date≤dates[so])/so]
          :Else
              r←(last⌊⍴r)↑r[so]
          :EndIf
          :If {⍵∊'no' 'NO':0 ⋄ 6::1 ⋄ ##.RIU≤⍵}⊂crit.format ⍝ is the result used?
              r←⎕PW ¯2 ⎕SE.Dyalog.Utils.showCol r
          :EndIf
      :OrIf 0∊⍴r
          r←'* nothing changed',nada/' (no programs found)'
          r,←(nada<~0∊⍴n)/' since ',⍕date
          r,←(0≢ti)/' by ',ti←crit.by
      :End
    ∇

    DF←{(⍵.⎕DF df){⍵}⍕⍵{⍺}df←⍵.⎕DF ⎕NULL}

      listObjs←{⍺←# ⋄ ⎕ML←0
          names←1↓⊃,/' ',⍵∘{(DF ⍵)∘,¨~∘' '¨↓'.',⍵.⎕NL ⍺}¨nsTree ⍺
⍝ list objects in ⍺ space and ⍵ nameclasses (including 0.1 grade)
⍝ ← fullname list all nameclass items in or below space
⍝ Phil Last ⍝ 2008-01-09 12:09
          (~'['∊¨names)/names
      }

⍝ namespace tree, ⍵ is a ns
⍝ ← ns and all direct nss below
⍝   excludes nss whose only ref is outside parent
⍝ Phil Last ⍝ 2008-04-30 00:30
    nsTree←{⍵ {⊃∇/⍺.(⍺ {(0,⍵)/⍨0,(⍺≠⍵)∧⍺=⍵.##} ⍎⍕'⍺',⌽⎕NL ¯9.1),⊂⍵,⍺} ⍬}

    :Section Test
    ∇ r←Test dummy;F;T
      ⎕FX⍪'F'
      T←{(,⊂'.F',⍨⍕⎕THIS)∊⎕SE.UCMD List.Name,' ',⍵,' '⊣'-last=1'}
      r←0
      r←~T'-by=X',⎕AN
      r∧←T'-by=',⎕AN
      r∧←T'¯10'
      r∧←T'¯2w'
      r∧←T'¯1m'
      r∧←T'-last=3'
    ∇
    :EndSection

:Endnamespace ⍝ Latest  $Revision: 1519 $
