﻿:Namespace ListNames ⍝ V1.02
⍝ Name listing and searching
⍝ 2020 03 25 RPark inital code
⍝ 2021 04 15 RPark [18988,18987] fix extra leading spaces and error on empty namespace
⍝ 2021 05 01 RPark make error messages more human friendly
⍝ 2021 12 07 RPark enable relative namespace paths

    ⎕IO←1 ⋄ ⎕ML←1

⍝ - WIBNI handle accents
⍝ - WIBNI ⍵ as a ref
⍝ - WIBNI JSON objects
⍝ - WIBNI give name class name as well as number
⍝ - WIBNI list from multiple namespaces
⍝   - -group= by nameclass or namespace first
⍝ - WIBNI most recently modified first
⍝ - WIBNI recursively traverse namespace

    ∇ r←List
      r←⎕NS¨1⍴⊂⍬
     ⍝ Name, group, short description and parsing rules
      r.Name←⊂'Names'
      r.Group←⊂'WS'
      r[1].Desc←'List names'
      r.Parse←⊂'99S -filter= -insensitive'
    ∇

    ∇ r←Run(cmd input);Is_Namespace;ToMatrix;caller;grouped;integer;is_namespace;is_this;namelist;nc;nclabel;ncmark;ns;nstmp;path;sorted
      :Trap 0
     ⍝ Default: search current namespace for any names of all nameclasses
          (ns nc nclabel)←Parse input.Arguments   ⍝ namespace, nameclasses, include class labels?
          caller←##.THIS                          ⍝ ns from which ucmd was called
          ncmark←'───'                            ⍝ Nameclass marker when grouped
          nstmp←'.*⎕THIS\.?'⎕R''⍠1⊢ns
          Is_Namespace←{
              9=caller.⎕NC ⍵:1
              (¯1=caller.⎕NC ⍵)∧∨/∨/⍤⍷∘(⎕C ⍵)¨'⎕se' '#'
          }
          is_namespace←Is_Namespace⊃nstmp
          nc←nc(1 2 3 4 5 6 7 8 9)⊃⍨1+0∊nc
          :If ~is_this←nstmp≡,⊂''
              :If ¯1∊⎕NC nstmp
              :AndIf ~is_namespace
                  ('Invalid name: ',⊃nstmp)⎕SIGNAL 2
              :ElseIf 0∊caller.⎕NC nstmp
                  ('Undefined name: ',⊃nstmp)⎕SIGNAL 6
              :ElseIf ~∧/is_namespace
                  ('Not a namespace: ',⍕nstmp⌷⍨⊂~is_namespace)⎕SIGNAL 11
              :EndIf
          :EndIf
          path←(1+is_this⍲ns≢caller)⊃''('.',⍨¨⍕¨ns)       ⍝ If <ns> specified, give paths
          ns←(1+'⎕this'≡⍥(,⍤⊆)∘⎕C ns)⊃ns caller   ⍝ caller is ⎕THIS
          namelist←ns caller.{⍺⍎'⎕NL -⍵'}¨⊂nc
          :If 0≢input.filter
              namelist←namelist Search¨⊂input.filter
          :EndIf
          :If 0=≢⊃namelist
              grouped←⊂0 0 0⍴''       ⍝ Flatten and showCol works for this empty array
          :Else
              sorted←path{((≢⍵)⍴⊆⍺){⍺∘,¨⍵}¨⍵}input.insensitive Sort¨namelist
              :If nclabel
                  integer←∧/(⊢=⌊)nc   ⍝ 0: specified decimal nameclass e.g. dfn 3.2
                  grouped←caller(integer _GroupByNameclass)¨sorted
              :Else
                  grouped←↑¨sorted
              :EndIf
          :EndIf
          ToMatrix←{,[⍳2]⍤↑⍣(2≤≢⍴⍵)⊢⍵}↑
          r←⎕SE.Dyalog.Utils.showCol ToMatrix grouped
          :If 1=≢r
          ⍝ For one row of names, change nameclass display format
              r←' +(\d)' '  +'⎕R'   \1' ' '⊢'\S* (\d\.?\d?) \S*'⎕R'\1:',r
          :EndIf
      :Else
          ⎕DMX.(EN ⎕SIGNAL⍨OSError{⍵,2⌽(×≢⊃⍬⍴2⌽⍺,⊂'')/'") ("',⊃⍬⍴2⌽⍺}Message{⍵,⍺,⍨': '/⍨×≢⍺}⊃⍬⍴DM,⊂'')
      :EndTrap
    ∇

    ∇ r←level Help cmd;Eg
      :Select cmd
      :Case 'Names'
          r←,⊂List[1].Desc
          r,←⊂'    ]',cmd,' [<ns>] [<ncs>] [-filter=<pattern>] [-insensitive]'
          :If level>0
              r,←⊂''
              r,←⊂'<ns>          List names from this namespace (default: ⎕THIS)'
              r,←⊂''
              r,←⊂'<ncs>         List only these name classes (default: all). If specified, group by nameclass'
              r,←⊂''
              r,←⊂'-filter=      List names matching <pattern>'
              r,←⊂'                Glob with ? single character or * multi-character wildcard'
              r,←⊂'                Use /pattern/ for regex'
              r,←⊂''
              r,←⊂'-insensitive  List names in case-insensitive order (default is case-sensitive)'
              r,←⊂''
              r,←⊂'Note:  For <ncs>, 0 is shorthand for all nameclasses'
              r,←⊂''
              r,←⊂'Examples'
              Eg←cmd∘{'    ]',⍺,' ',⍵}
              r,←⊂Eg'                            ⍝ List all names in the current namespace'
              r,←⊂Eg'2 4                         ⍝ Variables and operators only'
              r,←⊂Eg'⍳10                         ⍝ List all names grouped by nameclass'
              r,←⊂Eg'0                           ⍝ Ditto'
              r,←⊂Eg'⎕SE 2+⍳7                    ⍝ Non-variables in ⎕SE'
              r,←⊂Eg'⎕SE -i                      ⍝ Names in ⎕SE in case-insensitive order'
              r,←⊂Eg'⎕SE 2 -filter=P*            ⍝ Variables in ⎕SE beginning with P'
              r,←⊂Eg'⎕SE.Dyalog.Utils 2,3.1,4.2  ⍝ Variables, tradfns and dops in ⎕SE.Dyalog.Utils'
          :Else
              r,←'' ']Names -??  ⍝ for details and examples'
          :EndIf
      :EndSelect
    ∇

    ∇ (ns nc label)←Parse args;fixed;valid;vfi;nums;ns
      label←0
      :If 0∊⍴args
          (valid fixed)←0
          nc←⍳10
          ns←,⊂'⎕THIS'
      :Else
          (valid fixed)←↓⍉↑{2 6::0 ⍵ ⋄ ' ,'⎕VFI⍕##.THIS⍎⍵}¨args
          valid←∨/¨valid
          nc←∪∊valid/|@(2|⎕DR¨)fixed
          :If 0=≢nc
              nc←⍳10
          :Else
              label←1
          :EndIf
          :If 1=+/~valid
              ns←args/⍨~valid
          :ElseIf 0=+/~valid
              ns←,⊂'⎕THIS'
          :Else
         ⍝ To enable multi-ns behaviour, change 1=+/~valid to 1≤+/~valid above and comment ⎕SIGNAL below
              ⎕SIGNAL⊂('EN' 16)('Message' 'Only one namespace reference permitted')
          :EndIf
      :EndIf
    ∇

      Search←{
     ⍝       ⍺: character matrix list of names
     ⍝       ⍵: character vector of space-separated patterns
     ⍝       ←: filtered character matrix
     ⍝ Default: ⎕S for exact match with ? single char or * multi-char wildcards (DOS-style glob)
          terms←⊆','(≠⊆⊢)⍣(','∊⍵)⊢⍵
          regex←('//'≡(⊃,⊃∘⌽))¨terms
          pattern←'^',¨(regex/regex(⊣↓-⍤⊣↓⊢)¨terms),¨'$'
          pattern,←'^',¨('\?' '\*'⎕R'.' '.*'⊢terms/⍨~regex),¨'$'
          pattern ⎕S'%'⊢⍺
      }

    ∇ sorted←{case_insensitive}Sort list;grade;decimal
   ⍝ list is a character matrix
   ⍝ Default: case sensitive natural sort
      :If 0=⎕NC'case_insensitive'
          case_insensitive←0
      :EndIf
      :If case_insensitive
          sorted←list⌷⍨⊂⍋_Natural ⎕C list
      :Else
          sorted←list⌷⍨⊂⍋_Natural list
      :EndIf
    ∇

      NL←{
          ⍺←⊃⎕RSI
          ⍺(⊃⎕RSI).⍎'⎕NL ⍵'
      }

      _GroupByNameclass←{
          caller←⍎⍣(80≡⎕DR ⍺)⊢⍺
          width←⌊2÷⍨⌈/≢¨⍵
          nc←⌊⍣⍺⍺|caller.⎕NC ⍵
          ↑⊃,/{(⊂⍋⍵)⌷⍵}nc{⊂(⊂ncmark,' ',(⍕⍺),' ',ncmark)⍪⍵}⌸⍵
      }

      _Natural←{   ⍝ Grade for Natural Sort Order
          ⍺⍺{6::⊂⍵ ⋄ ⍎¨@(⊃⍤⊃⍤⎕VFI¨)⍵⊂⍨1,2≠/⍵∊⎕D}¨⍵
      }

:EndNamespace