﻿:namespace Files ⍝ V1.16
⍝ File related commmands
⍝ 2015 11 12 Adam: moved help layout to framework
⍝ 2015 12 30 Adam: added Test
⍝ 2016 01 23 DanB: added help for find & replace
⍝ 2016 02 17 DanB: ]file.edit to work under nix (no use of ]caption)
⍝ 2016 03 18 DanB: modified help msg
⍝ 2017 03 08 Adam: note about )ed native.file
⍝ 2017 07 18 Becca: Change ]file.edit, ]file.find, ]file.replace, ]file.touch, ]file.ToLarge Help descriptions
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -??
⍝ 2019 01 14 Adam: Help texts

    ⎕ml←1 ⋄ ⎕io←1 ⋄ AllCmds←'Find' 'Replace' 'Edit' 'Touch' 'ToLarge'

    ∇ r←List;t
      r←{⎕NS ⍬}¨AllCmds
      r.Name←AllCmds
      r.Group←⊂'File'
      t←'L -folder= -options∊iI -types= -regex'
      r.Parse←('1',t)('2',t,' -backup[=]'),'1L -create' '1L' '1 -recursive -list -backup= -verbose'
     
      r[1].Desc←'List line numbers and lines that contain the specified string for each file that has a match'
      r[2].Desc←'Replace strings in files and return the number of changes made'
      r[3].Desc←'Open the specified native file as an editable text file'
      r[4].Desc←'Check whether the specified file exists in the current/specified location and create it if it cannot be found'
      r[5].Desc←'Transform component files in the specified directory from small-span to large-span'
    ∇

    ∇ r←level Help Cmd;with;by
      r←⊂List[AllCmds⍳⊂Cmd].Desc
      :Select Cmd
      :CaseList 'Find' 'Replace'
          :If 0=level
              r,←⊂'    ]',Cmd,' <searchstring>',(' <replacementstring>'/⍨'R'=⊃Cmd),' [-folder=<startfolder>] [-options=i] [-regex] [-types=<exts>]',' [-backup[=<ext>]]'/⍨'R'=⊃Cmd
          :Else
              r,←⊂''
              r,←⊂'Argument',(' is text' 's are texts'⊃⍨1+'R'=⊃Cmd),' to be searched for in the relevant files'
              :If Cmd≡'Replace'
                  r,←⊂'-backup[=<ext>]        adds <ext> (default is ".bu") to the extension of the original files'
              :EndIf
              r,←⊂'-folder=<startfolder>  specifies a folder different than the current workdir'
              r,←⊂'-options=i             specifies case insensitivity'
              r,←⊂'-regex                 interprets arguments as regular expressions'
              r,←⊂'-types=<exts>          specifies the (comma-separated) file extensions to be searched (default "dyalog,asmx,aspx,asax,apl")'
              r,←'' 'Examples:'
              by←5↓with←' with WXYZ'/⍨'R'=⊃Cmd
              r,←⊂'    ',Cmd,' ABC',with,' in .dyalog files under \temp :'
              r,←⊂'        ]',Cmd,' ABC',by,' -folder=\temp'
              r,←⊂'    ',Cmd,' insensitive syntactic ABC',with,' in PHP files under \tmp :'
              r,←⊂'        ]',Cmd,' \bABC\b',by,' -opt=i -folder=\tmp -typ=php -regex'
              r,←⊂'    ',Cmd,' ABC',with,' not within comments or text in the current workdir:'
              r,←⊂'        ]',Cmd,' "(''[^'']*''|⍝.*$)?(?(-1)(*SKIP)(?!)|ABC)"',by,' -regex'
          :EndIf
     
      :Case 'Edit'
          :If 0=level
              r,←⊂'    ]',Cmd,' <filename> [-create]'
          :Else
              r,←'' 'Argument is native file to be edited' '-create  creates the file first'
              r,←'' 'Examples:'
              r,←⊂'    Edit myfile.txt in the \tmp folder:'
              r,←⊂'        ]file.',Cmd,' \tmp\myfile.txt'
              r,←⊂'    Create mynewfile.txt in the \tmp folder and edit it:'
              r,←⊂'        ]file.',Cmd,' \tmp\mynewfile.txt -create'
              r,←'' 'Note that )ED can also edit native files:' '        )ED \tmp\myfile.txt'
          :EndIf
     
      :Case 'Touch'
          :If 0=level
              r,←⊂'    ]',Cmd,' <file>'
          :Else
              r,←'' '<file>  native file to locate/create'
              r,←'' 'Example:' '    Check if abc.xyz exists under \tmp, and if not, create it:'
              r,←⊂'        ]',Cmd,' \tmp\abc.xyz'
              r,←⊂'    \tmp\abc.xyz created.'
          :EndIf
      :Case 'ToLarge'
          :If 0=level
              r,←⊂'    ]',Cmd,' <dir> [-backup[=<ext>]] [-list] [-recursive] [-verbose]'
          :Else
              r,←'' '<dir>            target directory'
              r,←⊂'-backup[=<ext>]  adds <ext> (default is ".bu") to the extension of the original files'
              r,←⊂'-list            lists small-span files in <dir> without converting them'
              r,←⊂'-recursive       applies the command recursively (includes all sub-folders)'
              r,←⊂'-verbose         provides additional details'
              r,←'' 'Example:'('        ]',Cmd,' /my/project -rec -ver -back=.D32')
              r,←⊂'    "C:/my/project/t32.DCF" made into large-span format and backed up to "C:/my/project/t32.DCF.D32"'
              r,←'    * "C:/my/project/talt/fo1.DCF" is already large-span' '    ...' '    19 files modified'
              r,←'' 'This user command uses ⎕FCOPY to perform the conversion. This means that it can take a considerable amount of time to execute if there are very large files, but all the timestamps are preserved.'
          :EndIf
      :EndSelect
      r,←(level=0)/''(']FILE.',Cmd,' -?? ⍝ for more info')
    ∇

    Open←{0::0⊣⎕←'*** Unable to open: ',⎕em ⎕en ⋄ 22::⍵ ⎕ncreate 0 ⋄ ⍵ ⎕ntie 0}

    ∇ r←Run(Cmd Args);ct;w;nt;n;tie;text;copy;ci;file;oldcaption
      r←0 0⍴''
      :If nt←3>ci←AllCmds⍳⊂Cmd
        ⍝ The utility functions are in this script
          ct←⎕SE.SALT.Load'tools\code\fileUtils -noname'
      :EndIf
     ⍝ We'll run one of them on these folders
      :If nt∧0≡w←⊂Args.Switch'folder'
          w←('∘'{1↓¨(v∊⍺)⊂v←⍺,⍵}⎕SE.SALT.Settings'workdir')⎕SE.SALTUtils.ClassFolder¨⊂''
      :EndIf
     
     ⍝ Is this NOT a regular expression?
      :If nt>Args.Switch'regex'
          Args.Arguments[1]←⊂'{}\.[^|]$(?*)+'{pat←⍵ ⋄ r←1+b←⍵∊⍺ ⋄ (pat b)←r∘/¨pat b ⋄ pat⊣((≠\b)/pat)←'\'}1⊃Args.Arguments
      :EndIf
     
      :Select ci
      :Case 1 ⍝ Find
          r←{'Total ',' found',⍨⍕+/{⍬⍴2⊃⎕VFI ⍵}¨⍵}w ct.showExpr¨⊂Args.(Arguments,types 1 options)
     
      :Case 2 ⍝ Replace
          r←{'Total ',' changes made',⍨⍕+/{⍬⍴2⊃⎕VFI ⍵}¨⍵}w ct.replExpr¨⊂Args.(Arguments,types 1 options backup)
     
      :Case 3 ⍝ Edit
          file←⎕SE.SALTUtils.fixFsep 1⊃Args.Arguments
          :If Args.create ⋄ →0/⍨0≡nt←Open file ⋄ ⎕NUNTIE nt ⋄ :EndIf
          :If 0≡text←{22::0 ⋄ ⎕SE.SALTUtils.GetUnicodeFile ⍵}file
              r←'** File not found'
          :Else
              (CR LF)←nt←⎕UCS 13 10 ⋄ r←'File not changed'
              copy←text←nt LF ⎕R(CR,⊂,CR)⍠'Mode' 'D'⊢text  ⍝ separate lines
              :If ⎕SE.SALTUtils.WIN ⋄ oldcaption←⎕SE.UCMD 1⌽'"caption editor "',1⊃Args.Arguments ⋄ :EndIf
              ⎕ED'text'
              :If ⎕SE.SALTUtils.WIN ⋄ {}⎕SE.UCMD'caption editor "',oldcaption,'"' ⋄ :EndIf
              :If copy≢text
                  :If ~⎕SE.SALTUtils.WIN ⋄ nt←LF ⋄ :EndIf
                  text←CR ⎕R nt⍠'Mode' 'D'⊢text
                  text ⎕SE.SALTUtils.PutUTF8File file ⋄ r←'File modified'
              :EndIf
          :EndIf
     
      :Case 4 ⍝ Touch
          r←1⊃Args.Arguments
          :Trap 0
              ⎕NUNTIE r ⎕NTIE 0
              r,←' exists.'
          :Case 22
              ⎕NUNTIE r ⎕NCREATE 0
              r,←' created.'
          :Else
              r←'*** Unable to access: ',⎕EM ⎕EN
          :EndTrap
     
      :Case 5 ⍝ ToLarge
          ⍝ Transform all 32b files in Args into 64b format
          ct←⎕SE.SALT.Load'tools\code\fileUtils -noname'
     
          ⍝ Get the list
          :If Args.recursive ⋄ r←1 ct.recFLib 1⊃Args.Arguments
          :Else
              r←⎕FLIB 1⊃Args.Arguments
              :If ⎕SE.SALTUtils.WIN
                  r←n⌽(r⌽⍨-n←+/∧\⌽' '=r),(r∧.≠'.')⍀1 4⍴'.DCF'
              :EndIf
          :EndIf
          ⎕←Args.verbose⌿r←↑Args.(backup list)∘ct.make64b¨{⍵↓⍨-⊥⍨' '=⍵}¨↓r
          r←(n←r∧.≠'*')⌿r
          →Args.list/0
          r←(⍕+/n),' files modified'
      :EndSelect
    ∇

    :SECTION Test
    ∇ r←Test dummy;T;cmd;n;tie;file;cf32b;Nix;grps;fol
      grps←List.Group
      r←⍬ ⋄ T←{⎕SE.UCMD(⊃grps[AllCmds⍳⊂cmd]),'.',cmd,' ',⍵}
      Nix←{⍺ ⎕NERASE ⍺ ⎕NTIE ⍵}
      fol←4↑file←'/tmp/filestst.dyalogtestfile'
      cf32b←¯86 13 13 2,(1\⍨¯4,5⍴1 ¯3),(31↑¯15 1 ¯3 1\¯112),¯3,n,(20↑5⍴4↑¯112),(68↑30⍴24↑¯12 ¯71 84 85 ¯59 3),111,(n←7↑3/¯1),16⍴8↑2
      ⎕NUNTIE ⎕NNUMS ⋄ ⎕FUNTIE ⎕FNUMS  ⍝ start clean
      :Trap 22 ⋄ file Nix 0 ⋄ :EndTrap ⍝ Erase if present
      ⎕SE.SALTUtils.makeDir'/tmp'
      ⎕NUNTIE tie⊣(∊'PleaSe' 'presS' 'Esc',¨⊂⎕UCS 13 10)⎕NAPPEND tie←file ⎕NCREATE 0
      :For cmd :In AllCmds
          :Trap n←0
              :Select cmd ⍝ Note: The order of the cases is important
              :CaseList 'Find' 'Replace'
                  n←(8↑T(8↑'"S" "s" P -opt=i'↓⍨8×'Find'≡cmd),' -fol=',fol,' -typ=',file↓⍨file⍳'.')≡'Total 2 '
              :Case 'Edit'
                  n←1 ⍝ (5↑T file)≡'File ' ⍝ Because it will need user action
              :Case 'Touch'
                  file Nix 0
                  n←(T file)≡file,' created.'
                  n∧←(T file)≡file,' exists.'
              :Case 'ToLarge'
                  ⍝ Replace text file with short-span component file:
                  ⎕NUNTIE tie⊣cf32b ⎕NAPPEND 83,⍨file ⎕NCREATE file Nix tie
                  n←(8↑T fol)≡'1 files '
                  n∧←64='S'⎕FPROPS tie←file ⎕FTIE 0
              :EndSelect
          :EndTrap
          r,←n
      :EndFor
      ⎕NUNTIE-|tie ⋄ ⎕FUNTIE|tie
      file Nix 0
     
    ∇
    :ENDSECTION

:endnamespace ⍝ Files  $Revision: 1571 $
