﻿:namespace Monitor ⍝ V2.17
⍝ Implement "Monitor", "APLMON", "RunTime" and "SpaceNeeded" User Commands.
⍝ 2014 06 23 DanB: Disabled APLMON, fixed [11158]
⍝ 2015 05 31 Adam: Removed APLMON & Monitor & and their sub-fns (broken and obsolete to Profile)
⍝ 2015 06 01 Adam: Complete Help overhaul and auto PW
⍝ 2015 06 02 Adam: ]?cmd refs all help levels
⍝ 2015 11 12 Adam: moved help layout to framework
⍝ 2015 12 30 Adam: added Test
⍝ 2016 12 12 Adam: ]runtime column header over timings now say "(ms)" instead of the mysterious "Exp"
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -??
⍝ 2018 05 02 Adam: help tweaks
⍝ 2019 01 29 Adam: help tweaks
⍝ 2020 10 27 Adam: ]spaceneeded sanity check

    ⎕IO←1 ⋄ ⎕DIV←⎕ML←0 ⍝ Set those here to avoid inheriting them from outside

    AllCmds←'RunTime' 'SpaceNeeded'

    ∇ r←List
      :Access Shared Public
      r←⎕NS¨0⍴¨AllCmds               ⍝ create N commands
      r.Name←AllCmds                 ⍝ their names
      r.Desc←'Report execution time of one or more expressions' 'Compute memory needed to run expression(s)' ⍝ descriptions
      r.Group←⊂'Performance'         ⍝ same group
      r.Parse←' -repeat= -details[=]all none ai -compare' '99S'
    ∇

    ∇ r←level Help Cmd
      :Access Shared Public
      :Select Cmd
      :Case 'RunTime'
          r←List.Desc[AllCmds⍳⊂Cmd]
          r,←⊂'    ]',Cmd,' [<expression> [<expression> ... [-compare]]] [-details[=all|non|ai]] [-repeat=<limit>]'
          r,←⊂''
          :If 0=level
              r,←⊂']',Cmd,' -??  ⍝ for more information'
              r,←⊂']',Cmd,' -??? ⍝ for examples'
          :ElseIf 1=level
              r,←⊂'Argument is a series of expressions to run'
              r,←⊂''
              r,←⊂'-compare  compare the expressions using the first one as base line.'
              r,←⊂'-details[=all|non|ai]  specify which details to include. It can be one of the following:'
              r,←⊂'    all   (default) ⎕AI and ⎕MONITOR CPU and elapsed numbers with test function results'
              r,←⊂'    none  only numeric results in millisecs as a matrix of Nx2'
              r,←⊂'    ai    numeric results of ⎕MONITOR and ⎕AI as a matrix of Nx4'
              r,←⊂''
              r,←⊂'-repeat=<limit>  repeats each expression until <limit> is reached. Valid limits are:'
              r,←⊂'    <i>      repeat each expression <i> times'
              r,←⊂'    <t>s     repeat until at least <t> seconds have passed'
              r,←⊂'    <t>m     repeat until at least <t> milliseconds have passed'
              r,←⊂'    <i>⌈<t>  repeat until both limits have been reached'
              r,←⊂'    <i>⌊<t>  repeat until at least one limit has been reached'
              r,←⊂''
              r,←⊂']',Cmd,' -??? ⍝ for examples'
          :Else            ⍝ 1<level
              r,←'Examples:' ''
              r,←⊂'    To measure the time needed to execute a single expression:'
              r,←⊂'        ]',Cmd,' {+/1=⍵∨⍳⍵}¨⍳1000'
     
              r,←⊂'    * Benchmarking "{+/1=⍵∨⍳⍵}¨⍳1000"'
              r,←⊂'                 (ms) '
              r,←⊂'     CPU (avg):    15 '
              r,←⊂'     Elapsed:      15 '
              r,←⊂''
              r,←⊂'    To repeatedly execute this expression twenty times or for two seconds, whichever is less (averaging the results):'
              r,←⊂'        ]',Cmd,' {+/1=⍵∨⍳⍵}¨⍳1000 -repeat=20⌊2s'
              r,←⊂'    * Benchmarking "{+/1=⍵∨⍳⍵}¨⍳1000", repeat=20⌊2s'
              r,←⊂'                        (ms) '
              r,←⊂'     CPU (avg):  16.91666667 '
              r,←⊂'     Elapsed:    16.625      '
              r,←⊂''
              r,←⊂'    To return raw ⎕MONITOR and ⎕AI data on timings (average of 50 executions) of two expressions:'
              r,←⊂'        ]',Cmd,' {+/1=⍵∨⍳⍵}¨⍳1000 ⍳⍨⍳1e6 -details=ai -rep=50'
              r,←⊂'    16.56 16.46 16.56 16.46'
              r,←⊂'     2.5   2.46  2.5   2.52'
              r,←⊂''
              r,←⊂'    To compare timings of two expressions that give the same result:'
              r,←⊂'        ]',Cmd,' ⍴⍴⍳9 ⍴∘⍴⍳9 -compare'
              r,←⊂'      ⍴⍴⍳9  → 7.2E¯8 |    0% ⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕                            '
              r,←⊂'      ⍴∘⍴⍳9 → 2.2E¯7 | +207% ⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕ '
              r,←⊂''
              r,←⊂'    To compare timings of two expressions that give different results (a * prefixes expressions that gave a different result to the first expression):'
              r,←⊂'        ]',Cmd,' ⍴⍴⍳9 ⍴⍴⍪⍳9 ⍴⍴⍳4+5 -compare'
              r,←⊂'      ⍴⍴⍳9   → 7.1E¯8 |   0% ⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕                    '
              r,←⊂'    * ⍴⍴⍪⍳9  → 1.3E¯7 | +88% ⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕ '
              r,←⊂'      ⍴⍴⍳4+5 → 1.3E¯7 | +78% ⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕   '
              r,←⊂''
              r,←⊂']',Cmd,' -??  ⍝ for syntax information'
          :EndIf
      :Case 'SpaceNeeded'
          r←List.Desc[AllCmds⍳⊂Cmd]
          r,←⊂'    ]',Cmd,' [<expression> [<expression> ...]]'
          r,←⊂''
          :If 0=level
              r,←⊂']',Cmd,' -?? ⍝ for more information and example'
          :Else
              r,←⊂'Argument is a series of zero or more expressions to test'
              r,←'' 'Result is number of bytes needed to execute each expression'
              r,←'' 'Example (may take a long time to compute, depending on ⎕WA):'
              r,←⊂'        ]',Cmd,' ⍳1e6 ⍳⍳9'
              r,←⊂'    ⍳1e6  4000102'
              r,←⊂'    ⍴⍳8       818'
          :EndIf
      :EndSelect
    ∇

    ∇ r←Run(Cmd Args);cs;fns;top;min;switch;expr;cap;file;ai;on;off;report;clear;repeat;n;path;exp;f;minrun;t;eex;runfor;fn;branch;cond;results;all;tell;detail;ran;mondata;reparg;showai;showresult;done;cnt;dya
      :Access Shared Public
     
      cs←##.THIS ⍝ Calling Space
     
      :Select Cmd
      :Case 'RunTime'
          ran←1⊃(repeat fn runfor)←splitRepeat⍕reparg←Args.repeat ⋄ (showai showresult)←∨\'ai' 'none'∊⊂Args.details
          results←0(2+2×showai)⍴all←∨/Args.details∘≡¨1 'all' ⋄ detail←{⍵:⍺}∘all ⋄ tell←{⍵:⍺}∘(⍱/Args.details∘≡¨'none' 'ai')
          :For exp :In (Args.compare⍲0≡Args.details)/Args.Arguments
              tell''
              tell⍕'* Benchmarking "',exp,'"',(reparg≢0)/', repeat=',reparg
     
            ⍝ Find how long it takes to do it once:
              dya←{2::1 ⋄ 85⌶⍵}'0' ⋄ {}⎕WA ⍝ max memory use
              r←1 ⋄ ai←⎕AI ⋄ {}{85::r∘←0 ⋄ dya:1 cs.(85⌶)⍵ ⋄ cs.(85⌶)⍵}exp ⋄ ai←2↑1↓⎕AI-ai
            ⍝ ai←⎕AI ⋄ r←{85::0 ⋄ dya:1 cs.(85⌶)⍵ ⋄ cs.(85⌶)⍵ ⋄ 1}exp ⋄ ai←2↑1↓⎕AI-ai ⍝ Is this valid to remove ∘←
              detail'Test run took ',(⍕ai),' msecs'
              minrun←512 64 8 1[⎕IO++/1 10 100<1↑ai] ⋄ eex←{1↓⍵⍴⍨⍺×⍴⍵}∘('⋄',(r/'{}'),exp)
     
            ⍝ Have we already made the test?
              :If (runfor≤1↓ai)∧repeat≤1 ⋄ ai←ai∘.×1 1 0 ⍝ make ⎕MON values same
                  detail'** Expression was only run once' ⋄ mondata←⍬
     
              :ElseIf t←∧/cond←1<runfor,repeat ⍝ we have both # of times AND period
                  n←⍕⎕THIS ⋄ cond←1⌽cond,t
                  branch←'→2×⍳',↑,/cond/('(0<',n,'.cnt←',n,'.cnt-1)')('∧∨'[1+'⌈'∊fn])(n,'.n>⎕ai[2+⎕io]')
                  (n minrun)←defineFn minrun branch
                  cnt←⌈repeat÷minrun
                  2 3 ⎕MONITOR'f' ⋄ n←runfor+3⊃ai←⎕AI ⋄ f ⋄ ai←2↑1↓⎕AI-ai
                  ran←minrun×1⍴r←2 3↑0 1↓mondata←⎕MONITOR'f' ⋄ ai←⍉ai⍪0 1↓r
     
              :ElseIf runfor>0  ⍝ run for a specified period
                ⍝ Define temp fn to run until time limit, set monitor on it, and run it
                  (n minrun)←defineFn minrun,⊂'→2×⎕ai[2+⎕io]<',(⍕⎕THIS),'.n'
                  3 2 ⎕MONITOR'f' ⋄ n←runfor+3⊃ai←⎕AI ⋄ f ⋄ ai←2↑1↓⎕AI-ai
                  ran←minrun×1⍴r←2 3↑0 1↓mondata←⎕MONITOR'f' ⋄ ai←⍉ai⍪0 1↓r
     
              :Else  ⍝ repeat a specific # times
                ⍝ Create a fn that makes 2 sets of tests in blocks of minrun and remainder:
                  n←(⍕⎕THIS),'.n' ⋄ branch←'→2×⍳0<',n,'←',n,'-1'
                 ⍝ Build a fn that will be used to perform the test
                  ran←×/((n cnt)minrun)←defineFn repeat branch
                  4 2 3 ⎕MONITOR'f' ⋄ ai←⎕AI ⋄ f ⋄ ai←2↑1↓⎕AI-ai
                  r←+⌿2 2 2⍴4 2↑0 2↓mondata←⎕MONITOR'f' ⋄ ai←⍉ai⍪r
     
              :EndIf
            ⍝ Show ⎕MONITOR info plus ⎕AI's and branch line info if details wanted
              cap←'' '⎕AI' '(ms)' '[2]→line' ⋄ t←mondata≢⍬
              tell(1 0 1 0∨all∧t)/cap⍪'CPU (avg):' 'Elapsed:',(n←ai÷ran)
              detail'Effective repeat=',(⍕ran),t/', # expression on repeat line was ',⍕minrun
              detail'⎕MONITOR data:'mondata
              results⍪←,⍉n[;2,⍳showai]
          :EndFor
          r←showresult⌿results
     
          :If Args.compare
              :If 1<⍴Args.Arguments
                  r←0 1↓⍕⍪r''(cmpx Args.Arguments)
              :Else
                  r←'** You need to supply more than one expression to be able to use -compare'
              :EndIf
          :EndIf
     
      :Case 'SpaceNeeded'
          r←0 2⍴0
          :For exp :In Args.Arguments
              r⍪←exp(wsreq exp)
          :EndFor
     
      :EndSelect
    ∇

      cmpx←{                                      ⍝ Approx expression timings.
          1=≡,⍵:∇⊂,⍵                              ⍝ single expression: enclose.
          1{                                      ⍝ starting with one,
              ⍬⍴2↓(##.THIS⍎⍵)-⎕AI                       ⍝ time ⍺ expr-iterations.
          }{⎕IO ⎕ML←0                             ⍝ local sysvars (see Notes).
              times←⍺ ⍺⍺{                         ⍝ time each expression.
                  ⍺ ⍺⍺'{0<⍵:∇⍵-1{⍺}',⍵,'⋄⎕AI}⍺'   ⍝ execute expression in ⍺-loop.
              }¨⍵                                 ⍝ ... for each expression.
              1000>+/times÷⍴,⍵:(⍺×2)∇ ⍵           ⍝ too quick: reiterate × 2.
              null←'{0<⍵:∇⍵-{⍵}1⋄⎕AI}⍺'           ⍝ null loop for "control" time.
              nett←times-⍺ ⍺⍺ null                ⍝ times - null loop overhead.
              hist←↑40{(⌊0.5+⍺×⍵÷⌈/⍵)⍴¨'⎕'}nett   ⍝ simple histogram.
              secs←⍺{↑6 ¯2∘⍕¨⍵÷⍺×1000}nett        ⍝ e-format seconds.
              rels←⌊100×¯1+nett÷1⌈⊃nett           ⍝ percentages relative to 1st.
              sign←{(1+×⍵)⊃'- +'}                 ⍝ sign: - +.
              fpcs←⌽↑{'%',⌽(sign ⍵),⍕|⍵}¨rels     ⍝ formatted percentages.
              diff←{⍵⊃' *'}¨×{⍵⍳⍵},⍵⍵¨⍵           ⍝ result differences.
              exps←diff,' ',↑⍵                    ⍝ exprs with diff markers.
              pref←{↑⍺∘,¨↓⍵}                      ⍝ ⍺-prefix of rows of matrix ⍵.
              cmps←' | 'pref fpcs,' ',hist        ⍝ percents and histogram.
              1=⍴,⍵:secs                          ⍝ single expr: just output time.
              exps,' → 'pref secs,cmps            ⍝ [*] expr → secs | %s histogram.
          }{                                      ⍝ right operand:
              ##.THIS⍎⍵                                  ⍝ execute expr in its native envt.
          }⍵                                      ⍝ vector of subject expressions.
      }

    ∇ (cnt minrun)←defineFn(minrun branch);done
      cnt←1 ⋄ done←0
      :Repeat
          :Trap 10 11 16
              done←÷'f'∊⎕FX'f' '⎕cs cs'(eex minrun),⊂branch
          :Else
              cnt×←2 ⋄ minrun←⌈minrun÷2
          :EndTrap
      :Until done
    ∇

    ∇ (times fn period)←splitRepeat string;n;b;K;M
     ⍝ Parse 'repeat' switch's value: # of times, period, min/max
     ⍝ The string may be a single number optionally followed by 'm' to denote milliseconds or 's' (secs)
     ⍝ or it may be 2 numbers, one of which followed by 'm' or 's', separated by either ⌈ or ⌊
      (times fn period)←1 '' 0 ⋄ K←1,1000*∨/b←string='s' ⋄ (b/string)←'m'        ⍝ 1 sec=1000 msecs
      (b n)←⎕VFI b\string/⍨b←~string∊'⌈⌊m' ⋄ b←(∧/b)∧(+/M←string='m')∊(⍴n)↓0 0 1 ⍝ accept only 1 m
      'Invalid repetition number'⎕SIGNAL 11/⍨b≤⍴string~⎕D,' m⌈⌊'
      :If 1=⍴n←⌈n
          (times period)←K×1 0⌈(∨/M)⌽n,0
      :Else
          fn←1↑'⌈⌊'∩string,'⌊' ⍝ ⌊ implied otherwise
          (times period)←K×n⌽⍨∨/((∨\M)/string)∊⎕D
      :EndIf
    ∇

      wsreq←{                             ⍝ WS required to execute expression ⍵.
          _←##.THIS⍎⍵                     ⍝ error if the expression cannot be run at all
          ⍺←¯700+0 ∇'⍬'                   ⍝ ⍺ is calibration constant.
          {1::0 ⋄ ⍵⍴' '}⎕WA:              ⍝ force initial WS FULL to set ⎕DM.
          ⎕WA-⍺+⍵{                        ⍝ WS required.
              1::1 1 0/⍵                  ⍝ WS FULL:: explore lower range (lo mid).
              (0 1 1/⍵){⍺}⍺⍺{##.THIS⍎⍺}⍺⍴' '     ⍝ execute subject expr with restricted WA.
          }{                              ⍝ binary search for WS FULL failure point:
              mid←⌊+/⍵÷2                  ⍝ mid point of range.
              mid∊⍵:⍬⍴⍵                   ⍝ convergence: maximum packing value.
              lo hi←⍵                     ⍝ lower and upper bounds.
              ∇ mid ⍺⍺ lo mid hi          ⍝ explore lower or upper range.
          }0 ⎕WA                          ⍝ starting with maximum range.
      }

    :SECTION Test

    ∇ r←Test dummy;T;cmd;n;v
      r←⍬ ⋄ T←{⎕SE.UCMD(⊃List.Group[AllCmds⍳⊂cmd]),'.',cmd,' ',⍵}
      :For cmd :In AllCmds
          :Trap n←0
              :Select cmd
              :Case 'RunTime'
                  T'⍳1E7'
                  T'⍴⍴⍳9 ⍴∘⍴⍳9 -compare'
                  T'⍳⍳9 -details'
                  T'"⌹4 4⍴!⍳16" -repeat=20⌊2s'
                  n←1
              :Case 'SpaceNeeded'
                  n←6 7 2 16≡⌊⍟⍎,⍕'⍳'~¨⍨T'⍳1e3 ⍳⍳9'
              :EndSelect
          :EndTrap
          r,←n
      :EndFor
    ∇

    :ENDSECTION

:Endnamespace ⍝ Monitor  $Revision: 1617 $
