﻿:namespace newcmd ⍝ V2.04
⍝ This class will help create a new user command
⍝ 2015 09 23 modified to hide switches group and offer MyUCMDs folder to save
⍝ 2015 11 12 Adam: moved help layout to framework
⍝ 2016 02 18 Adam: Fixed formatting problem in F1 help
⍝ 2016 07 26 Adam: Save dialog now says [Save] instead of [Open]
⍝ 2017 03 16 Adam: Unfreeze session, update look
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -??
⍝ 2018 04 30 Adam: Centre form
⍝ 2018 05 07 Adam: Help tweaks, keep help open
⍝ 2018 06 30 Adam: pixel scaling; cross-platform; add -nogui; multiple args; args can have groups
⍝ 2019 01 30 Adam: help
⍝ 2020 06 19 MBaas: Fix number of dashes in hint
⍝ 2021 02 18 Adam: ⎕C
⍝ 2021 08 12 Adam: Link to Parse docs

⍝ This will first create a form to gather basic info about the user commands
⍝ to create then construct the frame of the namespace which can be edited before saving it
⍝ as a user command.

    ⎕IO←1 ⋄ ⎕ML←1 ⋄ ⎕WX←3 ⍝ we need to do this for the font in the form

    ∇ W←W
      W←⎕SE.SALTUtils.WIN
    ∇

    DESC←'Create one or more new user commands',W/' (optionally using a GUI)'

    ∇ r←List
      r←⎕NS ⍬
    ⍝ Name, group, short description and parsing rules
      r.Name←'UNew'
      r.Group←'UCMD'
      r.Desc←DESC
      r.Parse←'-nogui'
    ∇

    ∇ r←Run(Cmd Input)
      ⍝:If ~W
      ⍝:OrIf ##.RIU
      r←NewCmd Input
      ⍝:Else
      ⍝    {}⎕SE.UCMD&'r←',Cmd,' Input'
      ⍝:EndIf
    ∇

    ∇ r←level Help Cmd;h
      r←⊂DESC
      :If ~W
      :OrIf 1≥level
          r,←⊂'    ]',Cmd,' [[<group>.]<name>]',W/' [-nogui]'
          r,←⊂''
          :If 0=level
              r,←⊂']',Cmd,' -??  ⍝ for more information and example'
          :Else ⍝ 1=level on Windows; 1≤level on non-Win
              r,←⊂'[<group>.]<name>  name, optionally with group name, for new user command'
              r,←W/'' '-nogui            do not pre-populate basic details (name, description, syntax, etc.) in a GUI'
              r,←'' 'NOTE:  this command will open an Edit window comprising skeleton code for development'
              r,←'' 'Example:' '    To create a new command named "Spiffy":'('        ]',Cmd,' Spiffy')''
          :EndIf
          r,←W/⊂']',Cmd,' -??? ⍝ for GUI element details'
      :Else
          r,←HELP
          r,←⊂']',Cmd,' -?? ⍝ for syntax information'
      :EndIf
    ∇

      HelpName←{
          ⍺←0
          n←(1 ⎕C⊃⌽⍵),(⍺≥0)/'.',⊃⍵
          ']',n,(×|⍺)/' -','?'⍴⍨|⍺
      }

      Template←{
          parts←'.'(≠⊆⊢)⍵
          ng←⌽parts,⍨'MyCmds' 'MyCmd'↓⍨-≢parts
          ng,'' ''(0 5⍴⊂'')('Help text to appear for ] -?? and ',¯1 HelpName ng)(,⊂'Help text to appear for ',1 HelpName ng)
      }

    ∇ r←NewCmd Input;Form1;gui;CmdsQueue;CmdsReady
    ⍝ Enter command details thru a form them make it real
      CmdsQueue←∪Template¨(⊢↑⍨1⌈≢)Input.Arguments
      CmdsReady←⍬
      gui←W>Input.nogui
      :If gui
          FORM←MAKEhForm
          FORM FILLhForm 2↑⊃CmdsQueue
          ⎕DQ FORM      ⍝ several commands can be defined here
      :EndIf
      :If gui≤×≢CmdsReady
          r←gui MAKEhClass CmdsReady,CmdsQueue
          {⎕EX FORM}⍣gui⊢⍬⊤⍬
      :Else
          r←'No commands created.'
      :EndIf
    ∇

    ∇ fname FILLhForm namgrp;f1;full
    ⍝ Fill the form with default values
      :With fname
          sdt.Text←sdt.Tip←'Help text to appear for ',1 ##.HelpName namgrp
          ldt.Text←ldt.Tip←'Help text to appear for ',2 ##.HelpName namgrp
          namet.Text grpt.Text←namgrp
          mlt.Text←Group0.nat.Text←''
          Group0.nat.Value←⍬ ⍝ because it is not reset when Text is assigned
          Group0.(max long).State←0
          Group1.G.Values←4 5⍴⊂''
          Group1.Visible←usemod.State←0
      :EndWith
      ⍝f1←fname,'.',(1+' '∧.=1⊃namgrp)⊃'grpt' 'namet'
      f1←fname,'.','namet'
      ⎕NQ f1'GotFocus'
    ∇



    ∇ {fname}←MAKEhForm;h;lm;l1;fh;fw;fhw;mw;bsz;∆;ns;CR;Here;cbf;font;evt;t;l2;l3;l4;l5;color;AplFont;⎕ML;aplfont
    ⍝ Create the form to enter new Spice command info
      ⎕ML←1 ⋄ CR←⎕AV[4] ⋄ Here←⍕⎕THIS
      'aplfont'⎕WC(⊂'Font'),'⎕SE'⎕WG'Font'
      'aplfont'⎕WS'Size' 16
      AplFont←⎕WS∘'Font'aplfont
   ⍝ Basic form globals
      h←24 ⋄ lm←16 ⋄ l5←70+l4←150+l3←50+l2←30+l1←20
      (fh fw)←fhw←560 450 ⋄ color←255 150 150 ⋄ mw←fw-2×lm
      :With fname←'Form1'⎕WC'Form' 'New User Command Wizard'('Size'fhw)('Coord' 'ScaledPixel')⍝('EdgeStyle' 'Dialog')('Border' 2)
          TipObj←'tf'⎕WC'TipField'
          t←(1+80=⎕DR'')⊃'Dyalog Alt' 'APL385 Unicode'
          FontObj←⎕SE.SALTUtils.Fonts.Message
          ⎕WS evt←'event' 22(Here,'.ncHelp&')
          'name'⎕WC'Label' 'Name:'(l1 lm)
          AplFont'namet'⎕WC'Edit' ''((l1+1)60)(h 120)evt
          namet.Tip←'Name of the new command. This field is compulsory',CR,'and must follow the rules for valid APL names.'
          'grp'⎕WC'Label' 'Group:'(l1 190)
          AplFont'grpt'⎕WC'Edit' ''((l1+1)240)(h 80)evt
          grpt.Tip←'Name of the group this command will belong to. E.g. if the command',CR,'is math-related, enter something mnemonic like "Calc". This field',CR,'is compulsory and must follow the rules for valid APL names. '
          'ml'⎕WC'Label' 'Min Len:'(l1 330)
          AplFont'mlt'⎕WC'Edit' ''((l1+1)400)(h 30)('FieldType' 'Numeric')evt('ValidIfEmpty' 1)
          mlt.Tip←'Minimum number of characters needed to enter the command.',CR,'Default is 1, but it may be necessary to enter more characters',CR,'if there is a conflict with another command''s name, or even the',CR,'full name if the name shortening functionality has been disabled.'
          'sd'⎕WC'Label' 'Short description:'((l2+2)lm)
          AplFont'sdt'⎕WC'Edit' ''((l2+25)lm)(h mw)('HScroll' 0)evt
          'ld'⎕WC'Label' 'Long description:'((l3+2)lm)
          AplFont'ldt'⎕WC'Edit' ''((l3+25)lm)(110 mw)'multi'evt
     
          :With 'Group0'⎕WC'Group' 'Arguments'(l4 lm)(60 mw)evt
              gl2←7+gl1←15 ⋄ gp2←65+gp1←160
              'na'⎕WC'Label' '# of args:'(gl2 20)
              AplFont'nat'⎕WC'Edit' ''((gl2+1)105)(h 32)('FieldType' 'Numeric')evt('ValidIfEmpty' 1)
              'max'⎕WC'Button' 'Number is maximum:'(gl1 gp1)(h gp2)('Align' 'Left')('Style' 'Check')
              'long'⎕WC'Button' 'Merge trailing arguments:'((gl1+20)gp1)(h gp2)('Align' 'Left')('Style' 'Check')
              nat.Tip←'Enter a value here to limit the number of',CR,'arguments that the command should accept'
              max.Tip←'Check this box if the number of arguments specified',CR,'is the maximum number of arguments allowed'
              long.Tip←'Check this box to merge additional arguments into a',CR,'single value when beyond the specified max number'
          :EndWith
     
          'usemod'⎕WC'Button' 'Use modifiers (switches):'(l5 lm)(h 260)('Align' 'Left')('Style' 'Check')
          'usemod'⎕WS'event' 30(Here,'.G1viz')
          usemod.Tip←'Check this box if the command uses modifiers'
     
          :With 'Group1'⎕WC'Group' 'Modifiers'((l5+h)lm)(163 mw)evt
              AplFont'G'⎕WC'Grid' ⋄ ns←4 ⋄ t←'event' 22(Here,'.ncHelp&')
              'G.e'⎕WC'Edit'('EdgeStyle' 'Recess')t
              'G.c'⎕WC'Combo'('No' 'Yes' 'Maybe')t
     
              'G.b'⎕WC'button' ''('Style' 'Check')t
              AplFont'G.n'⎕WC'Edit'('FieldType' 'Numeric')('ValidIfEmpty' 1)t
              'G'⎕WS'CellHeights'h
              'G'⎕WS'CellSelect' 'Whole'
              'G'⎕WS'CellTypes'(ns 5⍴1 4 2 1 3)
              'G'⎕WS'CellWidths'(⌊75 32 67 130 33×1.2)
              'G'⎕WS'TitleHeight'(2×h)
              'G'⎕WS'ColTitles'('Name'('Min',CR,'len')('Accepts',CR,'values')('Acceptable',CR,'values')('As a',CR,'set'))
              'G'⎕WS'AutoExpand' 1 0
              'G'⎕WS'Input'('G.'∘,¨'ecbn')
              'G'⎕WS'Posn'(20 0)
              'G'⎕WS'ResizeCols'(1 1 0 1 0)
              'G'⎕WS'Size'(133,+/21,G.CellWidths)
              'G'⎕WS'TitleWidth' 0
              'G'⎕WS'Values'(ns 5⍴⊂'')
          :EndWith
          Group1.Visible←0 ⍝ not visble unless usemod is set
     
          cbf←Here,'.NextCmd'
          h←fhw[1]-40
          'next'⎕WC'button' 'Next Command'(h lm)('event' 'select'cbf 1)
          'done'⎕WC'button' 'Done'(h,5+2⊃next.(Size+Posn))('event' 'select'cbf 0)
          'cancel'⎕WC'button' 'Cancel'(h,5+2⊃done.(Size+Posn))('cancel' 1)('event' 'select' 1)
      :EndWith
    ∇

    ∇ G1viz msg
⍝ Set visibility according to value of button
      Form1.Group1.Visible←Form1.usemod.State
    ∇

    ∇ ncHelp msg;f;sz;txt;evt
      :If 'F1'≡3⊃msg
          evt←'event' 22 1 ⍝ terminate on ANY char
          'f'⎕WC'form' 'Help for newcmd'(100 500)(sz←730 630)('coord' 'pixel')evt
          'f.t'⎕WC'edit'(∊HELP,¨⊂⎕UCS 13 10)(0 0)(sz-1)'multi'evt
          'f.t'⎕WS'Font'⎕SE.SALTUtils.Fonts.Message
          ⎕DQ'f'
      :EndIf
    ∇

    CurrentCmds←{6::0 ⋄ ⎕se.SALTUtils.lCase¨⎕SE.Dyalog.SALT.List[;1]}0

    ∇ more NextCmd arg;ng;gdata;any;t;anytxt;Msg;val
    ⍝ Callback fn for the 'Next' button on Form1
    ⍝ Verify entered data. 'more' means 'keep entering data if checks succeed'
      :With FORM
          Msg←##.Msg
          any←∨/''∘≢¨gdata←Group1.G.Values ⋄ ng←namet.Text grpt.Text
          {}÷'STOP'≢namet.Text
          :If more∨(1∊any)∨∨/anytxt←' '∨.≠¨namet.Text Group0.nat.Text sdt.Text,⊂∊ldt.Text   ⍝ any new fields?
              :If ∨/t←¯1=⎕NC ng
                  Msg'Name must be APL-like'(⍕'Enter a valid',((t∧⍲/t)/'cmd' 'group')'name')
                  ⎕NQ'namet' 'GotFocus'
                  →0
              :ElseIf (⎕SE.SALTUtils.lCase¨ng[1]~¨' ')∊##.CurrentCmds
                  Msg'This command already exists' 'Enter another name'
                  ⎕NQ'namet' 'GotFocus'
                  →0
              :ElseIf 1↑0≥Group0.nat.Value
                  Msg'Invalid number of arguments' 'Enter a number >0'
                  ⎕NQ'Group0.nat' 'GotFocus'
                  →0
              :ElseIf ∨/t←¯1=any/⎕NC gdata[;1]
                  Msg'Invalid modifier name' 'Enter a valid APL name'
                  ⎕NQ'Group1.G' 'GotFocus' ⍝ which t?
                  →0
              :ElseIf t≢∪t←any/gdata[;1]
                  Msg'Modifier names not unique' 'Rename same name modifiers'
                  →0
              :ElseIf ∨/any/(gdata[;4]≡¨1)∧0∊¨⍴¨gdata[;3]
                  Msg'Invalid SET values' 'Enter at least ONE character of the set to use'
                  →0
              :ElseIf ~anytxt[3]
                  Msg'Short description mandatory' 'Enter a short description for this command'
                  ⎕NQ'sdt' 'GotFocus'
                  →0
              :ElseIf ~anytxt[4]
                  Msg'Long description mandatory' 'Enter a proper description for this command'
                  ⎕NQ'ldt' 'GotFocus'
                  →0
              :Else ⍝ looks fine, gather cmd data
                  t←Group0.(max long).State ⋄ val←t{0∊⍴⍵:⍕1∩⍺ ⋄ ⍵}⍕Group0.nat.Value
                  ##.CmdsReady,←⊂ng,(⊂mlt.Text),(⊂val,t/'SL'),(any⌿gdata)sdt.Text ldt.Text
                  ##.CmdsQueue↓⍨←1
              :EndIf
          :EndIf
      :EndWith
      :If more
          :If ×≢CmdsQueue
              FORM FILLhForm 2↑⊃CmdsQueue
          :Else
              FORM FILLhForm'MyCmd' 'MyCmds'
          :EndIf
      :Else
          ⎕EX FORM ⍝ Erase Form1 here to end this jig
      :EndIf
    ∇

    ∇ tn←MAKEhSwitches mat;st;ml
    ⍝ Make switches descriptions
      tn←'-',¨mat[;1]~¨' '                    ⍝ name
      ml←(⍴¨tn)⌊1+|⊃¨mat[;2],¨0               ⍝ no neg #s
      tn←tn{⍵≤2:⍺ ⋄ ⍺[⍳⍵],'(',⍵↓⍺,')'}¨ml     ⍝ add ()s to denote "not necessary"
      st←'=∊'[1+1∊¨mat[;5]]                   ⍝ parameter style
      st←st{(⍵/'['),⍺,⍵/']'}¨'M'∊¨mat[;3]     ⍝ add [] if 'maybe'
      tn←⍕tn,¨(~'N'∊¨mat[;3])/¨st,¨mat[;4]    ⍝ add validation parameters
    ∇

    ∇ r←gui MAKEhClass cmdlist;src;qu;in;t;i;name;fname;F;cmds;newname;prev;edr;same;now;qu2;one
     ⍝ Create a namespace template from a list of commands descriptions
      →(⍴cmdlist)↓0
      one←1=≢cmdlist
      qu←{Q,⍨Q,(1+⍵=Q←'''')/⍵}
      qu2←{1=≢c←∪⍵:'⊂',⊃c ⋄ 1↓∊' '∘,¨⍵}qu¨
     ⍝ Find a name for the namespace in the ws - this can be changed when editing it
      src←⍴i←0
      :While 0≠#.⎕NC name←('MyCmds'↓⍨-one),(0≠i)/⍕i ⋄ i+←1 ⋄ :EndWhile
     
     ⍝ Create the namespace source
      src,←⊂':Namespace ',name
      src,←('⍝ Custom user commands'↓⍨-one)'' '    ⎕IO←1 ⋄ ⎕ML←1' ''
      src,←⊂'    ∇ r←List'
      src,←⊂'      r←⎕NS¨',(⍕≢cmdlist),'⍴⊂⍬'
      src,←⊂'    ⍝ Name, group, short description and parsing rules'
      t←(∊⍴¨cmds←' '~⍨¨1⊃¨cmdlist)⌊⍎¨'0',¨(3⊃¨cmdlist)~¨⊂'-¯' ⍝ minimum length
      src,←⊂'      r.Name←',(',¨'/⍨1∊≢¨cmds),qu2 t{⍺≤1:⍵ ⋄ (⍺↑⍵),'(',⍺↓⍵,')'}¨cmds
      src,←⊂'      r.Group←',qu2 2⊃¨cmdlist
    ⍝ Put in short descriptions
      t←('      r['∘,,∘'].Desc←')∘⍕¨in←⍳≢cmdlist
      src,←t,¨qu¨6⊃¨cmdlist
    ⍝ Parsing rules
    ⍝ The rules are made up of the ## of args followed by the switches description
      t←MAKEhSwitches¨5⊃¨cmdlist ⍝ a table of switch name, style, params & param type
      t,⍨¨←4⊃¨cmdlist
      src,←⊂'      r.Parse←',(qu2 t),' ⍝ ENTER NUMBER OF ARGS AND OPTIONALLY -modifiers HERE (for details, see https://docs.dyalog.com/',(1↓∊'.',∘⍕¨2↑⎕SE.SALTUtils.VERSION),'/User%20Commands%20User%20Guide.pdf#page=18 )'
      src,←'    ∇ ' ''
     
      src,←'    ∇ r←Run(cmd input)' '      :Select cmd'
      :For i :In in
          src,←⊂'      :Case ',(1<⍴t)↓',',qu t←i⊃cmds
          src,←⊂'          r←',(qu'command ',t,' in construction'),' ⍝ ENTER COMMAND CODE HERE'
      :EndFor
      src,←'      :EndSelect' '    ∇ ' ''
     
      src,←'    ∇ r←level Help cmd' '      :Select cmd'
      :For i :In in
          src,←⊂'      :Case ',(1<⍴t)↓',',qu t←i⊃cmds
          :If 1∊⍴t←qu¨i 7⊃cmdlist
              src,←⊂'          r←',⊃t
          :Else
              src,←⊂'          r←⍬'
              src,←'          r,←⊂'∘,¨t
          :EndIf
      :EndFor
      src,←'      :EndSelect' '    ∇ ' '' ':EndNamespace'
     
      newname←name←⍕#.⎕FIX src ⋄ prev←#.⎕NL-9 ⋄ edr←⎕ED name ⋄ same←prev≡now←#.⎕NL-9
      :If same∧0∊⍴edr ⍝ we already have the answer
      :ElseIf ~same
          newname←'#.',⊃now~prev
      :Else
          newname←'#.',edr
      :EndIf
     
      t←(⎕SE.SALTUtils.getEnvir'HOME'),(W/'/Documents'),'/MyUCMDs/'
      3 ⎕MKDIR t
      :If gui
          :If 1∊'Query'Msg('Namespace ',newname,' ready')('The namespace ',2↓newname,' is in the root of the workspace. In order for its new user command',one↓'s to be available in upcoming sessions, the namespace must be saved to file. Do you wish to do so now?')
              'F'⎕WC'FileBox'('Save ',newname,' script')t'*.dyalog'('Event' 71 1)('FileMode' 'Write')('File'(2↓newname,'.dyalog'))
          :AndIf 71∊2⊃2↑in←⎕DQ'F'
              r←3⊃in
              r←⎕SE.SALT.Save newname,' ',r
              F←{(2×':'∊2⊃⍵)↓⍵}¨⎕SE.SALTUtils.PATHDEL(⊢⊆⍨∘~∊⍨)⎕SE.SALT.Settings'cmddir'
              :If ~(⊂t)∊F ⋄ {}⎕SE.SALT.Settings'-permanent cmddir ,',t ⋄ :EndIf
              {}⎕SE.UCMD'ureset' ⍝ to pick up the changes
          :Else
              r←(qu newname),' NOT saved.'
          :EndIf
      :Else
          r←⎕SE.SALT.Save newname,' ',t
      :EndIf
    ∇

    ∇ {r}←{style}Msg(cap txt);mb;evt
      txt←⍕⍣(2<10|⎕DR txt)⊢(⌈/18 0+⍴¨cap txt)↑¨⊂txt
      :If 0=⎕NC'style' ⋄ style←'Msg' ⋄ :EndIf
      'mb'⎕WC'msgbox'cap txt style('Event'(evt←61 62 63)1)
      r←4|evt⍳(⎕DQ'mb')[2]
    ∇

    h←⊢'NAME: name of the new command. This field is compulsory and '
    h,←'must follow the rules for valid APL names.'
    r←h''
    h←⊢'GROUP: name of the group this command will belong to. '
    h,←'E.g. if the command is math-related, enter something mnemonic like "Calc". '
    h,←'This field is compulsory and must follow the rules for valid APL names. '
    r,←h''
    h←⊢'MIN LEN: minimum number of characters needed to enter the command. '
    h,←'Default is 1, but it may be necessary to enter more characters if '
    h,←'there is a conflict with another command''s name, or even the full name '
    h,←'if the name shortening functionality has been disabled.'
    r,←h''
    h←⊢'SHORT DESCRIPTION: short description of what the command does, to be displayed '
    h,←'in response to "] -??". This one-line field is compulsory.'
    r,←h''
    h←⊢'LONG DESCRIPTION: fuller description of what the command does. '
    h,←'Displayed in response to "]mycmd -?". This free-form text is compulsory.'
    r,←h''
    h←⊢'# OF ARGS: number of arguments this command accepts. '
    h,←'Arguments are normally space-delimited words or numbers, '
    h,←'but if a space is part of an argument, enclose the argument in quotes. '
    h,←'May be left blank.'
    r,←h''
    h←⊢'NUMBER IS UPPER LIMIT: ticked to let the command '
    h,←'accept fewer arguments than the # OF ARGS. '
    h,←'E.g. if # OF ARGS is 3 and this box is ticked, '
    h,←'one may enter 0-3 arguments.'
    r,←h''
    h←⊢'MERGE TRAILING ARGUMENTS: ticked to let the '
    h,←'last argument contain whatever follows, even if interrupted by spaces. '
    h,←'E.g. if # OF ARGS is 3 and this box '
    h,←'is ticked, and the user enters: "ONE 2 3 Four", then '
    h,←'the first argument will be "ONE", the second will be "2", '
    h,←'and the third will be "3 Four".'
    r,←h''
    h←⊢'MODIFIERS: have 4 elements each: 1. the modifier name, a valid APL id; '
    h,←'2. the minimum number of characters needed to recognize this modifier (default 1); '
    h,←'3. whether the modifier takes a value or not; 4. the possible values '
    h,←'or single characters which the modifier accepts; 5. whether the previous field '
    h,←'should be understood as a single value or as a set. '
    h,←'E.g. if modifier -ABC= accepts values "123" and "xyz", enter: '
    r,←⊂h
    r,←⊂'│ ABC │ 1 │ Yes │ 123 xyz │ ∨ │'
    r,←⊂'But if it only accepts a single vowel, enter:'
    r,←⊢'│ ABC │ 1 │ Yes │ aeiou   │   │' ''
    HELP←r

:Endnamespace ⍝ newcmd  $Revision: 1692 $
