﻿:Namespace Props ⍝ V1.16
⍝ Implement "ListProp" as "Spice Command". From Ray Cannons' UCMDS.
⍝ 2015 05 21 Adam: NS header
⍝ 2015 06 01 Adam: Help overhaul and auto PW, Tools → MSWin, :Class → :Namespace
⍝ 2015 06 22 Adam: Removed superfluous local, fixed redundant Help text
⍝ 2015 11 12 Adam: moved help layout to framework
⍝ 2017 03 08 Adam: disable on non-Win
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -??
⍝ 2018 04 19 Adam: help text tweak
⍝ 2019 01 16 Adam: help

    ⎕ml←0 ⋄ ⎕io←1
    DESC←'List property names and values for given or current object'

    ∇ r←List
      r←⎕NS''
      r.Name←'GUIProps'
      r.Desc←DESC
      r.Parse←''
      r.Group←'MSWin'
      r/⍨←⎕SE.SALTUtils.WIN
    ∇

    ∇ r←Run(Cmd Args);CL;A;B;SU;Ob
      ⍝ Perform a PropList on current GUI object
      SU←⎕SE.Dyalog.Utils
     
      :If Args∧.=' ' ⍝ Try to pick it up from CurObj
          Args←'⎕SE.cbbot.bandsb2.sb.curobj'⎕WG'Text'
          Args←(¯1+Args⍳'(')↑Args
      :EndIf
      Args←Args~' '
      :If Args≡''
          r←'(No object identified)'
      :Else
          Ob←('⎕SE'⎕WG'CurSpace'),'.',Args
          :If 9≠⎕NC Ob
              (⍎Ob).⎕WX←3
          :OrIf 0=(⍎Ob).⎕NC⊂'PropList'
              r←'Not a GUI object: ',Ob
          :Else
              A←SU.showCol↑0 Listprop Ob
              B←SU.showCol↑1 Listprop Ob
              r←A{↑(↓⍺),↓⍵}B
          :EndIf
      :EndIf
    ∇

    ∇ r←level Help Cmd;t
      r←⊂DESC
      :If 0=level
          r,←⊂'    ]',Cmd,' [<object>]' 
          r,←⊂''
          r,←⊂']',Cmd,' -?? ⍝ for more information and example'
      :Else
          r,←'' '<object>  GUI object to report on (default is reported "current object"). '
          r,←'' 'NOTE:  Only works for GUI objects created by ⎕WC, not for GUI objects created using other techniques.'
          r,←'' 'Example:'
          ⍎⊃r,←⊂'        ''t''⎕WC''timer'' (''active'' 0)'
          r,←⊂'        ]',Cmd,' t'
          r,←'    '∘,¨↓Run Cmd 't'
      :EndIf
    ∇

    ∇ r←arg Listprop guiobj;prop;row;w;split;len;res
      split←{⍺{⍵<⍺-20:⍺ ⋄ ⍵}⍺-+/∧\' '≠⌽⍺↑⍵}
      w←⎕PW-5
      r←,⊂'Properties of ',guiobj
      :With guiobj ⋄ ⎕WX←3
          :For prop :In PropList(~{⍵⍵=0:⍺ ⍺⍺ ⍵ ⋄ ⍵}arg)'MethodList' 'ChildList' 'EventList' 'PropList'
              res←{0::'?' ⋄ ,⍕⍎⍵}prop
              row←prop,':',res
              :If w<⍴row
                  r,←⊂''
                  :While w<⍴row
                      len←w split row
                      r,←⊂len↑row
                      row←len↓row
                  :EndWhile
              :EndIf
              r,←⊂row
          :EndFor
      :EndWith
     
    ∇

:EndNamespace ⍝ Props  $Revision: 1512 $
