﻿:namespace SaltInSpice ⍝ V1.28
⍝ Implement SALT commands within Spice
⍝ 2015 11 12 Adam: moved help layout to framework
⍝ 2015 12 30 Adam: added Test
⍝ 2016 04 07 DanB: Settings example to use ∘
⍝ 2016 11 16 Adam: removed mention of -vars
⍝ 2017 03 01 Adam: updated help to OS appropriate separators
⍝ 2017 07 24 Adam: typo fix
⍝ 2017 09 19 Adam: help text ref to SALT User Guide
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -??
⍝ 2018 04 20 Adam: ]settings settingname -?, add ]Set as alias to ]Settings
⍝ 2018 05 03 Adam: Help tweaks
⍝ 2018 05 31 Adam: [14943] help for track
⍝ 2018 11 05 Adam: Add ]Boot
⍝ 2019 02 04 Adam: help
⍝ 2021 02 18 Adam: ⎕C
⍝ 2022 09 28 Adam: typo

    ⎕ml← ⎕io←1
    Cnames←'Compare' 'RemoveVersions' 'List' 'Load' 'Save' 'Settings' 'Snap'  'Clean' 'Set' 'Boot'

    WIN←'Win'≡3↑⊃#⎕WG'APLVersion'

    ∇ r←List
      r←⎕NS¨(⍴Cnames)⍴⊂''
      r.(Group Parse)←⊂'SALT' ''
      r.Name←Cnames
      r[1].Desc←'Compare two versions of a SALTed item'
      r[2].Desc←'Remove one or more versions of a file managed by SALT'
      r[3].Desc←'List files (default: .dyalog only) and directories in the specified directory'
      r[4].Desc←'Load item from native text file'
      r[5].Desc←'Save item in a native text file (default: same place if already SALTed)'
      r[6].Desc←'Return one or all parameters or set one parameter'
      r[7].Desc←'Save all new or modified items to native text files (unscripted namespaces become directories)'
      r[8].Desc←'Remove SALT tags from the ws or specific items so that SALT no longer saves changes to associated files'
      r[9].Desc←'Return one or all parameters or set one parameter'
      r[10].Desc←'Boot from a file containing instructions or a function'
    ∇

    ∇ Û←Run(Ûcmd Ûargs);Ûriu
     ⍝ Simulate calling directly from the original ns
      Ûriu←{6::0 ⋄ ##.RIU}0
     ⍝ We can't use :With because if a space is returned
     ⍝ as result it will be lost in :endwith
      ⎕CS ##.THIS  ⍝ We know THIS has been set for us
      Û←⍎'⎕SE.SALT.',Ûcmd,' Ûargs' ⍝ Û vars for Snap
      :If Ûriu<Ûcmd≡'RemoveVersions'
          Û←0 0⍴''
      :EndIf
      :If 'Settings' 'Set'∊⍨⊂Ûcmd
      :AndIf ~Ûriu
          Û←⍕Û
      :EndIf
     
    ∇

    ∇ r←level Help Cmd;setting;settings;setParHelp
      (1↑Cmd)←⎕SE.Dyalog.Utils.ucase 1↑Cmd
      :If 'Clean'≡Cmd
          r←⊂'Remove SALT tags from the ws or specific items so that SALT no longer saves changes to associated files'
          r,←⊂'    ]',Cmd,' [<items>] [-deletefiles]'
          r,←⊂''
          :If 0<level
              r,←⊂'<items>  specific items (default all) in the current namespace from which to remove SALT tags'
              r,←'' '-deletefiles  also remove the files associated with the specified items'
              r,←'' 'Examples:' '    Remove all tags in all items in the ws:'('       ]',Cmd)
              r,←'    Remove tags in items A and B and delete their files:'('       ]',Cmd,' A B -deletefiles')
          :EndIf
      :Else
          settings←1 ⎕SE.SALT.Settings'name'
          setting←⎕C##.##.arg∩⎕C⎕A
          :If 'Settings' 'Set'∊⍨⊂Cmd
          :AndIf settings∊⍨⊂setting
              r←⊂']SALT.',Cmd,' ',setting,'  ⍝ determines ',(settings⍳⊂setting)⊃1 ⎕SE.SALT.Settings'desc'
              r,←DescSets setting
              :If 'track'≡setting
                  r,←'' 'Possible values are zero or more of:'
                  r,←⊂'  ∘ compiled  preserves the 400⌶ state of SALTed objects (even though 400⌶ directives are not a visible part of a function''s code). The information is reinstated when an object is loaded into the workspace by SALT.'
                  r,←⊂'  ∘ atinfo    retrieves the function, user and timestamp information (as recorded by the monadic system function ⎕AT) pertaining to the last time that the function was saved. The information is reinstated when a function is loaded into the workspace by SALT. Can only be used for traditional functions and operators. This is the default value.'
                  r,←⊂'  ∘ new       tracks unSALTed objects; when these objects are edited using the default editor, they are saved in the first directory named in the workdir session parameter.'
                  r,←''('If no values are specified (]',Cmd,' ""), SALT will only keep the minimum necessary information required to keep track of an object''s origin file.')
                  r,←'' 'Multiple values can be specified in a space or comma separated list. Additional values can be added to the current set by prefixing them with a comma. Active values can be removed by prefixing them with a tilde (~).'
                  r,←'' 'When returning a list of multiple values, space is used as a separator.' ''
              :EndIf
              r,←⊂''
              level←0
          :Else
              r←{(+/∨\' '≠⌽⍵)↑¨↓⍵}⍎'⎕SE.SALT.',{(5×'SALT.'≡5↑⍵)↓⍵}Cmd,' ''?'''
              r←r[3],(⊂'    ]SALT.',⊃r),3↓r
              (2⊃r)←'<value>'⎕R'&|-?'⊢2⊃r
              setParHelp←']SALT.',Cmd,' <parameter> -?  ⍝ for detailed description of a specific parameter'
              :If 0=level
                  r↑⍨←3         ⍝ SALT returns too much help
                  r,←setParHelp''/⍨'Settings' 'Set'∊⍨⊂Cmd
              :Else  ⍝ More help (?? case)
                  r←{⍵,⍨'    '/⍨'-'≡⊃⍵}¨r ⍝ Indent -modifier info
                  r,←'' 'Examples:'
                  :Select Cmd
                  :Case 'Save'
                      r,←⊂'    Save "myobj" in <myfile> (not using a version number):'
                      r,←⊂'        ]',Cmd,' myobj /my/folder/myfile'
                      r,←⊂'    Start using version numbers with "myobj":'
                      r,←⊂'        ]',Cmd,' myobj -version'
                      r,←⊂'    Save "myobj" at a specific version number (here 12):'
                      r,←⊂'        ]',Cmd,' myobj -ver=12'
                      r,←⊂'    Save XYZ to folder ensuring folder is created if non existant:'
                      r,←⊂'        ]',Cmd,' XYZ /new/folder/ -makedir'
                      r,←⊂'    Save namespace NN and convert it to script form in the workspace:'
                      r,←⊂'        ]',Cmd,' NN  relative\path\nn  -convert'
                  :Case 'RemoveVersions'
                      r,←⊂'    Remove version 12 of "myfile":'
                      r,←⊂'        ]',Cmd,' /my/folder/myfile -version=12'
                      r,←⊂'    Remove versions above 12 of "myfile":'
                      r,←⊂'        ]',Cmd,' /my/folder/myfile -version=>12'
                      r,←⊂'    Remove versions 12 to 21 of "myfile":'
                      r,←⊂'        ]',Cmd,' /my/folder/myfile -version=12-21'
                      r,←⊂'    Remove versions starting at 12 of "myfile" except the last which will be renamed version 12:'
                      r,←⊂'        ]',Cmd,' /my/folder/myfile -version=≥12 -collapse'
                      r,←⊂'    Remove all versions of "myfile" except the last one which will be renamed version 1:'
                      r,←⊂'        ]',Cmd,' /my/folder/myfile -all -collapse'
                      r,←⊂'    Remove versionning for "myfile" and keep the last one:'
                      r,←⊂'        ]',Cmd,' /my/folder/myfile -all'
                  :Case 'Snap'
                      r,←⊂'    Save every new item in the ws to path specified; changed items are saved to their own location:'
                      r,←⊂'        ]',Cmd,' \new\project'
                      r,←⊂'    Same thing but make sure the folder exists and do not prompt for confirmation of replacement:'
                      r,←⊂'        ]',Cmd,' \new\project -makedir -noprompt'
                      r,←⊂'    Save only namespaces and classes that start with "GUI" and convert namespaces to script form in the ws:'
                      r,←⊂'        ]',Cmd,' /utils/gui -class=9.1,9.4 -pattern=GUI* -convert'
                      r,←⊂'    Save every new item in a file whose prefix is "UTIL" (eg fn <cat> goes to <UTILcat>):'
                      r,←⊂'        ]',Cmd,' /basics -fileprefix=UTIL'
                      r,←⊂'    Save every item and create a load fn named <lx> to recreate the ws:'
                      r,←⊂'        ]',Cmd,' /my/wsx -loadfn=lx'
                  :Case 'Load'
                      r,←'' '    Load and define the item in a particular file:'
                      r,←⊂'        ]',Cmd,' \tmp\myitem'
                      r,←'' '    Load all version 3 of files starting with TM, searching recursively:'
                      r,←⊂'        ]',Cmd,' TM* -ver=3'
                      r,←'' '    Bring script S, don''t define it, don''t keep a SALT trace and assign its reference to X:'
                      r,←⊂'        ]X←',Cmd,' \tmp\S -noname -nolink'
                      r,←'' '    Disperse the items in /tmp/ns into #.N:'
                      r,←⊂'        ]',Cmd,' /tmp/ns -disperse -target=#.N'
                  :Case 'Compare'
                      r,←⊂'    Compare class in file C with object in workspace:'
                      r,←⊂'        ]SALT.',Cmd,' /my/files/C -version=ws'
                      r,←⊂'    Compare versions 2 and 7 of file X; use +- as line symbols:'
                      r,←⊂'        ]SALT.',Cmd,' \tmp\X -ver=2 7 -symb=+-'
                      r,←⊂'    Compare file A with file B, use always external pgm BC to compare:'
                      r,←⊂'        ]SALT.',Cmd,' /tmp/A  /myfiles/B -use=/bin/BC -permanent'
                  :Case 'Open'⍝ N.B. this command has been moved to its own file
                      r,←⊂'    Open disk explorer to show the contents of /tmp:'
                      r,←⊂'        ]',Cmd,'  /tmp'
                      r,←⊂'    Open file \my\file with Notepad (Windows):'
                      r,←⊂'        ]',Cmd,'  \my\file -with=notepad'
                      r,←⊂'    Open file X with program <vi>:'
                      r,←⊂'        ]',Cmd,' X -with=vi'
                  :Case 'List'
                      r,←⊂'    List all files in \tmp and all files below:'
                      r,←⊂'        ]',Cmd,' \tmp -recursive'
                      r,←⊂'    List folders of folder Y:'
                      r,←⊂'        ]',Cmd,' \myfiles\Y -folders'
                      r,←⊂'    List versions and type of files in relative folder Z:'
                      r,←⊂'        ]',Cmd,'  Z  -type  -ver'
                      r,←⊂'    List the full (starting from #)  path of files:'
                      r,←⊂'        ]',Cmd,'  -full=2'
                  :CaseList 'Settings' 'Set'
                      r←(¯2↓r),'' 'The following parameters impact user commands:',(DescSets''),¯2↑r
                      r,←⊂'    Find the current value of the "workdir" parameter:'
                      r,←⊂'        ]',Cmd,' workdir'
                      r,←⊂'    Overwrite the paths for User Commands:'
                      r,←⊂'        ]',Cmd,'  cmddir  \my\ucmd1',':;'[1+WIN],'\my\ucmd2'
                      r,←⊂'    Set permanently the comparison program (for cmd Compare) to BestC:'
                      r,←⊂'        ]',Cmd,' comp \programs\Bestc.exe  -permanent'
                      r,←⊂'    Remove the requirement to answer prompts when saving items:'
                      r,←⊂'        ]',Cmd,' edprompt 0'
                      r,←''setParHelp
                  :Case 'Boot'
                      r,←⊂'    Boot from a file containing instructions or a function:'
                      r,←⊂'        ]',Cmd,' filename'
                      r,←⊂'    As above, but do not run the ⎕LX:'
                      r,←⊂'        ]',Cmd,' filename  -xload'
                  :EndSelect
              :EndIf
          :EndIf
      :EndIf
      :If 0=level
          r,←⊂']SALT.',Cmd,' -??      ⍝ for more information and examples'
      :EndIf
      r,←''(']SALT.',Cmd,' is a thin cover for the ⎕SE.SALT.',Cmd,' function. See the SALT User Guide for full documentation.')
      :If Cmd≡'Snap'
          r,←'' 'WARNING:  The command is not atomic. If the process is not completed, then already-committed file writes will not be rolled back, and the list of successfully saved items will be returned.'
      :EndIf
      :If WIN
          r←'/'⎕R'\\'⊢r
      :Else
          r←'\\'⎕R'/'⊢r
      :EndIf
    ∇

    ∇ r←DescSets parameters;a;h
      a←0⍴⊂0⍴⊂''
      h←⊂'    cmddir  specifies the full path to the directory (or list of directories) from which to retrieve user commands. If multiple entries exist in the path, they are searched in the order listed (starting from the left) until a user command with the required name is found.'
      a,←⊂h
      h←⊂'    debug  specifies the level of debugging to use. Possible values are:'
      h,←⊂'        0:   no debugging and report errors in the environment'
      h,←⊂'        >0:  stop if an error is encountered'
      a,←⊂h
      h←⊂'    edprompt  specifies whether a user is prompted for confirmation to overwrite the file when modifying a script. Possible values are:'
      h,←⊂'        0:  the user is never prompted for confirmation'
      h,←⊂'        1:  the user is prompted for confirmation each time a script is modified'
      a,←⊂h
      h←⊂'    newcmd  specifies when new user commands become effective in the user interface. Possible values are:'
      h,←⊂'        auto    new commands are detected automatically (default on non-Pi)'
      h,←⊂'        manual  new commands do not become effective until the user command ]UReset is run (default on Raspberry Pi)'
      a,←⊂h
      r←⊃,/a/⍨'cmddir' 'debug' 'edprompt' 'newcmd'(∨/⍷)¨⍨⊆parameters
    ∇

    :Section TEST

    ∇ r←Test dummy;T;file;testvar;Eq;ext;old
      r←⍬ ⋄ T←{0::0 ⋄ ⎕SE.UCMD'SALT.',⍺,' ',⍵}
      Eq←{⊃≡/~∘'/\'¨⍺ ⍵~¨⊂'/\'}
      testvar←⎕D
      old←'Settings'T'varfmt xml'
      r,←'/tmp/testvar.dyalog'Eq'Save'T'testvar /tmp/ -nop'
      ⎕EX'testvar'
      r,←(testvar≡⎕D)∧'testvar'≡'Load'T'/tmp/testvar'
      r,←'testvar'≡2⊃2⌷'List'T'/tmp/testvar'
      r,←2=+/'testvar'⍷'Compare'T'testvar -ver=ws'
      r,←(≢'List'T'/tmp/testvar')='RemoveVersions'T'/tmp/testvar -all -nop'
      r,←'xml'≡'Settings'T'varfmt ',old
      r,←1⊣'Snap'T''⍝ not sure how it works
      r,←∨/'Cleanup done'⍷'Clean'T'' ⍝ delete what snap made
     
    ∇
    :EndSection

:Endnamespace ⍝ SaltInSpice  $Revision: 1801 $
