:namespace  Spice ⍝ V1.54
⍝ UCMD commands Script
⍝ 2015 09 25 DanB: added GetVersion
⍝ 2015 11 02 DanB: added more info to ]version and -extended
⍝ 2015 12 30 Adam: added 8.1 and 10 handling to ]version
⍝ 2016 02 18 Adam: documented ]version -extended, various Help fixes, moved ]version to TOOLS
⍝ 2016 10 22 DanB: added ws version and buildid in ]version
⍝ 2017 03 13 Adam: WS version fix for Windows
⍝ 2017 03 22 Adam: Add curr ver for unsaved wss, always one ver decimal, checksum now neutrally labeled and only with -extended
⍝ 2017 05 25 Adam: ]uload reports proper cased ucmd name
⍝ 2017 10 09 Adam: added ]uversion
⍝ 2017 10 31 Adam: full version number reporting for Windows and .NET
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -??
⍝ 2018 04 20 Adam: ]Uload shows filename, help text
⍝ 2018 05 07 Adam: ]ULoad and ]UVersion now fetch all matching commands and show group, help tweaks
⍝ 2018 05 27 Adam: Add help for ]uversion
⍝ 2018 05 29 Adam: ]uversion now reports framework number (too) and its help refers to ]version
⍝ 2018 05 30 Adam: help tweaks
⍝ 2019 02 01 Adam: help tweaks, blank commit if not found, ]uload ignore ]
⍝ 2020 05 22 Adam: make ]uversion see lowercase v and more date formats
⍝ 2020 07 06 MBaas: ]version includes htmlrenderer.dll, chrome_elf.dll; conga-version now properly detected; -extended=2 will display actual error-msgs that would otherwise be trapped
⍝ 2021 02 18 AndyS: typo
⍝ 2021 02 23 Adam: Allow ] in ucmd name for ]uload and ]uversion
⍝ 2023 10 02 Adam: Detect Win11 by build≥22000 (11 reports itself as 10)
⍝ 2023 10 04 Adam: Add Cider and Tatin to ]version
⍝ 2023 10 17 Adam: Differentiate between Cider/tatin unavailable and not loaded
⍝ 2023 12 05 Adam: Handle ⎕WSID being a dir
⍝ 2025 03 10 Adam: Fix ws version report

    Cmds←'ULoad' 'UReset' 'UDebug' 'Version'  'UMonitor' 'Refresh' 'UVersion'  ⍝ 'UHelp'?

    ⎕ML←1 ⋄ ⎕IO←1 ⋄ NL←⎕av[4 3] ⍝ cannot use ⎕ucs 13 10 on Classic Unix

    rtb←{⍺←' ' ⋄ (-⊥⍨⍵∊⍺)↓⍵} ⋄ DFLAGS←'d1c48KSWwh'

    ∇ r←List
      r←{⎕NS ⍬}¨Cmds
      r.Name←Cmds
      r.(Group Parse)←⊂'UCMD' ''
      r[1].(Desc Parse)←'Load a user command''s script into the current namespace' '1'
      r[2].Desc←'Refresh cache of all user command definitions' ⍝ this cmd is dealt with in SALTUtils
      r[3].(Desc Parse)←'Facilitate debugging of user commands'('1s -permanent -flags[=]')
      r[4].(Desc Parse Group)←'Report version numbers of APL, OS, SALT, UCMD, .NET and/or workspace' '1SL -extended[=]1 2' 'TOOLS'
      r[5].(Desc Parse)←'Gather user command execution data' '1s -var= -report[=]'
     ⍝ This command should be in the SALT class:
      r[6].(Desc Parse Group)←'Reload all SALTed items from their associated files' '-noprompt' 'SALT'
      r[7].(Desc Parse)←'Report version information of a user command' '1S'
    ∇

    ∇ r←Run(Cmd Args);z;la;t;fn;unav;state;ref;cl;setf;oo;un;rel;v;a;noa;fl;nof;obj;file;data;ver;type;os;ext;src;cmdname;filename;i;o
      r←0 0⍴''
      :Select Cmd
     
      :CaseList 'ULoad' 'UVersion'
          r←(Cmd≡'UVersion')/⊂'framework:  ',⍕⎕SE.SALTUtils.UVersion
          :If ×≢Args.Arguments
              v←1↑⍴t←⎕SE.Dyalog.SALT.List ⋄ un←{⍺,'.',⍵}/t[;2,⍨⍳'.'∊ref←(1⊃Args.Arguments)~' ]']
              :If ∨/z←un∊⊂cl←⎕SE.Dyalog.Utils.lcase ref←(1⊃Args.Arguments)~' ]'
              :OrIf 1=+/z←cl∘≡¨(⍴cl)↑¨un
                  :For i :In ⍸z
                      fn←t[i;]
                      filename←7⊃fn
                      cmdname←']'~⍨(⎕SE.Dyalog.Utils.ucase 1⊃fn),'.',(3⊃fn)
                      :If 'ULoad'≡Cmd
                          cl←⎕IO+9.1=⎕NC⊂o←⍕⎕SE.SALT.Load'"',filename,'" -target=',⍕##.THIS
                          r,←⊂(cl⊃'Class' 'Namespace'),' "',o,'" now contains source for "]',cmdname,'" from "',filename,'.dyalog"'
                      :Else
                          src←⎕SE.SALT.Load'"',filename,'" -source'
                          r,←⊂'command:    ]',cmdname
                          r,←⊂'source:     ',filename,⎕SE.SALT.SALTEXT
                          r,←⊂'version:    ',⊃'V *(\d+\.\d+)'⎕S'\1'⍠1⊃src
                          r,←⊂'revision:   ',⊃'\$.*?(\d+).*\$'⎕S'\1'⊃⌽src
                          r,←⊂'commit:     ',⊃'^ *((\W|\d\d)?\d\d(\W?\d\d?){2} .*)'⎕S'\1'(⊢↓⍨¯1+0⍳⍨∊∘'⍝ ')(⊢⊃⍨0⍳⍨'⍝'=1↓(⊃~∘' ')¨)src
                          r,←⊂''
                      :EndIf
                  :EndFor
                  r←↑r
              :Else
                  r←'No such command found'
              :EndIf
          :Else
              r←⊃r
          :EndIf
     
      :Case 'UDebug'
          r←'Is ',state←(0 1⍳⎕SE.SALTUtils.DEBUG)⊃'OFF' 'ON' 'ON+'
          →0/⍨(noa←' '∧.=a←⍕Args.Arguments)∧nof←0≡fl←Args.flags
          '-permanent does not apply to flags'⎕SIGNAL 11/⍨Args.permanent>nof
          r←'Unable to set (enter ON or OFF)'
          :If ∨/t←'off' 'on' ''∊⊂⎕SE.Dyalog.Utils.lcase⌽∘rtb⍣2,a~' '
              :If nof
                  r←'Was ',state
                  ⎕SE.SALTUtils.DEBUG←t[2]
                  :If Args.permanent ⋄ {}⎕SE.SALT.Settings'debug ',(⍕t[2]),' -permanent' ⋄ :EndIf
              :Else
         ⍝ Set the interpreter (DEBUG) flags (OFF means remove them, ON adds them, neither queries)
     
⍝ The flag are
⍝ h additional checks
⍝ w wscheck each desk calc line
⍝ W wscheck each line of apl
⍝ S shuffle 'n wscheck each getspace
⍝ M shuffle and wscheck each trip to message q
⍝ K log all input keys to apllog
⍝ 4 ?
⍝ c wscheck after each callback
⍝ 1 or d: debug
     
                  ((fl='d')/fl)←'1'  ⍝ d ≡ 1 flag
                  r←(1+¯1↑t)⊃'Was: ' 'Is: '
                  setf←{2 ⎕NQ'.' 'SetDFlags'⍵}
                  r←r,t[2]{n←2⍴⍨⍴tags←⌽1↓DFLAGS
                      old←bits←n⊤setf 0  ⍝ find current state
                      ((tags∊⍵)/bits)←⍺
                      x←setf 2⊥bits      ⍝ reset to new value
                      1⌽'""',old/tags}fl,(fl≡1)/DFLAGS
              :EndIf
          :EndIf
     
      :Case 'Version'
          r←Version Args
     
      :Case 'UReset'
          ⍝ Execution of UReset is handled in the framework; it appears here for the HELP only
          ⍝ and in case a shorter form of 'ureset' has been entered:
          ResetUCMDcache 1
          t←⍕1↑⍴⎕SE.Dyalog.SALT.List ⋄ r←t,' commands reloaded'
     
      :Case 'UMonitor'
          state←(0 1⍳⎕SE.SALTUtils.MONITOR)⊃'OFF' 'ON' 'ON+'
          :If 0≢file←Args.report
          ⍝ Produce a report of code coverage
              :If ⎕SE.SALTUtils.MONITOR=0
              :OrIf 0=⎕NC v←⎕SE.SALTUtils.MONITORNAME
              :OrIf 0∊⍴⍎v
                  'No data accumulated'⎕SIGNAL 6
              :EndIf
              0 ⎕THIS ⎕SE.SALT.Load'tools/code/codecov' ⍝ bring in the code
              data←,0 1↓¯2 CodeCov.CCinit ⎕IO⊃¨⍎v
              r←data CodeCov.CC 2⊃¨⍎v
              :If file≢1
                  r ⎕SE.SALTUtils.PutUTF8File file
                  r←(⍕r),' bytes written to ',file
              :EndIf
          :ElseIf 0≡v←Args.var ⋄ r←'Is ',state
          :Else ⋄ rel←~'#⎕'∊⍨1↑v
              'MONITOR cannot be used from an unnamed NS'⎕SIGNAL 11/⍨rel∧'['∊t←⍕##.THIS
              v←(rel/t,'.'),v
              'invalid variable name'⎕SIGNAL 11↓⍨(⎕NC v)∊0 2
              ⎕SE.SALTUtils.MONITORNAME←v
              r←'''',v,''' will be used for monitoring'
              ⎕SE.SALTUtils.MONITOR←1
          :EndIf
          →0↓⍨⍴Args.Arguments
          :If ∨/oo←'off' 'on'∊⎕SE.Dyalog.Utils.lcase¨Args.Arguments
              r←'Was ',state
              :If ⎕SE.SALTUtils.MONITOR←oo[2] ⍝ turn ON? clear data
              :AndIf 2=⎕NC t←⎕SE.SALTUtils.MONITORNAME
                  ⍎t,'←⍬'
              :EndIf
          :Else ⋄ r←'Unable to set (enter ON or OFF)'
          :EndIf
     
      :Case 'Refresh'
          r←(~Args.noprompt)refreshWS #
     
      :EndSelect
    ∇

    ∇ r←Version Args;ext;fn;ok;os;t;type;unav;v;ver;z;gv;dyalog;⎕USING;lib;hr;lv
    ⍝ Return version information about a number of items
      Args.extended←⍎⍕Args.extended ⍝ make sure it's numeric (0..1..2)
     
      :If 0<⍴fn←{(+/∧\' '=⍵)↓⍵}1⊃1↑Args.Arguments ⍝ are we trying to find the version of a ws?
          r←wsVersion fn
      :Else ⍝ show various versions
          unav←'(unavailable)'
        ⍝ Dyalog's
          type←(32×1+∨/'-64'⍷v←1⊃ver←⎕SE.SALTUtils.APLV){' ',(⍕⍺),'-bit ',⍵⊃'Unicode' 'Classic'}1+82=⎕DR''
          dyalog←⊂(({(3>+\'.'=⍵)/⍵}2⊃ver),type,', BuildID ',{0::'?' ⋄ 2 ⎕NQ'.'⍵}'getbuildid')
          lib←⎕SE.SALTUtils.(DYALOG,FS)
          :If Args.extended≠0
              :Select ⎕SE.SALTUtils.OS
              :Case 'Win'
                  dyalog,←⊂GetFileVersion lib,'htmlrenderer.dll'
                  dyalog,←⊂GetFileVersion lib,'chrome_elf.dll'
              :Case 'Lin'
                  lib,←'lib/'
                  dyalog,←⊂GetFileVersion lib,'htmlrenderer.so'
              :Case 'Mac'
                  lib,←'lib/'
                  dyalog,←⊂GetFileVersion lib,'htmlrenderer.dylib'
              :EndSelect
              :Trap 0  ⍝ at least show CEF-Version
                  hr←#.⎕NEW'HTMLRenderer'(('Visible' 0)('AsChild' 0))
                  dyalog,←⊂'CEFVersion: ',1⊃hr ⎕WG'CEFVersion'
              :Else
                  :If Args.extended=2
                      dyalog,←⊂'CEFVersion:',⎕JSON ⎕DMX
                  :EndIf
              :EndTrap
              ⎕EX'hr' ⍝ explicitly kill it (makes a difference on v16)
          :EndIf
          r←⊂'Dyalog'(↑dyalog)
        ⍝ The OS
          :If ⎕SE.SALTUtils.WIN    ⍝ Windows?
              os←GetVersion
          :Else          ⍝ Non-Win
              os←{0::'' ⋄ ∊⎕SH ⍵}'uname -srv','mM'[1+'AIX'≡3↑v]
          :EndIf
          r,←⊂'OS'os
         ⍝ Other info such as computer name could be added
          :If Args.extended>0
              r,←⊂'CPUs'(⍕1111⌶⍬)
          :EndIf
        ⍝ Link
          lv←unav
          :If 9=⎕SE.⎕NC'Link'
          :AndIf 0<⎕SE.Link.⎕NC'Version'
              lv←⎕SE.Link.Version
          :Else
              :Trap 911 ⍝ 17.1
                  :If '*'≠⊃⎕SE.UCMD'Link.Version'  ⍝ is it available
                      ⎕SE.UCMD'lv←Link.Version'
                  :EndIf
              :EndTrap
          :EndIf
          r,←⊂'Link'lv
        ⍝ SALT & UCMDs (no need to take care of "unavailable case" - otherwise this command wouldn't even be running!)
          r,←⊂'SALT'(⍕⎕SE.SALT.Version)
          r,←⊂'UCMD'(⍕⎕SE.SALTUtils.UVersion)
        ⍝ .Net: show the Version in use, the bridge and dyalognet
          v←unav
          :Trap 0
              :If (0<Args.extended)⊣t←⍬
                  ⎕USING←'System'
                  t←((7↑¨t)∊'bridge1' 'dyalogn')/t←⍕¨AppDomain.CurrentDomain.GetAssemblies
                  t←{(~∨\', Culture'⍷⍵)/⍵}¨t
                  :If 0=≢t   ⍝ probably .NET CORE
                      t←('Dyalog.Net.Bridge'∘(⊃⍷)¨t)/t←⍕¨AppDomain.CurrentDomain.GetAssemblies
                  :EndIf
              :EndIf
              v←↑GetDOTNETVersion[4],t
          :Else
              :If Args.extended=2
                  v,←⊂⎕JSON ⎕DMX
              :EndIf
          :EndTrap
          r,←⊂'.NET'v
          r,←⊂'WS'(wsVersion'')
     
          ⍝ Tatin
          :If 10<≢⎕SE.UCMD'Tatin -?'
              lv←'(not loaded)'
          :Else
              lv←unav
          :EndIf
          :If 9=⎕SE.⎕NC'Tatin'
          :AndIf 0<⎕SE.Tatin.⎕NC'Version'
              lv←{⍵↑⍨¯1+⍵⍳'+'}2⊃⎕SE.Tatin.Version
          :EndIf
          r,←⊂'Tatin'lv
     
          ⍝ Cider
          :If 10<≢⎕SE.UCMD'Cider -?'
              lv←'(not loaded)'
          :Else
              lv←unav
          :EndIf
          :If 9=⎕SE.⎕NC'Cider'
          :AndIf 0<|⎕SE.Cider.⎕NC⊂'Version'
              lv←{⍵↑⍨¯1+⍵⍳'+'}⎕SE.Cider.Version
          :EndIf
          r,←⊂'Cider'lv
     
          :If Args.extended>0
              ext←'Conga'unav
              :Trap 0
                  'DRC'⎕CY'conga'
                  v←2 DRC.Init lib
                  :If ok←0=1↑v
                      t←⊂6↓2⊃v   ⍝ split on various sections, e.g. GnuTLS
                      v←v⊂⍨↑∨/'Dynam' 'Copyright' ' built' 'GnuTLS' 'Built'⍷¨⊂v←2 2⊃DRC.Describe'.'
                      v←,/1 0 1/2 3⍴v ⍝ remove copyright sections
                      t,←v
                      t←(⊂'Version: ',¯1↓∊(⍕¨DRC.Version),¨'.'),t
                  :ElseIf Args.extended=2
                      ext←⊂'Conga: '(⍕v)
                  :EndIf
                  :If ok ⋄ ext[2]←⊂↑t ⋄ :EndIf
              :Else
                  :If Args.extended=2
                      ext←'Conga'(⎕JSON ⎕DMX)
                  :EndIf
              :EndTrap
              r,←⊂ext
     
              ext←'SQAPL'unav
              :Trap 0
                  'SQA'⎕CY'sqapl'
                  :If ok←0=1↑v←SQA.Init'' ⋄ t←⊂(~∨\'Using'⍷t)/t←6↓2⊃v
                      v←v⊂⍨↑∨/'Version' 'Copyright' ' built' 'IniFile'⍷¨⊂v←2⊃SQA.Describe'.'
                      v←,/1 0 1/2 3⍴v,'' '' ⍝ remove copyright sections
                      t←t,¯2 0↓¨v
                  :ElseIf Args.extended=2
                      ext←⊂'SQAPL: ',⍕v
                  :EndIf
                  :If ok ⋄ ext[2]←⊂⎕FMT↑t ⋄ :EndIf
              :Else
                  :If Args.extended=2
                      ext←('SQAPL')(⎕JSON ⎕DMX)
                  :EndIf
              :EndTrap
              r,←⊂ext
          :EndIf
      :EndIf
      r←⍕↑r
    ∇

    ∇ r←wsVersion fn;z;file;wsid;clear
      :If 0=≢fn
      :OrIf '⎕wsid'≡⎕C fn
          clear←'CLEAR WS'≡⎕WSID
          :If clear<⎕NEXISTS wsid←⎕WSID
          :OrIf clear<⎕NEXISTS wsid←⎕WSID,'.dws'
              r←wsVersion wsid
          :Else
              r←4↑2⊃⎕SE.SALTUtils.APLV
          :EndIf
      :ElseIf ~⎕NEXISTS fn
          ('workspace ',fn,' is not found')⎕SIGNAL 22
      :ElseIf 1=1 ⎕NINFO fn
          r←4↑2⊃⎕SE.SALTUtils.APLV
      :Else
          file←fn
          z←⎕SE.SALTUtils.WIN>'.'∊file↑⍨-⌊/'/\'⍳⍨⌽file  ⍝ under Win add extension if missing
          (fn,' is not a workspace')⎕SIGNAL 22↑⍨6≥2 ⎕NINFO file
          r←1↓1⍕0.1⊥⌽4↓83 6 ⎕MAP file←file,z/'.DWS'
          :If Args.extended>0
              :Trap 22
                  r←r,' (LRC ',')',⍨2 ⎕NQ'.' 'getbuildid'file
              :EndTrap
          :EndIf
      :EndIf
    ∇

    isYes←{~⍺:1 ⋄ ⎕←⍵ ⋄ n←⍴⍞←'? [Yes/No/Stop]: ' ⋄ ∨/'sS'∊r←1↑n↓⍞:⎕signal 901 ⋄ ∨/'yY'∊r}

    remVer←{1≥+/b←(∨\r∊'/\')<'.'=r←⌽⍵:⍵ ⋄ (,1)≢1⊃⎕vfi r/⍨~c←1≠+\b:⍵ ⋄ ⌽c/r}

    ∇ {n}←confirm refreshWS tgt;lst;sons;file;srcws;t;b;obj;cload;call1;⎕TRAP;⎕PW
    ⍝ This fn is used to update all objects starting at tgt
      ⎕PW←999 ⋄ n←0 ⍝ number of changes made
      :If call1←0=⎕NC'LIST' ⋄ ⎕SHADOW'LIST' ⋄ LIST←⍬ ⋄ ⎕TRAP←901 'C' '→End' ⋄ :EndIf ⍝ avoid recursion, keep track of nss done
      LIST,←tgt
      cload←{(o f p)←⍵ ⋄ 922 22::0⊣⎕←'*** File ',f,' NOT FOUND for object ',o ⋄ ⍺≢⎕SE.SALT.Load f,p}
     
      :If 0≢srcws←{0::0 ⋄ ⎕SRC ⍵}tgt ⍝ chk scripted nss
          :If 9=tgt.⎕NC'SALT_Data'
              :If srcws cload tgt(file←tgt.SALT_Data.SourceFile)' -source'
              :AndIf confirm isYes⍕'** Confirm overwrite ',tgt,' with contents of file ',remVer file
                  n+←⍴,⎕←0 tgt.## ⎕SE.SALT.Load file ⍝ we need to redo the load to tag the object
              :EndIf
          :EndIf
      :Else ⍝ must be a regular ns
     
          :If 2=#.⎕NC'SALT_Var_Data.VD'
          :AndIf 1∊b←#.SALT_Var_Data.VD[;⎕IO]{⍵∘≡¨{⍵↓⍨-1+⊥⍨'.'≠⍵}¨⍺}{df←⍵.⎕DF ⎕NULL ⋄ (⍵.⎕DF df)⊢⍕⍵}tgt
              :For obj file :In ↓b⌿#.SALT_Var_Data.VD[;⍳2]
                  :If (⍎obj)cload obj file' -noname -nolink'
                  :AndIf confirm isYes⍕'** Confirm overwrite ',obj,' with contents of file ',remVer file
                      n+←⍴,⎕←0 tgt ⎕SE.SALT.Load file ⍝ we need to redo the load to tag the object
                  :EndIf
              :EndFor
          :EndIf
     
          :For obj :In lst←tgt.⎕NL-3 4
              :If 2≡≡srcws←tgt.⎕NR obj
              :AndIf ~0∊⍴t←⎕SE.SALTUtils.fnData srcws obj
              :AndIf ({(3≠⍴⍵)∨' }'≢1⊃⌽⍵:⍵ ⋄ ⍵[1],¨1↓¨⍵[3]}⎕SE.SALTUtils.remTag srcws)cload obj(file←t.SourceFile)' -source'
              :AndIf confirm isYes⍕'** Confirm overwrite ',obj,' with contents of file ',remVer file
                  n+←×⍴,⎕←0 tgt ⎕SE.SALT.Load file
              :EndIf
          :EndFor
     
          :If 0<⍴lst←tgt.⎕NL-9
          :AndIf 0<⍴lst←LIST~⍨tgt⍎¨lst
            ⍝ Recurse thru non-scripted children
              :If 0<⍴sons←{⍵/⍨~1∊¨(⍕¨⍵)∊¨⊂'[('}lst
                  n+←+/∊confirm refreshWS¨sons
              :EndIf
          :EndIf ⍝ all nss
      :EndIf
     End:
      :If call1 ⋄ n←(⍕n),' objects refreshed' ⋄ :EndIf
    ∇

    ∇ r←level Help Cmd;EndSelect
      r←List.Desc[Cmds⍳⊂Cmd]
      :Select Cmd
      :Case 'ULoad'
          r,←⊂'    ]',Cmd,' <ucmdname>'
          r,←⊂''
          r,←⊂'NOTES:'
          r,←⊂'    ∘  the current namespace must be # or a named namespace'
          r,←⊂'    ∘  if <ucmdname> matches multiple user commands, then all of them will be loaded'
          r,←'' 'Example:' '    To load the namespace of the CD user command:'
          r,←⊂'        ]',Cmd,' cd'
          r,←⊂'    Namespace "#.Summary" now contains source for "]FILE.CD" from "',⎕SE.SALTUtils.(DYALOG,'/'⎕R'\\'⍣WIN⊢'/SALT/spice/Summary.dyalog"')
      :Case 'UReset'
          r,←⊂'    ]',Cmd
          r,←⊂''
          r,←⊂'NOTE:  ]',Cmd,' is necessary to pick up changes made to files containing user commands, unless the Session is restarted or the "newcmd" parameter has been set to "auto" (default) in which case the cache is automatically rebuilt.'
     
      :Case 'UDebug'
          r,←⊂'    ]',Cmd,' [on|off] [-permanent] [-flags=<dyalog>]'
          r,←⊂''
          :If level=0
              r,←⊂']',Cmd,' -?? ⍝ for more information'
          :Else
              r,←⊂']',Cmd,'      ⍝ report the current state'
              r,←⊂']',Cmd,' off  ⍝ default state'
              r,←⊂']',Cmd,' on   ⍝ cause the following behaviour:'
              r,←⊂'    ∘  when a user command is called, a message is displayed to indicate that debugging is on'
              r,←⊂'    ∘  " -" at the end of a user command call suspends execution on the first line of the Run or Help function in the command''s script'
              r,←⊂'    ∘  any error during user command execution opens the tracer rather than cutting back and reporting the error'
              r,←⊂'    ∘  if a user command has been loaded into the current namespace with ]ULoad then that version is used rather than the version on file'
              r,←⊂'    ∘  user command help text will include source file, command version, and syntax parser information'
              r,←⊂''
              r,←⊂'-permanent       make the on/off setting permanent across sessions'
              r,←⊂'-flags=<dyalog>  should only be used as directed by Dyalog Ltd.'
          :EndIf
      :Case 'Version'
          r,←⊂'    ]',Cmd,' [<file>] [-extended]'
          r,←⊂''
          r,←⊂'<file>     report the minimum Dyalog version necessary to )LOAD <file> (will give meaningless result if <file> is not a workspace)'
          r,←⊂'-extended  give additional version information for .NET, Conga, and SQAPL or, for files, an 8-digit hex hash'
     
      :Case 'UMonitor'
          r,←⊂'    ]',Cmd,' [on|off] [-var=<name>] [-report[=<file>]]'
          r,←⊂''
          :If level=0
              r,←⊂']',Cmd,' -?? ⍝ for more information'
          :Else
              r,←⊂']',Cmd,'      ⍝ report the current state'
              r,←⊂']',Cmd,' off  ⍝ default'
              r,←⊂']',Cmd,' on   ⍝ store ⎕CR and ⎕MONTIOR data (this discards any previously stored data)'
              r,←⊂''
              r,←⊂'    -var=<name>     (implies "on") name of variable for data storage (default: #.UCMDMonitor)'
              r,←⊂'    -report         generate report based on stored data'
              r,←⊂'    -report=<file>  saves generated report to file instead'
              r,←'' 'Example:'
              r,←⊂'        ]',Cmd,' on'
              r,←⊂'        ]UVersion                ⍝ call the CD user command'
              r,←⊂'        ]',Cmd,' -report  ⍝ generate report (can be quite lengthy)'
              r,←⊂'     x line never executed'
              r,←⊂'     → branch always taken'
              r,←⊂'     ↓ branch never  taken'
              r,←⊂''
              r,←⊂'     ∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇∇'
              r,←⊂''
              r,←⊂'          1 [0]    r←Run(Cmd Args);z;la;t;fn;unav;state;ref;cl;setf;oo;un;rel;v;a;noa;fl;nof;obj;file;data;ver;type;os;ext;src;cmdname;filename;i;o'
              r,←⊂'          1 [1]    r←0 0⍴'''
              r,←⊂'          1 [2]    :select Cmd'
              r,←⊂'          0 [3]'
              r,←⊂'      ↓   1 [4]    :caselist ''ULoad'' ''UVersion'''
              r,←⊂'          1 [5]        r←(Cmd≡''UVersion'')/⊂''framework:  '',⍕⎕SE.SALTUtils.UVersion'
              r,←⊂'      →   1 [6]        :if ×≢Args.Arguments'
              r,←⊂'     x    0 [7]            v←1↑⍴t←⎕SE.Dyalog.SALT.List ⋄ un←{⍺,''.'',⍵}/t[;2,⍨⍳''.''∊ref←(1⊃Args.Arguments)~'' '']'
              r,←⊂'    ...'
          :EndIf
      :Case 'Refresh'
          r,←⊂'    ]',Cmd,' [-noprompt]'
          r,←⊂''
          r,←⊂'    -noprompt  skip confirmation prompts'
      :Case 'UVersion'
          r,←⊂'    ]',Cmd,' [<ucmdname>]'
          r,←⊂''
          r,←⊂'<ucmdname>  report framework version, full name, source file, internal version number, revision number, and last commit of a given user command. If omitted, report framework version.'
          r,←'' 'Example:'
          r,←⊂'        ]',Cmd,' CD'
          r,←'    '∘,¨↓⎕SE.UCMD'UVersion CD'
          r,←'To report version numbers of APL, OS, SALT, UCMD, .NET and/or workspace, instead use:' '    ]Version'
      :EndSelect
    ∇

    ∇ R←GetVersion;gv;V;⎕IO;⎕ML;minor;nul;build;IsWow64Process;wow64;ok;bits
      ⎕IO←⎕ML←1
      'gv'⎕NA'U4 kernel32∣GetVersion'
     ⍝ OS is specified by high-order (first) bit and low-order byte
      :Select (V←(32⍴2)⊤gv)[1 30 31 32]
      :Case 0 0 1 1 ⋄ R←'Windows NT 3.51'
      :Case 0 1 0 0 ⋄ R←'Windows NT 4.0'
      :Case 0 1 0 1 ⋄ R←'Windows 2000 or Windows XP'
      :Case 1 1 0 0 ⋄ R←'Windows 95, Windows 98, or Windows Me'
      :Case 0 1 1 0
    ⍝ Major version of 6. Look at minor version.
          minor←2⊥V[16+⍳8]
          R←'Vista or Windows Server 2008' '7 or Windows Server 2008 R2' '8 or Windows Server 2012'
    ⍝ Note that 8, 8.1, and 10 (and probably all future versions) report 8.0⌈whatever the application manifest calls for
          R,←'8.1 or Windows Server 2012' '10 beta' ⍝ pre-releases of 10 reported 6.4
          R←'Windows ',(R⊃⍨0 1⍳minor),(' or newer'/⍨2≤minor)
      :Case 0 0 0 1 ⋄ R←'Windows 10 alpha' ⍝ earliest builds reported 9.0
      :Case 0 0 1 0 ⍝ only if application manifest says 10+
          :If 22000>2⊥16↑V
              R←'Windows 10 or Windows Server 2016'
          :Else
              R←'Windows 11'
          :EndIf
      :EndSelect
      :Trap 0
          'gv'⎕NA'u ntdll.dll|RtlGetVersion ={ U U U U U T[128]}'
          V←2 6⊃V←gv⊂276 0 0 0 0(128⍴' ')
         ⍝ Some versions return Wide chars
          :If 1<+/V=nul←⎕UCS 0
              V←((⍴V)⍴1 0)/V
          :EndIf
          R,←', '{⍵,~(~0∊⍴⍵)/⍺}(¯1+V⍳nul)↑V
      :EndTrap
      :Trap 6 ⍝ Try asking for exact version
          ⎕USING←'System'
          build←{(3>+\'.'=⍵)/⍵}⍕Environment.OSVersion
          build~←' ',⎕A,⎕C ⎕A
          R,←' (',build,')'
      :EndTrap
      bits←32
      :Trap 0 ⍝ Get bit-width
          ⎕NA'U kernel32|IsWow64Process I >U'
          bits(⊣+×)←⎕SE.SALTUtils.AMD64∨>/IsWow64Process ¯1 0 ⍝ ¯1=this. Result: wow64,ok
      :EndTrap
      R,←' ','-bit ',⍨⍕bits
    ∇

    ∇ R←GetFileVersion file;⎕USING;gv
      :If 1=1⊃GetDOTNETVersion
          ⎕USING←'System' 'System.Diagnostics,System.Diagnostics.FileVersionInfo.dll'        ⍝ .net Framework
      :Else
          ⎕USING←'System' 'System.Diagnostics,System.Diagnostics.FileVersionInfo'            ⍝ .NET Core
      :EndIf
      :If ⎕SE.SALTUtils.WIN∧0<1⊃GetDOTNETVersion
          gv←{⍵,': ',(FileVersionInfo.GetVersionInfo⊂⍵).FileVersion}  ⍝ .NET GetVersion is only useful on Windows
      :Else
          gv←{⍵,': ',{'-- ::'@(2+3×⍳5)∊⍕¨(⊃,100+1∘↓)6↑⍵}⊃3 ⎕NINFO ⍵}   ⍝ use ⎕NINFO if not available or other platform
      :EndIf
      :Trap 0
          :If ⎕NEXISTS file
              R←gv file
          :Else
              R←file,': does not exist'
          :EndIf
      :Else
          :If Args.extended≠2       ⍝  global param...
              R←file,': (unavailable)'
          :Else
              R←(⊂file),⎕JSON ⎕DMX
          :EndIf
      :EndTrap
     
    ∇

    ∇ R←GetDOTNETVersion;vers;⎕IO;⎕USING
⍝ R[1] = 0/1/2: 0=nothing, 1=.net Framework, 2=NET CORE
⍝ R[2] = Version (text-vector)
⍝ R[3] = Version (identifiable x.y within [2] in numerical form)
⍝ R[4] = Textual description of the framework
      ⎕IO←1
      R←0 '' 0 ''
      :Trap 0
          ⎕USING←'System' ''
          vers←System.Environment.Version
          R[2]←⊂⍕vers
          R[3]←vers.(Major+0.1×Minor)
          :If 4=⌊R[3]   ⍝ a 4 indicates .net Framework!
              R[1]←1
              :If (⍕vers)≡'4.0.30319.42000'   ⍝ .NET 4.6 and higher!
                  R[4]←⊂Runtime.InteropServices.RuntimeInformation.FrameworkDescription
              :ElseIf (10↑⍕vers)≡'4.0.30319.' ⍝ .NET 4, 4.5, 4.5.1, 4.5.2
                  R[4]←⊂'.NET Framework ',2⊃R  ⍝ JD: good enough?  Otherwise I may need to dig into the registry according to https://docs.microsoft.com/de-de/dotnet/framework/migration-guide/how-to-determine-which-versions-are-installed?view=netframework-4.8
              :EndIf
          :ElseIf 3.1=R[3]  ⍝ .NET CORE
          :OrIf 4<R[3]
              R[1]←2
              ⎕USING←'System,System.Runtime.InteropServices.RuntimeInformation'
              R[4]←⊂Runtime.InteropServices.RuntimeInformation.FrameworkDescription
          :EndIf
      :Else
      ⍝ bad luck, go with the defaults
      :EndTrap
    ∇
:Endnamespace ⍝ Spice  $Revision: 1909 $
