:namespace Summary ⍝ V1.54
⍝ Misc utils
⍝ 2015 05 28 Adam: toHex & FromHex & Factors & PivotTable moved Tools → Calc
⍝ 2015 11 12 DanB: changed summary header
⍝ 2016 02 12 DanB: modified CD to work under *nix
⍝ 2016 07 15 DanB: from/tohex to accept executable strings
⍝ 2017 02 27 Adam: tweaked helps
⍝ 2017 03 08 Adam: fix CD for non-Win, Replace ⎕U2338 with ⎕=, help fixes
⍝ 2017 03 22 Adam: added ]xref -raw
⍝ 2017 05 27 Adam: ]tohex and ]fromhex now handle any integer
⍝ 2017 05 25 Adam: Proper cased ToHex FromHex ToQuadTS
⍝ 2017 05 26 Adam: results for help text examples
⍝ 2017 07 11 Adam: Swap ]tohex and ]fromhex help texts
⍝ 2017 07 12 Adam: Extended ]??disp[lay]
⍝ 2017 07 13 Adam: Updated help
⍝ 2017 07 18 Becca: Changed ]ToQuadTS Help description
⍝ 2017 12 12 Adam: Fix ]??Calls
⍝ 2018 03 05 Adam: Fix ]?pivottable
⍝ 2018 04 12 Adam: [14781] Help text tweaks, renamed ]Calls -isolate to ]Calls -ns
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -??
⍝ 2018 04 30 Adam: Help and code tweaks, fix ]xref -file
⍝ 2018 05 01 Adam: help tweaks
⍝ 2018 05 30 Adam: help tweaks
⍝ 2018 06 07 MKrom: tweak help for to/fromhex
⍝ 2018 08 02 Adam: remove stray ''
⍝ 2018 11 13 Adam: help tweaks
⍝ 2019 02 04 Adam: help tweaks
⍝ 2019 04 15 Adam: ]cd merge args
⍝ 2020 09 14 Adam: Allow system nss
⍝ 2020 10 12 Adam: Move CD to Dyalog.Utils
⍝ 2021 06 28 Adam: [19186] Use disp/display/factors from dfns.dws
⍝ 2021 07 15 Adam: Handle CRLF, restore ]disp defautls and fix its help
⍝ 2022 01 12 Adam: Workaround 19379
⍝ 2022 02 22 Adam: [19698] avoid auto-localisation in the above workaround, and cleaner workaround code
⍝ 2022 03 31 Adam: [19780] Detect how far up the stack we need to go, rather than computing it based on ⎕SI, display→disp
⍝ 2022 09 14 Adam: Restore decorators on ]disp
⍝ 2023 12 04 Adam: Remove code to work around [19379]
⍝ 2024 07 23 Adam: [17148] Fix ]cd -??
⍝ 2025 01 24 Adam: Avoid boxing ]disp/]display (and add disabled ]sink)
⍝ 2025 02 04 Adam: Avoid injecting no-box marker if no boxing or rowing is active
⍝ 2025 03 25 Adam: Rework ]disp/]display/]sink to not return
⍝ 2025 04 01 Adam: [16741] Make ]disp/]display respect ⎕PP

    ⎕ml←3 ⋄ ⎕io←1
    OS←⎕SE.SALTUtils.OS
    AllCmds←'Summary' 'Calls' 'Xref'  'CD'  'Display' 'Disp' 'ToHex' 'FromHex' 'Factors' 'ToQuadTS' 'PivotTable' 'Sink'

    ∇ r←List;i
      r←⎕NS¨(⍴AllCmds)⍴⊂''
      r.Group←'NS' 'FN' 'NS' 'File' 'Output' 'Output' 'Calc' 'Calc' 'Calc' 'File' 'Calc' 'Output'
      r.Parse←'1L -file' '1-2L -details -treeview -file -full -ns[=]' '1L -file -raw' '1SL' '' '' '' '1L' '1' '' '1L -f:≢' ''
      r.Name←AllCmds
      i←0 ⍝ i←i+1 allows inserting new cmds w/o renumbering
      r[i←i+1].Desc←'Summarise (scope, size, syntax) the functions in a namespace/class/scriptfile'
      r[i←i+1].Desc←'Produce the calling tree of a function in a class/namespace/scriptfile'
      r[i←i+1].Desc←'Describe the inter-object cross-references in a class/namespace/scriptfile'
      r[i←i+1].Desc←'Report (and, optionally, change) the current directory'
      r[i←i+1].Desc←'Display specified array with borders indicating array and sub-array shape and type'
      r[i←i+1].Desc←'Display specified array with borders indicating sub-array shape and type'
      r[i←i+1].Desc←'Convert integer(s) to a vector of text vectors containing the hexadecimal representation of each number'
      r[i←i+1].Desc←'Convert a list of hexadecimal representations of integers to a numeric vector'
      r[i←i+1].Desc←'Determine the prime factors of the argument'
      r[i←i+1].Desc←'Convert a component file timestamp (single float number) to ⎕TS format (vector of 7 numbers)'
      r[i←i+1].Desc←'Create a pivot table from an appropriate matrix'
      r[i←i+1].Desc←'Suppress all (standard) output from expression'
      r↓⍨←¯1 ⍝ disable ]sink
    ∇

    ∇ r←Run(Cmd Args);ct;ns;sw;sp;file;arg;tmpNS;fn;nsname;Cn;b;ok;⎕PP;up;val;I86;ExecUp;Sink;qseosp;old
    ⍝ Execute cmd for all the defined commands
     
      :If 4>Cn←AllCmds⍳⊂Cmd
          fn←file←1⊃ct←Args.Arguments
          :If ok←Cn=2 ⍝ Cmd≡'FnCalls'
              :If ok←1=⍴ct
                  :If ok←∧/b←'.'≠file
                      file←'⎕this'
                  :Else
                      file↓⍨←-1+⍴fn←(-⊥⍨b)↑file ⍝ accept ns.fn
                  :EndIf
              :Else ⋄ file←2⊃ct
              :EndIf
          :EndIf
          :If ~Args.file         ⍝ get the space
              'Only for [name]spaces'⎕SIGNAL 11/⍨ok<(9=##.THIS.⎕NC file)⍱('⎕SE'(,'#')'⎕THIS'∊⍨⊂file)
              tmpNS←##.THIS⍎file
          :Else
              r ⎕SIGNAL 11↓⍨0∊⍴⍴r←tmpNS←⎕SE.SALT.Load'"',file,'" -noname'
          :EndIf
          ct←⎕SE.SALT.New'tools/code/callingTree'tmpNS
      :EndIf
     
      :Select Cn
      :Case 1⊣'Summary'
          r←format ct.FnRefs
      :Case 2⊣'FnCalls'
          :If 0≢nsname←Args.ns
              'Namespace name must be free'⎕SIGNAL 11↓⍨(0=##.THIS.⎕NC⍕nsname)∨nsname≡1
              '-ns only works on namespaces or #'⎕SIGNAL 11↓⍨(9.1=⎕NC⊂'tmpNS')∨#≡tmpNS
              r←ct.Calls fn,' -raw'               ⍝ get raw info to gather globals and fns
              sp←⊃,/(∊∘'G'¨1⊃¨r[;3])/¨2⊃¨r[;3]    ⍝ this should work even with a 0 line niladic fn
              sp←∪(∧\¨'.'≠sp)/¨sp                 ⍝ only namespace kept in ns.x
              sp←(0<tmpNS.⎕NC sp)⌿sp              ⍝ ignore ⎕names
              sp←⊃r[;1],sp
              r←tmpNS.⎕NS sp                      ⍝ create a ns from the objects
              :If nsname≢1
                  r←0 0⍴''⊣nsname ##.THIS.⎕NS r ⍝ create a separate ns with all the objects
              :Else
                  r←##.THIS.⎕NS r
              :EndIf
          :Else
              r←ct.Calls(⊂fn),Args.(treeview details 999 full)
          :EndIf
      :Case 3⊣'Xref'
          r←ct.XrefX~Args.raw
⍝          :If 0≢file←Args.file
⍝              r ⎕SE.SALTUtils.PutUTF8File file
⍝              r←'Result in file ',file
⍝          :EndIf
      :Case 4⊣'cd'
          r←1 ⎕SE.Dyalog.Utils.CD{(+/∧\' '=⍵)↓⍵}1⊃Args.Arguments,⊂''
      :CaseList 5 6 12⊣'display' 'disp' 'sink'
          →0↓⍨' '∨.≠Args
          :Trap 0,1000/⍨12=Cn  ⍝ avoid trapping interrupts if we don't have to, because we end up stopping the wrong place
     
              ExecUp←86 ##.THIS.⌶
              ⍝ find out how far up the stack we need to go
              up←0
              :Repeat
                  up+←1
              :Until ((0=≢)∨('UCMD'≡↑))up ExecUp'⎕SI'
              up+←1
              qseosp←↑⊆⎕SE.onSessionPrint  ⍝ onSessionPrint←onSessionPrint fails, so we have to munge the structure
              :If 12=Cn
                  ⎕SE.Dyalog.Out.Sink←{}
                  ⎕SE.onSessionPrint←'⎕SE.Dyalog.Out.Sink'
                  up ExecUp Args
                  ⎕SE.{onSessionPrint⊢←⍵}qseosp  ⍝ we have to dot into ⎕SE to avoid the reference going through this ucmd ns
                  :Return
              :EndIf
              val←up ExecUp Args
              ⎕PP←##.THIS.⎕PP
              :If Cn=5
                  r←Display val
              :ElseIf Cn=6
                  r←1 1 0 1 Disp val
              :EndIf
              old←⎕SE.UCMD'box ?'
              {}⎕SE.UCMD'box off'
              ⎕←r
              {}⎕SE.UCMD old
              ⎕EX'r'
          :Else
              ⎕SE.{onSessionPrint⊢←⍵}qseosp  ⍝ we have to dot into ⎕SE to avoid the reference going through this ucmd ns
              ⎕DMX.((EN-100×EN>1000)⎕SIGNAL⍨{⍵,⎕UCS 8/⍨''≡⍵}⍬(⊢↓⍨'⍎'=⍴)OSError{⍵,2⌽(×≢⊃⍬⍴2⌽⍺,⊂'')/'") ("',⊃⍬⍴2⌽⊆⍺}Message{⍵,⍺,⍨': '/⍨×≢⍺}⊃⍬⍴DM,⊂'')
          :EndTrap
      :Case 7⊣'ToHex'
          →0↓⍨' '∨.≠r←Args
          r←1 hex ##.THIS⍎r⊣⎕PP←34
      :Case 8⊣'FromHex'
          r←0 hex 1⊃Args.Arguments
      :Case 9⊣'factorsof'
          r←factorsOf ##.THIS⍎1⊃Args.Arguments
      :Case 10⊣'to⎕ts'
          →0↓⍨' '∨.≠r←Args
          r←dywftt ##.THIS⍎r
      :Case 11 ⍝ pivot table
          r←(##.THIS⍎Args.f)pivot ##.THIS⍎1⊃Args.Arguments
      :EndSelect
    ∇

    ∇ r←a cat1 b;sa;sb
      sa←(⍴a)⌈0 1×sb←⍴b
      r←(sa↑a)⍪(sb⌈0 1×sa)↑b
    ∇

    ∇ r←tox hex num;HEX;⎕IO;⎕ML;b
     ⍝ Turn an integer into HEX format or the other way around if la is 0
      →(num∨.≠' ')↓⍴r←⍬
      ⎕ML←⎕IO←0 ⋄ HEX←⎕D,'ABCDEFabcdef'
      num←,' ',⍕##.THIS⍎∘(1∘↓)⍣('⍎'∊1↑num)⊢num ⍝ executable string?
      num←b\num/⍨b←~num∊',' ⍝ tolerant of ,
      :If tox∧∨/0 2∊10|⎕DR num ⋄ num←1⊃⎕VFI num ⋄ :EndIf ⍝ accept char string
      :If tox
          'must be integer'⎕SIGNAL 11/⍨0≠1|num
          r←{HEX[{(1⌈⍴⍵)↑⍵},16⊥⍣¯1⊢⍵]}¨num
      :Else
          num←'(?<!\d)0x'⎕R''⊢num ⍝ remove any 0x before the numbers
          'invalid number(s)'⎕SIGNAL 11↓⍨∧/num∊' ',HEX
          num←(⊂'')~⍨{1↓¨(⍵∊' ')⊂⍵}' ',num ⍝ cut on spaces
          r←16⊥¨{⍵-6×⍵>15}¨HEX∘⍳¨num
      :EndIf
    ∇
      ∆FMT1←{
          ⎕FMT(⎕UCS 13)@{⍵=⎕UCS 10}⍵/⍤1⍨~⍵⍷⍨⎕UCS 13 10
      }

      Display←{⎕IO ⎕ML←0 1                        ⍝ Boxed display of array.
     
          box←{                                   ⍝ box with type and axes
              vrt hrz←(¯1+⍴⍵)⍴¨'│─'               ⍝ vert. and horiz. lines
              top←'─⊖→'[¯1↑⍺],hrz                 ⍝ upper border with axis
              bot←(⊃⍺),hrz                        ⍝ lower border with type
              rgt←'┐│',vrt,'┘'                    ⍝ right side with corners
              lax←'│⌽↓'[¯1↓1↓⍺],¨⊂vrt             ⍝ left side(s) with axes,
              lft←⍉'┌',(↑lax),'└'                 ⍝ ... and corners
              lft,(top⍪⍵⍪bot),rgt                 ⍝ fully boxed array
          }
     
          deco←{⍺←type open ⍵ ⋄ ⍺,axes ⍵}         ⍝ type and axes vector
          axes←{(-2⌈⍴⍴⍵)↑1+×⍴⍵}                   ⍝ array axis types
          open←{16::(1⌈⍴⍵)⍴⊂'[ref]' ⋄ (1⌈⍴⍵)⍴⍵}   ⍝ exposure of null axes
          trim←{(~1 1⍷∧⌿⍵=' ')/⍵}                 ⍝ removal of extra blank cols
          type←{{(1=⍴⍵)⊃'+'⍵}∪,char¨⍵}            ⍝ simple array type
          char←{⍬≡⍴⍵:'─' ⋄ (⊃⍵∊'¯',⎕D)⊃'#~'}∘⍕    ⍝ simple scalar type
          line←{(6≠10|⎕DR' '⍵)⊃' -'}              ⍝ underline for atom
     
          {                                       ⍝ recursive boxing of arrays:
              0=≡⍵:' '⍪(open ⎕FMT ⍵)⍪line ⍵       ⍝ simple scalar
              1 ⍬≡(≡⍵)(⍴⍵):'∇' 0 0 box ⎕FMT ⍵     ⍝ object rep: ⎕OR
              1=≡⍵:(deco ⍵)box open ∆FMT1 open ⍵  ⍝ simple array
              ('∊'deco ⍵)box trim ⎕FMT ∇¨open ⍵   ⍝ nested array
          }⍵
      }
      Disp←{
          ⎕IO ⎕ML←0 1                           ⍝ Boxed sketch of nested array.
     
          ⍺←⍬ ⋄ dec ctd←2↑⍺                       ⍝ 1:decorated, 1:centred.
     
          box←{                                   ⍝ Recursive boxing of nested array.
              isor ⍵:⎕FMT⊂⍵                       ⍝ ⎕or: '∇name'.
              1=≡,⍵:dec open ∆FMT1 dec open ⍵      ⍝ simple array: format.
              mat←matr 1/dec open ⍵               ⍝ matrix of opened subarrays.
              r c←×⍴mat                           ⍝ non-null rows/cols.
              dec<0∊r c:c/r⌿∇ 1 open mat          ⍝ undecorated null: empty result.
              subs←aligned ∇¨mat                  ⍝ aligned boxed subarrays.
              (≢⍴⍵)gaps ⍵ plane subs              ⍝ collection into single plane.
          }
     
          aligned←{                               ⍝ Alignment and centring.
              rows cols←sepr⍴¨⍵                   ⍝ subarray dimensions.
              sizes←(⌈/rows)∘.,⌈⌿cols             ⍝ aligned subarray sizes.
              ctd=0:sizes↑¨⍵                      ⍝ top-left alignment.
              v h←sepr⌈0.5×↑(⍴¨⍵)-sizes           ⍝ vertical and horizontal rotation.
              v⊖¨h⌽¨sizes↑¨⍵                      ⍝ centred aligned subarrays.
          }
     
          gaps←{                                  ⍝ Gap-separated sub-planes.
              ⍺≤2:⍵                               ⍝ lowish rank: done.
              subs←(⍺-1)∇¨⍵                       ⍝ sub-hyperplanes.
              width←⊃⌽⍴⊃subs                      ⍝ width of inter-plane gap.
              fill←(⍺ width-3 0)⍴' '              ⍝ inter-plane gap.
              ↑{⍺⍪fill⍪⍵}/1 open subs             ⍝ gap-separated planes.
          }
     
          plane←{                                 ⍝ Boxed rank-2 plane.
              2<⍴⍴⍺:⍺ join ⍵                      ⍝ gap-separated sub-planes.
              odec←(dec shape ⍺)outer ⍵           ⍝ outer type and shape decoration.
              idec←inner ⍺                        ⍝ inner type and shape decorations.
              (odec,idec)collect ⍵                ⍝ collected, formatted subarrays.
          }
     
          join←{                                  ⍝ Join of gap-separated sub-planes.
              sep←(≢⍵)÷1⌈≢⍺                       ⍝ sub plane separation.
              split←(0=sep|⍳≢⍵)⊂[0]⍵              ⍝ separation along first axis.
              (⊂⍤¯1⊢⍺)plane¨split                 ⍝ sub-plane join.
          }
     
          outer←{                                 ⍝ Outer decoration.
              sizes←1 0{⊃↓(⍉⍣⍺)⍵}¨sepr⍴¨⍵         ⍝ row and col sizes of subarrays.
              sides←sizes/¨¨'│─'                  ⍝ vert and horiz cell sides.
              bords←dec↓¨'├┬'glue¨sides           ⍝ joined up outer borders.
              ↑,¨/('┌' '')⍺ bords'└┐'             ⍝ vertical and horizontal borders.
          }
     
          inner←{                                 ⍝ Inner subarray decorations.
              deco←{(type ⍵),1 shape ⍵}           ⍝ type and shape decorators.
              sepr deco¨matr dec open ⍵           ⍝ decorators: tt vv hh .
          }
     
          collect←{                               ⍝ Collected subarrays.
              lft top tt vv hh←⍺                  ⍝ array and subarray decorations.
              cells←vv right 1 open tt hh lower ⍵ ⍝ cells boxed right and below.
              boxes←(dec∨0∊⍴⍵)open cells          ⍝ opened to avoid ,/⍬ problem.
              lft,top⍪↑⍪⌿,/boxes                  ⍝ completed collection.
          }
     
          right←{                                 ⍝ Border right each subarray.
              types←2⊥¨(⍳⍴⍵)=⊂¯1+⍴⍵               ⍝ right border lower corner types.
              chars←'┼┤┴┘'[types]                 ⍝    ..     ..      ..      chars.
              rgt←{⍵,(-≢⍵)↑(≢⍵)1 1/'│',⍺}         ⍝ form right border.
              ((matr 1 open ⍺),¨chars)rgt¨⍵       ⍝ cells bordered right.
          }
     
          lower←{                                 ⍝ Border below each subarray.
              bot←{⍵⍪(-1⊃⍴⍵)↑⍺ split ⍵}           ⍝ lower border.
              split←{((¯2+1⊃⍴⍵)/'─')glue ⍺}       ⍝ decorators split with horiz line.
              (matr↑,¨/⍺)bot¨matr ⍵               ⍝ cells bordered below.
          }
     
          type←{                                  ⍝ Type decoration char.
              dec<|≡⍵:'─'                         ⍝ nested: '─'
              isor ⍵:'∇'                          ⍝ ⎕or:    '∇'
              sst←{                               ⍝ simple scalar type.
                  0=dec×⍴⍴⍵:'─'                   ⍝ undecorated or scalar ⍕⍵: char,
                  (⊃⍵∊'¯',⎕D)⊃'#~'                ⍝ otherwise, number or space ref.
              }∘⍕                                 ⍝ ⍕ distinguishes type of scalar.
              0=≡⍵:sst ⍵                          ⍝ simple scalar: type.
              {(1=⍴⍵)⊃'+'⍵}∪,sst¨dec open ⍵       ⍝ array: mixed or uniform type.
          }
     
          shape←{                                 ⍝ Row and column shape decorators.
              dec≤0=⍴⍴⍵:⍺/¨'│─'                   ⍝ no decoration or scalar.
              cols←(×¯1↑⍴⍵)⊃'⊖→'                  ⍝ zero or more cols.
              rsig←(××/¯1↓⍴⍵)⊃'⌽↓'                ⍝ zero or more rows.
              rows←(¯1+3⌊⍴⍴⍵)⊃'│'rsig'⍒'          ⍝ high rank decorator overrides.
              rows cols                           ⍝ shape decorators.
          }
     
          matr←{↑,↓⍵}                             ⍝ matrix from non-scalar array.
          sepr←{+/¨1⊂↑⍵}                          ⍝ vec-of-mats from mat-of-vecs.
          open←{16::(1⌈⍴⍵)⍴⊂'[ref]' ⋄ (⍺⌈⍴⍵)⍴⍵}   ⍝ stretched to expose nulls.
          isor←{1 ⍬≡(≡⍵)(⍴⍵)}                     ⍝ is ⎕or of object?
          glue←{0=⍴⍵:⍵ ⋄ ↑⍺{⍺,⍺⍺,⍵}/⍵}            ⍝ ⍵ interspersed with ⍺s.
     
          isor ⍵:⎕FMT⊂⍵                           ⍝ simple ⎕OR: done.
          1=≡,⍵:∆FMT1 ⍵                           ⍝ simple array: done.
          box ⍵                                   ⍝ recursive boxing of array.
      }

      factorsOf←{⎕ML ⎕IO←1        ⍝ Prime factors of ⍵.
          ⍵{                      ⍝ note: ⎕wa>(⍵*÷2)×2*4.
              ⍵,(⍺÷×/⍵)~1         ⍝ append factor > sqrt(⍵).
          }∊⍵{                    ⍝ concatenated,
              (0=(⍵*⍳⌊⍵⍟⍺)|⍺)/⍵   ⍝ powers of each prime factor.
          }¨⍬{                    ⍝ remove multiples:
              nxt←⊃⍵              ⍝ next prime, and
              msk←0≠nxt|⍵         ⍝ ... mask of non-multiples.
              ∧/1↓msk:⍺,⍵         ⍝ all non multiples - finished.
              (⍺,nxt)∇ msk/⍵      ⍝ sieve remainder.
          }⍵{                     ⍝ from,
              (0=⍵|⍺)/⍵           ⍝ divisors of ⍵ in:
          }2,(1+2×⍳⌊0.5×⍵*÷2),⍵   ⍝ 2,3 5 .. sqrt(⍵),⍵
      }

⍝ Produce a summary of a class' (in a .Dyalog file) objects.

    ∇ r←format m3c;ss;t3
    ⍝ Format function references
    ⍝ 3rd column contains scope, size & syntax as per ⎕AT
      r←'No functions found' ⋄ →0/⍨0∊⍴m3c
      t3←⊃,0 1↓ss←0 1↓⊃m3c[;3] ⋄ ss[;2]←t3[;1] ⋄ t3←↓1+|0 1↓t3
      t3←t3⌷¨⊂⊃∘.,/'nr' '012' 'fmd'
      r←⍕'Name' 'Scope' 'Size' 'Syntax'⍪m3c[;1],ss,t3
    ∇

    ∇ ts←dywftt ts;md;shape;tmp;yr;z;⎕IO
    ⍝ *** convert ⎕FRDCI timestamp(s) to ⎕ts-format for Dyalog/W ***
    ⍝ right argument: ⎕FRDCI-type timestamp(s) of any shape
    ⍝ result: ⎕ts-type timestamp(s) with shape <(⍴argument),7>
    ⍝ Only works through 2099!
      ⎕IO←0 ⋄ shape←⍴ts ⋄ ts←,ts+18626112000
      md←365.2501|1+1461|yr←⌊ts÷5184000
      tmp←31 61 92 122 153 184 214 245 275 306 337 366
      z←(,⍉<⍀tmp∘.≥md)/,((⍴md),12)⍴⍳12
      md←(1+12|z+2),[0.1]⌈md-(0,tmp)[z]
      ts←(1960+⌊(yr+60)÷365.25),md,⍉24 60 60 60⊤ts
      ts[;6]←⌊0.5+ts[;6]×100÷6
      ts←(shape,7)⍴ts
    ∇

    ∇ table←(F pivot)data;all;Z;rc;⎕IO;d;t;K;there;keys;unik
⍝ Excel Pivot Table emulator
⍝ data is a 2 or 3 column matrix whose last column contains numbers
⍝ We could generate tables with more dimensions, this version is restricted to 2
      ⎕IO←0 ⋄ K←{⍺,F ⍵}⌸
      :If 2∊1↓⍴data ⍝ 2 column case
          table←{⍵⍪'Total'(+/,0 1↓⍵)}data[;0]K data[;1]
      :Else         ⍝ assume 3 columns
    ⍝ We generate a 2D table of all the combinations of data[;⍳2]
          rc←↑,/⍴¨unik←∪¨↓⍉keys←0 ¯1↓data
          Z←{0}¨all←,↑∘.,/unik ⋄ there←,/keys
          (t d)←↓⍉there K,data[;¯1+¯1↑⍴data]
          Z[all⍳t]←d ⋄ t←⊂'Total'
         ⍝ This only works for 3 col data
          table←(' ',(0⊃unik),t),((1⊃unik),t)⍪d⍪+⌿d←d,+/d←rc⍴Z
      :EndIf
    ∇

    ∇ r←lev Help Cmd;i;F;expr;eg;h;dir;R;b;disp
      :Access Shared Public
      F←'' '-file      interprets the argument as a filename'
     
      R←⊂'    G global item (not a visible function)'
      R,←⊂'    F visible function'
      R,←⊂'    R recursive function call'
      R,←⊂'    * function already shown (only without -full modifier)'
      R,←⊂'    ○ local item'
      R,←⊂'    ! unreferenced local item'
      R,←⊂'    L referenced label'
      R,←⊂'    l unreferenced label'
      R,←⊂'    ↑ global local (global localised at an upper level)'
      R,←⊂''
     
      :Select Cmd
      :Case 'Summary'
          i←,⊂'Summarise (scope, size, syntax) the functions in a namespace/class/scriptfile'
          i,←⊂'    ]',Cmd,' <namespace> [-file]'  ⍝ summary
          :If ×lev
              i,←'' 'For a given ref, all regular fns and dfns are reported, listing their scope, size, and syntax.' ''
              i,←⊂'Scope is {S|P|C|D} where:'
              i,←⊂'    S:shared; P:public, C:constructor; D:destructor'
              i,←'' 'Size is in bytes' ''
              i,←⊂'Syntax is {n|r}{0|1|2}{m|d|f} where:'
              i,←⊂'    n:no result; r:has result'
              i,←⊂'    0:niladic, 1:monadic; 2:dyadic'
              i,←⊂'    m:Monadic operator; d:Dyadic op; f:Function'
              i,←⊂'  For example "r0f" means a result-returning niladic function'
              i,←'' 'Example:'('    ]',Cmd,' ⎕se.Parser')
              i,←F
          :EndIf
      :Case 'Calls'
          i←,⊂'Produce the calling tree of a function in a class/namespace/scriptfile'
          i,←⊂'    ]',Cmd,' <function> [<namespace>]'
          :If ×lev
              i,←'<namespace> defaults to the current namespace' ''
              i,←'Example:'('    ]',Cmd,'  getEnvir  ⎕se.SALTUtils')
              i,←⊂'-details   shows other references (ex: vars). Each name is preceded by one of these symbols:'
              i,←R
              i,←'-treeview  uses GUI to show the result' ''
              i,←'-full      repeats description of already shown fns' ''
              i,←⊂'-ns        returns a namespace (instead of a report) containing only the requested function and its dependencies:'
              i,←⊂'    ]SubSet←',Cmd,' getEnvir  ⎕se.SALTUtils -ns'
              i,←⊂'           Alternatively, the generated namespace can be named with:'
              i,←⊂'    ]',Cmd,' getEnvir  ⎕se.SALTUtils -ns=SubSet'
              i,←F
              i,←'' 'NOTE: item names reported in other namespaces are shown as Globals.'
          :EndIf
      :Case 'Xref'
          i←,⊂'Describe the inter-object cross-references in a class/namespace/scriptfile'
          i,←⊂'    ]',Cmd,' <namespace> [-raw] [-file]'
          :If 1=lev
              i,←'' 'Example:'('    ]',Cmd,' ⎕se.Parser')''
              i,←⊂'Each name is preceded by a symbol. Its meaning is'
              i,←R
              i,←⊂'-raw       returns the raw data as a square matrix and a list of names'
              i,←F
              i,←''(']',Cmd,' -???    ⍝ for explained example')
          :ElseIf 2=lev
              i,←'' 'Example:'
              i,←⊂'    src←'':Class cl'' '':Field myfield←1'''
              i,←⊂'    src,←''∇foo a;var'' ''a←1'' ''goo'' ''∇'''
              i,←⊂'    src,←''∇goo;var'' ''var←myfield'' ''∇'''
              i,←⊂'    src,←⊂'':EndClass'''
              i,←⊂'    ⎕FIX src'
              i,←⊂'      ]Xref cl'
              i,←⊂'       var'
              i,←⊂'  myfield.'
              i,←⊂'     goo..'
              i,←⊂'      a...'
              i,←⊂'      ↓↓↓↓'
              i,←⊂'[FNS]  - -'
              i,←⊂'foo   ○F !'
              i,←⊂'goo    .G○'
              b←'This shows that var appears in both foo and goo, but in foo it only appears in the function header. '
              b,←'myfield is referenced in goo but is external to it, so appears as a Global to goo. '
              b,←'Dots, dashes, colons and arrows only serve as alignment decorators and have no special meaning. '
              b,←'Alternatively, we can get the raw information (square table, name list):'
              i,←''b
              i,←⊂'    ]Xref cl -raw'
              i,←⊂'┌─────┬───────────────────────┐'
              i,←⊂'│     │┌─┬───┬───┬───────┬───┐│'
              i,←⊂'│○ F !││a│foo│goo│myfield│var││'
              i,←⊂'│   G○│└─┴───┴───┴───────┴───┘│'
              i,←⊂'│     │                       │'
              i,←⊂'│     │                       │'
              i,←⊂'└─────┴───────────────────────┘'
              i,←''(']',Cmd,' -??    ⍝ for full syntax and legend')
          :EndIf
      :Case 'CD'
          i←,⊂'Report (and, optionally, change) the current directory'
          i,←⊂'    ]',Cmd,' [<newdir>]' ⍝ cd
          :If ×lev
              i,←'' 'Examples:'
              i,←'' 'What is the current directory?'
              i,←⊂'    ]',Cmd
              i,←⊂⎕SE.Dyalog.Utils.CD''
              i,←'' 'Let''s go to the root directory:'
              i,←⊂'    ]',Cmd,' ',⎕SE.SALTUtils.FS
              i,←⊂dir←⎕SE.Dyalog.Utils.CD'/'
              i,←'' 'What is the current directory now?'
              i,←⊂'    ]',Cmd
              i,←⊂⎕SE.Dyalog.Utils.CD''
              i,←'' 'Let''s go back to where we came from:'
              i,←⊂'    ]',Cmd,' ',dir
              i,←⊂⎕SE.Dyalog.Utils.CD dir
          :EndIf
      :CaseList 'Disp' 'Display'
          disp←Cmd≡'Disp'
          i←,⊂'Display specified array with borders indicating ',('non-simple array shape and'/⍨disp∧lev>0),('array and '/⍨~disp),'sub-array shape and type'
          i,←⊂'    ]',Cmd,' <array>'
          :If ×lev
              i,←⊂''
              i,←⊂'Axes are indicated as follows:'
              i,←⊂'es'⎕R'is'⍣disp⊢'    ↓  leading axes   (length>0)'
              i,←⊂'    →  trailing axis  (length>0)'
              i,←⊂'es'⎕R'is'⍣disp⊢'    ⌽  leading axes   (length=0)'
              i,←⊂'    ⊖  trailing axis  (length=0)'
              i,←disp/⊂'    ⍒  multiple leading axes'
              i,←⊂'Content types are indicated as follows:'
              i,←disp↓⊂'    ∊  Nested'
              i,←⊂'    ~  Numeric'
              i,←⊂'    ─  Character'
              i,←⊂'    #  Namespace'
              i,←⊂'    ∇  ⎕OR'
              i,←⊂'    +  Mixed'
              i,←⊂'If any axis is length-0 then the content is prototypical'
              expr←Cmd,' 1 1 4⍴(42''ab'')⎕SE(⍪''ab'',42)⍬'
              i,←'' 'Example:'('    ]',expr),↓⍎'1',expr
              i,←⊂''
              i,←⊂'NOTE:  This is similar to displaying array with ]Boxing on -style=m','idax'/⍨2/1 0=disp
          :EndIf
      :Case 'ToHex'
          i←,⊂'Convert integer(s) to a vector of text vectors containing the hexadecimal representation of each number'
          i,←⊂'    ]',Cmd,' <expression>' ⍝ tohex
          :If ×lev
              eg←'  61166 100 999'
              i,←'Examples:'('    ]',Cmd,eg)' EEEE  64  3E7 '
              eg←'  ¯1 0 1+2*32'
              i,←('    ]',Cmd,eg)' FFFFFFFF  100000000  100000001 ' '' 'Related command: ]FromHex'
          :EndIf
      :Case 'FromHex'
          i←,⊂'Convert a list of hexadecimal representations of integers to a numeric vector'
          i,←⊂'    ]',Cmd,' <hex>' ⍝ fromhex
          :If ×lev
              eg←'  307 EEEE A'
              i,←'Example:'('    ]',Cmd,eg)'775 61166 10' '' 'Related command: ]ToHex'
          :EndIf
      :Case 'Factors'
          i←,⊂'Determine the prime factors of the argument'
          eg←' 67890'
          i,←('    ]',Cmd,eg)(⍕factorsOf⍎eg)
          r←i
          :Return
      :Case 'ToQuadTS'
          i←,⊂'Convert a component file timestamp (single float number) to ⎕TS format (vector of 7 numbers)'
          i,←⊂'    ]',Cmd,eg←' 1.23456E10'
          i,←⊂dywftt⍎eg
          r←i
          :Return
      :Case 'PivotTable'
          i←,⊂'Create a pivot table from an appropriate matrix'
          i,←⊂'    ]',Cmd,' <matrix>'
          i,←⊂'The matrix must have 2 or 3 columns. The last column must contain data appropriate for the function to apply (default count).'  ⍝ pivottable
          :If ×lev
              i,←'Example:' '      m←10 2⍴J 1 J 2 A 3 J 4 I 5 J 6 J 7 I 8 I 9 J 10⊣A I J←''AIJ'''
              i,←⊂'    ]',Cmd,' m  -f=+/'
              i,←⊂' J      30'
              i,←⊂' A       3'
              i,←⊂' I      22'
              i,←⊂' Total  55'
     
              i,←'' '   M← (20 2⍴''C3C3C4B4C2B2D1C4A4C1B3B1C1B2A0A1D1B0C1C4''),4 3 4 8 3 3 9 6 5 9 2 7 7 1 6 5 4 7 6 9'
              i,←⊂'    ]',Cmd,' M ⍝ count the number of each by default'
              i,←⊂'        3 4 2 1 0  Total'
              i,←⊂' C      2 3 1 3 0      9'
              i,←⊂' B      1 1 2 1 1      6'
              i,←⊂' D      0 0 0 2 0      2'
              i,←⊂' A      0 1 0 1 1      3'
              i,←⊂' Total  3 5 3 7 2     20'
     
              i,←'' 'Sum each:'('    ]',Cmd,' M  -f=+/')
              i,←⊂'        3  4 2  1  0  Total'
              i,←⊂' C      7 19 3 22  0     51'
              i,←⊂' B      2  8 4  7  7     28'
              i,←⊂' D      0  0 0 13  0     13'
              i,←⊂' A      0  5 0  5  6     16'
              i,←⊂' Total  9 32 7 47 13    108'
     
              i,←'' 'Average:'('    ]',Cmd,' M -f=+/ ÷ ≢')'...'
     
              i,←''('    ]',Cmd,' "(5 2⍴''GrpA'' ''case1'' ''GrpB'' ''case1'' ''GrpB'' ''case2'' ''GrpA'' ''case1'' ''GrpB'' ''case2''),⍳5"  -f=+/')
              i,←⊂'        case1  case2  Total'
              i,←⊂' GrpA       5      0      5'
              i,←⊂' GrpB       2      8     10'
              i,←⊂' Total      7      8     15'
          :EndIf
      :EndSelect
      r←i,(0=lev)/''(']',Cmd,' -?? ⍝ for more information and examples')
     
    ∇

⍝ Spice example:
⍝ fncalls  utils\callingTree ctor -details -treeview

    :SECTION Test
    ∇ r←Test dummy;T;cmd;n;ns;fn2;fn1;nl;t
      r←⍬ ⋄ T←{⎕SE.UCMD cmd,' ',⍵}
      fn1←{fn2 ⍵
   ⍝ Do something
      }
      fn2←*○
      'ns'⎕NS'fn1' 'fn2'
      :For cmd :In AllCmds
          :Trap n←0
              :Select cmd
              :Case 'Summary'
                  n←(T'ns')[;(⍳27)~14+⍳4]≡3 23⍴' name  scope    syntax  fn1             r2f    fn2             n0f   '
              :Case 'Calls'
                  n←(T'fn1')≡'Level 1:  →fn1',nl,'⍝ Do something',nl,'  F:fn2',(2/nl←⎕UCS 13),'Level 2: fn1→fn2'
              :Case 'Xref'
                  n←(T'ns')≡6 8⍴'       ⍵    fn2.      ↓↓[FNS]  -fn1   F○fn2    .'
              :Case 'CD'
                  n←(t≡(-⍴t)↑T'')∧(0⍴t←T'\tmp')≡'' ⋄ {}T t
              :Case 'Display'
                  n←(T'⎕NR ''fn2''')≡3 4⍴⎕UCS 9484 8594 9472 9488 9474 42 9675 9474 9492 9472 9472 9496
              :Case 'Disp'
                  n←(T'⎕NR ''fn1''')≡3 34⍴(⎕UCS 9484 8594,(10/9472),9516,(17/9472),9516 9472 9472 9488 9474),' fn1←{fn2 ⍵',(⎕UCS 9474),'   ⍝ Do something',(⎕UCS 9474 32 125 9474 9492,(10/9472),8594 9524,(16/9472),8594 9524 9472 8594 9496)
              :Case 'ToHex'
                  n←(T'912559 49374')≡'DECAF' 'C0DE'
              :Case 'FromHex'
                  n←(T'BAD C0FFEE 0x1DE')≡2989 12648430 478
              :Case 'Factors'
                  n←(T'1066')≡2 13 41
              :Case 'ToQuadTS' ⍝ Wrongly thinks 2100 is a leap year:
                  n←(T'246453E6')≡2100 2 29 2 6 40 0
              :Case 'PivotTable'
                  n←(T'2 3⍴⍳6 -f=+/')≡4 4⍴' ' 2 5 'Total' 1 3 0 3 4 0 6 6 'Total' 3 6 9
              :EndSelect
          :EndTrap
          r,←n
      :EndFor
     
    ∇
    :ENDSECTION

:Endnamespace ⍝ Summary  $Revision: 1911 $
