﻿:namespace Setup ⍝ V1.25
⍝ requires SALTUtils V2.608
⍝ Script for Personalization of Spice
⍝ 2015 05 21 Adam: NS header
⍝ 2015 06 01 Adam: Total Help overhaul and auto PW
⍝ 2015 11 12 Adam: moved help layout to framework
⍝ 2015 12 01 DanB: account for Mac OS and allow 2 locations for setup
⍝ 2016 05 29 DanB: added switch -info
⍝ 2017 01 12 Adam: use 4070⌶ on Windows
⍝ 2017 01 15 Adam: correct help * →  0/1
⍝ 2017 03 07 Adam: help now shows OS appropriate folder sep
⍝ 2017 06 08 Adam: try to find setup.dyalog in SALT paths
⍝ 2017 06 11 Adam: change this file's name to usetup.dyalog to lower risk of infinite recursion. Update help text to new spec
⍝ 2017 06 15 Adam: added -info=list to list all search paths
⍝ 2017 06 19 Adam: [14684] Use USERDIR rather than ⎕AN; cleanup
⍝ 2017 06 23 Adam: Fixed ⎕ML bug
⍝ 2017 06 26 Adam: Fixed ns path for global vars
⍝ 2017 07 05 Adam: Help note about argument
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -??
⍝ 2018 05 07 Adam: help tweaks
⍝ 2018 02 01 Adam: help
⍝ 2021 09 17 Adam: Move code to SALTUtils
⍝ 2022 03 03 Adam: Return result

    ⎕ML←1 ⋄ ⎕IO←1 ⋄ Folder←'MyUCMDs'
    DESC←'Run Setup from setup.dyalog'

    (WIN DEL PATH)←⎕SE.SALTUtils.(WIN(1⊃PATHDEL)USERDIR)
    
    ∇ r←List
      r←⎕NS''
      r.Name←'USetup'
      r.(Group Parse)←'UCMD' '1SL -info[=]list'
      r.Desc←DESC
      r←,r
    ∇

    ∇ r←Run(Cmd arg);ns;fn;exist;do;on;cb;paths;list
     ⍝ Run system setup
      r←⎕SE.SALTUtils.USetup arg.(Arguments info)
    ∇

    ∇ r←level Help Cmd;h;folders
      r←⊂DESC
      r,←⊂'    ]',Cmd,' [<arg>] -info[=list]'
      r,←⊂''
      :If 0=level
          r,←⊂']',Cmd,' -?? ⍝ for more information and examples'
      :Else
          r,←⊂'<arg>       right argument for Setup function'
          r,←⊂'-info       report setup.dyalog path in use and whether it exists'
          r,←⊂'-info=list  report full set of candidate setup.dyalog paths and whether they exist'
          folders←'"',PATH,Folder,'/"',(~WIN)/' or "',PATH,'.dyalog/',Folder,'/"'
          h←'To use this functionality, save a function named "Setup" (or namespace with such a function) in a file called "setup.dyalog" in '
          h,←folders
          h,←' or in one of the current SALT workdirs ('
          h,←DEL ⎕R', '⎕SE.SALT.Settings'workdir'
          h,←').'
          r,←''h''
          r,←⊂'If the Setup function is monadic and ]',Cmd,' is called with an argument, Setup will be called that argument, or with ''init'' when Dyalog APL starts.'
          r,←'' 'Examples:' '    To always let F2 list variables and F3 list functions:'
          r,←⊂'        Setup←{('')VARS'',⊂''ER'') ('')FNS'',⊂''ER'') ⎕PFKEY¨2 3}'
          r,←⊂'        ]Save Setup ',PATH,Folder,'/ -makedir'
          r,←'' '    To return the filename which will be used followed by a Boolean indicating if it exists or not:'
          r,←⊂'        ]',Cmd,' -info'
          r,←⊂'    ',⍕Run 0 ⎕JSON'[0,{"Arguments":0,"info":1}]'
          r,←⊂''
          r,←⊂'    To return a list of all current search paths with a Boolean for each indicating if that file exists (the topmost existing one, if any, will be used):'
          r,←⊂'        ]',Cmd,' -info=list'
          r,←⊂'    '
          r←⎕SE.SALTUtils.FixSlashes r
      :EndIf
    ∇


:Endnamespace ⍝ Setup  $Revision: 1777 $
