﻿:namespace  WSutils ⍝ V1.22
⍝ Misc Workspace Utilities
⍝ 2015 05 20 Adam: NS header
⍝ 2015 11 12 Adam: moved help layout to framework
⍝ 2016 02 14 DanB: made ]reorderlocals work for scripted nss too
⍝ 2017 07 13 Adam: help overhaul
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -??
⍝ 2018 06 05 Adam: help tweaks
⍝ 2019 02 01 Adam: help
⍝ 2021 03 22 Adam: add missing "-" in syntax spec
⍝ 2022 07 06 Adam: ]sizeof: mention curr ns

    (⎕ml ⎕io)←1 ⋄ CR←⎕ucs 13

    if←/⍨

    AllCmds←'Align' 'ReorderLocals' 'FnsLike' 'VarsLike' 'NamesLike' 'Nms' 'SizeOf' 'ObsLike'

    ∇ r←{data}Select cmd
      :If 900⌶⍬
          data←(o,f)f f v(f,n)f t v ⍝ uses dynamic scope
      :EndIf
      r←data⌷⍨⊂AllCmds⍳⊆cmd
    ∇

    ∇ r←List;f;i;v;n;o;t
      :Access Shared Public
      r←⎕NS¨(⍴AllCmds)⍴⊂''
      r.Group←'FN' 'FN' 'WS' 'WS' 'WS' 'WS' 'WS' 'WS'
      f←' -date=',v←' -format[=]no NO -regex -recursive'
      o←'-offset= '
      n←' -noclass'
      t←'-top= -class='
      r.Parse←Select AllCmds
      r.Name←AllCmds
      i←0
      r[i←i+1].Desc←'Align end-of-line comments'
      r[i←i+1].Desc←'Sort local names in the header of tradfns and tradops'
      r[i←i+1].Desc←'List functions and operators matching a pattern'
      r[i←i+1].Desc←'List variables matching the pattern'
      r[i←i+1].Desc←'List names followed by their class matching the pattern'
      r[i←i+1].Desc←'List names followed by their class matching the pattern'
      r[i←i+1].Desc←'Report size of the current namespace''s variables in descending order'
      r[i←i+1].Desc←'List objects matching the pattern'
    ∇

    ∇ r←lev Help Cmd;Cno;getex;sw;p;v;f;o;n;t;s;a
    ⍝ General Help for the commands in this namespace
     
      a←'' '    <pattern>      target items (if omitted, then all items will be processed)'
      v←,⊂'    -format[=no]   display result as )FNS would (implied in session when result is not assigned with ]res←',Cmd,', but can be disabled with -format=no)'
      v,←⊂'    -regex         use full regular expression (see ⎕R help) for <pattern> instad of globbing'
      v,←⊂'    -recursive     recurses through each namespace (if omitted, then <pattern> is only searched for in the current namespace)'
      f←,⊂'    -date=<range>  takes a value (optionally preceded by > or <), or a pair of [YY]MMDD values'
      f,←v
      o←,⊂'    -offset=<c>    column where comments should begin (default 40)'
      n←,⊂'    -noclass       removes the class number after the name'
      t←'    -top=<n>       show only the top <n> values' '    -class=<nc>    restrict the name class to the single value specified'
     
     ⍝ We now define (⍴AllCmds) arrays, one for each command
      r←,List.Desc Select Cmd
      s←a,⊃Select Cmd
      r,←⊂'    ]',Cmd,∊'^ *-(\S+)' '^ *(\S+)'⎕S' [-\1]' ' \1'⊢s
      r,←s/⍨(1=lev)∨(×lev)∧Cmd≡'SizeOf'
     
      :If 2≤lev ⍝ Examples (-???) help section
      :OrIf 1 'SizeOf'≡lev Cmd
          r,←'' 'Examples:'
     ⍝ We use the comments in this function to extract the information
     ⍝ Each :Case block contains examples in comments surrounded by a pair of labels.
     ⍝ The labels are given to <getex> to extract them at the end of each block
          getex←Cmd∘{'    '∘,¨'⋄Cmd⋄'⎕R Cmd⊢1↓¨(⍵[1]+1)↓⍵[2]↑⎕NR'Help'}
     
          :Select AllCmds⍳⊂Cmd
     os:  :Case 1               ⍝ align
⍝
⍝Align the inline comments at col 16 for fn <Fa>:
⍝
⍝      ⎕VR 'Fa'
⍝     ∇ Fa     ⍝ header rmk
⍝[1]    no eol'⍝'here
⍝[2]    this line at 16        ⍝ no ⍝ in above line
⍝[3]
⍝[4]   ⍝ Empty line above
⍝[5]    long line exceeding col  ⍝1 space added only
⍝[6]       ⍝ Comment line untouched
⍝[7]    'line with ⍝'    ⍝ c1
⍝[8]    dif2a        ⍝1 space will be inserted
⍝[9]    same3           ⍝     leading spaces deleted
⍝     ∇
⍝
⍝      ]⋄Cmd⋄  Fa -offset=16
⍝ 1  functions processed,  1  modified
⍝Fa
⍝      ⎕VR 'Fa'
⍝     ∇ Fa             ⍝ header rmk
⍝[1]    no eol'⍝'here
⍝[2]    this line at 16 ⍝ no ⍝ in above line
⍝[3]
⍝[4]   ⍝ Empty line above
⍝[5]    long line exceeding col ⍝ 1 space added only
⍝[6]       ⍝ Comment line untouched
⍝[7]    'line with ⍝'  ⍝ c1
⍝[8]    dif2a          ⍝ 1 space will be inserted
⍝[9]    same3          ⍝ leading spaces deleted
⍝     ∇
     oe:      r,←getex os oe
     
     rs:  :Case 2               ⍝ reorderlocals
⍝
⍝Reorder the locals in all fns starting with F:
⍝      ⎕vr 'Fnml'
⍝     ∇ Fnml;⎕PP;X;⍙;a;_;aa;Aa;aaAA;aA;⎕IO ⍝ locals anyone?
⍝[1]    ...
⍝     ∇
⍝      ]⋄Cmd⋄  F*
⍝3 fns processed, 1 changed
⍝      ⎕vr 'Fnml'
⍝     ∇ Fnml;a;aa;aA;Aa;aaAA;X;⍙;_;⎕IO;⎕PP ⍝ locals anyone?
⍝[1]    ...
⍝     ∇
     re:      r,←getex rs re
     
     fs:  :Case 3               ⍝ fnslike - includes operators
⍝
⍝Find all fns/ops whose name starts with F and display like )FNS:
⍝     ]⋄Cmd⋄  X*
⍝Xa    Xb    Xc
⍝
⍝Return the names of fns/ops whose name contains the string 'ex' after Feb 5th:
⍝     ]⋄Cmd⋄  *ex*   -date= >205
⍝regex  texico
⍝
⍝Return the names of programs whose name contains the same vowel repeated 3 times:
⍝     ]⋄Cmd⋄ ([aeuoi])\1\1  -regex  -format=no
⍝ooops
⍝weee
⍝
⍝Show the fns/ops in all namespaces in and below the one we're in:
⍝     ]⋄Cmd⋄  -recursive
⍝on1  on2  on3
⍝
⍝#.ns1
⍝ens1 gns2 hns3 jns4
     fe:      r,←getex fs fe
     
     vs:  :Case 4               ⍝ varslike
⍝
⍝Find all variables starting with F and display like )VARS:
⍝     ]⋄Cmd⋄  F*
⍝Fa    Fbc   Fxyz
⍝
⍝Example: return the names of vars/spaces whose name contains the same vowel repeated 3 times:
⍝     ]varslike ([aeuoi])\1\1  -regex  -format=no
⍝ooops
⍝weee
     ve:      r,←getex vs ve
     
     ns:  :Case 5               ⍝ nameslike
⍝
⍝Find all 3 letter names:
⍝     ]⋄Cmd⋄  ???
⍝aaa.2 dsa.2 fds.2 foo.3 goo.3
⍝
⍝Return the names of objects whose name contains the same vowel 3 times in a row:
⍝     ]⋄Cmd⋄ ([aeuoi])\1\1  -regex  -noclass
⍝ooops  weee
     ne:      r,←getex ns ne
     
     ms:  :Case 6               ⍝ nms
⍝
⍝Find all 3 letter names and display like )VARS:
⍝     ]⋄Cmd⋄  ???
⍝aaa.2 dsa.2 fds.2 foo.3 goo.3
⍝
⍝Return the names of objects whose name contains the same vowel 3 times in a row:
⍝     ]⋄Cmd⋄  ([aeuoi])\1\1  -regex
⍝ooops.2  weee.3
     me:      r,←getex ms me
     
     ss:  :Case 7               ⍝ sizeof
⍝
⍝Find the size of the 3 largest variables and namespaces:
⍝     ]⋄Cmd⋄  -top=3  -class=2 9
⍝m   11240   aa   9124    XYZ  1248
⍝
⍝Return the size of all 3 letter functions and operators:
⍝     ]⋄Cmd⋄  ??? -class=3 4
⍝axe 13216   wee  2224
     se:      r,←getex ss se
     
     bs:  :Case 8               ⍝ obslike
⍝
⍝Find the class 9 objects starting with N:
⍝     ]⋄Cmd⋄ N*
⍝N1    Nbeta Nameit
⍝
⍝Return the names of all 3 letter obs:
⍝     ]⋄Cmd⋄  ???
⍝abc   def   xyz
     be:      r,←getex bs be
     
          :EndSelect
      :EndIf
      r,←⊂''
      :If Cmd≡'SizeOf'
          r,←(0=lev)/⊂']',Cmd,' -??  ⍝ for more information and examples'
      :Else
          r,←((lev≤0 1),lev≥2)/(']',Cmd,' -')∘,¨(3⍴'??' '???'),¨'  ⍝ for '∘,¨'more information' 'examples' 'syntax details'
      :EndIf
    ∇

    ∇ r←{ref}Run(Cmd Args);addclass;allowed;at;b;bad;cfn;ch;Cno;col;date;DATE;dates;DOS;format;l1;n;names;nc;ok;salted;show;sz;t;WIN
     ⍝ Main program. Prepare for all cases.
      WIN←⍬⍴'Windows'⍷1⊃'.'⎕WG'APLVersion'
      :If 0=⎕NC'ref' ⋄ ref←##.THIS ⋄ :EndIf ⍝ where to do this
     
     ⍝ All cmds accept name patterns. Each may refer to a namespace but they must all be the same
      :If '.'∊⍕t←∪Args.Arguments ⍝ any dotted name?
          'all patterns must refer to the same namespace'⎕SIGNAL 11 if 1≠⍴l1←∪(-⊥⍨¨'.'≠t)↓¨t
          nc←ref.⎕NC names←¯1↓1⊃l1
          (names,' is not a namespace')⎕SIGNAL 11 if 9≠nc ⍝ ensure the dotted section refers to a space
          ref←ref⍎names                                   ⍝ and grab it
          Args.Arguments←(1+⍴names)↓¨t                    ⍝ and correct the naming
      :EndIf
     
      Cno←AllCmds⍳⊂Cmd         ⍝ which command
      show←↑                   ⍝ by default we simply disclose the whole thing
     
     ⍝ Add classification to argument (a name) for Nms and NamesLike if -noclass is NOT set
      addclass←{' '~⍨⍵,'.',⍕ref.⎕NC ⍵}⍣((Cno∊6 5)>Args.Switch'noclass')
     
      DOS←~Args.Switch'regex'  ⍝ assume DOS regular expression if -regex not there
     
      :If format←(⊂Args.Switch'format'){⍺∊'no' 'NO':0 ⋄ 6::⍵ ⋄ ##.RIU≤⍺}1 ⍝ is the result used?
          show←⎕PW ¯2∘⎕SE.Dyalog.Utils.showCol
      :EndIf
     
     ⍝ Find the classes allowed for each command and their names in the namespace to run this command
      nc←Cno⊃(3.1 3.2 4.1 4.2 9.1 9.4)(3 4 9.1 9.4)(3 4)2(⍳9)(⍳9)(2 9 Args.Switch'class')9
      names←ref.⎕NL-nc         ⍝ VTV form
     
     ⍝ Prepare for the -date switch
      :If ∨/3 4∊nc             ⍝ -date is for all but SIZE
      :AndIf 0≢DATE←Args.Switch'date'
          'only one comparison fn allowed'⎕SIGNAL 11 if 1<⍴n←DATE∩allowed←'<≤≥>-=≠'
          cfn←⍎t←1↑n,'='       ⍝ the comparison function
          'incorrect number of dates'⎕SIGNAL 11 if(0 1='-'∊t)⍱.∧1 2=⍴dates←2⊃⎕VFI DATE{b\⍺/⍨b←~⍺∊⍵}allowed
         ⍝ Keep all those without a timestamp unless required
          ok←('='∊t)∧(dates≡,0)∧0=at←100∘⊥∘(3∘↑)¨,0 1 0 0/ref.⎕AT names
         ⍝ We allow short dates and defaults are supplied for the century, the year and the month
          dates+←(20000000,10000 100×100|2↑⎕TS)+.×1000000 10000 100∘.>dates ⍝ pad century, year, month need be
         ⍝ If we are given 2 dates the comparison function is <in-range>
          :If '-'∊t ⋄ cfn←{(⍺≥1↑⍵)∧⍺≤1↓⍵} ⋄ :EndIf
          ok∨←at cfn dates     ⍝ make sure the dates are as requested
          names←ok⌿names       ⍝ and extract only those names
      :EndIf
     
      t←Args.Arguments
      :If (0<⍴t)>0∊⍴r←names    ⍝ any pattern to use?
          r←names namesLike t  ⍝ several patterns allowed
      :EndIf
     
      l1←⍬
      :If ~0∊⍴r                ⍝ any name found?
          :If Cno=1            ⍝ ]Align
              col←40 Args.Switch'offset'
              r←col ref Align r
          :ElseIf Cno=7        ⍝ ]sizeof
              n←⍴t←⍒sz←ref.⎕SIZE r
              r←↓(rtb↑r[t]),' ',⍕sz[⍪t] ⍝ top=¯n takes from the bottom
              :If 0≠t←n Args.Switch'top' ⋄ r←((×t)×n⌊|t)↑r ⋄ :EndIf
          :ElseIf Cno=2        ⍝ ]reordLocals
              :If 1∊⍴r ⋄ :AndIf 9=ref.⎕NC n←⊃r ⋄ ref←ref⍎n ⋄ r←'' ⋄ :EndIf
              l1←' objects processed',⍨⍕1⊃(nc ch bad salted)←ref ohl r Args.recursive
              l1,←', ',(⍕≢ch),' changed'
              :If 0<n←≢bad ⋄ l1,←', ',(⍕n),' failed:',⍕bad ⋄ :EndIf
              l1,←(×n)/CR,(⍕salted),((1+1<n←≢salted)⊃'is' 'are'),' SALTED and should be reSAVED!'
              r←ch
          :EndIf
      :EndIf
      r←show addclass¨r
      :If 0<⍴l1 ⋄ r←0 1↓⎕FMT 2 1⍴l1 r ⋄ :EndIf
      :If (Args.Switch'recursive')∧(ref≠⎕THIS)
      :AndIf ~0∊⍴n←(ref.⎕NL ¯9.1)~⊂'SALT_Data'
          t←(⍕ref)∘{s←⍴⍺ ⋄ ⍵↓⍨1+s×(⍺≡s↑⍵)∧1=+/'.'=s↓⍵}∘⍕¨ref⍎¨n
      :AndIf ~0∊⍴n←(n≡¨t)/n
          nc←(t←ref⍎⍕n)Run¨⊂Cmd Args
          r←↑cat1/(⊂r),t{format:(~0∊⍴⍵)⌿' '⍪(':',⍨⍕⍺)cat1' '⍪⍵
              ({1⌽⍵↑⍨-1+⊥⍨'.'≠⍵}⍕⍺),⍤1⊢⍵}¨nc
      :EndIf
    ∇

    a2cut←{⎕ml←3 ⋄ (⍵≠⍺)⊂⍵}

    ∇ header←sortlocals header;b;c;h;l;m;newh;so
     ⍝ Sort a header line
      (h c)←{i-←⊥⍨' '=(i←¯1+⍵⍳'⍝')↑⍵ ⋄ (rtb i↑⍵)(i↓⍵)},header
      →0 if 1∊'['''∊h          ⍝ skip lines with [;] or text
      →0 if 2>⍴m←';'a2cut h
      l←' 'a2cut b\l/⍨b←21≠⊃200⌶,⊂l←1⊃m
      so←' ',⊖2 28⍴⎕A,'⍙_abcdefghijklmnopqrstuvwxyz∆⎕'
      →0 if h≡newh←1↓∊';',¨∪m[1,1+so⍋1↓↑m]~l ⍝ sort, removing dups
      header←((⍴h)↑newh),c
    ∇

    ∇ (changed fns CRs)←ns findCRs fns;c
      :If 0∊⍴fns ⋄ changed←1⍴⍨⍴CRs←ns.⎕CR¨fns←ns.⎕NL-3.1 4.1
      :Else
          :If 1∊c←(~0∊⍴)¨CRs←ns.⎕CR¨fns ⍝ must be defined
          :AndIf 1∊c\←2=∊(⍴⍴)¨c/CRs     ⍝ exclude composed fns (rank=1)
              c\←{'}'≢⊢/' '~⍨⊢⌿⍵}¨c/CRs ⍝ exclude Dfns
          :EndIf
          changed←c
      :EndIf
    ∇

    ∇ (total changed badp salted)←ns ohl(fns rec);b;chk;classpos;cr;CRs;dns;fn;h;i;l;l1;mod;n;new;newh;S;SALTns;src;tmp;tmpsrc⍝ 0=not new, 1=new, ¯1=failed
    ⍝ Order Header Locals.
    ⍝ Reorder locals in (trad) pgms in namespace ns, possibly RECursively
    ⍝ It returns the # of pgms processed, the # changed, the list that failed and the list of spaces that were changed and are SALTed
    ⍝ It is recursive and will report, from the top level, all this data accumulated from the rec calls.
      salted←badp←0⍴⊂changed←⍴total←0
      :If ns≡dns←,⍕ns ⋄ ns←⍎dns ⋄ :EndIf ⍝ display form of ns
     
      :If 0≢tmpsrc←src←{16::0 ⋄ ⎕SRC ⍵}tmp←ns      ⍝ are we dealing with a scripted ns?
         ⍝ Work on tradfns only
          SALTns←{6::0 ⋄ ⍵.SALT_Data}ns            ⍝ grab a copy of SALT data, if any
          :If classpos←9.4=⎕NC⊂⍕ns                 ⍝ is this a class?
              classpos←1+(⊣/,⊢/)'^ *:(end)?class'⎕S 2⍠1⊢src
              tmpsrc[classpos]←':namespace' ':endnamespace'
              tmpsrc←'^ *:(end)?(property|implem|field|access)'⎕R'⍝'⍠1⊢tmpsrc
              :Trap 11
                  tmp←0 ⎕FIX tmpsrc
              :Else
                  ⍞←'*** Unable to process ',dns,CR ⋄ →0
              :EndTrap
          :EndIf
     
         ⍝ Find the ⎕CR of each program
          (changed fns CRs)←tmp findCRs fns
     
         ⍝ We now know which names are to be possibly modified. Let's find them in the source.
          :If ∨/changed
              l1←⊣⌿¨changed/CRs                    ⍝ the header of each pgm to check
              i←1⍳⍤1⍨1∊¨('∇ '∘,∘rlb∘rtb¨l1)∘.⍷src  ⍝ this is the position of each fn header
          :AndIf ∨/changed\←b←n←l1≢¨new←sortlocals¨l1
              (1⌷¨changed/CRs)←b/l1                ⍝ replace header line
          :AndIf 1∊changed←changed\¯1+2×(changed/fns)≡¨tmp.⎕FX¨changed/CRs
              src[n/i]←'∇',¨n/new
              tmp←ns.##.⎕FIX src
              :If 0≢SALTns ⋄ tmp.SALT_Data←SALTns ⋄ salted←⊂⍕tmp ⋄ :EndIf
          :EndIf
          h←dns,'.'
          badp←h∘,¨(¯1=changed)/fns ⋄ total←≢changed ⋄ changed←h∘,¨(changed=1)/fns
     
      :ElseIf ~0∊⍴⊃(mod chk CRs)←ns findCRs fns   ⍝ previous non-scripted ns code
     
         ⍝ Do the fns first
          :If 1∊mod←mod∧(ns.⎕NC chk)∊3.1 4.1
          :AndIf 1∊mod\←b←h≢¨newh←sortlocals¨h←⊣⌿¨mod/CRs
              (1⌷¨mod/CRs)←b/newh ⋄ mod\←¯1*(mod/chk)≢¨ns.⎕FX¨mod/CRs
          :EndIf
          h←dns,'.'
          badp←h∘,¨(¯1=mod)/chk ⋄ total←≢mod ⋄ changed←h∘,¨(mod=1)/chk
         ⍝ Do the nss after
          :If rec∨1=+/{⍵∊1↑⍵}⎕XSI ⍝ is this the first call?
              :For n :In ((ns.⎕NC fns)∊9.1 9.4)/fns
                  new←(h,n)ohl ⍬ rec
                  total+←1⊃new
                  (changed badp salted),←1↓new
              :EndFor
          :EndIf
      :EndIf
    ∇

⍝ Patterns, here, are the limited version where ? mean 1 character
⍝ and * means any series of characters. Ex: abc*def means "a name starting
⍝ with 'abc' and ending with 'def'".

    DOS←1                      ⍝ to make this work in test mode

    ∇ mat←mat namesLike pattern
    ⍝ Return lines in mat that match the pattern
    ⍝ Trailing spaces in mat are ignored
      :If 0<⍴mat
          :If DOS              ⍝ DOS mode?
             ⍝ Then replace ? by . and * by .* (note expression remains REGEX)
             ⍝ This only changes the meaning of *, ? and automatically anchors the pattern
              pattern←'^',¨('\?' '\*'⎕R'.' '.*'⊢pattern),¨'$'
          :EndIf
          mat←mat[⎕IO+∪pattern ⎕S 2⊢mat]
      :EndIf
    ∇

    ∇ {mod}←la Align arg;col;cr;fn;i;new;nr;ns;S;t;⎕IO
    ⍝ Align comments in fns in matrix or VTV ARG at col in namespace
      (col ns)←la ⋄ ⎕IO←0
      :If 1=≡arg ⋄ arg←~∘' '¨↓arg ⋄ :EndIf
      mod←{0}¨arg
      :For fn :In arg
          :Select ⍬⍴ns.⎕NC⊂fn
          :CaseList 3.1 4.1 3.2 4.2
              :If 2≡≡cr←ns.⎕NR fn ⍝ take a copy to see if anything has changed and ignore fns with refs
                  :If 0≢nr←col movcom cr
                      :If fn≢ns.⎕FX nr
                          ⎕←'*** Unable to refix function <',fn,'>'
                      :Else
                          mod[arg⍳⊂fn]←1 ⍝ note change
                      :EndIf
                  :EndIf
              :EndIf
          :CaseList 9.4 9.1
              :If ~0∊⍴cr←ns.{16::⍬ ⋄ ⎕SRC⍎⍵}fn
              :AndIf 0≢nr←col movcom cr
                  S←{6::0 ⋄ ⍵.SALT_Data}ns⍎fn
                  :If ('.',fn)≢(-1+⍴fn)↑⍕new←ns.⎕FIX nr
                      ⎕←'*** Unable to refix space <',fn,'>'
                  :Else
                      mod[arg⍳⊂fn]←1 ⍝ note change
                      :If 0≢S ⋄ new.SALT_Data←S ⋄ :EndIf
                  :EndIf
              :EndIf
          :Else
              ⎕←'Comments in <',fn,'> cannot be aligned'
          :EndSelect
      :EndFor
      ⎕←(⍴arg)'objects processed,'(+/mod)'modified'
      mod←mod⌿arg
    ∇

    ∇ r←col movcom nr;b;b2;code;lamp;lines;lpos;new
     ⍝ Perform code alignment here. cr is a VTV (⎕NR result)
     ⍝ We allow 'col' to be a fraction representing a % of maximum width
      r←0                      ⍝ return 0 if no alignment performed
      :If col<1 ⋄ col←⌈0.5+|col×100⌊⌈/∊⍴¨nr ⋄ :EndIf
      :If ∨/b←∨/¨lamp←{(>⌿0 1⌽'⍝∇'∘.=⍵)∧=\''''≠⍵}¨nr ⍝ ignore ⍝∇ tags
         ⍝ Align only comments after code
          lpos←(b/lamp)⍳¨1 ⋄ b2←(lpos↑¨lines←b/nr)∨.≠¨' '
      :AndIf ∨/b2 ⋄ (lpos lines)←b2∘/¨lpos lines
         ⍝ Pad code with at least 1 space to align the comments
          code←(col⌈1+⍴¨code)↑¨code←rtb¨lpos↑¨lines
         ⍝ Add the ⍝, add a space and the comments
          new←code,¨'⍝ '∘,¨rlb¨(lpos+1)↓¨lines
      :AndIf new≢lines
          (b2/b/nr)←new
          r←nr
      :EndIf
    ∇

    cat1←{w←¯1↑(⍴⍺)⌈⍴⍵ ⋄ (w↑⍤1⊢⍺)⍪w↑⍤1⊢⍵}

    rtb←{rk←-⍴⍴b←' '=⍵ ⋄ (rk↑-⊥⍨∧⌿⍣(¯2∊rk)+b)↓⍵} ⍝ Remove Trailing Blanks
    rlb←{(+/∧\' '=⍵)↓⍵}        ⍝ Remove Leading  Blanks

    ∇ r←Test arg;t
     ⍝ test cmds + unit tests
      r←t≡sortlocals t←'a b c;d;e'
      r,←t≡sortlocals t←'a b c;d;⎕AV'
      r,←t≡sortlocals t←'a b c;d'
      r,←'a b c;d  '≡sortlocals'a b c;d;d'
      r,←'a b c;d;x'≡sortlocals t←'a b c;x;d'
      r,←'a b c;d;x⍝'≡sortlocals t←'a b c;x;d⍝'
      r,←'a b c;d;x  ⍝z'≡sortlocals t←'a b c;x;d  ⍝z'
      r,←'a b c;b;d;x        ⍝z'≡t←sortlocals'a b c;a;b;c;x;d;a  ⍝z'
      r,←'a b c  '≡t←sortlocals'a b c;a'
    ∇

:Endnamespace ⍝ WSutils  $Revision: 1793 $
