:Namespace arrayeditor ⍝ V2.00
⍝ 2015 05 21 Adam: NS header
⍝ 2015 06 01 Adam: Help auto PW
⍝ 2015 11 12 Adam: moved help layout to framework
⍝ 2017 03 07 Adam: specific help per platform and ⎕ML
⍝ 2017 07 11 Becca: add an example
⍝ 2017 07 20 Adam: auto cmd name
⍝ 2018 05 31 Adam: fallback to )ed
⍝ 2019 01 21 Adam: text tweak
⍝ 2025 02 17 Adam: Make equivalent to )ed ⋄foo

    ⎕IO←1 ⋄ ⎕ML←1
    aplan←20≤⊃⊃⌽'.'⎕VFI 2⊃#⎕WG'APLVersion'

    ∇ d←DESC
      :If aplan
          d←'Edit one or more arrays using array notation (if possible)'
      :ElseIf ⎕SE.SALTUtils.WIN
          :If 80=⎕DR''
              d←'Edit a simple or mixed array of enclosures using the Array Editor from davidliebtag.com'
          :Else
              d←'Edit a simple numeric array in a GUI editor'
          :EndIf
      :Else
          d←'Edit an array using the built-in editor ─ equivalent to )ED'
      :EndIf
    ∇

    ∇ r←List
      r←⎕NS ⍬
   ⍝ Name, group, short description and parsing rules
      r.(Name Group Desc)←'Edit' 'Array'DESC
      r.Parse←'1',aplan/'99S'
    ∇

    ∇ r←level Help Cmd
      r←⊂DESC
      r,←⊂'    ]',List.Group,'.',Cmd,' <arrayname','s>'↓⍨~aplan
      :If ~aplan
      :AndIf ⎕SE.SALTUtils.WIN
      :AndIf 80=⎕DR''
      :AndIf 3≠#.⎕ML
          r,←'' 'NOTE: ⎕ML is always 3 in the Array Editor'
      :EndIf
    ∇

    ∇ r←Run(Cmd Input);name
      :If aplan
          '⋄'##.THIS.⎕ED&Input.Arguments
      :Else
          name←(⍕##.THIS){⍵,⍨(~∨/'#⎕'∊1↑⍵)/⍺,'.'}1⊃Input.Arguments
          :Trap 0
              name ⎕SE.NumEd.numed 0
          :Else
              ⎕ED&name
          :EndTrap
      :EndIf
      r←0 0⍴0
    ∇

:EndNamespace
