﻿:Namespace caption ⍝ V2.09
⍝ Query or change window captions
⍝ 2015 10 27 Adam: Changed class name
⍝ 2015 11 12 Adam: moved help layout to framework
⍝ 2016 03 17 DanB: fixed case when not found
⍝ 2016 05 05 DanB: added SysTray for V15
⍝ 2017 09 06 Adam: dynamic help examples
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -??
⍝ 2018 05 01 Adam: add SVN tag
⍝ 2019 01 16 Adam: help

    :SECTION FUNCTIONS

    ∇ r←List
      →0↓⍨⍴r←⎕NS¨⎕SE.SALTUtils.WIN⍴⊂⍬
      r.Name←⊂'Caption'
      r.Group←⊂'MSWin'
      r.Desc←⊂DESC
      r.Parse←⊂'2SL'
    ∇

    ∇ r←level Help Cmd;l;kw;A;B;C
      r←⊂DESC
      r,←⊂'    ]',Cmd,' [<window> [<text>]]'
      r,←⊂''
      :Select level
      :Case 0
          r,←⊂']',Cmd,' -?? ⍝ for more information'
          r,←⊂']',Cmd,' -??? ⍝ for examples'
      :Case 1
          r,←⊂'<window>  target window. If omitted, all current values are listed. Possible values are:'
          l←⊢⊂'main Dyalog APL Session window'
          l,←⊂'Edit window'
          l,←⊂'Message Box when an object cannot be fixed'
          l,←⊂'The Workspace Explorer tool'
          l,←⊂'Dialog box when one or more objects cannot be re-instantiated upon loading a workspace'
          l,←⊂'Status window'
          l,←⊂'Refactor as Method/Field/Property window displayed by the Editor'
          l,←⊂'Event Viewer'
          l,←⊂'Find/Replace dialog box'
          l,←⊂'Exit dialog box that is displayed when the user closes the main session'
          l,←⊂'Find Objects tool'
          l,←⊂'System Tray'
          r,←⊢'         '∘,¨↓⍕windowValues,⍪l
          r,←⊂''
          r,←⊂'<text>    new caption for the specified window. If omitted, the current text is returned. Use "" to remove customisation. Possible values are:'
          kw←'{TITLE} {WSID} {NSID} {SNSID} {PRODUCT} {VER_A} {VER_B} {VER_C} {PID} {CHARS} {BITS} {XLOC}'
          l←⊢⊂'The official window name, e.g. "Rebuild Errors"'
          l,←⊂'Workspace ID (⎕WSID), e.g. "',⎕WSID,'"'
          l,←⊂'Current Namespace, e.g. "#.myns"'
          l,←⊂'Current Namespace (short version), e.g. (myns)'
          l,←⊂'The name of the Dyalog product, e.g. "Dyalog APL/',⎕SE.SALTUtils.((3⊃APLV),' - ',⍕BITS),'"'
          A B C←'.'(3↑≠⊆⊢)2⊃⎕SE.SALTUtils.APLV
          l,←⊂'The main version number, e.g. "',A,'"'
          l,←⊂'The secondary version number, e.g. "',B,'"'
          l,←⊂'The tertiary version number (currently the internal revision number), e.g. "',C,'"'
          l,←⊂'The process ID'
          l,←⊂'"Classic" or "Unicode"'
          l,←⊂'"32" or "64"'
          l,←⊂'The namespace currently being explored (Explorer only)'
          r,←⊢'         '∘,¨↓⍕(split kw),⍪l
          r,←⊂''
          r,←⊂']',Cmd,' -??? ⍝ for examples'
      :Else
     
          r,←'' 'Examples:'
          r,←⊢⊢⊢'    To change the Session title to "ABC":'('        ]',Cmd,' session ABC')
          r,←⊢⊢⊢'    To reset the Session title:'('        ]',Cmd,' session ""')
          r,←⊢⊢⊂'    To change the status window''s title to "What''s going on (XX)" and include the machine size (32/64):'
          r,←⊢⊢⊂'        ]',Cmd,' status "What''s going on ({BITS})"'
          r,←⊢⊢⊂'    To append version number to the default Session caption:'
          r,←⊢⊢⊂'        ]',Cmd,' session {WSID} {SNSID}- {PRODUCT} {VER_A}.{VER_B}'
          r,←⊂''
          r,←⊂']',Cmd,' -?? ⍝ for syntax details'
     
      :EndSelect
      r,←⊂''
      r,←⊂'WARNING:  This user command changes registry settings. This means that:'
      r,←⊂'          ∘  all instances of this Dyalog version on this machine are affected.'
      r,←⊂'          ∘  only users with administrator access can use this user command.'
    ∇

    ∇ r←Run(Cmd Input);key;window;str;nargs;index
      key←(1⊃4070⌶⍬),'\Captions'
      nargs←≢Input.Arguments
      r←windowValues,⍪{regGetString key ⍵}¨Windows
      :If nargs>0 ⍝ Quit if no args
          index←windowValues⍳⍬⍴Input.Arguments
          'Invalid window name'⎕SIGNAL 11/⍨index>≢windowValues
          r←2⊃index⌷r
      :AndIf nargs>1 ⍝ Quit if one arg
          (window str)←Input.Arguments
          :If 0=⍴str
              regDeleteValue key window
          :Else
              'Unbalanced {}s'⎕SIGNAL 11/⍨{(0∊¯1↑s)⍲∧/0 1∊⍨s←+\1 ¯1 0['{}'⍳⍵]}str
              regPutString key window str
          :EndIf
      :EndIf
     
    ∇

    ⍝ The following programs were modified from
    ⍝ Kai Jaeger ⋄ APL Team Ltd ⋄ http://aplteam.com
    ⍝ Homepage: http://aplwiki.com/WinReg

    ∇ regClose HANDLE;RegCloseKey
      ⎕NA'U ADVAPI32.dll.C32|RegCloseKey U'
      {}RegCloseKey HANDLE
    ∇

    HKCU←2147483649               ⍝ 'HKEY_CURRENT_USER' HEX 0x80000001
    FULL_ACCESS←983103            ⍝ HEX 0xF003F
    TrimHCU←'HKEY_CURRENT_USER\'∘{n←⍴⍺ ⋄ (n×⍺≡n↑⍵)↓⍵}

    ∇ HANDLE←regGetHandle KEY;T;Get
      T←'A*'[⎕IO+80∊⎕DR'']  ⍝ covers the case for Classic & Unicode versions
      'Get'⎕NA'I ADVAPI32.dll.C32|RegCreateKeyEx',T,' U <0T I <0T I I I >U >U'
      HANDLE←⊃2⊃Get HKCU(TrimHCU KEY)0 '' 0 FULL_ACCESS 0 0 0
    ∇

    ∇ regPutString(Path SUBKEY STRING);HANDLE;REG_SZ;set;T;uni
    ⍝ Stores the value of a Registry SUBKEY
      HANDLE←regGetHandle Path
      STRING←,STRING
      REG_SZ←1 ⍝ String data type
      T←'A*'[uni←1+80∊⎕DR'']
      'set'⎕NA'I ADVAPI32.dll.C32|RegSetValueEx',T,' U <0T I I <0T I4'
      {}set HANDLE SUBKEY 0 REG_SZ STRING(uni×1+⊃⍴STRING)
      regClose HANDLE
    ∇

    ∇ {r}←regDeleteValue(key value);handle;T;Open;Delete
     ⍝ Delete a value from the Windows Registry.
     ⍝ args are a key and a value name
     ⍝ This method normally returns either SUCCESS (0) or FILE_NOT_FOUND
     ⍝ in case the value did not exist from the start.
      T←'A*'[1+80∊⎕DR'']
      'Open'⎕NA'I ADVAPI32.dll.C32|RegOpenKeyEx',T,' U <0T I I >I'
      :If 0=⎕IO⊃,r←Open HKCU(TrimHCU key)0 FULL_ACCESS 1
          (r handle)←r
          'Delete'⎕NA'I ADVAPI32.dll.C32|RegDeleteValue',T,' U <0T[]'
          r←Delete handle value
          regClose handle
      :EndIf
    ∇

    ∇ r←regGetString(key value);handle;T;Open;rc;bufSize;Read;type
     ⍝ Read a value from the Windows Registry.
     ⍝ args are a key and a value name
      T←'A*'[1+80∊⎕DR''] ⋄ r←''
      'Open'⎕NA'I ADVAPI32.dll.C32|RegOpenKeyEx',T,' U <0T I I >I'
      :If 0=⎕IO⊃,rc←Open HKCU(TrimHCU key)0 FULL_ACCESS 1
          (r handle)←rc
          'Read'⎕NA'I ADVAPI32.dll.C32|RegQueryValueEx',T,' U <0T I =I >0T =I4'
          (rc type r bufSize)←Read handle value 0 1 1024 1024
          r/⍨←2≠rc
          regClose handle
      :EndIf
    ∇

    :ENDSECTION

    :SECTION CONSTANTS

    ⎕IO←1 ⋄ ⎕ML←1

    split←≠∘' '⊆⊢

    Windows←'Session Editor MessageBox Explorer Rebuild_Errors Status ReFactor Event_Viewer'
    Windows,←' FindReplace ExitDialog WSSearch SysTray'
    Windows←{b\⍵/⍨b←'_'≠⍵}¨split Windows

    windowString←'session editor messagebox explorer rebuild status refactor event findreplace exit wssearch systray'
    windowValues←split windowString

    DESC←'Query or change window captions'

    :ENDSECTION
:EndNamespace ⍝ caption  $Revision$
