:Namespace ChartWizard
:Using ,sharpplot.dll
:Using ,system.drawing.dll
:Using ,system.windows.forms.dll
⍝ :Using ,system.dll

    (⎕IO ⎕ML ⎕WX)←1 1 3
    Version←'0.56'















⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section Util_APL
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Namespace Util

        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        DEBUG←0                             ⍝ Development flag - ⎕SIGNAL instead of ⎕DQ'MsgBox'
        SMALLEST←5e¯324                     ⍝ Smallest number - considered not bearing information

        DYALOGMIN←'14.0'                ⍝ Minimum required Dyalog version
        DOTNETMIN←'2.0'                 ⍝ Minimum required .Net version
        SHARPPLOTMIN←'2.36'             ⍝ Minimum required SharpPlot version
        DYALOGVERSION←'0.0'             ⍝ Actual version - updated at run init time (Util.CheckVersions)
        DYALOGWIDTH←¯1                  ⍝ Width of CPU (32 or 64)
        DOTNETVERSION←'0.0'
        SHARPPLOTVERSION←'0.0'
        SHARPPLOT300←¯1                 ⍝ is SharpPlot ≥ v3.00 ? (cached for speed)
        SHARPPLOT350←¯1                 ⍝ is SharpPlot ≥ v3.50 ? (cached for speed)
        DYALOG150←¯1                    ⍝ is Dyalog ≥ v15.0 ? (cached for speed)
        DYALOG160←¯1                    ⍝ is Dyalog ≥ v16.0 ? (cached for speed)
        DYALOG170←¯1                    ⍝ is Dyalog ≥ v17.0 ? (cached for speed)

        ∇ (version width)←GetDyalogVersion
          version←'.'⎕WG'APLVersion'
          width←32+32×∨/'64'⍷1⊃version
          version←2⊃version
        ∇
        ∇ windows←IsWindows
          windows←'Windows'≡7↑⊃'.'⎕WG'APLVersion'
        ∇
        ∇ version←GetDotNetVersion;⎕USING;System
          ⎕USING←,','     ⍝ Ensure that System is present if at all possible
          ⍝ andys : I have found that running ChartWizard.Run twice not as a user command will throw an error because System, which is initialised when the namespace is fixed, is no longer present by the time you come to run this for a second time ..
          :Trap 0 ⋄ version←⍕System.Environment.Version
          :Else ⋄ version←'0.0' ⋄ :EndTrap
        ∇
        ∇ version←GetSharpPlotVersion
          :Trap 0 ⋄ version←(⎕NEW Causeway.SharpPlot).Version
          :Else ⋄ version←'0.0' ⋄ :EndTrap
        ∇
        ∇ version←GetWizardVersion
          version←##.Version
        ∇
        ∇ ok←required CompareVersions actual;okr;r;oka;a
          ((okr r)(oka a))←'.'⎕VFI¨required actual
          :If ok←∧/okr,oka  ⍝ both strings are 'N.N.N.N'
              ok←r{
                  0∊⍴⍵:0∧.=⍺ ⋄ 0∊⍴⍺:1
                  r a←⊃¨⍺ ⍵
                  r<a:1 ⋄ r>a:0
                  (1↓⍺)∇(1↓⍵)
              }a
          :EndIf
        ∇
        ∇ ok←CheckVersions                  ⍝ check versions before running
          :If ~ok←IsWindows
              ⎕←'Chart wizard available on Windows only'
              :Return
          :EndIf
          (DYALOGVERSION DYALOGWIDTH)←GetDyalogVersion
          DYALOG150←'15.0'CompareVersions DYALOGVERSION
          DYALOG160←'16.0'CompareVersions DYALOGVERSION
          DYALOG170←'17.0'CompareVersions DYALOGVERSION
          DOTNETVERSION←GetDotNetVersion
          SHARPPLOTVERSION←GetSharpPlotVersion
          SHARPPLOT300←'3.00'CompareVersions SHARPPLOTVERSION
          SHARPPLOT350←'3.50'CompareVersions SHARPPLOTVERSION
          :If ~ok←DYALOGMIN CompareVersions DYALOGVERSION
              Gui.Error'Dyalog v',DYALOGMIN,' is required.'
          :ElseIf ~ok←'3.'≢2↑DOTNETVERSION
              Gui.Error'.NetCore v3 not supported - .Net Framework v2 or v4 required'
          :ElseIf ~ok←DOTNETMIN CompareVersions DOTNETVERSION
              Gui.Error'.Net Framework v',DOTNETMIN,' is required.'
          :ElseIf ~ok←SHARPPLOTMIN CompareVersions SHARPPLOTVERSION
              Gui.Error'SharpPlot v',SHARPPLOTMIN,' is required.'
          :EndIf
          Gui.COORD←(1+DYALOG160)⊃'Pixel' 'ScaledPixel'  ⍝ not a good idea - we DO want the GUI scaled by the DPI
          Gui.DPI←Gui.GetDPI
        ∇

        Random←{⍺←⊢ ⋄ ⎕RL←0 ⋄ ⍺?⍵} ⍝ ⎕RL←+/10⊥10 10⍴⍎¨⎕D∩⍨∊⍕⎕AI,⎕TS,⎕TID
        DRIsText←∊∘82 80 160 320
        DRIsNum←∊∘11 83 163 323 645 1287 1289
        IsNum←{DRIsNum ⎕DR ⍵}
        IsNumScalar←{(DRIsNum ⎕DR ⍵)∧(⊃0=⍴⍴⍵)}
        IsNestedNum←{2≠|≡⍵:0 ⋄ ∧/DRIsNum∊⎕DR¨⍵}                          ⍝ all items are flat num (any rank)
        IsNumVectors←{2≠≡⍵:0 ⋄ 1∨.≠∊{⍴⍴⍵}¨⍵:0 ⋄ ∧/DRIsNum∊⎕DR¨⍵}          ⍝ all items are numeric vectors
        IsText←{DRIsText ⎕DR ⍵}
        IsNestedText←{2≠|≡⍵:0 ⋄ ∧/DRIsText∊⎕DR¨⍵}                         ⍝ all items are flat text (any rank)
        IsStrings←{2≠≡⍵:0 ⋄ 1∨.≠∊{⍴⍴⍵}¨⍵:0 ⋄ ∧/DRIsText∊⎕DR¨⍵}            ⍝!!! scalars are NOT strings :  0←IsStrings('hello' 'world' '!')
        IsNestedNestedText←{3≠|≡⍵:0 ⋄ ∧/DRIsText∊⎕DR¨¨⍵}
        IsNestedStrings←{3≠≡⍵:0 ⋄ 1∨.≠∊{⍴⍴⍵}¨⍵:0 ⋄ 1∨.≠∊{⍴⍴⍵}¨¨⍵:0 ⋄∧/DRIsText∊⎕DR¨¨⍵}    ⍝!!! scalars are NOT strings
        IsRef←{9=⌊|⎕NC,⊂,'⍵'}

        IsSorted←{⍵{(⍺≡⍵)∨(⍺≡⌽⍵)}{⍵[⍋⍵]}⍵}

        CRLF←⎕UCS 13 10                       ⍝ Windows (carriage return - line feed) newline substring
        ⍝NL←⎕UCS 10 11 12 13 133 8232 8233     ⍝ Unicode new line characters
        NestText←{('^.*$'⎕S'%')⍵}               ⍝ turn string with newlines into nested strings
        UnNestText←{0∊⍴⍵:''⋄ 1≥|≡⍵:,⍵ ⋄ (-⍴CRLF)↓∊⍵,¨⊂CRLF}  ⍝ turn nested strings into string with windows newlines
        CutText←{(txt open close)←⍵ ⋄ n←⍴open ⋄ (0<+\((n⍴0),(-n)↓open⍷txt)-(close⍷txt))/txt}
        CutNestedText←{(txt open close)←⍵ ⋄ mat←↑txt ⋄ (0<+\(0,¯1↓∨/open⍷mat)-(∨/close⍷mat))/txt}
        GrepNestedText←{(∨/kwd⍷↑⍵)/⍵}
        UnGrepNestedText←{(~∨/kwd⍷↑⍵)/⍵}
        RemoveBlanks←{⌽{(∨\' '≠⍵)/⍵}⌽{(∨\' '≠⍵)/⍵}⍵}      ⍝ remove leading and trailing blanks
        Contains←{{~0∊⍴⍵}¨(⍵ ⎕S 0⎕OPT'IC' 1)¨⍺}              ⍝ 1 for each ⍺ that contains one of ⍵ - case-insensitive

          Display←{
              ⎕IO ⎕ML←0                                   ⍝ Boxed display of array.
              tl tr bl br vt hz←'┌┐└┘│─'                  ⍝ Top left, top right, ...
              box←{                                       ⍝ Box with type and axes.
                  vrt hrz←(¯1+⍴⍵)⍴¨vt hz                  ⍝ Vert. and horiz. lines.
                  top←(hz,'⊖→')[¯1↑⍺],hrz                 ⍝ Upper border with axis.
                  bot←(⊃⍺),hrz                            ⍝ Lower border with type.
                  rgt←tr,vt,vrt,br                        ⍝ Right side with corners.
                  lax←(vt,'⌽↓')[¯1↓1↓⍺],¨⊂vrt             ⍝ Left side(s) with axes,
                  lft←⍉tl,(↑lax),bl                       ⍝ ... and corners.
                  lft,(top⍪⍵⍪bot),rgt                     ⍝ Fully boxed array.
              }
              deco←{⍺←type open ⍵ ⋄ ⍺,axes ⍵}             ⍝ Type and axes vector.
              axes←{(-2⌈⍴⍴⍵)↑1+×⍴⍵}                       ⍝ Array axis types.
              open←{(1⌈⍴⍵)⍴⍵}                             ⍝ Expose null axes.
              trim←{(~1 1⍷∧⌿⍵=' ')/⍵}                     ⍝ Remove extra blank cols.
              type←{{(1=⍴⍵)⊃'+'⍵}∪,char¨⍵}                ⍝ Simple array type.
              char←{⍬≡⍴⍵:hz ⋄ (⊃⍵∊'¯',⎕D)⊃'#~'}∘⍕         ⍝ Simple scalar type.
              line←{(6≠10|⎕DR' '⍵)⊃' -'}                  ⍝ underline for atom.
              {                                           ⍝ Recursively box arrays:
                  0=≡⍵:' '⍪(open ⎕FMT ⍵)⍪line ⍵           ⍝ Simple scalar.
                  1 ⍬≡(≡⍵)(⍴⍵):'∇' 0 0 box ⎕FMT ⍵         ⍝ Object rep: ⎕OR.
                  1=≡⍵:(deco ⍵)box open ⎕FMT open ⍵       ⍝ Simple array.
                  ('∊'deco ⍵)box trim ⎕FMT ∇¨open ⍵       ⍝ Nested array.
              }⍵
          }

        GetFlags←{0≡⍵:32⍴0 ⋄ (32⍴2)⊤⍵.value__}
        SetFlags←{⍵∧.=0:0 ⋄ ⍺≡0:Gui.Error'Bad Flags' ⋄ r←CopyEnum ⍺ ⋄ r.value__←⌊.5+2⊥⍵ ⋄ r}           ⍝ must be careful that ⍺≢0 if ⍵≢0  ⍝!!! Bug : doesn't work without ⌊.5+
        CopyEnum←{0≡⍵:Gui.Error 'Bad Flags' ⋄ ¯1 0 ##.Util.Exec ##.Util.Source ⍵}     ⍝ deep copy
        ∇ yes←∆enum1 HasFlags ∆enum2                      ⍝ Equivalent to System.Enum.HasFlag, but dyadic
          yes←∧/(GetFlags ∆enum2)/(GetFlags ∆enum1)
        ∇
        ∇ ∆enum←∆enum1 DisableFlags ∆enum2                ⍝ ⍺∧~⍵
          :If ∆enum1≡0 ⋄ ∆enum←0 ⋄ :Return ⋄ :EndIf
          ∆enum←∆enum1 SetFlags(GetFlags ∆enum1)∧~(GetFlags ∆enum2)
        ∇
        ∇ ∆enum←∆enum1 AndFlags ∆enum2                    ⍝ ⍺∧⍵
          :If ∆enum1≡0 ⋄ ∆enum←0 ⋄ :Return ⋄ :EndIf
          ∆enum←∆enum1 SetFlags(GetFlags ∆enum1)∧(GetFlags ∆enum2)
        ∇
        ∇ ∆enums←∆styles GetStyles styles;allstyles;deep       ⍝ from namespace ∆styles, get styles that exist
          allstyles←∆styles.⎕NL ¯2
          :If 0∊⍴styles ⋄ styles←allstyles ⋄ :EndIf
          :If 1≥≡styles ⋄ styles←,⊂,styles ⋄ :EndIf
          :If 2≥≡styles ⋄ styles←,⊂,styles ⋄ :EndIf            ⍝ works with lists of lists (for Style CustomControl)
          ⍝:If ~0∊⍴ignored←styles~¨⊂allstyles ⋄ Gui.Debug'Unexpected styles : ',(⍕∆styles),'.(',(⍕ignored),')' ⋄ :EndIf  ⍝!!! sliently ignore inexistant styles
          styles←styles∩¨⊂allstyles                 ⍝ list of lists of style instances
          styles←({~0∊⍴⍵}¨styles)/styles            ⍝ remove empty rows
          ∆enums←∆styles∘⍎¨¨styles
        ∇


        ∇ id←ids NextId prefix;numbers;suffixes;nums
          ⍝ :If ~(⊂id)∊ids ⋄ :Return ⋄ :EndIf           ⍝ id is okay
          ⍝ prefix←(~⌽∧\⌽id∊⎕D)/id                      ⍝ id prefix
          ids/⍨←prefix∘{(⍺≡(⌊/⊃∘⍴¨⍺ ⍵)↑⍵)}¨ids        ⍝ ids matching prefix
          suffixes←(⍴prefix)∘↓¨ids                    ⍝ suffixes
          suffixes/⍨←{∧/⍵∊⎕D}¨suffixes                ⍝ numeric suffixes
          :If 0∊⍴suffixes
              id←prefix,'1'                           ⍝ no used id yet, take first
          :Else
              nums←⊃(//)⎕VFI∊suffixes,[1.5]' '        ⍝ used numbers
              id←prefix,⍕1+⌈/0,nums                   ⍝ get next available number
          :EndIf
        ∇
        ∇ {id}←PutRef(∆obj ∆ns prefix);ids
          id←((⊃prefix)∆ns.⎕NL ¯9)NextId prefix
          {}id ∆ns.{⍎⍺,'←⍵'}∆obj
        ∇
        ∇ stack←GetStackItems;si;stack                ⍝ for debug purpose
          ⍝where←{0::⍕⍵ ⋄ (⍕⍵),⍕⎕CLASS ⍵}¨⎕RSI
          si←(¯1↓⎕NSI){⍵,'@',⍺}¨1↓⎕XSI{⍺,'[',(⍕⍵),']'}¨⎕LC
          stack←1↓⎕STACK[;2]
          ((' '=⊃¨stack)/stack)←si
        ∇
        ∇ path←GetDyalogPath                          ⍝ Dyalog installation directory
          path←2 ⎕NQ'.' 'GetEnvironment' 'DYALOG'
          :If '\'≠⊃⌽path ⍝ :If '15.0'CompareVersions ⊃GetDyalogVersion  ⍝ avoid cached version
              path,←'\'
          :EndIf
        ∇
        ∇ path←GetSpicePath                           ⍝ Spice directory
          path←⎕SE.UCMD']settings cmddir'
        ∇


        ⍝⍝⍝⍝⍝ Array source generation ⍝⍝⍝⍝⍝
        FmtError←{##.Gui.Error 'Expression Formatting: ',,⍕⍵}
          FmtShape←{  ⍝ prepend shape (⍺) to expression (⍵) only when necessary
              ⍺≡,1:',',⍵ ⋄ (1<⍴⍺):(⍕⍺),'⍴',⍵ ⋄ ⍵       ⍝!!! ⍺≡,0 is okay because we don't handle prototypes
          }
          FmtArray←{  ⍝ Format any array
              size←×/shape←⍴⍵ ⋄ empty←0=size ⋄ long←1<size ⋄ deep←1<|≡⍵
              empty∧##.Util.IsText ⍵:shape FmtShape''''''
              empty:shape FmtShape,'⍬'                  ⍝!!! do not handle prototypes
              deep∧long:shape FmtShape ¯1↓∊{'(',⍵,') '}∘∇¨,⍵
              deep:shape FmtShape'⊂',∇⊃⍵
              shape FmtShape FmtSimple,⍵
          }
          FmtSimple←{  ⍝ simple ←→ 1≥|≡⍵
              ⎕PP←34
              ##.Util.IsText ⍵:'''',((1+⍵='''')/,⍵),''''
              ##.Util.IsNum ⍵:⍕,⍵
              exprs←FmtObject¨⍵
              items←{1↓¨{((∧\⍵≠'(')∧(⍵='.'))⊂⍵}'.',⍵}¨exprs        ⍝ cut expressions at dots, not pervading into brackets
              depths←⊃∘⍴¨items ⋄ share←(1<⍴items)∧(1=⍴∪depths)∧(depths∧.>1)
              ~share:¯1↓∊exprs,¨' '                    ⍝ obviously not sharing parent
              mask←0,⍨¯1↓∧\{∧/1=⍴∪⍵}¨↓⍉↑items          ⍝ mask of shared parent - PS items is rectangular
              items←items,¨¨'.'                        ⍝ dot everything
              parent←∊mask/⊃items                      ⍝ parent (with dot)
              items←¯1↓∊{' ',⍨¯1↓∊(~mask)/⍵}¨items     ⍝ items within parent
              parent,'(',items,')'                     ⍝ nicely parenthesised expression
          }
          FmtObject←{   ⍝ Format scalar array, possibly object - resulting expression must be parenthesised if needed
              ⎕PP←34
              0≢≡⍵:FmtError'Internal error'
              ##.Util.IsNum ⍵:,⍕⍵
              ##.Util.IsText ⍵:'''',((1+⍵='''')/⍵),''''
              type←{0::FmtError'Cannot format non-.Net objects' ⋄ ⍕⍵.GetType}⍵
              'System.'≡7↑type:type FmtSystem ⍵
              'Causeway.'≡9↑type:type FmtCauseway ⍵
              FmtError'Unknown object type'
          }
          FmtCauseway←{  ⍝ Format Causeway Objects
              'Zone'≡stype←9↓⍺:⍺ FmtZone ⍵
              'Styles'≡¯6↑stype:⍺ FmtFlags ⍵
              (⊂stype)∊⊂'ResetOptions':⍺ FmtFlags ⍵
              (⊂stype)∊'FillStyle' 'LineStyle' 'Marker':⍺ FmtStruct ⍵
              (⊂stype)∊'GroupByFunction' 'ChartType' 'ScriptTarget' 'SvgMode':⍺ FmtEnum ⍵
              FmtError'Unknown object type'
          }
          FmtZone←{      ⍝ Format Causeway.Zone
              args←⍵.(GetStartValue GetStopValue GetRegionColor GetRegionPattern GetRegionStyle)
              '(⎕NEW ',⍺,' (',(FmtArray args),'))'
          }
          FmtFlags←{     ⍝ Format [flag] enum
              0=⍵.value__:,'0'
              desc←(⍕⍵)~' '
              ~∨/mask←desc=',':⍺,'.',desc    ⍝ only one flag
              (mask/desc)←'+'
              ⍺,'.(',desc,')'                ⍝ sum of flags
          }
          FmtStruct←{    ⍝ Format named structure
              desc←{({(~⍵)∧≠\⍵}⍵∊'[]')/⍵}⍕⍵  ⍝ pick what's within '[]'
              name←{1↓(∨\⍵∊'=,')/⍵}desc      ⍝ pick what's after '=' or ','
              0∊⍴name:FmtError'Internal error'
              'Custom'≢6↑name:⍺,'.',name     ⍝ ⍺ is type
              stype←9↓⍺ ⋄ val←7↓name
              '*'=1↑val:FmtError'Cannot deal with custom structures'
              stype≡'Marker':'(⎕NEW ',⍺,' ''',val,''')'
              stype≡'FillStyle':'(⎕NEW ',⍺,' ''',val,''')'
              stype≡'LineStyle':'(⎕NEW ',⍺,' (⊂,',val,'))'
              FmtError'Unknown object type'
          }
          FmtEnum←{      ⍝ Format Enumeration
              ⍺,'.',⍕⍵
          }
          FmtSystem←{    ⍝ Format System Objects
              stype←7↓⍺
              'IntPtr'≡stype:⍺,'(',(⍕⍵),')'
              ~'Drawing.'≡8↑stype:FmtError'Unknown object type'
              stype←8↓stype
              'Color'≡stype:FmtColor ⍵
              'FontStyle'≡stype:⍺ FmtEnum ⍵
              (⊂stype)∊'Imaging.PixelFormat' 'Imaging.ImageFormat':⍺ FmtEnum ⍵
               ⍝ TODO : (⊂stype)∊'Image' 'Bitmap' 'Brush' 'TextureBrush' 'Imaging.Metafile':⍕⍵
              FmtError'Unknown object type'
          }
          FmtColor←{     ⍝ Format System.Drawing.Color
              ⍵.IsNamedColor:'System.Drawing.Color.',⍵.Name
              'System.Drawing.Color.(FromArgb ',(⍕256 256 256 256⊤⍵.ToArgb),')'
          }
        ∇ expr←Source array
          expr←FmtArray array  ⍝ should always return a text vector
        ∇
        ∇ expr←StripSource expr                 ⍝ expressions generated by PopupExpression maybe unexecutable because of this
          expr←expr~PopupExpression.SEPARATOR
        ∇
        EmptySource←,'⍬'
        ∇ empty←IsEmptySource expr
          expr~←' ',PopupExpression.SEPARATOR  ⍝!!! nasty global
          empty←(0∊⍴expr)∨(expr≡EmptySource)
        ∇
        ∇ values←opt Exec exprs;msg;values;∆ns;errmode;nsmode
          (errmode nsmode)←opt
          :Select nsmode
          :Case 0 ⋄ ∆ns←⎕NS''                          ⍝ use an empty sandbox if evaluating a source that is not an arbitrary expression
          :Case 1 ⋄ ∆ns←Main.GetExecNamespace⊃⎕RSI     ⍝ caller is a children of a Main, which knows where to run the expression (the namespace from which the wizard was launched)
          :Case ¯1 ⋄ ∆ns←Main.GetExecNamespace 1↓⎕RSI  ⍝ caller is not a children of a Main, but one of his callers is
          :Else ⋄ ##.Gui.Error'Misuse of Util.Exec'
          :EndSelect
          (msg values)←∆ns''Run exprs ⍝ run in namespace from which ChartWizard was started
          :Select errmode×~0∊⍴msg
          :Case 0                         ⍝ no error - or mode=0 to silently ignore them
          :Case 1 ⋄ ##.Gui.APLInfo msg    ⍝ politely inform user if something went wrong
          :Case ¯1 ⋄ ##.Gui.Error msg     ⍝ internal design error if expression errored
          :Else ⋄ ##.Gui.Error'Misuse of Util.Exec'
          :EndSelect
        ∇
        SWEARWORDS←'⎕OFF' '⎕CLEAR' '⎕LOAD' '⎕SAVE' '⎕CMD' '⎕SH'  ⍝ avoid the wildest beasts of our language just in case some string got patched wrong
        ∇ (msg values)←opt Run exprs;using;∆ns;nc;msg;shallow;value;expr;∆sharpplot;shadow     ⍝ execute expression, :Using same namespaces as this class
        ⍝ if 0∊⍴msg : values match exprs
        ⍝ if ~0∊⍴msg : values is failing expr, errmsg is error message
          (∆ns shadow)←opt
          :If shallow←1≥|≡exprs ⋄ exprs←,⊂,exprs ⋄ :EndIf         ⍝ allow a single expression
          using←∆ns.⎕USING ⋄ ∆ns.⎕USING←∪using,⎕THIS.##.⎕USING    ⍝ add our ⎕USING
          :If ~0∊⍴shadow ⋄ ∆ns.⎕SHADOW shadow ⋄ :EndIf         ⍝ names to shadow in execution space - we're running a script building those names
          values←⍬
          :For expr :In exprs
              msg←'' ⋄ value←⍬
              :If (⊂expr)Contains SWEARWORDS
                  msg←'APL expression: 'expr'tried to execute one of these functions:'(⍕SWEARWORDS)
              :Else
                  :Trap 0
                      ⎕EX'value'  ⍝ value may change nameclass
                      value←∆ns⍎expr  ⍝!!! fixup mantis 9728
                      :Select ⌊|nc←⊃⎕NC⊂'value'
                      :CaseList 2 9   ⍝ array or ref : ok
                      :Case 0 ⋄ value←⍬   ⍝!!! cannot happen, sadly (cf Mantis 9728)
                      :Else           ⍝ can't do anthing about it
                          msg←'APL expression: 'expr('produced an object of name class ',⍕nc)
                          ⎕EX'value' ⋄ value←⍬  ⍝ ⎕EX because nameclass has changed
                      :EndSelect
                  :Case 6
                      :If (22=⎕DMX.ENX)∧(0≠⎕NC'shadow')⍝∧('⍎'≢⊃⊃⎕DM)    ⍝!!! No result was provided when the context expected one ⍝!!! fix up mantis 9728
                          value←⍬                      ⍝ when running a script, pretend that successful non-returning expression sucessfully returned ⍬
                      :Else
                          msg←'APL expression:'expr'produced the following error: '⎕DMX.(⍕EM,((~0∊⍴Message)/': '),Message)
                      :EndIf
                  :Case 90
                      msg←'APL expression:'expr'produced the following .Net exception:',NestText⍕⎕EXCEPTION
                  :Else
                      msg←'APL expression:'expr'produced the following error:'⎕DMX.(⍕EM,((~0∊⍴Message)/': '),Message)
                  :EndTrap
              :EndIf
              :If ~0∊⍴msg ⋄ :Leave
              :Else ⋄ values,←⊂value
              :EndIf
          :EndFor
          :If ~0∊⍴msg ⋄ values←⍬ ⍝ values←expr    ⍝ in case of error return failing expression instead of values
          :ElseIf ~0∊⍴shadow ⋄ values←∆ns{1≥|≡⍵:⍺⍎⍵ ⋄ ⍺∘⍎¨⍵}shadow ⍝ we don't care about values, we really want the values of the shadowed names
          :ElseIf shallow ⋄ values←⊃values  ⍝ disclose value for single expression
          :EndIf
          ∆ns.⎕USING←using          ⍝ restore ⎕USING
        ∇

        ∇ tie←FileTie(file write dcf);TIE;CREATE;UNTIE;ERASE
          ⍝ write←0 : open if exists
          ⍝ write←1 : open or create
          ⍝ write←2 : create, or ask overwrite confirmation before opening
          ⍝ write←3 : create, or ask overwrite confirmation before erasing and creating
          ⍝ write←4 : create, or erase and create without asking
          :If dcf
              TIE←⎕FTIE ⋄ CREATE←⎕FCREATE ⋄ UNTIE←⎕FUNTIE
              ERASE←file∘{_←⍺ ⎕FERASE ⍵ ⋄ ⍺ ⎕FCREATE ⍵}
          :Else
              TIE←⎕NTIE ⋄ CREATE←⎕NCREATE ⋄ UNTIE←⎕NUNTIE ⋄ ERASE←0∘⎕NRESIZE
          :EndIf
          :Trap 0 ⋄ tie←file TIE tie←0                ⍝ try to open it
          :Case 22                                    ⍝ file does not exist
              :If (write≤0)                           ⍝ not ok if we want to read it
                  1 Gui.Info'"',file,'" does not exist.' ⋄ tie←0 ⋄ :Return
              :EndIf
              :Trap 0 ⋄ tie←file CREATE 0 ⋄ :Else     ⍝ writing to it, so try to create it
                  tie←0 ⋄ Gui.Info'Cannot create "',file,'".' ⋄ tie←0 ⋄ :Return
              :EndTrap
              :Return                                 ⍝ file was successfully created
          :Else ⋄ 1 Gui.Info'Cannot access "',file,'".' ⋄ tie←0 ⋄ :Return
          :EndTrap                                    ⍝ file successfully tied
          :If (1<write)∧(write<4) ⋄ :AndIf ~Gui.YesNo'Do you want to overwrite "',file,'"?'
              UNTIE tie ⋄ tie←0 ⋄ :Return
          :EndIf
          :If (3≤write)
              :Trap 0 ⋄ tie←ERASE tie
              :Else ⋄ 1 Gui.Info'Cannot access "',file,'".' ⋄ UNTIE tie ⋄ tie←0  ⍝ ⎕EN=19 for true access error
              :EndTrap
          :EndIf
        ∇

    :EndNamespace
    :EndSection



⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section Util_GUI
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Namespace Gui
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        STDH←22   ⍝ standard height in pixels
        STDW←70   ⍝ standard width
        SPACE←5   ⍝ spacing between GUI items
        BCOL←¯16  ⍝ background color
        COL_ADD←160 255 160
        COL_REMOVE←255 160 160
        COL_MOVE←128 192 255
        COL_EXPRESSION←255 255 160
        MAXSIZE←32000   ⍝!!! Dyalog cannot handle sizes above that (strange values above 32000, DOMAIN ERROR above 32765)
        COORD←'Invalid' ⍝ Util.CheckVersions will cache this
        DPI←0           ⍝ Util.CheckVersions will cache this - assume interpreter requires a restart between DPI changes (in fact an OS reboot is required)

        ⍝ without callbacks
        ⍝ http://pinvoke.net/default.aspx/gdi32/GetDeviceCaps.html
        HORZSIZE←4      ⍝ Width, in millimeters, of the physical screen.
        VERTSIZE←6      ⍝ Height, in millimeters, of the physical screen.
        HORZRES←8       ⍝ Width, in pixels, of the screen
        VERTRES←10      ⍝ Height, in raster lines, of the screen
        LOGPIXELSX←88   ⍝ Number of pixels per logical inch along the screen width
        LOGPIXELSY←90   ⍝ Number of pixels per logical inch along the screen height
        DESKTOPVERTRES←117 ⍝ ???
        DESKTOPHORZRES←118 ⍝ ???
        ∇ dpi←GetDPI;desktop;⎕FR;GetDC;GetDeviceCaps;ReleaseDC
              ⍝:If 0=⎕NC'GetDC'
              ⎕NA'P user32.dll|GetDC P'
              ⎕NA'I4 gdi32.dll|GetDeviceCaps P I4'
              ⎕NA'I4 user32.dll|ReleaseDC P P'
              ⍝:EndIf
              :If Util.DYALOGWIDTH>32 ⋄ ⎕FR←1287 ⋄ :EndIf  ⍝ required to move pointer around
              desktop←GetDC 0  ⍝ Scale to DPI setting
              dpi←(GetDeviceCaps desktop DESKTOPHORZRES)(GetDeviceCaps desktop DESKTOPVERTRES) ⍝ true screen size in pixels
              dpi÷←(GetDeviceCaps desktop HORZRES)(GetDeviceCaps desktop VERTRES)              ⍝ ≥v16.0 : true screen size in pixels ⋄ <v16.0 : virtual size relative to the logical DPI (<v16.0:
              dpi÷←96÷(GetDeviceCaps desktop LOGPIXELSX)(GetDeviceCaps desktop LOGPIXELSY)     ⍝ ≥v16.0 : true DPI setting (relative to 96) ⋄ <v16.0: always 96
              {}ReleaseDC 0 desktop
        ∇

        ∇ (h w)←GetScreenSize;coord
          ⍝ coord←'.'⎕WS'Coord'COORD ⋄ (h w)←'.'⎕WG'Size' ⋄ '.'⎕WS'Coord'coord  ⍝!!! Fails because of Mantis 15534
          coord←'.'⎕WS'Coord' 'Pixel' ⋄ (h w)←'.'⎕WG'Size' ⋄ '.'⎕WS'Coord'coord
          :If Util.DYALOG160 ⋄ (h w)÷←DPI ⋄ :EndIf
        ∇
        SetSize←{⍺.Size←⍵}     ⍝ ∆obj SetSize (h w)
        GetSize←{⍵.Size}                 ⍝ (h w)←GetSize ∆obj
        SetPosn←{⍺.Posn←⍵}               ⍝ ∆obj SetPosn (y x)
        GetPosn←{⍵.Posn}                 ⍝ (y x)←GetPosn ∆obj
        SetRect←{⍺.(Posn Size)←(2↑⍵)(¯2↑⍵)}   ⍝ ∆obj SetRect (y x h w)
        GetRect←{⍵.(Posn,Size)}          ⍝ (y x h w)←GetRect ∆obj

        IsRoot←{⍵≡⍵.##}  ⍝ fails on ⎕NULL
        IsParent←{0::0 ⋄ (⊂⍵⎕WG'Type')∊'Form' 'SubForm' 'Group'}                 ⍝ something that may have reconfigurable children
        IsParentOf←{p←⍵.## ⋄ p≡⍺:1 ⋄ p≡⍵:0 ⋄ ⍺ ∇ p} ⍝ { parent ⋄ ⍺ is parent ⋄ ⍵ is root ⋄ try with next parent }
        GetParentForm←{0::⎕NULL ⋄ IsRoot ⍵:⎕NULL ⋄ (⍵⎕WG'Type')≡'Form':⍵ ⋄ ∇ ⍵.##}                ⍝ parent form
        ⍝GetFormParent←{0::⎕NULL ⋄ (⊂⍵⎕WG'Type')∊'Form' 'SubForm' 'Root' 'Session':⍵ ⋄ ∇ ⍵.##} ⍝ first parent where I can build a form
        ⍝GetFormParent←{⎕THIS.##}   ⍝ Parent for new forms is the ChartWizard namespace, because we need to ensure ⎕WX←3 there
        GetDQParent←{0::⎕NULL ⋄ (⊂⍵⎕WG'Type')∊'Form' 'Root' 'Session':⍵ ⋄ ∇ ⍵.##} ⍝ something to ⎕DQ on

        ∇ Close ∆obj  ⍝ silently fail
          :If ∆obj≡⎕NULL ⋄ :Return ⋄ :EndIf
          :Select ⌊|∆obj.⎕NC⊂'Close'
          :Case 8 ⋄ 1 ⎕NQ ∆obj'Close'    ⍝ event
          :Case 3 ⋄ ∆obj.Close           ⍝ method
          :Else ⍝ Error'Cannot close ',⍕∆obj
          :EndSelect
        ∇
        ∇ ∆obj Redraw redraw;∆form
          ∆form←GetParentForm ∆obj
          ⍝ Debug 'Redraw : '∆form.Redraw'→'redraw'( Visible ='∆form.Visible')'∆form ∆obj
          ⍝ :If redraw>0
          ⍝    :If ∆form.Visible  ⍝ enabling redraw when not visible may pop form up ?  ⍝!!! fixed in Mantis 13606 and 13738
          ∆form.Redraw←redraw
          ⍝    :EndIf
          ⍝ :Else
          ⍝    ∆form.Redraw←0
          ⍝ :EndIf
        ∇
        ∇ {unminimise}Focus ∆obj         ⍝ get focus to target object
          :If 0=⎕NC'unminimise' ⋄ unminimise←0 ⋄ :EndIf
          :If unminimise ⋄ :AndIf 1=∆obj.State ⋄ ∆obj.State←0 ⋄ :EndIf
          1 ⎕NQ ∆obj'GotFocus'∆obj
        ∇

        ∇ EmptyQueue ∆obj;∆parent;dq
          ∆obj ⎕WS'Event' 1234 1                      ⍝!!! Event numbers should be global
          0 ⎕NQ ∆obj 1234
          :If ~0∊⍴dq←⎕DQ GetDQParent ∆obj   ⍝!!! this make the parent form pop up
          :AndIf 1234≢2⊃dq
              ##.Gui.Error'Gui EmptyQueue function is broken: ',⍕dq
          :EndIf
        ∇

        ∇ ∆obj Configure(y x h w);sink;autoconf;mask;wait;r;dq
          (y x h w)←∆obj.(Posn,Size){⍵≥0:⍵ ⋄ ⍺}¨(y x h w)    ⍝ Negative values mean keep default
          sink←1 ⎕NQ ∆obj'Configure'y x h w                  ⍝ Allow object to handle resize
          :If IsParent ∆obj ⋄ EmptyQueue ∆obj ⋄ :EndIf       ⍝ prevent further GUI configuration before all processing of this one is done
          ⍝ The following take 0.26 s instead of 1.20s, but doesn't work for some reason
          ⍝ 0 ⎕NQ ∆obj 'Configure' y x h w                   ⍝ add configure event to the queue
          ⍝ ∆obj.(Posn Size)←(y x)(h w)                      ⍝ force new values
        ∇

        Attach←{⍺.Attach←⍵}                    ⍝ ∆obj Attach (t l b r)
        Move←{⍺ Configure ⍵,¯1 ¯1}             ⍝ ∆obj Move (y x)
        Nudge←{⍺ Move ⍵+GetPosn ⍺}             ⍝ ∆obj Nudge (h w)
        Resize←{⍺ Configure ¯1 ¯1,⍵}           ⍝ ∆obj Resize (h w)
        Reconfigure←{⍵ Configure ¯1 ¯1 ¯1 ¯1}  ⍝ Reconfigure ∆obj

        ∇ ∆obj Limit prop;max;size   ⍝ limit size to a share of the screen
          max←(2⍴prop)×GetScreenSize
          :If max∨.<size←GetSize ∆obj
              ∆obj Resize max⌊size
          :EndIf
        ∇
        ∇ ∆obj SetFont(apl fixed);CreateFont;GetFontName;SetFont
          :If Util.DYALOG160  ⍝ instanciate font object
              SetFont←{⍺.FontObj←⍺.∆font←⍺.⎕NEW'Font'(('PName'(1⊃⍵))('Size'(2⊃⍵))('Coord'COORD))}
              GetFontName←{⍵.FontObj.PName}
          :Else  ⍝ use font definition as FontObj - pre-v16.0 don't have Font.Coord     ⍝!!! also Mantis 15536 makes it dodgy
              SetFont←{⍺.FontObj←⍵}
              GetFontName←{⊃⍵.FontObj}
          :EndIf
          :If fixed
              ∆obj SetFont'APL385 Unicode' 15
          :ElseIf apl
              ∆obj SetFont'APL333' 18
              :If 'APL333'≢GetFontName ∆obj   ⍝ in case APL333 is not available
                  ∆obj SetFont'APL385 Unicode' 15
              :EndIf
          :Else
               ⍝ ∆obj SetFont'MS Sans Serif' 9  ⍝!!! Mantis 15535
          :EndIf
           ⍝Debug 'SetFont:'apl fixed (⍕∆obj)({'Inherit'≡⍵.Coord:∇ ⍵.## ⋄ ⍵.Coord}∆obj)(GetFontName ∆obj)
        ∇


        ∇ {ok}←∆objs LayoutGrid(yg xg ya xa resize);c;r;fixed;valid;oh;ow;ph;pw;mask;y;x;h;w;t;b;l;∆parent;yg;xg
          :Access Public Shared
          ⍝ Very cool tool to position, size and attach a matrix of objects within a grid layout in their parent.
          ⍝ - ∆objs is a matrix of object references that should all have the same parent,
          ⍝   except for ⎕NULL which means there is no object for the corresponding cell in the grid.
          ⍝   if ∆objs is scalar or vector, it is interpreter as a 1-row matrix.
          ⍝ - yg and xg are vectors of gaps (separator space) around cells of the grid. We should have ((⍴yg),(⍴xg)) ←→ (1+⍴objs)
          ⍝   They may be scalars, if the space is the same for all.
          ⍝ - ya and xa are matrices of (¯1 0 1) that define which border of the parent, objects are attached to.
          ⍝   ¯1 means Top or Left, 1 means Bottom or Right, 0 means object will be attached to both sides (stretched).
          ⍝   They may also be scalars applying too all objects, or vectors, applying to rows and columns, in which case ((⍴ya),(⍴xa)) ←→ (⍴objs)
          ⍝   Obviously, there should be no more than one 0 per row and column, and value should be ascending.
          ⍝ - resize is a boolean matrix telling whether objects are resized to fill their cell size.
          ⍝   Where resize=0, objects will keep their original sizes
          ⍝   It may be scalar, in which case the value is used for all objects.
          ∆objs←(¯2↑1 1,⍴∆objs)⍴∆objs
          (r c)←⍴∆objs ⋄ ok←1
          :If 0=⍴⍴yg ⋄ yg←(1+r)⍴yg ⋄ :EndIf
          :If 0=⍴⍴xg ⋄ xg←(1+c)⍴xg ⋄ :EndIf
          :If (1+r c)≢(⍴yg),(⍴xg) ⋄ ok←0 ⋄ :EndIf
          :If 0=⍴⍴ya ⋄ ya←r⍴ya ⋄ :EndIf
          :If 1=⍴⍴ya ⋄ :If r≠⍴ya ⋄ ok←0 ⋄ :EndIf ⋄ ya←r c⍴c/ya ⋄ :EndIf
          :If 0=⍴⍴xa ⋄ xa←c⍴xa ⋄ :EndIf
          :If 1=⍴⍴xa ⋄ :If c≠⍴xa ⋄ ok←0 ⋄ :EndIf ⋄ xa←r c⍴xa ⋄ :EndIf
          :If ∨/1<(+/[1]ya=0),(+/[2]xa=0) ⋄ ok←0 ⋄ :EndIf  ⍝ must have only one 0 per attach vector
          :If 0=⍴⍴resize ⋄ resize←r c⍴resize ⋄ :EndIf
          :If 1≠⍴∪(r c)(⍴ya)(⍴xa)(⍴resize) ⋄ ok←0 ⋄ :EndIf
          :If ~ok ⋄ ##.Gui.Error'LayoutGrid: Bad Arguments' ⋄ :Return ⋄ :EndIf
          ⍝ Now that the input is correct, start doing stuff
          (∆objs fixed)←,¨(∆objs(~resize))              ⍝ (fixed←~resize) is more useful that resize
          :If ~∨/valid←⎕NULL∘≢¨∆objs ⋄ :Return ⋄ :EndIf ⍝ ⎕NULL means no object in that cell
          (∆objs fixed)←valid∘/¨(∆objs fixed)           ⍝ we don't really use matrices, but vectors of valid objects
          :If 1<⍴∪∆objs.## ⋄ ##.Gui.Error'LayoutGrid: Objects don''t share the same parent' ⋄ :Return ⋄ :EndIf
          ∆parent←(⊃∆objs).##
          (oh ow)←↓⍉↑GetSize¨∆objs                      ⍝ original object sizes
          h←⌈/r c⍴valid\oh ⋄ w←⌈⌿r c⍴valid\ow           ⍝ rows and columns heights and widths
          y←+\yg+0,h ⋄ x←+\xg+0,w                       ⍝ rows and columns positions
          (ph pw)←{⊃⌽⍵}¨(y x) ⋄ (y x)←¯1↓¨(y x)         ⍝ last positions are actually new parent size
          (y h)←c∘/¨(y h) ⋄ (x w)←(r×c)∘⍴¨(x w)         ⍝ turn into list of cell positions and sizes
          (y x h w ya xa)←valid∘/¨,¨(y x h w ya xa)     ⍝ turn into lists matching object list
          ⍝ restore sizes of unresized objects, adjusting position for objects attached to Right or Bottom
          mask←fixed∧1=ya ⋄ (mask/y)+←(mask/h-oh)       ⍝ attached to bottom ⋄ adjust y position
          mask←fixed∧1=xa ⋄ (mask/x)+←(mask/w-ow)       ⍝ attached to right ⋄ adjust x position
          (fixed/h)←(fixed/oh) ⋄ (fixed/w)←(fixed/ow)   ⍝ now reset sizes
          ⍝ compute Attach properties
          (t b)←↓⍉↑('Top' 'Top')('Top' 'Bottom')('Bottom' 'Bottom')[2+ya]
          (l r)←↓⍉↑('Left' 'Left')('Left' 'Right')('Right' 'Right')[2+xa]
          ⍝ Finally, do it all !
          ∆parent SetSize ph pw
          ∆objs Configure¨↓⍉↑(y x h w)                   ⍝ lay out children
          ∆objs Attach¨↓⍉↑(t l b r)                      ⍝ attach children
        ∇

        ∇ {ok}←LayoutSerial(∆objs new horizontal space);x;y;∆row;h;w;t;l;start;rowh;mask
          ⍝ sequentially place ∆objs in rows, with space between them.
          ⍝ new should be a integer vector of the same length as ∆objs, specifying how many rows to jump
          ⍝ horizontal is a flag specifying whether rows are horizontal or vertical.
          ok←1
          :If 1≠⍴⍴∆objs ⋄ ∆objs←,∆objs ⋄ :EndIf
          :If 0=⍴⍴new ⋄ new←(⍴∆objs)⍴new ⋄ :EndIf
          :If (⍴new)≢(⍴∆objs) ⋄ ok←0 ⋄ :EndIf
          :If ~ok ⋄ Error'LayoutSerial: Bad Arguments' ⋄ :Return ⋄ :EndIf
          start←space                              ⍝ current position
          mask←1,1↓0≠new
          :For ∆row new :InEach (mask⊂∆objs)(mask/new)
              (h w)←horizontal{⍺:⍵ ⋄ ⌽⍵}↓⍉↑∆row.(Size)
              rowh←⌈/h
              start+←rowh×new-1
              t←start+(rowh-h)÷2                   ⍝ top
              l←+\space+0,¯1↓w                     ⍝ left
              (t l)←horizontal{⍺:⍵ ⋄ ⌽⍵}(t l)
              ∆row Move¨t,¨l
              start+←space+rowh
          :EndFor
          ∆objs Attach¨⊂'Top' 'Left' 'Top' 'Left'
        ∇

        ∇ ∆obj LayoutSerialNext(rowwise new space stretch);oh;ow;rt;rl;rh
          ⍝ Append ∆obj serially within its parent. It won't resize.
          ⍝ All current siblings of ∆obj must have been laid down with this function.
          ⍝ - rowwise : flag to do it row-wise or col-wise
          ⍝ - new : flag to start a new row/column
          ⍝ - space : spacing in pixels between rows and columns
          ⍝!!!:If ∆obj≡⎕NULL ⋄ :Return ⋄ :EndIf
          (oh ow)←GetSize ∆obj                                      ⍝ object's width and height
          :If 0=∆obj.##.⎕NC'∆∆LAYOUTSERIALNEXT' ⋄ (rt rl rh)←0 0 0  ⍝ row top ⋄ row left ⋄ row height
          :Else ⋄ (rt rl rh)←∆obj.##.∆∆LAYOUTSERIALNEXT ⋄ :EndIf
          :If ~rowwise ⋄ ((oh ow)(rt rl))←⌽¨(oh ow)(rt rl) ⋄ :EndIf ⍝ do it col-wise
          :If new ⋄ rt+←rh+space ⋄ rl←space ⋄ rh←0 ⋄ :EndIf         ⍝ new row
          ∆obj Move rt rl ⋄ rl+←ow+space ⋄ rh⌈←oh                   ⍝ continue existing row
          :If stretch
              ow←(2⊃GetSize ∆obj.##)-rl-ow                          ⍝ stretch object
              rt+←rh+space ⋄ rl←space ⋄ rh←0                        ⍝ next will start new row
          :EndIf
          :If ~rowwise ⋄ ((oh ow)(rt rl))←⌽¨(oh ow)(rt rl) ⋄ :EndIf ⍝ do it col-wise
          :If stretch
              ∆obj Resize oh ow
              :If rowwise ⋄ ∆obj Attach'Top' 'Left' 'Top' 'Right'
              :Else ⋄ ∆obj Attach'Top' 'Left' 'Bottom' 'Left' ⋄ :EndIf
          :Else
              ∆obj Attach'Top' 'Left' 'Top' 'Left'
          :EndIf
          ∆obj.##.∆∆LAYOUTSERIALNEXT←rt rl rh
        ∇

        ∇ ∆ctrl←{∆parent}BuildLabel(caption width)
          :If 0=⎕NC'∆parent' ⋄ ∆parent←⊃⎕RSI ⋄ :EndIf
          ∆ctrl←∆parent.⎕NEW'Label'(('Caption'caption)('Coord'COORD)('BCol'BCOL))
          :If 0∊⍴width ⋄ ∆ctrl.Size←STDH,¯10+2⊃∆ctrl.Size
          :Else ⋄ ∆ctrl.Size←STDH,width ⋄ :EndIf
          ∆ctrl SetFont 0 0
        ∇
        ∇ ∆ctrl←{∆parent}BuildTick(caption width)
          :If 0=⎕NC'∆parent' ⋄ ∆parent←⊃⎕RSI ⋄ :EndIf
          ∆ctrl←∆parent.⎕NEW'Button'(('Style' 'Check')('Caption'caption)('Coord'COORD)('BCol'BCOL))
          :If 0∊⍴width ⋄ ∆ctrl.Size←STDH,2⊃∆ctrl.Size
          :Else ⋄ ∆ctrl.Size←STDH,width ⋄ :EndIf
          ∆ctrl SetFont 0 0
        ∇
        ∇ ∆ctrl←{∆parent}BuildSubForm args
          :If 0=⎕NC'∆parent' ⋄ ∆parent←⊃⎕RSI ⋄ :EndIf
          ∆ctrl←∆parent.⎕NEW'SubForm'(SubForm.Args,args)
        ∇
        ∇ ∆ctrl←{∆parent}BuildGroup args
          :If 0=⎕NC'∆parent' ⋄ ∆parent←⊃⎕RSI ⋄ :EndIf
          ∆ctrl←∆parent.⎕NEW'Group'(Group.Args,args)
        ∇
        ∇ ∆ctrl←{∆parent}BuildButton caption
          :If 0=⎕NC'∆parent' ⋄ ∆parent←⊃⎕RSI ⋄ :EndIf
          ∆ctrl←∆parent.⎕NEW'Button'(('Caption'caption)('Coord'COORD)('Size'(STDH STDW)))
          ∆ctrl SetFont 0 0
        ∇
        ∇ args←∆obj Tip tip;∆parent;∆tip
          ∆obj ⎕WS'Tip'tip
        ∇
        ∇ Error txt
          :If Util.DEBUG ⋄ ('ChartWizard Internal Error: ',,⍕txt)⎕SIGNAL 666
          :Else
              ⎕DQ ⎕NEW'MsgBox'(('Caption' 'Chart Wizard Internal Error')('Text'txt)('Style' 'Error')('Btns' 'OK'))
            ⍝  (⎕NEW MsgBox('Error' 'Internal Error'txt)).Wait
          :EndIf
        ∇
        ∇ {error}Info txt;style
          :If 0=⎕NC'error' ⋄ error←0 ⋄ :EndIf ⋄ style←(1+error)⊃'Info' 'Error'
          ⎕DQ ⎕NEW'MsgBox'(('Caption' 'Chart Wizard')('Text'txt)('Style'style)('Btns' 'OK'))
        ∇
        ∇ APLInfo txt  ⍝ Info box with APL characters
          (⎕NEW MsgBox('Chart Wizard' 1 0 txt'OK')).Wait
        ∇
        ∇ choice←choices Choice txt
          choice←(⎕NEW MsgBox('Chart Wizard' 0 0 txt choices)).Wait
        ∇
        ∇ Debug txt
          :If Util.DEBUG ⋄ ⎕←txt ⋄ :EndIf
        ∇
        ∇ yes←YesNo txt;dq;events;msgbox
          events←('onMsgBtn1' 1)('onMsgBtn2' 1)
          msgbox←⎕NEW'MsgBox'(('Caption' 'Chart Wizard')('Text'txt)('Style' 'Query')('Btns'('YES' 'NO'))('Event'events))
          dq←⎕DQ msgbox   ⍝!!! ⎕DQ ⎕NEW always returns ⍬
          :If 0∊⍴dq ⋄ :OrIf 'MsgBtn1'≢2⊃dq ⋄ yes←0 ⋄ :Else ⋄ yes←1 ⋄ :EndIf
          ⍝ yes←(⎕NEW MsgBox('YesNo' ''txt)).Wait
        ∇
        ∇ (file index)←FileBox(caption write filters);events;∆form;filemode;dq;ext;tie
          file←ext←'' ⋄ index←0 ⋄ filemode←{⍵:'Write' ⋄ 'Read'}write
          events←('onFileBoxOk' 1)('onFileBoxCancel' 1)
          :If 0∊⍴caption ⋄ caption←(1+write)⊃'Open...' 'Save as...' ⋄ :EndIf
          ∆form←⎕NEW'FileBox'(('Caption'caption)('FileMode'filemode)('Style' 'Single')('Filters'filters)('Event'events))
          :If 0∊⍴dq←⎕DQ ∆form ⋄ :OrIf 'FileBoxOK'≢2⊃dq ⋄ :Return ⋄ :EndIf   ⍝ user gave up
          file←∆form.(Directory,File) ⋄ ext←1⊃(index←∆form.Index)⊃filters           ⍝ extract information
          :If ~0∊⍴ext~'.*' ⋄ file,←(~'.'∊file)/1↓ext ⋄ :EndIf  ⍝ append extension if it was specified and file is not dotted
        ∇

        ∇ ShowHelp name;file
          file←Util.GetDyalogPath,'help\sharpplot.chm'
          :If ~0∊⍴name ⋄ name←name,'.htm'
              :If Util.SHARPPLOT300 ⋄ name←'SharpPlot-',name ⋄ :EndIf
          :EndIf
          System.Windows.Forms.Help.ShowHelp ⎕NULL file name
        ∇

        ∇ r←FindColors(a r g b);∆colors
        ⍝ find closest named colors from .Net
          ∆colors←a r g b{⍵[⍋+/[1]2*⍨⍺-[1](4⍴256)⊤⍵.ToArgb]}System.Drawing.Color.(⍎¨⎕NL ¯2)
          r←⊖∆colors,[1.5],⌿(4⍴256)⊤∆colors.ToArgb
        ∇

    :EndNamespace

    :EndSection





⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section Util_Charts
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

    :Namespace Chart
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        ⍝⍝⍝⍝⍝ CHART TYPES ⍝⍝⍝⍝⍝
        TYPE←1        ⍝ charttype identifier
        METHOD←2      ⍝ chart draw method name
        STYLE←3       ⍝ chart style namespace
        DEF←4         ⍝ default serie indices
        ARGS←5        ⍝ seriestypes : 'N'=Numeric ⋄ 'A'=Any (text or numeric) ⋄ UPPERCASE=nested=multiple ⋄ lowercase=flat=single
        SERIES←6      ⍝ name of series
        LIMIT←7       ⍝ maximum number of points
        DESC←8        ⍝ description : [1] display name ⋄ [2] "technical" overview ⋄ [3] "didactic" overview
        COLS←8

        CHARTS←0 COLS⍴0
        CHARTS⍪←''          ''                 '⎕NULL'                       0         ⍬        ⍬                                    ¯1       ('Invalid chart type')
        CHARTS⍪←'Bar'       'DrawBarChart'     'Causeway.BarChartStyles'     (,1)      (,'N')   (,¨,⊂'Values')                       10000    ('Bar chart' 'Draw side-by-side bars rising from a baseline' 'Useful for small summary data')
        CHARTS⍪←'Box'       'DrawBoxPlot'      'Causeway.BoxPlotStyles'      (,1)      (,'naa') (,¨'Values' 'Category1' 'Category2') 1000000  ('Box-and-Whiskers plot' 'Draw quartiles of mono- or bi-variate numerical distributions' 'Useful to explore yet-unmodelled correlations between numerical variables')
        CHARTS⍪←'Bubble'    'DrawBubbleChart'  'Causeway.BubbleChartStyles'  (,3 1 2)  (,'nnn') (,¨'Y' 'X' 'Z')                      10000    ('Bubble chart' 'Draw bubbles scaled by Z value at XY positions' 'Useful for small XYZ data')
        CHARTS⍪←'Cloud'     'DrawCloudChart'   'Causeway.CloudChartStyles'   (,3 2 1)  (,'nnN') (,¨'X' 'Y' 'Z')                      10000    ('Cloud chart' 'Draw markers on a 3D XYZ space' 'Useful for large XYZ data when point of view can be manually adjusted')
        CHARTS⍪←'Contour'   'DrawContourPlot'  'Causeway.ContourPlotStyles'  (,3 2 1)  (,'nnn') (,¨'X' 'Y' 'Z')                      1000     ('Contour plot' 'Draw 2D projection of XYZ regression surface' 'The best way to visualise trend of XYZ series')
        CHARTS⍪←'Dial'      'DrawDialChart'    'Causeway.DialChartStyles'    (,1)      (,'nn')  (,¨'Values' 'Radii')                 1000     ('Dial chart' 'Draw arrows pointing at values on a semi-circular dial' 'Useful for elaborate display of small series as gauges')
        CHARTS⍪←'Gantt'     'DrawGanttChart'   'Causeway.GanttChartStyles'   (,1 2 3)  (,'nnn') (,¨'Y' 'XStart' 'XEnd')              10000    ('Gantt chart' 'Draw bars, specifying start and end points' 'Useful for time-wise status monitoring')
        CHARTS⍪←'Histogram' 'DrawHistogram'    'Causeway.HistogramStyles'    (,1)      (,'a')   (,¨,⊂'Values')                       1000000  ('Histogram' 'Draw the value distribution of an unordered series' 'Useful to visualise the statistical repartition of mono-variate samples')
        CHARTS⍪←'Line'      'DrawLineGraph'    'Causeway.LineGraphStyles'    (,1)      (,'Nn')  (,¨'Y' 'X')                          10000    ('Line graph' 'Draw connected values on an XY plane' 'Useful for sequential series, typically time series')
        CHARTS⍪←'MinMax'    'DrawMinMaxChart'  'Causeway.MinMaxChartStyles'  (,1 2)    (,'nnn') (,¨'YMax' 'YMin' 'X')                10000    ('Min-Max chart' 'Draw mono-variate ranges on an XY plane' 'Useful for spanned sequential data, typically time series with error bars')
        CHARTS⍪←'Pie'       'DrawPieChart'     'Causeway.PieChartStyles'     (,1)      (,'nn')  (,¨'Values' 'Explode')               1000     ('Pie/Rose chart' 'Draw numeric series as angular portions of a disk' 'Useful for small summary series')
        CHARTS⍪←'Polar'     'DrawPolarChart'   'Causeway.PolarChartStyles'   (,1)      (,'Nn')  (,¨'Y' 'X')                          10000    ('Polar/Radar chart' 'Draw XY series where X is angular' 'Useful for angular data, or arbitrarily-categorised performance comparison')
        CHARTS⍪←'Response'  'DrawResponsePlot' 'Causeway.ResponsePlotStyles' (,1)      (,'Nnn') (,¨'Z' 'X' 'Y')                      1000000  ('Response surface' 'Draw Z surface on a 3D XYZ space' 'Useful for rectangular numerical data, or bi-variate mathematical functions')
        CHARTS⍪←'Scatter'   'DrawScatterPlot'  'Causeway.ScatterPlotStyles'  (,1 2)    (,'Nn')  (,¨'Y' 'X')                          10000    ('Scatter plot' 'Draw markers on an XY plane' 'Useful for discrete XY data')
        CHARTS⍪←'Step'      'DrawStepChart'    'Causeway.StepChartStyles'    (,1)      (,'nn')  (,¨'Y' 'X')                          10000    ('Step chart' 'Draw a constant XY line with discrete changes' 'Useful for sequential data with instantaneous changes')
        CHARTS⍪←'Table'     'DrawTable'        'Causeway.TableStyles'        (,1)      (,'A')   (,¨,⊂'Values')                      ¯1       ('Data Table' 'Draw rows and columns of text'  'Useful for small text summary of series')
        CHARTS⍪←'Tower'     'DrawTowerChart'   'Causeway.TowerChartStyles'   (,1)      (,'N')   (,¨,⊂'Values')                       1000     ('Tower chart' 'Draw a matrix of Z-scaled bars on a 3D XYZ space' 'Useful for small rectangular summary data, if point of view can be manually adjusted')
        CHARTS⍪←'Trace'     'DrawTraceChart'   'Causeway.TraceChartStyles'   (,1)      (,'Nn')  (,¨'Inner' 'X')                      10000    ('Trace chart' 'Draw XY lines alongside' 'Useful to spot sharp changes in a couple of sequential series')
        CHARTS⍪←'TreeMap'   'DrawTreeMap'      'Causeway.TreeMapStyles'      (,1)      (,'nnn') (,¨'Area' 'Depth' 'Altitude')        10000    ('Tree map' 'Draw nested rectangles of specified area (and possibly altitude)' 'Useful for tree-shaped mono- or bi-variate numerical data')
        CHARTS⍪←'Triangle'  'DrawTriangle'     'Causeway.TriangleStyles'     (,1 2 3)  (,'nnn') (,¨'X' 'Y' 'Z')                      10000    ('Triangle plot' 'Represent proportions of 3 variables on a triangle' 'Useful to represent proportions of 3 constituents')
        CHARTS⍪←'Vector'    'DrawVectors'      'Causeway.VectorStyles'       (,2 4 1 3)(,'nnnn')(,¨'X1' 'Y1' 'X2' 'Y2')              10000    ('Vector field' 'Draw XY vectors' 'Useful for data where each item is a XY pair')
        CHARTS⍪←'XBar'      'DrawXBarChart'    'Causeway.XBarChartStyles'    (,1 2)    (,'Nn')  (,¨'Y' 'X')                          10000    ('X-Bar chart' 'Draw bars at specified X positions' 'Useful for discrete sequential data, typically discrete values that occur at particular times')

        ∇ charttypes←GetTypes
          charttypes←CHARTS[;TYPE]~⊂''
        ∇
        ∇ ∆style←GetStyle charttype
          :If 0∊⍴charttype ⋄ Error'No chart has no style' ⋄ :EndIf  ⍝ yet another empty array joke
          ∆style←⊃CHARTS[CHARTS[;TYPE]⍳⊂charttype;STYLE]
        ∇
        ∇ name←GetMethod charttype
          :If 0∊⍴charttype ⋄ Error'No chart has no method' ⋄ :EndIf
          name←⊃CHARTS[CHARTS[;TYPE]⍳⊂charttype;METHOD]
        ∇
        ∇ name←GetLimit charttype
          :If 0∊⍴charttype ⋄ Error'No chart has no limit' ⋄ :EndIf
          name←⊃CHARTS[CHARTS[;TYPE]⍳⊂charttype;LIMIT]
        ∇
        ∇ (types names)←GetSeries charttype
          :If 0∊⍴charttype ⋄ Error'No chart has no series' ⋄ :EndIf
          (types names)←CHARTS[CHARTS[;TYPE]⍳⊂charttype;ARGS SERIES]
        ∇
        ∇ tip←GetTip charttype
          :If 0∊⍴charttype ⋄ Error'No chart has no tip' ⋄ :EndIf
          tip←⊃CHARTS[CHARTS[;TYPE]⍳⊂charttype;DESC]
        ∇
        ∇ desc←GetFormatDescription type
          :Select type
          :Case 'N' ⋄ desc←'multiple numeric vectors'
          :Case 'n' ⋄ desc←'a numeric vector'
          :Case 'A' ⋄ desc←'multiple numeric or strings vectors'
          :Case 'a' ⋄ desc←'a single numeric or strings vector'
          :Else ⋄ Gui.Error'Unknown serie type'
          :EndSelect
        ∇
        ∇ indices←GetDefaultIndices charttype
          indices←⊃CHARTS[CHARTS[;TYPE]⍳⊂charttype;DEF]
        ∇
        ∇ indices←GetIndices charttype
          :If 0∊⍴charttype ⋄ Error'No chart has no series' ⋄ :EndIf
          indices←GetDefaultIndices charttype
          indices∪←⍳⍴2⊃GetSeries charttype
        ∇
        ∇ prop←GetStylesProperty ∆styles
          prop←{¯1↓(⌽∧\⌽⍵≠'.')/⍵}⍕∆styles         ⍝ (Causeway.XXXs) → 'XXXs'
          prop←(-'s'=⊃⌽prop)↓prop                 ⍝ 'XXXs' → 'XXX'
        ∇
        ∇ styles←GetPropertyStyles prop
          styles←'Causeway.',prop,'s'             ⍝ 'XXX' → 'Causeway.XXXs'
        ∇
        ⍝ ∇ styles←GetStyles style                  ⍝ chart styles that have such style
        ⍝   styles←CHARTS[;STYLE]
        ⍝   styles←(2=⌊|⎕NC styles,¨⊂'.',style)/styles
        ⍝ ∇
        ∇ prop←GetStyleProperty ∆style
          :If 0=∆style ⋄ Gui.Error'Empty style doesn''t have a property' ⋄ :EndIf
          prop←GetStylesProperty ∆style.GetType   ⍝ (Causeway.XXXs.YYY) → 'XXX'
        ∇

        ∆WIZARDICON←⎕NULL
        ∇ ∆icon←GetWizardIcon
          :If ∆WIZARDICON≡⎕NULL
              ∆WIZARDICON←⎕NEW'Icon'(⊂'File'(Util.GetDyalogPath,'samples\Causeway\chartwizard16.gif'))
          :EndIf
          ∆icon←∆WIZARDICON
        ∇
        CHARTCBITS←⍬
        ∇ cbits←GetCBits;types;∆icon
          :If 0∊⍴CHARTCBITS
              ∆icon←⎕NEW'Icon'(⊂'File'(Util.GetDyalogPath,'samples\Causeway\charts32.gif'))
              types←'Bar' 'Box' 'Bubble' 'Cloud' 'Contour' 'Dial' 'Gantt' 'Histogram' 'Line' 'MinMax' 'Pie' 'Polar' 'Response' 'Scatter' 'Step' 'Table' 'Tower' 'Trace' 'TreeMap' 'Triangle' 'Vector' 'XBar' 'Wizard'
              cbits←∆icon.CBits ⋄ cbits←((2⊃⍴cbits)⍴32↑1)⊂[2]cbits ⍝ chop icons
              CHARTCBITS←cbits[types⍳GetTypes,⊂'Wizard']  ⍝ reorder to current fashion - use wizard for last one (unknown, empty or invalid charttypes)
          :EndIf
          cbits←CHARTCBITS
        ∇
        ∇ ∆img←GetImageList;path
          ∆img←⎕NEW'ImageList'(('Size'(32 32))('Masked' 0)('MapCols' 0))
          {}∆img.⎕NEW'Bitmap'(⊂'CBits'(⊃,/GetCBits))
        ∇
        ∇ ∆icon←GetIcon charttype;cbits
          cbits←(GetTypes⍳⊂charttype)⊃GetCBits
          ⍝∆icon←⎕NEW'Icon'(('Style' 'Large')('CBits'cbits)('Size'(32 32)))  ⍝ does not scale with DPI>100%
          ∆icon←⎕NEW'Bitmap'(⊂('CBits'cbits))
        ∇

        ∇ ∆sp Print txt;x;y          ⍝ overdraw Causeway.SharpPlot instance with error message
          ∆sp.Reset ⍬
          ∆sp.SetMargins(0 0 0 0) ⋄ ∆sp.Gutter←0 ⋄ ∆sp.DrawFrame
          ∆sp.SetNoteFont'APL385 Unicode' 10 System.Drawing.FontStyle.Regular System.Drawing.Color.Red
          ∆sp.NoteStyle←Causeway.NoteStyles.Absolute
          ∆sp.DrawNote(Util.UnNestText txt)5(¯15+2⊃∆sp.GetPaperSize)  ⍝!!! substract fontsize - drawnote position is bottom-left of first character
        ∇

    :EndNamespace
    :EndSection




⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section GUI_wrapper_classes
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

    :Class Form : 'Form'
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        ∇ args←Args
          args←('Coord'Gui.COORD)('BCol'Gui.BCOL)
        ∇
        ∇ FormConstructor args;cargs
          :Access Public
          cargs←Args
          cargs,←('Visible' 0)('Redraw' 0)('Posn'(50 30+Util.Random 50 50))('IconObj'Chart.GetWizardIcon)
          cargs,←args
          :Implements Constructor :Base cargs  ⍝ draw it only when ready
          ⍝⎕THIS.FontObj←''                    ⍝!!! Mantis 11536
          ⎕THIS Gui.SetFont 0 0                    ⍝ force font in case parent is ⎕SE
          ⎕THIS.TipObj←⎕THIS.⎕NEW⊂'TipField'         ⍝ tipfield can be accessed through (Gui.GetParentForm ⎕THIS).TipObj
          ⎕THIS.∆TIPFIELD←⎕THIS.TipObj   ⍝ save handle for 1400⌶0
          ⍝Gui.Debug'Form Constructor : '⎕THIS(Util.GetStackItems)
        ∇
        ∇ Show show;posn                    ⍝ Show/Hide form
          :Access Public
          :If show
              ⎕THIS Gui.Redraw 3
              ⍝ Gui.Debug 'Visible : 0 → 1'⎕THIS
              ⎕THIS.Visible←1
              ⍝ ⎕THIS Gui.Redraw 3  ⍝!!! before mantis 13606
              1 Gui.Focus ⎕THIS
          :Else
              ⍝ Gui.Debug 'Visible : 1 → 0'⎕THIS
              ⎕THIS.Visible←0
              ⎕THIS Gui.Redraw 0
          :EndIf
        ∇
        ∇ Wait                              ⍝ Show and wait
          :Access Public
          Show 1 ⋄ ⎕DQ ⎕THIS
        ∇
    :EndClass

    :Namespace SubForm
        ∇ args←Args
          args←('Coord'Gui.COORD)('EdgeStyle' 'Default')('BCol'Gui.BCOL)('Border' 0)
        ∇
    :EndNamespace
    :Namespace Group
        ∇ args←Args
          args←('Coord'Gui.COORD)('EdgeStyle' 'Plinth')('BCol'Gui.BCOL)('Border' 0)
        ∇
    :EndNamespace


    :Class ScrollSubForm : 'SubForm'        ⍝ A scrollable subform
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Public Shared ReadOnly SCROLLSIZE←16  ⍝ Scroll size
        :Field Private ∆CHILD               ⍝ functional child window
        :Field Private ∆SCROLL              ⍝ scroll bars to move child window (∆SCROLL[1] : VScroll ⋄ ∆SCROLL[2] : HScroll
        :Field Private ∆WINDOW              ⍝ subform above scrollbars but cropped by ⎕THIS - using SubForm.(VScroll HScroll)←¯1 was less nice because scroll bars are then not counted in SubForm.Size
        :field Private SCROLL               ⍝ (Vertical Horizontal) scroll flags : 0 for no scroll (attach) ⋄ 1 for scroll when needed ⋄ 2 for always scroll
        ∇ ScrollSubFormConstructor(vert horz key args);cargs;ssize;size
          :Access Public
          :Implements Constructor :Base SubForm.Args,args
          size←⎕THIS.Size ⋄ SCROLL←(vert horz)
          ∆SCROLL←⎕NEW'Scroll'(('VScroll' ¯1)('Thumb' 1)('BCol'Gui.BCOL))   ⍝('Align' 'Right') ⍝!!! BUG : When built with Align←('Right' 'Bottom'), ∆SCROLL.Attach is (None  Right  None  Right)    (None  Left  None  Left)
          ∆SCROLL,←⎕NEW'Scroll'(('HScroll' ¯1)('Thumb' 1)('BCol'Gui.BCOL))  ⍝('Align' 'Bottom')
          ∆SCROLL.Size←0⌈((¯1 1)(1 ¯1)×SCROLLSIZE)+((1 0)(0 1)×size)
          ∆SCROLL.Posn←((0 1)(1 0)×⌽∆SCROLL.Size)
          ∆SCROLL.AutoConf←0                                                ⍝ scroll bars are redrawn in ConfigureScroll callback
          ∆SCROLL.Active←(0≠SCROLL) ⋄ ∆SCROLL.Visible←(2=SCROLL)            ⍝ window size initialised at parent size - no need for scroll bars unless forced
          cargs←args,('AutoConf' 0)('Posn'(0 0))('Size'size)                ⍝ redrawn by the ConfigureScroll callback
          ∆WINDOW←Gui.BuildSubForm cargs
          cargs←args,('AutoConf' 2)('Posn'(0 0))('Size'size)
          ∆CHILD←∆WINDOW Gui.BuildSubForm cargs
          ∆SCROLL.(onThumbDrag onScroll)←⊂⊂'DoScroll'
          :If key
              ∆SCROLL.(onKeyPress)←⊂'ScrollKey'  ⍝ enable keystrokes on scroll bars to move child window around
              ∆SCROLL.(onGotFocus)←⊂'UnFocus'    ⍝ prevent scroll bars from stealing focus ⍝!!! doesn't work
          :EndIf
          (⎕THIS ∆CHILD).onConfigure←⊂'ConfigureScroll'
        ∇
        ∇ {msg}←DoScroll msg;cp;cs;pos        ⍝ move ∆CHILD around
          (cs cp)←∆CHILD.(Size Posn)
          :Select 2⊃msg ⋄ :Case 'ThumbDrag' ⋄ pos←3⊃msg ⋄ :Case 'Scroll' ⋄ pos←4⊃msg ⋄ :EndSelect
          cp[∆SCROLL⍳1⊃msg]←-pos-1          ⍝ Scroll starts at 1...
          2 ⎕NQ ∆CHILD'Configure',cp,cs     ⍝ no need to callback
        ∇
        ∇ {msg}←UnFocus msg
          Gui.Focus 3⊃msg                   ⍝ give back focus
          msg←0                             ⍝ inihibit
        ∇
        ∇ {msg}←ScrollKey msg;∆obj;cs;cp
          (cs cp)←∆CHILD.(Size Posn)
          :Select 5⊃msg
          :Case 38 ⋄ cp[1]+←10      ⍝ up arrow
          :Case 40 ⋄ cp[1]-←10      ⍝ down arrow
          :Case 37 ⋄ cp[2]+←10      ⍝ left arrow
          :Case 39 ⋄ cp[2]-←10      ⍝ right arrow
          :Case 33 ⋄ cp[1]←0        ⍝ page up
          :Case 34 ⋄ cp[1]←-cs[1]   ⍝ page down
          :Case 36 ⋄ cp[2]←0        ⍝ home
          :Case 35 ⋄ cp[2]←-cs[2]   ⍝ end
          :Else ⋄ :Return           ⍝ other keys : do not inhibit
          :EndSelect
          ConfigureChild cp,cs           ⍝ recompute everything, cleaning our overflows
          msg←0 ⍝ inhibit
        ∇
        ∇ ConfigureChild(y x h w)
          :Access Public
          ConfigureScroll ⎕NULL'Configure',y x h w
        ∇
        ∇ {(∆obj evt y x h w)}←ConfigureScroll(∆obj evt y x h w);child;ps;pp;cp;cs;scroll;ws;wp
          ⍝ Recompute and resize scrolls, window, and child
          :If (child←∆obj≡∆CHILD)∨(∆obj≡⎕NULL) ⋄ (pp ps)←⎕THIS.(Posn Size) ⋄ (cp cs)←((y x)(h w))  ⍝ ∆obj is ⎕NULL when just moving child around
          :Else ⋄ (pp ps)←((y x)(h w)) ⋄ (cp cs)←∆CHILD.(Posn Size) ⋄ :EndIf
          ⍝Gui.Debug'ScrollSubForm.Configure:'(1↓Util.GetStackItems)
          ⍝Gui.Debug'ScrollSubForm.Configure:'∆obj child'before:' 'parent'(⎕THIS.Size)'window'(∆WINDOW.Size)'child'(∆CHILD.Size)'this'(h w)
          scroll←(SCROLL=2)∨((SCROLL=1)∧(0>ps-cs))              ⍝ need for scrollbars
          scroll∨←(SCROLL=1)∧(⌽scroll)∧(SCROLLSIZE>ps-cs)       ⍝ a scroll bar forces the other to show up
          ws←0⌈ps-⌽scroll×SCROLLSIZE ⋄ wp←0 0                   ⍝ shrink window to show scroll bars
          cs←0⌈⊃ws cs+.×{(~⍵)(⍵)}SCROLL>0                       ⍝ attach ∆CHILD to ∆WINDOW where unscrolled
          cp←(0⌊ws-cs)⌈0⌊cp                                     ⍝ parent page cannot look outside children
          ∆SCROLL.Size←0⌈(SCROLLSIZE×(0 1)(1 0)+(¯1 0)(0 ¯1)×⌽scroll)+((1 0)(0 1)×ps)
          ∆SCROLL.Posn←((0 1)(1 0)×⌽∆SCROLL.Size)
          ∆SCROLL.Range←1⌈⌈cs⌈ws ⋄ ∆SCROLL.PageSize←ws
          ∆SCROLL.Visible←scroll ⋄ ∆SCROLL.Thumb←⌊0.5+1-cp           ⍝ Scroll starts at 1...
          ∆SCROLL.Step←10,¨10⌈⌊0.5+(cs-ws)÷4                    ⍝ small step is 10pix - big step is a quarter of scrollable space
          ⍝Gui.Debug'ScrollSubForm.Configure:'∆obj child'after:' 'parent'(ps)'window'(ws)'child'(cs)
          2 ⎕NQ ∆WINDOW'Configure',wp,ws                        ⍝ reconfigure with no callbacks
          :If child ⋄ ((y x)(h w))←(cp cs) ⋄ 2 ⎕NQ ⎕THIS'Configure',pp,ps
          :Else ⋄ ((y x)(h w))←(pp ps) ⋄ 2 ⎕NQ ∆CHILD'Configure',cp,cs ⋄ :EndIf
        ∇
        ∇ FitChild
          :Access Public                                        ⍝ Resize control to fit child's size
          ⎕THIS Gui.Resize ∆CHILD.Size+(⌽SCROLL=2)×SCROLLSIZE
        ∇
        ∇ ∆subform←GetChild                                     ⍝ Get handle to child window
          :Access Public
          ∆subform←∆CHILD
        ∇
        ∇ ∆subform←GetWindow
          :Access Public
          ∆subform←∆WINDOW
        ∇
        ∇ (∆vscroll ∆hscroll)←GetScrolls
          :Access Public
          (∆vscroll ∆hscroll)←∆SCROLL
        ∇
    :EndClass

    :Class Display : ScrollSubForm  ⍝!!! I wanted to call it Text but it steals the scope of .Text GUI property
        ∇ DisplayConstructor(apl fixed text args);size
          :Access Public
          :Implements Constructor :Base 1 1 1 args
          ⎕THIS.GetChild Gui.SetFont apl fixed
          SetText text
        ∇
        ∇ SetText text;size;∆child
          :Access Public
          :If 2=⍴⍴text ⍝ ok
          :ElseIf 1≥|≡text ⋄ text←Util.NestText text
          :Else ⋄ text←↑text
          :EndIf
          ∆child←⎕THIS.GetChild
          size←∆child.GetTextSize text
          ∆child Gui.Resize 10000⌊size    ⍝ weird things happen above that
          '∆TEXT'∆child.⎕WC'Text'(text)(0 0)  ⍝!!! cannot create unnamed Text object
⍝          ⎕THIS.FitChild
        ∇
    :EndClass

    :Class DisplayForm : Form       ⍝ simply display text
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆DISP
        :Field Private ARGS
        :Field Private APL
        :Field Private FIXED
        ∇ TextConstructor(caption apl fixed text args)
          :Access Public
          (ARGS APL FIXED)←(args apl fixed)
          :Implements Constructor :Base (⊂'Caption' caption),ARGS
          ∆DISP←⎕NEW Display(APL FIXED''ARGS)
          SetText text
        ∇
        ∇ SetText text    ⍝ update text and resize to fit
          :Access Public
          ∆DISP.SetText text
          ∆DISP Gui.LayoutGrid Gui.SPACE Gui.SPACE 0 0 0
        ∇
    :EndClass


    :Class MsgBox : Form
        ∇ MsgBoxConstructor(caption apl fixed text buttons)
          :Access public
          :Implements Constructor :Base ('Caption' caption) ('MinButton' 0)('MaxButton' 0) ('OnTop' 1)
          :If 1≥|≡buttons ⋄ buttons←,⊂,buttons ⋄ :EndIf
          ∆TEXT←⎕NEW Display(apl fixed text ⍬)
          ∆TEXT.FitChild
          ∆G←⎕THIS Gui.BuildSubForm ⍬
          ∆BUTTONS←∆G∘Gui.BuildButton¨buttons
          (⊃∆BUTTONS).Default←1
          ∆BUTTONS Gui.LayoutGrid 0 Gui.SPACE ¯1 1 0
          (2 1⍴∆TEXT ∆G)Gui.LayoutGrid(3 3 1×Gui.SPACE)(3×Gui.SPACE)(0 1)(0)1
          ⎕THIS Gui.Limit 0.8
          ⎕THIS.Posn←(Gui.GetScreenSize-⎕THIS.Size)÷2  ⍝ put in the middle of the screen
          ∆BUTTONS.onSelect←1
          ⎕THIS.onClose←1
        ∇
        ∇ {button}←Wait;dq
          :Access Public
          ⎕THIS.Show 1  ⍝ Form.Show
          :If ~0∊⍴dq←⎕DQ ⎕THIS ⋄ ∆button←⊃dq ⋄ button←∆button.Caption
          :Else ⋄ button←'' ⋄ :EndIf
        ∇
    :EndClass

    :Class Edit : 'Edit'            ⍝ Edit that handles Enter, Esc, and LostFocus
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        ∇ EditConstructor type
          :Access Public
          :Implements Constructor :Base 1 Args type
          ⍝Gui.Debug 'Edit' 'Coord='⎕THIS.Coord'FontObj='⎕THIS.FontObj
        ∇
        ∇ args←{custom}Args type
          :Access Public Shared
          :If 0=⎕NC'custom' ⋄ custom←0 ⋄ :EndIf
          :Select type
          :Case 'Numeric' ⋄ args←('Size'(Gui.STDH 50))('Value' 0)('Style' 'Single')('Justify' 'Right')('FieldType' 'Numeric')⍝('FontObj'('MS Sans Serif' 9))  ⍝!!! Mantis 15535
          :Case 'Text' ⋄ args←('Size'(Gui.STDH 100))('Value' '')('Style' 'Single')('Justify' 'Left')('FieldType' 'Char')⍝('FontObj'('MS Sans Serif' 9))
          :Case 'Character' ⋄ args←('Size'(Gui.STDH 50))('Value' '')('Style' 'Single')('Justify' 'Right')('FieldType' 'Char')⍝('FontObj'('MS Sans Serif' 9))
          :Case 'Expression' ⋄ args←('Size'(Gui.STDH 200))('Style' 'Single')('Justify' 'Left')('FieldType' 'Char')('FontObj'('APL385 Unicode' 16))('BCol'Gui.COL_EXPRESSION) ⍝!!! might fail when Mantis 15536 is fixed
          :Case 'Display' ⋄ args←('Size'((4×Gui.STDH)200))('Style' 'Multi')('ReadOnly' 1)('HScroll' ¯1)('VScroll' ¯1)('FontObj'('APL385 Unicode' 15))
          :EndSelect
          args,←⊂('Coord'Gui.COORD)
         
          :If custom
              args,←⊂('Event'('onKeyPress' 'EditKey'))
              :If (⊂type)∊'Numeric' 'Character'
                  args,←⊂('Event'('onGotFocus' 'EditGotFocus'))
                  args,←⊂('Event'('onLostFocus' 'EditLostFocus'))
              :EndIf
          :EndIf
        ∇
        ∇ {msg}←EditGotFocus msg
          ⎕THIS.SelText←1,1+⍴,⎕THIS.Text   ⍝ select all text on receiving focus
        ∇
        ∇ {msg}←EditLostFocus msg
          ⎕THIS.SelText←2/1+⍴,⎕THIS.Text   ⍝ select none on losing focus
        ∇
        ∇ {msg}←EditKey msg;obj;ENTER;ESC;keys          ⍝ Handle keystrokes on an Edit
          ENTER←13 ⋄ ESC←27
          :If ⎕THIS.Style≡'Multi' ⋄ keys←ESC ⋄ :Else ⋄ keys←ENTER ESC ⋄ :EndIf
          :If msg[4]∊keys
              EditChange msg
              msg←0                                     ⍝ inhibit
          :EndIf
        ∇
        ∇ {msg}←EditChange msg                          ⍝ Generate a change event with callback
          1 ⎕NQ(1⊃msg)'Change'
        ∇
    :EndClass


    :Class TextForm : Form    ⍝ display text while allowing copy/paste
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆DISP
        ∇ TextConstructor(caption apl fixed text args)
          :Access Public
          :Implements Constructor :Base ('Caption' caption)('Posn'(50 50)),args
          ∆DISP←⎕NEW'Edit'((Edit.Args'Display'),args)
          ∆DISP Gui.SetFont apl fixed
          SetText text
          ∆DISP Gui.LayoutGrid Gui.SPACE Gui.SPACE 0 0 0
        ∇
        ∇ SetText text;size     ⍝ update text and resize to fit
          :Access Public
          :If 1≥|≡text ⋄ text←Util.NestText text ⋄ :EndIf
          :If 2=⍴⍴text ⋄ text←↓text ⋄ :EndIf
          ∆DISP.Text←text
          size←30+∆DISP.GetTextSize↑text   ⍝ 16 for scroll bars, 2 for each border - don't know what the rest is for
          ∆DISP Gui.SetSize size⌊0.8×Gui.GetScreenSize
          ∆DISP Gui.LayoutGrid Gui.SPACE Gui.SPACE 0 0 0
        ∇
    :EndClass

    :EndSection




⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section GUI_meta_controls
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

    :Class Popup                                ⍝ Pop up a form that is built just in time
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆CLASS                   ⍝ class of form to pop up
        :Field Private ARGS                     ⍝ arguments for ∆CONTROL constructor
        :Field Private ∆FORM                    ⍝ instance of the form to pop up
        ∇ PopupConstructor(∆class args);∆parent;∆form
          :Access Public
          :Implements Constructor
          (∆CLASS ARGS ∆FORM)←∆class args(⎕NS'')
        ∇
        ∇ Close                                 ⍝ work with Gui.Close
          :Access Public
          :If IsPoppedUp ⋄ Gui.Close ∆FORM ⋄ :EndIf
        ∇
        ∇ yes←IsPoppedUp                        ⍝ Form is initialised and not closed
          :Access Public
          :If yes←∆FORM≢⎕NULL  ⍝ can't do (⎕NULL ⎕WG'Type') since v18.0
              yes←'Form'≡∆FORM ⎕WG'Type'
          :EndIf
        ∇
        ∇ BuildForm;ok                          ⍝ Build form if necessary
          :If ~IsPoppedUp
              ⍝Gui.Debug 'Popup.BuildForm : ',⍕⎕THIS ∆CLASS
              ∆FORM←⎕THIS Main.BuildForm ∆CLASS ARGS
          :EndIf
        ∇
        ∇ Show show                             ⍝ Show/Hide popup
          :Access Public
          :If show
              BuildForm ⋄ ∆FORM.Show 1
          :ElseIf IsPoppedUp
              ∆FORM.Show 0
          :EndIf
        ∇
        ∇ Wait                                  ⍝ Show and ⎕DQ
          :Access Public
          BuildForm ⋄ ∆FORM.Wait
        ∇
        ∇ ∆form←GetForm                         ⍝ Get a handle to form (will force build)
          :Access Public
          BuildForm ⋄ ∆form←∆FORM
        ∇
    :EndClass

    :Class FormControl : Form                   ⍝ Form that embeds a control
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆CONTROL                 ⍝ Control embedded in the form
        ∇ FormControlConstructor(formargs ∆class controlargs)
          :Access Public
          :Implements Constructor :Base formargs
          ∆CONTROL←⎕NEW ∆class controlargs
          ∆CONTROL Gui.LayoutGrid Gui.SPACE Gui.SPACE 0 0 0
          ⎕THIS.onClose←'CloseFormControl'       ⍝ work with Gui.Close
        ∇
        ∇ {msg}←CloseFormControl msg
          Gui.Close ∆CONTROL
        ∇
        ∇ ∆ctrl←GetControl
          :Access Public
          ∆ctrl←∆CONTROL
        ∇
    :EndClass

    :Class PopupControl : Popup                 ⍝ Embed a control in a form that's popped up
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆POPUP                   ⍝ Popup of form
        ∇ PopupControlConstructor(caption ∆class args);∆parent;∆form;fargs
          :Access Public
          fargs←(⊂('Caption'caption))
          :Implements Constructor :Base FormControl (fargs ∆class args)
        ∇
        ∇ ∆control←GetControl                   ⍝ Get a handle to the control (will force form to be built)
          :Access Public
          ∆control←⎕THIS.GetForm.GetControl
        ∇
    :EndClass

    :Class Replicator : ScrollSubForm       ⍝ A vector of controls
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆CONTROL             ⍝ class for controls
        :Field Private ARGS                 ⍝ constructor arguments for ∆CONTROL
        :Field Private ∆CONTROLS            ⍝ control object for each value
        :Field Private STATES               ⍝ state of each control : 0=uninit ;
        :Field Private ∆REMOVES             ⍝ buttons to remove each item from list
        :Field Private ∆UPS                 ⍝ buttons to move item up in the list
        :Field Private ∆DOWNS               ⍝ buttons to move item down in the list
        :Field Private ∆GROUP               ⍝ GUI groups of (∆UPS,¨∆REMOVES,¨∆DOWN)
        :Field Private ∆ADD                 ⍝ button to add item to list
        :Field Private ROWWISE              ⍝ Flag : display rowwise
        :Field Private ∆CHILD               ⍝ Child subform of ScrollSubForm
        :Field Public Shared ReadOnly ADD←1001     ⍝ Event : control was just added (3rd arg)              ⍝!!! event numbers should be in a global namespace
        :Field Public Shared ReadOnly ADDED←1002   ⍝ Event : some controls have been added (no arg)
        :Field Public Shared ReadOnly REMOVE←1003  ⍝ Event : control about to be removed (3rd arg)    ⍝!!! should be inhibitable
        :Field Public Shared ReadOnly REMOVED←1004 ⍝ Event : some controls have been removed (no arg)
        :field Public Shared ReadOnly MOVED←1005   ⍝ Event : some controls have been moved (no arg)
        ∇ ReplicatorConstructor(n rowwise vscroll hscroll ∆control args)
          :Access Public
          :Implements Constructor :Base vscroll hscroll 1 ⍬
          ROWWISE←rowwise ⋄ ∆CONTROL←∆control ⋄ ARGS←args
          ∆CHILD←⎕THIS.GetChild ⋄ ∆ADD←∆CHILD CreateButton'+' ⋄ ∆GROUPS←∆REMOVES←∆UPS←∆DOWNS←∆CONTROLS←⍬
          SetControls n⍴⊂args               ⍝ create n controls
          ⎕THIS.FitChild                    ⍝ fit them
        ∇
        ∇ Close                                 ⍝ allow this class to work with Gui.Close
          :Access Public
          :If ~0∊⍴∆CONTROLS ⋄ Gui.Close¨∆CONTROLS ⋄ :EndIf
        ∇
        ∇ ∆button←∆parent CreateButton caption;args;caption;bcol;tip
          :Select caption
          :Case '+'
              bcol←⎕NEW'Bitmap'(⊂'CBits'(10 10⍴256⊥Gui.COL_ADD))     ⍝!!! Can't set button bcol
              tip←'Add a new item'
          :Case '-'
              bcol←⎕NEW'Bitmap'(⊂'CBits'(10 10⍴256⊥Gui.COL_REMOVE))
              tip←'Remove this item'
          :Else ⋄ bcol←⎕NEW'Bitmap'(⊂'CBits'(10 10⍴256⊥Gui.COL_MOVE))
              :Select caption
              :Case '↑' ⋄ tip←'Move item up'
              :Case '↓' ⋄ tip←'Move item down'
              :Case '←' ⋄ tip←'Move item to the left'
              :Case '→' ⋄ tip←'Move item to the right'
              :EndSelect
          :EndSelect
          ⍝args←⊂('Event'('onSelect' 'AddRemove'))) ⍝!!! NONCE ERROR with ∆CHILD.AddRemove←AddRemove
          args←('Size'(ROWWISE⌽15 Gui.STDH))('Caption'caption)('FontObj'('APL385 Unicode' 16))('Picture'(bcol 1))
          ∆button←∆parent.⎕NEW'Button'args
          ∆button Gui.Tip tip
          ∆button.onSelect←'UpdateReplicator'
        ∇
        ∇ Show show;∆objs;ya;xa;r;c;xs;ys
          :If show                                        ⍝ recompute objects layout
              ∆objs←(∆GROUPS,[0.5]∆CONTROLS),(∆ADD,⎕NULL)
              (r c)←⍴∆objs ⋄ ys←0 Gui.SPACE 0 ⋄ xs←0,((c-1)⍴Gui.SPACE),0 ⋄ ya←(¯1 0) ⋄ xa←¯1                                     ⍝ spread control col-wise
              :If ~ROWWISE ⋄ ∆objs←⍉∆objs ⋄ ((ys xs)(ya xa))←⌽¨(ys xs)(ya xa) ⋄ :EndIf
              ∆objs Gui.LayoutGrid ys xs ya xa 1
              Gui.Reconfigure ∆CHILD           ⍝ allow ScrollSubForm to reconfigure - LayoutGrid simply resizes it
          :EndIf
          ⎕THIS Gui.Redraw 3×show                            ⍝ start/stop redrawing
        ∇
        ∇ {∆controls}←callback Add args;∆control;∆group;∆objs;ya;xa   ⍝ argument is a list of arguments to control constructor
          ∆controls←⍬
          :For args :In args
              ∆GROUPS,←∆group←∆CHILD Gui.BuildSubForm ⍬
              ∆UPS,←∆objs←∆group CreateButton{⍵:'←' ⋄ '↑'}ROWWISE
              ∆REMOVES,←∆objs,←∆group CreateButton'-'
              ∆DOWNS,←∆objs,←∆group CreateButton{⍵:'→' ⋄ '↓'}ROWWISE
              ∆objs←,[0.5]∆objs ⋄ ya←¯1 ⋄ xa←¯1 0 1
              :If ~ROWWISE ⋄ ∆objs←⍉∆objs ⋄ (ya xa)←⌽(ya xa) ⋄ :EndIf
              ∆objs Gui.LayoutGrid 0 0 ya xa 0
              ∆CONTROLS,←∆controls,←∆control←∆CHILD.⎕NEW ∆CONTROL args
              :If callback ⋄ 1 ⎕NQ ⎕THIS ADD ∆control ⋄ :EndIf
          :EndFor
        ∇
        ∇ callback Remove ∆objs;mask                     ⍝ argument is a list of ∆REMOVES buttons
          :If ∨/mask←∆REMOVES∊∆objs
              :If callback ⋄ {1 ⎕NQ ⎕THIS REMOVE ⍵}¨mask/∆CONTROLS ⋄ :EndIf
              Gui.Close¨∊mask∘/¨∆CONTROLS ∆GROUPS  ⍝ make sure GUI objects disappear
              (∆REMOVES ∆CONTROLS ∆GROUPS ∆UPS ∆DOWNS)←(~mask)∘/¨∆REMOVES ∆CONTROLS ∆GROUPS ∆UPS ∆DOWNS
          :EndIf
        ∇
        ∇ Move mask                                     ⍝ exchange two items
          :If 2<+/mask ⋄ Gui.Error'Replicator internal error' ⋄ :EndIf
          (mask/∆CONTROLS)←⌽(mask/∆CONTROLS)
          (mask/∆GROUPS)←⌽(mask/∆GROUPS)
          (mask/∆REMOVES)←⌽(mask/∆REMOVES)
          (mask/∆UPS)←⌽(mask/∆UPS)
          (mask/∆DOWNS)←⌽(mask/∆DOWNS)
        ∇
        ∇ {msg}←UpdateReplicator msg;∆obj;mask;∆form;add;rem⍝ callback on ∆ADD,∆REMOVES,∆UPS,∆DOWNS
          Show 0
          :If add←∆ADD≡∆obj←⊃msg ⋄ 1 Add⊂ARGS               ⍝ callback
          :ElseIf rem←∨/mask←∆obj=∆REMOVES ⋄ 1 Remove⊂∆obj  ⍝ callback
          :ElseIf ∨/mask←∆obj=∆UPS ⋄ Move mask∨1↓mask,0
          :ElseIf ∨/mask←∆obj=∆DOWNS ⋄ Move mask∨0,¯1↓mask
          :Else ⋄ Gui.Error'Unhandled object' ⋄ :EndIf
          Show 1
          :If add ⋄ 1 ⎕NQ ⎕THIS ADDED                       ⍝ callback
          :ElseIf rem ⋄ 1 ⎕NQ ⎕THIS REMOVED                 ⍝ callback
          :Else ⋄ 1 ⎕NQ ⎕THIS MOVED ⋄ :EndIf                ⍝ callback
        ∇
        ∇ {∆controls}←SetControls args;∆form                ⍝ Set number of controls, providing contructor arguments for each
          :Access Public
          Show 0 ⋄ 0 Remove ∆REMOVES ⋄ ∆controls←0 Add args ⋄ Show 1  ⍝ do not callback
        ∇
        ∇ {∆controls}←AddControls args
          :Access Public
          :If 0∊⍴args ⋄ :Return ⋄ :EndIf
          Show 0 ⋄ ∆controls←0 Add args ⋄ Show 1            ⍝ do not callback
        ∇
        ∇ RemoveControls mask
          :Access Public
          :If ~∨/mask ⋄ :Return ⋄ :EndIf
          Show 0 ⋄ 0 Remove mask/∆REMOVES ⋄ Show 1          ⍝ do not callback
        ∇
        ∇ ∆controls←GetControls                 ⍝ Get handles to controls
          :Access Public
          ∆controls←∆CONTROLS
        ∇
    :EndClass

    :endSection




⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section Ctrls_Base
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

    :Namespace CustomControl
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        ⍝ A custom control reflects its full status by a single array (its value).
        ⍝ The SetValue and GetValue methods must be overriden to read/write that value.
        ⍝ The SetSource and GetSource methods can be overriden to manipulate the executable expression that will produce the value through Util.Exec
        ⍝ Whenever its value is changed through some sub-input,
        ⍝ it calls a public callback function in the specified namespace with the specified name.
        ⍝ At that point, the GetValue/GetSource must be ready to provide an updated result.
        ⍝ That callback function takes one arguments (control reference) and does not return a result.
        ⍝   ∇ MyCallBack ∆ctrl
        ⍝     :Access Public
        ⍝     ⎕←∆ctrl 'was changed to :' ∆ctrl.GetValue
        ⍝   ∇
        ⍝ The CustomControl can built this way :
        ⍝   instance←⎕NEW CustomControl (⎕THIS 'MyCallBack')
        ⍝!!! unfortunately Custom callbacks should not be called from Constructors/Destructors

        ⍝!!! Dyalog should allow :Field in :Namespace
        ⍝:Field Private ∆CALLNS←⎕NULL       ⍝ Namespace reference where callback function publicly lies
        ⍝:Field Private CALLFN←''           ⍝ Name of the callback function
        ∇ CustomConstructor(∆callns callfn);y;x
          :Access Public
          :If (9≠⎕NC'∆callns')∨(~Util.IsText callfn) ⋄ ⎕SIGNAL 11 ⋄ :EndIf
          (∆CALLNS CALLFN)←∆callns callfn   ⍝ store callback info
        ∇
        ∇ CustomCallback                    ⍝ call the callback with updated value
          :Access Public
          :If 0∊⍴CALLFN ⋄ :Return ⋄ :EndIf  ⍝ no callback defined
          :If 3≠⌊|∆CALLNS.⎕NC⊂CALLFN ⋄ Gui.Error'Undefined callback :',CALLFN ⋄ :EndIf
          (∆CALLNS.⍎CALLFN)⎕THIS
        ∇
        ∇ r←CustomShow ∆ctrl;Wrap               ⍝ simple callback for CustomControl
          :Access Public Shared
          Wrap←{'<',(⍕⍵),'>'}
          Gui.Debug'CustomShow: ctrl='(Wrap ∆ctrl)'⋄ val ='(Wrap GetValue ∆ctrl)'⋄ src ='(Wrap GetSource ∆ctrl)
        ∇
        ∇ ∆ctrl SetValue value
          :If 3=⌊|∆ctrl.⎕NC⊂'SetValue' ⋄ ∆ctrl.SetValue value
          :ElseIf 3=⌊|∆ctrl.⎕NC⊂'SetSource' ⋄ ∆ctrl.SetSource Util.Source value
          :Else ⋄ Gui.Error'Cannot set value from',⍕∆ctrl ⋄ :EndIf
        ∇
        ∇ value←GetValue ∆ctrl
          :If 3=⌊|∆ctrl.⎕NC⊂'GetValue' ⋄ value←∆ctrl.GetValue
          :ElseIf 3=⌊|∆ctrl.⎕NC⊂'GetSource' ⋄ value←0 ¯1 Util.Exec ∆ctrl.GetSource
          :Else ⋄ Gui.Error'Cannot get value from',⍕∆ctrl ⋄ :EndIf
        ∇
        ∇ ∆ctrl SetSource expr
          :If 3=⌊|∆ctrl.⎕NC⊂'SetSource' ⋄ ∆ctrl.SetSource expr
          :ElseIf 3=⌊|∆ctrl.⎕NC⊂'SetValue' ⋄ ∆ctrl.SetValue 0 ¯1 Util.Exec expr
          :Else ⋄ Gui.Error'Cannot set source from',⍕∆ctrl ⋄ :EndIf
        ∇
        ∇ expr←GetSource ∆ctrl
          :If 3=⌊|∆ctrl.⎕NC⊂'GetSource' ⋄ expr←∆ctrl.GetSource
          :ElseIf 3=⌊|∆ctrl.⎕NC⊂'GetValue' ⋄ expr←Util.Source ∆ctrl.GetValue
          :Else ⋄ Gui.Error'Cannot get source from',⍕∆ctrl ⋄ :EndIf
        ∇
    :EndNamespace
    :Class CustomForm : Form
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Include CustomControl
        ∇ CustomFormConstructor(∆ns fn)
          :Access Public
          :Implements Constructor :Base ⍬
          CustomConstructor(∆ns fn)
        ∇
    :EndClass
    :Class CustomSubForm : 'SubForm'
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Include CustomControl
        ∇ CustomSubFormConstructor(∆ns fn)
          :Access Public
          :Implements Constructor :Base SubForm.Args
          CustomConstructor(∆ns fn)
        ∇
    :EndClass
    :Class CustomGroup : 'Group'
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Include CustomControl
        ∇ CustomGroupConstructor(∆ns fn)
          :Access Public
          :Implements Constructor :Base Group.Args
          CustomConstructor(∆ns fn)
        ∇
    :EndClass

    :EndSection




⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section Ctrls_Value ⍝ (CustomControls having SetValue/GetValue)
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

    :Class Boolean : 'Button'
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Include CustomControl
        ∇ BooleanConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base (('Style' 'Check')('Caption' '')('Coord'Gui.COORD)('BCol'Gui.BCOL))
          CustomConstructor ∆callns callfn
          ⎕THIS.onSelect←'CustomCallback'
        ∇
        ∇ SetValue value                        ⍝ Value setter
          :Access Public
          ⎕THIS.State←value
        ∇
        ∇ value←GetValue                        ⍝ Value getter
          :Access Public
          value←⎕THIS.State
        ∇
    :EndClass

    :Class NumTextEdit : Edit                   ⍝ CustomControl for a number or a string
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Include CustomControl
        :Field Private TEXT                     ⍝ Flag : 1 for text
        ∇ NumTextEditConstructor(type ∆callns callfn);args
          :Access Public
          :Implements Constructor :Base type
          CustomConstructor ∆callns callfn
          TEXT←type≡'Text'
          ⎕THIS.onChange←'CustomCallback'       ⍝ GetValue will be ready
        ∇
        ∇ SetValue value                        ⍝ Value setter
          :Access Public
          ⎕THIS.Value←value
        ∇
        ∇ value←GetValue                        ⍝ Value getter
          :Access Public
          value←⎕THIS.Value
          :If TEXT ⋄ value←,value ⋄ :EndIf
        ∇
    :EndClass
    :Class TextEdit:NumTextEdit                 ⍝ CustomControl for a string
        ∇ TextEditConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base 'Text' ∆callns callfn
        ∇
    :EndClass
    :Class NumEdit:NumTextEdit                  ⍝ CustomControl for a number
        ∇ NumEditConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base 'Numeric' ∆callns callfn
        ∇
    :EndClass
    :Class Filename:TextEdit                 ⍝ CustomControl for a filename
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field FILTERS                          ⍝ list of file file filters
        :Field WRITE                            ⍝ flag : will we write to file ? or just read it.
        ∇ FilenameConstructor(write filters ∆callns callfn)
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          :If ~(⊂'*.*')∊⊃¨filters ⋄ filters,←⊂'*.*' 'All Files (*.*)' ⋄ :EndIf
          FILTERS←filters ⋄ WRITE←write
          ⎕THIS Gui.Tip'Enter a file name, or double-click to browse for a file.' 'Use the ]CD user command to know the current working directory.'
          ⎕THIS.onMouseDblClick←'BrowseFile'
        ∇
        ∇ {msg}←BrowseFile msg;file
          :Access Public   ⍝ called by OptionsPane.UpdateTitle
          SetValue file←1⊃Gui.FileBox''WRITE FILTERS
          :If ~0∊⍴file                                ⍝ give up if no file
              ⎕NUNTIE Util.FileTie file WRITE 0       ⍝ warn if cannot use file
              CustomCallback
          :EndIf
        ∇
    :EndClass
    :Class PngFilename:Filename
        ∇ PngFilenameConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base  1 (⊂'*.png' 'Portable Network Graphics (*.png)')∆callns callfn
        ∇
    :endClass
    :Class SvgFilename:Filename
        ∇ SvgFilenameConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base  1 (⊂'*.svg' 'Scalable Vector Graphics (*.svg)')∆callns callfn
        ∇
    :EndClass
    :Class PdfFilename:Filename
        ∇ PdfFilenameConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base  1 (⊂'*.pdf' 'Portable Document Format (*.pdf)')∆callns callfn
        ∇
    :EndClass
    :Class EpsFilename:Filename
        ∇ EpsFilenameConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base  1 (⊂'*.eps' 'Encapsulated PostScript (*.eps)')∆callns callfn
        ∇
    :EndClass
    :Class PsFilename:Filename
        ∇ PsFilenameConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base  1 (⊂'*.ps' 'PostScript (*.ps)')∆callns callfn
        ∇
    :EndClass
    :Class GifFilename:Filename
        ∇ GifFilenameConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base  1 (⊂'*.gif' 'Graphics Interchange Format (*.gif)')∆callns callfn
        ∇
    :EndClass
    :Class JpgFilename:Filename
        ∇ JpgFilenameConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base  1 (⊂'*.jpg' 'Joint Photographic Experts Group (*.jpg)')∆callns callfn
        ∇
    :EndClass
    :Class BmpFilename:Filename
        ∇ BmpFilenameConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base  1 (⊂'*.bmp' 'Bitmap (*.bmp)') ∆callns callfn
        ∇
    :EndClass
    :Class EmfFilename:Filename
        ∇ EmfFilenameConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base 1 (⊂'*.emf' 'Enhanced Windows MetaFile (*.emf)')∆callns callfn
        ∇
    :EndClass





    :Class Character: 'Edit'                    ⍝ Control for a single character
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Include CustomControl
        ∇ CharacterConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base Edit.Args 'Character'
          CustomConstructor ∆callns callfn
          ⎕THIS.onKeyPress←'KeyPress'
          ⎕THIS.(onLostFocus onChange)←⊂'EditChange'
        ∇
        ∇ {msg}←KeyPress msg                    ⍝ Callback on Key Press
          SetValue ⎕UCS 4⊃msg                   ⍝ Change text to typed character
          CustomCallback                        ⍝ callback further
          msg←0                                 ⍝ Inhibit standard text change
        ∇
        ⍝∇ {msg}←EditChange msg                  ⍝ Callback on LostFocus or Change
        ⍝  CustomCallback                        ⍝ value ready - callback further
        ⍝∇
        ∇ value←GetValue                        ⍝ Value getter
          :Access Public
          value←⊃⎕THIS.Text
        ∇
        ∇ SetValue value                        ⍝ Value setter
          :Access Public
          ⎕THIS.Text←,⊃value
        ∇
    :EndClass


    :Class TrackBar : CustomSubForm                 ⍝ Custmcontrol embedding a Track bar and an edit
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Public Shared ReadOnly Args←('Size'(23 50))('TickAlign' 'Both')('HasTicks' 0)('BCol'Gui.BCOL)
        ∇ TrackBarConstructor(limits steps ∆callns callfn);custom;args
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          args←Args
          args,←('Limits'limits)('Step'steps)
          args,←⊂('Event'(('onScroll' 'TrackScroll')('onThumbDrag' 'TrackScroll')))
          ∆TRACK←⎕NEW'TrackBar'args
          ∆EDIT←⎕NEW NumEdit(⎕THIS'TrackEdit')
          ∆EDIT ∆TRACK Gui.LayoutGrid(0)(0 Gui.SPACE 0)(¯1)(¯1 0)1
        ∇

        ∇ {msg}←TrackScroll msg                 ⍝ callback from TrackBar
          ∆EDIT.SetValue ∆TRACK.Thumb
          CustomCallback
        ∇
        ∇ TrackEdit ∆control                    ⍝ callback from Edit
          :Access Public
          ∆TRACK.Thumb←∆TRACK.Limits{(2⊃⍺)⌊(1⊃⍺)⌈⌊0.5+⍵}∆EDIT.GetValue
          :If ∆control≢⎕NULL ⋄ CustomCallback ⋄ :EndIf
        ∇
        ∇ SetValue value                        ⍝ Value setter
          :Access Public
          ∆EDIT.SetValue value
          TrackEdit ⎕NULL
        ∇
        ∇ value←GetValue                        ⍝ Value getter
          :Access Public
          value←∆EDIT.GetValue
        ∇
    :EndClass
    :Class Angle : TrackBar                     ⍝ CustomControl for an angle in degrees
        ∇ AngleConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base (0 360)(10 1) ∆callns callfn
        ∇
    :EndClass
    :Class Perspective : TrackBar               ⍝ CustomControl for Perspective
        ∇ PerspectiveConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base (0 100)(5 1) ∆callns callfn
        ∇
    :EndClass



    :Class Combo : 'Combo'                      ⍝ CustomControl for combo box on a list of values
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Include CustomControl
        :Field Private VALUES←⍬                ⍝ list of actual values selected by combo box
        ∇ ComboConstructor(values value texts width ∆callns callfn)
          :Access Public
          :Implements Constructor :Base ('Style' 'Drop')('Coord' Gui.COORD)('Size' (Gui.STDH width))
          ⎕THIS Gui.SetFont 0 0
          ⍝ Gui.Debug 'Combo Size:'(⎕THIS.Size)'Coord:'(⎕THIS.Coord)
          CustomConstructor ∆callns callfn
          ⍝ Globals
          SetValues values ⋄ SetTexts texts ⋄ SetValue value
          ⍝ Events
          ⎕THIS.onSelect←'CustomCallback'       ⍝ GetValue will be ready
        ∇
        ∇ SetValues values                      ⍝ change list of values
          :Access Public
          :If values≢∪values ⋄ Gui.Error'Non-unique values for a Combo' ⋄ :EndIf
          SetTexts VALUES←values
        ∇
        ∇ SetTexts texts                        ⍝ change displayed list of strings for values
          :Access Public
          :If (⍴texts)≢(⍴VALUES) ⋄ Gui.Error'Inconsistent diplay texts for a Combo' ⋄ :EndIf
          ⎕THIS.Items←,∘⍕¨texts
        ∇
        ∇ SetValue value;sel;mask               ⍝ Value setter
          :Access Public
          :If 0∊⍴⎕THIS.Items
              :If ~0∊⍴value ⋄ Gui.Error'Unknown value' ⋄ :EndIf
          :Else
              :If 1≠+/mask←value∘≡¨VALUES ⋄ Gui.Error'Unknown value' ⋄ :EndIf
              ⎕THIS.SelItems←mask
          :EndIf
        ∇
        ∇ value←GetValue;mask                   ⍝ Value getter
          :Access Public
          :If 1=+/mask←⎕THIS.SelItems
              value←⊃mask/VALUES
          :Else
              Gui.Error'No value available'
          :EndIf
        ∇
    :EndClass
    :Class LineStyle : Combo                    ⍝ CustomControl for a Causeway.LineStyle
        ∇ LineStyleConstructor(∆callns callfn);values;default;names
          :Access Public
          values←Causeway.LineStyle.⍎¨names←Causeway.LineStyle.⎕NL ¯2
          names,⍨¨←⊂'LineStyle.'
          default←Causeway.LineStyle.Solid
          :Implements Constructor :Base values default names 135 ∆callns callfn
        ∇
    :EndClass
    :Class FillStyle : Combo                    ⍝ CustomControl for a Causeway.FillStyle
        ∇ FillStyleConstructor(∆callns callfn);values;default;names
          :Access Public
          values←Causeway.FillStyle.⍎¨names←Causeway.FillStyle.⎕NL ¯2
          names,⍨¨←⊂'FillStyle.'
          default←Causeway.FillStyle.Solid
          :Implements Constructor :Base values default names 165 ∆callns callfn
        ∇
    :EndClass
    :Class Marker : Combo                       ⍝ CustomControl for a Causeway.Marker
        ∇ MarkerConstructor(∆callns callfn);values;default;names
          :Access Public
          values←Causeway.Marker.⍎¨names←Causeway.Marker.⎕NL ¯2
          default←Causeway.Marker.Cross
          names,⍨¨←⊂'Marker.'
          :Implements Constructor :Base values default names 115 ∆callns callfn
        ∇
    :EndClass
    :Class GroupByFunction : Combo              ⍝ CustomControl for a Causeway.GroupByFunction
        ∇ GroupByFunctionConstructor(∆callns callfn);values;default;names
          :Access Public
          values←Causeway.GroupByFunction.⍎¨names←Causeway.GroupByFunction.⎕NL ¯2
          names,⍨¨←⊂'GroupByFunction.'
          default←Causeway.GroupByFunction.Sum
          :Implements Constructor :Base values default names 155 ∆callns callfn
        ∇
    :EndClass
    :Class SvgMode : Combo                     ⍝ CustomControl for a Causeway.SvgMode
        ∇ SvgModeConstructor(∆callns callfn);values;default;names
          :Access Public
          values←Causeway.SvgMode.⍎¨names←Causeway.SvgMode.⎕NL ¯2
          names,⍨¨←⊂'SvgMode.'
          default←Causeway.SvgMode.FixedAspect
          :Implements Constructor :Base values default names 135 ∆callns callfn
        ∇
    :EndClass
    :Class EmfType : Combo                     ⍝ CustomControl for a System.Drawing.Imaging.EmfType
        ∇ EmfTypeConstructor(∆callns callfn);values;default;names
          :Access Public
          values←System.Drawing.Imaging.EmfType.⍎¨names←System.Drawing.Imaging.EmfType.⎕NL ¯2
          names,⍨¨←⊂'EmfType.'
          default←System.Drawing.Imaging.EmfType.PlusDual
          :Implements Constructor :Base values default names 135 ∆callns callfn
        ∇
    :EndClass
    :Class TextRenderingHint : Combo                     ⍝ CustomControl for a System.Drawing.Text.TextRenderingHint
        ∇ TextRenderingHintConstructor(∆callns callfn);values;default;names
          :Access Public
          values←System.Drawing.Text.TextRenderingHint.⍎¨names←System.Drawing.Text.TextRenderingHint.⎕NL ¯2
          names,⍨¨←⊂'TextRenderingHint.'
          default←System.Drawing.Imaging.Text.TextRenderingHint.AntiAlias
          :Implements Constructor :Base values default names 155 ∆callns callfn
        ∇
    :EndClass

    :Class Style : CustomSubForm                ⍝ CustomControl for a Causeway style using multiple ticks
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆TICKS                   ⍝ list of tick control
        :Field Private ∆STYLES                  ⍝ list of styles for each tick - they must be of all be of the same enum (Causeway.XXXs)
        :Field Private ∆VALUE                   ⍝ cached value
        ∇ StyleConstructor(∆styles styles value tickwidth ∆callns callfn);captions;rows;ys;xs;cols;∆ticks;allstyles;ignored
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          ∆styles←∆styles Util.GetStyles styles         ⍝ styles namespace becomes list of lists of style instances
          ∆ticks←tickwidth∘{Gui.BuildTick(⍕⍵)⍺}¨¨∆styles
          ∆VALUE←0 ⋄ (∆TICKS ∆STYLES)←∊¨(∆ticks ∆styles)
          ⍝∆TICKS.EdgeStyle←⊂'Plinth' ⍝!!!
          ⍝ Layout
          ⍝:If ~0∊⍴tickwidth ⋄ ∆ticks Gui.SetSize¨⊂Gui.STDH tickwidth ⋄ :EndIf
          ⍝:If 0∊⍴cols ⋄ rows←1 ⋄ cols←⊃⍴∆STYLES ⋄ :Else ⋄ rows←⌈(⊃⍴∆styles)÷cols ⋄ :EndIf
          ⍝∆objs←(rows cols)⍴(rows×cols)↑∆TICKS,cols⍴⎕NULL
          cols←⌈/⊃∘⍴¨∆ticks ⋄ rows←⊃⍴∆ticks
          ∆ticks←↑cols↑¨∆ticks,¨⊂cols⍴⎕NULL             ⍝ make square matrix with ⎕NULL where to tick
          (ys xs)←{0,⍵,0}¨(¯1+rows cols)⍴¨Gui.SPACE     ⍝ space only between
          ∆ticks Gui.LayoutGrid 0 xs ¯1 ¯1 0            ⍝ no y space - stick top left
          SetValue value
          ⍝ Events
          ∆TICKS.onSelect←⊂'UpdateStyle'
        ∇
        ∇ SetValue ∆value;mask                   ⍝ Value setter
          :Access Public
          ∆TICKS.State←mask←∆value∘Util.HasFlags¨∆STYLES  ⍝!!! room for speed-up
          ⍝ we silently ignore unknown styles for the public API's Wizard.SetChartOption, which doesn't know to which group styles belong to (cf. Script.SetArgs)
          ⍝ :If ∆value≢+/mask/∆STYLES ⋄ Gui.Error'Unknown style : ',⍕∆value ⋄ :EndIf
          ⍝ remember just the ones we know :
          :If ∨/mask ⋄ ∆VALUE←+/mask/,∆STYLES ⋄ :Else ⋄ ∆VALUE←0 ⋄ :EndIf  ⍝!!! Dyalog cannot do 0/∆VALUES nor +/0,∆VALUES
          ⍝Gui.Debug'Style.SetValue'value
        ∇
        ∇ ∆value←GetValue                       ⍝ Value getter
          :Access Public
          ∆value←∆VALUE
        ∇
        ∇ {msg}←UpdateStyle msg;mask            ⍝ Callback from ∆TICKS
          :If ∨/mask←,∆TICKS.State ⋄ ∆VALUE←+/mask/,∆STYLES  ⍝!!! Dyalog cannot do 0/∆VALUES nor +/0,∆VALUES
          :Else ⋄ ∆VALUE←0 ⋄ :EndIf
          ⍝Gui.Debug'Style.Update'∆VALUE
          CustomCallback                        ⍝ value ready - callback further
        ∇
    :EndClass
    :Class ZoneStyle : Style                    ⍝ CustomControl for a ZoneStyles
        ∇ ZoneStyleConstructor(∆callns callfn);styles
          :Access Public
          styles←'Intersect' 'SpanPaper' 'SpanFrame' 'SpanAxes'
          :Implements Constructor :Base Causeway.ZoneStyles styles 0 ⍬ ∆callns callfn
        ∇
    :EndClass





    :Class Color : CustomSubForm                ⍝ CustomControl for System.Drawing.Color
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆COLOR                   ⍝ Color picker button (RGB)
        :Field Private ∆LAB                     ⍝ Label for ∆ALPHA
        :Field Private ∆ALPHA                   ⍝ Alpha channel (0-255)
        :Field Private ∆VALUE                   ⍝ Cached value (System.Drawing.Color)
        ∇ ColorConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          ∆COLOR←⎕NEW'ColorButton'(('EdgeStyle' 'Plinth')('Size'(23 50)))
          ∆LAB←Gui.BuildLabel('Opacity:'⍬)
          ∆ALPHA←⎕NEW'TrackBar'(('Thumb' 255)('Limits'(9 255))('Step'(32 1)),TrackBar.Args)  ⍝!!! SharpPlot uses alpha<9 for CMYK colors (cf. #.vstub.setcolour)
          ∆COLOR ∆LAB ∆ALPHA Gui.LayoutGrid(0)(0 Gui.SPACE 0 0)(¯1)(¯1 ¯1 0)0  ⍝ stick top left - stretch track bar in width
          SetValue System.Drawing.Color.Black
          ∆COLOR.onColorChange←'ColorChange'
          ∆ALPHA.(onThumbDrag onScroll)←⊂'ColorChange'
        ∇
        ∇ SetValue ∆value;a;r;g;b                ⍝ Value Setter
          :Access Public
          ∆VALUE←∆value
          (a r g b)←(4⍴256)⊤∆value.ToArgb        ⍝ cannot silently fail
          ∆COLOR.CurrentColor←(r g b)
          ∆ALPHA.Thumb←a
        ∇
        ∇ ∆value←GetValue;r;g;b;a                ⍝ Value getter
          :Access Public
          ∆value←∆VALUE
        ∇
        ∇ {msg}←ColorChange msg;∆obj;evt;a;r;g;b⍝ Callback : something has changed
          (∆obj evt)←2↑msg
          :If ∆obj evt≡∆COLOR'ColorChange'      ⍝ event is reported before actual update - we do the job
              (r g b)←∆COLOR.CurrentColor←3⊃msg
              msg←0 ⍝ inhibit standard action
          :Else
              (r g b)←∆COLOR.CurrentColor
          :EndIf
          a←∆ALPHA.Thumb
          ∆VALUE←System.Drawing.Color.FromArgb(a r g b)
          CustomCallback                        ⍝ value is ready - callback further
        ∇
    :EndClass


    :Class LineFill : CustomSubForm             ⍝ CustomControl for a line or a fill
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private LINE                     ⍝ Flag : 1 for line, 0 for fill
        :Field Private ∆COLOR                   ⍝ Color control
        :Field Private ∆STYLE                   ⍝ LineStyle or FillStyle control
        :Field Private ∆LAB                     ⍝ Label for ∆WIDTH
        :Field Private ∆WIDTH                   ⍝ LineWidth or EdgeWidth control
        ∇ LineFillConstructor(line ∆callns callfn)
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          LINE←line
          ∆COLOR←⎕NEW Color(⎕THIS'UpdateLineFill')
          :If LINE
              ∆STYLE←⎕NEW LineStyle(⎕THIS'UpdateLineFill')
              ∆LAB←Gui.BuildLabel('Width:'⍬)
          :Else
              ∆STYLE←⎕NEW FillStyle(⎕THIS'UpdateLineFill')
              ∆LAB←Gui.BuildLabel('Edge:'⍬)
          :EndIf
          ∆WIDTH←⎕NEW NumEdit(⎕THIS'UpdateLineFill')
          ∆COLOR ∆STYLE ∆LAB ∆WIDTH Gui.LayoutGrid(0)(Gui.SPACE×0 1 1 1 0)(¯1)(¯1)0  ⍝ stick top left
        ∇
        ∇ SetValue value;∆color;∆style;width    ⍝ Value Setter
          :Access Public
          (∆color ∆style width)←value
          ∆COLOR.SetValue ∆color
          ∆STYLE.SetValue ∆style
          ∆WIDTH.SetValue width
        ∇
        ∇ value←GetValue;∆color;∆style;width    ⍝ Value getter
          :Access Public
          ∆color←∆COLOR.GetValue
          ∆style←∆STYLE.GetValue
          width←∆WIDTH.GetValue
          value←(∆color ∆style width)
        ∇
        ∇ UpdateLineFill ∆control               ⍝ Callback : something has changed
          :Access Public
          CustomCallback                        ⍝ value is ready - callback further
        ∇
    :EndClass
    :Class Background : LineFill                ⍝ CustomControl for background (Color, FillStyle, EdgeWidth)
        ∇ BackgroundConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base 0 ∆callns callfn
        ∇
    :EndClass
    :Class Line : LineFill                      ⍝ CustomControl for line (Color, LineStyle, LineWidth)
        ∇ LineConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base 1 ∆callns callfn
        ∇
    :EndClass


    :Class Arrow : CustomSubForm                ⍝ CustomControl for an arrow style (size angle FillStyle)
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆LABSIZE                 ⍝ Label for size
        :Field Private ∆SIZE                    ⍝ Size control
        :Field Private ∆LABANGLE                ⍝ Label for angle
        :Field Private ∆ANGLE                   ⍝ Angle control
        :Field Private ∆FILL                    ⍝ FillStyle control
        ∇ ArrowConstructor(∆callns callfn);∆objs
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          ⍝ Objects
          ∆objs←∆LABSIZE←Gui.BuildLabel('Size:'⍬)
          ∆objs,←∆SIZE←⎕NEW NumEdit(⎕THIS'UpdateArrow')
          ∆objs,←∆LABANGLE←Gui.BuildLabel('Angle:'⍬)
          ∆objs,←∆ANGLE←⎕NEW NumEdit(⎕THIS'UpdateArrow')
          ∆objs,←∆FILL←⎕NEW FillStyle(⎕THIS'UpdateArrow')
          ⍝ Layout
          ∆objs Gui.LayoutGrid(0)(Gui.SPACE×0 1 1 1 1 0)(¯1)(¯1)0  ⍝ stick top left
        ∇
        ∇ SetValue value;size;angle;∆fill       ⍝ Value Setter
          :Access Public
          (size angle ∆fill)←value
          ∆SIZE.SetValue size
          ∆ANGLE.SetValue angle
          ∆FILL.SetValue ∆fill
        ∇
        ∇ value←GetValue;size;angle;∆fill       ⍝ Value getter
          :Access Public
          size←∆SIZE.GetValue
          angle←∆ANGLE.GetValue
          ∆fill←∆FILL.GetValue
          value←(size angle ∆fill)
        ∇
        ∇ UpdateArrow ∆control                  ⍝ Callback : something has changed
          :Access Public
          CustomCallback                        ⍝ value is ready - callback further
        ∇
    :EndClass



    :Class Zone : CustomSubForm                 ⍝ Control for a Causeway.Zone (start stop color fillstyle)
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆VALUE                   ⍝ cached value (Causeway.Zone)
        :Field Private ∆LABMIN                  ⍝ Label for min value
        :Field Private ∆MIN                     ⍝ Min value control
        :Field Private ∆LABMAX                  ⍝ Label for max value
        :Field Private ∆MAX                     ⍝ Max value control
        :Field Private ∆COLOR                   ⍝ Color control
        :Field Private ∆FILL                    ⍝ FillStyle control
        :Field Private ∆G1                      ⍝ Group for previous controls
        :Field Private ∆LABSTYLE                ⍝ Label for style
        :Field Private ∆STYLE                   ⍝ ZoneStyles control
        :Field Private ∆G2                      ⍝ Group for style
        ∇ ZoneConstructor(∆callns callfn);∆objs
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          ⍝ Objects
          (∆G1 ∆G2)←Gui.BuildSubForm¨⍬ ⍬
          ∆objs←∆LABMIN←∆G1 Gui.BuildLabel('Start:'⍬)
          ∆objs,←∆MIN←∆G1.⎕NEW NumEdit(⎕THIS'UpdateZone')
          ∆objs,←∆LABMAX←∆G1 Gui.BuildLabel('Stop:'⍬)
          ∆objs,←∆MAX←∆G1.⎕NEW NumEdit(⎕THIS'UpdateZone')
          ∆objs,←∆COLOR←∆G1.⎕NEW Color(⎕THIS'UpdateZone')
          ∆objs,←∆FILL←∆G1.⎕NEW FillStyle(⎕THIS'UpdateZone')
          ∆objs Gui.LayoutGrid(0)(Gui.SPACE×0 1 1 1 1 1 0)¯1 ¯1 0  ⍝ stick top left
          ∆objs←∆LABSTYLE←∆G2 Gui.BuildLabel('Zone style:'⍬)
          ∆objs,←∆STYLE←∆G2.⎕NEW ZoneStyle(⎕THIS'UpdateZone')
          ∆objs Gui.LayoutGrid(0)(0 Gui.SPACE 0)¯1 ¯1 0
          (2 1⍴∆G1 ∆G2)Gui.LayoutGrid(0 Gui.SPACE 0)(0)¯1 ¯1 0  ⍝ stick top left
          SetValue ⎕NEW Causeway.Zone(0 0 System.Drawing.Color.Green Causeway.FillStyle.Opacity30 0)
        ∇
        ∇ SetValue ∆value                        ⍝ Value setter
          :Access Public
          ∆VALUE←∆value
          (∆MIN ∆MAX ∆COLOR ∆FILL ∆STYLE).SetValue ∆value.(GetStartValue GetStopValue GetRegionColor GetRegionPattern GetRegionStyle)
        ∇
        ∇ ∆value←GetValue                       ⍝ Source getter
          :Access Public
          ∆value←∆VALUE
        ∇
        ∇ UpdateZone ∆control                   ⍝ Callback : something has changed
          :Access Public
          ∆VALUE←⎕NEW Causeway.Zone((∆MIN ∆MAX ∆COLOR ∆FILL ∆STYLE).GetValue)
          CustomCallback                        ⍝ value is ready - callback further
        ∇
    :EndClass







    :Class Font : 'Edit'                        ⍝ CustomControl for Font definition (name size style color)
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :include CustomControl
        :Field Private ∆FONT                    ⍝ 'Font' object to run ChooseFont method
        :Field Private NAME                     ⍝ Font face name (character string)
        :Field Private SIZE                     ⍝ Font height in points (scalar number)
        :Field Private ∆STYLE                   ⍝ System.Drawing.FontStyle.(Regular Bold Italic Underline)
        :Field Private ∆COLOR                   ⍝ System.Drawing.Color
        ∇ FontConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base (Edit.Args 'Text'),⊂('ReadOnly' 1)
          CustomConstructor ∆callns callfn
          ∆FONT←⎕NEW⊂'Font'
          SetValue'Arial' 9 System.Drawing.FontStyle.Regular System.Drawing.Color.Black
          ⍝⎕THIS.FontObj←∆FONT
          ⎕THIS.onMouseDown←'PickFont'
        ∇
        ∇ SetValue(name size ∆style ∆color);fcol                   ⍝ Value setter
          :Access Public
          (NAME SIZE ∆STYLE ∆COLOR)←(name size ∆style ∆color)       ⍝ update copy
          ∆FONT.(PName Size)←(NAME(⌊0.5+SIZE))  ⍝!!! cannot have non-integer size
          ∆FONT.Weight←400+300×∆STYLE Util.HasFlags System.Drawing.FontStyle.Bold  ⍝!!! Bold weakly emulated
          ∆FONT.Italic←∆STYLE Util.HasFlags System.Drawing.FontStyle.Italic
          ∆FONT.Underline←∆STYLE Util.HasFlags System.Drawing.FontStyle.Underline
          ⍝fcol←(3⍴256)⊤∆COLOR.ToArgb           ⍝!!! no transparency for now
          ⍝∆FONT.FCol←fcol                      ⍝!!! can't set Font FCol - Mantis 10739
          ⎕THIS.Text←⍕name size ∆style ⍝ ∆color                     ⍝ update display - do not mention color
        ∇
        ∇ (name size ∆style ∆color)←GetValue                        ⍝ Value getter
          :Access Public
          (name size ∆style ∆color)←(NAME SIZE ∆STYLE ∆COLOR)
        ∇
        ∇ {msg}←PickFont msg;∆obj;evt;r;g;b;name;height;fixed;italic;underline;weight;angle;charset;∆style;∆color    ⍝ Something has changed
          msg←0                                            ⍝!!! Bug ? on MouseDown, if msg is returned, this callback is called repetitively
          :If 0≡r←∆FONT.ChooseFont'' 1 ⋄ :Return ⋄ :EndIf  ⍝ Nothing happened
          (name height fixed italic underline weight angle charset)←1⊃r
          (r g b)←2⊃r
          ∆style←+/1(weight>500)italic underline/System.Drawing.FontStyle.(Regular Bold Italic Underline)  ⍝!!! Bold weakly emulated
          :If r g b∧.=0
              ∆color←System.Drawing.Color.Black               ⍝!!! user probably didn't mean it (Mantis 10739)
          :Else
              ∆color←System.Drawing.Color.FromArgb 255 r g b  ⍝!!! no transparency for now
          :EndIf
          SetValue name height ∆style ∆color              ⍝ update globals
          CustomCallback                                  ⍝ value is ready - callback further
        ∇
    :EndClass

    :Class ColorFont : CustomSubForm    ⍝ wrapper around Font to handle color separately (cf Mantis 10739)
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆FONT                    ⍝ instance of our custom Font class
        :Field Private ∆COLOR                   ⍝ instance of our custom Color class
        ∇ ColorFontConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          ∆FONT←⎕NEW Font(⎕THIS'UpdateColorFont')
          ∆COLOR←⎕NEW Color(⎕THIS'UpdateColorFont')
          (∆FONT ∆COLOR)Gui.LayoutGrid(0)(0 Gui.SPACE 0)(¯1)(0 1)1
        ∇
        ∇ SetValue(name size ∆style ∆color);fcol                   ⍝ Value setter
          :Access Public
          ∆FONT.SetValue(name size ∆style ∆color)  ⍝!!! ∆color is ignored - Mantis 10739
          ∆COLOR.SetValue(∆color)
        ∇
        ∇ (name size ∆style ∆color)←GetValue                        ⍝ Value getter
          :Access Public
          (name size ∆style ∆color)←∆FONT.GetValue ⍝!!! ∆color is ignored - Mantis 10739
          ∆color←∆COLOR.GetValue
        ∇
        ∇ UpdateColorFont ∆object;∆color
          :Access Public
          :If ∆object≡∆FONT
          :AndIf System.Drawing.Color.Black≢∆color←4⊃∆FONT.GetValue  ⍝ user did pick some color
              ∆COLOR.SetValue ∆color
          :EndIf
          CustomCallback
        ∇
    :EndClass



    :Class Title : CustomSubForm                    ⍝ CustomControl for a Title in an OptionsPane
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆TICK                        ⍝ Optional Tick control
        :Field Private ∆LAB                         ⍝ Title caption
        :Field Private ∆MENU                        ⍝ Menu to get help
        :Field Private HELPID                       ⍝ Help id to pop up
        ∇ TitleConstructor(caption width togglable toggled helpid ∆callns callfn);labw;∆objs;tip
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          ⎕THIS.EdgeStyle←'Plinth'
          labw←width
          :If togglable
              ∆objs←,∆TICK←⎕THIS Gui.BuildTick'' 13
              :If ~0∊⍴width
                  labw←width-Gui.SPACE+2⊃∆TICK.Size
              :EndIf
          :Else                                     ⍝ Emulate a Tick with a Namespace
              ∆TICK←⎕NS''
              ∆objs←⍬
          :EndIf
          ∆TICK.State←toggled
          HELPID←helpid
          ∆objs,←∆LAB←⎕THIS Gui.BuildLabel caption labw
          ∆objs Gui.LayoutGrid 0 Gui.SPACE ¯1 ¯1 0
          ∆objs←1 togglable 1/⎕THIS ∆TICK ∆LAB      ⍝ emulated tick is not a control
          ∆objs.onMouseDown←⊂'TitleClick'
          tip←'(right-click for help)'
          :If togglable ⋄ tip,⍨←'Tick to use custom settings, untick for factory defaults ' ⋄ :EndIf
          ∆objs Gui.Tip¨⊂tip
        ∇
        ∇ {msg}←TitleClick msg;∆obj;evt;y;x;button;shift
          (∆obj evt y x button shift)←msg
          :If (button=1)∧('Button'≡∆TICK ⎕WG'Type') ⍝ left-click : toggling checkbox
              ∆TICK.State←~∆TICK.State
              CustomCallback
          :ElseIf (button=2)                        ⍝ right-click : show help
              Gui.ShowHelp HELPID
          :EndIf
          msg←0                                     ⍝ inhibit MouseDown event
        ∇
        ∇ value←GetValue                            ⍝ Value getter
          :Access Public
          value←∆TICK.State
        ∇
        ∇ SetValue value                            ⍝ Value setter
          :Access Public
          ∆TICK.State←value
        ∇
    :EndClass


    :Class TickMarks : CustomSubForm            ⍝ CustomControl for TickMarks
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆G1                      ⍝ group for major/minor tickmarks
        :Field Private ∆MAJORTICK               ⍝ tick for major
        :Field Private ∆MAJOR                   ⍝ major CustomControl (NumEdit)
        :Field Private ∆MINORTICK               ⍝ tick for minor
        :Field Private ∆MINOR                   ⍝ minor CustomControl (NumEdit)
        :Field Private ∆G2                      ⍝ group for custom tickmarks
        :Field Private ∆CUSTOMTICK              ⍝ tick for custom
        :Field Private ∆CUSTOM                  ⍝ custom tickmarks CustomControl (PopupExpression_n)
        :Field Private SOURCE                   ⍝ this is a Source-based CustomControl (to remember the expression for custom tickmarks)
        :Field Public Shared ReadOnly DEFAULTS←(',⊂⍬') (,'1') ('1 1')    ⍝ TickMarks accept three overloads : (double[] custom) (double major) (double major, int minor)
        ∇ TickMarksConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          ⍝ Objects
          (∆G1 ∆G2)←Gui.BuildSubForm¨⍬ ⍬
          ∆MAJORTICK←∆G1 Gui.BuildTick'Major:' 60
          ∆MAJOR←∆G1.⎕NEW NumEdit(⎕THIS'UpdateTickMarks')
          ∆MINORTICK←∆G1 Gui.BuildTick'Minor:' 60
          ∆MINOR←∆G1.⎕NEW NumEdit(⎕THIS'UpdateTickMarks')
          ∆CUSTOMTICK←∆G2 Gui.BuildTick'Custom:' 60
          ∆CUSTOM←∆G2.⎕NEW PopupExpression_n(⎕THIS'UpdateTickMarks')
          ⍝ Layout
          (∆MAJORTICK ∆MAJOR ∆MINORTICK ∆MINOR)Gui.LayoutGrid(0)(0 1 1 1 0×Gui.SPACE)¯1 ¯1 0
          (∆CUSTOMTICK ∆CUSTOM)Gui.LayoutGrid(0)(0 Gui.SPACE 0)(¯1)(¯1 0)1
          (2 1⍴∆G1 ∆G2)Gui.LayoutGrid(0 Gui.SPACE 0)(0)¯1 0 1
          ⍝ Events
          (∆MAJORTICK ∆MINORTICK ∆CUSTOMTICK).onSelect←⊂'Tick'
        ∇
        ∇ SetSource source;depth;ticks;length;value;num            ⍝ Source setter
          :Access Public
          value←0 1 Util.Exec source ⋄ depth←≡value ⋄ length←⍴value ⋄ num←Util.IsNum value
          :If (num)∧(0=depth)                           ⍝ only major tickmarks
              ticks←1 0 0
              ∆MAJOR.SetValue⊃value
          :ElseIf (num)∧(1=depth)∧(2=length)            ⍝ major+minor tickmarks
              ticks←1 1 0
              ∆MAJOR.SetValue 1⊃value
              ∆MINOR.SetValue 2⊃value
          :Else                                       ⍝ custom tickmarks
              ⍝!!! need proper Prefix API
              :If ',⊂'≢2↑source ⋄ Gui.Error'Invalid custom tickmarks'   ⍝ any custom tickmarks expression should be enclosed
              :Else ⋄ source←2↓source ⋄ :EndIf
              ticks←0 0 1
              ∆CUSTOM.SetSource source
          :EndIf
          SOURCE←source
          (∆MAJORTICK ∆MINORTICK ∆CUSTOMTICK).State←ticks
        ∇
        ∇ source←GetSource                      ⍝ Source getter
          :Access Public
          source←SOURCE
        ∇
        ∇ {msg}←Tick msg;∆tick                  ⍝ Callback from ticks
          :Select ∆tick←⊃msg
          :Case ∆MAJORTICK
              :If ~∆MAJORTICK.State ⋄ ∆MINORTICK.State←0 ⋄ :EndIf
              ∆CUSTOMTICK.State←0
          :Case ∆MINORTICK
              :If ∆MINORTICK.State ⋄ ∆MAJORTICK.State←1 ⋄ :EndIf  ⍝ enabling minor enabled major
              ∆CUSTOMTICK.State←0
          :Case ∆CUSTOMTICK
              (∆MAJORTICK ∆MINORTICK).State←0
          :Else
              Gui.Error'Unhandled control'
          :EndSelect
          UpdateTickMarks ⎕NULL                 ⍝ Update value and callback further
        ∇
        ∇ UpdateTickMarks ∆ctrl;value                 ⍝ Callback from CustomControls
          :Access Public
          :If ∆MAJORTICK.State                  ⍝ Major tickmarks
              :If ∆CUSTOMTICK.State ⋄ Gui.Error'Inconsistent TickMarks control' ⋄ :EndIf
              value←∆MAJOR.GetValue
              :If ∆MINORTICK.State              ⍝ Major+Minor tickmarks
                  value,←∆MINOR.GetValue
              :EndIf
              SOURCE←Util.Source value
          :ElseIf ∆CUSTOMTICK.State             ⍝ Custom tickmarks
              :If ∨/(∆MAJORTICK ∆MINORTICK).State ⋄ Gui.Error'Inconsistent TickMarks control' ⋄ :EndIf
              ⍝!!! need proper Prefix API
              SOURCE←',⊂',∆CUSTOM.GetSource
          :Else                                 ⍝ no tickmarks ⍝!!! expression will not be saved
              SOURCE←⊃DEFAULTS
          :EndIf
          CustomCallback                        ⍝ value is ready - callback further
        ∇
    :EndClass

    :EndSection


⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section Ctrls_MultiValue
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝


    :Class Lister : CustomSubForm               ⍝ CustomControl for a vector of CustomControls using a list view
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private VALUES                   ⍝ cached list of values
        :Field Private MASK                     ⍝ mask of selected value (∆LIST.SelItems may lose track when losing focus)
        :Field Private ∆ADD                     ⍝ button to add item to list
        :Field Private ∆REMOVE                  ⍝ button to remove item from list
        :Field Private ∆GB                      ⍝ group for add and remove buttons
        :Field Private ∆LIST                    ⍝ list object
        :Field Private ∆GL                      ⍝ group for list an buttons
        :Field Private ∆CONTROL                 ⍝ control object
        ∇ ListConstructor(below ∆control ∆callns callfn);items
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          ∆GL←Gui.BuildSubForm ⍬
          ∆GB←∆GL Gui.BuildSubForm ⍬
          ∆ADD←∆GB.⎕NEW'Button'(⊂('Caption' 'Add'))
          ∆REMOVE←∆GB.⎕NEW'Button'(⊂('Caption' 'Remove'))
          ∆LIST←∆GL.⎕NEW'List'(('Style' 'Single')('BCol'Gui.BCOL))
          ∆CONTROL←⎕NEW ∆control(⎕THIS'UpdateList')         ⍝ callback
          ∆ADD ∆REMOVE ∆LIST Gui.SetSize¨(Gui.STDH Gui.STDW)(Gui.STDH Gui.STDW)(200 150)
          :If below
              (2 1⍴∆ADD ∆REMOVE)Gui.LayoutGrid(Gui.SPACE)(0)¯1 ¯1 0            ⍝ stick top left
              (∆GB ∆LIST)Gui.LayoutGrid(0)(0 Gui.SPACE 0)(0)(¯1 0)0            ⍝ stretch list width only - stretch all heights
              (2 1⍴∆CONTROL ∆GL)Gui.LayoutGrid(0 Gui.SPACE 0)(0)(¯1 0)(0)1     ⍝ strech control height only - stretch all widths
          :Else
              (∆ADD ∆REMOVE)Gui.LayoutGrid(0)(Gui.SPACE)¯1 ¯1 0                ⍝ stick top left
              (2 1⍴∆GB ∆LIST)Gui.LayoutGrid(0 Gui.SPACE 0)(0)(¯1 0)(0)0        ⍝ stretch list height only - stretch all widths
              (∆GL ∆CONTROL)Gui.LayoutGrid(0)(0 Gui.SPACE 0)(0)(¯1 0)1         ⍝ strech control width only - stretch all heights
          :EndIf
          VALUES←⍬ ⋄ MASK←⍬ ⋄ SetValue ⍬
          ∆ADD.onSelect←'ListAdd'
          ∆REMOVE.onSelect←'ListRemove'
          ∆LIST.onSelect←'ListSelect'
          ⍝!!! no onClose handler - won't work with Gui.Close
        ∇
        ∇ SetValue value                        ⍝ Value setter
          :Access Public
          :If 0∊⍴value ⋄ value←(⍴value)⍴⍬ ⋄ :EndIf ⍝ clean out prototype - value could be a vector of refs
          VALUES←value ⋄ ∆LIST.Items←⍕¨value
          MASK←(⍴VALUES)↑MASK                   ⍝ widen mask
          :If (~0∊⍴MASK)∧(~∨/MASK)              ⍝ no selection yet there should be
              MASK←(¯1↓MASK),1                  ⍝ pick last
          :EndIf
          ∆LIST.SelItems←MASK                   ⍝ update ∆LIST selection
          ListSelect'fake_msg'                  ⍝ apply selection (as if user clicked)
        ∇
        ∇ value←GetValue                        ⍝ Value getter
          :Access Public
          value←VALUES
        ∇
        ∇ {msg}←ListSelect msg;mask             ⍝ callback : selected a list item
          mask←<\∆LIST.SelItems
          :If (0∊⍴mask) ⋄ :Return ⋄ :EndIf      ⍝ nothing to do
          :If ∨/mask ⋄ MASK←mask ⋄ :EndIf       ⍝ list may be shorter or ∆LIST may have lost track - in which case don't update MASK
          ∆LIST.SelItems←MASK                   ⍝ update ∆LIST selection
          ∆CONTROL.SetValue⊃MASK/VALUES         ⍝ update ∆CONTROL with newly selected value
          1 ⎕NQ ∆CONTROL'GotFocus'∆LIST         ⍝ give focus to control ⍝!!! doesn't work !!!
        ∇
        ∇ {msg}←ListAdd msg;mask                ⍝ callback : add a new value
          :If 0∊⍴MASK
              SetValue,⊂∆CONTROL.GetValue       ⍝ reinstanciate current
          :Else
              SetValue(1+MASK)/VALUES           ⍝ duplicate current
              ∆LIST.SelItems←MASK←¯1⌽MASK       ⍝ select duplicate
          :EndIf
          CustomCallback
        ∇
        ∇ {msg}←ListRemove msg                  ⍝ callback to remove a value
          SetValue(~MASK)/VALUES
          CustomCallback
        ∇
        ∇ UpdateList ∆ctrl;val                  ⍝ callback from ∆CONTROL
          :Access Public
          val←∆ctrl.GetValue
          :If ~0∊⍴VALUES
              (⊃MASK/VALUES)←val                ⍝ update current item for getter
              (⊃MASK/∆LIST.Items)←⍕val          ⍝ update display
          :EndIf
          CustomCallback                    ⍝ value ready - callback further
        ∇
    :EndClass





    :Class PopupReplicator : 'Edit'             ⍝ CustomControl for a vector of CustomControls using a Replicator
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Include CustomControl
        :Field Private ∆CONTROL                 ⍝ Class of CustomControl to instanciate. Contructor MUST conform CustomConstructor.
        :Field Private ∆POPUP                   ⍝ Popup form for control
        :Field Private ∆PARENT                  ⍝ Parent form to build object that can not be held by an Edit
        :Field Private ∆MENU                    ⍝ Popup menu on right click
        :Field Private VALUE                    ⍝ cached value
        :Field Private CAPTION                  ⍝ Popup caption
        :Field Private ROWWISE                  ⍝ Flag for Replicator
        ∇ PopupReplicatorConstructor(caption rowwise ∆control ∆default ∆callns callfn);items;∆parent
          :Access Public
          :Implements Constructor :Base (Edit.Args'Text'),⊂('ReadOnly' 1)
          CustomConstructor ∆callns callfn
          ⎕THIS Gui.Tip'Left-click to change values, Right-click to copy/paste'
          ∆PARENT←Gui.GetParentForm ⎕THIS
          ∆POPUP←⎕NEW PopupControl(caption Replicator(7 rowwise 1 1 ∆control(⎕THIS'UpdateList')))  ⍝ 7 controls at once should be enough
          ∆MENU←∆PARENT.⎕NEW⊂'Menu'
          ∆MENU.∆COPY←∆MENU.⎕NEW'MenuItem'(('Caption' 'Copy')('Event'('onSelect' 1)))
          ∆MENU.∆PASTE←∆MENU.⎕NEW'MenuItem'(('Caption' 'Paste')('Event'('onSelect' 1)))
          SetValue ∆default
          ⎕THIS.onMouseDown←'MouseDown'
        ∇
        ∇ Close                                 ⍝ work with Gui.Close
          :Access Public
          Gui.Close ∆POPUP
        ∇
        ∇ SetValue value;sel;mask               ⍝ Value setter
          :Access Public
          ⎕THIS.Text←,⍕VALUE←value
        ∇
        ∇ value←GetValue                        ⍝ Value getter
          :Access Public
          value←VALUE
        ∇
        ∇ {msg}←MouseDown msg;∆obj;evt;y;x;but;shift
          (∆obj evt y x but shift)←msg
          :If but=1   ⍝ left-click
              PopupReplicator
          :Else       ⍝ right-click
              PopupMenu
          :EndIf
        ∇
        ∇ PopupReplicator;n;value;∆replicator                   ⍝ Pop up form
          n←⍴value←GetValue
          ∆replicator←∆POPUP.GetControl
          ∆replicator ⎕WS'Event'Replicator.(ADD MOVED REMOVED)'UpdateList'  ⍝!!! can't do this at constructor time =(
          ∆replicator.SetControls n⍴⊂⎕THIS'UpdateList'
          :If n>0 ⋄ ∆replicator.GetControls.SetValue value ⋄ :EndIf
          ∆POPUP.Show 1
        ∇
        ∇ UpdateList ∆ctrl;∆ctrls               ⍝ Callback from control
          :Access Public
          :If 0∊⍴∆ctrls←∆POPUP.GetControl.GetControls ⋄ SetValue ⍬
          :Else ⋄ SetValue ∆ctrls.GetValue ⋄ :EndIf
          CustomCallback                        ⍝ callback further
        ∇
        ∇ PopupMenu;r;thisclass;source;class;∆clip;text;mask
          thisclass←Util.RemoveBlanks⍕⎕CLASS ⎕THIS
          ∆clip←∆PARENT.⎕NEW⊂'Clipboard'
          ⍝(∆class value)←∆clip.Array ⍝!!! produces a syserror 999
          text←∆clip.Text
          :If 1=≡text                           ⍝ simple text
          :AndIf 1=+/mask←text='⍝'              ⍝ only one delimiter
              (source class)←Util.RemoveBlanks¨1↓¨(1,mask)⊂('⍝',text)
          :Else
              (source class)←(Util.EmptySource)''
          :EndIf
          ∆MENU.∆PASTE.Active←class≡thisclass
          :Select ⊃r←⎕DQ ∆MENU
          :Case ∆MENU.∆COPY
              ∆clip.Text←(Util.Source GetValue),'   ⍝ ',(thisclass)
          :Case ∆MENU.∆PASTE
              SetValue 0 0 Util.Exec source         ⍝ expect to find values in an empty sandbox
              CustomCallback                        ⍝ callback further
          :EndSelect
        ∇
    :EndClass
    :Class MultiColor : PopupReplicator         ⍝ CustomControl for a vector of System.Drawing.Color
        ∇ MultiColorConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base 'Color list' 0 Color System.Drawing.Color.Black ∆callns callfn
        ∇
    :EndClass
    :Class MultiFill : PopupReplicator          ⍝ CustomControl for a vector of Causeway.FillStyle
        ∇ MultiFillConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base 'FillStyle list' 0 FillStyle Causeway.FillStyle.Solid ∆callns callfn
        ∇
    :EndClass
    :Class MultiLine : PopupReplicator          ⍝ CustomControl for a vector of Causeway.LineStyle
        ∇ MultiLineConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base 'LineStyle list' 0 LineStyle Causeway.LineStyle.Solid ∆callns callfn
        ∇
    :EndClass
    :Class MultiMarker : PopupReplicator        ⍝ CustomControl for a vector of Causeway.Marker
        ∇ MultiMarkerConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base 'Marker list' 0 Marker Causeway.Marker.Cross ∆callns callfn
        ∇
    :EndClass
    :Class MultiZone : PopupReplicator          ⍝ CustomControl for a vector of Causeway.Zone
        ∇ MultiZoneConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base 'Zone list' 0 Zone (⎕NEW Causeway.Zone (0 0 System.Drawing.Color.Red))∆callns callfn
        ∇
    :EndClass

    :EndSection



⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section Ctrls_Source ⍝ (CustomControls having SetSource/GetSource)
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

    :Class Expression : CustomSubForm           ⍝ Custom control for an APL expression with value displayed
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private VALUE                    ⍝ Array produced by expression
        :Field Private ∆EDIT                    ⍝ Edit control
        :Field Private ∆DISP                    ⍝ Display of array
        ∇ ExpressionConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          ∆EDIT←⎕NEW Edit'Expression'           ⍝ with callbacks on key enter/esc
          ⍝∆DISP←⎕NEW'Edit'(Edit.Args'Display')  ⍝ without callbacks
          ∆DISP←⎕NEW Display(1 1 ''(⊂'BCol'(255 255 255)))
          (2 1⍴∆EDIT ∆DISP)Gui.LayoutGrid(0 Gui.SPACE 0)(0)(¯1 0)(0)1        ⍝ stretch display - stretch all widths
          ∆EDIT Gui.Tip'Enter an APL expression executed in the calling namespace'
          ∆DISP Gui.Tip'Display of the array produced by expression'
          SetSource Util.EmptySource
          ∆EDIT.onChange←'UpdateExpression'
          ⍝ resized by PopupExpression
        ∇
        ∇ Eval                                  ⍝ Evaluate expression
          ⎕THIS.onChange←0  ⍝ ugly workardound Util.Exec possibly ⎕DQing a MsgBox thereby trigger yet another 'Change' event
          ∆DISP.SetText Util.Display VALUE←1 1 Util.Exec ∆EDIT.Text
          ⎕THIS.onChange←'UpdateExpression'
        ∇
        ∇ SetValue value                        ⍝ Value setter
          :Access Public
          SetSource Util.GetSource value
        ∇
        ∇ value←GetValue                        ⍝ Value getter
          :Access Public
          value←VALUE
        ∇
        ∇ SetSource expr                        ⍝ Source setter
          :Access Public
          ∆EDIT.Text←expr ⋄ Eval
        ∇
        ∇ expr←GetSource                        ⍝ Source getter
          :Access Public
          expr←∆EDIT.Text
        ∇
        ∇ {msg}←UpdateExpression msg            ⍝ Callback on edit change
          Eval ⋄ CustomCallback                 ⍝ cache value ⋄ callback further
          ⍝ Gui.Debug'Update PopupExpression'∆EDIT.Text(↑Util.GetStackItems)
        ∇
    :EndClass

    :Class PopupExpression : Edit               ⍝ CustomControl for an expression that pops up an Expression editor
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :include CustomControl
        :Field Private ∆POPUP                   ⍝ Form for pop-up
        :Field Private VALUE                    ⍝ cached value
        :Field Private PREFIX                   ⍝ prefix to expression to produce expected format
        :Field Public Shared ReadOnly SEPARATOR←⎕UCS (1+82≠⎕DR'')⊃37 8288                      ⍝ APL-Illegal-yet-displayable unicode character
        ∇ PopupExpressionConstructor(∆callns callfn);∆parent;desc
          :Access Public
          :Implements Constructor :Base 'Expression'
          CustomConstructor ∆callns callfn
          ∆POPUP←⎕NEW PopupControl('Enter an APL Expression'Expression(⎕THIS'UpdatePopup'))
          ⎕THIS.Text←Util.EmptySource ⋄ SetFormat''
          ⎕THIS.onChange←'UpdateExpression'
          ⍝⎕THIS.onMouseDown←'PopupExpression' ⋄ ⎕THIS.ReadOnly←1
          ⎕THIS.onMouseDblClick←'PopupExpression' ⋄ ⎕THIS.ReadOnly←0
        ∇
        ∇ Close                                 ⍝ work with Gui.Close
          :Access Public
          Gui.Close ∆POPUP
        ∇
        ∇ SetFormat format;tip                  ⍝ cf Chart.(CHARTS[;ARGS])
          :Access Public
          tip←'Enter an APL expression'
          :If ~0∊⍴format
              tip,←' that produces ',(Chart.GetFormatDescription FORMAT←format),' when'
          :Else
              FORMAT←'A'
          :EndIf
          tip,←' executed in the calling namespace (double-click for display)'
          ⎕THIS Gui.Tip tip
          SetSource ⎕THIS.Text                  ⍝ update prefix
        ∇
        ∇ SetSource expr;n                      ⍝ Source setter
          :Access Public
          expr↓⍨←(1+⍴expr)|(expr←,expr)⍳SEPARATOR   ⍝ remove prefix
          Set expr(0 1 Util.Exec expr)
        ∇
        ∇ expr←GetSource                        ⍝ Source getter
          :Access Public
          expr←PREFIX,SEPARATOR,⎕THIS.Text
        ∇
        ∇ SetValue value                        ⍝ Value setter
          :Access Public
          Set(Util.Source value)value
        ∇
        ∇ value←GetValue                        ⍝ Value getter
          :Access Public
          value←VALUE
        ∇
        ∇ Set(expr value);deep;txt;prefix;nonnum;FIRST
          prefix←''
          :If (Main.GetExecNamespace ⎕THIS).⎕ML<2 ⋄ FIRST←'⊃' ⋄ :Else ⋄ FIRST←'↑' ⋄ :EndIf
          :While 1<⍴⍴value ⋄ value←↓value ⋄ prefix,⍨←'↓' ⋄ :EndWhile   ⍝ turn hi-rank into nested vectors
          :If 0=⍴⍴value ⋄ prefix,⍨←',' ⋄ :EndIf                        ⍝ turn scalar into vector
          nonnum←FORMAT∊'aA'
          :If Util.IsNum value ⋄ deep←0 ⋄ txt←0                        ⍝ numeric vector
          :ElseIf nonnum∧Util.IsText value ⋄ deep←0 ⋄ txt←1            ⍝ text vector
              value←,⊂value ⋄ prefix,⍨←',⊂'
          :ElseIf Util.IsNestedNum value ⋄ deep←1 ⋄ txt←0
              :If ~Util.IsNumVectors value ⋄ value←,¨value ⋄ prefix,⍨←',¨' ⋄ :EndIf                ⍝ non-uniform
          :ElseIf nonnum ⋄ :AndIf Util.IsNestedText value ⋄ deep←0 ⋄ txt←1
              :If ~Util.IsStrings value ⋄ value←,¨value ⋄ prefix,⍨←',¨' ⋄ :EndIf                ⍝ non-uniform
          :ElseIf nonnum ⋄ :AndIf Util.IsNestedNestedText value ⋄ deep←1 ⋄ txt←1
              :If ~Util.IsNestedStrings value ⋄ value←,¨,¨¨ ⋄ prefix,⍨←',¨,¨¨' ⋄ :EndIf               ⍝ non-uniform
          :ElseIf nonnum ⋄ :AndIf (1=|≡value) ⋄ deep←0 ⋄ txt←1
              value←,∘⍕¨value ⋄ prefix,⍨←',∘⍕¨'   ⍝ mixed scalars → vector of strings
          :ElseIf nonnum ⋄ :AndIf (2=|≡value) ⋄ deep←0 ⋄ txt←1
              value←,∘⍕¨value ⋄ prefix,⍨←',∘⍕¨'   ⍝ mixed vectors → vector of strings
          :ElseIf nonnum ⋄ deep←1 ⋄ txt←1         ⍝ trying to get text and failed - ravel-and-format-a-lot
              value←,¨,∘⍕¨¨value ⋄ prefix,⍨←',¨,∘⍕¨¨'      ⍝ vector of vectors of strings
          :Else ⋄ deep←0 ⋄ txt←1                  ⍝ trying to get a numeric and failed - can't do anything about it
          :EndIf
          :Select FORMAT
          :CaseList 'an'
              :If deep ⋄ value←⊃value ⋄ prefix,⍨←FIRST ⋄ :EndIf
          :CaseList 'AN'
              :If (~deep)∧(~0∊⍴value) ⋄ value←,⊂value ⋄ prefix,⍨←',⊂' ⋄ :EndIf
          :Else
              Gui.Error'Unknown expression format'
          :EndSelect
          VALUE←value
          PREFIX←prefix
          ⎕THIS.Text←expr
        ∇
        ∇ {msg}←PopupExpression msg;∆form       ⍝ Callback to pop up control
          ∆POPUP.GetControl.SetSource ⎕THIS.Text
          ∆POPUP.GetForm Gui.Resize 500 600
          ∆POPUP.Show 1
        ∇
        ∇ {msg}←UpdateExpression msg;expr       ⍝ callback form edit change
          expr←⎕THIS.Text
          ⎕THIS.onChange←0  ⍝ ugly workardound Util.Exec possibly ⎕DQing a MsgBox thereby trigger yet another 'Change' event
          Set expr(1 1 Util.Exec expr)
          ⎕THIS.onChange←'UpdateExpression'
          CustomCallback                        ⍝ value ready - callback further
          ⍝ Gui.Debug'Update PopupExpression'expr(↑Util.GetStackItems)
        ∇
        ∇ UpdatePopup ∆ctrl                     ⍝ callback from pop up
          :Access Public
          Set ∆POPUP.GetControl.(GetSource GetValue)   ⍝ used cached value
          CustomCallback                        ⍝ value ready - callback further
        ∇
    :EndClass
    :Class PopupExpression_n : PopupExpression  ⍝ Custom control for an expression producing a numeric vector
        ∇ PopupExpression_n_Constructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          SetFormat'n'
        ∇
    :EndClass
    :Class PopupExpression_N : PopupExpression  ⍝ Custom control for an expression producing multiple numeric vectors
        ∇ PopupExpression_N_Constructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          SetFormat'N'
        ∇
    :EndClass
    :Class PopupExpression_a : PopupExpression  ⍝ Custom control for an expression producing a vector of strings or numbers
        :Field Public Shared ReadOnly DEFAULTS←Util.EmptySource'0⍴⊂'''''  ⍝ PopupExpression_a accept two overloads (double[]) and (string[])
        ∇ PopupExpression_a_Constructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          SetFormat'a'
        ∇
    :EndClass
    :Class PopupExpression_A : PopupExpression  ⍝ Custom control for an expression producing multiple vectors of strings or numbers
        ∇ PopupExpression_A_Constructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          SetFormat'A'
        ∇
    :EndClass

    :EndSection







⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section Script_Class
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

    :Class Script
        ⍝ A class that stores a SharpPlot script as a big matrix.
        ⍝ There are three kinds of script chunks :
        ⍝ - ChartSetter→OptionsPane will use chart options (order∊1 2 4)
        ⍝ - GlobalOptions→OptionsPane will use global page options (order∊¯1 ¯2 ¯4)
        ⍝ - Series will use only SetMethodArgs/GetMethodArgs for (order∊3) series draw method scripts
        :field Public Shared ReadOnly Version←2
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆         ⍝ control matrix for properties
        :Field Public Shared ReadOnly ID←1        ⍝ ∆[;i] : Property unique identifier
        :Field Public Shared ReadOnly GROUP←2     ⍝ ∆[;i] : Property group identifier
        :Field Public Shared ReadOnly SOURCE←3    ⍝ ∆[;i] : Property value's APL expression
        :Field Public Shared ReadOnly ENABLED←4   ⍝ ∆[;i] : Id-wise Flag : is property enabled for current chart type
        :Field Public Shared ReadOnly TOUCHED←5   ⍝ ∆[;i] : Group-wise Flag : was group ever touched by user (if not - property is ignored by MergeScript)
        :Field Public Shared ReadOnly TOGGLED←6   ⍝ ∆[;i] : Group-wise flag : is group toggled by user (if not - do not call the corresponding SharpPlot API item)
        :Field Public Shared ReadOnly TYPE←7      ⍝ ∆[;i] : SharpPlot API type : 'P'=Property ⋄ 'M'=Method ⋄ 'S'=Style
        :Field Public Shared ReadOnly NAME←8      ⍝ ∆[;i] : SharpPlot API name
        :Field Public Shared ReadOnly INDEX←9     ⍝ ∆[;i] : SharpPlot API argument index (0 when argument passed as is) (negative when ignored)
        :Field Public Shared ReadOnly ORDER←10    ⍝ ∆[;i] : Script call order (see possible values below)
        :Field Public Shared ReadOnly DEFAULTS←11 ⍝ ∆[;i] : List of APL expressions for possible overloads, to check that new values are conformable. There can be only one for Properties and Styles (which cannot be overloaded). For styles, the default value indicates which flags that are control by this entry.
        :Field Public Shared ReadOnly COLS←11     ⍝ number of columns

        :Field Public Shared ReadOnly ORDPGINIT←¯1   ⍝ page size (SharpPlot constructor) - and nothing else
        :Field Public Shared ReadOnly ORDPGSET←¯2    ⍝ global settings
        :Field Public Shared ReadOnly ORDPGFIN←¯4    ⍝ save as
        :Field Public Shared ReadOnly ORDCHPAGE←0.9  ⍝ SharpPlot.NewPage - and nothing else
        :Field Public Shared ReadOnly ORDCHFRAME←1   ⍝ SharpPlot.NewFrame - and nothing else
        :Field Public Shared ReadOnly ORDCHSET←2     ⍝ chart settings
        :Field Public Shared ReadOnly ORDCHDRAW←3    ⍝ draw chart e.g. SharpPlot.DrawLineGraph
        :Field Public Shared ReadOnly ORDCHFIN←4     ⍝ after chart e.g. SharpPlot.DrawKey, SharpPlot.DrawNote
        :Field Public Shared ReadOnly ORDERS←¯1 ¯2 0.9 1 2 3 4 ¯4   ⍝ order to observe for a whole script

        ∇ Error msg
          Gui.Error'Script : ',msg
        ∇
        FMTU←{⍺←'' ⋄ ⍺,((~0∊⍴⍺)/'='),'(',(⍕{⍵[⍋⍵]}∪⍵),')'}
        ∇ ok←{ords}CheckScript script;ord;page;options;draw;ordpg;ordch;orddraw
        ⍝ check that script matrix is consistent
          ok←0
          :If 2≠⍴⍴script ⋄ :OrIf COLS≠2⊃⍴script ⋄ Error'Invalid script' ⋄ :Return
          :ElseIf 0∊⍴script ⋄ ok←1 ⋄ :Return   ⍝ empty is ok
          :EndIf
          :If ~Util.IsStrings script[;ID GROUP SOURCE]
          :OrIf ~Util.IsText script[;TYPE]
          :OrIf ~Util.IsNum script[;ENABLED TOUCHED TOGGLED INDEX ORDER]
          :OrIf ~Util.IsNestedStrings script[;DEFAULTS]
              Error'Invalid script column types' ⋄ :Return
          :EndIf
          :If (1⊃⍴script)≠⍴∪script[;ID] ⋄ Error'Non-unique IDs' ⋄ :Return ⋄ :EndIf
          :If ~∧/script[;TYPE]∊'MSP' ⋄ Error'Unknown API types' ⋄ :Return ⋄ :EndIf
          ord←script[;ORDER]
          page←∧/(ord∊ordpg←ORDPGINIT ORDPGSET ORDPGFIN)                    ⍝ page script (from GlobalOptions→OptionsPane)
          options←∧/(ord∊ordch←ORDCHPAGE ORDCHFRAME ORDCHSET ORDCHFIN)      ⍝ chart options script (from ChartSetter→OptionsPane)
          draw←∧/(ord∊orddraw←ORDCHDRAW)                                      ⍝ chart draw method script from Series
          :If 1≠+/page options draw ⋄ Error'Script has too many orders' ⋄ :Return ⋄ :EndIf
          :If page ⋄ :AndIf 1<⍴∪(ORDPGINIT=ord)/script[;GROUP] ⋄ Error'Multiple global initialisers' ⋄ :Return ⋄ :EndIf
          :If options ⋄ :AndIf 1<⍴∪(ORDCHPAGE=ord)/script[;GROUP] ⋄ Error'Multiple chart page initialisers' ⋄ :Return ⋄ :EndIf
          :If options ⋄ :AndIf 1<⍴∪(ORDCHFRAME=ord)/script[;GROUP] ⋄ Error'Multiple chart frame initialisers' ⋄ :Return ⋄ :EndIf
          :If draw ⋄ :AndIf ~∧/('M'=script[;TYPE]),(,script[;ENABLED TOUCHED TOGGLED]),(1=⍴∪,script[;NAME GROUP]) ⋄ Error'Invalid series draw script' ⋄ :Return ⋄ :EndIf
          :If 0≠⎕NC'ords' ⋄ :AndIf ~∧/ords∊⊃page options draw/ordpg ordch orddraw ⋄ Gui.Error'Mixed script chunks' ⋄ :Return ⋄ :EndIf
          ok←1
        ∇
        ∇ ok←issource ConformsDefaults(value defaults index type);default;value
        ⍝ check that value conforms to defaults
          ok←0
          :If issource ⋄ value←¯1 1 Util.Exec Util.StripSource value ⋄ :EndIf
          defaults←¯1 0∘Util.Exec∘Util.StripSource¨defaults  ⍝ defaults can be executed in a sandbox
          :If (type∊'PS')∧((1≠⍴defaults)∨(0≠index)) ⋄ Error'Inconsistent script' ⋄ :EndIf  ⍝ properties can not have overloads nor multiple arguments
          :For default :In defaults
              :If type='S'
                  :If index≠0 ⋄ Error'Style index is not 0' ⋄ :EndIf
                  :If default≡0 ⋄ Error'Unspecified style default' ⋄ :EndIf
                  :If value≡0
                      ok←1
                  :Else
                      :Trap 0 ⋄ ok←(⎕CLASS value)≡(⎕CLASS default) ⋄ :EndTrap                    ⍝ ⎕CLASS will fail if not scalar reference
                  :EndIf
              :Else
                  ok←((≡default)≡(≡value))∧((⍴⍴default)≡(⍴⍴value))
                  :If (type='M')∧(index=0)   ⍝ value is a list of arguments - check one level deeper
                      ok∧←((⍴default)≡(⍴value))∧((≡¨default)≡(≡¨value))∧((⍴∘⍴¨default)≡(⍴∘⍴¨value))
                  :EndIf
              :EndIf
              :If ok ⋄ :Return ⋄ :EndIf ⍝ found a conformable default
          :EndFor
        ∇
        ∇ ScriptNiladicConstructor              ⍝ create an empty script
          :Access Public
          :Implements Constructor
          ∆←0 COLS⍴⍬
        ∇
        ∇ ScriptMonadicConstructor script      ⍝ initialise script from argument (deep copy)
          :Access Public
          :Implements Constructor
          ∆←0 COLS⍴⍬
          SetValue script
        ∇
        ∇ script←GetValue                       ⍝ value getter
          :Access Public
          script←∆
        ∇
        ∇ SetValue script                       ⍝ value setter
          :Access Public
          :If ~(∪∆[;ORDER])CheckScript script ⋄ :Return ⋄ :EndIf
          ∆←script
        ∇
        ∇ AddItem(id group source toggle type name arg order defaults);x   ⍝ add a new item to current script - happens only when initialising OptionsPane
          :Access Public
          :If (⊂id)∊∆[;ID] ⋄ Error'AddItem: Duplicate id: ',(⍕id) ⋄ :EndIf
          ∆⍪←id group source 1 0 toggle type name arg order defaults        ⍝ enable←1 ⋄ touched←0
        ∇
        ∇ MergeScript script;inx;mask  ⍝ override this script entries with argument's
          :Access Public
          :If ~(∪∆[;ORDER])CheckScript script ⋄ :Return ⋄ :EndIf
          script←script[;TOUCHED]⌿script    ⍝ ignore untouched settings
          inx←∆[;ID]⍳script[;ID]
          mask←inx≤1⊃⍴∆
          ∆[mask/inx;]←mask⌿script          ⍝ merge known ids
          ∆⍪←(~mask)⌿script                 ⍝ add unknown ids
        ∇
        ∇ (inx mask)←FindIds ids;mask;inx;matches;mat
          matches←+/mat←(ids←,ids)∘.≡∆[;ID]
          :If ~∧/mask←1=matches
              Error'Sources: Missing ids: [',(⍕(0=matches)/ids),'] Non-unique ids: [',(⍕(1<matches)/ids),']'
          :EndIf
          inx←(1⊃⍴∆)∘{⊃⍵/⍳⍺}¨↓mask⌿mat
        ∇
        ∇ {groups}←SetSources(ids sources);inx;mask;id;source;type;name;oldsources;old;new;Dismember;diff            ⍝ set source expressions for script ids
          :Access Public
          (inx mask)←FindIds ids
          ⍝!!! don't check conformability because source could be a wrongful expression from a PopupExpression
          ⍝:If ~∧/1∘ConformsDefaults¨↓⍉↑(mask/sources)(∆[inx;DEFAULTS])(∆[inx;INDEX])(∆[inx;TYPE]) ⋄ Error'Unconformable value' ⋄ :EndIf
          oldsources←∆[inx;SOURCE] ⋄ ∆[inx;SOURCE]←mask/sources
          groups←∪∆[inx;GROUP]
          1 GroupsFlags groups TOGGLED 1       ⍝ touching a value toggles the group
          1 GroupsFlags groups TOUCHED 1       ⍝ whole groups were touched
        ∇
        ∇ sources←GetSources ids;mask;inx     ⍝ get source expressions for script ids
          :Access Public
          (inx mask)←FindIds ids
          sources←∆[inx;SOURCE]
        ∇
        ∇ Enable ids;mask           ⍝ enable this very list of ids
          :Access Public
          ∆[;ENABLED]←∆[;ID]∊ids    ⍝ ignore unknown ids
        ∇
        ∇ {flags}←set GroupsFlags(groups col flags);mat;gmask;inx;fmask;oldflags
          mat←(groups←,groups)∘.≡∆[;GROUP]
          :If ~∧/gmask←∨/mat
              Error'Missing groups: ',⍕(~gmask)/groups
          :EndIf
          inx←(1⊃⍴∆)∘{⍵/⍳⍺}¨↓gmask⌿mat
          :If set
              ∆[∊inx;col]←(⊃∘⍴¨inx)/flags
              ∆[∊inx;TOUCHED]←1
          :Else
              oldflags←∆[;col]∘{⍺[⍵]}¨inx
              :If ~∧/fmask←1=⊃∘⍴¨∪¨oldflags
                  Error'Inconsistent flags ',(⍕col),' for groups: ',⍕((~fmask)/gmask/groups)
              :EndIf
              flags←(⍴groups)⍴¯1
              (fmask/gmask/flags)←⊃¨fmask/oldflags
          :EndIf
        ∇
        ∇ toggles←Toggled groups                           ⍝ get toggle states of group ids
          :Access Public
          toggles←0 GroupsFlags(groups TOGGLED ¯1)
        ∇
        ∇ Toggle(groups toggle);rows;mask;inx                ⍝ set toggle states of group ids
          :Access Public
          1 GroupsFlags(groups TOGGLED toggle)
          1 GroupsFlags(groups TOUCHED 1)
        ∇
        ∇ txt←ord GetAPLScript varname;sources;type;indices;arg;i;newtable;For;ord;∆1;∆2;names;name;draw;options;page;group;groups;∆3;∆4;types;txt2;chunk;chunk2
        ⍝ Export script as a runnable vector of strings
          :Access Public
          txt←⍬ ⍝txt←⊂'sp←⎕NEW Causeway.SharpPlot'
          :If ~ord CheckScript ∆ ⋄ :Return ⋄ :EndIf
          ∆1←(∧/∆[;ENABLED TOGGLED])⌿∆
          ∆1[;SOURCE]←Util.StripSource¨∆1[;SOURCE]   ⍝ remove separator from PopupExpression
          :If ~∨/∧⌿(,ord)∘.∊(ORDPGINIT ORDPGSET)(ORDPGFIN)(ORDCHPAGE ORDCHFRAME ORDCHSET)(ORDCHFIN)(ORDCHDRAW) ⋄ Error'GetAPLScript: Unexpected script chunks ordering' ⋄ :EndIf
          :For ord :In ORDERS∩ord    ⍝ append sharpplot calls in ascending order for a page - ignoring order=0
              chunk←⍬
              ord←ord=∆1[;ORDER]               ⍝ turn into mask or rows of this order
              types←∆1[;TYPE]
              ⍝ TYPE='P' : regular properties cannot have multiple entries
              :If ~0∊⍴∆2←(ord∧types='P')⌿∆1
                  (sources names indices)←↓⍉∆2[;SOURCE NAME INDEX]
                  :If 0∨.≠indices ⋄ :OrIf names≢∪names ⋄ Error'Properties cannot have multiple entries or arguments' ⋄ :EndIf
                  chunk,←(varname,'.')∘,¨names,¨'←',¨sources
              :EndIf
              ⍝ TYPE='M' : methods must be called for each groups it appears in (in practice only SaveImage uses that feature)
              ∆2←(ord∧types='M')⌿∆1
              :For name :In ∪names←∆2[;NAME]
                  ∆3←(name∘≡¨names)⌿∆2
                  :For group :In ∪groups←∆3[;GROUP]  ⍝ loop groups within names because it's rarer that names appear in multiple groups - in fact only SaveImage does
                      (sources indices)←↓⍉(group∘≡¨groups)⌿∆3[;SOURCE INDEX]
                      (indices sources)/⍨←⊂indices≥0                       ⍝ ignore negative indices (ignored series)
                      :If indices≡,0                 ⍝ is all arguments at once
                          arg←⊃sources
                      :ElseIf indices≡,1             ⍝ lonely argument : enclose
                          arg←'⊂',⊃sources
                      :Else ⍝ arrange arguments in expected order, passing ⍬ to unspecified arguments
                          arg←∊{'(',⍵,')'}¨(sources,⊂Util.EmptySource)[indices⍳i←⍳⌈/indices]
                          :If 1=⍴i ⋄ arg←'⊂',arg ⋄ :EndIf
                          :If i≢{⍵[⍋⍵]}indices ⋄ Gui.Error'Script argument mismatch for function:',name ⋄ :EndIf
                      :EndIf
                      chunk,←⊂varname,'.',name,' ',arg
                  :EndFor
              :EndFor
              ⍝ TYPE='S' : styles can have multiple entries accross groups, that must be mapped to the same style property
              ∆2←(ord∧types='S')⌿∆1
              :For name :In ∪names←∆2[;NAME]
                  (sources indices)←↓⍉(name∘≡¨names)⌿∆2[;SOURCE INDEX]
                  :If 0∨.≠indices ⋄ Gui.Error'Multiple indices ',(FMTU indices),' for style: ',⍕name ⋄ :EndIf
                  arg←+/(¯1 0∘Util.Exec¨sources)~0                       ⍝!!! Dyalog can't do +/0,[Flag Enum]
                  :If arg≠0      ⍝ ignore unset style  ⍝!!! will go wrong if a previous chart has set some flags
                      arg←Util.Source arg
                      chunk,←⊂varname,'.',name,'←',arg
                  :EndIf
              :EndFor
              chunk2←{(3×'Set'∘≡¨3↑¨⍵)↓¨⍵}(1+⍴varname)↓¨chunk  ⍝ sort chunk alphabetically, ignoring "Set" prefix
              txt,←chunk[⍋↑chunk2]                              ⍝!!! arguably, we could sort by pane
          :EndFor
        ∇
        ∇ issource SetArgs(name arg);mask;inx;indices;defaults;Format;source;value;groups
        ⍝ arg is s value array and not an APL expression source
          :Access Public
          :If issource ⋄ source←arg ⋄ value←1 1 Util.Exec arg
          :Else ⋄ source←Util.Source arg ⋄ value←arg ⋄ :EndIf
          :If 0∊⍴inx←(name∘≡¨∆[;NAME])/⍳1⊃⍴∆
              Error'Unknown API name: ',⍕name
          :EndIf
          :Select ∪∆[inx;TYPE]
          :Case ,'P'                           ⍝ Property : easy - there is only one row and one arg
              defaults←⊃∆[inx;DEFAULTS]
              :If (,0)≢∆[inx;INDEX] ⋄ ⋄ Error'Inconsistent script' ⋄ :EndIf  ⍝ only one row
              :If ~0 ConformsDefaults value defaults 0 'P' ⋄ Gui.APLInfo('Unconformable ',name,' property argument')('Expecting something like:',⊃defaults) ⋄ :Return ⋄ :EndIf
              ∆[inx;SOURCE]←⊂source
          :Case ,'S'                           ⍝ Style : spread value on entries using that name. Their default indicates which flag they receive
              defaults←∆[inx;DEFAULTS]
              :If (,0)≢∪∆[inx;INDEX] ⋄ Error'Inconsistent script' ⋄ :EndIf  ⍝ can have several rows (one per group), but all indices must be 0
              :If ~∧/0∘ConformsDefaults¨value∘{⍺ ⍵ 0 'S'}¨defaults ⋄ Gui.APLInfo('Unconformable ',name,' style argument')('Expecting something like: ',⊃⊃defaults) ⋄ :Return ⋄ :EndIf
              defaults←¯1 0∘Util.Exec∘⊃¨defaults  ⍝ get default flags for each group
              ∆[inx;SOURCE]←Util.Source¨value∘Util.AndFlags¨defaults  ⍝ spread flags accross groups
          :Case ,'M'                           ⍝ Method : exactly one entry per argument
              :If 1≠⍴∪∆[inx;GROUP] ⋄ Gui.APLInfo'Cannot set arguments for method ',name ⋄ :Return ⋄ :EndIf  ⍝ do not set args for methods that appear in multiple groups (only SaveImage does)
              defaults←∆[inx;DEFAULTS]
              Format←{1=⍴⍵:⊃⍵ ⋄ ¯4↓⊃,/{'(',⍵,') or '}¨⍵}  ⍝ nicely format multiple defaults
              :Select {⍵[⍋⍵]}indices←∆[inx;INDEX]
              :Case ,0   ⍝ only one row
                  :If ~0 ConformsDefaults value(⊃defaults)0 'M' ⋄ Gui.APLInfo('Unconformable ',name,' method argument')('Expecting something like: ',Format⊃defaults) ⋄ :Return ⋄ :EndIf
                  ∆[inx;SOURCE]←⊂source
              :Case ,1   ⍝ only one row
                  :If ~0 ConformsDefaults value(⊃defaults)1 'M' ⋄ Gui.APLInfo('Unconformable ',name,' method argument')('Expecting something like: ',Format⊃defaults) ⋄ :Return ⋄ :EndIf
                  ∆[inx;SOURCE]←⊂source
              :Case ⍳⍴indices     ⍝ multiple rows
                  :If issource ⋄ Error'Cannot set source for multiple-argument methods' ⋄ :EndIf
                  :If 1∨.≠⊃∘⍴¨defaults ⋄ Error'Cannot set value for overloaded multiple-argument methods' ⋄ :EndIf
                  defaults←∊{'(',⍵,')'}¨(⊃¨defaults)[indices⍳⍳⍴indices]    ⍝ build a single default expression for whole argument, based on single defaults for each argument index
                  :If ~0 ConformsDefaults value(,⊂defaults)0 'M' ⋄ Gui.APLInfo('Unconformable ',name,' method arguments')('Expecting something like: ',defaults) ⋄ :Return ⋄ :EndIf
                  ∆[inx;SOURCE]←Util.Source¨value[indices]
              :Else
                  Error'Inconsistent script'
              :EndSelect
          :Else ⋄ Error'Inconsistent script'
          :EndSelect
          groups←∪∆[inx;GROUP]
          1 GroupsFlags groups TOUCHED 1       ⍝ whole groups were touched
          1 GroupsFlags groups TOGGLED 1       ⍝ whole groups were toggled
        ∇

        ⍝⍝⍝⍝⍝ Special interface for Series ⍝⍝⍝⍝⍝
        ∇ ok←CheckMethodScript
          ok←0
          :If (1⊃⍴∆)≠⍴∪∆[;ID] ⋄ Error'CheckMethodScript: non-unique ids' ⋄ :Return ⋄ :EndIf
          :If 1<⍴∪,∆[;GROUP NAME] ⋄ Error'CheckMethodScript: multiple methods' ⋄ :Return ⋄ :EndIf
          :If ~∧/,1 1 1 'M' 3=[2]∆[;TOUCHED TOGGLED ENABLED TYPE ORDER] ⋄ Error'GetMethodArgs: invalid flags' ⋄ :Return ⋄ :EndIf
          ok←1
        ∇
        ∇ (name indices exprs)←GetMethodArgs;mask;names           ⍝ used by Serie to get Draw function's argument
          :Access Public
          :If ~CheckMethodScript ⋄ name←'' ⋄ indices←exprs←⍬
          :Else ⋄ name←⊃∆[;NAME] ⋄ (indices exprs)←↓⍉∆[;INDEX SOURCE]
          :EndIf
        ∇
        ∇ SetMethodArgs(name indices exprs);ids;n                 ⍝ used by Serie to set Draw function's argument
          :Access Public
          :If ~CheckMethodScript ⋄ :Return ⋄ :EndIf
          :If 1≠⍴n←∪⊃∘⍴¨indices exprs ⋄ Gui.Error'SetMethodArgs: inconsistent indices and expressions' ⋄ :Return ⋄ :EndIf
          ⍝ reset everything
          n←⊃n ⋄ ∆←(n COLS)⍴⎕NULL
          ∆[;ID]←name∘{⍺,'.',⍕⍵}¨indices
          ∆[;GROUP NAME]←⊂name ⋄ ∆[;INDEX]←indices ⋄ ∆[;DEFAULTS]←,⊂∆[;SOURCE]←exprs  ⍝!!! DEFAULTS is dummy : no conformity checking for drawing methods
          ∆[;TOUCHED TOGGLED ENABLED TYPE ORDER]←n 5⍴1 1 1 'M'ORDCHDRAW
        ∇
    :EndClass

    :EndSection



⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section GUI_options_panes
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝


    :Class OptionsPane : ScrollSubForm          ⍝ A subform control that display one pane of options for a given charttype
        ⍝ Used by ChartSetter to build pane for given charttype (listed by Chart.GetTypes) and panetype (listed by OptionsPane.GetPaneTypes)
        ⍝ Used by GlobalOptions for its single (charttype≡panetype≡'Global') pane for global page options scripts
        ⍝ pane≡'All' is special case when creating default chart options scripts
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :include CustomControl
        :Field Private ∆SCRIPT                  ⍝ Script object
        :Field Private ∆CTRLS                   ⍝ vector of controls
        :Field Private CTRLIDS                  ⍝ vector of control ids
        :Field Private ∆LABELS                  ⍝ vector of labels
        :Field Private ∆TITLES                  ⍝ vector of titles (toggling groups of controls)
        :Field Private TITLEIDS                 ⍝ vector of group ids
        :Field Private CHARTTYPE                ⍝ OptionsPane's chart type
        :Field Private PANETYPE                 ⍝ OptionsPane's pane type
        :Field Private BUILDGUI                 ⍝ Flag : build GUI along with Script - otherwise just the Script (GetDefaults only)
        ∇ OptionsPaneConstructor(charttype panetype ∆callns callfn)
          :Access Public
          :Implements Constructor :Base 1 0 1 ⍬  ⍝ vscroll
          CustomConstructor ∆callns callfn
          ∆SCRIPT←⎕NEW Script
          ∆CTRLS←∆LABELS←∆TITLES←TITLEIDS←CTRLIDS←⍬
          BUILDGUI←1   ⍝ Truely building an OptionsPane control
          Build(CHARTTYPE PANETYPE)←(charttype panetype)
          ⎕THIS.GetChild.Size←Gui.SPACE+⊃⌈/(∆CTRLS,∆LABELS,∆TITLES).(Size+Posn)
        ∇
        ∇ Close                                 ⍝ work with Gui.Close
          :Access Public
          :If ~0∊⍴∆CTRLS ⋄ Gui.Close¨∆CTRLS ⋄ :EndIf     ⍝ close controls that may have sub-forms
        ∇
        ∇ {∆title}←AddTitle(id helpid caption width togglable toggled)
          ⍝ (togglable toggled) is usually (1 0) for controls because we want factory defaults (no sharpplot call)
          ⍝ (togglable toggled) is usually (0 1) for styles because (style=0) will not produce a sharpplot call
          :If BUILDGUI∧(width>0)
              ∆title←⎕THIS.GetChild.⎕NEW Title(caption width togglable toggled helpid ⎕THIS'UpdateTitle')
              LayoutNext ∆title 1 1 0
          :Else  ⍝ Emulate Title.GetValue required by ScriptNext
              ∆title←⎕NS''
              ∆title.GetValue←toggled  ⍝ Emulate Title.GetValue
          :EndIf
          TITLEIDS,←⊂id
          ∆TITLES,←∆title
        ∇
        ∇ {∆label}←AddLabel(caption newrow width)
          :If BUILDGUI
              ∆LABELS,←∆label←⎕THIS.GetChild Gui.BuildLabel caption width
              LayoutNext ∆label(newrow<0)(|newrow)0
          :EndIf
        ∇
        ∇ {∆ctrl}←AddControl(∆class defaults newrow stretch id type name arg order);toggle;∆title;source
          :If 1≥|≡defaults ⋄ defaults←,⊂,defaults ⋄ :EndIf  ⍝ enclose if not nested
          source←⊃defaults    ⍝ use first default as source
          :If BUILDGUI∧(∆class≢⎕NULL)
              CTRLIDS,←⊂id
              ∆CTRLS,←∆ctrl←⎕THIS.GetChild.⎕NEW ∆class(⎕THIS'UpdateControl')
              ∆ctrl CustomControl.SetSource source       ⍝!!! be careful that source is such that control will not change source - like PopupExpression may do - otherwise the default value will be wrong
              LayoutNext ∆ctrl 0 newrow stretch
          :EndIf
          ScriptNext id source type name arg order defaults
        ∇
        ∇ {∆obj}←AddStyles(id ∆styles styles ∆value newrow width ord);∆parent;styles;∆ctrl;prop;source;∆style;allstyles;ignored;type;∆default
          ⍝ :If ∆styles≡⎕NULL ⋄ :Return ⋄ :EndIf    ⍝ no style to build
          prop←Chart.GetStylesProperty ∆styles      ⍝ name of property
          id←prop,'.',id
          ∆default←+/∊∆styles Util.GetStyles styles ⍝ default value shows all possible flags for this control
          :If BUILDGUI
              CTRLIDS,←⊂id
              ∆CTRLS,←∆ctrl←⎕THIS.GetChild.⎕NEW Style(∆styles styles ∆value width ⎕THIS'UpdateControl')
              LayoutNext ∆ctrl 0 newrow 0
          :EndIf
          ScriptNext id(Util.Source ∆value)'S'prop 0 ord(,⊂Util.Source ∆default)
        ∇
        ∇ LayoutNext(∆ctrl title newrow stretch);width;∆title
          :If (newrow)∧(~title)∧(~0∊⍴∆TITLES)   ⍝ create a dummy title
              width←2⊃(⊃⌽∆TITLES).Size
              ∆LABELS,←∆title←⎕THIS.GetChild Gui.BuildLabel''width
              ∆title Gui.LayoutSerialNext 1 1 Gui.SPACE 0
          :EndIf
          ∆ctrl Gui.LayoutSerialNext 1 title Gui.SPACE stretch
        ∇
        ∇ ScriptNext(id source type name arg order defaults);toggle;∆title;group  ⍝ thin wrapper for Script.AddItem
          ∆title←⊃⌽∆TITLES ⋄ group←⊃⌽TITLEIDS ⋄ toggle←∆title.GetValue
          ∆SCRIPT.AddItem id group source toggle type name arg order defaults
        ∇
        ∇ UpdateTitle ∆title;group;ctrlid;∆ctrl;toggled                     ⍝ Callback on title ticks
          :Access Public
          group←(∆TITLES⍳∆title)⊃TITLEIDS
          toggled←∆title.GetValue
          ∆SCRIPT.Toggle(⊂group)(⊂toggled)
          :If (toggled)∧('Save'≡4↑group)  ⍝ exception when enabling GlobalOptions.SaveXXX : run file box on .Filename control
              ctrlid←group,'.Filename'   ⍝ see Pane 'Global'
              ∆ctrl←(CTRLIDS⍳⊂ctrlid)⊃∆CTRLS   ⍝ must derive from a Filename CustomControl
              :If 0∊⍴∆ctrl.GetValue       ⍝ no file name set
                  ∆ctrl.BrowseFile ⎕NULL  ⍝ Filename.BrowseFile - will CustomCallback into UpdateControl
                  :If 0∊⍴∆ctrl.GetValue   ⍝ user gave up
                      ∆title.SetValue toggled←0    ⍝ disable title
                      ∆SCRIPT.Toggle(⊂group)(⊂toggled)
                  :EndIf
              :Else                  ⍝ use file name
                  CustomCallback
              :EndIf
          :Else
              CustomCallback                            ⍝ callback further
          :EndIf
        ∇
        ∇ UpdateControl ∆ctrl;source;id;groups             ⍝ Callback on controls
          :Access Public
          ⍝CustomControl.CustomShow ∆ctrl
          id←(∆CTRLS⍳∆ctrl)⊃CTRLIDS
          source←CustomControl.GetSource ∆ctrl
          groups←∆SCRIPT.SetSources(⊂id)(⊂source)   ⍝ set control source, touch and toggle group in script
          (∆TITLES[TITLEIDS⍳groups]).SetValue 1     ⍝ toggle group in GUI
          CustomCallback                            ⍝ callback further
        ∇
        ∇ SetValue script;pids;vids;toggles;ctrlids;default⍝ Value setter - ∆script must come from a OptionsPane with the same charttype and panetype !
          :Access Public
          default←GetDefaultScript CHARTTYPE
          ∆SCRIPT←⎕NEW Script default       ⍝ use defaults for this chart type
          ∆SCRIPT.MergeScript script        ⍝ merge items that have been touched
          :If (~BUILDGUI)∨((0∊⍴∆CTRLS)≠(0∊⍴∆TITLES)) ⋄ Gui.Error'Uninitialised OptionsPane' ⋄ :Return ⋄ :EndIf
          :If (⊂CHARTTYPE)∊Chart.GetTypes
              ∆SCRIPT.Enable default[;Script.ID]  ⍝ enable only ids for this chart type  ⍝!!! API violation by direct addressing of matrix columns
          :EndIf
          :If ~0∊⍴∆CTRLS
              ⎕THIS Gui.Redraw 0
              ∆CTRLS CustomControl.SetSource¨∆SCRIPT.GetSources CTRLIDS
              ∆TITLES.SetValue ∆SCRIPT.Toggled TITLEIDS
              ⎕THIS Gui.Redraw 3
          :EndIf
        ∇
        ∇ script←GetValue                          ⍝ Value getter
          :Access Public
          script←∆SCRIPT.GetValue                  ⍝ Content of script
        ∇
        ∇ panes←GetPaneTypes
          :Access Public Shared
          panes←'Frame' 'Aspect' 'Drawing' 'Data' 'Text' 'Key' 'Axes' 'Captions' 'Ticks' 'Labels' 'Tags' 'Models' 'Formats'
        ∇
        ∇ tip←GetPaneTip pane
          :Access Public Shared
          :Select pane
          :Case 'Frame' ⋄ tip←'Chart frame position, size, margins, backgrounds'
          :Case 'Aspect' ⋄ tip←'Chart-specific settings'
          :Case 'Drawing' ⋄ tip←'Series graphic representation: colors, lines, markers, fills, edges, arrows'
          :Case 'Data' ⋄ tip←'Series data format and categorisation'
          :Case 'Text' ⋄ tip←'Chart annotations: headings, footnote'
          :Case 'Key' ⋄ tip←'Series legends: values, aspect'
          :Case 'Axes' ⋄ tip←'Chart axes: position, range, aspect'
          :Case 'Captions' ⋄ tip←'Axes titles'
          :Case 'Ticks' ⋄ tip←'Axes ticks and gridlines: position, aspect'
          :Case 'Labels' ⋄ tip←'Tick titles'
          :Case 'Tags' ⋄ tip←'Series value tags, baseline, datum lines, zones'
          :Case 'Models' ⋄ tip←'Graphical smoothing, polynomial modelfit and contours'
          :Case 'Formats' ⋄ tip←'Textual formatters: labels, keys, tags'
          :Else ⋄ tip←'' ⋄ Gui.Error'Unknown pane type'
          :EndSelect
        ∇
        ∇ Build(charttype panetype);∆ctrl;contour;titw;labw;tower;types;defdatum;stylecols;stw;∆styles;line;zeroon;polar;histogram;triangle;styles;cloud;bar;bubble;response;box;dial;gantt;xbar;vector;trace;treemap;scatter;step;minmax;pie;prop;def;xaxis;yaxis;zaxis;iaxis;Pane;error;persp;table
          error←'Inconsistent OptionsPane types'
          :If charttype≡'Global'   ⍝ Used by GlobalOptions
              :If panetype≢'Global' ⋄ Gui.Error error ⋄ :EndIf
              ∆styles←⎕NULL ⋄ prop←''
          :Else                    ⍝ Used by ChartSetter
              :If ~(⊂charttype)∊Chart.GetTypes ⋄ :OrIf ~(⊂panetype)∊GetPaneTypes,⊂'All' ⋄ Gui.Error error ⋄ :EndIf
              ∆styles←⍎Chart.GetStyle charttype
              prop←Chart.GetStylesProperty ∆styles
          :EndIf
          (bar box bubble cloud contour dial gantt histogram line minmax pie polar response scatter step table tower trace treemap triangle vector xbar)←charttype∘≡¨Chart.GetTypes
          xaxis←1
          yaxis←~∨/dial pie treemap
          zaxis←∨/bubble cloud contour response tower treemap
          iaxis←∨/trace
          persp←∨/cloud response tower
         
          :If BUILDGUI ⋄ ⎕THIS Gui.Redraw 0 ⋄ :EndIf
         
          :If panetype≡'All'      ⍝ run through all chart options panes
              Pane←'Global'∘≢
          :Else                   ⍝ run through designated panetype
              Pane←panetype∘≡
          :EndIf
         
          :If Pane'Frame' ⋄ titw←115 ⋄ labw←40 ⋄ stw←90
              AddTitle'NewPage' 'NewPage' 'New page:'titw 1 0
              AddLabel'Reset:' 0 labw ⋄ AddControl Boolean'0' 0 0 'NewPage.Reset' 'M' 'NewPage' 1 Script.ORDCHPAGE
              AddTitle'Frame' 'NewFrame' 'New frame:'titw 1 0
              AddLabel'Left:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'Frame.Left' 'M' 'NewFrame' 1 Script.ORDCHFRAME   ⍝ order=1 : chart initialisation
              AddLabel'Top:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'Frame.Top' 'M' 'NewFrame' 2 Script.ORDCHFRAME
              AddLabel'Width:' 0 labw ⋄ AddControl NumEdit'432' 0 0 'Frame.Width' 'M' 'NewFrame' 3 Script.ORDCHFRAME
              AddLabel'Height:' 0 labw ⋄ AddControl NumEdit'324' 0 0 'Frame.Height' 'M' 'NewFrame' 4 Script.ORDCHFRAME
              AddTitle'FrameBackground' 'SetFrameBackground' 'Frame background:'titw 1 0
              def←'System.Drawing.Color.White Causeway.FillStyle.Solid 1.5'
              AddControl Background def 0 0 'FrameBackground' 'M' 'SetFrameBackground' 0 Script.ORDCHSET
              styles←'Filled' 'Boxed' 'Shadowed' 'Rounded'
              AddTitle'FrameStyle' 'FrameStyle' 'Frame style:'titw 0 1
              AddStyles'FrameStyle'Causeway.FrameStyles styles 0 0 stw Script.ORDCHSET
              AddTitle'Gutter' 'Gutter' 'Gutter:'titw 1 0
              AddControl NumEdit'4' 0 0 'Gutter' 'P' 'Gutter' 0 Script.ORDCHSET
              AddTitle'Margins' 'SetMargins' 'Margins:'titw 1 0
              AddLabel'Top:' 0 labw ⋄ AddControl NumEdit'42' 0 0 'Margins.Top' 'M' 'SetMargins' 1 Script.ORDCHSET
              AddLabel'Bottom:' 0 labw ⋄ AddControl NumEdit'48' 0 0 'Margins.Bottom' 'M' 'SetMargins' 2 Script.ORDCHSET
              AddLabel'Left:' 0 labw ⋄ AddControl NumEdit'36' 0 0 'Margins.Left' 'M' 'SetMargins' 3 Script.ORDCHSET
              AddLabel'Right:' 0 labw ⋄ AddControl NumEdit'18' 0 0 'Margins.Right' 'M' 'SetMargins' 4 Script.ORDCHSET
              AddTitle'ChartBackground' 'SetChartBackground' 'Chart background:'titw 1 0
              def←'System.Drawing.Color.White Causeway.FillStyle.Solid 0'
              AddControl Background def 0 0 'ChartBackground' 'M' 'SetChartBackground' 0 Script.ORDCHSET
          :EndIf
         
          :If Pane'Aspect' ⋄ titw←100 ⋄ stw←95
              :Select charttype
              :Case 'Bar'
                  AddTitle'BarStyle' 'BarChartStyle' 'Bar style:'titw 0 1
                  styles←'Horizontal' 'StackedBars' 'FloatingBars'
                  AddStyles'BarStyle'∆styles styles 0 0 stw Script.ORDCHSET
              :Case 'Box'
                  AddTitle'BoxStyle' 'BoxPlotStyle' 'Box style:'titw 0 1
                  styles←'Horizontal' 'Plain' 'DecileWhiskers' 'ErrorBars' ⍝!!! 'TabularData'
                  AddStyles'BoxStyle'∆styles styles 0 0 stw Script.ORDCHSET
              :Case 'Bubble'
                  AddTitle'BubbleStyle' 'BubbleChartStyle' 'Bubble style:'titw 0 1
                  styles←'RadialScaling'  ⍝ 'Logarithmic'
                  AddStyles'BubbleStyle'∆styles styles 0 0 stw Script.ORDCHSET
              :Case 'Cloud'
              :Case 'Contour'
              :Case 'Dial'
                  AddTitle'DialStyle' 'DialChartStyle' 'Dial style:'titw 0 1
                  AddStyles'DialStyle'∆styles('Anticlockwise' 'WedgeZones')0 0 stw Script.ORDCHSET
              :Case 'Gantt'
              :Case 'Histogram'
                  AddTitle'ClassInterval' 'ClassInterval' 'Class interval:'titw 1 0
                  AddControl NumEdit'1' 0 0 'ClassInterval' 'P' 'ClassInterval' 0 Script.ORDCHSET
              :Case 'Line'
              :Case 'MinMax'
                  AddTitle'MinMaxStyle' 'MinMaxChartStyle' 'MinMax style:'titw 0 1
                  AddStyles'MinMaxStyle'∆styles'Horizontal' 0 0 stw Script.ORDCHSET
              :Case 'Pie'
                  AddTitle'PieStyle' 'PieChartStyle' 'Pie style:'titw 0 1
                  styles←'Plain' 'RoseDiagram' ⍝!!! 'FarthestFirst' is VML only
                  AddStyles'PieStyle'∆styles styles 0 0 stw Script.ORDCHSET
                  AddTitle'PieCenter' 'SetPieCenter' 'Pie center:'titw 1 0
                  AddLabel'X:' 0 ⍬ ⋄ AddControl NumEdit'0' 0 0 'PieCenter.X' 'M' 'SetPieCenter' 1 Script.ORDCHSET
                  AddLabel'Y:' 0 ⍬ ⋄ AddControl NumEdit'0' 0 0 'PieCenter.Y' 'M' 'SetPieCenter' 2 Script.ORDCHSET
                  AddTitle'PieRadius' 'PieRadius' 'Pie radius:'titw 1 0
                  AddControl NumEdit'100' 0 0 'PieRadius' 'P' 'PieRadius' 0 Script.ORDCHSET
                  AddTitle'PieStartAngle' 'PieStartAngle' 'Start angle:'titw 1 0
                  AddControl Angle'0' 0 0 'PieStartAngle' 'P' 'PieStartAngle' 0 Script.ORDCHSET
              :Case 'Polar'
              :Case 'Response'
              :Case 'Scatter'
                  AddTitle'ScatterStyle' 'ScatterPlotStyle' 'Scatter style:'titw 0 1
                  styles←'Parity'  ⍝ 'Logarithmic'
                  AddStyles'ScatterStyle'∆styles styles 0 0 stw Script.ORDCHSET
              :Case 'Step'
                  AddTitle'StepStyle' 'StepChartStyle' 'Step style:'titw 0 1
                  AddStyles'StepStyle'∆styles'Horizontal' 0 0 stw Script.ORDCHSET
              :Case 'Table'
                  AddTitle'TableStyle' 'TableStyle' 'Table style:'titw 0 1
                  styles←⊂'Boxed' 'Rounded' 'Opaque' 'Shadowed'
                  styles,←⊂'Center' 'Right',Util.SHARPPLOT300/'Middle' 'Bottom'
                  styles,←⊂'Absolute' 'UseHeaders' 'FitHeight' 'FitWidth'
                  AddStyles'TableStyle'∆styles styles 0 0 stw Script.ORDCHSET
                  AddTitle'TablePosition' 'SetTablePosition' 'Table position:'titw 1 0
                  AddLabel'X:' 0 ⍬ ⋄ AddControl NumEdit'0' 0 0 'TablePosition.X' 'M' 'SetTablePosition' 1 Script.ORDCHSET
                  AddLabel'Y:' 0 ⍬ ⋄ AddControl NumEdit'0' 0 0 'TablePosition.Y' 'M' 'SetTablePosition' 2 Script.ORDCHSET
                  AddLabel'Width:' 0 ⍬ ⋄ AddControl NumEdit'0' 0 0 'TablePosition.Width' 'M' 'SetTablePosition' 3 Script.ORDCHSET
                  :If Util.SHARPPLOT300
                      AddLabel'Height:' 0 ⍬ ⋄ AddControl NumEdit'0' 0 0 'TablePosition.Height' 'M' 'SetTablePosition' 4 Script.ORDCHSET
                  :EndIf
              :Case 'Tower'
                  AddTitle'TowerStyle' 'TowerChartStyle' 'Tower style:'titw 0 1
                  AddStyles'TowerStyle'∆styles'Plain' 0 0 stw Script.ORDCHSET
                  AddTitle'TowerAspect' 'TowerAspect' 'Tower aspect:'titw 1 0
                  AddControl NumEdit'1' 0 0 'TowerAspect' 'P' 'TowerAspect' 0 Script.ORDCHSET
                  AddTitle'TowerLimit' 'TowerLimit' 'Tower limit:'titw 1 1
                  AddControl NumEdit'1000' 0 0 'TowerLimit' 'P' 'TowerLimit' 0 Script.ORDCHSET
              :Case 'Trace'
                  AddTitle'TraceStyle' 'TraceChartStyle' 'Trace style:'titw 0 1
                  AddStyles'TraceStyle'∆styles'KiteDiagram' 0 0 stw Script.ORDCHSET
                  AddTitle'IAllowance' 'IAllowance' 'Inner allowance:'titw 1 0
                  AddControl NumEdit'0.8' 0 0 'IAllowance' 'P' 'IAllowance' 0 Script.ORDCHSET
              :Case 'TreeMap'
                  AddTitle'TreeMapStyle' 'TreeMapStyle' 'TreeMap style:'titw 0 1
                  AddStyles'TreeMapStyle'∆styles('Logarithmic' 'SquareRoot')0 0 stw Script.ORDCHSET
              :Case 'Triangle'
              :Case 'Vector'
                  AddTitle'VectorStyle' 'VectorStyle' 'Vector style:'titw 0 1
                  styles←'Dissected' 'Rooted' 'Middle' 'Terminated'
                  AddStyles'VectorStyle'∆styles styles 0 0 stw Script.ORDCHSET
              :Case 'XBar'
                  AddTitle'XBarStyle' 'XBarChartStyle' 'XBar style:'titw 0 1
                  styles←'Horizontal' 'StackedBars' 'FloatingBars'
                  AddStyles'XBarStyle'∆styles styles 0 0 stw Script.ORDCHSET
              :Else
                  Gui.Error'No chart style for 'charttype
              :EndSelect
              :If ∨/bar box tower
                  AddTitle'Gaps' 'Gap' 'Gaps:'titw 1 0
                  :If ∨/bar box
                      AddLabel'Bars:' 0 ⍬
                  :EndIf
                  AddControl NumEdit'0.6' 0 0 'Gap' 'P' 'Gap' 0 Script.ORDCHSET
                  :If ∨/bar box
                      AddLabel'Groups:' 0 ⍬
                      AddControl NumEdit'1.6' 0 0 'GroupGap' 'P' 'GroupGap' 0 Script.ORDCHSET
                  :EndIf
              :EndIf
              :If ∨/gantt xbar
                  AddTitle'BarWidths' 'SetBarWidths' 'Bar widths:'titw 1 0
                  AddControl PopupExpression_n(Util.EmptySource)0 1(charttype,'.BarWidths')'M' 'SetBarWidths' 1 Script.ORDCHSET
              :EndIf
              :If ∨/bar xbar
                  AddTitle'BarLimit' 'BarLimit' 'Bar limit:'titw 1 1
                  AddControl NumEdit'10000' 0 0(charttype,'.BarLimit')'P' 'BarLimit' 0 Script.ORDCHSET
              :EndIf
              :If persp
                  AddTitle'Viewpoint' 'SetViewpoint' 'View point:'titw 1 0
                  labw←65
                  AddLabel'Roll:' 0 labw ⋄ AddControl Angle'22' 0 1 'Viewpoint.Roll' 'M' 'SetViewpoint' 1 Script.ORDCHSET
                  AddLabel'Pitch:' 1 labw ⋄ AddControl Angle'15' 0 1 'Viewpoint.Pitch' 'M' 'SetViewpoint' 2 Script.ORDCHSET
                  AddLabel'Yaw:' 1 labw ⋄ AddControl Angle'50' 0 1 'Viewpoint.Yaw' 'M' 'SetViewpoint' 3 Script.ORDCHSET
                  AddTitle'Perspective' 'Perspective' 'Perspective:'titw 1 0
                  AddControl Perspective'12' 0 1 'Perspective' 'P' 'Perspective' 0 Script.ORDCHSET
                  labw←40
                  AddTitle'WallFills' 'SetWallFillStyles' 'Wall fillstyles:'titw 1 0
                  AddLabel'Top:' 0 labw ⋄ AddControl FillStyle'Causeway.FillStyle.Saturate30' 0 0 'WallFills.Top' 'M' 'SetWallFillStyles' 1 Script.ORDCHSET
                  AddLabel'Face:' 1 labw ⋄ AddControl FillStyle'Causeway.FillStyle.Saturate20' 0 0 'WallFills.Face' 'M' 'SetWallFillStyles' 2 Script.ORDCHSET
                  AddLabel'Edge:' 1 labw ⋄ AddControl FillStyle'Causeway.FillStyle.Saturate10' 0 0 'WallFills.Edge' 'M' 'SetWallFillStyles' 3 Script.ORDCHSET
                  ⍝ TODO : WallColors
                  AddTitle'3DOptions'prop'3D options:'titw 0 1
                  styles←'WallShading' 'FlatText'
                  AddStyles'3DOptions'∆styles styles 0 0 stw Script.ORDCHSET
              :EndIf
              :If 0∊⍴∆TITLES
                  AddLabel('No aspect settings for ',charttype,'.')0 ⍬
              :EndIf
          :EndIf
         
          :If Pane'Drawing' ⋄ titw←95 ⋄ labw←40 ⋄ stw←95
              AddTitle'Colors' 'SetColors' 'Colors:'titw 1 0
              ⍝ def←'System.Drawing.Color.(Navy Maroon Teal Green Purple Gray)' ⍝ real sharpplot default
              def←'System.Drawing.Color.(Navy Maroon Green OrangeRed Teal DarkOrchid DimGray)'
              AddControl MultiColor def 0 1 'Colors' 'M' 'SetColors' 1 Script.ORDCHSET
              :If ∨/bubble cloud contour line minmax polar response scatter step triangle vector
                  :If ~vector
                      AddTitle'MarkerOptions'prop'Marker options:'titw 0 1
                      styles←'Markers' 'NoMarkers' 'HaloMarkers' 'Risers' 'Terminated' 'DriftMarkers' 'ErrorBars'  ⍝!!! 'CellsCreated'
                      :If cloud ⋄ def←∆styles.Risers
                      :ElseIf triangle ⋄ def←∆styles.Markers
                      :Else ⋄ def←0 ⋄ :EndIf
                      AddStyles'MarkerOptions'∆styles styles def 0 stw Script.ORDCHSET
                  :EndIf
                  AddTitle'Markers' 'SetMarkers' 'Markers:'titw 1(∨/bubble contour cloud)
                  :If ∨/bubble contour ⋄ def←',Causeway.Marker.Bullet'
                  :ElseIf cloud ⋄ def←',Causeway.Marker.Node'
                  :Else ⋄ def←'Causeway.Marker.(Cross Plus Circle Diamond Bullet)' ⋄ :EndIf ⍝ Triangle Del
                  AddControl MultiMarker def 0 1 'Markers' 'M' 'SetMarkers' 1 Script.ORDCHSET
                  AddTitle'MarkerScales' 'SetMarkerScales' 'Marker scales:'titw 1(bubble)
                  :If bubble ⋄ def←',5' ⋄ :Else ⋄ def←',1' ⋄ :EndIf
                  AddControl PopupExpression_n def 0 1 'MarkerScales' 'M' 'SetMarkerScales' 1 Script.ORDCHSET
              :EndIf
              :If ∨/bubble cloud contour dial line minmax polar response scatter trace triangle vector
                  :If ~trace
                      AddTitle'LineOptions'prop'Line options: 'titw 0 1
                      styles←'Lines' 'NoLines' 'ArrowLines' ⍝ 'CrispEdges'
                      :If vector ⋄ def←∆styles.ArrowLines ⋄ :Else ⋄ def←0 ⋄ :EndIf
                      AddStyles'LineOptions'∆styles styles def 0 stw Script.ORDCHSET
                  :EndIf
                  AddTitle'LineStyles' 'SetLineStyles' 'Lines:'titw 1 0
                  def←'Causeway.LineStyle.(Solid Dash DashDotDot)'  ⍝ real sharpplot default is (Solid Dash Dot DashDot)
                  AddControl MultiLine def 0 1 'LineStyles' 'M' 'SetLineStyles' 1 Script.ORDCHSET
                  AddTitle'PenWidths' 'SetPenWidths' 'Pen widths:'titw 1 0
                  AddControl PopupExpression_n',0.3' 0 1 'PenWidths' 'M' 'SetPenWidths' 1 Script.ORDCHSET
              :EndIf
              :If ∨/cloud contour response scatter
                  AddTitle'ContourStyle' 'SetContourStyle' 'Contour lines:'titw 1 0
                  :If ∨/contour bubble treemap ⋄ def←'System.Drawing.Color.White Causeway.LineStyle.Solid 0.8'
                  :Else ⋄ def←'System.Drawing.Color.Red Causeway.LineStyle.Solid 0.8' ⋄ :EndIf
                  AddControl Line def 0 0 'ContourStyle' 'M' 'SetContourStyle' 0 Script.ORDCHSET
                  AddTitle'ContourFont' 'SetContourTagFont' 'Contour font:'titw 1 0
                  def←'''Arial'' 6 System.Drawing.FontStyle.Regular System.Drawing.Color.Green'
                  AddControl ColorFont def 0 0 'ContourTagFont' 'M' 'SetContourTagFont' 0 Script.ORDCHSET
              :EndIf
              :If ∨/pie box bar tower xbar table ⍝ venn   ⍝ in fact, any surface shading will use edgestyle for its key
                  AddTitle'EdgeStyle' 'SetEdgeStyle' 'Edge style:'titw 1 0
                  def←'System.Drawing.Color.Black Causeway.LineStyle.Solid 0.4'
                  AddControl Line def 0 0 'EdgeStyle' 'M' 'SetEdgeStyle' 0 Script.ORDCHSET
              :EndIf
              ⍝:If ∨/bar xbar   ⍝ replaced by EdgeStyle since SharpPlot v2.42
              ⍝    AddTitle'BarEdgeNib' 'BarEdgeNib' 'Bar edge width:'titw 1 0
              ⍝    AddControl NumEdit'0.4' 0 0 'BarEdgeNib' 'P' 'BarEdgeNib' 0 Script.ORDCHSET
              ⍝ :EndIf
              :If ∨/cloud histogram line minmax polar response step trace triangle
                  AddTitle'FillOptions'prop'Fill options:'titw 0 1
                  styles←'Filled' 'SurfaceShading' 'TiledSurface' 'Envelope'
                  :If histogram ⋄ def←∆styles.(SurfaceShading) ⋄ :Else ⋄ def←0 ⋄ :EndIf
                  AddStyles'FillOptions'∆styles styles def 0 stw Script.ORDCHSET
              :EndIf
              AddTitle'FillStyles' 'SetFillStyles' 'Fill styles:'titw 1(∨/histogram response)
              :If ∨/histogram response ⋄ def←',Causeway.FillStyle.(Opacity30)'
              :Else ⋄ def←'Causeway.FillStyle.(Opacity78 Opacity90)' ⋄ :EndIf
              ⍝ real sharpplot default is Causeway.FillStyle.(,Solid)
              AddControl MultiFill def 0 1 'FillStyles' 'M' 'SetFillStyles' 1 Script.ORDCHSET
              :If ∨/bubble cloud contour response treemap
                  AddTitle'AltitudeOptions'prop'Altitude shading'titw 0 1
                  styles←'AltitudeShading' 'Fine' 'Coarse'
                  :If contour ⋄ def←∆styles.(AltitudeShading+Fine) ⋄ :Else ⋄ def←0 ⋄ :EndIf
                  AddStyles'AltitudeOptions'∆styles styles def 0 stw Script.ORDCHSET
                  AddTitle'AltitudeColors' 'SetAltitudeColors' 'Altitude colors:'titw 1 0
                  :If ∨/contour bubble treemap ⋄ def←'System.Drawing.Color.(Green Yellow Red)'
                  :Else ⋄ def←'System.Drawing.Color.(Black Navy SkyBlue YellowGreen Khaki Peru Silver)' ⋄ :EndIf
                  ⍝ real default is System.Drawing.Color.(,DarkGreen)
                  AddControl MultiColor def 0 1 'AltitudeColors' 'M' 'SetAltitudeColors' 1 Script.ORDCHSET
              :EndIf
              :If tower
                  AddTitle'TowerFills' 'SetTowerFillStyles' 'Tower fills:'titw 1 0
                  AddLabel'Top:' 0 labw ⋄ AddControl FillStyle'Causeway.FillStyle.Saturate60' 0 0 'TowerFills.Top' 'M' 'SetTowerFillStyles' 1 Script.ORDCHSET
                  AddLabel'Face:' 1 labw ⋄ AddControl FillStyle'Causeway.FillStyle.Solid' 0 0 'TowerFills.Face' 'M' 'SetTowerFillStyles' 2 Script.ORDCHSET
                  AddLabel'Edge:' 1 labw ⋄ AddControl FillStyle'Causeway.FillStyle.Solid' 0 0 'TowerFills.Edge' 'M' 'SetTowerFillStyles' 3 Script.ORDCHSET
              :EndIf
              :If ~∨/pie treemap table  ⍝venn
                  AddTitle'ArrowStyle' 'SetArrowStyle' 'Arrow style:'titw 1 0
                  def←'10 25 Causeway.FillStyle.Solid'
                  AddControl Arrow def 0 0 'ArrowStyle' 'M' 'SetArrowStyle' 0 Script.ORDCHSET
              :EndIf
          :EndIf
         
          :If Pane'Data' ⋄ titw←95 ⋄ labw←53 ⋄ stw←95
              AddTitle'MissingValue' 'MissingValue' 'Missing value:'titw 1 0
              AddControl NumEdit'¯32768' 0 0 'MissingValue' 'P' 'MissingValue' 0 Script.ORDCHSET
              :If ∨/bar cloud line minmax polar step tower trace triangle xbar
                  AddTitle'DataOptions'prop'Data options: 'titw 0 1
                  styles←'XYPlot' 'Indexed' 'SegmentLines' 'SkipRepeats' 'SkipRuns' 'Percentage'
                  AddStyles'DataOptions'∆styles styles 0 0 stw Script.ORDCHSET
              :EndIf
              AddTitle'DataStyles' 'DataStyle' 'Data style: 'titw 0 1
              :If table ⋄ def←Causeway.DataStyles.Rows ⋄ :Else ⋄ def←0 ⋄ :EndIf
              AddStyles'DataStyles'Causeway.DataStyles('Rows' 'Relative')0 0 stw Script.ORDCHSET
              AddTitle'SplitBy' 'SplitBy' 'Split by:'titw 1 0
              AddLabel'Values:' 0 labw ⋄ AddControl PopupExpression_a PopupExpression_a.DEFAULTS 0 1 'SplitBy.Val' 'M' 'SplitBy' 1 Script.ORDCHSET
              AddLabel'Categories:' 1 labw ⋄ AddControl PopupExpression_a PopupExpression_a.DEFAULTS 0 1 'SplitBy.Cat' 'M' 'SplitBy' 2 Script.ORDCHSET
              AddTitle'GroupBy' 'GroupBy' 'Group by:'titw 1 0
              AddLabel'Values:' 0 labw ⋄ AddControl PopupExpression_a PopupExpression_a.DEFAULTS 0 1 'GroupBy.Val' 'M' 'GroupBy' 1 Script.ORDCHSET
              AddLabel'Categories:' 1 labw ⋄ AddControl PopupExpression_a PopupExpression_a.DEFAULTS 0 1 'GroupBy.Cat' 'M' 'GroupBy' 2 Script.ORDCHSET
              AddLabel'Function:' 1 labw ⋄ AddControl GroupByFunction'Causeway.GroupByFunction.Sum' 0 0 'GroupBy.Function' 'M' 'GroupBy' 3 Script.ORDCHSET
          :EndIf
         
          :If Pane'Text' ⋄ titw←110 ⋄ stw←110
              AddTitle'Heading' 'Heading' 'Heading:'titw 1 0
              AddControl TextEdit'''''' 0 1 'Heading' 'P' 'Heading' 0 Script.ORDCHSET
              AddTitle'HeadingStyle' 'HeadingStyle' 'Heading style:'titw 0 1
              styles←⊂'Left' 'Bottom' 'Right' 'NoWrap'
              styles,←⊂'Opaque' 'RuledBelow'
              AddStyles'HeadingStyle'Causeway.HeadingStyles styles 0 0 stw Script.ORDCHSET
              AddTitle'HeadingFont' 'SetHeadingFont' 'Heading font:'titw 1 0
              def←'''Times New Roman'' 18 System.Drawing.FontStyle.Regular System.Drawing.Color.Navy'
              AddControl ColorFont def 0 1 'HeadingFont' 'M' 'SetHeadingFont' 0 Script.ORDCHSET
              AddTitle'HeadingNudge' 'SetHeadingNudge' 'Heading nudge:'titw 1 0
              AddLabel'X:' 0 ⍬ ⋄ AddControl NumEdit'0' 0 0 'HeadingNudge.X' 'M' 'SetHeadingNudge' 1 Script.ORDCHSET
              AddLabel'Y:' 0 ⍬ ⋄ AddControl NumEdit'0' 0 0 'HeadingNudge.Y' 'M' 'SetHeadingNudge' 2 Script.ORDCHSET
              AddTitle'Subheading' 'Subheading' 'Sub-heading:'titw 1 0
              def←'''Times New Roman'' 12.5 System.Drawing.FontStyle.Regular System.Drawing.Color.Navy'
              AddControl TextEdit'''''' 0 1 'Subheading' 'P' 'Subheading' 0 Script.ORDCHSET
              AddTitle'SubheadingFont' 'SetSubheadingFont' 'Sub-heading font:'titw 1 0
              AddControl ColorFont def 0 1 'SubheadingFont' 'M' 'SetSubheadingFont' 0 Script.ORDCHSET
              AddTitle'Footnote' 'Footnote' 'Footnote:'titw 1 0
              AddControl TextEdit'''''' 0 1 'Footnote' 'P' 'Footnote' 0 Script.ORDCHSET
              AddTitle'FootnoteStyle' 'FootnoteStyle' 'Footnote style:'titw 0 1
              styles←'Center' 'Right' 'NoWrap' 'RuledAbove'
              AddStyles'FootnoteStyle'Causeway.FootnoteStyles styles 0 0 stw Script.ORDCHSET
              AddTitle'FootnoteFont' 'SetFootnoteFont' 'Footnote font:'titw 1 0
              def←'''Arial'' 8 System.Drawing.FontStyle.Regular System.Drawing.Color.Green'
              AddControl ColorFont def 0 1 'FootnoteFont' 'M' 'SetFootnoteFont' 0 Script.ORDCHSET
          ⍝ TODO : DrawNote NoteStyle SetNoteBackground SetNoteFont
          :EndIf
         
          :If Pane'Key' ⋄ titw←105 ⋄ labw←40 ⋄ stw←100
              AddTitle'KeyText' 'SetKeyText' 'Key:'titw 1 0
              AddControl PopupExpression_a PopupExpression_a.DEFAULTS 0 1 'KeyText' 'M' 'SetKeyText' 1 Script.ORDCHSET
              AddTitle'DrawKey' 'DrawKey' 'Draw Key:'titw 1 0
              AddLabel'X:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'DrawKey.X' 'M' 'DrawKey' 1 Script.ORDCHFIN  ⍝ order=4 : after chart
              AddLabel'Y:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'DrawKey.Y' 'M' 'DrawKey' 2 Script.ORDCHFIN
              AddTitle'KeyStyle' 'KeyStyle' 'Key style:'titw 0 1
              styles←⊂'NoKey' 'Reversed' 'Vertical' 'InlineWithData'
              styles,←⊂'BoxFrame' 'Boxed' 'Rounded' 'Shadowed'
              styles,←⊂'LeftAlign' 'CenterAlign' 'RightAlign' 'NoWrap'
              styles,←⊂'BottomAlign' 'MiddleAlign' 'TopAlign' 'AutofitText'
              styles,←⊂'Baseline' 'Plain'
              styles,←⊂'AbsolutePosition' 'Percentage'
              AddStyles'KeyStyle'Causeway.KeyStyles styles 0 0 stw Script.ORDCHSET
              AddTitle'KeyFrame' 'SetKeyFrame' 'Key frame:'titw 1 0
              AddLabel'Left:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'KeyFrame.Left' 'M' 'SetKeyFrame' 1 Script.ORDCHSET
              AddLabel'Top:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'KeyFrame.Top' 'M' 'SetKeyFrame' 2 Script.ORDCHSET
              AddLabel'Width:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'KeyFrame.Width' 'M' 'SetKeyFrame' 3 Script.ORDCHSET
              AddLabel'Height:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'KeyFrame.Height' 'M' 'SetKeyFrame' 4 Script.ORDCHSET
              AddTitle'KeyBackground' 'SetKeyBackground' 'Key background:'titw 1 0
              def←'System.Drawing.Color.White Causeway.FillStyle.Solid 0.6'
              AddControl Background def 0 0 'KeyBackground' 'M' 'SetKeyBackground' 0 Script.ORDCHSET
              AddTitle'KeyFont' 'SetKeyFont' 'Key font:'titw 1 0
              def←'''Times New Roman'' 9 System.Drawing.FontStyle.Regular System.Drawing.Color.Navy'
              AddControl ColorFont def 0 1 'KeyFont' 'M' 'SetKeyFont' 0 Script.ORDCHSET
              stw←70
              :If ∨/bubble cloud contour response treemap
                  AddTitle'ScalebarOptions'prop'Scale bar:'titw 0 1
                  AddStyles'ScalebarOptions'∆styles'ScaleBar' 0 0 stw Script.ORDCHSET
                  AddTitle'ScalebarStyle' 'ScalebarStyle' 'Scale bar style:'titw 0 1
                  styles←'Small' 'Left' 'Bottom' 'Right'
                  AddStyles'ScalebarStyle'Causeway.ScalebarStyles styles 0 0 stw Script.ORDCHSET
              :EndIf
          :EndIf
         
          :If Pane'Axes' ⋄ titw←75 ⋄ labw←30 ⋄ stw←90
              :If ~∨/dial pie table
                  AddTitle'AxesOptions'prop'Axes options: 'titw 0 1
                  styles←'NoAxes' 'CroppedAxes' 'ExplodeAxes' 'FrameAxes' 'Clipped' 'RedrawOutline' ⍝ 'ForceZero'
                  AddStyles'AxesOptions'∆styles styles 0 0 stw Script.ORDCHSET
              :EndIf
              :If polar
                  styles←'ClockFace' 'CompassPlot' 'HollowCenter' 'OriginMarker'
                  AddStyles'PolarAxesOptions'∆styles styles 0 0 stw Script.ORDCHSET
              :EndIf
              :If xaxis
                  AddTitle'XAxisOptions' 'XAxisStyle' 'X style:'titw 0 1
                  styles←⊂'NoAxis' 'ForceZero' 'ExactFit' 'Clipped'
                  styles,←⊂'InvisibleAxis' 'TopAxis' 'PlainAxis' 'ArrowedAxis'
                  styles,←⊂'BalancedAxis' 'DuplicateAxes'
                  :If 0 ⋄ def←Causeway.XAxisStyles.ForceZero ⋄ :Else ⋄ def←0 ⋄ :EndIf
                  AddStyles'XAxisOptions'Causeway.XAxisStyles styles def 0 stw Script.ORDCHSET
              :EndIf
              :If yaxis
                  AddTitle'YAxisOptions' 'YAxisStyle' 'Y style:'titw 0 1
                  styles←⊂'NoAxis' 'ForceZero' 'ExactFit' 'Clipped' 'ClampToAxis'
                  styles,←⊂'InvisibleAxis' 'LeftAxis' 'RightAxis' 'PlainAxis' 'ArrowedAxis'
                  styles,←⊂'BalancedAxis' 'DuplicateAxes' 'InvertAxis'
                  :If ∨/bar histogram ⋄ def←Causeway.YAxisStyles.ForceZero ⋄ :Else ⋄ def←0 ⋄ :EndIf
                  AddStyles'YAxisOptions'Causeway.YAxisStyles styles def 0 stw Script.ORDCHSET
              :EndIf
              :If zaxis
                  AddTitle'ZAxisOptions' 'ZAxisStyle' 'Z style:'titw 0 1
                  styles←⊂'PlainAxis' 'ForceZero' 'ExactFit'
                  :If tower ⋄ def←Causeway.ZAxisStyles.ForceZero ⋄ :Else ⋄ def←0 ⋄ :EndIf
                  AddStyles'ZAxisOptions'Causeway.ZAxisStyles styles def 0 stw Script.ORDCHSET
              :EndIf
              :If iaxis
                  AddTitle'IAxisOptions' 'IAxisStyle' 'Inner:'titw 0 1
                  styles←⊂'PlainAxis' 'ForceZero' 'ExactFit'
                  AddStyles'IAxisOptions'Causeway.IAxisStyles styles 0 0 stw Script.ORDCHSET
              :EndIf
              :If xaxis
                  AddTitle'XRange' 'SetXRange' 'X range'titw 1 0
                  AddLabel'Min:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'XRange.Min' 'M' 'SetXRange' 1 Script.ORDCHSET
                  AddLabel'Max:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'XRange.Max' 'M' 'SetXRange' 2 Script.ORDCHSET
              :EndIf
              :If yaxis
                  AddTitle'YRange' 'SetYRange' 'Y range'titw 1 0
                  AddLabel'Min:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'YRange.Min' 'M' 'SetYRange' 1 Script.ORDCHSET
                  AddLabel'Max:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'YRange.Max' 'M' 'SetYRange' 2 Script.ORDCHSET
              :EndIf
              :If zaxis
                  AddTitle'ZRange' 'SetZRange' 'Z range'titw 1 0
                  AddLabel'Min:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'ZRange.Min' 'M' 'SetZRange' 1 Script.ORDCHSET
                  AddLabel'Max:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'ZRange.Max' 'M' 'SetZRange' 2 Script.ORDCHSET
              :EndIf
              :If iaxis
                  AddTitle'IRange' 'SetIRange' 'I range'titw 1 0
                  AddLabel'Min:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'IRange.Min' 'M' 'SetIRange' 1 Script.ORDCHSET
                  AddLabel'Max:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'IRange.Max' 'M' 'SetIRange' 2 Script.ORDCHSET
              :EndIf
              AddTitle'Intercept' 'XIntercept' 'Intercept:'titw 1 0
              :If xaxis ⋄ AddLabel'X:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'Intercept.X' 'P' 'XIntercept' 0 Script.ORDCHSET ⋄ :EndIf
              :If yaxis ⋄ AddLabel'Y:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'Intercept.Y' 'P' 'YIntercept' 0 Script.ORDCHSET ⋄ :EndIf
              :If iaxis ⋄ AddLabel'Inner:' 0 labw ⋄ AddControl NumEdit'0' 0 0 'Intercept.I' 'P' 'IIntercept' 0 Script.ORDCHSET ⋄ :EndIf
              AddTitle'Factor' 'XFactor' 'Factor:'titw 1 0
              :If xaxis ⋄ AddLabel'X:' 0 labw ⋄ AddControl NumEdit'1' 0 0 'Factor.X' 'P' 'XFactor' 0 Script.ORDCHSET ⋄ :EndIf
              :If yaxis ⋄ AddLabel'Y:' 0 labw ⋄ AddControl NumEdit'1' 0 0 'Factor.Y' 'P' 'YFactor' 0 Script.ORDCHSET ⋄ :EndIf
              :If zaxis ⋄ AddLabel'Z:' 0 labw ⋄ AddControl NumEdit'1' 0 0 'Factor.Z' 'P' 'ZFactor' 0 Script.ORDCHSET ⋄ :EndIf
              AddTitle'AxisLine' 'SetAxisStyle' 'Axis style:'titw 1 0
              def←'System.Drawing.Color.Black Causeway.LineStyle.Solid 1.2'
              AddControl Line def 0 0 'AxisLine' 'M' 'SetAxisStyle' 0 Script.ORDCHSET
          :EndIf
         
          :If Pane'Captions' ⋄ titw←85 ⋄ labw←40 ⋄ stw←100
              :If triangle
                  AddTitle'CaptionOptions'prop'Caption options: 'titw 0 1
                  styles←'SideCaptions'
                  def←∆styles.SideCaptions
                  AddStyles'CaptionOptions'∆styles styles def 0 stw Script.ORDCHSET
              :EndIf
              :If xaxis
                  AddTitle'XCaptionOptions' 'XAxisStyle' 'X style:'titw 0 1
                  styles←⊂'CenteredCaption' 'AtEndCaption' 'RightCaption'
                  AddStyles'XCaptionOptions'Causeway.XAxisStyles styles 0 0 stw Script.ORDCHSET
                  AddTitle'XCaption' 'XCaption' 'X caption:'titw 1 0
                  AddControl TextEdit'''''' 0 1 'XCaption' 'P' 'XCaption' 0 Script.ORDCHSET
              :EndIf
              :If yaxis
                  AddTitle'YCaptionOptions' 'YAxisStyle' 'Y style:'titw 0 1
                  styles←⊂'CenteredCaption' 'AtEndCaption'
                  AddStyles'YCaptionOptions'Causeway.YAxisStyles styles 0 0 stw Script.ORDCHSET
                  AddTitle'YCaption' 'YCaption' 'Y caption:'titw 1 0
                  AddControl TextEdit'''''' 0 1 'YCaption' 'P' 'YCaption' 0 Script.ORDCHSET
              :EndIf
              :If zaxis
                  AddTitle'ZCaptionOptions' 'ZAxisStyle' 'Z style:'titw 0 1
                  AddStyles'ZCaptionOptions'Causeway.ZAxisStyles'AtEndCaption' 0 0 stw Script.ORDCHSET
                  AddTitle'ZCaption' 'ZCaption' 'Z caption:'titw 1 0
                  AddControl TextEdit'''''' 0 1 'ZCaption' 'P' 'ZCaption' 0 Script.ORDCHSET
              :EndIf
              AddTitle'CaptionFont' 'SetCaptionFont' 'Caption font:'titw 1 0
              def←'''Times New Roman'' 10 System.Drawing.FontStyle.Regular System.Drawing.Color.Teal'
              AddControl ColorFont def 0 1 'CaptionFont' 'M' 'SetCaptionFont' 0 Script.ORDCHSET
          :EndIf
         
          :If Pane'Ticks' ⋄ titw←75 ⋄ labw←40 ⋄ stw←95
              :If ∨/bar box xbar
                  styles←⊂'TicksBetween' ⍝ 'GridLines' 'OverlayGrid'
                  :If ∨/bar box ⋄ def←∆styles.TicksBetween ⋄ :Else ⋄ def←0 ⋄ :EndIf
                  AddTitle'TickOptions'prop'Ticks:'titw 0 1
                  AddStyles'TickOptions'∆styles styles def 0 stw Script.ORDCHSET
              :EndIf
              :If xaxis
                  AddTitle'XTickStyle' 'XTickStyle' 'X style:'titw 0 1
                  styles←⊂'NoTicks' 'MinorTicks' 'Absolute'
                  styles,←⊂'InsideTicks' 'CrossingTicks' 'DuplicateTicks'
                  AddStyles'XTickStyle'Causeway.XTickStyles styles 0 0 stw Script.ORDCHSET
                  AddTitle'XTickOptions' 'XAxisStyle' 'X style:'titw 0 1
                  styles,←⊂'LogScale' 'Longitude' 'Duration' 'Time' 'Date'
                  styles,←⊂'GridLines' 'OverlayGrid' 'AnnualTicks' 'MonthlyTicks'
                  :If ~∨/bar dial pie treemap ⋄ def←Causeway.XAxisStyles.GridLines ⋄ :Else ⋄ def←0 ⋄ :EndIf
                  AddStyles'XTickOptions'Causeway.XAxisStyles styles def 0 stw Script.ORDCHSET
                  AddTitle'XTickMarks' 'SetXTickMarks' 'X ticks:'titw 1 0
                  AddControl TickMarks TickMarks.DEFAULTS 0 1 'XTickMarks' 'M' 'SetXTickMarks' 0 Script.ORDCHSET
              :EndIf
              :If yaxis
                  AddTitle'YTickStyle' 'YTickStyle' 'Y style:'titw 0 1
                  styles←⊂'NoTicks' 'MinorTicks' 'Absolute'
                  styles,←⊂'InsideTicks' 'CrossingTicks' 'DuplicateTicks'
                  AddStyles'YTickStyle'Causeway.YTickStyles styles 0 0 stw Script.ORDCHSET
                  AddTitle'YTickOptions' 'YAxisStyle' 'Y style:'titw 0 1
                  styles,←⊂'LogScale' 'Latitude' 'Duration' 'Time' 'Date'
                  styles,←⊂'GridLines' 'OverlayGrid' 'AboveGrid' ⍝!!! 'Synchronised'
                  :If ~trace ⋄ def←Causeway.YAxisStyles.GridLines ⋄ :Else ⋄ def←0 ⋄ :EndIf
                  AddStyles'YTickOptions'Causeway.YAxisStyles styles def 0 stw Script.ORDCHSET
                  AddTitle'YTickMarks' 'SetYTickMarks' 'Y ticks:'titw 1 0
                  AddControl TickMarks TickMarks.DEFAULTS 0 1 'YTickMarks' 'M' 'SetYTickMarks' 0 Script.ORDCHSET
              :EndIf
              :If zaxis
                  AddTitle'ZTickOptions' 'ZAxisStyle' 'Z style:'titw 0 1
                  AddStyles'ZTickStyle'Causeway.ZTickStyles'NoTicks' 0 0 stw Script.ORDCHSET
                  :If persp ⋄ def←Causeway.ZAxisStyles.GridLines ⋄ :Else ⋄ def←0 ⋄ :EndIf
                  AddStyles'ZTickOptions'Causeway.ZAxisStyles'GridLines'def 0 stw Script.ORDCHSET
                  AddTitle'ZTickMarks' 'SetZTickMarks' 'Z ticks:'titw 1 0
                  AddControl TickMarks TickMarks.DEFAULTS 0 1 'ZTickMarks' 'M' 'SetZTickMarks' 0 Script.ORDCHSET
              :EndIf
              :If iaxis
                  AddTitle'ITickOptions' 'ITickStyle' 'Inner style:'titw 0 1
                  styles←⊂'NoTicks' 'InsideTicks' 'CrossingTicks'
                  AddStyles'ITickStyle'Causeway.ITickStyles styles 0 0 stw Script.ORDCHSET
                  def←Causeway.IAxisStyles.GridLines
                  AddStyles'ITickOptions'Causeway.IAxisStyles'GridLines'def 0 stw Script.ORDCHSET
                  AddTitle'ITickMarks' 'SetITickMarks' 'Inner ticks:'titw 1 0
                  AddControl TickMarks TickMarks.DEFAULTS 0 1 'ITickMarks' 'M' 'SetITickMarks' 0 Script.ORDCHSET
              :EndIf
              AddTitle'GridLines' 'SetGridLineStyle' 'Grid lines:'titw 1 0
              def←'System.Drawing.Color.Silver Causeway.LineStyle.Solid 0.18'  ⍝(FromArgb 64,3/128)
              AddControl Line def 0 0 'GridLines' 'M' 'SetGridLineStyle' 0 Script.ORDCHSET
          :EndIf
         
          :If Pane'Labels' ⋄ titw←80 ⋄ labw←40 ⋄ stw←95
              :If ∨/triangle table
                  AddTitle'LabelOptions'prop'Label options:'titw 0 1
                  styles←⊂'Spanned' 'Merged' 'Labelled'
                  :If triangle ⋄ def←∆styles.Labelled ⋄ :Else ⋄ def←0 ⋄ :EndIf
                  AddStyles'LabelOptions'∆styles styles def 0 stw Script.ORDCHSET
              :EndIf
              AddTitle'XLabelOptions' 'XAxisStyle' 'X style:'titw 0 1
              styles←⊂'NoLabels' 'InsideLabels' 'MiddleLabels' 'AngledLabels' 'MaskedLabels'
              styles,←⊂'FlatText' 'SpannedLabels' 'OmitLastLabel' 'StayAtEdge'
              :If persp ⋄ def←Causeway.XAxisStyles.AngledLabels
              :ElseIf ∨/bar box ⋄ def←Causeway.XAxisStyles.(AngledLabels+MiddleLabels)
              :Else ⋄ def←0 ⋄ :EndIf
              AddStyles'XLabelOptions'Causeway.XAxisStyles styles def 0 stw Script.ORDCHSET
              AddTitle'XLabels' 'SetXLabels' 'X labels:'titw 1 0
              AddControl PopupExpression_a PopupExpression_a.DEFAULTS 0 1 'XLabels' 'M' 'SetXLabels' 1 Script.ORDCHSET
              :If yaxis
                  AddTitle'YLabelOptions' 'YAxisStyle' 'Y style:'titw 0 1
                  styles←⊂'NoLabels' 'InsideLabels' 'MiddleLabels' 'AngledLabels'
                  styles,←⊂'FlatText' 'StayAtEdge'  ⍝!!! 'Synchronised'
                  :If persp ⋄ def←Causeway.YAxisStyles.AngledLabels ⋄ :Else ⋄ def←0 ⋄ :EndIf
                  AddStyles'YLabelOptions'Causeway.YAxisStyles styles def 0 stw Script.ORDCHSET
                  AddTitle'YLabels' 'SetYLabels' 'Y labels:'titw 1 0
                  AddControl PopupExpression_a PopupExpression_a.DEFAULTS 0 1 'YLabels' 'M' 'SetYLabels' 1 Script.ORDCHSET
              :EndIf
              :If zaxis
                  AddTitle'ZLabelOptions' 'ZAxisStyle' 'Z style:'titw 0 1
                  styles←'NoLabels' 'FlatText'
                  AddStyles'ZLabelOptions'Causeway.ZAxisStyles styles 0 0 stw Script.ORDCHSET
                  AddTitle'ZLabels' 'SetZLabels' 'Z labels:'titw 1 0
                  AddControl PopupExpression_a PopupExpression_a.DEFAULTS 0 1 'ZLabels' 'M' 'SetZLabels' 1 Script.ORDCHSET
              :EndIf
              :If iaxis
                  AddTitle'ILabelOptions' 'IAxisStyle' 'Inner:'titw 0 1
                  AddStyles'ILabelOptions'Causeway.IAxisStyles'NoLabels' 0 0 stw Script.ORDCHSET
                  AddTitle'ILabels' 'SetILabels' 'Inner labels:'titw 1 0
                  AddControl PopupExpression_a PopupExpression_a.DEFAULTS 0 1 'ILabels' 'M' 'SetILabels' 1 Script.ORDCHSET
              :EndIf
              AddTitle'LabelFont' 'SetLabelFont' 'Label font:'titw 1 0
              def←'''Times New Roman'' 8 System.Drawing.FontStyle.Regular System.Drawing.Color.Black'
              AddControl ColorFont def 0 1 'LabelFont' 'M' 'SetLabelFont' 0 Script.ORDCHSET
          :EndIf
         
          :If Pane'Tags' ⋄ titw←95 ⋄ labw←40 ⋄ stw←105
              :If ~∨/box cloud dial response tower trace table
                  AddTitle'ValueTagOptions' 'SetValueTags' 'Value tags:'titw 1(contour)
                  :If contour ⋄ def←∆styles.ValueTags ⋄ :Else ⋄ def←0 ⋄ :EndIf
                  AddStyles'ValueTagOptions'∆styles'ValueTags'def 0 stw Script.ORDCHSET
                  AddControl PopupExpression_a PopupExpression_a.DEFAULTS 0 1 'ValueTags' 'M' 'SetValueTags' 1 Script.ORDCHSET
                  AddTitle'ValueTagStyle' 'ValueTagStyle' 'Value tag style:'titw 0 1
                  styles←⊂'Normal' 'Hints' 'Tips' 'ShowAllTags'
                  styles,←⊂'Inside' 'Vertical' 'Angled' 'Radial'
                  styles,←⊂'Center' 'Left' 'Middle' 'Right'
                  styles,←⊂'Opaque' 'InheritColor' 'RecolorOutside'
                  styles,←⊂'Duration' 'SectorValues' 'CumulativeValues'
                  AddStyles'ValueTagStyle'Causeway.ValueTagStyles styles 0 0 stw Script.ORDCHSET
                  AddTitle'ValueFont' 'SetValueFont' 'Value tag font:'titw 1 0
                  def←'''Arial'' 6 System.Drawing.FontStyle.Regular System.Drawing.Color.Green'
                  AddControl ColorFont def 0 1 'ValueFont' 'M' 'SetValueFont' 0 Script.ORDCHSET
              :EndIf
              :If ∨/bar cloud histogram line scatter step xbar
                  AddTitle'Baseline' 'Baseline' 'Base line:'titw 1 0
                  AddControl NumEdit'0' 0 0 'Baseline' 'P' 'Baseline' 0 Script.ORDCHSET
                  def←'System.Drawing.Color.Black Causeway.LineStyle.Solid 1.2'
                  AddControl Line def 0 0 'Baseline.Line' 'M' 'SetBaselineStyle' 0 Script.ORDCHSET
              :EndIf
              :If ~∨/pie treemap triangle table
                  :If xaxis
                      AddTitle'XDatum' 'SetXDatumLines' 'X Datum:'titw 1 0
                      AddControl PopupExpression_n(Util.EmptySource)0 1 'XDatum' 'M' 'SetXDatumLines' 1 Script.ORDCHSET
                  :EndIf
                  :If yaxis
                      AddTitle'YDatum' 'SetYDatumLines' 'Y Datum:'titw 1 0
                      AddControl PopupExpression_n(Util.EmptySource)0 1 'YDatum' 'M' 'SetYDatumLines' 1 Script.ORDCHSET
                  :EndIf
                  :If zaxis
                      AddTitle'ZDatum' 'SetZDatumLines' 'Z Datum:'titw 1 0
                      AddControl PopupExpression_n(Util.EmptySource)0 1 'ZDatum' 'M' 'SetZDatumLines' 1 Script.ORDCHSET
                  :EndIf
                  AddTitle'DatumLine' 'SetDatumLineStyle' 'Datum line:'titw 1 0
                  def←'System.Drawing.Color.Maroon Causeway.LineStyle.Dash 0.3'
                  AddControl Line def 0 0 'DatumLine' 'M' 'SetDatumLineStyle' 0 Script.ORDCHSET
                  AddTitle'DatumTags' 'SetDatumLineTags' 'Datum tags:'titw 1 0
                  AddControl PopupExpression_a PopupExpression_a.DEFAULTS 0 1 'DatumTags' 'M' 'SetDatumLineTags' 1 Script.ORDCHSET
                  AddTitle'DatumFont' 'SetDatumTagFont' 'Datum font:'titw 1 0
                  def←'''Arial'' 6 System.Drawing.FontStyle.Regular System.Drawing.Color.Green'
                  AddControl ColorFont def 0 1 'DatumFont' 'M' 'SetDatumTagFont' 0 Script.ORDCHSET
              :EndIf
              :If ~∨/pie treemap triangle table
                  :If xaxis
                      AddTitle'XZones' 'SetXZones' 'X Zones:'titw 1 0
                      AddControl MultiZone(Util.EmptySource)0 1 'XZones' 'M' 'SetXZones' 1 Script.ORDCHSET
                  :EndIf
                  :If yaxis
                      AddTitle'YZones' 'SetYZones' 'Y Zones:'titw 1 0
                      AddControl MultiZone(Util.EmptySource)0 1 'YZones' 'M' 'SetYZones' 1 Script.ORDCHSET
                  :EndIf
                  :If iaxis
                      AddTitle'IZones' 'SetIZones' 'I Zones:'titw 1 0
                      AddControl MultiZone(Util.EmptySource)0 1 'IZones' 'M' 'SetIZones' 1 Script.ORDCHSET
                  :EndIf
                  :If persp
                      AddTitle'ZZones' 'SetZZones' 'Z Zones:'titw 1 0
                      AddControl MultiZone(Util.EmptySource)0 1 'ZZones' 'M' 'SetZZones' 1 Script.ORDCHSET
                  :EndIf
              :EndIf
              :If 0∊⍴∆TITLES
                  AddLabel(charttype,' does not provide tags.')0 ⍬
              :EndIf
          :EndIf
         
          :If Pane'Models' ⋄ titw←105 ⋄ labw←40 ⋄ stw←95
              :If histogram
                  AddTitle'HistogramModelOptions'prop'Histogram options:'titw 0 1
                  styles←'NormalCurve' 'Mean' 'SDev1' 'SDev2' 'SDev3'
                  AddStyles'HistogramModelOptions'∆styles styles 0 0 stw Script.ORDCHSET
              :EndIf
              :If ∨/bubble cloud contour line minmax polar response scatter triangle
                  AddTitle'ModelOptions'prop'Model options:'titw 0 1
                  styles←⊂'Curves' 'TrendLine' 'TrendSurface' 'ModelFit' 'GrowthCurve'
                  styles,←⊂'AnnotateModel' 'OnTopModel'
                  AddStyles'ModelOptions'∆styles styles 0 0 stw Script.ORDCHSET
                  AddTitle'Flexibility' 'Flexibility' 'Flexibility:'titw 1 0
                  AddControl NumEdit'3' 0 0 'Flexibility' 'P' 'Flexibility' 0 Script.ORDCHSET
              :EndIf
              :If ∨/cloud contour response scatter
                  AddTitle'MeshDensity' 'MeshDensity' 'Mesh density:'titw 1 0
                  AddControl NumEdit'1' 0 0 'MeshDensity' 'P' 'MeshDensity' 0 Script.ORDCHSET
                  AddTitle'ContourOptions'prop'Contour options:'titw 0 1
                  styles←'Contours' 'ProjectContours' 'NoTags'
                  AddStyles'ContourOptions'∆styles styles 0 0 stw Script.ORDCHSET
              :EndIf
              :If ∨/bubble cloud contour line scatter
                  AddTitle'OrderOfFit' 'SetOrderOfFit' 'Order of fit:'titw 1 0
                  AddLabel'X:' 0 ⍬ ⋄ AddControl NumEdit'1' 0 0 'OrderOfFit.X' 'M' 'SetOrderOfFit' 1 Script.ORDCHSET
                  AddLabel'Y:' 0 ⍬ ⋄ AddControl NumEdit'1' 0 0 'OrderOfFit.Y' 'M' 'SetOrderOfFit' 2 Script.ORDCHSET  ⍝!!! could be enabled only if zaxis
                  AddTitle'EquationStyle' 'EquationStyle' 'Equation style:'titw 0 1
                  styles←⊂'Opaque' 'Absolute' 'Percentage'
                  styles,←⊂'ForceOrigin' 'LinearFit' 'SpanData'
                  styles,←⊂'Below' 'Left' 'Middle' 'Straddle' 'AtEnd'
                  AddStyles'EquationStyle'Causeway.EquationStyles styles 0 0 stw Script.ORDCHSET
                  AddTitle'EquationPosition' 'SetEquationPosition' 'Equation position:'titw 1 0
                  AddLabel'X:' 0 ⍬ ⋄ AddControl NumEdit'1' 0 0 'EquationPosition.X' 'M' 'SetEquationPosition' 1 Script.ORDCHSET
                  AddLabel'Y:' 0 ⍬ ⋄ AddControl NumEdit'1' 0 0 'EquationPosition.Y' 'M' 'SetEquationPosition' 2 Script.ORDCHSET
              :EndIf
              :If 0∊⍴∆TITLES
                  AddLabel(charttype,' does not provide data models.')0 ⍬
              :EndIf
          :EndIf
         
          :If Pane'Formats' ⋄ titw←110
              AddTitle'XLabelFormat' 'XLabelFormat' 'X label format:'titw 1 0
              AddControl TextEdit'''G4''' 0 1 'XLabelFormat' 'P' 'XLabelFormat' 0 Script.ORDCHSET
              AddTitle'XDateFormat' 'XDateFormat' 'X date format:'titw 1 0
              AddControl TextEdit',''d''' 0 1 'XDateFormat' 'P' 'XDateFormat' 0 Script.ORDCHSET
              AddTitle'XTimeFormat' 'XTimeFormat' 'X time format:'titw 1 0
              AddControl TextEdit'''''' 0 1 'XTimeFormat' 'P' 'XTimeFormat' 0 Script.ORDCHSET
              :If yaxis
                  AddTitle'YLabelFormat' 'YLabelFormat' 'Y label format:'titw 1 0
                  AddControl TextEdit'''G4''' 0 1 'YLabelFormat' 'P' 'YLabelFormat' 0 Script.ORDCHSET
                  AddTitle'YDateFormat' 'YDateFormat' 'Y date format:'titw 1 0
                  AddControl TextEdit',''d''' 0 1 'YDateFormat' 'P' 'YDateFormat' 0 Script.ORDCHSET
                  AddTitle'YTimeFormat' 'YTimeFormat' 'Y time format:'titw 1 0
                  AddControl TextEdit'''''' 0 1 'YTimeFormat' 'P' 'YTimeFormat' 0 Script.ORDCHSET
              :EndIf
              :If zaxis
                  AddTitle'ZLabelFormat' 'ZLabelFormat' 'Z label format:'titw 1 0
                  AddControl TextEdit'''G4''' 0 1 'ZLabelFormat' 'P' 'ZLabelFormat' 0 Script.ORDCHSET
              :EndIf
              :If iaxis
                  AddTitle'ILabelFormat' 'ILabelFormat' 'Inner label format:'titw 1 0
                  AddControl TextEdit'''G4''' 0 1 'ILabelFormat' 'P' 'ILabelFormat' 0 Script.ORDCHSET
              :EndIf
              AddTitle'KeyFormat' 'KeyFormat' 'Key format:'titw 1 0
              AddControl TextEdit'''''' 0 1 'KeyFormat' 'P' 'KeyFormat' 0 Script.ORDCHSET
              AddTitle'ValueTagFormat' 'ValueTagFormat' 'Value tag format:'titw 1 0
              AddControl TextEdit'''G4''' 0 1 'ValueTagFormat' 'P' 'ValueTagFormat' 0 Script.ORDCHSET
              AddTitle'DatumTagFormat' 'DatumTagFormat' 'Datum tag format:'titw 1 0
              AddControl TextEdit'''''' 0 1 'DatumTagFormat' 'P' 'DatumTagFormat' 0 Script.ORDCHSET
              AddTitle'EquationFormat' 'EquationFormat' 'Equation format:'titw 1 0
              AddControl TextEdit'''''' 0 1 'EquationFormat' 'P' 'EquationFormat' 0 Script.ORDCHSET
              ⍝ TODO : Equation→heading,subheading,footnote,note,key
          :EndIf
         
         
          :If Pane'Global' ⋄ titw←110 ⋄ labw←60 ⋄ stw←100
              AddLabel'===== SharpPlot global options =====' ¯1 ⍬    ⍝ dummy title
              ⍝ order=¯1 : page initialisation
              AddTitle'PageSize' 'Reset' 'Page size:'titw 1 0
              AddLabel'Width:' 0 labw ⋄ AddControl NumEdit'432' 0 0 'PageSize.Width' 'M' 'Reset' 1 Script.ORDPGINIT
              AddLabel'Height:' 0 labw ⋄ AddControl NumEdit'324' 0 0 'PageSize.Height' 'M' 'Reset' 2 Script.ORDPGINIT
              ⍝ order=¯2 : page setup
              AddTitle'PageBackground' 'SetBackground' 'Page background:'titw 1 0
              def←'System.Drawing.Color.White Causeway.FillStyle.Solid 0'
              AddControl Background def 0 0 'PageBackground' 'M' 'SetBackground' 0 Script.ORDPGSET
              AddTitle'Newline' 'SetNewline' 'Newline character:'titw 1 0
              AddControl Character''';''' 0 0 'Newline' 'M' 'SetNewline' 0 Script.ORDPGSET
              AddTitle'ResetOption' 'ResetOption' 'Reset Options:'titw 1 0
              AddStyles'ResetOption'Causeway.ResetOptions ⍬ 0 0 stw Script.ORDPGSET
              ⍝ order=¯4 : after charts
              ⍝AddLabel'' 1 ⍬                      ⍝ dummy label for empty row
              AddLabel'===== Output image format(s) =====' ¯1 ⍬    ⍝ dummy title
              AddTitle'SaveSvg' 'SaveSvg' 'Save as SVG:'titw 1 0
              AddLabel'SvgMode:' 0 labw ⋄ AddControl SvgMode'Causeway.SvgMode.FixedAspect' 0 0 'SaveSvg.SvgMode' 'M' 'SaveSvg' 2 Script.ORDPGFIN
              AddLabel'File name:' 0 labw ⋄ AddControl SvgFilename'''''' 0 1 'SaveSvg.Filename' 'M' 'SaveSvg' 1 Script.ORDPGFIN
              AddTitle'SavePdf' 'SavePdf' 'Save as PDF:'titw 1 0
              AddLabel'File name:' 0 labw ⋄ AddControl PdfFilename'''''' 0 1 'SavePdf.Filename' 'M' 'SavePdf' 1 Script.ORDPGFIN
              AddTitle'SaveEps' 'SaveEps' 'Save as EPS:'titw 1 0
              AddLabel'File name:' 0 labw ⋄ AddControl EpsFilename'''''' 0 1 'SaveEps.Filename' 'M' 'SaveEps' 1 Script.ORDPGFIN
              AddTitle'SavePs' 'SavePS' 'Save as PS:'titw 1 0
              AddLabel'File name:' 0 labw ⋄ AddControl PsFilename'''''' 0 1 'SavePs.Filename' 'M' 'SavePS' 1 Script.ORDPGFIN
              AddTitle'SavePng' 'SaveImage' 'Save as PNG:'titw 1 0
              AddLabel'Resolution:' 0 labw ⋄ AddControl NumEdit'96' 0 0 'SavePng.Resolution' 'M' 'SaveImage' 3 Script.ORDPGFIN
              AddLabel'File name:' 0 labw ⋄ AddControl PngFilename'''''' 0 1 'SavePng.Filename' 'M' 'SaveImage' 1 Script.ORDPGFIN
              AddControl ⎕NULL'System.Drawing.Imaging.ImageFormat.Png' 0 0 'SavePng.Format' 'M' 'SaveImage' 2 Script.ORDPGFIN
              AddTitle'SaveGif' 'SaveImage' 'Save as GIF:'titw 1 0
              AddLabel'Resolution:' 0 labw ⋄ AddControl NumEdit'96' 0 0 'SaveGif.Resolution' 'M' 'SaveImage' 3 Script.ORDPGFIN
              AddLabel'File name:' 0 labw ⋄ AddControl GifFilename'''''' 0 1 'SaveGif.Filename' 'M' 'SaveImage' 1 Script.ORDPGFIN
              AddControl ⎕NULL'System.Drawing.Imaging.ImageFormat.Gif' 0 0 'SaveGif.Format' 'M' 'SaveImage' 2 Script.ORDPGFIN
              AddTitle'SaveJpg' 'SaveImage' 'Save as JPEG:'titw 1 0
              AddLabel'Resolution:' 0 labw ⋄ AddControl NumEdit'96' 0 0 'SaveJpg.Resolution' 'M' 'SaveImage' 3 Script.ORDPGFIN
              AddLabel'File name:' 0 labw ⋄ AddControl JpgFilename'''''' 0 1 'SaveJpg.Filename' 'M' 'SaveImage' 1 Script.ORDPGFIN
              AddControl ⎕NULL'System.Drawing.Imaging.ImageFormat.Jpeg' 0 0 'SaveJpg.Format' 'M' 'SaveImage' 2 Script.ORDPGFIN
              AddTitle'SaveBmp' 'SaveImage' 'Save as BMP:'titw 1 0
              AddLabel'Resolution:' 0 labw ⋄ AddControl NumEdit'96' 0 0 'SaveBmp.Resolution' 'M' 'SaveImage' 3 Script.ORDPGFIN
              AddLabel'File name:' 0 labw ⋄ AddControl BmpFilename'''''' 0 1 'SaveBmp.Filename' 'M' 'SaveImage' 1 Script.ORDPGFIN
              AddControl ⎕NULL'System.Drawing.Imaging.ImageFormat.Bmp' 0 0 'SaveBmp.Format' 'M' 'SaveImage' 2 Script.ORDPGFIN
              AddTitle'SaveEmf' 'SaveImage' 'Save as EMF:'titw 1 0
              AddLabel'File name:' 0 labw ⋄ AddControl EmfFilename'''''' 0 1 'SaveEmf.Filename' 'M' 'SaveImage' 1 Script.ORDPGFIN
              AddTitle'SaveXaml' 'SaveXaml' 'Save as XAML:'titw 1 0
              AddLabel'File name:' 0 labw ⋄ AddControl EmfFilename'''''' 0 1 'SaveXaml.Filename' 'M' 'SaveXaml' 1 Script.ORDPGFIN
              :If Util.SHARPPLOT350
                  AddTitle'SaveAnimatedGif' 'SaveAnimatedGif' 'Save as animated GIF:'titw 1 0
                  AddLabel'Delay (sec):' 0 labw ⋄ AddControl NumEdit'1' 0 0 'SaveAnimatedGif.Delay' 'M' 'SaveAnimatedGif' 2 Script.ORDPGFIN
                  AddLabel'Resolution:' 0 labw ⋄ AddControl NumEdit'96' 0 0 'SaveAnimatedGif.Resolution' 'M' 'SaveAnimatedGif' 3 Script.ORDPGFIN
                  AddLabel'File name:' 0 labw ⋄ AddControl GifFilename'''''' 0 1 'SaveAnimatedGif.Filename' 'M' 'SaveAnimatedGif' 1 Script.ORDPGFIN
                  AddTitle'SaveAnimatedSvg' 'SaveAnimatedSvg' 'Save as animated SVG:'titw 1 0
                  AddLabel'Delay (sec):' 0 labw ⋄ AddControl NumEdit'1' 0 0 'SaveAnimatedSvg.Delay' 'M' 'SaveAnimatedSvg' 2 Script.ORDPGFIN
                  AddLabel'SvgMode:' 0 labw ⋄ AddControl SvgMode'Causeway.SvgMode.FixedAspect' 0 0 'SaveAnimatedSvg.SvgMode' 'M' 'SaveAnimatedSvg' 3 Script.ORDPGFIN
                  AddLabel'File name:' 0 labw ⋄ AddControl SvgFilename'''''' 0 1 'SaveAnimatedSvg.Filename' 'M' 'SaveAnimatedSvg' 1 Script.ORDPGFIN
              :EndIf
          :EndIf
         
          :If BUILDGUI ⋄ ⎕THIS Gui.Redraw 3 ⋄ :EndIf
        ∇

        ⍝⍝⍝⍝⍝ special interface to get default scripts ⍝⍝⍝⍝⍝
        :Field Public Shared DEFAULTS←⍬
        ∇ OptionsPaneNiladicConstructor;charttype
          :Access Public
          :Implements Constructor
          BUILDGUI←0     ⍝ not really building GUI, just getting default script
          DEFAULTS←⍬
          ⍝ default scripts for each chart
          :For charttype :In Chart.GetTypes
              ∆SCRIPT←⎕NEW Script
              TITLEIDS←∆TITLES←⍬
              Build charttype'All'
              DEFAULTS,←⊂∆SCRIPT.GetValue
          :EndFor
          ⍝ Add one for global page settings
          ∆SCRIPT←⎕NEW Script
          TITLEIDS←∆TITLES←⍬
          Build'Global' 'Global'
          DEFAULTS,←⊂∆SCRIPT.GetValue
          ⍝ Add one for empty charttype
          DEFAULTS,←⊂(⎕NEW Script).GetValue
        ∇
        ∇ script←GetDefaultScript charttype;∆form;inx
          :Access Public Shared
          :If 0∊⍴DEFAULTS
              ⍝ it's fine to create a form here because we will just extract the text of the script, and remember no ref whatsoever
              ∆form←⎕NEW Form ⍬
              {}∆form.⎕NEW OptionsPane             ⍝ use niladic constructor to initialise DEFAULTS
          :EndIf
          script←((Chart.GetTypes,'Global' '')⍳⊂charttype)⊃DEFAULTS
        ∇
    :EndClass

    :EndSection



⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section GUI_chart_setters
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

    :Class ChartSetter : CustomForm             ⍝ CustomControl Form to set up a chart (chart type + chart options)
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private CHARTTYPES               ⍝ possible chart types
        :Field Private CHARTID                  ⍝ chart id
        :Field Private CHARTTYPE                ⍝ current chart type ('' is okay to create a lightweight dummy chartsetter)
        :Field Private CHARTTYPE_BAK            ⍝ saved chart type to back off ChartSetter changes
        :Field Private SCRIPT                   ⍝ chart options script for current chart
        :Field Private SCRIPT_BAK               ⍝ copy of script to back off ChartSetter changes
        :Field Private ∆CHARTTAB                ⍝ Tab control for chart types
        :Field Private ∆CHARTTABS               ⍝ TabButton for each chart type
        :Field Private ∆MENU                    ⍝ Menu to pop up on chart tabbuttons
        :Field Private ∆PANES                   ⍝ SubForm for options panes
        :Field Private PANETYPES                ⍝ identifier for each possible pane
        :Field Private PANETYPE                 ⍝ current pane type
        :Field Private ∆PANETAB                 ⍝ TabCtrl for panes
        :Field Private ∆PANETABS                ⍝ TabButtons for each pane
        :Field Private ∆PANE                    ⍝ OptionsPane control for current pane
        :Field Private ∆BUTTONS                 ⍝ SubForm for buttons
        :Field Private ∆CLOSE                   ⍝ Button to close window
        :Field Private ∆REVERT                  ⍝ Button to revert changes
        ∇ ChartSetterConstructor(charttype script ∆callns callfn);rows;cols;∆objs;charttypes;charttype;butsize;size;charts;sep
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          CHARTID←'' ⋄ CHARTTYPES←Chart.GetTypes
          PANETYPE←⊃PANETYPES←OptionsPane.GetPaneTypes
          butsize←6+32 32
          :Select 'ScrollSubForm'
          :Case 'TabControl'
              ∆CHARTTAB←⎕NEW'TabControl'(('Style' 'FlatButtons')('MultiLine' 1)('Justify' 'None')('FlatSeparators' 0)('HotTrack' 1)('TabSize'butsize))
              ∆CHARTTAB.ImageListObj←Chart.GetImageList
              ∆CHARTTABS←CHARTTYPES ∆CHARTTAB.{⎕NEW'TabButton'(('Caption'⍺)('ImageIndex'⍵))}¨⍳⍴CHARTTYPES
              ∆SUBFORM←∆CHARTTAB Gui.BuildSubForm ⍬
              ⍝!!! ∆CHARTTABS won't have tips nor mouse events
          :Case 'ToolControl'
              ∆CHARTTAB←⎕NEW'ToolControl'(('Multiline' 1)('Divider' 0))
              ∆CHARTTAB.Size←⎕THIS.Size
              ∆CHARTTAB.ImageListObj←Chart.GetImageList
              ∆CHARTTABS←CHARTTYPES ∆CHARTTAB.{⎕NEW'ToolButton'(('Caption'⍺)('ImageIndex'⍵))}¨⍳⍴CHARTTYPES
              ∆SUBFORM←⎕THIS Gui.BuildSubForm ⍬
              ⍝!!! ∆SUBFORM will not take space left by toolbar changing its number of rows
              ⍝!!! ∆CHARTTABS won't have tips
          :Case 'ToolBar'
              ∆CHARTTAB←⎕NEW'ToolBar'(('Align' 'Top')('VScroll' 0)('HScroll' 0)('Size'(2 11×butsize)))⍝ (⊂('Size'(1(⊃⍴CHARTTYPES)×butsize)))
              ⍝∆CHARTTAB.Attach←'Top' 'Left' 'Top' 'Right'
              ∆CHARTTABS←(⊂butsize)∆CHARTTAB.{⎕NEW'Button'(('Size'⍺)('Picture'(⍵ 3)))}¨Chart.GetIcon¨CHARTTYPES
              ⍝∆CHARTTABS Gui.LayoutGrid 0 0 ¯1 ¯1 0
              ∆SUBFORM←⎕THIS Gui.BuildSubForm ⍬
              ⍝!!! ∆CHARTTABS won't re-arrange
          :Case 'ScrollSubForm'
              ∆CHARTTAB←⎕NEW ScrollSubForm(0 2 1 ⍬)
              charts←⊂'Dial' 'Pie'
              charts,←⊂'Bar' 'XBar' 'Gantt'
              charts,←⊂'Line' 'Scatter' 'Trace' 'Polar'
              charts,←⊂'Step' 'MinMax' 'Vector' 'Triangle'
              charts,←⊂'Bubble' 'Contour'
              charts,←⊂'Tower' 'Response' 'Cloud'
              charts,←⊂,⊂'TreeMap'
              charts,←⊂'Histogram' 'Box'
              charts,←⊂,⊂'Table'
              sep←(0×Gui.SPACE)+(3×Gui.SPACE)×(¯1↓∊(-⊃∘⍴¨charts)↑¨1) ⋄ sep←Gui.SPACE,sep,Gui.SPACE
              CHARTTYPES←⊃,/charts
              ∆CHARTTABS←(⊂butsize)∆CHARTTAB.GetChild.{⎕NEW'Button'(('Size'⍺)('Picture'(⍵ 3)))}¨Chart.GetIcon¨CHARTTYPES
              ∆CHARTTABS Gui.LayoutGrid Gui.SPACE sep ¯1 ¯1 0
              ∆CHARTTAB.FitChild ⋄ (2⊃∆CHARTTAB.Size)←(2⊃⎕THIS.Size)
              ∆SUBFORM←⎕THIS Gui.BuildSubForm ⍬
          :EndSelect
          ∆BUTTONS←⎕THIS Gui.BuildSubForm ⍬
          (∆CLOSE ∆REVERT)←∆BUTTONS∘Gui.BuildButton¨'Close' 'Revert'
          (∆CLOSE ∆REVERT)Gui.Tip¨'Close form, keeping changes' 'Revert settings as they were when the window was opened'
          (∆REVERT ∆CLOSE)Gui.LayoutGrid(0)(Gui.SPACE)¯1 1 0
          (3 1⍴∆CHARTTAB ∆SUBFORM ∆BUTTONS)Gui.LayoutGrid(0 1 1 1×Gui.SPACE)(0)(¯1 0 1)(0)1
          ∆CHARTTABS Gui.Tip¨{⍵,⊂'(right-click on icon to pop-up help)'}¨Chart.GetTip¨CHARTTYPES
          ∆PANETAB←∆SUBFORM.⎕NEW'TabControl'(('Style' 'Tabs')('MultiLine' 1)('Justify' 'None'))
          ∆PANETABS←∆PANETAB.{⎕NEW'TabButton'(⊂('Caption'⍵))}¨PANETYPES
          ∆PANETABS Gui.Tip¨OptionsPane.GetPaneTip¨PANETYPES
          ∆CHARTTABS.onMouseDown←⊂'ChartClick'
          (∆CHARTTABS,∆PANETABS,∆CLOSE,∆REVERT).onSelect←⊂'ChartSetterSelect'
          ⎕THIS Gui.Resize 560 650
          ⎕THIS Gui.Limit 0.8
          ∆PANE←⎕NULL
          SetValue charttype CHARTID script
          ⎕THIS.onClose←'CloseChartSetter'    ⍝ work with Gui.Close
        ∇
        ∇ {msg}←CloseChartSetter msg
          Gui.Close ∆PANE
        ∇
        ∇ BuildPane                         ⍝ Build options pane subform
          :If 0∊⍴CHARTTYPE ⋄ :Return ⋄ :EndIf   ⍝!!! no chart id → no pane
          :If ∆PANE≢⎕NULL ⋄ Gui.Close ∆PANE ⋄ :EndIf
          ∆PANE←∆PANETAB.⎕NEW OptionsPane(CHARTTYPE PANETYPE ⎕THIS'UpdateChartSetter')
          ∆PANE.SetValue SCRIPT ⋄ SCRIPT←∆PANE.GetValue ⍝ OptionsPane will enable/disable items based on chart type
        ∇
        ∇ {msg}←ChartClick msg;∆obj;evt;y;x;button;shift;charttype;dq
          (∆obj evt y x button shift)←msg
          :If 2=button ⍝ right click
              charttype←(∆CHARTTABS⍳∆obj)⊃CHARTTYPES
              Gui.ShowHelp Chart.GetMethod charttype
          :EndIf
        ∇
        ∇ {msg}←ChartSetterSelect msg;mask;tab;∆obj;type        ⍝ User click on a button or a tab
          ∆obj←⊃msg
          :If ∆obj≡∆CLOSE
              Gui.Close ⎕THIS                              ⍝ just close - changes have already been updated
          :ElseIf ∆obj≡∆REVERT                             ⍝ revert
              :If CHARTTYPE≢CHARTTYPE_BAK
                  SetChartType CHARTTYPE_BAK
              :EndIf
              ∆PANE.SetValue SCRIPT←SCRIPT_BAK  ⍝!!! not sure if slower to compare than to always reset ? certainly harder =)
              CustomCallback                               ⍝ callback to update with reverted values
          :ElseIf ∨/mask←∆obj∘≡¨∆CHARTTABS                 ⍝ change chart type
              :If CHARTTYPE≢type←⊃mask/CHARTTYPES
                  SetChartType type
                  BuildPane ⋄ CustomCallback                   ⍝ update pane
                  Gui.Focus ⎕THIS                   ⍝ this is because changing chart type may create new Series which will cause a cascaded Gui.Configure→Gui.EmptyQueue→⎕DQ that will steal focus to the main form
              :EndIf
          :ElseIf ∨/mask←∆obj∘≡¨∆PANETABS                  ⍝ change pane
              :If PANETYPE≢type←⊃mask/PANETYPES
                  ∆PANETABS.State←mask
                  PANETYPE←type
                  BuildPane ⋄ CustomCallback                   ⍝ update pane
              :EndIf
          :Else
              Gui.Error'Unhandled object'
          :EndIf
        ∇
        ∇ SetChartType charttype;mask;caption
          CHARTTYPE←charttype ⋄ mask←CHARTTYPE∘≡¨CHARTTYPES
          :If (⊂∆CHARTTAB ⎕WG'Type')∊'TabControl' 'ToolControl'
              ⍝ Setting .State←1 is not enough for TabButtons and ToolButtons
              :If ∨/mask ⋄ 2 ⎕NQ(⊃mask/∆CHARTTABS)'Select' ⋄ :EndIf
          :Else
              ∆CHARTTABS.State←mask
          :EndIf
          UpdateCaption
        ∇
        ∇ SetValue(charttype chartid script)           ⍝ Value setter
          :Access Public
          ⍝Gui.Debug'ChartSetter.SetValue'charttype
          SetChartType CHARTTYPE_BAK←CHARTTYPE←charttype
          SCRIPT_BAK←SCRIPT←script
          SetChartId chartid
          BuildPane
        ∇
        ∇ SetChartId chartid;caption
          :Access Public
          CHARTID←chartid
          UpdateCaption
        ∇
        ∇ UpdateCaption;caption
          caption←'Chart settings'
          :If ~0∊⍴CHARTID ⋄ caption,←': ',(⍕CHARTID),' (',(⍕CHARTTYPE),')' ⋄ :EndIf
          ⎕THIS.Caption←caption
        ∇
        ∇ (charttype chartid script)←GetValue          ⍝ Value getter
          :Access Public
          (charttype chartid script)←CHARTTYPE CHARTID SCRIPT
        ∇
        ∇ UpdateChartSetter ∆pane;pane;options             ⍝ something has changed in the current pane
          :Access Public
          SCRIPT←∆PANE.GetValue
          CustomCallback                        ⍝ callback further
        ∇
    :EndClass



    :Class ChartButton : CustomSubForm          ⍝ CustomControl popping up a ChartSetter a button
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private CHARTTYPE                ⍝ Current chart type
        :Field Private SCRIPT                   ⍝ chart options script for current chart
        :Field Private ∆BUTTON                  ⍝ Button with chart type icon
        :Field Private ∆SUB                     ⍝ SubForm to wrap button nicely
        :Field Private ∆CHARTID                 ⍝ Chart id editor
        :Field Private ∆POPUP                   ⍝ Popup for ChartSetter
        ∇ ChartButtonConstructor(popup charttype ∆callns callfn);∆parent;popup;script
          :Access Public
          :Implements Constructor :Base ∆callns callfn          ⍝Gui.Debug'ChartButton.Constructor :'charttype
          ∆SUB←Gui.BuildSubForm⊂('Size'(38 70))
          ∆BUTTON←∆SUB.⎕NEW'Button'(('Posn'(0 16))('Size'(6+32 32))('BCol'(255 255 255)))
          ∆BUTTON Gui.Tip'Select chart type and set it up (right-click for help)'
          ∆CHARTID←Gui.BuildLabel'' 70 ⋄ ∆CHARTID.Justify←'Center'
          (2 1⍴∆SUB ∆CHARTID)Gui.LayoutGrid(0 Gui.SPACE 0)(0)¯1 ¯1 0
          script←OptionsPane.GetDefaultScript charttype
          ∆POPUP←⎕NEW Popup(ChartSetter(charttype script ⎕THIS'UpdateChartButton'))
          SetValue(charttype''script)                             ⍝ empty chartid will be popuplated by caller later
          ∆BUTTON.onSelect←'PopupChartSetter'                     ⍝ pop up form on button click
          ∆BUTTON.onMouseDown←'MouseDown'
          :If popup ⋄ 1 ⎕NQ ∆BUTTON'Select' ⋄ :EndIf
        ∇
        ∇ Close                                 ⍝ work with Gui.Close
          :Access Public
          Gui.Close ∆POPUP
        ∇
        ∇ {msg}←MouseDown msg;∆obj;evt;y;x;button;shift;charttype;dq
          (∆obj evt y x button shift)←msg
          :If 1=button ⍝ left click
              1 ⎕NQ ∆obj'Select'
          :Else ⍝ right click
              Gui.ShowHelp Chart.GetMethod CHARTTYPE
          :EndIf
          msg←0  ⍝ inhibit event
        ∇
        ∇ SetChartId chartid
          :Access Public
          ∆CHARTID.Caption←CHARTID←chartid
          :If ∆POPUP.IsPoppedUp ⋄ ∆POPUP.GetForm.SetChartId chartid ⋄ :EndIf
        ∇
        ∇ SetValue(charttype chartid script)  ⍝ Value setter  ⍝!!! does not update popup script if it's built
          :Access Public
          ⍝Gui.Debug'ChartButton.SetValue:'charttype chartid
          :If ∆POPUP.IsPoppedUp ⋄ ∆POPUP.GetForm.SetValue charttype chartid script ⋄ :EndIf
          ∆CHARTID.Caption←chartid
          ∆BUTTON.Picture←(Chart.GetIcon charttype)3
          (CHARTTYPE CHARTID SCRIPT)←(charttype chartid script)
        ∇
        ∇ (charttype chartid script)←GetValue ⍝ Value getter
          :Access Public
          (charttype chartid script)←(CHARTTYPE CHARTID SCRIPT)
        ∇
        ∇ {msg}←PopupChartSetter msg            ⍝ Callback from ∆BUTTON.onSelect
          :Access Public
          :If ~∆POPUP.IsPoppedUp ⋄ ∆POPUP.GetForm.SetValue CHARTTYPE CHARTID SCRIPT ⋄ :EndIf
          ∆POPUP.Show 1
        ∇
        ∇ UpdateChartButton ∆ctrl;oldtype                  ⍝ Callback from ∆POPUP
          :Access Public
          oldtype←CHARTTYPE ⋄ (CHARTTYPE CHARTID SCRIPT)←∆POPUP.GetForm.GetValue
          :If CHARTTYPE≢oldtype ⋄ ∆BUTTON.Picture←(Chart.GetIcon CHARTTYPE)3 ⋄ :EndIf
          CustomCallback                        ⍝ callback further
        ∇
    :EndClass


    :Class Charts : CustomSubForm               ⍝ CustomControl using a Replicator of ChartButton
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆CHARTS                  ⍝ Replicator of ChartButton
        :Field Private CHARTTYPES               ⍝ Chart type of each chart button
        :Field Private CHARTIDS                 ⍝ chart id of each chart button
        :Field Private SCRIPTS                  ⍝ chart options script of each chart button
        :field Public Shared ReadOnly CHARTIDBASE←'Chart'    ⍝!!! get a chart id based on charttype ?
        ∇ ChartsConstructor(∆callns callfn);extra
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          ⎕THIS.EdgeStyle←'Plinth'
          ∆CHARTS←⎕NEW Replicator(0 1 1 1 ChartButton(1 'Line'⎕THIS'UpdateCharts')) ⍝ new ChartButtons will pop up options settings form for a Line chart ⋄ vscroll is enabled because we don't want child to be resized to parent, and because when hscroll will show up, height will not be sufficient anymore
          ∆CHARTS.SetControls 3⍴⊂0 ''⎕THIS''                              ⍝ create dummy chartbuttons that don't pop up
          ∆CHARTS.FitChild                                                ⍝ Use this as default size
          ∆CHARTS Gui.LayoutGrid Gui.SPACE Gui.SPACE 0 0 0                ⍝ attach
          ∆CHARTS.SetControls ⍬                                           ⍝ remove dummy controls
          CHARTTYPES←CHARTIDS←SCRIPTS←⍬
          ∆CHARTS ⎕WS'Event'Replicator.(ADDED REMOVED MOVED)'UpdateCharts'      ⍝ update on button creation/move/destruction
        ∇
        ∇ Close                                 ⍝ work with Gui.Close
          :Access Public
          Gui.Close ∆CHARTS
        ∇
        ∇ SetCharts(charttypes chartids);n;scripts
          :Access Public
          n←∪⊃∘⍴¨charttypes chartids
          scripts←OptionsPane.GetDefaultScript¨charttypes
          SetValue(charttypes chartids scripts)
        ∇
        ∇ chartids←AddCharts charttypes;charttype;∆controls
          :Access Public
          chartids←⍬
          :For charttype :In charttypes
              chartids,←CHARTIDS,←⊂CHARTIDS Util.NextId CHARTIDBASE
          :EndFor
          :If ~0∊⍴chartids
              ∆controls←∆CHARTS.AddControls{0 ⍵ ⎕THIS'UpdateCharts'}¨charttypes           ⍝ do not popup options
              ∆controls.SetChartId chartids
              UpdateValue
          :EndIf
        ∇
        ∇ RemoveCharts chartids
          :Access Public
          ∆CHARTS.RemoveControls CHARTIDS∊chartids
          UpdateValue
        ∇
        ∇ UpdateValue
          :If 0∊⍴∆controls←∆CHARTS.GetControls
              (CHARTTYPES CHARTIDS SCRIPTS)←⍬ ⍬ ⍬
          :Else
              (CHARTTYPES CHARTIDS SCRIPTS)←↓⍉↑∆CHARTS.GetControls.GetValue
          :EndIf
        ∇
        ∇ SetValue(charttypes chartids scripts);n;∆controls
          :Access Public
          n←∪⊃∘⍴¨(CHARTTYPES CHARTIDS SCRIPTS)←(charttypes chartids scripts)
          ∆controls←∆CHARTS.SetControls n⍴⊂0 ''⎕THIS'UpdateCharts'                    ⍝ do not popup options - dummy charttype to avoid building pane
          :If n>0 ⋄ ∆controls.SetValue↓⍉↑CHARTTYPES CHARTIDS SCRIPTS ⋄ :EndIf         ⍝ now build the real panes
        ∇
        ∇ (charttypes chartids scripts)←GetValue;n
          :Access Public
          n←⍴∪⊃∘⍴¨(charttypes chartids scripts)←(CHARTTYPES CHARTIDS SCRIPTS)
          :If n≠1 ⋄ Gui.Error'Inconsistent Charts state' ⋄ :EndIf
          :If chartids≢∪chartids ⋄ Gui.Error'Duplicate chart ids' ⋄ :EndIf
        ∇
        ∇ {msg}←UpdateCharts msg;∆ctrls;values;dup;uninit;ok;chartid;chartids;badids;∆ctrl;charttype;∆obj;evt;script            ⍝ callback from ∆CHARTS
          :Access Public
          :If 0∊⍴∆ctrls←∆CHARTS.GetControls
              CHARTTYPES←CHARTIDS←SCRIPTS←⍬
          :Else ⍝ allocate chartid if a new chart was added
              (CHARTTYPES chartids SCRIPTS)←↓⍉↑∆ctrls.GetValue
              ⍝ check chartids are all different
              dup←∨/(∘.≡⍨chartids)∧(∘.≠⍨⍳⍴chartids)     ⍝ duplicate chartids
              :If ∨/dup ⋄ Gui.Error'Duplicate chart ids: ',(⍕dup/chartids) ⋄ :EndIf
              uninit←{0∊⍴⍵}¨chartids                    ⍝ uninitialised chartids
              :If (1<+/uninit) ⋄ Gui.Error'More than one unidentified charts' ⋄ :EndIf
              ⍝!!! could touch (uninit/CHARTTYPES) here, rather than leave it to ChartButton
              ⍝ generate new chart ids if necessary
              CHARTIDS←(~badids←dup∨uninit)/chartids
              :For ∆ctrl chartid :InEach badids∘/¨∆ctrls chartids
                  CHARTIDS,←⊂chartid←CHARTIDS Util.NextId CHARTIDBASE
                  ∆ctrl.SetChartId chartid
              :EndFor
              CHARTIDS←CHARTIDS[⍋badids]  ⍝ back into original order
          :EndIf
          CustomCallback                        ⍝ callback further
        ∇
    :EndClass

    :endSection



⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section GUI_series_setters
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

    :Class Serie : CustomSubForm                ⍝ CustomControl for a serie
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆EXPR                    ⍝ Expression control
        :Field Private ∆G                       ⍝ Group for other controls
        :Field Private ∆LABCHART                ⍝ Label for chart
        :Field Private ∆CHARTID                 ⍝ Chart id control
        :Field Private ∆LABSERIE                ⍝ Label for serie
        :Field Private ∆SERIE                   ⍝ Serie index control (indexing Chart.GetSeries CHARTTYPES[CHARTIDS⍳⊂∆CHARTID.GetValue]) (¯1 for ignored)
        :Field Private CHARTIDS                 ⍝ List of available chart ids - must all be valid
        :Field Private CHARTTYPES               ⍝ list of chart types for each chart id - must all be valid
        ∇ Constructor(∆callns callfn);∆objs
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          ∆EXPR←⎕NEW PopupExpression(⎕THIS'UpdateSerie')
          ∆G←Gui.BuildSubForm ⍬
          ∆objs←∆LABCHART←∆G Gui.BuildLabel('Chart:'⍬)
          ∆objs,←∆CHARTID←∆G.⎕NEW Combo(⍬ ⍬ ⍬ 120 ⎕THIS'UpdateSerie')
          ∆objs,←∆LABSERIE←∆G Gui.BuildLabel('Series:'⍬)
          ∆objs,←∆SERIE←∆G.⎕NEW Combo(⍬ ⍬ ⍬ 230 ⎕THIS'UpdateSerie')
          CHARTTYPES←CHARTIDS←⍬
          ∆objs Gui.LayoutGrid(0)(0 1 1 1 0×Gui.SPACE)¯1 ¯1 0     ⍝ stick top left
          (2 1⍴∆EXPR ∆G)Gui.LayoutGrid(0 Gui.SPACE 0)(0)(¯1)(0)1  ⍝ stick top - stretch width
        ∇
        ∇ Close                                 ⍝ work with Gui.Close
          :Access Public
          Gui.Close ∆EXPR
        ∇
        ∇ UpdateSerie ∆control                       ⍝ callback from controls
          :Access Public
          :If ∆control≡∆CHARTID ⋄ Set ∆CHARTID.GetValue ¯1
          :ElseIf ∆control≡∆SERIE ⋄ Set ∆CHARTID.GetValue ∆SERIE.GetValue ⋄ :EndIf
          CustomCallback                        ⍝ callback further
        ∇
        ∇ SetValue(charttypes chartids chartid serieindex expr);series
          :Access Public
          :If ∨/{0∊⍴⍵}¨charttypes,chartids
          :OrIf ~(⊂chartid)∊chartids,⊂''
              Gui.Error'Invalid Serie Value'
          :EndIf
          (CHARTTYPES CHARTIDS)←(charttypes chartids)
          ∆CHARTID.SetValues chartids,⊂''
          ∆CHARTID.SetTexts(chartids{⍺,' (',⍵,')'}¨charttypes),⊂'(None)'
          Set chartid serieindex
          ∆EXPR.SetSource expr
        ∇
        ∇ Set(chartid serieindex);series;types;type
          :If ~0∊⍴chartid
              (types series)←Chart.GetSeries(CHARTIDS⍳⊂chartid)⊃CHARTTYPES
              series,¨←{' (',⍵,')'}¨Chart.GetFormatDescription¨types
              type←⊃(types,⊂'')[((⍳⍴series),¯1)⍳serieindex]
          :Else
              type←''
              series←⍬
          :EndIf
          ∆CHARTID.SetValue chartid
          ∆SERIE.SetValues(⍳⍴series),¯1
          ∆SERIE.SetTexts(series),⊂'(None)'
          ∆SERIE.SetValue serieindex
          ∆EXPR.SetFormat type
        ∇
        ∇ (charttypes chartids chartid serieindex expr)←GetValue;n
          :Access Public
          n←∪⊃∘⍴¨(charttypes chartids)←(CHARTTYPES CHARTIDS)
          :If n>0
              chartid←∆CHARTID.GetValue
          :Else
              chartid←''
          :EndIf
          serieindex←∆SERIE.GetValue
          expr←∆EXPR.GetSource
        ∇
    :EndClass


    :Class Series : CustomSubForm               ⍝ CustomControl using a Replicator of Serie
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆SERIES                  ⍝ Replicator
        :Field Private CHARTTYPES               ⍝ chart type of each chart
        :Field Private CHARTIDS                 ⍝ chart id of each chart
        :Field Private ∆SCRIPTS                 ⍝ series draw method script of each chart
        :Field Private SERIEIDS                 ⍝ chart id of each serie
        :Field Private SERIEINDICES             ⍝ serie index for each serie
        :Field Private SERIEEXPRS               ⍝ expression for each serie
        ∇ SeriesConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          ⎕THIS.EdgeStyle←'Plinth'
          ∆SERIES←⎕NEW Replicator(3 0 1 0 Serie(⎕THIS'UpdateSeries'))     ⍝ create 3 dummy serie controls
          ∆SERIES Gui.LayoutGrid Gui.SPACE Gui.SPACE 0 0 0          ⍝ take it as default size
          ∆SERIES.SetControls ⍬                                     ⍝ remove dummy controls
          CHARTTYPES←CHARTIDS←SERIEIDS←SERIEINDICES←SERIEEXPRS←SCRIPTS←⍬
          ∆SERIES ⎕WS'Event'Replicator.(ADD MOVED REMOVED)'AddRemove'
        ∇
        ∇ Close                                 ⍝ work with Gui.Close
          :Access Public
          Gui.Close ∆SERIES
        ∇
        SpreadIndices←{⍵+{⍵\1-+\⍵/⍵}⍵<0}          ⍝ spread unused serie indices (¯1) to different unused indices (¯1 ¯2 ¯3...)
        UnspreadIndices←{s←⍵ ⋄ ((s<0)/s)←¯1 ⋄ s}  ⍝ multiple unused serie indices all come back to ¯1
        ∇ SetValue(charttypes chartids scripts);charttype;serieids;serieindices;serieexprs;n;values;chartid;mask;∆script;name;indices;exprs
          :Access Public
          (CHARTTYPES CHARTIDS)←(charttypes chartids)
          :If ~0∊⍴scripts ⋄ ∆SCRIPTS←{⎕NEW Script ⍵}¨scripts ⋄ :Else ⋄ ∆SCRIPTS←⍬ ⋄ :EndIf
          (SERIEIDS SERIEINDICES SERIEEXPRS)←(⍬ ⍬ ⍬)
          ⍝ Get series from chart draw method scripts
          :For charttype chartid ∆script :InEach CHARTTYPES CHARTIDS ∆SCRIPTS
              (name indices exprs)←∆script.GetMethodArgs  ⍝ script only has draw method for this charttype
              :If name≢Chart.GetMethod charttype ⋄ Gui.Error'Script draw method mismatch' ⋄ :EndIf
              n←∪⊃∘⍴¨(SERIEINDICES SERIEEXPRS),←¨(indices exprs)
              SERIEIDS,←n⍴⊂chartid
          :EndFor
          SERIESINDICES←UnspreadIndices SERIEINDICES
          ⍝(SERIEIDS SERIEINDICES SERIEEXPRS)/⍨←¨⊂Util.IsEmptySource¨SERIEEXPRS  ⍝ ignore empty expressions
          n←∪⊃∘⍴¨(SERIEIDS SERIEINDICES SERIEEXPRS)
          ∆SERIES.SetControls n⍴⊂⎕THIS'UpdateSeries'
          :If n>0
              values←↓⍉↑(n⍴⊂CHARTTYPES)(n⍴⊂CHARTIDS)SERIEIDS SERIEINDICES SERIEEXPRS
              ∆SERIES.GetControls.SetValue values
          :EndIf
        ∇
        ∇ (charttypes chartids scripts)←GetValue;n
          :Access Public
          n←⍴∪⊃∘⍴¨(charttypes chartids scripts)←(CHARTTYPES CHARTIDS ∆SCRIPTS.GetValue)
          :If 1≠n ⋄ Gui.Error'Inconsistent Series state' ⋄ :EndIf
        ∇
        ∇ ReadSeries;∆ctrls;values
          ⍝ Read Serie controls
          :If 0∊⍴∆ctrls←∆SERIES.GetControls
              values←⍬ ⍬ ⍬ ⍬ ⍬
          :Else
              values←↓⍉↑∆ctrls.GetValue
              :If ∨/{1≠⊃⍴∪⍵}¨values[1 2],∘⊂¨(CHARTTYPES CHARTIDS)
                  Gui.Error'Inconsistent series control'
              ⍝:ElseIf {⍵≢∪⍵}↓⍉↑values[3 4]
              ⍝    Gui.Error'Multiple expressions mapping to the same series'
              :EndIf
          :EndIf
          (SERIEIDS SERIEINDICES SERIEEXPRS)←values[3 4 5]
          ⍝ Gui.Debug 'Series.SERIEINDICES :' SERIEINDICES
        ∇
        ∇ MakeScripts;chartid;∆script;chartindex;charttype;indices;exprs;index;id;method;expr;mask;unused
          ⍝ update chart draw method scripts
          :For ∆script chartid :InEach ∆SCRIPTS CHARTIDS
              chartindex←CHARTIDS⍳⊂chartid
              charttype←chartindex⊃CHARTTYPES
              (indices exprs)←(chartid∘≡¨SERIEIDS)∘/¨SERIEINDICES SERIEEXPRS
              :If ∨/mask←(indices>0)∧(indices⍳indices)≠⍳⍴indices
                  Gui.Info'Multiple expressions mapping to the same series of ',chartid,' (',charttype,')'
                  (mask/indices)←¯1       ⍝ passively ignore redundant series
                  ⍝ SERIEINDICES←indices  ⍝ actively disable multiple mappings
              :EndIf
              indices←SpreadIndices indices
              method←Chart.GetMethod charttype
              unused←(Chart.GetIndices charttype)~indices ⍝ unset series default to empty source
              indices,←unused ⋄ exprs,←(⍴unused)⍴⊂Util.EmptySource
              ∆script.SetMethodArgs method indices exprs  ⍝ anything else left in the script will disappear
          :EndFor
        ∇
        ∇ UpdateSeries ∆control;serieid;serieindex;serieexpr;name;i     ⍝ callback from ∆SERIES' Serie controls
          :Access Public
          ReadSeries ⋄ MakeScripts ⋄ CustomCallback
        ∇
        ∇ {msg}←AddRemove msg;∆ctrl;evt;chartid;serieindex;charttype;indices;used;serieid             ⍝ callback on ∆SERIES' Replicator.(ADD REMOVED MOVED)
          :If Replicator.ADD≡evt←2⊃msg                            ⍝ set default value for a new serie
              serieid←'' ⋄ serieindex←¯1                          ⍝ default : no serie found
              :If ~0∊⍴serieid←⊃(CHARTIDS~SERIEIDS),⊂''            ⍝ look for next unused chartid
                  serieindex←⊃Chart.GetIndices(CHARTIDS⍳⊂serieid)⊃CHARTTYPES   ⍝ first series index
              :Else                                               ⍝ look for next unused serie in current chartids
                  :For charttype chartid :InEach CHARTTYPES CHARTIDS
                      indices←Chart.GetIndices charttype          ⍝ possible indices for that chart type
                      used←(chartid∘≡¨SERIEIDS)/SERIEINDICES
                      :If ~0∊⍴indices←indices~used                ⍝ there are unused indices
                          serieid←chartid ⋄ serieindex←⊃indices   ⍝ pick up next one
                          :Leave
                      :EndIf
                  :EndFor
              :EndIf
              (∆ctrl←3⊃msg).SetValue CHARTTYPES CHARTIDS serieid serieindex(Util.EmptySource)
          :EndIf                                                  ⍝ nothing to do for a button remove
          ReadSeries ⋄ MakeScripts ⋄ CustomCallback
        ∇
        ∇ AddSeries(chartids indices expressions);n;∆controls;mask;inx
          :Access Public
          :If 0<n←∪⊃∘⍴¨chartids indices expressions
              :If ~∧/mask←chartids∊CHARTIDS ⋄ Gui.Error'AddSeries: Unknown chartids: ',⍕chartids~CHARTIDS ⋄ :EndIf
              (chartids indices expressions)/⍨←¨⊂mask
              ⍝ replace previous series mapped to those
              mask←(⍴SERIEIDS)≥inx←(SERIEIDS{⍺ ⍵}¨SERIEINDICES)⍳(chartids{⍺ ⍵}¨indices)
              ∆SERIES.AddControls(+/~mask)⍴⊂⎕THIS'UpdateSeries'      ⍝ create controls for not found
              ∆controls←∆SERIES.GetControls[inx+(~mask)×¯1++\~mask]  ⍝ control for each new series
              ∆controls.SetValue CHARTTYPES CHARTIDS∘,¨↓⍉↑chartids indices expressions
              ReadSeries ⋄ MakeScripts
          :EndIf
        ∇
        ∇ SetCharts(charttypes chartids);serieid;newtypes;oldtypes;oldtype;newtype;oldindices;newindices;values;newids;mask;indices;used;∆scripts;n;chartid;charttype;unused
          :Access Public
          ⍝ Move scripts around to follow chartid moves
          ∆scripts←{⎕NEW Script}¨chartids
          :If ∨/mask←(⊃⍴CHARTIDS)≥inx←CHARTIDS⍳chartids  ⍝ replace scripts of chartids that survived with their old scripts
              (mask/∆scripts)←∆SCRIPTS[mask/inx]
          :EndIf
          ∆SCRIPTS←∆scripts
          ⍝ Deal with chart type changes
          :If 0∊SERIEINDICES ⋄ Gui.Error'Inconsistent serie indices' ⋄ :EndIf
          oldtypes←(CHARTTYPES,⊂'')[CHARTIDS⍳SERIEIDS]    ⍝ old type of chart for each serie
          newtypes←(charttypes,⊂'')[chartids⍳SERIEIDS]    ⍝ new type of chart for each serie
          mask←(oldtypes≢¨newtypes)∧({~0∊⍴⍵}¨oldtypes)∧({~0∊⍴⍵}¨newtypes)
          :For serieid :In ∪mask/SERIEIDS            ⍝ re-evaluate indices of series for chart types that changed
              mask←serieid∘≡¨SERIEIDS
              :If 1<⍴oldtype←∪mask/oldtypes
              :OrIf 1<⍴newtype←∪mask/newtypes
                  Gui.Error'Conflicting chart types'
                  oldtype←newtype←''
              :EndIf
              (oldindices newindices)←Chart.GetIndices¨oldtype,newtype
              indices←(mask/SERIEINDICES)
              used←(newindices,10⍴¯1)[oldindices⍳((indices>0)/indices)]  ⍝ map used series in same default order     ⍝!!! hardcoded 10⍴¯1 : 10 series should be enough
              ((indices>0)/indices)←used
              ((indices<0)/indices)←(+/indices<0){⍺↑⍵,⍺⍴¯1}newindices~used    ⍝ use remaining unused series in the order they come along ⍝!!! could be cleverer - this loses order if i switch from a charttype with many series to one with fewer series then back again
              (mask/SERIEINDICES)←indices
          :EndFor
          :If 0∊SERIEINDICES ⋄ Gui.Error'Inconsistent serie indices' ⋄ :EndIf
          ⍝ Apply changes
          (CHARTTYPES CHARTIDS)←(charttypes chartids)
          ((~SERIEIDS∊CHARTIDS)/SERIEIDS)←⊂''   ⍝ reset chartids that don't exist anymore
          (({0∊⍴⍵}¨SERIEIDS)/SERIEINDICES)←¯1   ⍝ reset indices for series with no more chart id
              ⍝ Map series with no chart to charts with no series - remember unused chart indices for later
          unused←⍬                              ⍝ unused indices for each chartid
          :For chartid charttype :InEach CHARTIDS CHARTTYPES
              mask←chartid∘≡¨SERIEIDS           ⍝ series that map to this very chart
              indices←(Chart.GetIndices charttype)~(mask/SERIEINDICES)
              :If ∨/mask←{0∊⍴⍵}¨SERIEIDS        ⍝ series that don't map to a chart
                  mask←mask×(⍴indices)≥+\mask      ⍝ series that can map to this chart
                  (mask/SERIEIDS)←⊂chartid      ⍝ et voilà !
                  (mask/SERIEINDICES)←(+/mask)↑indices
                  indices←(+/mask)↓indices      ⍝ leftovers (if any !)
              :EndIf
              unused,←⊂indices
          :EndFor
          :If 0∊SERIEINDICES ⋄ Gui.Error'Inconsistent serie indices' ⋄ :EndIf
          ⍝ Apply changes to existing Series controls
          mask←(~Util.IsEmptySource¨SERIEEXPRS)∨((SERIEIDS∊CHARTIDS)∧(SERIEINDICES>0))  ⍝ useful Series controls
          :If ∨/~mask ⋄ ∆SERIES.RemoveControls~mask ⋄ :EndIf                            ⍝ remove useless controls
          :If ∨/mask                                                                    ⍝ update remaining series
              n←∪⊃∘⍴¨(SERIEIDS SERIEINDICES SERIEEXPRS)
              values←↓⍉↑mask∘/¨(n⍴⊂CHARTTYPES)(n⍴⊂CHARTIDS)SERIEIDS SERIEINDICES SERIEEXPRS
              ∆SERIES.GetControls.SetValue values
          :EndIf
          ReadSeries  ⍝ Serie may have modified the expression to conform expected array format
          :If ~0∊⍴unused                       ⍝ just to prevent ,/ to fail
              chartids←(⊃∘⍴¨unused)/CHARTIDS ⋄ indices←⊃,/unused   ⍝ flatten
              :If ~0∊⍴indices ⋄ AddSeries chartids indices((⍴indices)⍴⊂Util.EmptySource) ⋄ :EndIf
          :EndIf
          ⍝ Apply changes to scripts
          MakeScripts
        ∇

    :EndClass

    :EndSection





⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section Global_Options
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

    :Class GlobalOptions : CustomForm           ⍝ CustomControl Form to set up global page options
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆PANE                    ⍝ OptionsPane for global page options
        :Field Private ∆BUTTONS
        :Field Private ∆CLOSE
        :Field Private ∆REVERT
        :Field Private SCRIPT_BAK               ⍝ backup of OptionsPane script - a global page options script
        ∇ GlobalOptionsConstructor(∆callns callfn)
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          ⎕THIS.Caption←'Global page options'
          ∆PANE←⎕NEW OptionsPane('Global' 'Global'⎕THIS'UpdateGlobal')
          ∆PANE.FitChild
          SCRIPT_BAK←∆PANE.GetValue
          ∆BUTTONS←⎕THIS Gui.BuildSubForm ⍬
          (∆CLOSE ∆REVERT)←∆BUTTONS∘Gui.BuildButton¨'Close' 'Revert'
          (∆CLOSE ∆REVERT)Gui.Tip¨'Close form, keeping changes' 'Revert settings as they were when the window was opened'
          (∆REVERT ∆CLOSE)Gui.LayoutGrid(0)(Gui.SPACE)¯1 1 0
          (2 1⍴∆PANE ∆BUTTONS)Gui.LayoutGrid(0 1 1×Gui.SPACE)(0)(0 1)(0)(1)
          ⎕THIS Gui.Limit 0.8
          (∆CLOSE ∆REVERT).onSelect←⊂'ButtonClick'
          ⎕THIS.onClose←'CloseGlobalOptions'    ⍝ work with Gui.Close
        ∇
        ∇ {msg}←CloseGlobalOptions msg
          Gui.Close ∆PANE
        ∇
        ∇ script←GetValue
          :Access Public
          script←∆PANE.GetValue
          ⍝Gui.Debug'GlobalOptions.GetValue:'∆PANE.GetValue
        ∇
        ∇ SetValue script
          :Access Public
          ⍝(resolution svgmode)←Util.Source¨(resolution svgmode)
          ⍝∆script.SetSource¨('Resolution'resolution)('SvgMode'svgmode)
          ∆PANE.SetValue SCRIPT_BAK←script
          ⍝Gui.Debug'GlobalOptions.SetValue:'∆PANE.GetValue
        ∇
        ∇ UpdateGlobal ∆ctrl                          ⍝ callback from OptionsPane
          :Access Public
          CustomCallback
        ∇
        ∇ {msg}←ButtonClick msg
          :Select ∆obj←⊃msg
          :Case ∆CLOSE
              Gui.Close ⎕THIS                              ⍝ close form - changes already applied
          :Case ∆REVERT
              ∆PANE.SetValue SCRIPT_BAK                    ⍝ revert values
              CustomCallback                               ⍝ callback to update with reverted values
          :Else
              Gui.Error'Unhandled button'
          :EndSelect
        ∇
    :EndClass

    :EndSection




⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section GUI_main_wizard_form
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

    :Class Wizard : CustomForm
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆MENU                    ⍝ Form menu
        :Field Private ∆GLOBAL                  ⍝ Popup for GlobalOptions form
        :Field Private ∆GLOBALSCRIPT            ⍝ Global page option script - from GlobalOptions - we keep it as a ∆SCRIPT instance to be able to access SvgMode and Resolution for the File→SaveImage menu item
        :Field Private RESOLUTION               ⍝ Resolution from GlobalOptions
        :Field Private SVGMODE                  ⍝ SVG mode from GlobalOptions
        :Field Private ∆CHARTS                  ⍝ Charts control
        :Field Private CHARTIDS                 ⍝ chart id of each chart - all valid
        :Field Private CHARTTYPES               ⍝ chart type of each chart - all valid
        :Field Private OPTIONSCRIPTS            ⍝ chart options script for each chart - from Charts
        :Field Private ∆SERIES                  ⍝ Series control
        :Field Private SERIESCRIPTS             ⍝ series draw method script for each chart - from Series
        :Field Private ∆SHARPPLOT               ⍝ SharpPlot instance for the current chart
        :Field Private TXTSCRIPT                ⍝ APL Script to produce the current chart
        :Field Private ∆TXTSCRIPT               ⍝ Form to display script text
        :Field Private REFRESH                  ⍝ Flag : rebuild script, run it and callback for display update when anything changes
        :Field Private ∆EXECNS                  ⍝ copy of execution namespace from Main
        ∇ WizardConstructor(∆callns callfn);n;values
          :Access Public
          :Implements Constructor :Base ∆callns callfn
          ⎕THIS.Caption←'Chart Wizard',Util.DEBUG/' (DEBUG VERSION)'
          REFRESH←1
          ∆EXECNS←Main.GetExecNamespace ⎕THIS
          BuildWizardMenu                  ⍝ Create ∆MENU
          BuildWizardForm                  ⍝ Create and layout ∆CHARTS and ∆SERIES
          ∆GLOBAL←⎕NEW Popup(GlobalOptions(⎕THIS'UpdateWizard'))
          ∆TXTSCRIPT←⎕NEW Popup(TextForm('SharpPlot script' 1 1 ''⍬))  ⍝(⊂'BCol'(255 255 255))
          CHARTTYPES←CHARTIDS←OPTIONSCRIPTS←⍬
          SERIEIDS←SERIEINDICES←SERIEEXPRS←SERIESCRIPTS←⍬
          UpdateGlobal ⋄ UpdateScript
          ⍝∆GLOBAL.Show 0  ⍝!!! because UpdateGlobal called GetForm called OptionsPane.Build called Gui.Redraw←3 while the form was not visible
          ⎕THIS.onClose←'CloseWizard'  ⍝ work with Gui.Close
        ∇
        ∇ {msg}←CloseWizard msg
          Gui.Close¨∆GLOBAL ∆TXTSCRIPT ∆CHARTS ∆SERIES
        ∇
        ∇ BuildWizardForm
          (∆TOP ∆BOT)←Gui.BuildSubForm¨⍬ ⍬
          ∆LAB←∆TOP Gui.BuildSubForm⊂('Size'(50 50))
          ∆LABLINE←∆LAB.⎕NEW'Poly'(('Points'((0 50)(0 50)))('FCol'(255 255 255)))
          ∆LABCHARTS←∆LAB Gui.BuildLabel'Charts:'⍬
          ∆LABSERIES←∆LAB Gui.BuildLabel'Series:'⍬
          ∆LABCHARTS.Posn←0 0+0 1×∆LAB.Size-∆LABCHARTS.Size
          ∆LABCHARTS.Attach←'Top' 'Right' 'Top' 'Right'
          ∆LABSERIES.Posn←5 0+1 0×∆LAB.Size-∆LABSERIES.Size
          ∆LABSERIES.Attach←'Bottom' 'Left' 'Bottom' 'Left'
          ∆CHARTS←∆TOP.⎕NEW Charts(⎕THIS'UpdateWizard')
          ∆SERIES←∆BOT.⎕NEW Series(⎕THIS'UpdateWizard')
          ⍝Gui.Debug 'Setting up'
          (∆LAB ∆CHARTS)Gui.LayoutGrid Gui.SPACE(1 2 1×Gui.SPACE)¯1(¯1 0)1
          (∆SERIES)Gui.LayoutGrid Gui.SPACE Gui.SPACE 0 0 0
          (2 1⍴∆TOP ∆BOT)Gui.LayoutGrid 0 0(¯1 0)(0)1
        ∇
        ∇ {callback}UpdateWizard ∆control;charttypes;chartids  ⍝ callback from controls
          :Access Public
          :If 0=⎕NC'callback' ⋄ callback←1 ⋄ :EndIf
          :If ∆GLOBAL.GetForm∊∆control ⋄ UpdateGlobal ⋄ :EndIf
          :If ∆CHARTS∊∆control ⋄ UpdateCharts ⋄ :EndIf
          :If ∆SERIES∊∆control ⋄ UpdateSeries ⋄ :EndIf
          :If REFRESH
              UpdateScript
              :If callback ⋄ CustomCallback ⋄ :EndIf
          :EndIf
        ∇
        ∇ UpdateGlobal
          ∆GLOBALSCRIPT←⎕NEW Script ∆GLOBAL.GetForm.GetValue
        ∇
        ∇ UpdateCharts;charttypes;chartids;n
          n←∪⊃∘⍴¨(charttypes chartids OPTIONSCRIPTS)←∆CHARTS.GetValue
          :If (CHARTTYPES CHARTIDS)≢(charttypes chartids)       ⍝ update only if necessary
              (CHARTTYPES CHARTIDS)←(charttypes chartids)
              ∆SERIES.SetCharts CHARTTYPES CHARTIDS
              UpdateSeries
          :EndIf
        ∇
        ∇ UpdateSeries;n;charttypes;chartids;scripts
          n←∪⊃∘⍴¨(charttypes chartids SERIESCRIPTS)←∆SERIES.GetValue
          :If (CHARTTYPES CHARTIDS)≢(charttypes chartids) ⋄ Gui.Error'Inconsistent charts/series' ⋄ :EndIf
        ∇
        ∇ UpdateScript;alltypes;txt;chartid;charttype;using;∆options;inx;∆series;name;chunk;options;series;values;msg
          ⍝!!! series performance improvement possible by caching parts of script that haven't changed
          name←'sp'
          alltypes←Chart.GetTypes
          txt←⊂'⍝ Global page set-up'
          using←''',sharpplot.dll'' '',system.drawing.dll'''
          ⍝ using←Util.Source ⎕USING  ⍝ wrongly includes System.Windows.Forms
          txt,←⊂'⎕USING←',using,' ⍝ you probably want to localise ⎕USING'
          txt,←⊂'⍝ To use cross-platform SharpPlot, comment the above and un-comment below'
          txt,←⊂'⍝ :If 0=⎕NC''Causeway'' ⋄ (System.Drawing←System←⍎''Causeway''⎕NS'''').(⎕CY''sharpplot'') ⋄ :EndIf  ⍝ workspace copied only once if Causeway and System are not localised'
          txt,←⊂name,'←⎕NEW Causeway.SharpPlot'
          txt,←Script.(ORDPGINIT ORDPGSET)∆GLOBALSCRIPT.GetAPLScript name   ⍝ global page options script
          txt,←⊂''
          :For chartid options series :InEach CHARTIDS OPTIONSCRIPTS SERIESCRIPTS
              ∆options←⎕NEW Script options      ⍝ chart options script
              ∆series←⎕NEW Script series           ⍝ series draw method scripts
              inx←CHARTIDS⍳⊂chartid
              charttype←inx⊃CHARTTYPES
              txt,←⊂'⍝ ',chartid,' (',charttype,')'
              txt,←Script.(ORDCHPAGE ORDCHFRAME ORDCHSET)∆options.GetAPLScript name
              txt,←Script.(ORDCHDRAW)∆series.GetAPLScript name
              txt,←Script.(ORDCHFIN)∆options.GetAPLScript name
              txt,←⊂''
          :EndFor
          :If ~0∊⍴chunk←Script.(ORDPGFIN)∆GLOBALSCRIPT.GetAPLScript name   ⍝ global page options script
              txt,←⊂'⍝ Post-processing'
              txt,←chunk
              txt,←⊂''
          :EndIf
          txt,←⊂'⍝ (⎕NEW Causeway.SharpPlotViewer ',name,').Show ⍬        ⍝ Uncomment this line to view the chart (Windows IDE)'
          txt,←⊂'⍝ 3500⌶',name,'.RenderSvg Causeway.SvgMode.FixedAspect   ⍝ Uncomment this line to view the chart (RIDE)'
          TXTSCRIPT←txt
          (msg ∆SHARPPLOT)←∆EXECNS name Util.Run txt   ⍝ returned value is that of shadowed name
          :If ~0∊⍴msg
              ∆SHARPPLOT←⎕NEW Causeway.SharpPlot
              ∆SHARPPLOT Chart.Print msg
          :EndIf
        ∇
        ∇ (g i t o s a)←GetValue  ⍝ return state a one array
          ⍝ :Access Public
          g←∆GLOBALSCRIPT.GetValue
          i←CHARTIDS ⋄ t←CHARTTYPES
          o←OPTIONSCRIPTS
          s←SERIESCRIPTS
          a←TXTSCRIPT
        ∇
        ∇ SetValue(g i t o s a)   ⍝ return state a one array
          ⍝ :Access Public
          ∆GLOBALSCRIPT.SetValue g ⋄ ∆GLOBAL.GetForm.SetValue g  ⍝ our copy ⋄ ∆GLOBAL's copy
          ∆CHARTS.SetValue(CHARTTYPES←t)(CHARTIDS←i)(OPTIONSCRIPTS←o)
          ∆SERIES.SetValue(CHARTTYPES←t)(CHARTIDS←i)(SERIESCRIPTS←s)
          ⍝ TXTSCRIPT←a ⍝ could be used for manual disaster recovery, or for very harsh reconstruction test     ⍝ :if TXTSCRIPT≢a ⋄ Gui.Error ⋄ :EndIf
          :If REFRESH ⋄ UpdateScript ⋄ :EndIf
        ∇

        ∇ value←Eval expr
          :Access Public
          value←2⊃∆EXECNS''Util.Run expr  ⍝ silently ignore errors
        ∇


        ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Public API ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

        ∇ Reset;global
        ⍝ Reset wizard to no chart and no series
          :Access Public
          global←OptionsPane.GetDefaultScript'Global'
          SetValue(global ⍬ ⍬ ⍬ ⍬ ⍬)
          :If REFRESH ⋄ CustomCallback ⋄ :EndIf
        ∇
        ∇ ∆sharpplot←GetSharpPlot
        ⍝ Get the Causeway.SharpPlot instance of the current chart
          :Access Public
          ∆sharpplot←∆SHARPPLOT
        ∇
        ∇ nestedtext←GetScript
        ⍝ Get the APL script that generates the current chart
          :Access Public
          nestedtext←TXTSCRIPT
        ∇
        ∇ charttypes←GetChartTypes
        ⍝ Get the list of chart types supported by the Chart Wizard
          :Access Public
          charttypes←Chart.GetTypes
        ∇
        ∇ series←GetSeries charttype
        ⍝ Get the list of series for a given chart type
          :Access Public
          series←2⊃Chart.GetSeries,charttype
        ∇
        ∇ chartids←GetChartIds
        ⍝ Get the current list of chart identifiers
          :Access Public
          chartids←CHARTIDS
        ∇
        ∇ charttype←GetChartType chartid;inx
        ⍝ Get the chart type of target chart identifier
          :Access Public
          charttype←''
          :If (⍴CHARTIDS)<inx←CHARTIDS⍳⊂,chartid ⋄ Gui.Info'Unknown chart identifier: ',,⍕chartid ⋄ :Return ⋄ :EndIf
          charttype←inx⊃CHARTTYPES
        ∇
        ∇ chartids←AddCharts charttypes;simple;mask
        ⍝ Add new charts - return the identifier of each
          :Access Public
          :If simple←1≥|≡charttypes ⋄ charttypes←⊂,charttypes ⋄ :EndIf
          :If ~∧/mask←charttypes∊Chart.GetTypes ⋄ Gui.Info'Unknown chart types:'(,⍕∪(~mask)/charttypes) ⋄ :EndIf
          chartids←∆CHARTS.AddCharts,mask/charttypes
          :If simple ⋄ chartids←⊃chartids ⋄ :EndIf
          UpdateCharts
          Refresh REFRESH
        ∇
        ∇ RemoveCharts chartids;mask
        ⍝ Remove charts with target identifiers
          :Access Public
          :If 1≥|≡chartids ⋄ chartids←,⊂,chartids ⋄ :EndIf
          ∆CHARTS.RemoveCharts,chartids
          UpdateCharts
          Refresh REFRESH
        ∇
        ∇ SetSeries(chartid series expression);inx;names;indices
        ⍝ Set one series' expression for target chart
          :Access Public
          :If ~Util.IsText expression ⋄ expression←Util.Source expression ⋄ :EndIf
          :If (⍴CHARTIDS)<inx←CHARTIDS⍳⊂chartid←,chartid ⋄ Gui.Info'Unknown chart identifier: '(,⍕chartid) ⋄ :Return ⋄ :EndIf
          names←2⊃Chart.GetSeries inx⊃CHARTTYPES
          :If (⍴names)<inx←names⍳⊂,series ⋄ Gui.Info'Unknown series identifier: '(,⍕series) ⋄ :Return ⋄ :EndIf
          ∆SERIES.AddSeries,∘⊂¨chartid inx(,expression)
          UpdateSeries
          Refresh REFRESH
        ∇
        ∇ options←GetGlobalOptions
        ⍝ Get list of SharpPlot API names for target chart's options
          :Access Public
          options←{⍵[⍋↑⍵]}∪(∆GLOBALSCRIPT.GetValue)[;Script.NAME]  ⍝!!! violation of the Script API
          options/⍨←'Save'∘≢¨4↑¨options                            ⍝!!! hide SaveImage, which can not be set this way because it belongs to multiple script groups
        ∇
        ∇ {issource}SetGlobalOption(option value)
        ⍝ Set value of a chart option. Warning : inadequate values may go undetected, and trigger an error later, when the attached GUI control is rebuilt
          :Access Public
          :If 0=⎕NC'issource' ⋄ issource←0 ⋄ :EndIf   ⍝ Warning ! giving a wrongful source expression may silently break the chart wizard, which would fail only later.
          issource ∆GLOBALSCRIPT.SetArgs(option value)
          Refresh REFRESH
        ∇
        ∇ options←GetChartOptions chartid;inx
        ⍝ Get list of SharpPlot API names for target chart's options
          :Access Public
          :If (⍴CHARTIDS)<inx←CHARTIDS⍳⊂,chartid ⋄ Gui.Info'Unknown chart identifier : '(,⍕chartid) ⋄ :Return ⋄ :EndIf
          options←{⍵[⍋↑⍵]}∪(inx⊃OPTIONSCRIPTS)[;Script.NAME]  ⍝!!! violation of the Script API
        ∇
        ∇ {issource}SetChartOption(chartid option value);inx;∆script
        ⍝ Set value of a chart option.
          :Access Public
          :If 0=⎕NC'issource' ⋄ issource←0 ⋄ :EndIf   ⍝ Warning ! giving a wrongful source expression may silently break the chart wizard, which would fail only later.
          :If (⍴CHARTIDS)<inx←CHARTIDS⍳⊂,chartid ⋄ Gui.Info'Unknown chart identifier : '(,⍕chartid) ⋄ :Return ⋄ :EndIf
          ∆script←⎕NEW Script(inx⊃OPTIONSCRIPTS)
          issource ∆script.SetArgs(option value)
          (inx⊃OPTIONSCRIPTS)←∆script.GetValue
          ∆CHARTS.SetValue CHARTTYPES CHARTIDS OPTIONSCRIPTS
          Refresh REFRESH
        ∇
        ∇ Refresh on
        ⍝ Rebuild script, run it, and display output chart.
          :Access Public
          :If REFRESH←on ⋄ UpdateScript ⋄ CustomCallback ⋄ :EndIf
        ∇
        ∇ SaveSession filename
        ⍝ Save current chart wizard session to file
          :Access Public
          4 Save,filename  ⍝ do not ask for confirmation before overwrite
        ∇
        ∇ LoadSession filename
        ⍝ Load a chart wizard session from file
          :Access Public
          Load,filename
        ∇
        ∇ RunSample sample
        ⍝ Run a sample
          :Access Public
          'Unknown samples'⎕SIGNAL(~(⊂sample)∊GetSamples)/11
          ⎕THIS.Reset
          (Samples⍎sample)⎕THIS
        ∇
        ∇ samples←GetSamples
        ⍝ Get list of available samples
          :Access Public
          samples←Samples.⎕NL ¯3
        ∇

        ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ MENUS ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

        ∇ BuildWizardMenu
          ∆MENU←⎕NEW'MenuBar'(⊂('EdgeStyle' 'None'))
          ∆MENU.∆FILE←∆MENU.⎕NEW'Menu'(⊂('Caption' 'File'))
          (∆MENU.∆FILE.∆VIEW←∆MENU.∆FILE.⎕NEW'MenuItem'(⊂('Caption' 'View Script'))).onSelect←'DoShowScript'
          :If Util.DEBUG
              (∆MENU.∆FILE.∆DEBUG←∆MENU.∆FILE.⎕NEW'MenuItem'(⊂('Caption' 'View Debug Script'))).onSelect←'DoDebugScript'
          :EndIf
          (∆MENU.∆FILE.∆IMAGE←∆MENU.∆FILE.⎕NEW'MenuItem'(⊂('Caption' 'Save Image'))).onSelect←'DoSaveImage'
          (∆MENU.∆FILE.∆SAVE←∆MENU.∆FILE.⎕NEW'MenuItem'(⊂('Caption' 'Save Wizard session'))).onSelect←'DoSaveSession'
          (∆MENU.∆FILE.∆OPEN←∆MENU.∆FILE.⎕NEW'MenuItem'(⊂('Caption' 'Load Wizard session'))).onSelect←'DoLoadSession'
          (∆MENU.∆OPTIONS←∆MENU.⎕NEW'MenuItem'(⊂('Caption' 'Page Options'))).onSelect←'DoPageOptions'
          ∆MENU.∆SAMPLES←∆MENU.⎕NEW'Menu'(⊂('Caption' 'Samples'))
          BuildSamplesMenu ∆MENU.∆SAMPLES
          ∆MENU.∆HELP←∆MENU.⎕NEW'Menu'(⊂('Caption' 'Help'))
          (∆MENU.∆HELP.∆WIZARD←∆MENU.∆HELP.⎕NEW'MenuItem'(⊂('Caption' 'Chart Wizard Help'))).onSelect←'DoHelpWizard'
          (∆MENU.∆HELP.∆SPLOT←∆MENU.∆HELP.⎕NEW'MenuItem'(⊂('Caption' 'SharpPlot Help'))).onSelect←'DoHelpSharpPlot'
          (∆MENU.∆HELP.∆ABOUT←∆MENU.∆HELP.⎕NEW'MenuItem'(⊂('Caption' 'About...'))).onSelect←'DoAbout'
        ∇
        ∇ BuildSamplesMenu ∆menu
          (∆menu.∆BUSINESS←∆menu.⎕NEW'MenuItem'(⊂('Caption' 'Business chart'))).onSelect←'DoSample'
          (∆menu.∆LINE←∆menu.⎕NEW'MenuItem'(⊂('Caption' 'Simple line chart'))).onSelect←'DoSample'
          (∆menu.∆SURFACE←∆menu.⎕NEW'MenuItem'(⊂('Caption' 'Stacked surfaces'))).onSelect←'DoSample'
          (∆menu.∆RADAR←∆menu.⎕NEW'MenuItem'(⊂('Caption' 'Feature comparison'))).onSelect←'DoSample'
          (∆menu.∆TRACE←∆menu.⎕NEW'MenuItem'(⊂('Caption' 'Parallel trace'))).onSelect←'DoSample'
          (∆menu.∆SCATTER←∆menu.⎕NEW'MenuItem'(⊂('Caption' 'Scatter linear fit'))).onSelect←'DoSample'
          (∆menu.∆VECTOR←∆menu.⎕NEW'MenuItem'(⊂('Caption' 'Vector fields'))).onSelect←'DoSample'
          (∆menu.∆CONTOUR2←∆menu.⎕NEW'MenuItem'(⊂('Caption' 'Double contour plot'))).onSelect←'DoSample'
          (∆menu.∆HISTO←∆menu.⎕NEW'MenuItem'(⊂('Caption' 'Histogram'))).onSelect←'DoSample'
          (∆menu.∆RESP2←∆menu.⎕NEW'MenuItem'(⊂('Caption' '2D response surface'))).onSelect←'DoSample'
          (∆menu.∆RESP3←∆menu.⎕NEW'MenuItem'(⊂('Caption' '3D response surface'))).onSelect←'DoSample'
          (∆menu.∆CONTOUR1←∆menu.⎕NEW'MenuItem'(⊂('Caption' '2D regression surface'))).onSelect←'DoSample'
          (∆menu.∆CONTOUR3←∆menu.⎕NEW'MenuItem'(⊂('Caption' '3D regression surface'))).onSelect←'DoSample'
          (∆menu.∆BASE10←∆menu.⎕NEW'MenuItem'(⊂('Caption' 'Why base-10 is cool'))).onSelect←'DoSample'
          (∆menu.∆BASE12←∆menu.⎕NEW'MenuItem'(⊂('Caption' 'Why base-12 is cool'))).onSelect←'DoSample'
          (∆menu.∆PSYCHO←∆menu.⎕NEW'MenuItem'(⊂('Caption' 'Psychoscope'))).onSelect←'DoSample'
          (∆menu.∆BUBBLE←∆menu.⎕NEW'MenuItem'(⊂('Caption' 'Constant-momentum bubbles'))).onSelect←'DoSample'
          (∆menu.∆SPLASH1←∆menu.⎕NEW'MenuItem'(⊂('Caption' 'SharpPlot splash screen 1'))).onSelect←'DoSample'
          (∆menu.∆SPLASH2←∆menu.⎕NEW'MenuItem'(⊂('Caption' 'SharpPlot splash screen 2'))).onSelect←'DoSample'
        ∇
        ∇ {msg}←DoSample msg;∆obj;∆menu
          ⎕THIS.Reset
          ∆menu←(∆obj←⊃msg).##
          :Select ∆obj
          :Case ∆menu.∆BUSINESS ⋄ Samples.Business ⎕THIS
          :Case ∆menu.∆SCATTER ⋄ Samples.Scatter ⎕THIS
          :Case ∆menu.∆VECTOR ⋄ Samples.Vector ⎕THIS
          :Case ∆menu.∆RESP2 ⋄ Samples.Response2D ⎕THIS
          :Case ∆menu.∆RESP3 ⋄ Samples.Response3D ⎕THIS
          :Case ∆menu.∆CONTOUR1 ⋄ Samples.Contour1 ⎕THIS
          :Case ∆menu.∆CONTOUR2 ⋄ Samples.Contour2 ⎕THIS
          :Case ∆menu.∆CONTOUR3 ⋄ Samples.Contour3 ⎕THIS
          :Case ∆menu.∆BASE10 ⋄ Samples.Base10 ⎕THIS
          :Case ∆menu.∆BASE12 ⋄ Samples.Base12 ⎕THIS
          :Case ∆menu.∆PSYCHO ⋄ Samples.Psycho ⎕THIS
          :Case ∆menu.∆HISTO ⋄ Samples.Histogram ⎕THIS
          :Case ∆menu.∆BUBBLE ⋄ Samples.Bubble ⎕THIS
          :Case ∆menu.∆RADAR ⋄ Samples.Radar ⎕THIS
          :Case ∆menu.∆TRACE ⋄ Samples.Trace ⎕THIS
          :Case ∆menu.∆SPLASH1 ⋄ Samples.Splash1 ⎕THIS
          :Case ∆menu.∆SPLASH2 ⋄ Samples.Splash2 ⎕THIS
          :Case ∆menu.∆LINE ⋄ Samples.Line ⎕THIS
          :Case ∆menu.∆SURFACE ⋄ Samples.Surface ⎕THIS
          :Else ⋄ Gui.Error'Unhandled menu item'
          :EndSelect
        ∇

        ∇ {msg}←DoPageOptions msg
          ∆GLOBAL.GetForm.SetValue ∆GLOBALSCRIPT.GetValue  ⍝ Global Options form might have been closed
          ∆GLOBAL.Show 1
        ∇
        ∇ {msg}←DoShowScript msg
          ∆TXTSCRIPT.GetForm.SetText TXTSCRIPT
          ∆TXTSCRIPT.GetForm Gui.Limit 0.8
          ∆TXTSCRIPT.Show 1
        ∇
        ∇ {msg}←DoSamples msg;∆obj
          :Access Public  ⍝!!! Callback is set by Samples.BuildMenu
          Reset
          ⎕THIS Samples.Run ∆MENU.SAMPLES(∆obj←⊃msg)
        ∇
        ∇ {msg}←DoDebugScript msg;txt;ShowScript;chartid;charttype;options;series;∆form
          txt←⊂'===== Global Settings ====='
          txt,←↓⍕∆GLOBALSCRIPT.GetValue
          txt,←⊂''
          :For chartid charttype options series :InEach CHARTIDS CHARTTYPES OPTIONSCRIPTS SERIESCRIPTS
              txt,←⊂'===== Options for ',chartid,' (',charttype,') ====='
              txt,←↓⍕options
              txt,←⊂'===== Series for ',chartid,' (',charttype,') ====='
              txt,←↓⍕series
              txt,←⊂''
          :EndFor
          ∆form←⎕THIS Main.BuildForm DisplayForm('Debug Script' 1 1 txt(⊂'BCol'(255 255 255)))
          ∆form.State←2 ⍝ maximise
          ∆form.Show 1  ⍝ non-blocking
        ∇
        ∇ {msg}←DoHelpWizard msg;caption;txt;∆form
          caption←'Chart Wizard help'
          txt←⊂'The Chart Wizard is a frontend to set up arbitrarily complex SharpPlot charts.'
          txt,←⊂''
          txt,←⊂'=== Charts ==='
          txt,←⊂''
          txt,←⊂'The top of the main form shows the list of charts that will be overlaid'
          txt,←⊂'on the drawing page. Click on a chart icon to select its chart type'
          txt,←⊂'and access its settings.'
          txt,←⊂''
          txt,←⊂'In that chart settings form, most entries are shown with a tickbox'
          txt,←⊂'as a title: this is to enable/disable the SharpPlot call.'
          txt,←⊂'When disabled, SharpPlot will use "factory defaults".'
          txt,←⊂'Right-clicking on a title will pop up the SharpPlot help for that setting.'
          txt,←⊂''
          txt,←⊂'Edit fields in a yellow background expect valid apl expressions'
          txt,←⊂'executed in the namespace from which the chart wizard was called.'
          txt,←⊂'You may double click on them to pop-up an form that displays the array.'
          txt,←⊂'Their tip fields will tell you what kind of array they expect.'
          txt,←⊂'For more details, right-click on their title to get specific help.'
          txt,←⊂''
          txt,←⊂'=== Data Series ==='
          txt,←⊂''
          txt,←⊂'The rest of the main form is a list of data series produced by'
          txt,←⊂'APL expressions (on yellow-background edits), and mapped to'
          txt,←⊂'chart arguments via combo boxes attached to that edit.'
          txt,←⊂''
          txt,←⊂'=== Global page options ==='
          txt,←⊂''
          txt,←⊂'Global page options are accessible through the eponymous menu item.'
          txt,←⊂'These settings affect the whole script, independently of the charts'
          txt,←⊂'actually drawn onto it.'
          txt,←⊂''
          txt,←⊂'=== Using the Chart Viewer ==='
          txt,←⊂''
          txt,←⊂'The title of the window shows the current resolution of the chart display.'
          txt,←⊂'- Fit image to window: press Space or Escape'
          txt,←⊂'- Zoom in: double left-click, or press + or Enter'
          txt,←⊂'- Zoom out: double right-click, or press - or Backspace'
          txt,←⊂'- Move image (when zoomed in): drag the mouse while clicking,'
          txt,←⊂'  or press Arrows, Home/End/PageUp/PageDown'
          txt,←⊂''
          txt,←⊂'=== So what? ==='
          txt,←⊂''
          txt,←⊂'Once you''re happy with your chart set-up, you can:'
          txt,←⊂'- save your current settings as a Chart Wizard session'
          txt,←⊂'  to load it later and keep working on your data'
          txt,←⊂'- save the chart as an image (raster, vector, etc.)'
          txt,←⊂'- look at the APL script that produces it'
          txt,←⊂'- paste the script into your application code so that'
          txt,←⊂'  it produces the same chart from similar workspace data.'
          txt,←⊂''
          txt,←⊂'=== One Last advice ==='
          txt,←⊂''
          txt,←⊂'Remember that SharpPlot is a state machine, so that the order'
          txt,←⊂'in which you do things DOES matter. For example, if you set some'
          txt,←⊂'X Labels for one chart, the next chart will reuse those values,'
          txt,←⊂'unless you explicitly reset them.'
          txt,←⊂''
          txt,←⊂'Nicolas Delcros - Dyalog 2014-2018'
          ∆form←⎕THIS Main.BuildForm DisplayForm(caption 0 0 txt ⍬)
          ∆form Gui.Resize(0.5×1⊃Gui.GetScreenSize)(400)
          ∆form.Show 1  ⍝ non-blocking
        ∇
        ∇ {msg}←DoHelpSharpPlot msg
          Gui.ShowHelp''
        ∇
        ∇ {msg}←DoAbout msg;txt
          :Access Public
          txt←⊂'Chart Wizard v',Util.GetWizardVersion,' using SharpPlot v',Util.SHARPPLOTVERSION
          txt,←⊂'Nicolas Delcros - Dyalog Ltd. 2014-2018'
          Gui.Info txt
        ∇
        ∇ {msg}←DoSaveImage msg;∆form;file;dq;filters;∆sp;dir;events;resolution;svgmode;id;tie;index;delay
          filters←⊂('*.png' 'Portable Network Graphics (*.png)')            ⍝ 1
          filters,←⊂('*.svg' 'Scalable Vector Graphics (*.svg)')            ⍝ 2
          :If Util.SHARPPLOT350
              filters,←⊂('*.svg' 'Animated SVG (*.svg)')                        ⍝ 3
          :EndIf
          filters,←⊂('*.pdf' 'Portable Document Format (*.pdf)')            ⍝ 4
          filters,←⊂('*.eps' 'Encapsulated PostScript (*.eps)')             ⍝ 5
          filters,←⊂('*.ps' 'PostScript (*.ps)')                            ⍝ 6
          filters,←⊂('*.gif' 'Graphics Interchange Format (*.gif)')         ⍝ 7
          :If Util.SHARPPLOT350
              filters,←⊂('*.gif' 'Animated GIF (*.gif)')                        ⍝ 8
          :EndIf
          filters,←⊂('*.jpg' 'Joint Photographic Experts Group (*.jpg)')    ⍝ 9
          filters,←⊂('*.bmp' 'Bitmap (*.bmp)')                              ⍝ 10
          filters,←⊂('*.emf' 'Enhanced Windows MetaFile (*.emf)')           ⍝ 11
          (file index)←Gui.FileBox'Save image as...' 1 filters
          :If ~Util.SHARPPLOT350 ⋄ index+←(index+.≥3 7) ⋄ :EndIf
          :If 0∊⍴file ⋄ :Return ⋄ :EndIf                     ⍝ user gave up
          ⎕NUNTIE tie←Util.FileTie file 2 0                  ⍝ see if we can overwrite it
          :If 0=tie ⋄ :Return ⋄ :EndIf                       ⍝ cannot write to file
          :If index∊1 7 8 9 10
              id←'Save',((1 7 8 9 10⍳index)⊃'Png' 'Gif' 'AnimatedGif' 'Jpg' 'Bmp'),'.Resolution'   ⍝ sneaked from GlobalOptions
              resolution←0 0 Util.Exec⊃∆GLOBALSCRIPT.GetSources⊂id
          :EndIf
          :If index∊2 3
              svgmode←0 0 Util.Exec⊃∆GLOBALSCRIPT.GetSources⊂((2 3⍳index)⊃'SaveSvg' 'SaveAnimatedSvg'),'.SvgMode'   ⍝ sneaked from GlobalOptions
          :EndIf
          :If index∊3 8
              delay←0 0 Util.Exec⊃∆GLOBALSCRIPT.GetSources⊂((3 8⍳index)⊃'SaveAnimatedSvg' 'SaveAnimatedGif'),'.Delay'
          :EndIf
          :Select index
          :Case 1 ⋄ ∆SHARPPLOT.SaveImage file System.Drawing.Imaging.ImageFormat.Png resolution
          :Case 2 ⋄ ∆SHARPPLOT.SaveSvg file svgmode
          :Case 3 ⋄ ∆SHARPPLOT.SaveAnimatedSvg file delay svgmode
          :Case 4 ⋄ ∆SHARPPLOT.SavePdf⊂file
          :Case 5 ⋄ ∆SHARPPLOT.SaveEps⊂file
          :Case 6 ⋄ ∆SHARPPLOT.SavePS⊂file
          :Case 7 ⋄ ∆SHARPPLOT.SaveImage file System.Drawing.Imaging.ImageFormat.Gif resolution
          :Case 8 ⋄ ∆SHARPPLOT.SaveAnimatedGif file delay resolution
          :Case 9 ⋄ ∆SHARPPLOT.SaveImage file System.Drawing.Imaging.ImageFormat.Jpeg resolution
          :Case 10 ⋄ ∆SHARPPLOT.SaveImage file System.Drawing.Imaging.ImageFormat.Bmp resolution
          :Case 11 ⋄ ∆SHARPPLOT.SaveImage file System.Drawing.Imaging.ImageFormat.Emf
          :Else ⋄ Gui.Error'SaveImage : Unexpected Image File Format'
          :EndSelect
        ∇

        :field Private Shared ReadOnly DESCRIPTION←'Chart Wizard Session'
        ∇ DoSaveSession;filters;file
          filters←,⊂('*.dcf' 'Dyalog Component File (*.dcf)')
          file←1⊃Gui.FileBox('Save chart wizard session as...' 1 filters)
          3 Save file   ⍝ ask for confirmation before overwrite
        ∇
        ∇ write Save file;tie
          :If 0∊⍴file ⋄ :Return ⋄ :EndIf                      ⍝ user gave up
          :If 0=tie←Util.FileTie file write 1 ⋄ :Return ⋄ :EndIf  ⍝ cannot open file
          DESCRIPTION ⎕FAPPEND tie  ⍝ file was created by Util.FileTie(write←3)
          Script.Version ⎕FAPPEND tie
          GetValue ⎕FAPPEND tie
          TXTSCRIPT ⎕FAPPEND tie
          ⎕FUNTIE tie
        ∇
        ∇ DoLoadSession;filters;file
          filters←('*.dcf' 'Dyalog Component File (*.dcf)')('*.*' 'All files (*.*)')
          file←1⊃Gui.FileBox'Load session...' 0 filters
          Load file
        ∇
        ∇ Load file;tie;desc;version;value
          :If 0∊⍴file ⋄ :Return ⋄ :EndIf                         ⍝ use gave up
          :If 0=tie←Util.FileTie file 0 1 ⋄ :Return ⋄ :EndIf     ⍝ file not found
          :If 1 4≡2↑⎕FSIZE tie
          :OrIf 1 5≡2↑⎕FSIZE tie  ⍝ component 4 is backup of script as text
              desc←⎕FREAD tie 1 ⋄ version←⎕FREAD tie 2 ⋄ value←⎕FREAD tie 3
          :Else
              desc←version←value←⎕NULL
          :EndIf
          ⎕FUNTIE tie
          :If DESCRIPTION≢desc
          :OrIf ~Util.IsNumScalar version
              Gui.Error'File is not a Chart Wizard session: ',⍕file ⋄ :Return
          :EndIf
          :Select version
          :Case Script.Version
              ⍝ nothing to do
          :Else
              Gui.Error'Unexpected Chart Wizard session version: ',⍕file ⋄ :Return
          :EndSelect
          SetValue value
          :If REFRESH ⋄ CustomCallback ⋄ :EndIf
        ∇

    :EndClass

    :EndSection





⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section Viewers
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

    :Class RasterViewer : Form
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆SCROLL              ⍝ ScrollSubform
        :Field Private ∆PIC                 ⍝ control to display a System.Drawing.Image
        :field Private ∆METAFILE            ⍝ metafile holding the script
        :Field Private SIZE                 ⍝ Current size of displayed image
        :Field Private CENTER               ⍝ Current center of display, within image size
        :Field Private ZOOMLIMIT            ⍝ ¯1=ask user ⋄ 1=limit ⋄ 0=do not limit
        :Field Private DRAGGING             ⍝ Flag to drag chart
        :Field Private LASTMOUSE            ⍝ last mouse position (when dragging chart)
        :Field Private DPI                  ⍝ Current DPI of monitor



        ∇ RasterViewerConstructor args;∆picsize;g
          :Access Public
          :Implements Constructor :Base (⊂'Caption' 'Chart Preview'),args
          ∆SCROLL←⎕NEW ScrollSubForm(1 1 0 ⍬)  ⍝ handle keystrokes ourselves
          ∆SCROLL Gui.LayoutGrid 0 0 0 0 0
          ∆PIC←∆SCROLL.GetChild.⎕NEW'NetControl'(⊂'ClassName' 'System.Windows.Forms.PictureBox')
          ⍝ :If Util.DEBUG ⋄ ∆PIC.BorderStyle←System.Windows.Forms.BorderStyle.FixedSingle ⋄ :EndIf
          SIZE←324 432 ⋄ CENTER←0.5×SIZE
          ⍝g←∆PIC.CreateGraphics ⋄ DPI←g.(DpiY DpiX) ⋄ g.Dispose
          ⍝DPI←(×/DPI)*0.5  ⍝!!! no support for stretched DPI
          ∆PIC.Image←∆METAFILE←⎕NEW System.Drawing.Bitmap(⌽SIZE)  ⍝ X Y
          ∆PIC.SizeMode←System.Windows.Forms.PictureBoxSizeMode.StretchImage
          ∆PIC Gui.LayoutGrid Gui.SPACE Gui.SPACE 0 0 0
          (⎕THIS ∆SCROLL,∆SCROLL.(GetScrolls,GetWindow GetChild)).onKeyPress←⊂'ViewerKey'
          ∆PIC.onMouseDoubleClick←'ViewerDoubleClick'
          ∆PIC.onMouseDown←'ViewerDown'
          ∆PIC.onMouseUp←'ViewerUp'
          ∆PIC.onMouseLeave←'ViewerLeave'
          ZOOMLIMIT←¯1   ⍝ don't know yet whether we want to limit zoom
          DRAGGING←0
          LASTMOUSE←0 0
        ∇
        ∇ chartsize←GetChartSize;desktop
          chartsize←∆METAFILE.(Height Width)÷Gui.DPI
        ∇
        ∇ imgsize←imgsize FitInto winsize
          :If (÷/imgsize)≤(÷/winsize) ⋄ imgsize←(imgsize[1]×winsize[2]÷imgsize[2]),winsize[2]   ⍝ image is wider - use window width
          :Else ⋄ imgsize←winsize[1],(imgsize[2]×winsize[1]÷imgsize[1])                   ⍝ image is taller - use window height
          :EndIf
        ∇
        ∇ Reset;chart;win
          (CENTER win)←0.5 1×⊂∆SCROLL.Size
          SIZE←GetChartSize FitInto win
        ∇
        ∇ {msg}←ViewerDoubleClick msg;y;x;∆evt;ratio;win;chart
          ∆evt←2⊃msg ⋄ (y x)←∆evt.(Y X)
          :Select ∆evt.Button
          :Case System.Windows.Forms.MouseButtons.Left
              CENTER←y x ⋄ SIZE×←2*0.5
          :Case System.Windows.Forms.MouseButtons.Right
              CENTER←y x ⋄ SIZE÷←2*0.5
          :Else
              Reset
          :EndSelect
          RedrawChart 0
        ∇
        ∇ {msg}←ViewerDown msg;∆evt;y;x
          ∆evt←2⊃msg ⋄ (y x)←∆evt.(Y X)
          LASTMOUSE←(y x) ⋄ DRAGGING←1
          ⍝Gui.Debug 'mouse ='(y x)'⋄ center ='CENTER
          ∆PIC.onMouseMove←'ViewerMove'  ⍝ start dragging
        ∇
        ∇ {msg}←ViewerMove msg;∆evt;y;x;mousemove;winmove;oldcenter
          ∆evt←2⊃msg ⋄ (y x)←∆evt.(Y X)
          :If DRAGGING
              mousemove←(y x)-LASTMOUSE      ⍝ mouse has moved that much
              oldcenter←CENTER
              CENTER←oldcenter-mousemove     ⍝ move center the other way
              ⍝Gui.Debug'movestart: mouse: 'LASTMOUSE'→'(y x)'⋄ center :'oldcenter'→'CENTER'⋄ ∆ ='mousemove
              ∆PIC.onMouseMove←0             ⍝ don't register the redraw as a mouse move
              RedrawChart 0
              winmove←CENTER-oldcenter          ⍝ window has moved that much
              LASTMOUSE←(y x)+winmove
              ⍝Gui.Debug'movend: mouse: '(y x)'→'LASTMOUSE' ⋄ center :'oldcenter'→'CENTER'⋄ ∆ ='winmove
              ∆PIC.onMouseMove←'ViewerMove'  ⍝ start dragging
          :Else
              ∆PIC.onMouseMove←0             ⍝ stop doing this
          :EndIf
        ∇
        ∇ {msg}←ViewerUp msg;∆evt;y;x
          ⍝Gui.Debug'stop up'
          DRAGGING←0
          :If 9=⎕NC'∆PIC'    ⍝ MouseLeave may happen after form was destroyed
              ∆PIC.onMouseMove←0  ⍝ stop dragging
          :EndIf
        ∇
        ∇ {msg}←ViewerLeave msg;∆evt;y;x
          ⍝Gui.Debug'stop leave'
          DRAGGING←0
          :If 9=⎕NC'∆PIC'    ⍝ MouseLeave may happen after form was destroyed
              ∆PIC.onMouseMove←0  ⍝ stop dragging
          :EndIf
        ∇
        ∇ {msg}←ViewerKey msg;key
          :Select key←5⊃msg
          :CaseList 27 32 ⋄ Reset            ⍝ escape ⋄ space
          :CaseList 13 187 107 ⋄ SIZE×←2*0.5 ⍝ enter ⋄ plus ⋄ keypad plus
          :CaseList 8 189 109 ⋄ SIZE÷←2*0.5  ⍝ backspace ⋄ minus ⋄ keypad minus
          :Case 38 ⋄ CENTER[1]-←0.2×∆SCROLL.Size[1]      ⍝ up arrow
          :Case 40 ⋄ CENTER[1]+←0.2×∆SCROLL.Size[1]      ⍝ down arrow
          :Case 37 ⋄ CENTER[2]-←0.2×∆SCROLL.Size[2]      ⍝ left arrow
          :Case 39 ⋄ CENTER[2]+←0.2×∆SCROLL.Size[2]      ⍝ right arrow
          :Case 33 ⋄ CENTER[1]←0        ⍝ page up
          :Case 34 ⋄ CENTER[1]←SIZE[1]  ⍝ page down
          :Case 36 ⋄ CENTER[2]←0        ⍝ home
          :Case 35 ⋄ CENTER[2]←SIZE[2]  ⍝ end
          :Else ⋄ :Return              ⍝ other keys : do not inhibit
          :EndSelect
          RedrawChart 0
          msg←0     ⍝ inhibit
        ∇
        ∇ RedrawChart force;chartsize;winpos;winsize;∆picsize;limit;newwinpos;newcenter;resolution;picsize;msg
        ⍝ CENTER refers to the point to aim in the OLD size.
          chartsize←GetChartSize ⋄ picsize←∆PIC.Image.(Height Width) ⋄ winsize←∆SCROLL.Size
          :If SIZE∨.>limit←5000      ⍝ limit number of pixels
              msg←'High zoom might hang the intepreter' 'Do you want to allow it? (not recommended)'
              :If ZOOMLIMIT=¯1 ⋄ ZOOMLIMIT←~Gui.YesNo msg ⋄ :EndIf
              :If ZOOMLIMIT ⋄ SIZE×←limit÷⌈/SIZE ⋄ :EndIf
          :EndIf
          :If (force)∨(SIZE≢picsize)                                   ⍝ SIZE has changed
              CENTER×←SIZE÷picsize                                     ⍝ scale center from old picsize to new picsize
              picsize←SIZE
              ⍝picsize×←DPI÷96                                          ⍝ empirically coded
              ∆picsize←⎕NEW System.Drawing.Size(⌽1⌈⌈picsize)           ⍝ Dyalog float (Y X), .Net is non-zero integer (X Y)
              ∆PIC.Image←⎕NEW System.Drawing.Bitmap(∆METAFILE ∆picsize)⍝ new scaled image
          :EndIf
          winpos←-(CENTER-winsize÷2)                                   ⍝ require position for picture to aim at CENTER
          ∆SCROLL.ConfigureChild winpos,SIZE                           ⍝ aim at CENTER
          newwinpos←∆SCROLL.GetChild.Posn                              ⍝ ScrollSubForm may have handled overflows
          newcenter←-(newwinpos-winsize÷2)                             ⍝ recompute current CENTER
          ⍝Gui.Debug⍕'Redraw' 'SIZE'SIZE'winsize'winsize'-' 'CENTER'CENTER'newcenter'newcenter'-' 'winpos'winpos'newwinpos'newwinpos
          CENTER←newcenter
          ⍝:If '2.51' Util.CompareVersions Util.SHARPPLOTVERSION
          ⍝    resolution←⌊0.5+0.5×+/72×SIZE÷chartsize                      ⍝ metafile was rendered at 72 DPI
          ⍝:Else
          resolution←⌊0.5+0.5×+/96×SIZE÷chartsize                      ⍝ metafile was rendered at 96 DPI
          ⍝:EndIf
          ⎕THIS.Caption←'Chart Preview - current display resolution = ',(⍕resolution),' DPI'
        ∇
        ∇ SetSharpPlot ∆sp
          :Access Public
          :If Util.SHARPPLOT300 ⍝ fixed page mechanism after v2.70
          :AndIf 0=∆sp.Pages  ⍝ no page drawn yet - metafile will appear of size 1x1
              ∆METAFILE←⎕NEW System.Drawing.Bitmap(⌊0.5+⌽GetChartSize)  ⍝ do not change size
          :Else
              ∆METAFILE←∆sp.RenderMetafile ⍬
          :EndIf
          SIZE←GetChartSize FitInto ∆PIC.Image.(Height Width)
          RedrawChart 1
        ∇
        ∇ FitWindow
          :Access Public
          Reset ⋄ RedrawChart 0
        ∇
        ⍝∇ SetRectangle(x y w h)
        ⍝  :Access Public
        ⍝  ⎕THIS Gui.Configure(y+Gui.STDH)x(h-Gui.STDH)w
        ⍝∇
    :EndClass


    :Class SvgViewer : Form   ⍝ I wish it worked =(
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆VIEW  ⍝ web browser
        ∇ SvgViewerConstructor args;∆picsize
          :Access Public
          :Implements Constructor :Base (⊂'Caption' 'Chart SVG Preview'),args
          ∆VIEW←⎕NEW'NetControl'(⊂'ClassName' 'System.Windows.Forms.WebBrowser')
          ∆VIEW Gui.LayoutGrid Gui.SPACE Gui.SPACE 0 0 1
        ∇
        ∇ SetSharpPlot ∆sp;html
          :Access Public
          html←''
          html,←'<!DOCTYPE html>'
          html,←'<html><body>'
          html,←∆sp.RenderSvg ChartWizard.Causeway.SvgMode.FixedAspect
          html,←'</body></html>'
          ∆VIEW.DocumentText←html   ⍝!!! no support for svg at microsoft 2.0
        ∇
        ∇ FitWindow
          :Access Public
          ⍝!!! not implemented
        ∇
        ∇ Configure(y x h w)
          :Access Public
          ⎕THIS Gui.Configure(y+Gui.STDH)x(h-Gui.STDH)w      ⍝ Form (title bar) height is not included is (Posn Size)
        ∇
    :EndClass

    :Class SharpPlotViewer ⍝ : Causeway.SharpPlotViewer    ⍝!!! can't derive from .Net class because of Mantis 15654
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆VIEW  ⍝ Causeway.SharpPlotViewer instance
        :Field Public ∆ONCLOSE  ⍝ see onClose
        ⍝ wrapper to make Causeway.SharpPlotViewer compatible with RasterViewer:Form API
        ∇ yes←SharpPlotViewer
          :Access Shared Public
          yes←(Util.SHARPPLOT350)∧(Util.DYALOG170)  ⍝ the SharpPlotViewer was crap  before v3.50 - 2455⌶ broken up to v17.0
        ∇
        ∇ SharpPlotViewerConstructor arg
          :Access Public
          :Implements Constructor
          ⍝ instanciate in this instance's parent
          :If SharpPlotViewer ⋄ ∆VIEW←##.⎕NEW Causeway.SharpPlotViewer
          :Else ⋄ ∆VIEW←##.⎕NEW RasterViewer ⍬
          :EndIf
        ∇
        ⍝ In common with other viewers
        ∇ SetSharpPlot ∆sp
          :Access Public
          :If SharpPlotViewer ⋄ ∆VIEW.SharpPlot←∆sp
          :Else ⋄ ∆VIEW.SetSharpPlot ∆sp
          :EndIf
        ∇
        ∇ FitWindow
          :Access Public
          :If SharpPlotViewer   ⍝!!! not implemented - SharpPlotViewer does not expose Causeway.SharpPlotImage.Fit
          :Else ⋄ ∆VIEW.FitWindow
          :EndIf
        ∇
        ∇ Configure(y x h w)
          :Access Public
          :If SharpPlotViewer ⋄ ∆VIEW.SetBounds⌊0.5+(4⍴Gui.DPI)×x y w h+¯1 ¯1 2 2×Gui.SPACE  ⍝ .Net apparently doesn't count border - while it does count title bar and menus
          :Else ⋄ ∆VIEW Gui.Configure(y+Gui.STDH)x(h-Gui.STDH)w  ⍝ Form (title bar + menu bar) height is not included is (Posn Size)
          :EndIf
        ∇
        ∇ Show show
          :Access Public
          :If SharpPlotViewer ⋄ :If show ⋄ ∆VIEW.Show ⍬ ⋄ :Else ⋄ ∆VIEW.Hide ⋄ :EndIf
          :Else ⋄ ∆VIEW.Show show
          :EndIf
        ∇
        :Property onClose
        :Access Public
            ∇ Set value;where
              :If 0≢value←value.NewValue
                  ∆ONCLOSE←⊃⎕RSI  ⍝ where the callback function is
                  value←'∆ONCLOSE.',value  ⍝ the callback function name will be evaluated from this namespace
              :Else
                  ∆ONCLOSE←⎕NULL
              :EndIf
              :If SharpPlotViewer ⋄ ∆VIEW(2455⌶)'Closed'value ⍝ Util.DYALOG170 : not working prior to v17.0
              :Else ⋄ ∆VIEW.onClose←value
              :EndIf
            ∇
        :EndProperty
        ∇ Close
          :Access Public
          Gui.Close ∆VIEW
          ∆VIEW←⎕NULL
        ∇
    :EndClass

    :Namespace GetViewer
        ∇ viewer←GetViewer  ⍝ select viewer to use
          ⍝⎕USING←',sharpplot.dll'  ⍝!!! bug in v14.0 which can't see the :Using of the parent
          ⍝viewer←##.Causeway.SharpPlotViewer  ⍝!!! bugged bug : in v14.0 the returned namespace oddly vanishes (weak reference ?), producing (VALUE ERROR: No result was provided when the context expected one)
          :If Util.SHARPPLOT350 ⋄ viewer←SharpPlotViewer  ⍝ was crap before that
          :Else ⋄ viewer←RasterViewer                     ⍝ was better up to v3.50
          :EndIf
        ∇
    :EndNamespace

    :EndSection





⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section Main_class
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝


    :Class Main
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        :Field Private ∆WIZARD               ⍝ GUI instance of the wizard
        :Field Private ∆VIEWER               ⍝ GUI instance of the viewer
        :Field Private ∆FORMS                ⍝ Forms registered with AddForm/BuildForm
        :Field Public ∆EXECNS                ⍝ Namespace where to execute expressions
        :Field Private Shared HANDLEBASE←'⍙CHARTWIZARD⍙'
        :Field Private HANDLE                ⍝ variable in ∆EXECNS that points to this Main instance

        ∇ MainConstructor ∆ns;H;W;b;t;l;r;i;x;y;h;w;charttypes;chartids;serieids;serieindices;serieexprs
          :Access Public
          :Implements Constructor
          ⍝:If ⎕SE∊⎕RSI ⋄ :AndIf 9=⎕NC'⎕SE.SALTUtils.c'
          ⍝    ∆EXTRAREF←⎕SE.SALTUtils.c  ⍝!!! Mantis 10895
          ⍝:EndIf
          ∆EXECNS←∆ns
          ⍝HANDLE←Util.PutRef ⎕THIS ∆EXECNS HANDLEBASE  ⍝ put main ref in calling namespace to prevent it from being garbage-collected, and to avoid appearing in (1400⌶0)
          HANDLE←Util.PutRef ⎕THIS Global.GetRoot HANDLEBASE  ⍝ put main ref ⎕SE to prevent it from being garbage-collected, and to avoid appearing in (1400⌶0)
          ∆FORMS←⍬
          ∆WIZARD←AddForm Wizard(⎕THIS'UpdateMain')
          ∆VIEWER←AddForm SharpPlotViewer ⍬
          (H W)←Gui.GetScreenSize
          (t b l r i)←(50 100 50 50 50)  ⍝ space around windows (top bottom left right inbetween)
          (y x)←(t l) ⋄ (h w)←(H-t+b)(600)
          ∆WIZARD Gui.Configure(y+2×Gui.STDH)x(h-2×Gui.STDH)w  ⍝ Form (title bar + menu) height is not included is (Posn Size)
          x←l+w+i ⋄ w←W-w+i+l+r
          ∆VIEWER.Configure y x h w
          UpdateMain ⎕NULL
          ∆VIEWER.FitWindow              ⍝ fit chart to viewer window
          (∆WIZARD ∆VIEWER).Show 1
          (∆WIZARD ∆VIEWER).onClose←⊂'CloseMain'
          ⍝ (∆WIZARD ∆VIEWER).onGotFocus←⊂'FocusMain'  ⍝ bind forms focii
        ∇
        ∇ UpdateMain ∆control;∆sp
          :Access Public
          ∆sp←∆WIZARD.GetSharpPlot
          :Trap 90
              ∆VIEWER.SetSharpPlot ∆sp
          :Else
              ∆sp Chart.Print⍕⎕EXCEPTION
              ∆VIEWER.SetSharpPlot ∆sp
          :EndTrap
        ∇
        ∇ {msg}←CloseMain msg;∆form;∆objs;names                       ⍝ close everything
          :Access Public
          :If ~Gui.YesNo'Do you really want to quit the Chart Wizard?'
              msg←0 ⋄ :Return ⍝ inhibit close
          :EndIf
          ⍝∆EXECNS.⎕EX HANDLE  ⍝ remove global reference
          Global.GetRoot.⎕EX HANDLE
          ⍝:Trap 6 ⋄ ∆VIEWER.onClosed←0 ⋄ :EndTrap ⍝!!! Mantis 10809 - fixed in v14.1 ?
          ∆WIZARD.onClose←0
          ∆VIEWER.onClose←0
          :For ∆form :In ∆FORMS
              Gui.Close ∆form
          :EndFor
        ∇
        ∇ {msg}←FocusMain msg;∆obj
          (∆WIZARD ∆VIEWER).onGotFocus←0
          Gui.Focus¨⌽(∆obj←⊃msg)∪∆WIZARD ∆VIEWER
          (∆WIZARD ∆VIEWER).onGotFocus←⊂'FocusMain'
        ∇
        ∇ ∆wizard←GetWizard
          :Access Public
          ∆wizard←∆WIZARD
        ∇
        ∇ ∆form←AddForm(∆class args)                  ⍝ add a form to the current chart wizard
          :Access Public
          ∆FORMS,←∆form←⎕THIS.⎕NEW ∆class args        ⍝ instanciate form in this instance of Main, and add it to ∆FORMS list
        ∇

        ⍝ Shared methods for global stuff
        ∇ ∆main←GetMain ∆children;∆child    ⍝ Get Main instance in target's namespace parents
          :Access Private Shared
          :For ∆child :In ∆children
              ⍝ look for an instance of this class in the parent tree of that calling namespace
              ∆main←{0::⎕NULL ⋄ Gui.IsRoot ⍵:⎕NULL ⋄ ⎕THIS≡⊃⊃⎕CLASS ⍵:⍵ ⋄ ∇ ⍵.##}∆child
              :If ∆main≢⎕NULL ⋄ :Leave ⋄ :EndIf
          :EndFor
          :If ∆main≡⎕NULL ⋄ Gui.Error'Cannot find Main parent' ⋄ :EndIf
        ∇
        ∇ ∆form←∆children BuildForm(∆class args)  ⍝ shared method to build a form that will be destroyed when Chart Wizard instance closes
          :Access Public Shared
          ∆form←(GetMain ∆children).AddForm ∆class args
        ∇
        ∇ ∆ns←GetExecNamespace ∆children
          :Access Public Shared
          ∆ns←(GetMain ∆children).∆EXECNS
        ∇
    :EndClass

    :EndSection








⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section Magic_with_input
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

    :Namespace Magic
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862





        ⍝ TOWERLIMIT←3         ⍝ up to that many points on both axes : tower
        ⍝ SQUARE←{⍺≥⍵*0.7}     ⍝ (⍺←series)÷(⍵←length) ratio above which array is considered square : tower or response
        BARMAXSERIES←2       ⍝ maximum number of series for a bar chart
        BARMAXLENGTH←15      ⍝ maximum series length for a bar chart (above 12 months)
        LINEMAXSERIES←15     ⍝ maximum number of series for a line/scatter chart
        BUBBLEMAXLENGTH←20   ⍝ maximum number of points for a bubble chart
        CONTOURMAXLENGTH←200 ⍝ maximum number of points for a contour chart
        BOXMINLENGTH←500     ⍝ do not attempt box and whiskers with less than than many items (above 365 days)
        LABELLIMIT←50        ⍝ do not set labels above that limit

        GetMatrix←{2=⍴⍴⍵:⍵  ⋄ Util.IsNum ⍵:,[.5]⍵ ⋄ ↑⍵}  ⍝ argument is numeric vector, matrix, or nested numeric vectors
        GetNested←{2=⍴⍴⍵:↓⍵ ⋄ Util.IsNum ⍵:,⊂⍵    ⋄  ⍵}  ⍝ argument is numeric vector, matrix, or nested numeric vectors
        Median←{⍺←0.5 ⋄ (⌊.5+1+⍺×¯1+⊃⍴⍵)⊃{⍵[⍋⍵]}⍵}            ⍝ median value of vector
        Span←{0∊⍴⍵:0 ⋄ (⌈/⍵)-(⌊/⍵)}                      ⍝ span along last dimension
        Spiky←{(Median |2-/⍵)∧.>(0.1×Span ⍵)}             ⍝ argument is numeric vector - 1 if changes more than a decile half of the time

        ⍝:Field Public Shared ∆EXECNS   ⍝ Magic.Run temporarily sets this shared global to current execution namespace
        ⍝ so you HAVE to be called by Magic.Run to call the following :
        ⍝FMTIO←{∆EXECNS.⎕IO:⍕⍵ ⋄ ⍕⍵-1}
        ⍝FIRST←{∆EXECNS.⎕ML≥2:'↑' ⋄ '⊃'}
        ⍝MIX←{∆EXECNS.⎕ML≥2:'⊃' ⋄ '↑'}


        ∇ (value expr)←CleanShape(value expr);newshape;shape
        ⍝ Clean any array
        ⍝ - output is either a vector, a matrix, or a vector of vectors.
        ⍝ - disclose 1-item nested array
        ⍝ - remove unitary dimensions, shallow scalar or 1-item array becomes 1-item vector
        ⍝ - if a nested vector, ravel each sub-item
        ⍝ - anything empty will not modify the expression and return (value←⍬)
          newshape←(shape←⍴value)~1                 ⍝ remove unitary dimension
          :If (0≠⍴⍴value)∧(shape≡newshape)          ⍝ array is okay
              ⍝ nothing to do
          :ElseIf ~0∊⍴newshape                      ⍝ array has non-unitary dimensions
              value←newshape⍴value ⋄ expr←'{((⍴⍵)~1)⍴⍵}',expr
          :ElseIf 1≥|≡value                         ⍝ shallow 1-item - make it a 1-item vector
              value←,value ⋄ expr←',',expr
          :Else                                     ⍝ deep 1-item array : dig further
              (value expr)←CleanShape(⊃value)(FIRST,expr)
          :EndIf
          :If Util.IsText value                     ⍝ text array → strings vector
              :If 1=⍴⍴value ⋄ value←,⊂value ⋄ expr←',⊂',expr    ⍝ vector → nested vector
              :Else ⋄ value←↓value ⋄ expr←'↓',expr ⋄ :EndIf     ⍝ matrix → nested vector
          :EndIf
        ∇

        ∇ new←{debug}CleanMatrix mat;not;r;c;p;nr;nc
        ⍝ Argument is a boolean matrix. This function tries to remove as few 1s as possible
        ⍝ so that the 0s all belong either to a row full of 0s or a column full of 0s.
          ⍝ :If 0=⎕NC'debug' ⋄ debug←0 ⋄ :EndIf
          not←~mat
          (r c)←{(+/⍵)(+⌿⍵)}not-mat        ⍝ cost of zeroing rows and columns
          p←×r∘.-c                         ⍝ 1=prefer zeroing rows ; ¯1=prefer zeroing cols ; 0=don't know
          p×←not                           ⍝ keep preference only for 0s
          (r c)←(∨/p=1)(∨⌿p=¯1)            ⍝ obvious rows and columns to zeroise... - was : (r c)←(0<+/p)(0>+⌿p)
          new←(~r)∧[1](~c)∧[2]mat          ⍝ ...do it - was : (nr nc)←(mat∧[1]~r)(mat∧[2]~c)
          ⍝ :If debug ⋄ ⎕←'*'((' ',r),c⍪mat)'→'((' ',r),c⍪p)'→'(' ',' '⍪new) ⋄ :EndIf
          :If new≢mat          ⍝ I have no idea how many recursions can be expected... I only managed to get up to 6 recursions with random matrices...
              new←debug CleanMatrix new
          :EndIf
        ∇

        ∇ (numexpr rowtitles coltitles)←NumericSeries(value expr);mat;mask;rows;cols;numrows;numcols
        ⍝ (value expr) is either a matrix or a nested vector
        ⍝ - extract expression for numeric series, along with rowtitles and coltitles
        ⍝ - ravel each sub-vectors of a nested vector
          numexpr←expr                   ⍝ numexpr is the expression for the numeric part of the matrix
          rowtitles←⍬ ⋄ coltitles←⍬      ⍝ rowtitles and coltitles are string arrays made of non-numeric items of the matrix
          :If ~mat←2=⍴⍴value             ⍝ nested vector
              :If (1∨.≠∊{⍴⍴⍵}¨value)                    ⍝ items are not all vectors
                  value←,¨value ⋄ expr←',¨',expr        ⍝ ravel items
              :EndIf
              value←↑value                              ⍝ keep value as a matrix for now
          :EndIf
          :If Util.IsNum value ⋄ numexpr←expr ⋄ :Return ⋄ :EndIf         ⍝ all numeric - nothing to do
          :If 0∊⍴value ⋄ numexpr←'' ⋄ :Return ⋄ :EndIf  ⍝ empty - no numeric value
          mask←CleanMatrix Util.IsNumScalar¨value
          rows←∨/mask ⋄ cols←∨⌿mask                   ⍝ numeric rows ⋄ numeric columns
          :If ∨/rows,cols                ⍝ some numeric value : extract expression and titles
              rowtitles←,∘⍕¨↓rows⌿(~cols)/value ⋄ numrows←FMTIO rows/⍳1⊃⍴value ⍝ agregate non-numeric values
              coltitles←,∘⍕¨↓⍉(~rows)⌿cols/value ⋄ numcols←FMTIO cols/⍳2⊃⍴value
              :If ~mat ⋄ expr←MIX,expr ⋄ :EndIf       ⍝ turn nested into matrix
              :If ∧/rows ⋄ numrows←'' ⋄ :Else ⋄ numrows←'(⍳',(FMTIO 1),'⊃⍴⍵)~',FMTIO(~rows)/⍳1⊃⍴value ⋄ :EndIf
              :If ∧/cols ⋄ numcols←'' ⋄ :Else ⋄ numcols←'(⍳',(FMTIO 2),'⊃⍴⍵)~',FMTIO(~cols)/⍳2⊃⍴value ⋄ :EndIf
              numexpr←'{⍵[',numrows,';',numcols,']}',expr
          :Else                          ⍝ no numeric value
              numexpr←''
          :EndIf
        ∇
        ∇ (value expr)←indices ExtractSeries(value expr)
        ⍝ (value expr) is a matrix or a vector of vectors
          :If indices∧.>0
              :If (1=⍴⍴value)∧(0=⍴⍴indices)
                  expr←(FMTIO indices),'⊃',expr
                  value←indices⊃value
              :Else
                  expr←'(⊂',(FMTIO indices),')⌷',expr
                  value←indices⌷value
              :EndIf
          :Else ⍝ indices≤0
              indices←-indices
              :If 2=⍴⍴value
                  expr←'{⍵[(⍳',FIRST,'⍴⍵)~',(FMTIO indices),';]}',expr
                  value←value[(⍳1⊃⍴value)~indices;]
              :Else
                  expr←'{⍵[(⍳',FIRST,'⍴⍵)~',(FMTIO indices),']}',expr
                  value←value[(⍳1⊃⍴value)~indices]
              :EndIf
          :EndIf
        ∇

        ⍝⍝⍝⍝⍝ entry point of this namespace ⍝⍝⍝⍝⍝

        ∇ ∆wizard Run expr;value;newexpr;oldexpr;mask;∆EXECNS
        ⍝ do your best to configure the chart wizard given argument expression
          ∆wizard.Refresh 0
          ∆EXECNS←Main.GetExecNamespace ∆wizard  ⍝ globalise the namespace where to run expressions - update at each run
          :If ∆EXECNS.⎕IO ⋄ FMTIO←{⍕⍵} ⋄ :Else ⋄ FMTIO←{⍕⍵-1} ⋄ :EndIf
          :If ∆EXECNS.⎕ML≥2 ⋄ FIRST←'↑' ⋄ MIX←'⊃' ⋄ :Else ⋄ FIRST←'⊃' ⋄ MIX←'↑' ⋄ :EndIf
          :If 0∊⍴expr~' '   ⍝ no expression at all
              Demo ∆wizard
              :Return ⍝ DONE !
          :EndIf
          value←∆wizard.Eval oldexpr←expr
          (value expr)←CleanShape(value expr)
          :If 0∊⍴value        ⍝ empty array
              ∆wizard Default oldexpr
          :ElseIf 1=⍴⍴value   ⍝ vector
              :If Util.IsNum value        ⍝ simple numeric vector - easy
                  ∆wizard NoX value expr ⍬ ⍬        ⍝ will be a bar or a line
              :ElseIf 2=⊃⍴value           ⍝ two deep items - probably x y
                  ∆wizard TwoItems(value expr oldexpr)
              :ElseIf 1∧.=(Util.IsNumScalar¨value)+(Util.IsText¨value)  ⍝ mixed numbers and strings
                  ∆wizard MixedVector(value expr oldexpr)
              :Else   ⍝ vector of vectors
                  ∆wizard RunSeries(value expr oldexpr)
              :EndIf
          :ElseIf 2=⍴⍴value  ⍝ matrix
              ∆wizard RunSeries(value expr oldexpr)
          :Else  ⍝ high rank array
              ∆wizard Default oldexpr  ⍝ don't know what to do
          :EndIf
          ⍝∆EXECNS←#  ⍝ do not remember the handle, we're in a shared namespace
          ⎕EX¨'FMTIO' 'FIRST' 'MIX'  ⍝ do not remember the execns-specifics
        ∇



        ∇ ∆wizard TwoItems(value expr oldexpr);mat;nested;val1;expr1;val2;expr2;mask;x;xexpr;y;yexpr;rowtitles;coltitles;rows;cols;isx;isy
        ⍝ catch a vector x with a (matrix/nested) y
          mat←0 ⋄ nested←0
          (val1 expr1)←CleanShape(1⊃value)((FMTIO 1),'⊃',expr)
          (val2 expr2)←CleanShape(2⊃value)((FMTIO 2),'⊃',expr)
          isx←{(1=⊃⍴⍴⍵)∧(Util.IsNum ⍵)∨(Util.IsStrings ⍵)}¨val1 val2   ⍝ numeric or strings vector
          isy←{(2=⊃⍴⍴⍵)∨(1=⊃⍴⍴⍵)∧(1<|≡⍵)}¨val1 val2    ⍝ matrix or vector of vectors
          :If ~∧/(isx≠isy),isx isy∊(0 1)(1 0)        ⍝ we clearly don't have an x and a y as we expect them
              ∆wizard RunSeries value expr oldexpr   ⍝ fall back to default handling - in particular for two vectors
              :Return
          :EndIf
          (x xexpr y yexpr)←(1+isx≡0 1)⊃(val1 expr1 val2 expr2)(val2 expr2 val1 expr1)
          (yexpr rowtitles coltitles)←NumericSeries y yexpr
          :If 0∊⍴yexpr               ⍝ no numbers in y
              :If (~0∊⍴x)∧(Util.IsNum x) ⋄ ∆wizard NoX x xexpr ⍬ ⍬       ⍝ plot x
              :Else ⋄ ∆wizard Default oldexpr ⋄ :EndIf                   ⍝ no hope left
              :Return
          :Else
              y←∆wizard.Eval yexpr
              :If nested←2≠⍴⍴y ⋄ rows←⊃⍴,y ⋄ cols←⌈/⊃∘⍴¨,¨y
              :Else ⋄ (rows cols)←⍴y ⋄ :EndIf
              :If cols=⍴,x
                  ⍝ nothing to do
              :ElseIf rows=⍴,x
                  yexpr←(nested/'↓'),'⍉',(nested/MIX),yexpr
                  (rowtitles coltitles)←(coltitles rowtitles)
              :Else  ⍝ can't match x to y
                  ∆wizard RunSeries y yexpr oldexpr   ⍝ try with y
                  :Return
              :EndIf
              :If Util.IsNum x
                  ∆wizard XY x xexpr''y yexpr rowtitles  ⍝ no x title
              :Else
                  ∆wizard NoX y yexpr rowtitles x  ⍝ x replaces coltitles
              :EndIf
          :EndIf
        ∇

        ∇ ∆wizard MixedVector(value expr oldexpr);mask;caption
        ⍝ vector with scalar numbers and strings
          mask←Util.IsNumScalar¨value
          :If ~∨/mask
              ∆wizard Default oldexpr
          :Else
              expr←'{⍵[(⍳⍴⍵)~',(FMTIO(~mask)/⍳⍴value),']}',expr
              caption←,⍕(~mask)/value            ⍝ patch up all non-numeric data
              value←mask/value                   ⍝ sieve numeric scalars
              ∆wizard NoX value expr(,⊂caption)⍬   ⍝ caption is single rowtitle - no coltitles
          :EndIf
        ∇

        ∇ ∆wizard RunSeries(value expr oldexpr);series;length;mat;numexpr;rowtitles;coltitles;numval;nummat;mask;x;xexpr;y;index;yexpr;z;zexpr;choice
        ⍝  ∆wizard PickXY(value expr oldexpr)
        ⍝  :Return
        ⍝ (value expr) is either a matrix or a vector of vectors
          (numexpr rowtitles coltitles)←NumericSeries(value expr)
          :If 0∊⍴numexpr  ⍝ no numeric values
              ∆wizard Default oldexpr
              :Return
          :EndIf
          numval←∆wizard.Eval numexpr
          :If 2=⍴⍴numval ⋄ mat←1 ⋄ (series length)←⍴numval ⋄ nummat←numval
          :Else ⋄ mat←0 ⋄ series←⊃⍴numval ⋄ length←⌈/⊃∘⍴¨numval ⋄ nummat←↑numval ⋄ :EndIf
          :If series>length ⍝ length>BARLIMIT
              :If mat ⋄ numval←⍉numval ⋄ numexpr←'⍉',numexpr
              :Else ⋄ numval←↓⍉↑numval ⋄ numexpr←'↓⍉',MIX,numexpr ⋄ :EndIf
              (series length)←(length series)
              (rowtitles coltitles)←(coltitles rowtitles)
          :EndIf
          :If 1=series                       ⍝ can't really have X - only coltitles as xlabels - will be a bar or a line
          ⍝ :OrIf (1∧.<series length)∧(series length∧.≤TOWERLIMIT)   ⍝ too few values and not one series
              ∆wizard NoX numval numexpr rowtitles coltitles
          ⍝ The following block was removed : it's not actually that nice to force sorted series as X
          ⍝:ElseIf series≤LINEMAXSERIES
          ⍝:AndIf 1=+/mask←Util.IsSorted¨↓nummat      ⍝ 1 sorted series = x
          ⍝    index←⊃mask/⍳⍴mask
          ⍝    (x xexpr)←index ExtractSeries(numval numexpr)
          ⍝    (y yexpr)←(-index)ExtractSeries(numval numexpr)
          ⍝    ∆wizard XY x xexpr(⊃mask/rowtitles)y yexpr((~mask)/rowtitles)
          :ElseIf 2=series
          :AndIf 'Two Series'≢choice←'Two Series' 'X-Y Series' 'Y-X Series'Gui.Choice'Your data is made of two numeric series.' 'Are they two different series, or are they X-Y coordinates of the same series?'
              (x xexpr)←('X-Y Series' 'Y-X Series'⍳⊂choice)ExtractSeries(numval numexpr)
              (y yexpr)←('Y-X Series' 'X-Y Series'⍳⊂choice)ExtractSeries(numval numexpr)
              :If 0∊⍴rowtitles ⋄ rowtitles←'' '' ⋄ :EndIf
              ∆wizard XY x xexpr(1⊃rowtitles)y yexpr(1↓rowtitles)
          :ElseIf 3=series
          :AndIf 'Three Series'≢choice←'Three Series' 'X-Y Series' 'X-Y-Z Series'Gui.Choice'Your data is made of three numeric series.' 'Are they three different series, or are they X-Y or X-Y-Z coordinates of the same series?'
              :If choice≡'X-Y Series'
                  choice←'X-Y-Y Series' 'Y-Y-X Series'Gui.Choice'Your data is made of three series of X-Y data.' 'In which order are they presented?'
                  (x xexpr)←(('X-Y-Y Series' 'Y-Y-X Series'⍳⊂choice)⊃(1 3))ExtractSeries(numval numexpr)
                  (y yexpr)←(('X-Y-Y Series' 'Y-Y-X Series'⍳⊂choice)⊃(2 3)(1 2))ExtractSeries(numval numexpr)
                  :If 0∊⍴rowtitles ⋄ rowtitles←'' '' ⋄ :EndIf
                  ∆wizard XY x xexpr(1⊃rowtitles)y yexpr(1↓rowtitles)
              :Else
                  choice←'X-Y-Z Series' 'Z-Y-X Series'Gui.Choice'Your data is made of three series of X-Y-Z data.' 'In which order are they presented?'
                  (x xexpr)←(('X-Y-Z Series' 'Z-Y-X Series'⍳⊂choice)⊃(1 3))ExtractSeries(numval numexpr)
                  (y yexpr)←2 ExtractSeries(numval numexpr)
                  (z zexpr)←(('X-Y-Z Series' 'Z-Y-X Series'⍳⊂choice)⊃(3 1))ExtractSeries(numval numexpr)
                  :If 0∊⍴rowtitles ⋄ rowtitles←'' '' '' ⋄ :EndIf
                  ∆wizard XYZ x xexpr(1⊃rowtitles)y yexpr(2⊃rowtitles)z zexpr(3⊃rowtitles)
              :EndIf
          :Else             ⍝ too many series - forget about X
              ∆wizard NoX numval numexpr rowtitles coltitles  ⍝ will be a response
          :EndIf
        ∇

        ∇ ∆wizard PickXY(value expr oldexpr);x;xexpr;y;yexpr;keys;∆xypicker
          ∆xypicker←⎕THIS Main.BuildForm XYPicker(value expr ⍬)
          (x xexpr y yexpr keys)←∆xypicker.Run  ⍝ does a job similar to NumericSeries
          :If (0∊⍴y)
              ∆wizard Default oldexpr
          :ElseIf (~0∊⍴x)∧(Util.IsNum x)
              ∆wizard XY x xexpr''y yexpr keys  ⍝!!! no xtitle
          :Else
              ∆wizard NoX y yexpr keys x  ⍝ keys=rowtitles ⋄ x=coltitles
          :EndIf
        ∇

        ⍝⍝⍝⍝⍝ Actual wizard set-up ⍝⍝⍝⍝⍝

        ∇ Demo ∆wizard;id
        ⍝ demo chart when no expression is given
          id←∆wizard.AddCharts'Line'
          ∆wizard.SetSeries id'X' '.12×(0,⍳100)'
          ∆wizard.SetSeries id'Y' '6×1-2○○(0,⍳100)÷50'
          ∆wizard.Refresh 1
        ∇

        ∇ ∆wizard Default expr;id;value
        ⍝ default chart when don't know what to do
          value←∆wizard.Eval expr
          :If 0∊⍴value
              id←∆wizard.AddCharts'Line'
              ∆wizard.SetSeries id'Y'expr
          :Else
              value←,∘⍕¨,value ⋄ expr←',∘⍕¨,',expr
              id←∆wizard.AddCharts'Histogram'
              ∆wizard.SetChartOption id'ClassInterval' 1
              ∆wizard.SetChartOption id'SetXTickMarks' 1
              ∆wizard.SetSeries id'Values'('{({⍵[⍋↑⍵]}∪⍵)⍳⍵}',expr)
              ∆wizard.SetChartOption id'SetXLabels'({⍵[⍋↑⍵]}∪value)
              ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.(AngledLabels+MiddleLabels)
          :EndIf
          ∆wizard.Refresh 1
        ∇
        ∇ ∆wizard NoX(value expr rowtitles coltitles);id;length;mat;series;cat
        ⍝ (value expr) has been through CleanShape and NumericSeries, and series<length
          (series length)←⍴mat←GetMatrix value
          ⍝:If (1∧.<series length)∧(series length∧.≤TOWERLIMIT)   ⍝ too few values and not one series
          ⍝    id←∆wizard.AddCharts'Tower'
          ⍝    ∆wizard.SetSeries id'Values'expr
          :If (series≤BARMAXSERIES)∧(length≤BARMAXLENGTH)
              id←∆wizard.AddCharts'Bar'
              ∆wizard.SetSeries id'Values'expr
          :ElseIf (series≤LINEMAXSERIES)∧(BOXMINLENGTH≤length)  ⍝ not too many series, not too few points
          :AndIf ∧/Spiky¨↓mat                                   ⍝ not a sequence
          :AndIf Gui.YesNo'Data doesn''t look continuous.' 'You should probably display the distribution of values, rather than plotting it sequentially.' 'Do you want to do so? (recommended)'
              :If series=1  ⍝ is a vector
                  id←∆wizard.AddCharts'Histogram'
                  ∆wizard.SetSeries id'Values'expr
              :Else         ⍝ is a matrix or nested vectors
                  id←∆wizard.AddCharts'Box'
                  :If 2=⍴⍴value
                      cat←'{(',FIRST,'⌽⍴⍵)/⍳(',FIRST,'⍴⍵)}',expr
                      expr←',',expr
                  :Else
                      cat←'{('FIRST'∘⍴¨⍵)/⍳⍴⍵}',expr
                      expr←FIRST,',/',expr
                  :EndIf
                  :If ~0∊⍴rowtitles
                      cat←(⍕⊃⌽⍴value),'/',Util.Source rowtitles   ⍝!!! should be an true expression here
                  :EndIf
                  ∆wizard.SetSeries id'Values'expr
                  ∆wizard.SetSeries id'Category1'cat
                  :If 0∊⍴coltitles ⋄ ∆wizard.SetSeries id'Category2'coltitles ⋄ :EndIf ⍝!!! should be a true expression here
              :EndIf
          :ElseIf (series≤LINEMAXSERIES)                  ⍝ some kind of sequence
              id←∆wizard.AddCharts'Line'
              ∆wizard.SetSeries id'Y'expr
          :Else  ⍝ too many series
              id←∆wizard.AddCharts'Response'
              ∆wizard.SetSeries id'Z'expr
          :EndIf
          :If (~0∊⍴coltitles)∧((⍴coltitles)≤LABELLIMIT)
              :Select ∆wizard.GetChartType id
              :Case 'Bar'
                  ∆wizard.SetChartOption id'SetXLabels'coltitles
              :Case 'Histogram'
                  ∆wizard.SetChartOption id'SetXTickMarks' 1
                  ∆wizard.SetChartOptoin id'ClassInterval' 1
                  ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.(GridLines+AngledLabels+MiddleLabels)  ⍝ keep default wizard gridlines
                  ∆wizard.SetChartOption id'SetXLabels'coltitles
              :CaseList 'Line' 'Tower' 'Response' 'Histogram'
                  ∆wizard.SetChartOption id'SetXTickMarks' 1
                  ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.(GridLines+AngledLabels)  ⍝ keep default wizard gridlines
                  ∆wizard.SetChartOption id'SetXLabels'coltitles
              :Case 'Box'   ⍝ already used as category2
              :Else ⋄ Gui.Error'Unhandled chart type'
              :EndSelect
          :EndIf
          :If (~0∊⍴rowtitles)∧((⍴rowtitles)≤LABELLIMIT)
              :Select ∆wizard.GetChartType id
              :CaseList 'Bar' 'Line'
                  :If 1=series ⋄ ∆wizard.SetChartOption id'YCaption'(⊃rowtitles)
                  :Else ⋄ ∆wizard.SetChartOption id'SetKeyText'rowtitles ⋄ :EndIf
              :CaseList 'Tower' 'Response'
                  ∆wizard.SetChartOption id'SetYTickMarks' 1
                  ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.(GridLines+AngledLabels)  ⍝ keep default wizard gridlines
                  ∆wizard.SetChartOption id'SetYLabels'rowtitles
              :Case 'Histogram'
                  ∆wizard.SetChartOption id'YCaption'(⊃rowtitles)  ⍝ we know there's only one series
              :Case 'Box'  ⍝ already used as category1
              :Else ⋄ Gui.Error'Unhandled chart type'
              :EndSelect
          :EndIf
          ∆wizard.Refresh 1
        ∇

        ∇ ∆wizard XY(x xexpr xtitle y yexpr keys);id;x;min;max
        ⍝ x is numeric vector, y is numeric (vector, matrix or nested vector)
        ⍝ key is strings
          :If Util.IsSorted x
              id←∆wizard.AddCharts'Line'
              (min max)←{(⎕NEW System.DateTime(⍵ 1 1)).ToOADate}¨¯15 5+1⊃⎕TS     ⍝ back 15 year, forward 5 years
              :If (min≤⌊/x)∧((⌈/x)≤max)
                  ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.(GridLines+Date) ⍝ keep default wizard gridlines
              :EndIf
          :Else
              id←∆wizard.AddCharts'Scatter'
          :EndIf
          :If ~0∊⍴xtitle ⋄ ∆wizard.SetChartOption id'XCaption'xtitle ⋄ :EndIf
          :If ~0∊⍴keys
              :If 1=⍴keys ⋄ ∆wizard.SetChartOption id'YCaption'(⊃keys)
              :Else ⋄ ∆wizard.SetChartOption id'SetKeyText'keys ⋄ :EndIf
          :EndIf
          ∆wizard.SetSeries id'X'xexpr
          ∆wizard.SetSeries id'Y'yexpr
          ∆wizard.Refresh 1
        ∇

        ∇ ∆wizard XYZ(x xexpr xtitle y yexpr ytitle z zexpr ztitle);id;length
        ⍝ x y z are three vectors of the same length
          length←∊∪⍴¨x y z
          :If length≤BUBBLEMAXLENGTH
              id←∆wizard.AddCharts'Bubble'
              ∆wizard.SetChartOption id'BubbleChartStyle'Causeway.BubbleChartStyles.ScaleBar
              ∆wizard.SetChartOption id'SetMargins'(42 48 36 60)
          :ElseIf length≤CONTOURMAXLENGTH
              id←∆wizard.AddCharts'Contour'
              ∆wizard.SetChartOption id'ContourPlotStyle'Causeway.ContourPlotStyles.(ScaleBar+ValueTags)
              ∆wizard.SetChartOption id'SetMargins'(42 48 36 60)
          :Else
              id←∆wizard.AddCharts'Cloud'
              ∆wizard.SetChartOption id'CloudChartStyle' 0  ⍝ remove wizard's default risers
          :EndIf
          ∆wizard.SetChartOption id'XCaption'xtitle
          ∆wizard.SetChartOption id'YCaption'ytitle
          ∆wizard.SetChartOption id'ZCaption'ztitle
          ∆wizard.SetSeries id'X'xexpr
          ∆wizard.SetSeries id'Y'yexpr
          ∆wizard.SetSeries id'Z'zexpr
          ∆wizard.Refresh 1
        ∇


    :endNamespace

    :EndSection






⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section Magic_XY_Picker
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

    :Class XYPicker : Form
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        ⍝ pick XY rows in a matrix or a vector of vectors - does a similar job to Magic.NumericSeries
        ⍝ y will be numeric matrix
        ⍝ x will be a vector, possibly non-numeric
        ⍝ key will be a vector of strings

        (BLACK GREY WHITE)←(0 0 0)(¯16)(255 255 255)
        (GREEN YELLOW ORANGE RED)←(224 255 224)(255 255 176)(255 224 192)(255 200 200)
        (BLUE PURPLE)←(208 224 255)(224 192 255)
        :Field Public Shared ReadOnly TYPE_0←1     ⍝ ignored values
        :Field Public Shared ReadOnly TYPE_V←2     ⍝ selected values
        :Field Public Shared ReadOnly TYPE_X←3     ⍝ x values
        :Field Public Shared ReadOnly TYPE_Y←4     ⍝ y values
        :Field Public Shared ReadOnly TYPE_K←5     ⍝ key text
        :Field Public Shared ReadOnly TYPE_T←6     ⍝ value tags
        TRGB←GREY GREEN YELLOW ORANGE BLUE PURPLE  ⍝ color for each type : TRGB[TYPE]

        :Field Private ∆GRID             ⍝ Grid object to display matrix
        :Field Private EXPRESSION        ⍝ original expression
        :Field Private MATRIX            ⍝ current matrix value
        :Field Private NESTED            ⍝ was original value nested
        :Field Private TRANSPOSED        ⍝ is matrix transposed
        :Field Private ROWTYPES          ⍝ type of each row
        :Field Private COLTYPES          ⍝ type of each column

        ∇ SeriesPickerConstructor(value expr types);∆menus;∆buttons;r;c;cellw;diff;gridsize;tip
          :Access Public
          :Implements Constructor :Base ⊂('Caption' 'Please select series types in your array...')
         
          ∆GRID←⎕NEW'Grid'(('VScroll' ¯1)('HScroll' ¯1))
          ∆GRID.(CellHeights CellWidths)←Gui.(STDH STDW)
          ∆GRID.(ResizeCols ResizeRows ResizeColTitles ResizeRowTitles)←1 0 0 0
          ∆GRID.(ColTitleAlign RowTitleAlign)←'Center' 'Center'
          ∆GRID.(TitleHeight TitleWidth)←Gui.STDH 30
          ∆GRID.(CellSelect ClipCells AlwaysShowSelection ShowInput)←'None' 1 1 0
          ∆GRID.(AutoExpand)←0 0
          ∆GRID.(GridBCol BCol)←¯16 TRGB
          ⍝GRID.(InputMode InputModeKey)←'AlwaysScroll' (27 0)  ⍝ (27 0) = ESC
          ∆GRID.(Size)←150 300
          tip←⊂'Your input array seems to have numeric series.'
          tip,←⊂'Please check that your series are row-wise, and if not, right-click on the grid to transpose it.'
          tip,←⊂'You can also select a row for X coordinates, if your data has any.'
          tip,←⊂'Non-numeric columns can be selected as Key titles, by right-clicking on that column.'
          ∆GRID Gui.Tip tip
         
          cellw←50
          ∆KEY←⎕THIS Gui.BuildSubForm ⍬
          ∆KEY←⎕NEW'Grid'(('VScroll' 0)('HScroll' 0))
          ∆KEY.(CellHeights CellWidths TitleHeight TitleWidth CellSelect)←Gui.STDH cellw 0 0 'None'
          ∆KEY.(Input)←∆KEY.{⎕NEW'Label'(('BCol'⍵)('Justify' 'Center'))}¨TRGB
          ∆KEY.(Values)←1 4⍴'Values' 'X' 'Key' 'Ignored'
          ∆KEY.(CellTypes)←1 4⍴TYPE_V TYPE_X TYPE_K TYPE_0
          ∆KEY.(BCol)←TRGB
          ∆KEY.(ShowInput)←1
          ∆KEY.(Size)←(Gui.STDH)(cellw×4)
         
          ∆G←⎕THIS Gui.BuildSubForm ⍬
          ∆OK←∆G Gui.BuildButton'OK'
          ∆DEFAULT←∆G Gui.BuildButton'Default'
          ∆DEFAULT.Default←1
          (∆buttons←∆OK ∆DEFAULT)Gui.LayoutGrid 0 Gui.SPACE ¯1 1 0
         
          (3 1⍴∆GRID ∆KEY ∆G)Gui.LayoutGrid Gui.SPACE Gui.SPACE(3 1⍴0 1 1)(3 1⍴0 ¯1 0)(3 1⍴1 0 1)
         
          ∆MENU←∆GRID.⎕NEW'Menu'(⊂('EdgeStyle' 'None'))
          ∆menus←∆SEPS←⍬
          ∆ROWV←∆menus,←∆MENU.⎕NEW'MenuItem'(('Caption' 'Set Row as Values')('BCol'(TYPE_V⊃TRGB)))
          ∆ROWX←∆menus,←∆MENU.⎕NEW'MenuItem'(('Caption' 'Set Row as X')('BCol'(TYPE_X⊃TRGB)))
          ∆ROW0←∆menus,←∆MENU.⎕NEW'MenuItem'(('Caption' 'Ignore Row')('BCol'(TYPE_0⊃TRGB)))
          ∆SEPS,←∆MENU.⎕NEW'Separator'(⊂('Style' 'Horz'))
          ∆COLV←∆menus,←∆MENU.⎕NEW'MenuItem'(('Caption' 'Set Column as Values')('BCol'(TYPE_V⊃TRGB)))
          ∆COLK←∆menus,←∆MENU.⎕NEW'MenuItem'(('Caption' 'Set Column as Key')('BCol'(TYPE_K⊃TRGB)))
          ∆COL0←∆menus,←∆MENU.⎕NEW'MenuItem'(('Caption' 'Ignore Column')('BCol'(TYPE_0⊃TRGB)))
          ∆SEPS,←∆MENU.⎕NEW'Separator'(⊂('Style' 'Horz'))
          ∆RESET←∆menus,←∆MENU.⎕NEW'MenuItem'(⊂('Caption' 'Reset Row/Column Selection'))
          ∆TRANSPOSE←∆menus,←∆MENU.⎕NEW'MenuItem'(⊂('Caption' 'Transpose Matrix'))
         
          ⍝ Event handlers :
          ∆GRID.onCellDown←'SeriesClick' ⍝!!! from the doc : If you enable this event it is advisable that you ALSO enable MouseUp events. Otherwise, the slight delay in running your callback function will cause the down and up sequence to be reversed.
          (∆buttons,∆menus).onSelect←1
          ⎕THIS.onClose←1
         
          EXPRESSION←expr
          :If 2≠⍴⍴value ⋄ NESTED←1 ⋄ value←↑value ⋄ :Else ⋄ NESTED←0 ⋄ :EndIf  ⍝ make matrix if necessary
          (r c)←⍴value ⋄
          :If TRANSPOSED←(r>c) ⋄ value←⍉value ⋄ :EndIf
          SetMatrix value
        ∇

        ∇ SetMatrix mat;r;c;comments;diff;gridsize
          (r c)←⍴MATRIX←mat
          ∆GRID.(Values RowTitles ColTitles)←(,∘⍕¨mat)(⍕¨⍳r)(⍕¨⍳c)
          :If c>0
              ∆GRID.SetColSize¨(⍳c),¨¯3
              ∆GRID.CellWidths←30⌈∆GRID.CellWidths
          :EndIf
          ResetMatrix
          diff←⎕THIS.Size-∆GRID.Size
          gridsize←1++/¨∆GRID.(CellHeights CellWidths,¨TitleHeight TitleWidth)
          ⎕THIS Gui.Resize(diff⌈∆KEY.Size+2×Gui.SPACE)⌈(0.7×Gui.GetScreenSize)⌊diff+gridsize
        ∇

        ∇ ResetMatrix;mask;rowmask;colmask;num;sortedrows;r;c
          mask←Magic.CleanMatrix Util.IsNumScalar¨MATRIX
          rowmask←∨/mask ⋄ colmask←∨⌿mask ⋄ (r c)←⍴MATRIX
          ROWTYPES←r⍴TYPE_0 ⋄ COLTYPES←c⍴TYPE_0
          (rowmask/ROWTYPES)←(colmask/COLTYPES)←TYPE_V   ⍝ numeric items are value by default
          num←rowmask⌿colmask/MATRIX  ⍝ numeric submatrix
          sortedrows←rowmask\Util.IsSorted¨↓num
          :If (2≤+/rowmask)∧(1=+/sortedrows)∧(Magic.BARMAXLENGTH≤+/colmask)        ⍝ more than two series, not too few items, and exactly one series is sorted
              ((<\sortedrows)/ROWTYPES)←TYPE_X    ⍝ first sorted is x
          :ElseIf (+/colmask)≤Magic.BARMAXLENGTH  ⍝ not too many xlabels
              ((<\~rowmask)/ROWTYPES)←TYPE_X      ⍝ first non-numeric row is xlabels
          :EndIf
          ((<\~colmask)/COLTYPES)←TYPE_K          ⍝ first non-numeric col is key
          UpdateMatrix
        ∇

        ∇ UpdateMatrix;r;c;rv;cv;cells
          ⍝ Combine |  0  |   V  | XYKT |
          ⍝ --------+-----+------+------+
          ⍝    0    |  0  |   0  |   0  |
          ⍝    V    |  0  |   V  | XYKT |
          ⍝  XYKT   |  0  | XYKT |   0  |
          :If ~∧/(ROWTYPES∊TYPE_0 TYPE_V TYPE_X),(COLTYPES∊TYPE_0 TYPE_V TYPE_K),(1≥+/ROWTYPES∊TYPE_X),(1≥+/COLTYPES∊TYPE_K) ⋄ Gui.Error'Inconsistent cell types' ⋄ :EndIf
          r←⊃⍴ROWTYPES ⋄ c←⊃⍴COLTYPES
          rv←ROWTYPES=TYPE_V ⋄ cv←COLTYPES=TYPE_V
          cells←r c⍴TYPE_0
          (rv⌿cells)←((+/rv),c)⍴COLTYPES
          (cv/cells)←⍉((+/cv),r)⍴ROWTYPES
          ∆GRID.CellTypes←cells
        ∇
        ∇ Set(row index type);matrix;rows;cols
          (rows cols matrix)←(ROWTYPES COLTYPES MATRIX)
          :If ~row ⋄ (rows cols)←(cols rows) ⋄ matrix←⍉matrix ⋄ :EndIf
          :Select type
          :Case TYPE_0  ⍝ ok
          :Case TYPE_V
              :If ~Util.IsNum(cols=TYPE_V)/matrix[index;]
                  Gui.Info((1+row)⊃'Column' 'Row'),' is not numeric, and cannot be used as Values'
                  :Return
              :EndIf
          :CaseList TYPE_X TYPE_K
              ((rows=type)/rows)←TYPE_0  ⍝ unset previous
          :Else ⋄ Gui.Error'Unhandled cell type'
          :EndSelect
          rows[index]←type
          :If ~row ⋄ (rows cols)←(cols rows) ⋄ :EndIf
          (ROWTYPES COLTYPES)←(rows cols)
          UpdateMatrix
        ∇

        ∇ {msg}←SeriesClick msg;dq;evt;y;x;but;shift;r;c;i;rtype;ctype;∆menus;type;row;index;newtype
          (∆obj evt y x but shift r c i)←msg
          :If ¯1=r ⋄ :Return ⋄ :EndIf                 ⍝ do nothing
          ∆GRID.CurCell←r c                           ⍝ highlight clicked cell
          (rtype ctype)←r c⊃¨ROWTYPES COLTYPES
          ∆menus←∆ROWV ∆ROWX ∆ROW0 ∆COLV ∆COLK ∆COL0
          type←TYPE_V TYPE_X TYPE_0 TYPE_V TYPE_K TYPE_0
          row←3/1 0
          index←3/r c
          ∆menus.Active←¯1≠index
          ∆menus.Checked←type=3/rtype ctype
          :If 0∊⍴dq←⎕DQ ∆MENU ⋄ :Return ⋄ :EndIf
          :Select ∆obj←⊃dq
          :Case ∆ROWV ⋄ Set 1 r((1+rtype=TYPE_V)⊃TYPE_V TYPE_0)
          :Case ∆ROWX ⋄ Set 1 r((1+rtype=TYPE_X)⊃TYPE_X TYPE_0)
          :Case ∆ROW0 ⋄ Set 1 r((1+rtype=TYPE_0)⊃TYPE_0 TYPE_V)
          :Case ∆COLV ⋄ Set 0 c((1+rtype=TYPE_V)⊃TYPE_V TYPE_0)
          :Case ∆COLK ⋄ Set 0 c((1+ctype=TYPE_K)⊃TYPE_K TYPE_0)
          :Case ∆COL0 ⋄ Set 0 c((1+ctype=TYPE_0)⊃TYPE_0 TYPE_V)
          :Case ∆RESET ⋄ ResetMatrix
          :Case ∆TRANSPOSE ⋄ TRANSPOSED←~TRANSPOSED ⋄ SetMatrix⍉MATRIX
          :Else ⋄ Gui.Error'Unhandled menu item'
          :EndSelect
        ∇



        ∇ (x xexpr y yexpr keys)←Run;dq;types;mask;index;FIRST;MIX;numcols;numrows;expr;nummask;colmask;rowmask;FMTIO;∆EXECNS
          :Access Public
          ∆EXECNS←Main.GetExecNamespace ⎕THIS  ⍝ update at each run
          :If ∆EXECNS.⎕ML≥2 ⋄ FIRST←'↑' ⋄ MIX←'⊃' ⋄ :Else ⋄ FIRST←'⊃' ⋄ MIX←'↑' ⋄ :EndIf
          :If ∆EXECNS.⎕IO ⋄ FMTIO←{⍕⍵} ⋄ :Else ⋄ FMTIO←{⍕⍵-1} ⋄ :EndIf
          Show 1 ⋄ ⎕THIS.OnTop←1
          :If 0∊⍴dq←⎕DQ ⎕THIS
          :OrIf ∆OK≢⊃dq
              ResetMatrix
          :EndIf
          ⎕THIS.onClose←0
          Gui.Close ⎕THIS
          x←y←keys←⍬ ⋄ xexpr←yexpr←''
          :If (∧/TYPE_0=ROWTYPES)∨(∧/TYPE_0=COLTYPES)   ⍝ nothing
              :Return
          :ElseIf ∧/TYPE_V=ROWTYPES,COLTYPES     ⍝ everything is values
              y←MATRIX ⋄ yexpr←(TRANSPOSED/'⍉'),((TRANSPOSED∧NESTED)/MIX),EXPRESSION   ⍝ expression for current MATRIX
              :Return
          :EndIf
          y←MATRIX ⋄ expr←(TRANSPOSED/'⍉'),(NESTED/MIX),EXPRESSION   ⍝ expression for current MATRIX
          :If ∧/colmask←COLTYPES=TYPE_V ⋄ numcols←''
          :Else ⋄ numcols←'(⍳',(FMTIO 2),'⊃⍴⍵)~',FMTIO(~colmask)/⍳⍴colmask ⋄ :EndIf
          :If ∧/rowmask←ROWTYPES=TYPE_V ⋄ numrows←''
          :Else ⋄ numrows←'(⍳',(FMTIO 1),'⊃⍴⍵)~',FMTIO(~rowmask)/⍳⍴rowmask ⋄ :EndIf
          :If ∨/mask←TYPE_X=ROWTYPES
              :If 1≠+/mask ⋄ Gui.Error'Inconsistent row types' ⋄ :EndIf
              index←⊃mask/⍳⍴mask
              x←colmask/MATRIX[index;] ⋄ xexpr←'{⍵[',(FMTIO index),';',numcols,']}',expr
              :If Util.IsNum x  ⍝ x is ok
              :ElseIf Util.IsText x ⋄ x←,¨x ⋄ xexpr←',¨',xexpr
              :ElseIf ~Util.IsStrings x ⋄ x←,∘⍕¨x ⋄ xexpr←',∘⍕¨',xexpr
              :EndIf
          :EndIf
          :If ∨/mask←TYPE_K=COLTYPES
              :If 1≠+/mask ⋄ Gui.Error'Inconsistent col types' ⋄ :EndIf
              keys←,∘⍕¨,rowmask⌿(<\mask)/MATRIX
          :EndIf
          y←rowmask⌿colmask/MATRIX
          yexpr←'{⍵[',numrows,';',numcols,']}',expr
        ∇

    :EndClass

    :EndSection








⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section Samples
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

    :Namespace Samples
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862

        ∇ {∆wizard}←Base10 ∆wizard;id
          :Access Public
          ∆wizard.Refresh 0
          id←∆wizard.AddCharts'Scatter'
          ∆wizard.SetChartOption id'Heading' 'Why base-10 is cool'
          ∆wizard.SetChartOption id'SetColors'System.Drawing.Color.(Red Blue)
          ∆wizard.SetChartOption id'SetMarkers'(,Causeway.Marker.Plus)
          ∆wizard.SetChartOption id'SetPenWidths'(1 0.5)
          ∆wizard.SetChartOption id'SetKeyText'('Integer approximation' 'Base-10 logarithm')
          ∆wizard.SetChartOption id'KeyStyle'Causeway.KeyStyles.Reversed
          ∆wizard.SetSeries id'X' '1 2 4 5 8 10'
          ∆wizard.SetSeries id'Y' '0 0.3 0.6 0.7 0.9 1'
          id←∆wizard.AddCharts'Line'
          ∆wizard.SetChartOption id'LineGraphStyle'Causeway.LineGraphStyles.(GridLines+Curves)
          ∆wizard.SetSeries id'X' '(9↓(~⎕IO)+⍳100)÷10'
          ∆wizard.SetSeries id'Y' '10⍟(9↓(~⎕IO)+⍳100)÷10'
          ∆wizard.Refresh 1
        ∇

        ∇ {∆wizard}←Base12 ∆wizard;id
          :Access Public
          ∆wizard.Refresh 0
          id←∆wizard.AddCharts'Scatter'
          ∆wizard.SetChartOption id'Heading' 'Why base-12 is cool'
          ∆wizard.SetChartOption id'Footnote' 'Also you can represent one base-12 digit per hand by pointing the thumb at the 3 phalanges of the 4 remaining fingers'
          ∆wizard.SetChartOption id'SetColors'System.Drawing.Color.(Red Blue)
          ∆wizard.SetChartOption id'SetMarkers'(,Causeway.Marker.Plus)
          ∆wizard.SetChartOption id'SetPenWidths'(1 0.5)
          ∆wizard.SetChartOption id'SetKeyText'('Rule of twelfths (1 2 3 3 2 1)' 'Sine wave')
          ∆wizard.SetChartOption id'KeyStyle'Causeway.KeyStyles.Reversed
          ∆wizard.SetSeries id'X'(0,⍳12)
          ∆wizard.SetSeries id'Y' '+\0,{⍵,⌽-⍵}{⍵,⌽⍵}1 2 3'
          id←∆wizard.AddCharts'Line'
          ∆wizard.SetChartOption id'LineGraphStyle'Causeway.LineGraphStyles.(GridLines+Curves)
          ∆wizard.SetSeries id'X' '.12×(0,⍳100)'
          ∆wizard.SetSeries id'Y' '6+6×-2○○(0,⍳100)÷50'
          ∆wizard.Refresh 1
        ∇


        ∇ {∆wizard}←Vector ∆wizard;id;x;y;n;d;∆yzones
          ∆wizard.Refresh 0
          id←∆wizard.AddCharts'Vector'
          n←20 ⋄ d←20 ⋄ (x y)←↓○??2 n⍴d
          ∆wizard.SetChartOption id'Heading' 'Tow overlaid vector fields'
          ∆wizard.SetChartOption id'Subheading' 'with Y zones'
          ∆wizard.SetChartOption id'Footnote' 'Data is 4 numeric vectors for (x y) position of start and end points.'
          ∆wizard.SetChartOption id'FootnoteStyle'Causeway.FootnoteStyles.RuledAbove
          ∆wizard.SetChartOption id'SetMargins'(50 60 30 20)
          ∆wizard.SetChartOption id'SetKeyText'('First series' 'Second Series')
          ∆wizard.SetChartOption id'SetLineStyles'(,Causeway.LineStyle.Solid)
          ∆yzones←,⎕NEW Causeway.Zone(0 10 System.Drawing.Color.Lime Causeway.FillStyle.Opacity18 0)
          ∆yzones,←⎕NEW Causeway.Zone(40 ¯32768 System.Drawing.Color.Red Causeway.FillStyle.Opacity18 0)
          ∆wizard.SetChartOption id'SetYZones'∆yzones
          ∆wizard.SetChartOption id'SetXRange'(0 65)
          ∆wizard.SetChartOption id'XCaption' 'Distance'
          ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.(GridLines+ArrowedAxis)
          ∆wizard.SetChartOption id'SetYRange'(0 65)
          ∆wizard.SetChartOption id'YCaption' 'Height'
          ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.(GridLines+ArrowedAxis)
          ∆wizard.SetSeries id'Y1'(⌊0.9×y)
          ∆wizard.SetSeries id'Y2'(⌈y)
          ∆wizard.SetSeries id'X1'(⌊0.8×x)
          ∆wizard.SetSeries id'X2'(⌈x)
          (x y)←↓○??2 n⍴d
          id←∆wizard.AddCharts'Vector'
          ∆wizard.SetSeries id'Y1'(⌈y)
          ∆wizard.SetSeries id'Y2'(⌊0.9×y)
          ∆wizard.SetSeries id'X1'(⌊(○d)-x)
          ∆wizard.SetSeries id'X2'(⌈(○d)-0.8×x)
          ∆wizard.Refresh 1
        ∇
        ∇ {∆wizard}←Trace ∆wizard;id
          ∆wizard.Refresh 0
          id←∆wizard.AddCharts'Trace'
          ∆wizard.SetChartOption id'Heading' 'A Trace chart to detect sharp changes'
          ∆wizard.SetChartOption id'Subheading' 'with time X axis'
          ∆wizard.SetChartOption id'SetMargins'(50 30 30 20)
          ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.(GridLines+Time+Date+ArrowedAxis)
          ∆wizard.SetChartOption id'YAxisStyle' 0
          ∆wizard.SetChartOption id'SetYLabels'('First' 'Second' 'Third' 'Fourth' 'Fifth')
          ∆wizard.SetChartOption id'IAxisStyle'Causeway.IAxisStyles.GridLines
          ∆wizard.SetChartOption id'SetIRange'(¯200 200)
          ∆wizard.SetSeries id'Inner'('(((?∘(1∘+)⍣3))5 500⍴100)×',Global.NORMALRANDOM,' 5 500')
          ∆wizard.SetSeries id'X' 'System.DateTime.Now.ToOADate+¯5+.01×⍳500'
          ∆wizard.Refresh 1
        ∇
        ∇ {∆wizard}←Scatter ∆wizard;id
          ∆wizard.Refresh 0
          ∆wizard.SetGlobalOption'SetNewline' ';'
          id←∆wizard.AddCharts'Scatter'
          ∆wizard.SetChartOption id'Heading' 'Linear fit on a Scatter plot'
          ∆wizard.SetChartOption id'SetEquationPosition'(10 230)
          ∆wizard.SetChartOption id'SetMargins'(50 18 19 18)
          ∆wizard.SetChartOption id'EquationStyle'Causeway.EquationStyles.(Absolute+Opaque)
          ∆wizard.SetChartOption id'EquationFormat' 'Model fit: y = C1x + C0;R<sup>2</sup> = R2'
          ∆wizard.SetChartOption id'ScatterPlotStyle'Causeway.ScatterPlotStyles.(ModelFit+AnnotateModel)
          ∆wizard.SetChartOption id'XIntercept' 0
          ∆wizard.SetChartOption id'YIntercept' 0
          ∆wizard.SetSeries id'X'('{⍵[⍋⍵]}',Global.NORMALRANDOM,' 50')
          ∆wizard.SetSeries id'Y'('(0.1×⍳50)+',Global.NORMALRANDOM,' 50')
          ∆wizard.Refresh 1
        ∇
        ∇ Line ∆wizard;id
          ∆wizard.Refresh 0
          id←∆wizard.AddCharts'Line'
          ∆wizard.SetGlobalOption'SetNewline' ';'
          ∆wizard.SetChartOption id'SetMargins'(40 50 30 30)
          ∆wizard.SetChartOption id'Heading' 'Simple Line Graph'
          ∆wizard.SetChartOption id'Subheading' 'with curves, Y datums and inverted Y axis'
          ∆wizard.SetChartOption id'HeadingStyle'Causeway.HeadingStyles.Bottom
          ∆wizard.SetChartOption id'SetChartBackground'(System.Drawing.Color.LightSeaGreen Causeway.FillStyle.GradientBottom 0)
          ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.(ArrowedAxis+TopAxis)
          ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.(ArrowedAxis+InvertAxis+AtEndCaption)
          ∆wizard.SetChartOption id'YCaption' 'Depth'
          ∆wizard.SetChartOption id'XCaption' 'Distance from shore'
          ∆wizard.SetChartOption id'SetYDatumLines'(50 100)
          ∆wizard.SetChartOption id'SetDatumLineTags'('Surface water' ';Deep water')
          ∆wizard.SetChartOption id'SetDatumTagFont'('Arial' 10 System.Drawing.FontStyle.Regular System.Drawing.Color.Navy)
          ∆wizard.SetChartOption id'SetPenWidths'(,1.5)
          ∆wizard.SetChartOption id'LineGraphStyle'Causeway.LineGraphStyles.Curves
          ∆wizard.SetChartOption id'Flexibility' 100
          ∆wizard.SetSeries id'Y'('0,20×+\|',Global.NORMALRANDOM,' 10')
          ∆wizard.SetSeries id'X'('0,10×+\5+?10⍴10')
          ∆wizard.Refresh 1
        ∇
        ∇ Surface ∆wizard;id
          ∆wizard.Refresh 0
          id←∆wizard.AddCharts'Line'
          ∆wizard.SetChartOption id'Heading' 'Stacked surfaces'
          ∆wizard.SetChartOption id'Subheading' 'with overlaid white gridlines'
          ∆wizard.SetChartOption id'Footnote' 'Stacked surface is achieved with DataStyles.Relative'
          ∆wizard.SetChartOption id'DataStyle'Causeway.DataStyles.Relative
          ∆wizard.SetChartOption id'SetGridLineStyle'(System.Drawing.Color.White Causeway.LineStyle.Solid 0.18)
          ∆wizard.SetChartOption id'SetColors'System.Drawing.Color.(Navy Maroon Green OrangeRed Teal DarkOrchid DimGray)
          ∆wizard.SetChartOption id'SetFillStyles'(,Causeway.FillStyle.Saturate80)
          ∆wizard.SetChartOption id'SetKeyText'('UK' 'France' 'Germany' 'Spain' 'Italy')
          ∆wizard.SetChartOption id'LineGraphStyle'Causeway.LineGraphStyles.(NoLines+SurfaceShading)
          ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.NoAxis
          ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.(GridLines+OverlayGrid+DuplicateAxes)
          ∆wizard.SetSeries id'Y'('|',Global.NORMALRANDOM,' 5 10')
          ∆wizard.Refresh 1
        ∇

        ∇ {∆wizard}←Business ∆wizard;id
          ∆wizard.Refresh 0
          ∆wizard.SetGlobalOption'SetBackground'(System.Drawing.Color.(FromArgb 64 64 64)Causeway.FillStyle.GradientBottomRight 0)
          id←∆wizard.AddCharts'Bar'
          ∆wizard.SetChartOption id'SetAxisStyle'(System.Drawing.Color.White Causeway.LineStyle.Solid 2)
          ∆wizard.SetChartOption id'BarChartStyle'Causeway.BarChartStyles.StackedBars
          ∆wizard.SetChartOption id'SetColors'(System.Drawing.Color.FromArgb¨(255 128 0)(0 128 255)(117 234 0))
          ∆wizard.SetChartOption id'SetEdgeStyle'(System.Drawing.Color.Black Causeway.LineStyle.Invisible 0)
          ∆wizard.SetChartOption id'SetGridLineStyle'(System.Drawing.Color.White Causeway.LineStyle.Solid 0.5)
          ∆wizard.SetChartOption id'SetHeadingFont'('Arial' 21 System.Drawing.FontStyle.Bold System.Drawing.Color.White)
          ∆wizard.SetChartOption id'Heading' 'Sales figures'
          ∆wizard.SetChartOption id'SetFootnoteFont'('Arial' 7 System.Drawing.FontStyle.Regular System.Drawing.Color.White)
          ∆wizard.SetChartOption id'FootnoteStyle'Causeway.FootnoteStyles.Right
          ∆wizard.SetChartOption id'Footnote' 'in millions, of course'
          ∆wizard.SetChartOption id'SetKeyFont'('Arial' 13 System.Drawing.FontStyle.Regular System.Drawing.Color.White)
          ∆wizard.SetChartOption id'SetKeyText'('Cigarettes' 'Pyjamas' 'Dog food')
          ∆wizard.SetChartOption id'SetLabelFont'('Arial' 12 System.Drawing.FontStyle.Regular System.Drawing.Color.White)
          ∆wizard.SetChartOption id'SetMargins'(50 50 25 25)
          ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.ForceZero
          ∆wizard.SetChartOption id'SetXLabels'('Jan' 'Feb' 'Mar' 'Apr' 'May' 'Jun' 'Jul' 'Aug' 'Sep' 'Oct' 'Nov' 'Dec')
          ∆wizard.SetChartOption id'XTickStyle'Causeway.XTickStyles.NoTicks
          ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.(ForceZero+GridLines+OverlayGrid+DuplicateAxes)
          ∆wizard.SetChartOption id'SetYTickMarks'(10 1)
          ∆wizard.SetSeries id'Values' '○?3 12⍴⍳12'
          id←∆wizard.AddCharts'Pie'
          ∆wizard.SetChartOption id'SetPieCenter'(60 180)
          ∆wizard.SetChartOption id'PieChartStyle'Causeway.PieChartStyles.ValueTags
          ∆wizard.SetChartOption id'PieRadius' 40
          ∆wizard.SetChartOption id'SetValueFont'('Arial' 12 System.Drawing.FontStyle.Bold System.Drawing.Color.White)
          ∆wizard.SetChartOption id'ValueTagStyle'Causeway.ValueTagStyles.Inside
          ∆wizard.SetChartOption id'SetXLabels'⍬
          ∆wizard.SetSeries id'Values' '100+?3⍴100'
          ∆wizard.SetSeries id'Explode' '20 0 0'
          ∆wizard.Refresh 1
        ∇

        ∇ {∆wizard}←Response2D ∆wizard;id
          ∆wizard.Refresh 0
          id←∆wizard.AddCharts'Response'
          ∆wizard.SetChartOption id'Heading' '2D Response Surface'
          ∆wizard.SetChartOption id'Subheading' 'a response plot with altitude shading and no perspective'
          ∆wizard.SetChartOption id'Footnote' 'Data is an [X;Y] matrix of Z altitudes. Optional vectors for X and Y coordinates were used here.'
          ∆wizard.SetChartOption id'SetMargins'(80 40 20 60)
          ∆wizard.SetChartOption id'SetViewpoint'(90 0 90)
          ∆wizard.SetChartOption id'Perspective' 0
          :If '2.43'Util.CompareVersions Util.SHARPPLOTVERSION
              ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.(GridLines+AngledLabels+ExactFit)
              ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.(GridLines+AngledLabels+ExactFit)
          :Else  ⍝ ExactFit didn't work
              ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.(GridLines+AngledLabels)
              ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.(GridLines+AngledLabels)
          :EndIf
          ∆wizard.SetChartOption id'ZAxisStyle'Causeway.ZAxisStyles.PlainAxis
          ∆wizard.SetChartOption id'ResponsePlotStyle'Causeway.ResponsePlotStyles.(AltitudeShading+ScaleBar+NoLines)
          ∆wizard.SetChartOption id'SetAltitudeColors'(System.Drawing.Color.(Blue Lime Yellow Red DeepPink))
          ∆wizard.SetChartOption id'SetContourStyle'(System.Drawing.Color.White Causeway.LineStyle.Solid 0.8)
          ∆wizard.SetChartOption id'SetFillStyles'(,Causeway.FillStyle.Solid)
          ∆wizard.SetSeries id'X'('¯35++\1+|',Global.NORMALRANDOM,' 40')
          ∆wizard.SetSeries id'Y'('¯30++\1+|',Global.NORMALRANDOM,' 30')
          ∆wizard.SetSeries id'Z'('⌽+⍀+\0.02+',Global.NORMALRANDOM,' 30 40')
          ∆wizard.Refresh 1
        ∇


        ∇ {∆wizard}←Response3D ∆wizard;id
          ∆wizard.Refresh 0
          id←∆wizard.AddCharts'Response'
          ∆wizard.SetGlobalOption'SetBackground'(System.Drawing.Color.Black Causeway.FillStyle.Sunrise 0)
          ∆wizard.SetChartOption id'SetMargins'(50 30 30 ¯50)
          ∆wizard.SetChartOption id'Heading' '3D Response Surface'
          ∆wizard.SetChartOption id'SetHeadingFont'('Times New Roman' 16 System.Drawing.FontStyle.Regular System.Drawing.Color.White)
          ∆wizard.SetChartOption id'Subheading' 'a response plot with altitude shading and perspective'
          ∆wizard.SetChartOption id'SetSubheadingFont'('Times New Roman' 12 System.Drawing.FontStyle.Regular System.Drawing.Color.White)
          ∆wizard.SetChartOption id'Footnote' 'Data is an [X;Y] matrix of Z altitudes.'
          ∆wizard.SetChartOption id'SetFootnoteFont'('Arial' 8 System.Drawing.FontStyle.Regular System.Drawing.Color.White)
          ∆wizard.SetChartOption id'FootnoteStyle'Causeway.FootnoteStyles.RuledAbove
          :If ~'2.53'Util.CompareVersions Util.SHARPPLOTVERSION  ⍝ incorrectly used keyfont for scalebar before that
              ∆wizard.SetChartOption id'SetKeyFont'('Times New Roman' 8 System.Drawing.FontStyle.Regular System.Drawing.Color.White)
          :EndIf
          ∆wizard.SetChartOption id'SetLabelFont'('Times New Roman' 8 System.Drawing.FontStyle.Regular System.Drawing.Color.White)
          ∆wizard.SetChartOption id'SetAxisStyle'(System.Drawing.Color.White Causeway.LineStyle.Solid 1.2)
          ∆wizard.SetChartOption id'ResponsePlotStyle'Causeway.ResponsePlotStyles.(NoLines+AltitudeShading+ScaleBar)
          ∆wizard.SetChartOption id'SetAltitudeColors'(System.Drawing.Color.(Black Navy YellowGreen Khaki Peru Silver))
          ∆wizard.SetChartOption id'SetFillStyles'(,Causeway.FillStyle.Opacity78)
          ∆wizard.SetSeries id'Z'('⌽+⍀+\0.02+',Global.NORMALRANDOM,' 30 40')
          ∆wizard.Refresh 1
         
         
        ∇

        ∇ {∆wizard}←Contour1 ∆wizard;id;expr
          ∆wizard.Refresh 0
          id←∆wizard.AddCharts'Contour'
          ∆wizard.SetChartOption id'Heading' '2D Regression Surface'
          ∆wizard.SetChartOption id'Subheading' 'a contour plot with altitude shading'
          ∆wizard.SetChartOption id'Footnote' 'Data is three X Y Z numerical vectors for the markers. The surface is an extrapolated bi-variate polynomial fit.'
          ∆wizard.SetChartOption id'SetMargins'(60 30 20 60)
          ∆wizard.SetChartOption id'SetOrderOfFit'(3 3)
          ∆wizard.SetChartOption id'ContourPlotStyle'Causeway.ContourPlotStyles.(ValueTags+Curves+AltitudeShading+Fine+ScaleBar)
          ∆wizard.SetChartOption id'SetMarkers'(,Causeway.Marker.Bullet)
          ∆wizard.SetChartOption id'SetValueFont'('Arial' 6 System.Drawing.FontStyle.Regular System.Drawing.Color.Black)
          ∆wizard.SetChartOption id'SetGridLineStyle'(System.Drawing.Color.Black Causeway.LineStyle.Solid 0.18)
          ∆wizard.SetChartOption id'SetAltitudeColors'(System.Drawing.Color.(Blue Lime Yellow Red DeepPink))
          ∆wizard.SetChartOption id'SetContourStyle'(System.Drawing.Color.White Causeway.LineStyle.Solid 0.8)
          ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.(GridLines+OverlayGrid+DuplicateAxes)
          ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.(GridLines+OverlayGrid+DuplicateAxes)
          ∆wizard.SetChartOption id'SetXTickMarks' 1
          ∆wizard.SetChartOption id'SetYTickMarks' 1
          expr←Global.NORMALRANDOM,' 20'
          ∆wizard.SetSeries id'Z'('+\⌊10×1+',expr)
          ∆wizard.SetSeries id'Y'('+\0.7×',expr)
          ∆wizard.SetSeries id'X'('+\',expr)
          ∆wizard.Refresh 1
        ∇

        ∇ {∆wizard}←Contour2 ∆wizard;id;expr
          ∆wizard.Refresh 0
          id←∆wizard.AddCharts'Contour'
          ∆wizard.SetChartOption id'Heading' 'Double Contour Plot'
          ∆wizard.SetChartOption id'Footnote' 'Overlaying two contour plots on shared XY values'
          ∆wizard.SetChartOption id'SetMargins'(50 50 20 20)
          ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.(DuplicateAxes+GridLines)
          ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.(DuplicateAxes+GridLines)
          ∆wizard.SetChartOption id'SetOrderOfFit'(2 2)
          ∆wizard.SetChartOption id'SetKeyText'('First series' 'Second series')
          ∆wizard.SetChartOption id'KeyStyle'Causeway.KeyStyles.(RightAlign+BottomAlign)
          ∆wizard.SetChartOption id'ContourPlotStyle'Causeway.ContourPlotStyles.(ValueTags+Curves)
          ∆wizard.SetChartOption id'SetMarkers'(,Causeway.Marker.Bullet)
          ∆wizard.SetChartOption id'SetColors'(,System.Drawing.Color.Red)
          ∆wizard.SetChartOption id'SetContourStyle'(System.Drawing.Color.Red Causeway.LineStyle.Solid 0.8)
          ∆wizard.SetChartOption id'SetValueFont'('Arial' 6 System.Drawing.FontStyle.Regular System.Drawing.Color.Red)
          ∆wizard.SetChartOption id'ValueTagStyle'Causeway.ValueTagStyles.Right
          expr←Global.NORMALRANDOM,' 20'
          ∆wizard.SetSeries id'X'('+\111 ',expr)
          ∆wizard.SetSeries id'Y'('+\222 ',expr)
          ∆wizard.SetSeries id'Z'('+\⌊10×1+',expr)
          id←∆wizard.AddCharts'Contour'
          ∆wizard.SetChartOption id'ContourPlotStyle'Causeway.ContourPlotStyles.(ValueTags+Curves) ⍝ override wizard default
          ∆wizard.SetChartOption id'SetMarkers'(,Causeway.Marker.Ring)                            ⍝ override wizard default
          ∆wizard.SetChartOption id'SetColors'(,System.Drawing.Color.Blue)
          ∆wizard.SetChartOption id'SetContourStyle'(System.Drawing.Color.Blue Causeway.LineStyle.Solid 0.8)
          ∆wizard.SetChartOption id'SetValueFont'('Arial' 6 System.Drawing.FontStyle.Regular System.Drawing.Color.Blue)
          ∆wizard.SetChartOption id'ValueTagStyle'Causeway.ValueTagStyles.Left
          ∆wizard.SetSeries id'X'('+\111 ',expr)
          ∆wizard.SetSeries id'Y'('+\222 ',expr)
          ∆wizard.SetSeries id'Z'('⌊10×1+',expr)
          ∆wizard.Refresh 1
        ∇


        ∇ {∆wizard}←Contour3 ∆wizard;id;expr
          ∆wizard.Refresh 0
          id←∆wizard.AddCharts'Cloud'
          ∆wizard.SetChartOption id'Heading' '3D Regression Surface'
          ∆wizard.SetChartOption id'Subheading' 'a cloud chart with model fit and altitude shading'
          ∆wizard.SetChartOption id'Footnote' 'Data is three X Y Z numerical vectors for the markers. The surface is an extrapolated bi-variate polynomial fit.'
          ∆wizard.SetChartOption id'SetMargins'(50 30 20 ¯100)
          ∆wizard.SetChartOption id'SetOrderOfFit'(3 3)
          ∆wizard.SetChartOption id'CloudChartStyle'Causeway.CloudChartStyles.(AltitudeShading+ScaleBar+ModelFit+Risers)
          ∆wizard.SetChartOption id'SetMarkers'(,Causeway.Marker.Ball)
          ∆wizard.SetChartOption id'SetColors'(System.Drawing.Color.((FromArgb 32 0 0 0)Red))  ⍝ cannot use transparency lower than 9 (SharpPlot would interpret it as CMYK)
          ∆wizard.SetChartOption id'SetFillStyles'(,Causeway.FillStyle.Opacity78)
          expr←Global.NORMALRANDOM,' 20'
          ∆wizard.SetSeries id'Z'('+\',expr)
          ∆wizard.SetSeries id'Y'('+\',expr)
          ∆wizard.SetSeries id'X'('+\',expr)
          ∆wizard.Refresh 1
        ∇

        ∇ {∆wizard}←Psycho ∆wizard;id
          ∆wizard.Refresh 0
          id←∆wizard.AddCharts'Polar'
          ∆wizard.SetChartOption id'Heading' 'Psychoscope'
          ∆wizard.SetChartOption id'Footnote' 'Explore your own psyche with normal random distributions. Hit enter on the series expression to generate a new one.'
          ∆wizard.SetChartOption id'SetMargins'(40 0 0 0)
          ∆wizard.SetChartOption id'SetFillStyles'(,Causeway.FillStyle.Opacity6)
          ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.NoAxis
          ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.NoAxis
          ∆wizard.SetChartOption id'SetColors'System.Drawing.Color.(Blue Red LimeGreen Yellow Magenta Orange)
          ∆wizard.SetChartOption id'PolarChartStyle'Causeway.PolarChartStyles.(SurfaceShading+Curves+NoLines)
          ∆wizard.SetSeries id'Y'('{(⌽⍵),⍵}+\',Global.NORMALRANDOM,' 10 180')
          ∆wizard.Refresh 1
        ∇

        ∇ {wizard}←Histogram ∆wizard;id;n
          n←100
          ∆wizard.Refresh 0
          ∆wizard.SetGlobalOption'SetBackground'((System.Drawing.Color.FromArgb(255 255 64))Causeway.FillStyle.GradientBottomRight 0)
          id←∆wizard.AddCharts'Histogram'
          ∆wizard.SetChartOption id'Heading' 'Sum of 2-dice throw'
          ∆wizard.SetChartOption id'Subheading'('Number of throws = ',⍕n)
          ∆wizard.SetChartOption id'SetMargins'(60 40 40 20)
          ∆wizard.SetChartOption id'HistogramStyle'Causeway.HistogramStyles.(SurfaceShading+Mean+SDev1+NormalCurve)
          ∆wizard.SetChartOption id'SetFillStyles'(,Causeway.FillStyle.GradientTop)
          ∆wizard.SetChartOption id'XCaption' 'Values'
          ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.(GridLines+CenteredCaption+MiddleLabels)
          ∆wizard.SetChartOption id'SetXRange'(2 13)
          ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.(DuplicateAxes+GridLines+ForceZero+CenteredCaption)
          ∆wizard.SetChartOption id'YCaption' 'Occurences'
          ∆wizard.SetSeries id'Values'('+/(~⎕IO)+?',(⍕n),' 2⍴6')
          ∆wizard.Refresh 1
        ∇

        ∇ {∆wizard}←Bubble ∆wizard;id;vx;vy;r;t;v;n
          ∆wizard.Refresh 0
          id←∆wizard.AddCharts'Bubble'
          ∆wizard.SetGlobalOption'SetNewline' ';'
          ∆wizard.SetChartOption id'Heading' 'Constant-momentum motion - a 4D chart'
          ∆wizard.SetChartOption id'Subheading' 'repeatedly hit enter on the series expression to animate the balls'
          ∆wizard.SetChartOption id'Footnote' 'All balls have the same momentum, meaning that they would stop if they hit each other face to face.;Momentum is proportional to speed (2D - x and y) and cube of radius (1D - marker scales).;Altitude shading indicates density (1D), where 1 is the smallest density of the set.'
          ∆wizard.SetChartOption id'SetMargins'(60 40 20 60)
          ∆wizard.SetChartOption id'SetChartBackground'(System.Drawing.Color.DarkGreen Causeway.FillStyle.Solid 0)
          ∆wizard.SetChartOption id'BubbleChartStyle'Causeway.BubbleChartStyles.(AltitudeShading+RadialScaling+FrameAxes+ScaleBar)
          ∆wizard.SetChartOption id'SetMarkers'(,Causeway.Marker.Bullet)
          ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.PlainAxis
          ∆wizard.SetChartOption id'SetXRange'(0 1)
          ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.PlainAxis
          ∆wizard.SetChartOption id'SetYRange'(0 1)
          ∆wizard.SetChartOption id'SetAltitudeColors'System.Drawing.Color.(White Black)
          ∆wizard.SetChartOption id'ZAxisStyle'Causeway.ZAxisStyles.ForceZero   ⍝ darkness proortional to altitude
          ∆wizard.SetChartOption id'SetZTickMarks' 1                            ⍝ because we will use the smallest value to 1, and want ot check that the color rangeis readable on the scale bar
          ∆wizard.SetChartOption id'ZCaption' 'Density'                            ⍝ because we will use the smallest value to 1, and want ot check that the color rangeis readable on the scale bar
          ⍝ carefully choose radius and speed so that density remains redable i.e. within a small dynamic span (max÷min) - yet allowing as much speed and radius variety as possible
          n←' 10'                                                   ⍝ number of balls
          t←'0.0001×0 60 60 1000⊥¯4↑⎕TS'                           ⍝ time - reset world at midnight
          vx←'888 ',Global.NORMALRANDOM,n      ⍝ horizontal speed   ⍝ {(×⍵)×(|⍵)*.5}
          vy←'999 ',Global.NORMALRANDOM,n      ⍝ vertical speed
          v←'0.5*⍨⊃+/2*⍨888 999 ',Global.NORMALRANDOM,'¨',n  ⍝ speed magnitude
          r←'1+|777 ',Global.NORMALRANDOM,n             ⍝ ball radius
          1 ∆wizard.SetChartOption id'SetMarkerScales'('3×',r)
          ∆wizard.SetSeries id'X'('1|(',vx,')×(',t,')')            ⍝ wrap around [0;1]
          ∆wizard.SetSeries id'Y'('1|(',vy,')×(',t,')')
          ∆wizard.SetSeries id'Z'('{⍵÷⌊/⍵}÷(3*⍨',r,')×(',v,')')     ⍝ density ← ÷((volume←radius*3)×(speed)  ⍝ {⍵÷⌊⍵} with scalebar is neat for dynamic ranges to blow the values and warn the reader
          ∆wizard.Refresh 1
        ∇
        ∇ {∆wizard}←Radar ∆wizard;id;vx;vy;r;t;v;n
          ∆wizard.Refresh 0
          id←∆wizard.AddCharts'Polar'
          ∆wizard.SetChartOption id'Heading' 'A feature-comparison Radar chart'
          ∆wizard.SetChartOption id'SetMargins'(50 30 0 0)
          ∆wizard.SetChartOption id'SetColors'System.Drawing.Color.(Blue Red LimeGreen)
          ∆wizard.SetChartOption id'SetFillStyles'(,Causeway.FillStyle.Opacity18)
          ∆wizard.SetChartOption id'PolarChartStyle'Causeway.PolarChartStyles.(SurfaceShading+NoLines)
          ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.GridLines
          ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.(ForceZero+GridLines)
          ∆wizard.SetChartOption id'SetXLabels'('Saltness' 'Dryness' 'Greasiness' 'Clamminess' 'Chewiness' 'Crispness' 'Fluffyness')
          ∆wizard.SetChartOption id'SetKeyText'('Fries' 'Chips' 'Crisps')
          ∆wizard.SetSeries id'Y' '↓3+?3 7⍴7'
          ∆wizard.Refresh 1
        ∇
        ∇ {∆wizard}←Splash1 ∆wizard;datasize;xtick;ytick;blur;bold;flex;dens;alt;x;y;w1;w2;u1;u2;bits;mask;id;gridcol;z;w;h;ztick
        ⍝ SharpPlot splash screen (big logo)
          datasize←80 60     ⍝ 2×80 60    ⍝ x y size of the bitmap and of the matrix data !!! CPU hungry !!!
          xtick←6 4          ⍝ 10 5       ⍝ xticks
          ytick←6 4          ⍝ 10 5       ⍝ yticks
          ztick←21           ⍝ 18
          blur←0              ⍝ 0          ⍝ number of pixel blur - reduces the datasize by that many pixels
          bold←1              ⍝ 0.9        ⍝ text boldness (0-1)
          flex←50             ⍝ 30         ⍝ contour flexibility (= accuracy 0-100)
          dens←3              ⍝ 4          ⍝ contour mesh density !!! CPU hungry !!!
          alt←100             ⍝ 100        ⍝ data altitude
          (w h)←datasize
          'bmp'⎕WC'Bitmap'('Bits'(h w⍴1))('Coord' 'Pixel')
          'bmp.fnt'⎕WC'Font' 'Arial'(⌊0.5+h÷2)0 0 0(1000×bold)
          'bmp.'⎕WC'Text'('Sharp' 'Plot')((0.05 0.45×h)(0.05 0.15×w))('Font' 'bmp.fnt')
          w1←{⍺,[1]⍵,[1]⍺} ⋄ u1←{⍺↓[1](-⍺)↓[1]⍵}    ⍝ wrap/unwrap 1st axis
          w2←{⍺,[2]⍵,[2]⍺} ⋄ u2←{⍺↓[2](-⍺)↓[2]⍵}    ⍝ put/remove 2nd axis
          bits←⌽⍉'bmp'⎕WG'Cbits'                    ⍝ turn x y bitmap coord into x y chart coords
          bits←255-(+/[1]256 256 256⊤bits)÷3        ⍝ average RGB to get gray level and invert b/w
          bits←alt×{|⍵÷⌈/,⍵}({0 w2 3+/0 w1 3+⌿⍵}⍣blur)bits   ⍝ blur
          mask←0 w1 0 w2 2 u1 2 u2⊃{∧/2=/⍵},{¯1 0 1∘.⊖¯1 0 1⌽¨⍵}⊂0 w1 0 w2 bits  ⍝ mask of bits with equal neighbours (0 for edge)
          ⍝Gui.Debug'killed ',(⍕+/,mask),' ouf of ',(⍕×/⍴mask),' pixels.'
          (x y z)←↓⍉↑(~,mask)/,(⍳⍴bits),¨bits
          :If 0
              'f'⎕WC'Form'
              'f.bmp'⎕WC'Bitmap'('CBits'(256⊥3⌿,[0.5]⌊0.5+255×bits))
              'f'⎕WS'Picture' 'f.bmp' 3
          :EndIf
          ∆wizard.Refresh 0
          id←∆wizard.AddCharts'Contour'
          ∆wizard.SetSeries id'Z'z
          ∆wizard.SetSeries id'Y'y
          ∆wizard.SetSeries id'X'x
          ∆wizard.SetChartOption id'Gutter' 1
          ∆wizard.SetChartOption id'SetMargins'(0 0 0 0)
          ∆wizard.SetChartOption id'SetMarkers'(,Causeway.Marker.Invisible)  ⍝ ContourPlotStyle.NoMarkers was introduced in v2.42
          gridcol←System.Drawing.Color.FromArgb 128 0 100 0
          ∆wizard.SetChartOption id'SetGridLineStyle'(gridcol Causeway.LineStyle.Solid 1.5)
          ∆wizard.SetChartOption id'SetAxisStyle'(System.Drawing.Color.Black Causeway.LineStyle.Solid 1.5)
          ∆wizard.SetChartOption id'SetAltitudeColors'System.Drawing.Color.(YellowGreen Khaki Peru Black)
          ∆wizard.SetChartOption id'XTickStyle'Causeway.XTickStyles.(DuplicateTicks+InsideTicks)
          ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.(GridLines+OverlayGrid+NoLabels)
          ∆wizard.SetChartOption id'SetXTickMarks'xtick
          ∆wizard.SetChartOption id'YTickStyle'Causeway.YTickStyles.(DuplicateTicks+InsideTicks)
          ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.(GridLines+OverlayGrid+NoLabels)
          ∆wizard.SetChartOption id'SetYTickMarks'ytick
          ∆wizard.SetChartOption id'SetZTickMarks'ztick
          ∆wizard.SetChartOption id'ContourPlotStyle'Causeway.ContourPlotStyles.(NoTags+FrameAxes+AltitudeShading+Fine+Curves)
          ∆wizard.SetChartOption id'SetContourStyle'(System.Drawing.Color.Maroon Causeway.LineStyle.Solid 0.8)⍝ Causeway.LineStyle.Invisible 0.01)  ⍝!!! todo doesn't work
          ∆wizard.SetChartOption id'Flexibility'flex
          ∆wizard.SetChartOption id'MeshDensity'dens
          ∆wizard.Refresh 1
        ∇

        ∇ {∆wizard}←Splash2 ∆wizard;id
          ∆wizard.Refresh 0
          ∆wizard.SetGlobalOption'SetBackground'(System.Drawing.Color.Black Causeway.FillStyle.Sunrise 0)
          id←∆wizard.AddCharts'Line'
          ∆wizard.SetChartOption id'Gutter' 0
          ∆wizard.SetChartOption id'SetMargins'(0 0 0 0)
          ∆wizard.SetChartOption id'SetLineStyles'(,Causeway.LineStyle.Invisible)
          ∆wizard.SetChartOption id'SetPenWidths'(,0)
          ∆wizard.SetChartOption id'SetGridLineStyle'(System.Drawing.Color.(FromArgb 128 192 192 192)Causeway.LineStyle.Solid 0.18)
          ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.(GridLines+NoAxis)
          ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.(GridLines+NoAxis)
          ∆wizard.SetSeries id'Y'('⍳10')
          id←∆wizard.AddCharts'Tower'
          ∆wizard.SetChartOption id'NewFrame'(0 0 432 324)  ⍝ to reset gutter
          ∆wizard.SetChartOption id'Gutter' 10
          ∆wizard.SetChartOption id'SetMargins'(0 0 0 0)
          ∆wizard.SetChartOption id'Heading' 'Sharp'
          ∆wizard.SetChartOption id'HeadingStyle'Causeway.HeadingStyles.(Left+RuledBelow)
          ∆wizard.SetChartOption id'SetHeadingFont'('Arial' 40 System.Drawing.FontStyle.Regular System.Drawing.Color.White)
          ∆wizard.SetChartOption id'Footnote' 'Plot'
          ∆wizard.SetChartOption id'FootnoteStyle'Causeway.FootnoteStyles.(Right+RuledAbove)
          ∆wizard.SetChartOption id'SetFootnoteFont'('Arial' 40 System.Drawing.FontStyle.Regular System.Drawing.Color.White)
          ∆wizard.SetChartOption id'Perspective' 8
          ∆wizard.SetChartOption id'SetEdgeStyle'(System.Drawing.Color.Black Causeway.LineStyle.Solid 0)
          ∆wizard.SetChartOption id'TowerAspect' 1.5
          ∆wizard.SetChartOption id'Gap' 0.5
          ∆wizard.SetChartOption id'TowerChartStyle'Causeway.TowerChartStyles.NoAxes
          ∆wizard.SetChartOption id'SetColors'System.Drawing.Color.(FromArgb¨(255 244 216 11)(255 0 255 0)(255 0 192 192)(255 0 0 255)(255 128 0 128)(255 192 0 0))
          ∆wizard.SetChartOption id'SetTowerFillStyles'Causeway.FillStyle.(GradientTopRight GradientTop Solid)
          ∆wizard.SetChartOption id'SetViewpoint'(7 27 7)
          ∆wizard.SetSeries id'Values' '↓500++⍀+\¯30+?6 12⍴100'
          id←∆wizard.AddCharts'Line'
          ∆wizard.SetChartOption id'NewFrame'(0 0 432 324)  ⍝ to reset gutter
          ∆wizard.SetChartOption id'Gutter' 0
          ∆wizard.SetChartOption id'SetMargins'(0 0 0 0)
          ∆wizard.SetChartOption id'SetColors'System.Drawing.Color.(FromArgb¨(255 244 216 11)(255 0 255 0)(255 0 192 192)(255 0 0 255)(255 128 0 128)(255 192 0 0))
          ∆wizard.SetChartOption id'XAxisStyle'Causeway.XAxisStyles.(NoAxis)
          ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.(NoAxis)
          ∆wizard.SetSeries id'Y'('↓(?6⍴100)+[⎕IO]+\',Global.NORMALRANDOM,' 6 500')
          ∆wizard.Refresh 1
         
        ∇

        ∇ {∆wizard}←APITutorial;id
          ⍝ A walk around the Chart Wizard API
          ((1+⎕LC)↓⍳100)⎕STOP⊃⎕SI
          ⍝ Build wizard with some expression argument:
          ∆wizard←##.RunWizard'⍳3'      ⍝ equivalent to:      ]∆wizard←chart ⍳3
          ⍝ The result is an instance of the ChartWizard.Wizard class,
          ⍝ which allows you to manipulate the state of the current charts.
          ⍝ Get current chart types:
          ⎕←∆wizard.GetChartType¨∆wizard.GetChartIds
          ⍝ Remove them:
          ∆wizard.RemoveCharts ∆wizard.GetChartIds
          ⍝ Add a scatter charts - get a chart id for it:
          ⎕←id←∆wizard.AddCharts'Scatter'
          ⍝ Get series names for it:
          ⎕←∆wizard.GetSeries'Scatter'
          ⍝ Set series - can either be specified as an APL expression (string), or as an array.
          ∆wizard.SetSeries id'X'(?10⍴10)       ⍝ notice that the once-computed array will be used as argument
          ∆wizard.SetSeries id'Y' '?2 10⍴10'    ⍝ notice that the expression will be re-evaluated every time the chart is updated, and that it will appear in the script
          ⍝ Show available global page options:
          ⎕←∆wizard.GetGlobalOptions
          ⍝ Options are named by their SharpPlot API entry (property or method) rather than by what's displayed in the GUI, so that you can refer to the SharpPlot help when using the chart wizard API.
          ⍝ Options arguments are arrays (NOT expressions) that can be passed to the corresponding SharpPlot API entry
          ⍝ For example "Page Size" in Global Page Options, actually maps to the SharpPlot.Reset function - you can see that by right-clicking on its GUI control title to pop up related help
          ∆wizard.SetGlobalOption'Reset'(400 400)   ⍝ Reset method take two numeric arguments
          ⍝ Full overloads have to be used all the time (except for TickMarks)
          ⍝ For example here you can not just call SetBackground(Color fillColor), you have to call the full SetBackground(Color fillColor,FillStyle fillStyle,double edgeWidth)
          ∆wizard.SetGlobalOption'SetBackground'(System.Drawing.Color.LightYellow Causeway.FillStyle.Solid 1)
          ⍝ Same things apply to chat options.
          ⍝ Show available chart options for Chart1
          ⎕←∆wizard.GetChartOptions id
          ∆wizard.SetChartOption id'Heading' 'Hello scatter plot'                    ⍝ Heading property gets a string
          ∆wizard.SetChartOption id'YAxisStyle'Causeway.YAxisStyles.(BalancedAxis+DuplicateAxes+GridLines)   ⍝ YAxisStyle property gets a Causeway.YAxisStyles flag enumeration
          ∆wizard.SetChartOption id'SetXRange'(0 10)                                 ⍝ SetXRange method takes two numeric arguments
          ⍝ The chart wizard is quite picky about the argument structure, just to be sure that irrelevant values do not get passed around.
          ⍝ For example, single method arguments are not expected to be enclosed, and scalars will not be tolerated when vectors are expected
          ∆wizard.SetChartOption id'SetKeyText'(,⊂'First Series' 'Second Series')    ⍝ enclosed will not work
          ∆wizard.SetChartOption id'SetKeyText'('First Series' 'Second Series')      ⍝ need to pass the single vector as is
          ∆wizard.SetChartOption id'SetColors'(System.Drawing.Color.Green)           ⍝ scalar will not work
          ∆wizard.SetChartOption id'SetColors'(,System.Drawing.Color.Green)          ⍝ need to pass a vector
          ⍝ TickMarks is the one exceptions where several overloads can be used,
          ⍝ and for custom tickmarks, where a vector is passed as a single argument, it DOES need to be enclosed
          ∆wizard.SetChartOption'Chart1' 'SetXTickMarks'(5)                  ⍝ SetXTickMarks(double major)
          ∆wizard.SetChartOption'Chart1' 'SetXTickMarks'(5 4)                ⍝ SetXTickMarks(double major, int minor)
          ∆wizard.SetChartOption'Chart1' 'SetXTickMarks'(0 1 3 5 7 9 10)     ⍝ will not work - need to enclose it into a 1-item vector
          ∆wizard.SetChartOption'Chart1' 'SetXTickMarks'(,⊂0 1 3 5 7 9 10)   ⍝ SetXTickMarks(double[] tickplacements)
          ⍝ Save as a session
          ∆wizard.SaveSession'chartwizardtutorial.dcf'
          ⍝ Reset wizard
          ∆wizard.Reset
          ⍝ Load the session - see if everything comes back correctly
          ∆wizard.LoadSession'chartwizardtutorial.dcf'
          ⍝ Get the Causeway.SharpPlot instance and display it
          (⎕NEW Causeway.SharpPlotViewer ∆wizard.GetSharpPlot).Show ⍬
          ⍝ Get the APL text script
          ⎕←↑∆wizard.GetScript
          ⍝ Last thing: You can prevent the wizard from refreshing its output (saving a lot of performance)
          ∆wizard.Refresh 0
          ∆wizard.SetChartOption id'Heading' 'New Heading'
          ⍝ You'll see it happen when you run the next line:
          ∆wizard.Refresh 1
         
         
          ⍝ That's all, folks !
          ⍬ ⎕STOP⊃⎕SI
        ∇


    :EndNamespace

    :EndSection





⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section Main_thin_wrapper ⍝ maintaining global references in ⎕SE.Dyalog.Chart
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Namespace Global
        (⎕IO ⎕ML ⎕WX)←1 1 3  ⍝!!! Mantis 10862
        ⍝ cannot share ∆CHARTWIZARDS here because Spice/UCMD doesn't keep a ref to imported scripts
        ∇ ∆ns←GetRoot
          :If 0=⎕NC'⎕SE.Dyalog.Chart'
              :If 0=⎕NC'⎕SE.Dyalog'
                  '⎕SE.Dyalog'⎕NS''
              :EndIf
              '⎕SE.Dyalog.Chart'⎕NS''
          :EndIf
          ∆ns←⎕SE.Dyalog.Chart
        ∇
        ⍝ NORMALRANDOM←'{⍺←0 ⋄ ⎕IO ⎕RL d←1 ⍺ 1E9 ⋄ x y←(?2⍴⊂⍵⍴d)÷d ⋄ (.5*⍨-2×⍟x)×1○○2×y}'
        ⍝ NORMALRANDOM←(⍕⎕THIS),'.NormalRandom
        ∇ fnexpr←NORMALRANDOM;∆global
          ∆global←GetRoot
          :If 0=∆global.⎕NC'NormalRandom'
              ∆global.⎕FX ⎕THIS.⎕VR'NormalRandom'
          :EndIf
          fnexpr←(⍕∆global),'.NormalRandom'
        ∇
        ∇ r←{rl}NormalRandom shape;x;y;depth;⎕RL;⎕IO
        ⍝ distribution ← average + standard_deviation × NormalRandom (shape)
          :Access Public Shared
          :If 0≠⎕NC'rl' ⋄ ⎕RL←rl ⋄ :Else ⋄ ⎕RL←0 ⋄ :EndIf
          ⎕IO←1 ⋄ depth←1000000000                       ⍝ randomness depth
          (x y)←⊂[1+⍳⍴,shape](?(2,shape)⍴depth)÷depth    ⍝ two random variables within ]0;1]
          r←((-2×⍟x)*0.5)×1○○2×y                         ⍝ Box-Muller distribution
        ∇
    :EndNamespace

    ⍝ even thinner wrapping at root namespace level
    ∇ {∆wizard}←NewWizard ∆parent;⎕WX;∆main;∆class;∆ns
      :If ~Util.CheckVersions ⋄ ∆wizard←⎕NULL ⋄ :Return ⋄ :EndIf
      ⍝ ∆class←(∆ns←∆parent.⎕NS'').⎕FIX ⎕SRC ⎕THIS  ⍝ hide copy of this script in unnamed namespace in parent namespace
      ⍝ ∆main←∆parent.⎕NEW ∆class.Main ∆parent  ⍝ ⎕NEW Main
      ⍝ ∆main.∆HACK1←∆class  ⍝ keep pointer to class
      ⍝ ∆main.∆HACK2←∆ns     ⍝ keep pointer to unnamed namespace
      ∆main←∆parent.⎕NEW Main ∆parent
      ∆wizard←∆main.GetWizard
      ⍝ ∆wizard.∆MAIN←∆main  ⍝ save a handle for 1400⌶0 - doesn't work because ∆main is parent of ∆wizard
      ⍝ Gui.Focus ∆wizard
    ∇

    ∇ {∆wizard}←{∆parent}RunWizard expr;id;input;N;S;num;mask;first;mix;rows;cols;labs;ord;shape;vec;mat
      :If 0=⎕NC'∆parent' ⋄ ∆parent←⊃⎕RSI ⋄ :EndIf  ⍝ calling namespace by default
      :If ⎕NULL≢∆wizard←NewWizard ∆parent
          ⍝ ∆wizard ∆wizard.##.∆HACK1.Magic.Run expr
          ∆wizard Magic.Run expr
          ⍝ Gui.Focus ∆wizard
      :EndIf
    ∇

    :EndSection



⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section UCMD_interface
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝

    ∇ r←List
      :Access Public Shared  ⍝ UCMD API
      r←⎕NS¨⍬ ⍬ ⍬
      r[1].Name←'Chart'
      r[1].Desc←'Run the chart wizard on argument APL expression'
      r[1].Group←'Tools'
      r[1].Parse←''
      r[2].Name←'ChartSession'
      r[2].Desc←'Run the chart wizard from a saved session file'
      r[2].Group←'Tools'
      r[2].Parse←''
      r[3].Name←'ChartViewer'
      r[3].Desc←'Run the chart viewer on a SharpPlot object'
      r[3].Group←'Tools'
      r[3].Parse←''
      r←r[,1]  ⍝ disable the last two for now
    ∇

    ∇ r←Run(Cmd Args);version;required;∆wizard;ok
      :Access Public Shared  ⍝ UCMD API
      :Select Cmd
      :Case 'Chart'
          :If ⎕NULL≢r←∆wizard←##.THIS RunWizard Args
              ∆wizard.∆SPICE←##  ⍝ remember spice namespace where class resides for 1400⌶0
          :EndIf
          :If ~##.RIU ⋄ r←0 0⍴0 ⋄ :EndIf  ⍝ emulate shy result
      :Case 'ChartSession'
          :If ⎕NULL≢r←∆wizard←NewWizard ##.THIS
              ∆wizard.∆SPICE←##  ⍝ remember spice namespace where class resides for 1400⌶0
              ∆wizard.LoadSession Util.RemoveBlanks Args
          :EndIf
          :If ~##.RIU ⋄ r←0 0⍴0 ⋄ :EndIf  ⍝ emulate shy result
      :Case 'ChartViewer'    ⍝ would have been useful when Causeway.SharpPlotViewer was crap (before v3.50) and RasterViewer was superior
          :Trap 0 ⋄ ok←Causeway.SharpPlot≡⎕CLASS ##.THIS 0 Util.Run Args ⋄ :Else ⋄ ok←0 ⋄ :EndTrap
          :If ok
              r←##.THIS.⎕NEW RasterViewer ⍬
              r.SetSharpPlot Args
              r.∆SPICE←##  ⍝ remember spice namespace where class resides for 1400⌶0
              :If ~##.RIU    ⍝ emulate shy result
                  ⍝ Util.PutRef r ##.THIS'⍙CHARTVIEWER⍙'  ⍝ put name ref in calling namespace to prevent it from being garbage-collected
                  Util.PutRef r Global.GetRoot'⍙CHARTVIEWER⍙'  ⍝ put name ref in ⎕SE to prevent it from being garbage-collected
                  ⍝ TODO : Closing the chart viewer should delete that variable
                  r←0 0⍴0
              :EndIf
          :Else
              r←'Error - Argument is not a Causeway.SharpPlot object'
          :EndIf
      :Else
          r←'Unexpected command:',(,⍕Cmd),' ',(,⍕Args)
      :EndSelect
    ∇

    ∇ r←Help Cmd
      :Access Public Shared  ⍝ UCMD API
      :Select Cmd
      :Case 'Chart'
          r←'Run the chart wizard on argument APL expression'
      :Case 'ChartSession'
          r←'Run the chart wizard from saved session file'
      :Case 'ChartViewer'
          r←'Run the chart previwer on a SharpPlot instance'
      :Else
          r←'Unexpected command:',(,⍕Cmd)
      :EndSelect
    ∇

    :EndSection





⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
    :Section Installation
⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝


    ∇ src←DoChart
      :Access Public Shared
      src←⊂'DoChart msg;⎕IO;⎕ML;curobj;name'
      src,←⊂'⍝ Callback on Chart intended to replace ⎕SE.Chart.DoChart,'
      src,←⊂'⍝ which is the callback to ⎕SE.cbtop.bandtb2.tb.(bar lin pie sca).onSelect'
      src,←⊂'⍝ and ⎕SE.popup.chart.(bar lin pie sca).onSelect'
      src,←⊂'⍝ Relies on the ]chart user command to be available'
      src,←⊂'⎕IO←1 ⋄ ⎕ML←1'
      src,←⊂'curobj←''⎕SE.cbbot.bandsb2.sb.curobj'''
      src,←⊂':Trap 0 ⋄  name←curobj ⎕WG''Text'' ⋄ :Else ⋄  ⎕←''Cannot read data from '',curobj ⋄ :Return ⋄ :EndTrap '
      src,←⊂'name←((¯1+name⍳''('')↑name)~'' '''
      src,←⊂'{}(⊃⎕RSI)⎕SE.UCMD '']chart '',name'
    ∇

    ∇ InstallCallbacks;tb;btns;∆global
      :Access Public Shared
      :If '15.0'Util.CompareVersions⊃Util.GetDyalogVersion
          ∆global←Global.GetRoot
          :If 'DoChart'≢∆global.⎕FX DoChart        ⍝ Override ⎕SE.Chart.DoChart
              ⎕←'Couldn''t override ',(⍕∆global),'.DoChart'
          :Else
              ⎕←'Overriden ',(⍕∆global),'.DoChart'
          :EndIf
      :Else  ⍝ v12.0 → v14.2 : ⎕SE.Chart.DoChart is the unique chart button callback (see buildse.dws)
          :If 9≠⎕NC'⎕SE.Chart'
          :OrIf 'DoChart'≢⎕SE.Chart.⎕FX DoChart        ⍝ Override ⎕SE.Chart.DoChart
              ⎕←'Couldn''t override ⎕SE.Chart.DoChart'
          :Else
              ⎕←'Overriden ⎕SE.Chart.DoChart'
          :EndIf
      :EndIf
    ∇

    ∇ InstallScript salt;path;txt;file;tie;msg;r
      :Access Public Shared
      :If Util.DEBUG
          Gui.Error'ChartWizard.Util.DEBUG needs to be 0 in a release'
          :Return
      :EndIf
      txt←⎕SRC ⎕THIS                      ⍝ get source
      ⍝txt←{(∧\⍵≠'⍝')/⍵}¨txt              ⍝ remove comments
      ⍝txt←({⍵∨.≠' '}¨txt)/txt            ⍝ remove empty lines
      txt←Util.UnNestText txt             ⍝ un-nest
      txt←⎕UCS'UTF-8'⎕UCS txt             ⍝ encode as utf-8
      :If salt
          path←Util.GetSpicePath
      :Else
          path←'..\release'               ⍝ release directory
      :EndIf
      file←path,'\chartwizard.dyalog'     ⍝ target file for user command
      :If 0≠tie←Util.FileTie file 3 0
          txt ⎕NAPPEND tie
          ⎕NUNTIE tie
          Gui.Info'Written class to ',file
      :EndIf
    ∇

    ∇ Install     ⍝ install into spice and IDE
      :Access Public Shared
      InstallScript 1
      InstallCallbacks
    ∇

    ∇ Release     ⍝ produce a releasable script
      :Access Public Shared
      ⎕←'      ]settings cmddir ,[salt]/lib '
      ⎕←'      ]scanforclassic'
      InstallScript 0
      InstallScript 1
    ∇

    :EndSection





:EndNamespace  ⍝ end of story