﻿:Namespace Config ⍝ V2.01
⍝ Display value of configuration parameters (optionally with origin)
⍝ 2020 05 21 Adam: Placed in EXPERIMENTAL group
⍝ 2020 05 22 Adam: Cleanup
⍝ 2020 06 02 Adam: Make -origin=long to =full and default of -long=wrap
⍝ 2021 03 24 Adam: Make non-experimental
⍝ 2021 08 09 Adam: [19254] Change documentation to -origin=full

    ⎕IO←1 ⋄ ⎕ML←1
    DESC←2↓2⊃⎕SRC ⎕THIS

    ∇ r←List
      r←⎕NS ⍬
      r.Name←'Config'
      r.Group←'Tools'
      r.Desc←DESC
      r.Parse←'99S -origin[=]full short -long[=]wrap cut'
    ∇

      Help←{
          r←DESC('    ]',⍵,' [<params>] [-origin[=full|short]] [-long[=wrap|cut]]')
          0=⍺:r
          r,←⊂''
          r,←⊂'Argument:    configuration parameter(s) (omit to list all)'
          r,←⊂''
          r,←⊂'Modifiers:'
          r,←⊂''
          r,←⊂'-origin=     include source for value (omitted by default)'
          r,←⊂'    "full"   entire paths (default when only -origin is specified)'
          r,←⊂'    "short"  abbreviations and no paths'
          r,←⊂''
          r,←⊂'-long=       fit long values to screen width (left as-is by default)'
          r,←⊂'    "wrap"   fold over multiple lines (default when only -long is specified)'
          r,←⊂'    "cut"    truncate to screen width'
          r,←⊂''
          r,←⊂'Example:'
          r,←⊂'      ]',⍵,' dyalog  ⍝ display all configuration parameters'
          r,⊂2 ⎕NQ #'GetEnvironment' 'DYALOG'
      }

    ∇ r←Run(cmd input);origin;Long;pw
      origin←3|'short' 1 0⍳⊂input.(1⊣⍣('full'≡origin)⊢origin) ⍝ 1≡long; default:none
     
      r←origin ⎕SE.Dyalog.Utils.Config{0=≢⍵:⍬ ⋄ ⍵}input.Arguments ⍝ no-args: all
      :If 0≢input.long
          pw←⎕PW-+/⌈⌿0 ¯1↓≢¨r ⍝ combined width of all but last col
          :If 2=⎕NC'⎕SE.Dyalog.Out.B.state' ⍝ ]Box
          :AndIf 'on'≡⎕SE.Dyalog.Out.B.state
              pw-←(3*'max'≡⎕SE.Dyalog.Out.B.style)×1+⊃⌽⍴r ⍝ Box adds 1 or 3 cols plus 1 or 3 cols per col
          :Else
              pw-←2×⊃⌽⍴r ⍝ raw display adds 2 cols per col
          :EndIf
          ('screen too narrow',' (try -origin=short)'/⍨'full' 1∊⍨⊂input.origin)⎕SIGNAL 11⍴⍨3≥pw
     
          :If 'cut'≡input.long ⍝ Select post-processor
              Long←{
                  ⍺≥≢⍵:⍵
                  ellip←⎕UCS(3⍴46)8230⊃⍨3|⎕DR'' ⍝ Classi/Unicode "..."
                  ellip,⍨⍵↑⍨⍺-≢ellip
              }
          :ElseIf 0≢input.long
              Long←(⌈÷⍨∘≢,⊣)⍴⊢,''⍴⍨¯1+⊣
          :Else
              Long←⊢
          :EndIf
          r←⍉⊖pw Long¨@1⊖⍉r
      :EndIf
    ∇
:EndNamespace
