﻿:Namespace format ⍝ V1.30
⍝ Format text vector for std output
⍝ 2015 10 27 Adam: Renamed class
⍝ 2015 11 12 Adam: moved help layout to framework
⍝ 2017 05 26 Adam: typo
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -??
⍝ 2018 05 01 Adam: add SVN tag, help tweaks
⍝ 2019 01 24 Adam: help
    ⎕IO←1 ⋄ ⎕ML←1
    DESC←'Format text into vector of text vectors (or matrix if called from Session) to fit ⎕PW using '∘,¨'specified margins' 'margins inferred from the text'

    ∇ r←List
      r←⎕NS¨⍬ ⍬
   ⍝ Name, group, short description and parsing rules
      r.Name←'Format' 'Layout'
      r.Group←⊂'Output'
      r.Desc←DESC
      r.Parse←'1L -left=  -right=  -first= ' '1L'
    ∇

    ∇ r←level Help Cmd;⎕ML;call;rm;A;B;C;D;E
      ⎕ML←1
      :Select Cmd
      :Case 'Format'
          r←⊣/DESC
          r,←⊂'    ]',Cmd,' <text> [-first=<f>] [-left=<l>] [-right=<r>]'
          r,←⊂''
          :If 0=level
              r,←⊂']',Cmd,' -??  ⍝ for more information'
              r,←⊂']',Cmd,' -??? ⍝ for examples'
          :ElseIf level=1
              r,←⊂'<text>  text to be formatted. Must be an expression evaluating to a:'
              r,←⊂'    simple vector      will be formatted a single paragraph'
              r,←⊂'    vector of vectors  each vector will be formatted as a separate paragraph'
              r,←⊂'    matrix             each row will be formatted as a separate paragraph'
              r,←⊂''
              r,←⊂'-first=<f>  first line''s indent from the left margin. Can be positive or negative. Must be one of:'
              r,←⊂'    integer        the width of this many characters'
              r,←⊂'    ¯1<fraction<1  a fraction of the current screen width (⎕PW)'
              r,←'' '-left=<l> -right=<r>  left and right margins for the body text. If specified, must be one of:'
              r,←⊂'    integer≥0     the width of this many characters'
              r,←⊂'    0<fraction<1  a fraction of the current screen width (⎕PW)'
              r,←⊂''
              r,←⊂']',Cmd,' -??? ⍝ for examples'
          :Else
              r,←⊂'Examples:'
              r,←⊂'    Current user''s name beginning a quarter of the way across the Session:'
              call←⊃r,←⊂'        ]',Cmd,' ⎕AN -l=.25'
              r,←⎕SE.UCMD call
              r,←⊂''
              rm←⍕⎕PW-30 
              r,←⊢⊢⊂'    Four-character hanging indent with a right margin of ',rm,' characters:'
              ⍎⊃r,←⊢⊂'        A←''I wandered lonely as a cloud'''
              ⍎⊃r,←⊢⊂'        B←''That floats on high o''''er vales and hills,'''
              ⍎⊃r,←⊢⊂'        C←''When all at once I saw a crowd,'''
              ⍎⊃r,←⊢⊂'        D←''A host, of golden daffodils;'''
              call←⊃r,←⊂'        ]Format A B C D -first=¯4 -left=4 -right=',rm
              r,←⎕SE.UCMD call
⍝              r,←⊢⊢⊂'    Indent first line 4 spaces and have a right margin of ',(⍕rm),' characters:'
⍝             ⍎⊃r,←⊂'        E←''Mary had a little lamb, His fleece was white as snow.'''
⍝              call←⊃⊢'        ]',Cmd,' E -f=4 -r=',rm
              r,←⊂''
              r,←⊂']',Cmd,' -?? ⍝ for details'
          :EndIf
      :Case 'Layout'
          r←⊢/DESC
          r,←⊂'    ',Cmd,' <text>'
          r,←⊂''
          :If 0=level
              r,←⊂']',Cmd,' -?? ⍝ for more information and examples'
          :Else ⍝ 1≤level
              r,←⊂'<text>  an expression evaluating to a vector, a vector of vectors or a matrix, which provides both content and layout pattern:'
              r,←⊂'        ∘  Leading spaces indicate left margin'
              r,←⊂'        ∘  First instance of internal multiple spaces indicates hanging body text'
              r,←⊢'        ∘  Trailing spaces indicate right margin' ''
              r,←⊂'Example:'
              r,←⊂'        lorem←''   Lorem ipsum:  Dolor sit amet, consectetuer adipiscing elit.'''
              r,←⊂'        ⎕PW←42'
              r,←⊂'        ]',Cmd,' lorem'
              r,←⊂'   Lorem ipsum:  Dolor sit amet,        '
              r,←⊂'                 consectetuer adipiscing'
              r,←⊂'                 elit.                  '
          :EndIf
      :EndSelect
    ∇

    ∇ r←Run(Cmd Input);text;vals
      text←##.THIS⍎⊃Input.Arguments
      :Select Cmd
      :Case 'Format'
          vals←∊0 Input.Switch¨'left' 'right' 'first'
          r←vals ⎕SE.Dyalog.Utils.formatText text
      :Case 'Layout'
          r←⎕SE.Dyalog.Utils.layoutText text
      :EndSelect
      r←↑⍣(~##.RIU)⊢r
    ∇

:EndNamespace ⍝ format  $Revision$
