﻿:Namespace it ⍝ v1.2
⍝ User commands for opening Inline Tracing value windows
⍝ 2025 07 09 Adam: Add Descriptions
⍝ 2025 08 13 Adam: [22471] Fix index error

    cmds←'Left' 'Right' 'Axis' 'Function' 'PLeft' 'PRight' 'Result' 'PAxis' 'PFunction'
    names←(
    'Left Argument'
    'Right Argument'
    'Axis Specification'
    'Current Function'
    'Previous Left'
    'Previous Right'
    'Previous Result'
    'Previous Axis'
    'Previous Function'
    )
    ∇ r←List
      r←cmds{(
              Group:'IT'
              Desc:'Open ',⍵,' window for inline tracing'
              Name:⍺
              Parse:'0 -aplan'
          )}¨names
    ∇
    ∇ Run(cmd args)
      cmd(2405⌶)⍨1+args.aplan
    ∇
    ∇ r←level Help cmd
      r←,⊂List[cmds⍳⊂cmd].Desc
      r,←⊂'    ]',cmd,'         ⍝ view/edit Inline Tracing ',cmd
      r,←⊂'    ]',cmd,' -aplan  ⍝ ditto, but using array notation'
    ∇
:EndNamespace
