﻿:Namespace Open ⍝ V3.41
⍝ Open a file under Windows
⍝ 2015 11 12 Adam: added version number
⍝ 2015 12 30 Adam: added Test
⍝ 2017 03 08 Adam: disable on non-Win
⍝ 2017 03 21 Adam: Try non-.Net
⍝ 2017 05 26 Adam: uppercase ]open→]Open, help overhaul
⍝ 2018 04 19 Adam: Move to FILE and enable on Linux and macOS
⍝ 2018 04 19 Adam: help text tweak, add ]Help
⍝ 2018 04 20 Adam: use local list for ]Help, add built-ins and ucmds and error msgs
⍝ 2018 04 24 Adam: more ]help examples
⍝ 2018 05 01 Adam: add SVN tag
⍝ 2018 06 19 Adam: Help.csv→help.csv
⍝ 2018 07 30 Adam: Fix ]open -using
⍝ 2018 08 08 Adam: Add error number support, fix handling of iRetVal
⍝ 2018 08 22 Adam: Fix ]help errmsg
⍝ 2018 10 15 Adam: Disable ]help on Classic
⍝ 2018 02 04 Adam: Help, enable ]help ]ucmd
⍝ 2019 02 14 Andy: Replace http with https
⍝ 2019 08 06 Adam: Add i-beams
⍝ 2019 12 30 Adam: Adapt to new UI API
⍝ 2021 02 18 Adam: ⎕C
⍝ 2021 08 15 Adam: Add ]help -p= and avoid layout if result is used
⍝ 2021 08 24 Adam: [19282] Update help for ]Help to include -page=
⍝ 2022 01 12 Adam: Handle ]help 35 and 56
⍝ 2025 06 30 Adam: Use 911⌶ 
⍝ 2025 07 01 Adam: Handle naked ]help

    ⎕IO←1 ⋄ ⎕ML←1

    If←/⍨

    ∇ r←List
      r←⎕NS¨⍬ ⍬
   ⍝ Name, group, short description and parsing rules
      r[1].(Name Group Desc Parse)←'Open' 'File' 'Open a file or directory with the specified application' '1SL -using='
      r[2].(Name Group Desc Parse)←'Help' 'Tools' 'Browse or get link to information about any APL concept' '1SL -url -page∊0123456789'
      r If←'AIX'≢3↑⊃⎕SE.SALTUtils.APLV
    ∇

    ∇ r←Run(Cmd Input)
      r←⊃Input.Arguments
      :If Cmd≡'Help' ⍝ Do not change to :Select because ]Help might want ]Open to run later
          :If ×≢Input
              r←(1⌈0 Input.Switch'page')HelpUrl r
              :If ~Input.url
                  :If ']'=⊃r
                      r←Layout⍣(~##.RIU)⎕SE.UCMD 1↓r
                  :Else
                      '-page is only supported for help on user commands'⎕SIGNAL 11/⍨0≢Input.page
                      Cmd←'Open' ⍝ Proceed with ]Open
                  :EndIf
              :EndIf
          :Else
              r←Layout ⎕SE.SALTUtils.UCMDGeneralHELP
          :EndIf
      :EndIf
      :If Cmd≡'Open'
          :Select 3↑⊃⎕SE.SALTUtils.APLV
          :Case 'Win'
              r←r WinOpenWith Input.Switch'using'
          :Case 'Mac'
              r XOpenWith'open'Input.Switch'using'
          :Case 'Lin'
              r XOpenWith'xdg-open'Input.Switch'using'
          :Else
              r←'** This command is not supported on ',⊃⎕SE.SALTUtils.APLV
          :EndSelect
      :EndIf
    ∇

    Layout←{↑∘⎕SE.Dyalog.Utils.layoutText⍣(~##.RIU)⊢⍵}

    ∇ r←level Help Cmd
      :Select Cmd
      :Case 'Open'
          r←,⊂'Open a file or directory with the specified application'
          r,←⊂'    ]',Cmd,' [<target>] [-using=<app>]'
          :If level>0
              r,←⊂''
              r,←⊂'<target>      The file or directory to be opened. If not specified, then a file selection dialog box will be opened on Windows. The current directory will be used on all other platforms.'
              r,←⊂'-using=<app>  The application that should be used to open <target>'
              r,←'' 'Examples:'
              r,←'    To browse the current directory (Linux/macOS) or open a file selection dialog box (Windows):'('        ]',Cmd)
              r,←'    To open or browse "mytarget":'('        ]',Cmd,' mytarget')
              r,←'    To open or browse "mytarget" with the program "myapp":'('        ]',Cmd,' mytarget -using=myapp')
          :Else
              r,←''(']',Cmd,' -?? ⍝ for more information and examples')
          :EndIf
      ⍝r,←⊂'-permanent     remember the program to use in the future'
      :Case 'Help'
          r←⊂'Browse or get link to information about any APL concept.'
          r,←⊂'    ]',Cmd,' [<concept>] [-page=<p>]'
          r,←⊂''
          r,←⊂'<concept>  the subject for which help is to be given. Supported concepts are:'
          r,←'  ∘  '∘,¨'Symbols for primitive functions and operators, e.g. "*" or "⍣"' 'I-beams, e.g. "1200⌶"' 'Control structures and syntactic symbols, e.g. ":for" and "{"'
          r,←'  ∘  '∘,¨'System functions, operators, variables, and constants, e.g. "⎕ninfo" or "⎕a"' 'System and user commands, e.g. ")clear" or "]box"'
          r,←'  ∘  '∘,¨'GUI objects, properties, methods, and events, e.g. "form" or "select"' 'Error messages and numbers, e.g. "rank error" or "11"'
          r,←'Unrecognised concepts will be searched for as free text in the help system.' ''
          r,←⊂''
          r,←⊂'-page=<p>  display page <p> of the help text (only applicable when <subject> is a user command)'
          r,←'' 'Examples:'
          r,←⊂'    ]',Cmd,'              ⍝ opens browser on help front page'
          r,←⊂'    ]',Cmd,'  ⎕csv        ⍝ opens browser on the ⎕CSV system function page'
          r,←⊂'    ]',Cmd,'  ⌹  -url     ⍝ gives link to Domino page'
          r,←⊂'    ]',Cmd,'  form        ⍝ opens browser on GUI Form page'
          r,←⊂'    ]',Cmd,'  ]save -p=2  ⍝ displays help for the ]Save user command'
          r,←⊂'    ]',Cmd,'  ws full     ⍝ opens browser on page about insufficient space'
          r,←'' 'To get general user command help, enter:' '    ]'
      :EndSelect
    ∇

    Fmt←' ' '/[-\w]+/\.\.'⎕R'\%20' ''⍣≡ ⍝ replace spaces and collapse "/.."s


      HelpUrl←{
          Ask←1∘(911⌶)
          ' '∧.=⍵:Fmt'?' Ask⍛,'../../../'
          url←Ask ⍵
          ''≢url:url
     
          (terms subst urls)←⎕CSV⍠2⍠'Separator'(⎕UCS 9)⊢'/spice/help.csv',⍨⎕SE.SALTUtils.getEnvir'SALT'
          term←⊂¯1 ⎕C ⍵
          term∊terms:Fmt(Ask⍤⊃∘subst,⊃∘urls)terms⍳term   ⍝ built-ins
          ⍺←1
          (']'=⊃⍵)∨(term∊##.##.List[;2]):']',(⍵~']-?'),' -',⍺⍴'?' ⍝ user commands
          ens←⍸~(⊃∘⌽¨⎕EM⍳1010)∊⎕D,' '
          en←⊃⊃⌽⎕VFI⍕⊃term
          en∊ens:Fmt'?'Ask⍛,'../../../programming-reference-guide/error-messages/','-'@(' '∘=)⎕C ⎕EM en ⍝ error numbers
          em←1 ⎕C term
          em∊⎕EM ens:Fmt'?'Ask⍛,'../../../programming-reference-guide/error-messages/','-'@(' '∘=)⊃term ⍝ error messages
          Fmt'?'Ask⍛,'../../../?q=',⍵         ⍝ general search
      }

    ∇ name XOpenWith cmd ⍝ for non-Win
      cmd,←' "'
      cmd,←'file://'If~∨/'://'⍷name    ⍝ add protocol if absent
      cmd,←(~∨/'/\'∊name)/⊃1 ⎕NPARTS'' ⍝ add path if absent
      cmd,←name,'"'
      {}⎕SH cmd
    ∇

    ∇ r←{name}WinOpenWith cmd;⍙USING;ext;sel;⎕USING;fd;folder;isfile;path;Dext;SU;dir;cmd;iRetVal
      r←name
     
      :If 0≢cmd ⍝ Use .Net if we need to specify with what
          iRetVal←(⍎⎕NA'P shell32|ShellExecute* P P <0T P P I4')0 0 name 0 0 5 ⍝ Try non-.Net if we can
      :OrIf 1=0 33⍸iRetVal
     
          ⍙USING←cmd
          ext←cmd←r←⍬
          SU←⎕SE.SALTUtils
     
          :If sel←0=≢name ⍝ ask the user if a file is not supplied
              ⎕USING←'System.Windows.Forms,System.Windows.Forms.dll'
              fd←⎕NEW OpenFileDialog
              →0 If'OK'≢⍕fd.ShowDialog ⍬
              name←fd.FileName
          :EndIf
          Dext←SU.SALTEXT
     ⍝ If this is a relative path we search in the list of SALT working directories
          :If SU.isRelPath path←name
              :For folder :In {⎕ML←3 ⋄ (⍵≠'∘')⊂⍵}⎕SE.UCMD'settings workdir'
                  isfile←~SU.isDir path←folder SU.ClassFolder name
                  ext←Dext If(⍙USING≡0)∧isfile∧sel⍱'.'∊name ⍝ add extension if none supplied
                  →run If 1=⍴dir←⎕IO⊃'a'SU.Dir path,ext
              :EndFor
              'File not found'⎕SIGNAL 922
          :Else
              :If ~dir←SU.isDir name
                  ext←Dext If(⍙USING≡0)∧sel⍱'.'∊name
              :EndIf
          :EndIf  ⍝ otherwise we use it directly
     run: r←dir RunCmd path,ext ⍝ full path name case
      :EndIf
    ∇

    ∇ r←{dir}RunCmd path;⎕USING ⍝ this is only used by <Open>
      ⎕USING←'System.Diagnostics,system.dll'
      r←⍙USING{6::(⍺≡0)/⍵ ⋄ 90::⎕EXCEPTION.Message ⋄ ⍵⊣Process.Start(0≡⍺)↓⍺ ⍵}path
      r ⎕SIGNAL 922 If path≢r
    ∇

    :Section Test
    ∇ r←Test dummy;Pids;pids;pid
      Pids←{3::⍬ ⋄ 2 2∘⊃¨⎕VFI¨3↓⎕CMD'tasklist /FI "IMAGENAME eq notepad.exe"'}
      pids←Pids ⍬
      {}⎕SE.UCMD List.Name,' C:\Windows\System32\notepad.exe'
      r←1=⍴pid←pids~⍨Pids ⍬
      {}⎕CMD'taskkill /pid ',⍕pid
    ∇
    :EndSection

:EndNamespace ⍝ Open  $Revision$
