:Namespace outputspec ⍝ V2.0991
⍝ System user Command
⍝
⍝ 2015 05 21 Adam: NS header
⍝ 2016 05 29 DanB: added cmd LastResult and modified box to include a button
⍝ 2016 09 03 DanB: prevent VALERR line 7
⍝ 2016 10 28 DanB: changed SD to reflect better screen dimensions
⍝ 2017 02 21 Adam: Proper ]Box ToolButton and ]LastResult -pfkey → -button
⍝ 2017 02 22 Adam: 2 × -button → -pfkey=, ]?Box overhaul, install button at 1st call and keep it, ]?LastResult overhaul
⍝ 2017 02 23 Adam: Box added new fns and ops for 16.0 and ⎕Uhhhh, added hint and tip to button, do not check for button on non-win, help updates
⍝ 2017 03 02 Adam: disabled ]lastresult altogether and ]box -pfkey
⍝ 2017 03 06 Adam: fix missing trees
⍝ 2017 03 19 Adam: fix ]???rows
⍝ 2017 03 27 Adam: Silence ]rows
⍝ 2017 05 16 JohnS: ]box remove -chars, do not switch on when just changing settings, implement -t=def
⍝ 2017 05 26 Adam: ]???rows note about when cutting occurs
⍝ 2017 06 17 Adam: ]fn.findoutput → ]output.find
⍝ 2017 07 11 Adam: ]?display symbol legend
⍝ 2018 03 29 JohnS: ]rows: dots extend across whole window
⍝ 2018 04 04 Adam: Enable box button
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -??
⍝ 2018 04 30 JohnS: limited length of ]rows folding dots ······ to ⎕PW
⍝ 2018 05 01 Adam: help tweaks
⍝ 2019 02 04 Adam: help
⍝ 2020 04 28 Adam: [17929] Fix train trees with spaces
⍝ 2020 05 26 Adam: [9376,18007] Filter when tracing and from ]output.find; remove doubled ... when interrupted
⍝ 2020 05 27 Adam: Add Hoof (○¨)
⍝ 2020 06 01 Adam: Add SessionTrace with ns path
⍝ 2020 06 02 Adam: [18126] normalise display of LF, make V17.1 compatible, allow output.find to say [0]
⍝ 2020 06 03 Adam: Handle missing stack frame, avoid trailing spaces
⍝ 2020 06 08 Adam: Make use of ⎕PW semi-global
⍝ 2020 06 11 Adam: [18236] Fix Box button callback
⍝ 2020 07 20 Adam: trap and resignal on WS FULL after error
⍝ 2021 02 23 Adam: add box -style=non
⍝ 2021 04 26 Adam: Handle class methods
⍝ 2021 05 04 Adam: Avoid printing uncalled-for trailing spaces
⍝ 2021 05 20 Adam: Avoid printing empty line on empty output
⍝ 2021 08 12 Adam: Support simulation of (non-)suspension, and choosing to print or return "image"
⍝ 2021 08 13 Adam: Add ]box -view= like -style but for ]view
⍝ 2021 10 08 Adam: Guarantee number of elements in event msg, ensure output can be interrupted
⍝ 2021 11 05 MBaas: add ]output.find -timestamp
⍝ 2021 11 10 Adam: add ]output.find -stop, harmonise all helps and APIs, speed up DEBUG handling
⍝ 2021 11 11 Adam: [19187] delay setting ⎕PW until needed, fix missing normalisation of F. members
⍝ 2021 11 14 Adam: Handle pfkey in text form
⍝ 2021 11 15 Adam: Handle numeric find pfkey
⍝ 2021 11 16 Adam: Early out from Find if off, ensure all settings exist
⍝ 2022 02 14 Adam: [19660] Do all output at once, instead of line-by-line
⍝ 2023 10 02 Adam: Report correct previous value
⍝ 2025 01 27 Adam: Early out if Nil printing
⍝ 2025 02 03 Adam: Make resilient towards Nils
⍝ 2025 02 03 Adam: Make resilient towards ⎕ORs
⍝ 2025 03 25 Adam: Back out prev 2 and make v19.0-compat
⍝ 2025 05 12 Adam: [22190] Reinstate recognition of all operators
⍝ 2025 06 11 Adam: [22253] ignore __session_input__ on stack
⍝ 2025 06 17 Adam: [22187] Use I-beam to output as group
⍝ 2025 06 17 Adam: Full support for Behind
⍝ 2025 07 23 Adam: [22417] Ignore missing boxing button and always use ⎕←
⍝ 2025 08 26 Adam: Make sure to call 5306⌶ with vec of vecs

    ⎕io← ⎕ml←1
    OUTSpace ← '⎕se.Dyalog.Out' ⋄ Var←{0::⍵ ⋄ ⎕se.SALTUtils.LastResultVarName}⍬⊤⍬
    enableLastResult←0
    enableBoxPfkey←0

    cmds←'LastResult' 'Box' 'Boxing' 'Rows' 'Find'

    ∇ r←Nss
      r←{⎕NS''}¨cmds ⍝ space for each cmd.
      r.Name←cmds
      r.Group←⊂'Output'
     
      r[cmds⍳⊂'LastResult'].Desc←⊂'Record Last session output'
      r[cmds⍳'Box' 'Boxing'].Desc←⊂'Display output with borders indicating shape, type and structure'
      r[cmds⍳⊂'Rows'].Desc←'Cut, wrap, fold or extend the display of output lines to fit the Session window'
      r[cmds⍳⊂'Find'].Desc←'Precede output with a reference to the line of code that generated it'
     
      r[cmds⍳⊂'LastResult'].Parse←'1S  -pfkey='
      r[cmds⍳'Box' 'Boxing'].Parse←⊂'1S -style="non min mid max" -view="non min mid max" -trains="box tree parens def" -fns[=]"off on"',enableBoxPfkey/' -pfkey='
      r[cmds⍳⊂'Rows'].Parse←'1S -style="long cut wrap" -fold[=] -fns[=]"off on" -dots='
      r[cmds⍳⊂'Find'].Parse←'1S -includequadoutput[=]"off on" -stop[=]"off on" -timestamp[=]"off on"'
    ∇

    ∇ r←List ⍝ Name, group, short description and parsing rules
      r←Nss/⍨enableLastResult∨cmds≢¨⊂'LastResult'
    ∇

    {⍎⍵.Name,'Mods←''-(\w+)''⎕S''\1''⊢⍵.Parse'}¨Nss
    BoxingDefs←BoxDefs←'min' 'min' 'box' 'off',enableBoxPfkey/0
    RowsDefs←'long' 'off' 'off' '·'
    FindDefs←'off' 'off' 'off'
    LastResultDefs←,0
    allSettings←OUTSpace∘,¨⊃,/{'.'(⊃⍵)'.'∘,¨(⊂'state'),⍎⍵}¨cmds,¨⊂'Mods'

    ∇ O←{reset}Init OUTSpace;initials;refs;cmd;ref;mod;def
      :If 900⌶0
          reset←0
      :EndIf
      O←⍎OUTSpace ⎕NS'Filter' 'Box' 'Rows' 'SD' 'Dft' 'pfnops' 'flipBox' 'SetCallback' 'OUTSpace' 'timestamp' 'allSettings' 'Init' 'cmds'
      initials←⊃¨cmds
      O.⎕NS∘⍬¨initials ⍝ ensure spaces for Box, Rows, LastResult and Find exist
      refs←O⍎¨initials
      :If 0∊⎕NC allSettings
          initials←⊃¨cmds
          O.⎕NS∘⍬¨initials ⍝ ensure spaces for Box, Rows, LastResult and Find exist
          refs←O⍎¨initials
          :For cmd ref :InEach cmds refs
              :For mod def :InEach 'state' 'off',⍥⊆¨⍎¨cmd∘,¨'Mods' 'Defs'
                  :If reset∨0=ref.⎕NC mod
                      mod ref.{⍎⍺,'←⍵'}def
                  :EndIf
              :EndFor
          :EndFor
      :EndIf
    ∇
    ∇ r←Run(Cmd Input);arg;O;pfkey;i;state;mods;ref
    ⍝ Setup a space for the callback program to run. If it does exist no new space will be created.
      O←Init OUTSpace
     
      arg←⎕C⊃Input.Arguments,⊂''         ⍝ single optional argument.
      ref←O⍎i←⊃Cmd
      state←⎕C ref.state
      mods←⍎Cmd,'Mods'
      :Select arg
      :CaseList 'off' 'on'
          r←'Was ',1 ⎕C state
          ref.state←arg
      :Case ''
          :If 0∧.≡Input⍎¨mods
              r←'Is ',1 ⎕C state
          :Else
              r←'Was'
          :EndIf
      :CaseList 'reset'(,'?')
          r←Cmd Set arg
      :Else
          r←'Arguments: ON OFF RESET ?'
      :EndSelect
     
      :Select Cmd
      :CaseList 'Box' 'Boxing'
          :If 9=⎕SE.⎕NC'cbtop'
          :AndIf 9=⎕NC Button
              Button ⎕WS'State'(O.B.state≡'on')
              :If enableBoxPfkey
              :AndIf Input.pfkey≢0
                  Input.pfkey←{∨/⍵∊0 1:⍬ ⋄ 0=n←n×0 12≠.<n←⌊⊢/∊⎕VFI ⍵~ST←'sScCaA':⍬ ⋄ ⊂'Accelerator'((111+n),+/∪1 1 2 2 4 4 0[ST⍳⍵])}Input.pfkey
                  Button ⎕WS Input.pfkey
              :EndIf
          :EndIf
      :Case 'LastResult'
          :Select Input.pfkey~'sScCaA'
          :Case ,0
              {}Var ⎕PFKEY O.L.pfkey
          :Case ,'0'
              {}''⎕PFKEY O.L.pfkey
          :Else
              {}''⎕PFKEY O.L.pfkey
              Input.pfkey←{∨/⍵∊0 1:0 ⋄ 0=n←n×0 12≠.<n←⌊⊢/∊⎕VFI ⍵~ST←'sScCaA':0 ⋄ n+12×+/∪1 1 2 2 4 4 0[ST⍳⍵]}Input.pfkey
              {}Var ⎕PFKEY Input.pfkey
          :EndSelect
      :Case 'Rows'
          :If 1≡Input.fold
              Input.fold←,'3'
          :EndIf
          'fold must be: off, 0 .. 9'⎕SIGNAL 11↓⍨(⊂Input.fold)∊0,,¨⎕D,⊂'off'
      :EndSelect
     
      {r Amend∘⊢←i'.',⍵}¨mods
      SetCallback(O⍎¨⊃¨cmds).state∨.≢⊂'off' ⍝ any active?
    ∇

      SetCallback←{
          cb←⊃⍵↓0(OUTSpace,'.Filter')
          '⎕se'⎕WS'Event'('SessionPrint'cb),⎕SE.SALTUtils.V18/⊂'SessionTrace'cb
      }

      Amend←{
          name←⊃⌽⍵⊆⍨'.'≠⍵
          value←Input⍎name
          0≡value:⍺
          value←'on'⊣⍣(1≡value)⊢value
          r←(' ?-',name,'=\w+|$')⎕R(' -',name,'=',⍕O⍎⍵)⍠'ML'(']'=⊃⍺)⊢⍺
          _←⍎'O.',⍵,'←value'
          r
      }

      Set←{
          ref←O⍎⊃⍺
          mods←⍎⍺,'Mods'
          _←⍵{⍺≡'reset':ref⍎⍕mods'←⍵' ⋄ ⍬}⍎⍺,'Defs'
          r←']',⍺,' ',1 ⎕C ref.state
          r,∊{' -',⍵,'=',⍕ref⍎⍵}¨mods
      }

    ∇ r←level Help Cmd;⎕ML;lev2;n;h
      r←⍬
      :Select Cmd
      :CaseList 'Box' 'Boxing'
          r,←⊂'Display output with borders indicating shape, type and structure'
          r,←⊂'    ]',Cmd,' [on|off|reset|?] [-style={non|min|mid|max}] [-view={non|min|mid|max}] [-trains={box|tree|parens|def}] [-fns[=off|on]]',' [-pfkey=[S][C][A]<n>]'/⍨enableBoxPfkey∧⎕SE.SALTUtils.WIN
          r,←⊂''
          :If 0=level
              r,←⊂']',Cmd,' -?? ⍝ for more information and examples'
          :Else
              r,←⊂'Argument is one of:'
              r,←⊂'    ""       query on/off state only'
              r,←⊂'    "on"     activate boxing'
              r,←⊂'    "off"    disable boxing'
              r,←⊂'    "reset"  restore factory settings: -style=min -view=min -trains=box -fns=off'
              r,←⊂'    "?"      query current state including modifiers'
              r,←⊂''
              r,←⊂'-style={non|min|mid|max}  amount of diagram detail in Session'
              r,←⊂'-view={non|min|mid|max}   amount of diagram detail when using ]View'
              r,←⊂'     non  boxing     ┌───┬──────┐    ┌→──┬──────┐    ┌→───────────────┐'
              r,←⊂'                     │min│boxing│    │mid│boxing│    │ ┌→──┐ ┌→─────┐ │'
              r,←⊂'                     └───┴──────┘    └──→┴─────→┘    │ │max│ │boxing│ │'
              r,←⊂'                                                     │ └───┘ └──────┘ │'
              r,←⊂'    non:  no borders                                 └∊───────────────┘'
              r,←⊂'    min:  no border decoration'
              r,←⊂'    mid:  axes are indicated as follows:'
              r,←⊂'            ↓  leading axis   (length>0)'
              r,←⊂'            →  trailing axis  (length>0)'
              r,←⊂'            ⌽  leading axis   (length=0)'
              r,←⊂'            ⊖  trailing axis  (length=0)'
              r,←⊂'            ⍒  multiple leading axes'
              r,←⊂'          content types are indicated as follows:'
              r,←⊂'            ~  numeric'
              r,←⊂'            ─  character'
              r,←⊂'            #  namespace'
              r,←⊂'            ∇  ⎕OR'
              r,←⊂'            +  mixed'
              r,←⊂'    max:  axes are indicated as follows:'
              r,←⊂'            ↓  leading axes   (length>0)'
              r,←⊂'            →  trailing axis  (length>0)'
              r,←⊂'            ⌽  leading axes   (length=0)'
              r,←⊂'            ⊖  trailing axis  (length=0)'
              r,←⊂'          content types are indicated as follows:'
              r,←⊂'            ∊  nested'
              r,←⊂'            ~  numeric'
              r,←⊂'            ─  character'
              r,←⊂'            #  namespace'
              r,←⊂'            ∇  ⎕OR'
              r,←⊂'            +  mixed'
              r,←⊂'    NOTES:'
              r,←⊂'        ∘  For mid and max, content is prototypical if any axis has length=0.'
              r,←⊂'        ∘  -style=non is similar to non-boxed output, but fixes newline issues'
              r,←⊂'        ∘  -style=mid is similar to always using ]Disp'
              r,←⊂'        ∘  -style=max is similar to always using ]Display'
              r,←⊂''
              r,←⊂'-trains={box|tree|parens|def}  display style of trains and derived functions'
              r,←⊂'    Display of +⌿÷≢ with -trains=...'
              r,←⊂'        box          tree     parens    def '
              r,←⊂'    ┌─────┬─┬─┐      ┌─┼─┐    (+⌿)÷≢   +⌿÷≢'
              r,←⊂'    │┌─┬─┐│÷│≢│      ⌿ ÷ ≢'
              r,←⊂'    ││+│⌿││ │ │    ┌─┘'
              r,←⊂'    │└─┴─┘│ │ │    +'
              r,←⊂'    └─────┴─┴─┘'
              r,←⊂'    NOTE:  -trains=parens uses default form if any component needs multiple lines to display.'
              r,←⊂''
              r,←⊂'-fns={off|on}  diagram output from running functions'
              r,←⊂'    Display of {⌽⎕←⍵}''hello'' ''world'' with -fns=...'
              r,←⊂'         off               on'
              r,←⊂'     hello  world    ┌─────┬─────┐'
              r,←⊂'    ┌─────┬─────┐    │hello│world│'
              r,←⊂'    │world│hello│    └─────┴─────┘'
              r,←⊂'    └─────┴─────┘    ┌─────┬─────┐'
              r,←⊂'                     │world│hello│'
              r,←⊂'                     └─────┴─────┘'
              :If enableBoxPfkey
                  r,←⊂''
                  r,←⊂'-pfkey=[S][C][A]<n>  toggle boxing on/off with function key <n>, while zero or more of with C(ontrol), S(hift), A(lt) are held depressed'
                  r,←⊂'    ]',Cmd,' -pfkey=12   ⍝ assign to F12'
                  r,←⊂'    ]',Cmd,' -pfkey=CSA6 ⍝ assign to Ctrl+Shift+Alt+F6'
              :EndIf
          :EndIf
     
      :Case 'Rows'
          r←⊂'Cut, wrap, fold or extend the display of output lines to fit the Session window'
          r,←⊂'    ]',Cmd,' [on|off|reset|?] [-style=<s>] [-fold=<f>] [-fns[=on|off]] [-dots=<c>]'
          r,←⊂''
          :If 0=level
              r,←⊂']',Cmd,' -??   ⍝ for more information and examples'
          :Else
              r,←⊂'Argument:'
              r,←⊂'    ""       query main state (on/off)'
              r,←⊂'    "on"     enable row-processing'
              r,←⊂'    "off"    restore native ⎕PW block-wrapping'
              r,←⊂'    "reset"  restore factory settings: -style=long -fold=off -fns=off -dots=·'
              r,←⊂'    "?"      query full state, including modifiers'
              r,←⊂''
              r,←⊂'Modifiers:'
              r,←⊂''
              r,←⊂'-style=<s>'
              r,←⊂'    "long"  rows extended beyond screen width (default)'
              r,←⊂'    "cut"   rows truncated at screen width'
              r,←⊂'    "wrap"  each row wrapped at screen width'
              r,←⊂''
              r,←⊂'-fold[=<f>]'
              r,←⊂'    <n>     number of trailing rows after fold (must be 0 through 9; default: 3). Ignored with -style=wrap'
              r,←⊂'    "off"   no folding; all rows displayed (default)'
              h←'    NOTE:  -fold=<n> replaces rows towards the end of multi-row  output with a line of <c> characters so that the expression that generated '
              h,←'the output, together with some leading and trailing rows of its output, remain visible in the session window. -fold=<n> '
              h,←'may be appropriate for session-based demonstrations.'
              r,←⊂h
              r,←⊂''
              r,←⊂'-fns={on|off}'
              r,←⊂'    "on"    also format output from running functions'
              r,←⊂'    "off"   only format session results (default)'
              r,←⊂'    NOTE:  By default, only output from expressions typed into the session is processed. To include output from running functions, set -fns=on.'
              r,←⊂''
              r,←⊂'    Example:'
              r,←⊂'          ]',Cmd,' -fold=3'
              r,←⊂'    was -fold=off'
              r,←⊂'          ⍳10 4   ⍝ this assumes that the session window is 13 lines high'
              r,←⊂'    ┌→───┬────┬────┬────┐'
              r,←⊂'    ↓1 1 │1 2 │1 3 │1 4 │'
              r,←⊂'    ├~──→┼~──→┼~──→┼~──→┤'
              r,←⊂'    │2 1 │2 2 │2 3 │2 4 │'
              r,←⊂'    ├~──→┼~──→┼~──→┼~──→┤'
              r,←⊂'    │3 1 │3 2 │3 3 │3 4 │'
              r,←⊂'    ├~──→┼~──→┼~──→┼~──→┤'
              r,←⊂'    ·····················'
              r,←⊂'    ├~──→┼~──→┼~──→┼~──→┤'
              r,←⊂'    │10 1│10 2│10 3│10 4│'
              r,←⊂'    └~──→┴~──→┴~──→┴~──→┘'
              r,←⊂''
              r,←⊂'-dots=<c>'
              r,←⊂'    <c>     character to use for ellipses (default is "·", shown as "···")'
          :EndIf
     
      :Case 'Find'
          r←⊂'Precede output with a reference to the line of code that generated it'
          r,←⊂'    ]OUTPUT.',Cmd,' {on|off|reset|?} [-includequadoutput[=on|off]] [-stop[=on|off]] [-timestamp[=on|off]]'
          r,←⊂''
          :If 0=level
              r,←⊂']OUTPUT.',Cmd,' -?? ⍝ for more information and examples'
          :Else
              r,←⊂'Argument:'
              r,←⊂'    "on"     enable reports'
              r,←⊂'    "off"    disable reports'
              r,←⊂'    "reset"  restore factory settings: -includequadoutput=off -stop=off -timestamp=off'
              r,←⊂'    "?"      query current state'
              r,←⊂''
              r,←⊂'Modifiers:'
              r,←⊂''
              r,←⊂'-includequadoutput[=on|off]'
              r,←⊂'    "on"    also report on output caused by ⎕←'
              r,←⊂'    "off"   only report on implicit output (default)'
              r,←⊂''
              r,←⊂'-stop[=on|off]'
              r,←⊂'    "on"    stop execution when about to output'
              r,←⊂'    "off"   print any putput and continue execution (default)'
              r,←⊂''
              r,←⊂'-timestamp[=on|off]'
              r,←⊂'    "on"    show timestamp with every output'
              r,←⊂'    "off"   do not show timestamps with output reports (default)'
              r,←'' 'NOTE:  Reports begin with ">>" for implicit output and with "⎕←" for explicit output.'
              r,←'' 'Example:'
              r,←⊂'        ∇ foo'
              r,←⊂'    [1]   ''Line not starting with ⎕'''
              r,←⊂'    [2]   ⎕←''Line with ⎕←'''
              r,←⊂'        ∇'
              r,←⊂''
              r,←⊂'        foo'
              r,←⊂'    Line not starting with ⎕'
              r,←⊂'    Line with ⎕←'
              r,←⊂''
              r,←⊂'        ]OUTPUT.',Cmd,'  on  -includequadoutput -timestamp'
              r,←⊂'    Was off'
              r,←⊂'        foo'
              r,←⊂'    >> Output from #.foo[1]',timestamp
              r,←⊂'    Line not starting with ⎕'
              r,←⊂'    ⎕← Output from #.foo[2]',timestamp
              r,←⊂'    Line with ⎕←'
          :EndIf
     
      :Case 'LastResult'
          r←⊂'Automatically store the last printed result in ',Var,' (variable name may change in a future release)'
          r,←⊂'    ]',Cmd,' {on|off|reset|?} [-pfkey=[S][C][A]<n>]'
          :If 1≤level
              r,←⊂''
              r,←⊂'Speed up typing the variable name by assigning it to a function key using the modifier -pfkey=[S][C][A]<n> where <n> is 1 to 12 and optionally preceeded by S for Shift, C for Control and/or A for Alt:'
              r,←⊂'        ]',Cmd,' on -pfkey=S6 ⍝ store the name in Shift+F6'
              r,←⊂'        ?10⍴100' ⋄ ⎕RL←⍬
              r,←⊂'    ',⍕n←?10⍴100
              r,←⊂'        +/',Var,' ⍝ Use Shift+F6 to type this'
              r,←⊂'    ',⍕,+/n
          ⍝:EndIf
          ⍝r,←'' 'If the last printed result was a ref, certain workspace actions be may be temporarily blocked (this restriction may disappear in a future release). To unblock, simply enter a non ref expression in the session.'
          ⍝:If 1≤level
          ⍝    r,←⊂'        ⎕NS ⍬'
          ⍝    r,←⊂'    #.[Namespace]'
          ⍝    r,←⊂'        )clear'
          ⍝    r,←⊂'    Cannot perform operation when # is referenced by session namespace.'
          ⍝    r,←⊂'        0'
          ⍝    r,←⊂'    0'
          ⍝    r,←⊂'        )clear'
          ⍝    r,←⊂'    clear ws'
          :Else
              r,←''(']',Cmd,' -?? ⍝ for details')
          :EndIf
     
      :EndSelect
      :If 1≤level
          r,←⊂''
          r,←SaveInfo'NOTE:  Make settings persist for future Dyalog instances by saving the session:'
      :EndIf
    ∇

    ∇ r←SaveInfo r;dse;save;saveas;req;Req
      Req←{
          ⎕NEXISTS ⍵:1≠12 ⎕NINFO dse
          1
      }
      :If ⎕SE.SALTUtils.WIN
          :If 9=⎕NC'⎕SE.mb.session.sesave'
              save←⎕SE.mb.session.(Caption,'>',sesave.Caption)~'&'
          :Else
              save←'Session>Save'
          :EndIf
          :If 9=⎕NC'⎕SE.mb.session.sesave'
              saveas←⎕SE.mb.session.(Caption,'>',sesaveas.Caption)~'&'
          :Else
              saveas←'Session>Save As...'
          :EndIf
          :If 80=⎕DR''
              saveas←'...'⎕R(⎕UCS 8230)⍠'Regex' 0⊢saveas
          :EndIf
      :EndIf
      r←⊆r
      dse←⎕SE ⎕WG'File'
      :If ''≡dse
          :If ⎕SE.SALTUtils.WIN
              r,←⊂'    ',saveas
          :Else
              dse←(⎕SE.Dyalog.Utils.Config'DYALOG'){⍺,('/'=⊃⌽⍺)↓'/',⍵}'default.dse'
              req←Req dse
              r,←⊂'    2⎕NQ⎕SE''FileWrite''',req/'  ⍝ requires write access to "',dse,'"'
          :EndIf
      :Else
          req←Req dse
          :If ⎕SE.SALTUtils.WIN
              :If req
                  r,←⊂'    ',saveas,' or'
              :Else
                  r,←⊂'    ',save,' or'
              :EndIf
          :EndIf
          r,←⊂'    2⎕NQ⎕SE''FileWrite''',req/'  ⍝ requires write access to "',dse,'"'
      :EndIf
    ∇

    ∇ r←flipBox dummy;c;band;obj
      B.state←'offon'↑⍨3-5×c←B.state≢'on' ⍝ determine new state
      band←⊃⌽'b'⎕SE.cbtop.⎕NL ¯9
      obj←'⎕SE.cbtop.',band,'.tb.boxing'
      obj ⎕WS'State'c  ⍝ change button
      SetCallback c
      r←1
    ∇

    ∇ {output}←{A}Filter event            ⍝ various output filters.
      ;susp;rand;⎕PP;monad;text;DispFmt;trace;⎕PW;LFmt;Split;sim;i;∆STACK;GroupOut
      ⎕PP←⍬⍴⎕RSI.⎕PP                      ⍝ current space's precision.
      ∆STACK←⎕STACK ⍝ cache before it might get modified by stopping
      :If 0=⎕NC'DEBUG'
          DEBUG←0
      :EndIf
      :If 1≥DEBUG ⍝ this verbosity is for speed
          :If ⍬≢⎕STOP'Filter'
              ⍬ ⎕STOP'Filter'
          :EndIf
      :Else
          :If ⍬≡⎕STOP'Filter'
              STOP ⎕STOP'Filter'
          :EndIf
      :EndIf
     STOP: :Trap 0 1000↓⍨DEBUG                 ⍝ catching errors & interrupts.
          :If sim←⍬≡⍴event ⍝ simulating
              event←⌽2⊥⍣¯1⊢event ⍝ unpack little-endian: (non-)suspension, return result instead of printing
          :EndIf
          event←4↑event,⍬ ⍬ ⍬             ⍝ ensure enough args
     
          :If monad←900⌶0
              A←0
          :EndIf
          trace←event[2]∊'SessionTrace' 527
     
          susp←2=-/(,∆STACK)⍳'*' '⎕DQ'    ⍝ execution suspended.
          ⍝ multi-line input is implemented as locked function
          ⍝ this will look like we're printing from a function
          ⍝ so we pretend it isn't on the stack:
          susp∨←(4=-/(,∆STACK)⍳'*' '⎕DQ')∧('Filter' '__session_input__'≡2↑⎕SI)
          susp∨←1≡⊃event                  ⍝ simulate suspension?
          susp∧←0≢⊃event                  ⍝ simulate non-suspension?
          A{⍎'rand←⍺⍺' ⋄ ⍺⍺}0             ⍝ naming of fn/var "rand".
          GroupOut←5306⌶,∘⊆∘,             ⍝ unofficial: output lines as group
          Split←{(+/∨\' '≠⌽⍵)↑¨↓⍵}
          LFmt←{
              SubFmt←{ ⍝ ⎕FMT but substituting spaces with ⍺
                  e←∊w←⍵
                  (∊w)←⍺@(' '∘=)e
                  ⎕FMT w
              }
              spaceSubs←⎕UCS 0 1            ⍝ substitution chars
              fmts←spaceSubs SubFmt¨⊂⍵
              oldSpaces←↓⊃∧/spaceSubs=fmts  ⍝ indicate real spaces in each line
              split←Split⊃fmts              ⍝ work with substituted spaces, not to strip them
              oldSpaces{' '@(⍺↑⍨≢)⍵}¨split  ⍝ put spaces back in where they were
          }
          DispFmt←{                       ⍝ display formatted output.
              O←Init OUTSpace             ⍝ output namespace.
              U←⎕SE.Dyalog.Utils          ⍝ utils namespaces.
              isa←2 9∨.=⎕NC'rand'         ⍝ operand is array or namespace.
              rb←'off'∘≢¨(R B).state      ⍝ rows and boxing states.
              oon←susp<2<⍴⎕XSI            ⍝ output on?
              CaptureResult←{
                  _←⎕SE.SALTUtils.LastResultVarName ⎕PFKEY⊃⊃⌽⎕VFI⍕O.L.pfkey
                  ⍵:⍎⎕SE.SALTUtils.LastResultVarName,'←⍺'
                  0
              }
              _←⍵ CaptureResult isa∧O.L.state≡'on' ⍝ capture result?
              0 0 0≡rb,oon:⊂⍵           ⍝ all off: no formatting.
              FindOutput←{
                  F.state≢'on':0
                  trace:0
                  0 ''∊⍨⍬⍴⍵:0
                  ~oon:0
                  (fn lc)←⍵
                  ⍝ lc←1⌈lc ⍝ why was this here?
                  time←timestamp/⍨F.timestamp≡'on'
                  (F.includequadoutput≡'on')<'⎕'∊qo←'⎕←>>'/⍨2/⍲\2/'⎕←'≡2↑{(+/∧\' '=⍵)↓⍵}(1+lc)⌷180⌶fn:0
                  msg←qo,(' Output from ',fn,1⌽'][',⍕lc),time
                  ⊢⎕←msg⊣msg ⎕SIGNAL 901/⍨F.stop≡'on'
              }
              _←FindOutput 3⊃¨⎕XSI ⎕LC,¨0
              fmt←{                               ⍝ formatting style.
                  box←{susp ⍺(⍵⌶Box)⍵}            ⍝ regular boxing.
                  isa:1 box ⍵                     ⍝ array boxing.
                  f←⍵⌶                            ⍝ unpack ⎕OR
                  3≡⊃183⌶'f':⎕FMT ⍵               ⍝ ⎕OR
                  simp←(⎕NC⊂'rand')∊3.1 3.2       ⍝ simple non-derv.
                  simp:0 box ⍵                    ⍝ box-formatting array.
                  nkd←tacit'rand'                 ⍝ nkd-struct for local derv
                  B.trains≡'box':0 box⊃⌽nkd       ⍝ boxing of tacit fn
                  B.trains≡'tree':' '@(0=⎕UCS)Dft nkd ⍝ tree-formatting.
                  0(B.trains≡'parens')U.expr⊂nkd  ⍝ linear display of tacit fn
              }
              tacit←{                                     ⍝ nkd struct for 'rand'
                  this←⊃U.nkds ⎕NS'rand'                  ⍝ raw nkd for 'rand'
                  tnames←O.{0=⎕NC'tnames':0 ⋄ tnames}0    ⍝ tnames, default off
                  ⊃tnames U.nabs(⊂this),U.nkds ⍬⍴⎕RSI↓⍨¯1+⎕SI⍳⊂'Filter' ⍝ rand names wrt current ns
              }
     
              BoxOnly←{                   ⍝ boxing only:
                  isa:LFmt fmt ⍵  ⍝ array: cropped.
                  Split ⎕FMT fmt ⍵        ⍝ fn: remove trailing blanks
              }
              sim∨0 1≡rb:BoxOnly ⍵
     
              CropOnly←{                  ⍝ cropping only:
                  isa:susp Rows LFmt ⍵    ⍝ array: cropped.
                  Split ⎕FMT ⍵            ⍝ fn: force ' ∇name'
              }
              1 0≡rb:CropOnly ⍵
     
              susp Rows BoxOnly ⍵         ⍝ cropping if larger than window.
          }                               ⍝ :: ∇ *
          output←DispFmt A
          :If trace
              text←(2⊃⎕XSI),'[',(⍕4⊃event),']'
              GroupOut LFmt text output↓⍨-monad
          :ElseIf ×≢output
          :AndIf 1≢2⊃event
              GroupOut output
              :If 2=⎕NC'⎕SE.Dyalog.Out.extraline'
                  :For i :In ⍳⎕SE.Dyalog.Out.extraline ⍝ we cannot output them in one go, as that will show a group bracket
                      ⍬
                  :EndFor
              :EndIf
          :EndIf
          :If 1≢2⊃event
              ⎕EX'output'
          :EndIf
      :Case 901
          (⊃⎕DMX.DM)⎕SIGNAL 901
      :Else
          :If ⎕EN<1000
              :Trap 1 ⍝ WS FULL
                  :If trace
                      text←(2⊃⎕XSI),'[',(⍕4⊃event),']'
                      ⍞←text A↓⍨-monad ⋄ ⍞←⎕UCS 13
                  :Else
                      ⎕←A ⍝ need ⎕← for dyalogscript
                  :EndIf
              :Else
                  ⎕SIGNAL⊂('EN' 1)('Message' 'Insufficient space to format output')
              :EndTrap
          :EndIf
      :EndTrap
    ∇

      Box←{⎕ML ⎕IO←0                      ⍝ Boxed session output.
     
          susp isa←⍺                      ⍝ from fun and array display.
          susp<B.fns≡'off':⍵              ⍝ no boxing from fn output: done.
          simp←⍵{~isa:0 ⋄ 1=≡,⍺⍺}0        ⍝ is an array and is simple.
     
          fn←{                            ⍝ formatted function.
              isa:1 box ⍵                 ⍝ top level is array.
              (⊂,⍵)∊pfns:1/⍵              ⍝ primitive fn.
              isprimop ⍵:1/⍵              ⍝ primitive op.
              cls←⍺ class ⍵               ⍝ class of function ⍵.
              cls∊+3.1 4.1:tfn ⍺          ⍝ tradfn or tradop:
              cls∊+3.2 4.2:ndfn ⍵         ⍝ named dfn or dop:
              cls∊-3.2 4.2:↑⍵             ⍝ unnamed dfn or dop:
              ~⍺ isderv ⍵:1 box ⍵         ⍝ not derived fn: give up.
              '['≡1⊃⍵:⍺{                  ⍝ +/[1 → +/[1]
                  ax←'[',(⍕2⊃⍵),']'       ⍝ formatted axis
                  (⊃⍺)ax fn(⊃⍵)ax         ⍝ axis as monadic operator
              }⍵
              ~'.'≡1⊃⍵:⍺ ∇¨⍵              ⍝ derived fn.
              0::⍺ ∇¨⍵                    ⍝ error:
              ⍙←⍎⊃⍵                       ⍝ naming left operand,
              9≠⎕NC'⍙':⍺ ∇¨⍵              ⍝ not a space ref:
              (2⊃⍺)∇ 2⊃⍵                  ⍝ dropping space-tagging.
          }                               ⍝ :: C[;] ← vr ∇ nr
     
          tfn←{'    ∇ ',(6↓¯2↓⍵),'∇'}     ⍝ nice 1970s-style display.
     
          isderv←{                        ⍝ looks like a derived fn.
              ~(⊂⍴⍵)∊,¨2 3:0              ⍝ not a 2- or 3-vector: no
              isprimop 1⊃⍵:1              ⍝ primitive operator.
              ∧/(¯2↑⍺)isfn¨¯2↑⍵:1         ⍝ fork
              4=⌊|(1⊃⍺)class 1⊃⍵          ⍝ defined operator
          }
     
          isfn←{                          ⍝ is a function?
              (⊂,⍵)∊pfns:1                ⍝ primitive fn:
              isname ⍵:1                  ⍝ for late-binding.
              3=⌊⍺ class ⍵:1              ⍝ class is 3:
              ⍺ isderv ⍵                  ⍝ derived fn.
          }                               ⍝ :: yes ← vr ∇ cr
     
          isname←{                        ⍝ valid name.
              ~ischarvec ⍵:0              ⍝ non-starter.
              0≤⎕NC ⍵                     ⍝ possible.
          }
     
          ischarvec←{(1=⍴⍴⍵)∧(⎕DR ⍵)∊82 80 160 320}  ⍝ char vector.
     
          isprimop←{                         ⍝ is a primitive operator.
              u←80=⎕DR''                     ⍝ Unicode
              kvrs←⎕UCS u/9000+16 56 60 18   ⍝ key, variant, paw, stencil
              kvrs,←⎕UCS 9061/⍨u∧⎕SE.SALTUtils.V18 ⍝ hoof ⍝NEWGLYPH⍝
              pops←'/\⌿⍀.¨∘⍨&⍣[⌶@'           ⍝ classic primitive ops
              sops←'⎕S' '⎕R' '⎕OPT'          ⍝ system ops
              sops,←'⎕U2338' '⎕U2360' '⎕U2364' '⎕U233A' ⍝ ⎕= ⎕: ∘¨ ⎕⋄
              sops,←⎕SE.SALTUtils.V18/⊆'⎕U2365' ⍝ ○¨ ⍝NEWGLYPH⍝
              (⊂⍵)∊pops,kvrs,sops            ⍝ is a primitive operator.
          }
     
          ndfn←{                          ⍝ named dfn: removal of name←.
              a←⊃⍵                        ⍝ first line.
              x←a⍳'{'                     ⍝ length of 'name←'.
              ~'⍝'∊a:↑(⊂x↓a),1↓⍵          ⍝ no comment: without name.
              c←a⍳'⍝'                     ⍝ position of line[0] comment.
              d←x↓(c↑a),(x⍴' '),c↓a       ⍝ name← removed, comment adjusted.
              ↑(⊂d),1↓⍵                   ⍝ raw dfn matrix rep.
          }
     
          class←{
              ~ischarvec ⍺:¯1                     ⍝ not a char vector.
              ~'∇     ∇'≡7↑¯1⌽⍺:¯1                ⍝ not ⎕vr
              fx←(⎕NS'').{11::¯1 ⋄ ⎕NC⊂⎕FX ⍵}     ⍝ fix in tmp space.
              (cls←fx ⍵)∊3 4∘.+0.1 0.2:cls        ⍝ trad or named dfn or op:
              -fx,⊂('⍙←',⊃⍵),1↓⍵                  ⍝ unnamed dfn or failure.
          }
     
          box←{                                   ⍝ boxing of ⍵
              U B←⎕SE.Dyalog.(Utils Out.B)        ⍝ handy refs.
              style←sim⊃B.style B.view            ⍝ min mid max
              smooth←1⍝B.chars≡'regular'            ⍝ box-drawing chars?
              simp∧(⎕UCS 10)∊⍕⍵:⍺ ∇'\r?\n'⎕R'\r'⍠'Mode' 'D'⍤1⍕⍵ ⍝ normalise EOLs
              (isa∧style≡'non')∨simp∧~style≡'max':⍵   ⍝ no boxing.
              style≡'min':0 smooth 0 1 ⎕PP U.disp ⍵   ⍝ min: undecorated disp
              style≡'mid':⍺ smooth 0 1 ⎕PP U.disp ⍵   ⍝ mid: ⍺-decorated disp
              ⍺:smooth ⎕PP U.display ⍵            ⍝ max: ⍺: display
              0 smooth 0 1 U.disp ⍵               ⍝ max: undecorated disp.
          }
     
          uni←80=⎕DR''                            ⍝ unicode interpreter
          pf0←'+-×÷⌊⌈|*⍟<≤=≥>≠∨∧⍱⍲!?~○'           ⍝ scalar fns.
          pf1←'⌷/⌿\⍀∊⍴↑↓⍳⊂⊃∩∪⊣⊢⊥⊤,⍒⍋⍉⌽⊖⌹⍕⍎⍪≡≢⍷'   ⍝ other fns.
          pfu←⎕UCS uni/8838 9080                  ⍝ ⊂_ and ⍳_.
          pfns←,¨pf0,pf1,pfu                      ⍝ primitive fns.
     
          ⍙←⍺⍺ ⋄ 0 box(⊃⎕VR'⍙')fn⊃⎕NR'⍙'          ⍝ boxed output.
      }

      Dft←{⎕IO ⎕ML←0 1                            ⍝ Display of function tree.
     
          trav←{                                  ⍝ traverse, accumulating subtrees.
              0=≡⍺:⍺ leaf ⍵                       ⍝ not a derv or train: done.
              '['≡1⊃⍵:(2↑⍺)∇(⊃⍵)('[',(⍕2⊃⍵),']')  ⍝ axis: special treatment
              ~4∊|⍺:train ⍺ ∇¨⍵                   ⍝ train
              {                                   ⍝ operator-derived fn:
                  2=⍴⍵:mop ⍵                      ⍝ monadic operator
                  3=⍴⍵:dop ⍵                      ⍝ dyadic operator.
              }⍺ ∇¨⍵                              ⍝ formatted subtrees.
          }                                       ⍝ ::
     
          train←{                                 ⍝ function train.
              subs←↑mesh/⍵                        ⍝ enmeshed subtrees.
              tops←apts⊃↓subs                     ⍝ anchor points.
              jpts←mid⍣(2=+/tops),tops            ⍝ joining points.
              xvec←{(3×⍵)++\⍵}jpts                ⍝ character index vector.
              deco←(¯2+⍴⍵)⊃' ── ┌┴┐ ' ' ── ┌┼┐ '  ⍝ plumbing chars.
              (xvec⊃¨⊂deco)⍪subs                  ⍝ subtree matrix.
          }
     
          mop←{                                   ⍝ operator with one operand.
              land oper←↓¨⍵                       ⍝ derived function components.
              tab←+/∧\(⊃land)∊' ┌─┐'              ⍝ indentation for top line.
              pad←(tab+2)/' '                     ⍝ padding for operator.
              topr←pad∘,¨oper                     ⍝ tabbed operator.
              deco←' ┌─┘'                         ⍝ plumbing chars.
              join←tab 1 1 1/deco                 ⍝ dog-leg or straight join.
              ↑(topr,↓join),land                  ⍝ subtree matrix.
          }
     
          dop←{                                   ⍝ operator with two operands.
              land oper rand←⍵                    ⍝ derived function components.
              subs←land mesh rand                 ⍝ merged subtrees.
              tops←mid apts⊃↓subs                 ⍝ anchor points.
              xvec←{(3×⍵)++\⍵}tops                ⍝ character index vector.
              head←xvec⊃¨⊂' ── ┌┴┐ '              ⍝ forked subtree joiner.
              otab←(head⍳'┴')/' '                 ⍝ operator padding.
              ↑(otab∘,¨↓oper),↓head⍪subs          ⍝ subtree matrix.
          }
     
          mesh←{                                  ⍝ meshed left and right subtrees.
              lbr rbr←⊂[1 2]↑⎕FMT¨(⌽⍺)⍵                ⍝ sub branches with same no of rows.
              lft rgt←{+/∧\' '=⍵}¨lbr rbr         ⍝ left and rgt adjacent blanks.
              sep←⌊/lft+rgt                       ⍝ narrowest separation.
              dpl←lft⌊sep                         ⍝ chars to drop from left subtree.
              dpr←0⌈sep-dpl                       ⍝   ..      ..      right   ..
              lvec←⌽¨dpl↓¨↓lbr                    ⍝ left rows.
              rvec←dpr↓¨' '∘,¨↓rbr                ⍝ right rows, padded with min gap.
              trim←{(~∧\∧⌿⍵=' ')/⍵}               ⍝ trim off outer blank cols.
              ⌽trim⌽trim↑lvec,¨rvec               ⍝ meshed subtrees.
          }
     
          leaf←{                                  ⍝ leaf formatting
              ⍺∊2 9:(⎕UCS 0)@(=∘' ')1 ⎕SE.Dyalog.Utils.repObj ⍵   ⍝ array: linear representation
              1∊'←{'⍷⊃↓⍵:∇↑noname↓⍵               ⍝ dfn without name
              '·'@(' '=⊢)⎕FMT ⍵                   ⍝ dots for blanks in char matrix
          }
     
          noname←{                                ⍝ without dfn name
              a←⊃⍵                                ⍝ first line
              x←a⍳'{'                             ⍝ length of 'name←'
              ~'⍝'∊a:(⊂x↓a),1↓⍵                   ⍝ no comment: without name
              c←a⍳'⍝'                             ⍝ position of line[0] comment
              d←x↓(c↑a),(x⍴' '),c↓a               ⍝ name← removed, comment adjusted
              (⊂d),1↓⍵
          }
     
          mid←{⍵∨(⍳⍴⍵){⍺=⌊(+/⍵/⍺)÷2}⍵}            ⍝ mask with midpoint
          trim←{⍵-¯1⌽1 1⍷⍵}⍣≡                     ⍝ for ('abc',)
          apts←trim∘(~∘(∊∘' ┌─┐'))                ⍝ anchor points for sub-trees.
          dfnop←{'}'≡⊃⌽~∘' ',⍵}                   ⍝ dfn or dop
     
          N K D←⍵                                 ⍝ name, kind-tree, defn
          K trav D                                ⍝ display of function tree.
      }

      pfnops←{                                    ⍝ primitive fns and ops.
          pf0←'+-×÷⌊⌈|*⍟<≤=≥>≠∨∧⍱⍲!?~○'           ⍝ scalar fns.
          pf1←'⌷/⌿\⍀∊⍴↑↓⍳⊂⊃∩∪⊣⊢⊥⊤,⍒⍋⍉⌽⊖⌹⍕⍎⍪≡≢⍷'   ⍝ other fns.
          pfu←⎕UCS ⍵/8838 9080                    ⍝ ⊂_ and ⍳_ ⍝NEWGLYPH⍝
          pfns←pf0,pf1,pfu                        ⍝ primitive fns.
     
          kvrs←⎕UCS ⍵/9000+16 56 60 18 61 51      ⍝ key, variant, paw, stencil, hoof, behind ⍝NEWGLYPH⍝
          pops←'/\⌿⍀.¨∘⍨&⍣[⌶@'                    ⍝ classic primitive ops
          sops←'⎕S' '⎕R' '⎕OPT'                   ⍝ system ops.
          sops,←'⎕U2338' '⎕U2360' '⎕U2364' '⎕U233A' '⎕U2365' '⎕235B' ⍝ ⎕= ⎕: ∘¨ ⎕⋄ ○¨ ∘_ ⍝NEWGLYPH⍝
          ops←pops,kvrs,sops                      ⍝ operators.
          pfns ops                                ⍝ fns & ops.
      }

      Rows←{                               ⍝ Cropped to fit session window.
          R←⎕SE.Dyalog.Out.R               ⍝ ref for params.
          ⍺<R.fns≡'off':⍵                  ⍝ no cropping from fn output: done.
          long←R.style≡'long'              ⍝ unrestricted screen width.
          sd←SD                            ⍝ physical screen dimensions
          ⎕PW⊢←⊢⌿sd⌈32767×long             ⍝ ⎕pw temp set to screen width.
          R.style≡'wrap':⍵                 ⍝ ⎕PW-wrap each line.
          rows←≢⍵ ⋄ cols←⌈/≢¨⍵             ⍝ raw output size.
          sr sc←sd⌈long×0,⎕PW⌈cols⌊32767   ⍝ screen_rows screen_cols
          coldots←{                        ⍝ with column dots.
              cols≤sc:⍵                    ⍝ no column cropping: done.
              ((3⍴R.dots),⍨(dc-3)↑⊢)¨@(dc<≢¨)⍵ ⍝ 3 dots after too-long lines
          }
          dc←cols⌊sc                       ⍝ number of cols to display.
          fold←(R.fold≢'off')∧rows>sr-2    ⍝ must fold rows?
          ~fold:coldots ⍵                  ⍝ no: row cropping only.
          tail←⍎R.fold                     ⍝ 0..9
          t←0⌈tail⌊sr-3                    ⍝ no of trailing rows.
          h←0⌈sr-3+t                       ⍝ input + brk + fold + prompt.
          brk←⊂(⌊/32767 cols,long↓⊢/sd)⍴R.dots ⍝ fold marker: ··················
          top←h↑⍵                          ⍝ retained upper part of output.
          bot←(-t)↑⍵                       ⍝    ..    lower  ..     ..
          all←top,brk,bot                  ⍝ dots-broken matrix
     
          coldots⍣(~long)⊢all              ⍝ cropped.
      }

    ∇ rc←SD;handle;GetDlgItem;GetClientRect;GetDC;ReleaseDC;GetDeviceCapsdlg;r;c;v;h;_;scal;hdc  ⍝ session window size
      :Trap 0
          ⎕NA'u user32|GetDlgItem u u'
          ⎕NA'u user32|GetClientRect u >{u u u u}'
          handle←'⎕se'⎕WG'Handle'
          dlg←GetDlgItem handle 0
          _(_ _ c r)←GetClientRect dlg(0 0 0 0)
          scal←1
          v h←2 ⎕NQ'⎕se' 'GetTextSize' 'X'
          :If (,'1')≡2 ⎕NQ'.' 'GetEnvironment' 'AutoDPI'
              ⎕NA'u user32|GetDC U'
              ⎕NA'u user32|ReleaseDC U U'
              ⎕NA'u gdi32|GetDeviceCaps U U'
              scal←96÷⍨GetDeviceCaps(hdc←GetDC 0)88
              {}ReleaseDC 0 hdc
          :End
     
          rc←⌊r c÷v h×scal
      :Else
          rc←⎕SD-1 0  ⍝ Unix version?
      :EndTrap
      rc-←0 1 ⍝ maybe we have DYALOG_LINEEDITOR_MODE=1
    ∇

    ∇ obj←Button;band ⍝ name of ]boxing button for ⎕W_
      band←⊃⌽'b'⎕SE.cbtop.⎕NL ¯9
      obj←'⎕SE.cbtop.',band,'.tb.boxing'
    ∇

    ∇ ts←timestamp
      ts←' at ',' '@11⊃'%ISO%.fff'(1200⌶)1 ⎕DT'J'
    ∇

:EndNamespace

 ⍝ outputspec  $Revision: 1934 $
