:Namespace repr ⍝ v1.21
⍝ 2021 03 24 Adam: Initial code
⍝ 2021 03 25 Adam: Own parsing to allow strings in expression
⍝ 2021 04 08 Adam: Fix error on error on one-liner
⍝ 2021 05 04 Adam: Handle ⎕NULL in CSV, stand-alone functions, and fix bugs in CSV
⍝ 2021 05 05 Adam: Avoid dropping first char of error if it isn't ⍎
⍝ 2021 05 09 Adam: Include "]" of bracket axis
⍝ 2021 07 28 Adam: Handle idioms [19239], add -f=json and rename APLAN to -f=aplan so -f= can have the default "apl"
⍝ 2021 08 02 Adam: Fix bug in xSV with non-scalar elements
⍝ 2021 08 13 Adam: Handle anonymous functions and operators, move to OUTPUT
⍝ 2021 10 20 Adam: Update help example
⍝ 2022 01 12 Adam: Workaround 19379
⍝ 2022 02 22 Adam: Handle function/operator results and cleaner workaround code
⍝ 2022 03 31 Adam: [19780] Detect how far up the stack we need to go, rather than computing it based on ⎕SI
⍝ 2022 07 28 Nathaniel: Fix bug in idiom recognition, added missed cases incl. /⌿
⍝ 2023 12 04 Adam: Remove code to work around [19379]
⍝ 2024 10 01 RPark: [21624] fix value error for locals and sub-nss

    ⎕ML←1 ⋄ ⎕IO←1

      Join←{
          ⍺←⎕UCS 13
          ∊1↓,(⊂⍺),⍪⍵
      }

    short←'apl' 'aplan' 'js' 'json' 'xml' 'csv' 'ssv' 'psv' 'tsv'
    long←'APL expression' 'APL Array Notation' 'JavaScript code' 'JavaScript Object Notation' 'Extensible Markup Language','Comma' 'Semi-colon' 'Pipe' 'Tab' ,¨⊂' Separated Values'
    desc←'Represent given value as '
    syntax←'[-format={',('|'Join short),'}] [-outfile=<filename>]'

    ∇ r←List
      r←⎕NS ⍬
      r.Name←'Repr'
      r.Group←'Output'
      r.Desc←desc,1 ⎕C'/'Join short
      r.Parse←''
    ∇

      Help←{
          r←⊂desc,(', 'Join ¯1↓long),', or ',⊃⌽long
          r,←⊂''
          r,←⊂']',⍵,' <expr> ',syntax
          r,←⊂''
          0=⍺:r,⊂']',⍵,' -??  ⍝ for details and examples'
          r,←⊂'<expr>  the value to generate code for'
          r,←⊂''
          r,←⊂'-format=  (default: apl)'
          r,←,/'  '∘,¨⍉↑(short↑¨⍨⌈/≢¨short)(' ',¨long)
          r,←⊂''
          r,←⊂'-outfile=  write code to <filename> instead of printing it'
          r,←⊂''
          r,←⊂'Limitations:'
          r,←⊂'  ∘  The default notation is a single-line APL expression, suitable for ⍎ ─ this cannot represent objects or functions.'
          r,←⊂'  ∘  Some values cannot be represented, for example non-namespace objects, and namespaces that are not self contained.'
          r,←⊂'  ∘  Only APL Array Notation can represent functions, but not tradfns or multi-line tacit functions.'
          r,←⊂'  ∘  JavaScript cannot represent nested scalars.'
          r,←⊂'  ∘  JavaScript and Comma/Tab Separted Values can lose structural information.'
          r,←⊂'  ∘  Character separated values can lose type information.'
          r,←⊂''
          r,←⊂'Examples:'
          r,←⊂'    ]',⍵,' ⍳2 3                              ⍝ print APL code that evaluates to ⍳2 3'
          r,←⊂'    ]',⍵,' +⌿÷1⌈≢                            ⍝ fully parenthesise the given train'
          r,←⊂'    ]',⍵,' ⍳2 3 -f=aplan                     ⍝ print APL Array Notation'
          r,←⊂'    ]',⍵,' ⍳2 3 -f=js -o=/tmp/inds.js        ⍝ create file with JavaScript code'
          r,←⊂'    ]',⍵,' ⎕SE.Dyalog.Utils.cut              ⍝ print ⎕FX invocation to rebuild function'
          r,←⊂'    ]',⍵,' ''ABC''⍪2 3⍴⍳6 -f=csv               ⍝ convert table to Comma Separated Values'
          r
      }

    ∇ res←Run(cmd input);cont;params;expr;parser;ctor;sep;bs;ht;format;outfile;Prefix;mod;mods;str;Repr;Tacit;nl;nc;Array;fmt;xr;nr;oneliner;idioms;name;caller;fn;src;up;val;ExecUp
      ⍝ Input is raw to avoid quotes being interpreted as argument delimiters
      ⍝ Instead, we do custom parsing:
      ctor←'\|' '<\w+>|[][{}]'⎕R' ' ''⊢syntax
      Prefix←'(?:'∘Join,')?'⍴⍨2×¯1+≢ ⍝ modifiers can be abbreviated
      ⍝ this regex tries to match only appropriate modifiers:
      mod←'(?:(?:^|\s)-(?:',(Prefix'format'),'=("?)(',('|'Join short),')\1|',(Prefix'outfile'),'=("[^"]+"|\S+)))+(\s|$)'
      str←'''[^'']+''' ⍝ avoid matching modifier-looking sequences inside strings (comments are handled by the framework)
      ⍝ Exceedingly unlikely code could actually fail due to ambiguity:
      ⍝     f←3
      ⍝     js←3
      ⍝     ]repr 5 -f=js  ⍝ will give 5 instead of 4 (5-3=3)
      mods←∊mod ⎕S'&'⊢str ⎕R''⊢input
      parser←⎕NEW ⎕SE.Parser ctor
      params←parser.Parse mods
      expr←'''[^'']+''' '^ +| +$' '  +'⎕R'&' '' ' '⊢str mod ⎕R'\0' ' '⊢input
      :If ×≢expr
          nl←⎕UCS 13
     
          fmt←(short⍳⊂params.format)⊃long,⊂'an APL expression'
          :Select params.format
          :Case 'aplan' ⋄ Repr←Serialise
          :Case 'js' ⋄ Repr←5∘JS
          :Case 'json' ⋄ Repr←JS
          :Case 'xml' ⋄ Repr←⎕XML⍣2 ⎕SE.Dyalog.Utils.toXML
          :Case 'csv' ⋄ Repr←','SV
          :Case 'ssv' ⋄ Repr←';'SV
          :Case 'psv' ⋄ Repr←'|'SV
          :Case 'tsv' ⋄ Repr←(⎕UCS 9)SV
          :Else ⋄ Repr←1∘⎕SE.Dyalog.Utils.repObj
          :EndSelect
     
          :If 3 4∊⍨⌊nc←|##.THIS.⎕NC⊂expr
              name←1
     CODE:    :If 0 'apl' 'aplan'∊⍨⊂params.format
                  oneliner←'aplan'≢params.format
                  cont←##.THIS.⎕NR expr
                  :Select 10×1|nc
                  :Case 1 ⍝ trad
                      :If oneliner
                          cont←'⎕FX',Repr cont
                      :Else
                          cont←'∇',⍨cont,¨⍨'∇'↑⍨≢cont
                      :EndIf
                  :Case 2 ⍝ d-
                      :If oneliner
                          cont←'⎕FX',Repr cont
                      :EndIf
                  :Case 3 ⍝ tacit
                      idioms← '⊃∘⍴¨' '{0}¨' ',/' '⍪/' '⊣/' '⊢/' '⊣⌿' '⊢⌿'
                      Tacit←{
                          (⍬≡⍴⍺)∧idioms∊⍨⊂∊⍵:(⊢∇⍨3+∊∘'¨∘/⌿')∊⍵  ⍝ idioms [19239]
                          2 9∊⍨⊂⍺:Join⊆Repr ⍵    ⍝ array
                          ⍬≢⍴⍺:∊'(',(⍺ ∇¨⍵),')',⍨']'/⍨'['≡2⊃⍵  ⍝ derv
                          (3 1)(4 1)∊⍨⊂⍺,≢⍵:⍵    ⍝ primitive
                          0=≢⍵:11 ⎕SIGNAL⍨'Contains external or locked function'
                          code ← Join⊆⍵
                          '}'=⊃⌽⊃⌽⍵:code         ⍝ dfn
                          '(∇',code,nl,'∇)'      ⍝ tradfn
                      }
                      xr←183 ##.THIS.⌶expr
                      nr←##.THIS.⎕NR expr
                      cont←(name/' ',expr,'←'),⌽⍤{(∨\' '≠⍵)/⍵}⍣2{1↓¯1↓⍵}⍣((⍬≢⍴xr)∨idioms∊⍨⊂nr)⊢xr Tacit nr
                  :EndSelect
                  :If oneliner
                  :AndIf 1≠≢⎕FMT cont
                      11 ⎕SIGNAL⍨'Could not represent "',expr,'" using ',fmt
                  :EndIf
              :Else
                  11 ⎕SIGNAL⍨'Could not represent "',expr,'" using ',fmt
              :EndIf
          :Else
              :Trap 0
                  ExecUp←86 ##.THIS.⌶
                  ⍝ find out how far up the stack we need to go
                  up←0
                  :Repeat
                      up+←1
                  :Until ((0=≢)∨('UCMD'≡⊃))up ExecUp'⎕SI'
                  up+←1
     
                  val←up(86 ##.THIS.⌶)expr
              :Else
                  ⎕DMX.(EN ⎕SIGNAL⍨⍬(⊢↓⍨'⍎'=⍴)OSError{⍵,2⌽(×≢⊃⍬⍴2⌽⍺,⊂'')/'") ("',⊃⍬⍴2⌽⊆⍺}Message{⍵,⍺,⍨': '/⍨×≢⍺}⊃⍬⍴DM,⊂'')
              :EndTrap
              :If 3 4∊⍨⌊nc←|⎕NC⊂'val'
                  name←0
                  expr←'.val',⍨⍕⎕THIS
                  :GoTo CODE
              :EndIf
              :Trap 0
                  cont←Repr val
              :Else
                  11 ⎕SIGNAL⍨'Could not represent "',expr,'" using ',fmt
              :EndTrap
          :EndIf
     
          :If 0≡params.outfile
              res←Join⊆cont
          :Else
              (⊂cont)⎕NPUT⍠'NEOL' 2⊢params.outfile 1
          :EndIf
      :Else
          'expression required'⎕SIGNAL 6
      :EndIf
    ∇

      JS←{
          ⍺←⍬
          js←1 ⎕JSON⍠'Compact' 0⍠'HighRank' 'Split'⍠'Dialect'('JSON',⍕⍺)⍠'Null'⎕NULL⊢⍵
          js←'\[\s*[-\d.E, \r]+\s*\]|\[\s+|\s+]|{\s+}'⎕R{⍵.Match~' ',⎕UCS 13}⍠'Mode' 'D'⊢js ⍝ inline lists of numbers
          ⍝ remove , before ] and } EXCEPT in strings, so we match strings (https://stackoverflow.com/q/32155133) and keep them as-is, then match ,] and ,}
          js←'(("|'')(((?=\\)\\([''"\\\/bfnrtv0]|u[0-9a-fA-F]{4}))|[^''"\\\0-\x1F\x7F]+)*\2)' ',(]|})'⎕R'&' '\1'⊢js
          '^(  )+'⎕R{' '⍴⍨0.5×≢⍵.Match}js
      }

      SV←{
          1≥≢⍴⍵:∇⍉⍪⍵
          2<≢⍴⍵:∇,[⍳¯1+≢⍴⍵]⍵
          mat←⍺⍺ ⎕R('\',⍺⍺)⍠'Regex' 0⍤(1 ⎕JSON⍠'HighRank' 'Split'⊢)¨''⍨¨@(⎕NULL∘≡¨)⍵
          cont←¯1↓''⎕CSV⍠'EscapeChar' '\'⍠'QuoteChar' ''⍠'LineEnding' 13⍠'Trim' 0⍠'Separator'(⎕UCS 8)⍨mat
          (⎕UCS 8)⎕R ⍺⍺⊢cont
      }

    ∇ F←Serialise;old
      :If 3=⎕NC old←'⎕SE.Link.Serialise'
          F←⍎old
      :Else
          F←⎕SE.Dyalog.Array.Serialise
      :EndIf
      ⎕EX⊃⎕SI
      Serialise←F
    ∇

:EndNamespace
