﻿:namespace  supdate ⍝ V1.34
⍝ Script update
⍝ 2015 05 22 Adam: NS header
⍝ 2016 02 11 DanB: made it warn about classes unable to deal with
⍝ 2017 03 17 Adam: removed help linebreaks, and -DONT(SAVE) → -dontsave
⍝ 2017 05 26 Adam: help text language
⍝ 2018 04 22 Adam: Help text, fix misspelling of DONTSAVE
⍝ 2019 02 04 Adam: help

    ∇ r←{L}Help Cmd;a;b
      r←⊂'Synchronise namespace/class script to match current content'
      r,←⊂'    ]',Cmd,' [<object>] [-dontsave]'
      :If L=0
          r,←⊂''
          r,←⊂']',Cmd,' -??   ⍝ for more information and examples'
      :Else
          a←'Update the script of a class or a namespace by adding '
          a,←'new functions at the bottom and new variables at the top. '
          a,←'Any item that has been deleted from the object will be removed from the script.'
          r,←''a''
          r,←⊂'<object>   name of scripted namespace/class to process (default is current namespace)'
          r,←⊂'-dontsave  do not save to file (only relevant if object is SALTed)'
          r,←'' 'Example:'
          r,←⊂'        ]Load myns'
          r,←⊂'      #.myns'
          r,←⊂'        myns.v←⍳9'
          r,←⊂'        myns.⎕FX ''myfn'' ''2+2'''
          r,←⊂'        ]',Cmd,' myns'
          r,←⊂'    Added/changed 1 variables and 1 functions'
      :EndIf
      b←'WARNING:  There are potential problems with adding and removing '
      b,←'items. For example, if variable A is used to make B, then '
      b,←'removing A will prevent the script from being fixed.'
      r,←''b
    ∇

    ⎕IO←1 ⋄ ⎕ML←1

    ∇ r←List
      r←⎕NS ⍬
    ⍝ Name, group, short description and parsing rules
      r.(Name Group Parse)←'ScriptUpdate' 'NS' '1s -dontsave'
      r.Desc←'Synchronise namespace/class script to match current content'
    ∇

    If←/⍨

    fnNameOf←{ (21=1⊃200⌶⍵ '')/⍵}

    ∇ r←Run(Cmd Args);obj;ref;new;var;v;cs;f;top;del;space;SALT;hasSALT;SALTcopy;was;deleted;removed;src;rlb;mask;keep;ljsrc;cl;now;b;ln;end;fns;dfnh;dfne;changed;dfn1;s;e;orig;bad;c
      rlb←{(+/∧\' '=⍵)↓⍵}
      ref←space←##.THIS ⋄ keep←1
      :If 0<⍴Args.Arguments
          'invalid object'⎕SIGNAL 11 If 9≠space.⎕NC obj←1⊃Args.Arguments
          ref←space⍎obj ⋄ space←ref.## ⍝ this is the object we're dealing with
      :Else ⋄ space←space.##
      :EndIf
      'Cannot update # or ⎕SE'⎕SIGNAL 11 If ref∊# ⎕SE
      :If hasSALT←9=ref.⎕NC SALT←'SALT_Data' ⋄ SALTcopy←ref⍎SALT ⋄ :EndIf
      now←ref.⎕NL-⍳9                ⍝ and all the visible names in it
      src←⎕SRC ref                  ⍝ the source
      orig←0 ⎕FIX src               ⍝ as it was w/o the new objects
      new←now~was←orig.⎕NL-⍳9       ⍝ the added material
     ⍝ We only deal with vars and trad fns/ops (class 2.1 3.1 4.1)
      new~←bad←(~(ref.⎕NC new)∊2.1 3.1 4.1)/new
     
     ⍝ There could also be changes in objects (vars or fns)
      changed←0/deleted←was~now
      :For f :In now∩was          ⍝ for each common name
          :If (c←⌊cl←ref.⎕NC⊂f)=orig.⎕NC f ⍝ we cannot use ⎕OR because Dfns are not deemed to ≡
              :If c=2
                  v>←b←(cl≠2.1)∧v←(ref⍎f)≢orig⍎f ⋄ bad,←b/⊂f
              :ElseIf c∊3 4
                  v>←b←(cl∊3.1 4.1)<v←(ref.⎕CR f)≢orig.⎕CR f ⋄ bad,←b/⊂f
              :Else ⋄ v←0 ⍝ we don't touch spaces
              :EndIf
          :Else
              b←~v←cl∊2.1 3.1 4.1 ⋄ bad,←b/⊂f
          :EndIf
          (deleted new),←⊂changed,←v/⊂f
      :EndFor
      :If ~0∊⍴bad
          ⎕←'** WARNING: these objects cannot be added: ',bad
      :EndIf
      :If removed←0<⍴deleted
         ⍝ Mask out any Class/ns
          v←':class' ':names' ':endcl' ':endna'⍳⎕SE.SALTUtils.lCase¨6↑¨ljsrc←' ',⍨¨rlb¨src
          mask←1=(+\v<3)-+\v∊3 4
         ⍝ Mask out any D code
          v←v⍱∨\¨('⍝'=cl)>v←≠\¨''''=cl←mask/ljsrc
          f←0∊¨cl←(∊1↑⍨¨⍴¨v)⊂0=(+\∊v∧cl='{')-+\∊v∧cl='}'
          s←mask\f∧(1⊃¨cl)∧e←{1⊃⌽⍵}¨cl ⍝ single line D fns
          dfne←s∨mask\e>v←¯1⌽e ⍝ multiline D fns end here
          dfnh←s∨mask\e<v      ⍝ multiline D fns header
          mask←mask∧dfnh≥≠\s<dfnh∨dfne
         ⍝ Mask out code between ∇s
          mask←mask\cl≤=\cl←'∇'≠mask/1⊃¨ljsrc
     
         ⍝ Find which variables to remove
          keep←mask=mask
          :If 1∊var←2=orig.⎕NC↑deleted
              f←({'^',⍵,' *←'}¨var/deleted)⎕S{⍵.BlockNum}mask/ljsrc
              keep←~mask\(⍳+/mask)∊1+f ⍝ remove
          :EndIf
         ⍝ Remove fns
          :If 0<⍴fns←(~var)/deleted
             ⍝ Remove ∇fns
              v←(+/mask)⍴0
              :For ln end :In ↓{(2,⍨0.5×⍴⍵)⍴⍵}{⍵/⍳⍴⍵}'∇'=∊1↑¨cl←mask/ljsrc
                  :If (f←⊂fnNameOf 1↓ln⊃cl)∊fns
                      v[ln+0 1]←1 ⋄ fns~←f
                  :EndIf
              :EndFor
              keep←keep>{⍵∨≠\⍵}mask\v
             ⍝ Remove D fns
              :If 0<⍴fns
                  s←{⍵/⍳⍴⍵}dfnh ⋄ e←{⍵/⍳⍴⍵}dfne
              :AndIf 1=⍴v←1+('^(',(⊃{⍺,'|',⍵}/fns),') *←{')⎕S{⍵.BlockNum}ljsrc[s]  ⍝ find where Dfn defined
                  keep[∊s[v]+0,¨⍳¨e[v]-s[v]]←0
              :EndIf
          :EndIf
          src←keep/src
      :EndIf
      :If (0=⍴new)>0∊keep
          r←'No change'
      :Else
          var←2=⌊cl←ref.⎕NC new    ⍝ and their classes
         ⍝ Find the top lines of the source
          top←⍴ljsrc←rlb¨src
          top←⍴r←src↑⍨v-top=v←+/∧\' :⍝'∊⍨⍬∘⍴¨ljsrc
         ⍝ Load the conversion software
          cs←⎕SE.SALT.Load'lib\NStoScript -noname'
         ⍝ Add the new vars
          :If ∨/var
              r,←(var/new)cs.makeVars ref
          :EndIf
         ⍝ Add body of source
          r,←¯1↓top↓src ⍝ keep :endspace
         ⍝ Add the new fns
          :If ∨/f←~var
              del←0.1=1|f/cl
              r,←⊃,/del{c←ref.⎕NR ⍵ ⋄ c[⍳⍺],⍨←'∇' ⋄ ' ',c,⍺/'∇'}¨f/new
          :EndIf
         ⍝ Add last line
          r,←¯1↑src
         ⍝ Refix space
          ref←space.⎕FIX r
          (v f)←0<ns←+/1 0∘.=var
          r←'Added/changed ',(v/' variables',⍨⍕1↑ns),(' and '/⍨v∧f),f/' functions',⍨⍕1↓ns
          :If hasSALT
              ref.SALT_Data←SALTcopy
          :AndIf ~Args.dontsave
              ⎕SE.SALT.Save ref
          :EndIf
      :EndIf
    ∇

   ⍝ All possible function/operator headers. These can be used to test <fnNameOf>
    FH←  'f1' 'f1 a1' 'f1(a d)' 'la f1 a1' 'la f1(a d)'
    FH,← '{la2}f1 a1' '{la2}f1(a d)' 'R←f1' 'R←f1 a1' 'R←f1(a d)'
    FH,← 'R←la f1 a1' 'R←la f1(a d)' 'R←{la2}f1 a1' 'R←{la2}f1(a d)' '{R}←f1'
    FH,← '{R}←f1 a1' '{R}←f1(a d)' '{R}←la f1 a1' '{R}←la f1(a d)' '{R}←{la2}f1 a1'
    FH,← '{R}←{la2}f1(a d)' '(r1 r2)←f1' '(r1 r2)←f1 a1' '(r1 r2)←f1(a d)' '(r1 r2)←la f1 a1'
    FH,← '(r1 r2)←la f1(a d)' '(r1 r2)←{la2}f1 a1' '(r1 r2)←{la2}f1(a d)' '{(r1 r2)}←f1' '{(r1 r2)}←f1 a1'
    FH,← '{(r1 r2)}←f1(a d)' '{(r1 r2)}←la f1 a1' '{(r1 r2)}←la f1(a d)' '{(r1 r2)}←{la2}f1 a1' '{(r1 r2)}←{la2}f1(a d)'
    FH,← '(lo f1) a1' '(lo f1)(a d)' 'la (lo f1) a1' 'la (lo f1)(a d)' '{la2}(lo f1) a1'
    FH,← '{la2}(lo f1)(a d)' 'R←(lo f1) a1' 'R←(lo f1)(a d)' 'R←la (lo f1) a1' 'R←la (lo f1)(a d)'
    FH,← 'R←{la2}(lo f1) a1' 'R←{la2}(lo f1)(a d)' '{R}←(lo f1) a1' '{R}←(lo f1)(a d)' '{R}←la (lo f1) a1'
    FH,← '{R}←la (lo f1)(a d)' '{R}←{la2}(lo f1) a1' '{R}←{la2}(lo f1)(a d)' '(r1 r2)←(lo f1) a1' '(r1 r2)←(lo f1)(a d)'
    FH,← '(r1 r2)←la (lo f1) a1' '(r1 r2)←la (lo f1)(a d)' '(r1 r2)←{la2}(lo f1) a1' '(r1 r2)←{la2}(lo f1)(a d)' '{(r1 r2)}←(lo f1) a1'
    FH,← '{(r1 r2)}←(lo f1)(a d)' '{(r1 r2)}←la (lo f1) a1' '{(r1 r2)}←la (lo f1)(a d)' '{(r1 r2)}←{la2}(lo f1) a1' '{(r1 r2)}←{la2}(lo f1)(a d)'
    FH,← '(lo f1 ro) a1' '(lo f1 ro)(a d)' 'la (lo f1 ro) a1' 'la (lo f1 ro)(a d)' '{la2}(lo f1 ro) a1'
    FH,← '{la2}(lo f1 ro)(a d)' 'R←(lo f1 ro) a1' 'R←(lo f1 ro)(a d)' 'R←la (lo f1 ro) a1' 'R←la (lo f1 ro)(a d)'
    FH,← 'R←{la2}(lo f1 ro) a1' 'R←{la2}(lo f1 ro)(a d)' '{R}←(lo f1 ro) a1' '{R}←(lo f1 ro)(a d)' '{R}←la (lo f1 ro) a1'
    FH,← '{R}←la (lo f1 ro)(a d)' '{R}←{la2}(lo f1 ro) a1' '{R}←{la2}(lo f1 ro)(a d)' '(r1 r2)←(lo f1 ro) a1' '(r1 r2)←(lo f1 ro)(a d)'
    FH,← '(r1 r2)←la (lo f1 ro) a1' '(r1 r2)←la (lo f1 ro)(a d)' '(r1 r2)←{la2}(lo f1 ro) a1' '(r1 r2)←{la2}(lo f1 ro)(a d)' '{(r1 r2)}←(lo f1 ro) a1'
    FH,← '{(r1 r2)}←(lo f1 ro)(a d)' '{(r1 r2)}←la (lo f1 ro) a1' '{(r1 r2)}←la (lo f1 ro)(a d)' '{(r1 r2)}←{la2}(lo f1 ro) a1' '{(r1 r2)}←{la2}(lo f1 ro)(a d)'

    :Namespace test1
⍝ This ns is used for testing ]supdate. It is written as strange as possible to cover many angles.
⍝ Vars a-g are defined, 'e' also inside other elements like fns
⍝ 'e' and <foo> will be deleted, some added, like xx and
        a←⍳9
          d0←{
              e←dsa     ⍝ 'e'
              {dsa}}
        ∇ foo
          e←'dsa'       ⍝ 'e'
        ∇
        b←'dsa'
          d1←{
              ∇ foo     ⍝ <foo>
          }
        c←1 2 21
        :namespace X
            e←21        ⍝ 'e'
            :namespace Y
                ∇ foo⍝  ⍝ <foo>
                ∇
            :endnamespace
        :endnamespace
        d←'dsdsa'
          d3←{
              e←321
    ⍝ another fn to be deleted
          }
        d4←{⍵}
        e←-890
        :class C
            e←21
            ∇ {x}←foo x
            ∇
        :endClass
        f←⍳8 9
        ∇ hoo
          z←{
              1000<foo←⍵*2:⍵
      ⍝∇foo       ⍝ <foo>
          }21
        ∇
        g←2 3 4⍴⍳99
    :EndNamespace

    ∇ qa;names;src;P
      {}÷('f1' '')≡∪(fnNameOf¨FH),⊂''
      src←⎕SRC test1 ⍝ keep a copy
      names←test1.⎕NL-⍳9
      test1.⎕EX¨'e' 'foo' 'd3' 'b' ⍝ erase e, foo
      test1.(a xx d3)←⍳¨2 3 4 ⍝ mod 'a', add xx, change type of 'd3'
      test1.⎕FX'joo' '21' ⍝ add <joo>
      test1.⎕FX'hoo' '321' ⍝ change <hoo>
      test1.b←{⍵}∘(⍳2 2) ⍝ make b an illegal object and
      test1.koo←','∘, ⍝ add an illegal object (both impossible to write)
      P←⎕NS'' ⋄ P.Arguments←,⊂(⎕CS''),'.test1'
      ##.THIS←#
      Run'supdate'P
      {}÷(test1.⎕NL-⍳9)≡'joo' 'xx',⍨names~,¨'foo' 'e'
    ∇

:Endnamespace ⍝ supdate  $Revision: 1519 $
