﻿:namespace VersionControl ⍝ V1.31
⍝ Implement subversion commands within Spice
⍝                  This version assumes that a repository already exists (it does not create one).
⍝ 2015 05 21 Adam: NS header
⍝ 2016 04 07 DanB: use JOT as separator for workdir
⍝ 2016 05 26 Adam: help for ]?delete
⍝ 2016 05 28 Adam: use ⎕SE.SALTUtils.PATHDEL as separator for workdir
⍝ 2017 06 02 Adam: disable SVN ucmds

    enableSVN←0

    ⎕io ⎕ml←1

    ∇ r←defConstants uni
      :If uni ⋄ r←⎕UCS 13 10
      :Else ⋄ r←⎕AV[4 3]
      :EndIf
    ∇

    (CR LF)←defConstants 80=⎕dr'' ⍝ note: put SubVersion in the help

    AllCmds←      'Commit' 'CheckOut' 'Import' 'Export' 'Diff' 'Status' 'Add' 'Delete()' 'Update' 'Resolve'
    Nargs←'1SL -m= -clean' '2'        '2L -m ' '2SL   ' '1L  ' '1SL   ' '2L ' '1L      ' '1SL   ' '1SL'
    Syntax←⍬
    Syntax,←⊂'commit [file] -m=message' 'Commit (Checkin) all changes in the file (or current dir) to its repository'
    Syntax,←⊂'checkout repository location' 'Check out a working copy from a repository'
    Syntax,←⊂'import path repository' 'Import [a PATH] into a repository'
    Syntax,←⊂'export repository location' 'Produce a snapshot of the repository'
    Syntax,←⊂'diff file' 'Show the difference between 2 revisions or paths'
    Syntax,←⊂⊂'Show the status of the working directory or the arg supplied'
    Syntax,←⊂'add object file' 'Save object in file and add it to the working directory'
    Syntax,←⊂⊂'Remove files and directories from version control'
    Syntax,←⊂⊂'Update current workdir from the repository'
    Syntax,←⊂⊂'Tell svn we have solved a conflict with file X'

    ∇ ferase file
      :Trap 0 ⋄ file ⎕NERASE file ⎕NTIE 0 ⋄ :EndTrap
    ∇

    ∇ nf←chk f;try;gettmp
      ferase f ⍝ ensure absent
      try←{19 22::0 ⋄ 1⊣⍵ ⎕NERASE ⍵ ⎕NCREATE 0}
      →0/⍨try nf←f
      →0/⍨try nf←'/tmp/',f
      →0/⍨try nf←'/',f
      :If ⎕SE.SALTUtils.WIN
          'gettmp'⎕NA'U kernel32∣GetTempPath* U >0T'
          →0/⍨try nf←⊃↑/gettmp 240 240
      :EndIf
      ⎕←'*** Unable to create redirection files'
    ∇

    ∇ r←List;n;desc
      :Access Shared Public
      n←⍴AllCmds
      r←⎕NS¨n⍴⊂''
      r.(Group Parse)←⊂'SVN' ''
      r.Parse←Nargs ⍝ the others later
      r.Name←AllCmds~¨⊂'()'
     ⍝ r[AllCmds⍳⊂n].MinLen←⊢/⍴n←'Delete'
     
      desc←'Check in (commit) the current SALT workdir' 'Checkout the current SALT workdir'
      desc,←'Import a folder into a database' 'Export the database to a folder'
      desc,←'Find the difference between 2 versions' 'Show the status of the current workdir'
      desc,←'Add a script to the current workdir' 'Delete a script from the current workdir'
      desc,←'Update the current workdir from the database' 'Resolve a conflict'
      r.Desc←desc
      r/⍨←enableSVN
    ∇

    addDQ←{</'" '∊⍵: 1⌽'""',⍵ ⋄ ⍵}∘⎕se.SALTUtils.fixFsep ⍝ add " even if not WIN
    addExt←{v←⎕SE.SALTUtils.addExt(-lq←'"'∊¯1↑⍵)↓⍵ ⋄ v,lq/'"'}
    fileURL←{∨/'://'⍷⍺⊃v←⍵:⍵ ⋄ (⍺⊃v),⍨←'file://' ⋄ v} ⍝ add FILE:// before ⍺th element
    if←/⍨
    splitStr←{⍺←' ' ⋄ (1↓¨((s=⍺)>≠\'"'=s)⊂s←⍺,⍵)~⊂''}

    ∇ cleanSlab
    ⍝ Erase current output files - they should be in the current directory
      ferase¨Fmsg Ferr
    ∇

    ∇ str←contentsOf file;type;tie
      type←⎕DR'' ⋄ tie←file ⎕NTIE 0
      str←⎕NREAD tie type(⎕NSIZE tie)
      ⎕NUNTIE tie
    ∇

    ∇ r←enList vtv
      r←1↓∊CR,¨vtv~¨LF
    ∇

    ∇ output←grabOutput
      output←contentsOf¨Fmsg Ferr
    ∇

    ∇ wd←currentWorkdir
      wd←''⎕SE.SALTUtils.ClassFolder⍨(∧\~wd∊⎕SE.SALTUtils.PATHDEL)/wd←⎕SE.SALT.Settings'workdir'
    ∇

    ∇ r←sendCmd arg ⍝ send command to OS, grab all output
      r←⎕CMD arg,CmdRedirect
      r←enList r,grabOutput
    ∇

    ∇ file←file findName Args;m;obj
      :If m←0<⍴Args ⋄ :AndIf 9∊##.THIS.⎕NC obj←1⊃Args
          file←(##.THIS⍎obj).SALT_Data.SourceFile ⍝ only for ⎕SRCed objs, not fns
      :ElseIf m
          file←file ⎕SE.SALTUtils.{addExt((isRelPath p)/⍺,FS),p←fixFsep ⍵}1⊃Args
      :EndIf
      file←addDQ file
    ∇

    ∇ r←Run(Cmd A);ref;name;wd;FS;lines;file;b;Args;msg;ext;f0;last;hasver;isspace;obj;ver
      :Access Shared Public
     
      (Fmsg Ferr)←chk¨'svnmsg.txt' 'svnerr.txt' ⍝ we may not have permission to write these files...
      CmdRedirect←' >',Fmsg,' 2>',Ferr
     
      Args←{b←'\'∊⍨v←⍵ ⋄ (b/v)←'/' ⋄ v}¨A.Arguments
      FS←{(1+2×':'∊2↑⍵)⊃3↑⍵}wd←currentWorkdir
      r←'*** Unknown SVN command'
     
      :Select AllCmds⍳⊂Cmd
      :Case 9 ⍝ 'svnupdate' ⍝ [PATH]
         ⍝ Updating a file that is already versioned in SALT requires that we juggle files a bit
          :If hasver←0<⍴Args ⍝ there must be a file
              (file ver)←⎕SE.SALTUtils.{(⊂fn),ListVersions/FS splitLast,fn←fixFsep ⍵}wd findName Args
          :AndIf hasver←0<⍴ver~0 ⋄ (name ext ext)←⎕SE.SALTUtils.splitName file
              ⎕SE.SALTUtils.fileErase f0←name,'.0.',ext
              f0 ⎕SE.SALTUtils.fileMove⍨file←name,'.',ext ⍝ take a backup
              last←name,'.',(⍕⌈/ver),'.',ext
              last ⎕SE.SALTUtils.fileCopy file ⍝ make the file to update
          :Else ⋄ file←1⊃Args,⊂wd
          :EndIf
          r←sendCmd'svn update ',addDQ file
          ⍝ We cannot bring in the files because they won't ⎕FIX properly if there is a conflict
          :If 0<⍴lines←¯1↓CR splitStr r ⍝ reload everything mentioned
              r←r,CR,'Files should be edited outside APL then brought in in case of conflict'
          :ElseIf hasver
              file ⎕SE.SALTUtils.fileCopy name,'.',(⍕1+⍎ver),'.',ext
          :EndIf
     
      :Case 1 ⍝ 'svnci'     ⍝ [PATH] -m=comment
          'You must enter a comment with -m='⎕SIGNAL 11 if A.m≡r←0
          file←⊃{⍺,'.',⍵}/(name ext)←1 0 1/⎕SE.SALTUtils.splitName wd findName Args
          :If A.clean
              ⎕SE.SALT.RemoveVersions file,' -all -collapse'
          :EndIf
          r←sendCmd'svn ci ',file,1⌽'" -m "',A.m~'"'
     
      :Case 5 ⍝ 'svndiff'   ⍝ [file]
          :If ∧/(r←sendCmd'svn diff ',wd findName Args)∊CR,' '
              r←'(no difference)'
          :EndIf
     
      :Case 6 ⍝ 'svnstatus' ⍝ [PATH], default current folder
          r←sendCmd'svn status ',addDQ 1⊃Args,⊂wd
     
      :Case 10 ⍝ 'svnresolve'⍝ [PATH]
      ⍝ We can either try to resolve a conflict by supplying the name of
      ⍝ an object whose source filename will be used, or by supplying a
      ⍝ filename ourselves which may or may not be relative
          r←sendCmd'svn resolved ',wd findName Args
     
      :Case 7 ⍝ 'svnadd'    ⍝ file
          (obj file)←Args
          file←⎕SE.SALT.Save(##.THIS⍎obj)file
          r←sendCmd'svn add ',addDQ file
     
      :Case 8 ⍝ 'svndelete' ⍝ PATH|URL
          r←sendCmd'svn delete --force ',wd findName Args
     
      :Case 2 ⍝ 'svnco'     ⍝ URL [PATH]
      ⍝ We grab a copy from the database
          :If ⎕SE.SALTUtils.isRelPath file←2⊃Args ⋄ (2⊃Args)←wd,FS,file ⋄ :EndIf
          r←sendCmd'svn co ',⍕addDQ¨1 fileURL Args
      ⍝ If the command was successful we set the working directory in SALT
          :If ~'svn:' '''svn'∊⍨⊂4↑r~CR
              r,←'New workdir=',⎕SE.SALT.Settings'workdir ,',2⊃Args
          :EndIf
     
      :Case 4 ⍝ 'svnexport' ⍝ URL PATH
          r←sendCmd'svn export ',⍕addDQ¨¯2↑(⊂wd),Args
     
      :Case 3 ⍝ 'svnimport' ⍝ PATH URL -m message
          msg←'-m ',addDQ'Imported from APL'A.Switch'm'
          r←sendCmd'svn import ',⍕(addDQ¨2 fileURL Args)msg
     
      :EndSelect
      cleanSlab
    ∇

    ∇ r←{l}Help Cmd
      :Access Shared Public
      r←((AllCmds~¨⊂'()')⍳⊂Cmd)⊃Syntax,'?'
      r←↑r,⊂'** If the arguments to the cmd include spaces remember to supply "double quotes" around it'
    ∇

:Endnamespace ⍝ VersionControl  $Revision: 1472 $
