﻿:namespace system ⍝ V1.06
⍝ Show loaded assemblies in memory
⍝ 2015 05 22 Adam: NS header
⍝ 2018 04 16 Adam: [14781] explicit ".NET"
⍝ 2019 01 16 Adam: help

    ⎕IO←1 ⋄ ⎕ML←1
    
    DESC←'List all .NET assemblies currently loaded into memory'

    ∇ r←List
      r←⎕NS ⍬
    ⍝ Name, group, short description and parsing rules
      r.Name← 'Assemblies'
      r.Group←'MSWIN'
      r.Desc←DESC
      r.Parse←''
      r/⍨←⎕SE.SALTUtils.WIN
    ∇

    ∇ r←Run(Cmd Args);⎕USING
      :Select Cmd
      :Case 'Assemblies'
          r←'* No .NET assemblies currently loaded'
          :Trap 90
              ⎕USING←'System'
              r←↑⍕¨AppDomain.CurrentDomain.GetAssemblies
          :EndTrap
      :EndSelect
    ∇

    ∇ r←l Help Cmd
      :Select Cmd
      :Case 'Assemblies'
          r←DESC('    ]',Cmd)
      :EndSelect
    ∇

:Endnamespace
 ⍝ system  $Revision: 1512 $ 
