:Namespace view ⍝ V1.05
⍝ Evaluate and view in a read-only Editor window
⍝ 2021 08 12 Adam Inital code, show non-tacit as ⎕VR, handle dyadic ops
⍝ 2021 08 13 Adam Adjustable boxing with ]box -view=
⍝ 2021 11 05 Adam better error with missing argument
⍝ 2022 04 17 Adam consider ucmd only if first non-space is ]

    ⎕IO←1 ⋄ ⎕ML←1

    ∇ r←List
      (r←⎕NS ⍬).(Name Group Parse Desc)←'View' 'Output' '' 'Evaluate and view in a read-only Editor window'
    ∇

    ∇ Run(cmd input);output;tmp
      :If input∧.=' '
          'argument required'⎕SIGNAL 705
      :ElseIf ']'=⊃input~' '
          output←##.THIS ⎕SE.UCMD input
      :ElseIf 4.3=##.THIS.⎕NC⊂input      ⍝ tacit op
          output←##.THIS.⎕OR input
      :ElseIf 4=##.THIS.⎕NC input        ⍝ tradop/dop
          output←##.THIS.⎕VR input
      :Else
          output←##.THIS⍎input
      :EndIf
     
      :If 3.3 4.3∊⍨⎕NC⊂'output'   ⍝ tacit
          :Trap 11 ⍝ We need to get the ⎕OR from the right root namespace, but we cannot determine which one that is
              output←(⎕EX'output')⊢output #.{aa←⍺⍺ ⋄ ⎕OR'aa'}⍬   ⍝ try #
          :Else
              output←(⎕EX'output')⊢output ⎕SE.{aa←⍺⍺ ⋄ ⎕OR'aa'}⍬ ⍝ then ⎕SE
          :EndTrap
      :ElseIf 3.1 3.2 4.1 4.2∊⍨⎕NC⊂'output'   ⍝ trad/dfn/op
          output←(⎕EX'output')⊢⎕VR'output'
      :EndIf
      :If 2=≡output               ⍝ nested
      :AndIf 1=≢⍴output           ⍝ vector of
      :AndIf ∧/0 2∊⍨10|⎕DR¨output ⍝ character
      :AndIf ∧/1=≢∘⍴¨output       ⍝ vectors
           ⍝ leave as-is
      :ElseIf ⊃'Dyalog.Out.Filter'⍷⍥⌽∊⎕SE.onSessionPrint
      :AndIf (⎕SE.Dyalog.Out.B.style≡'max')∨(⊂≢⊆)output ⍝ max or nested/⎕OR
          output←output ⎕SE.Dyalog.Out.Filter 3 ⍝ simulate non-suspension, return "image" instead of printing
      :EndIf
     
      ##.THIS ⎕SE.Dyalog.Utils.View output
    ∇

    ∇ res←lvl Help cmd
      res←,⊂List.Desc
      res,←⊂'    ]',cmd,' ⍳2 3           ⍝ view the result of ⍳2 3 in a read-only Editor window'
      res,←⊂'    ]',cmd,' ]Display ⍳2 3  ⍝ view the result of the user command ]Display with the argument "⍳2 3"'
      res,←⊂''
      res,←⊂'NOTE:  Boxing of ]',cmd,'''s output is controlled by ]box on -view={non|min|mid|max}.'
      res,←⊂'       ]Box -?? ⍝ for details and examples'
    ∇
:EndNamespace
