﻿:Namespace wsc ⍝ V1.23
⍝ Objects comparison utility made from ws 'compare' for V11
⍝ 2015 05 22 Adam: NS header and auto Version
⍝ 2017 05 26 Adam: message if no differences found
⍝ 2017 05 28 Adam: Desc casing
⍝ 2017 06 05 Adam: fix failure to load compare.code if SALT folder is not in workdir
⍝ 2018 04 12 Adam: report more specific errors
⍝ 2018 05 08 Adam: help tweaks
⍝ 2018 05 31 Adam: [15757] suppress wrong message
⍝ 2018 11 13 Adam: add help level, tweak text
⍝ 2021 02 18 Adam: ⎕C
⍝ 2023 02 19 Adam: check r length instead of the missing FOUNDDIFFS

⍝ Because there are many commands starting with 'compare' we do not use the cmd name but
⍝ the GROUP name for all Object Types (1-4)

    (⎕IO ⎕ML)←1

    CompareCode←⎕SE.SALT.SALTFOLDER,'spice/compare.code -nolink -noname' ⍝ this is where all the real code resides

    ∇ r←Version;⎕ML
      ⎕ML←1
      r←⊢/∊'V'⎕VFI⊃⎕SRC ⎕THIS
    ∇

    AllCmds←4⍴⊂'Compare' ⍝ the same command name for all here - this is a special case
    lGroups←⎕se.Dyalog.Utils.lcase¨ Groups← 'WS' 'Array' 'FN' 'File'


    ∇ r←List;CompCode
      r←⎕NS¨(⍴AllCmds)⍴⊂⍬
     ⍝ Name, group, short description and parsing rules
      r.Name←AllCmds
      r.Group←Groups
      r.Desc←'Compare two '∘,¨'workspaces' 'variables/arrays' 'functions' 'component files'
      CompCode←⎕SE.SALT.Load CompareCode
      r.Parse←'1-2' '2' '2' '2',¨⍕¨CompCode.(Sets/¨⊂cSw)
    ∇

    ∇ r←Run(Cmd Args);CompCode
      CompCode←⎕SE.SALT.Load CompareCode
      CompCode.ZONE←CompCode._ZONE Args.Switch'window'
      CompCode.SHOW←CompCode._SHOW Args.Switch'show'
      CompCode.NLINES←CompCode._NLINES Args.Switch'nlines'
      CompCode.DELINS←CompCode._DELINS Args.Switch'delins'
      CompCode.(NOLASTLINE NSSRC EXSTRING EXNAMES TRIM)←Args.Switch¨'nolastline' 'nssrc' 'exstring' 'exnames' 'normalize'
      CompCode.TS←Args.Switch'ts'
      CompCode.NAMECLASS←0 Args.Switch'nameclass'
     
      :Select lGroups⍳⊂##.Group
      :Case 1 ⍝ 'ws.compare'
          r←CompCode.compare Args
      :Case 3 ⍝ 'fns.compare'
          'Invalid function name'⎕SIGNAL 11↓⍨∧/(##.THIS.⎕NC↑Args.Arguments)∊3 4
          r←##.THIS CompCode.comp2fn Args
      :Case 2 ⍝ 'array.compare'
          'Invalid variable name'⎕SIGNAL 11↓⍨∧/(##.THIS.⎕NC↑Args.Arguments)∊2 9
          r←##.THIS CompCode.comp2var Args
      :Case 4 ⍝ 'file.compare'
          :Trap 0
              r←CompCode.compfiles Args
          :Else
              :If ×≢⎕DMX.Message
                  r←'* Command Execution Failed: ',⎕DMX.Message
              :Else
                  ⎕SIGNAL ⎕EN
              :EndIf
          :EndTrap
      :EndSelect
      :If 0=≢r
          r←'[no differences found]'
      :EndIf
    ∇

    ∇ r←lev Help Cmd;⎕ML;i;obj;c;CR;GROUP
      ⎕ML←1 ⋄ i←lGroups⍳⊂##.Group ⋄ CR←⎕AV[4] ⋄ c←⎕SE.SALT.Load CompareCode
      r←(0⌈lev-1)c.Help i
      :If 0=lev
          GROUP←1 ⎕C ##.Group
          r←(¯1↓(r⍳'.')↑r)('    ]',GROUP,'.Compare ',##.Group,'1 ',##.Group,'2')('    ]',GROUP,'.Compare -?? ⍝ for more information')
      :Else ⍝ 1 or 2
          :If i=1
              r,←CR,CR,'Example:',CR,'    ]ws.compare \qa\ws\testkeep =\testcompare'
          :AndIf lev>1
              r←CR,c.Describe
          :Else ⍝ 1
              :If lev=1
                  r,←CR,CR,']',##.Group,'.',Cmd,' -???  ⍝ for full documentation'
              :EndIf
          :EndIf
      :EndIf
    ∇

:EndNamespace ⍝ wsc  $Revision: 1816 $
