﻿:Namespace docum ⍝ V1.19
⍝ Implements wsdoc as a UCMD
⍝ 2015 05 21 Adam: NS header and auto Version
⍝ 2016 02 17 DanB: make it start at #
⍝ 2018 05 05 Adam: Help overhaul
⍝ 2019 02 04 Adam: help

    ⎕IO←1 ⋄ ⎕ML←1

    Rules←'-file= -items= -pw= -noprompt -xref -noclass'

    AllCmds←,⊂'Document'

    ∇ r←Version
      r←⊢/∊'V'⎕VFI⊃⎕SRC ⎕THIS
    ∇

    ∇ r←List
      r←⎕NS¨0/¨AllCmds
   ⍝ Name, group, short description and parsing rules
      r.Name←AllCmds
      r.Group←⊂'WS'
      r[1].Desc←'List (part of) the workspace content, displaying each item separately'
      r.Parse←⊂Rules
    ∇

    ∇ r←Run(Cmd Input)
      r←0 0⍴'' ⋄ # wsdoc Input
    ∇

    ∇ r←level Help Cmd;Ind
      r←,⊂'List (part of) the workspace content, displaying each item separately'
      r,←⊂'    ]',Cmd,' [<items>] [-items=<types>] [-file=<file>] [-noprompt] [-pw=<w>] [-xref]'
      r,←⊂''
      :If level>0
          Ind←'                  '∘,¨
          r,←⊂'<items>       if specified, restricts listing to these specific items (defaults to no restrictions)'
          r,←⊂'-items=       the items to list (trailing "/" means "list only name, do not list contents"). Multiple items must be space-separated and the list must be in quotation marks. Must be one or more of:'
          r,←Ind ITEMS
          r,←⊂'-file=<file>  output to file. Any "⍵" in the name will be replaced by the workspace name.'
          r,←⊂'-noprompt     do not ask before overwriting existing file'
          r,←⊂'-pw=<w>       use this width to fold items'
          r,←⊂'-xref         produce a cross reference of objects, listing the type with the following codes:'
          r,←Ind 'RS  result' 'LA  left argument' 'RA  right argument' 'LO  left operand' 'RO  right operand'
          r,←Ind'LN  local name' 'LL  local label' 'QV  system variable' 'QF  system function' 'KW  keyword'
          r,←4↓¨Ind⊂'and a symbol indicating usage with the following symbols:'
          r,←Ind':   label' '(←  assigned within parens' ')←  modified assignment' 'f←  fn assigned' '∘←  jot assigned'
          r,←Ind'?←  uncertain' '[   [index]' '?   questionnable' '!←  should be verified'
          r,←'' 'Example:'
          r,←⊂'    To show the functions'' names and code as well as the names (only) of objects, and output to a file with the same name as the workspace:'
          r,←⊂'        ]',Cmd,'  -file=/tmp/⍵  -noprompt  -items="fns obs/"'
      :Else
          r,←⊂']',Cmd,' -??  ⍝ for more information and example'
      :EndIf
    ∇

    xCut←{⍺←1↑⍵ ⋄ 1↓¨(⍵∊⍺)⊂⍵} ⋄ rTb←{⍺←' ' ⋄ ⍵↓⍨-⊥⍨⍺=⍵}

    ITEMS←xCut' salt wsid fns fns/ vars vars/ obs obs/'

    CR←⎕ucs 13 ⋄ NL←(~⎕SE.SALTUtils.WIN)↓CR,⎕ucs 10


    ∇ {src}wsdoc arg;cmd;put;scfmt;tn;nm;t;j;c;ok;list;cannot;PW;items;done;i;b;mod
⍝ Easy workspace documentation routine.    /LHG  22Jan10 modified 2012 by DanB
⍝ Switch <file> is the name of the file to which output is to be written.
⍝ The file is created if it does not exist; otherwise, the user is prompted to determine whether
⍝ or not the existing file should be overwritten unless switch -nopromt is used.
⍝ <cmd> specifies the level of documentation desired.  It is a list of names identifying
⍝ the items to document.
⍝ Switch items may contain one or more of
⍝
⍝       wsid       Displays the workspace name and saved timestamp
⍝       fns        Displays the list of functions, optionally followed by the definition of each
⍝       vars       Displays the list of variables, optionally followed by the value of each
⍝       obs        Displays the list of objects, optionally followed by the definition of each
⍝
⍝ which may optionally be followed by '/' to avoid expansion of the related namelist
⍝ into individual members for documentation.
⍝
⍝ If <cmd> is empty, the default documentation level of  wsid, fns, vars and obs/  is used.
     
⍝ This fn may also be used stand-alone, i.e. without being called as a user command.
     
    ⍝ src is the source namespace defaulted to the calling environment.
      :If 0=⎕NC'src' ⋄ src←⍬⍴⎕RSI ⋄ :EndIf
     
      :If 326≠⎕DR arg ⋄ arg←(⎕NEW ⎕SE.Parser Rules).Parse arg ⋄ :EndIf
     
      items←∪(xCut' ',arg.items~0)~⊂''
      ('Invalid item. Must be in ',⍕ITEMS)⎕SIGNAL 11↓⍨∧/items∊ITEMS
      :If 0<⍴cmd←arg.Arguments ⋄ cmd←~∘' '¨↓src ⎕SE.UCMD'nameslike ',(⍕cmd),' -noclass' ⋄ :EndIf
     
      :If 0∊⍴cmd←cmd,')',¨items
          cmd←')wsid' ')fns' ')vars' ')obs/' ⍝ Default documentation level
      :EndIf
     
      cmd←cmd[⍒cmd∊⊂')wsid']                 ⍝ put )WSID at the top
     
      put←{ ⍝ Display or write output to file adding NL to file
          ⍺=0:⍵,CR
          t←CR ⎕R NL ⎕OPT'Mode' 'D'+⍵,CR,CR
          (⎕UCS'UTF-8'⎕UCS t)⎕NAPPEND ⍺
      }
     
      scfmt←{ ⍝ Format matrix of names <⍵> in width <⍺> using system command output
          n←⌈/0,c←⌈(1++/⍵≠' ')÷8 ⍝ Number of 8-char groups required per name and max
          m←((n×⊃⍴⍵),8)⍴((⊃⍴⍵),n×8)↑⍵ ⍝ Pad and reshape to single-group width
          m←,(,c∘.≥⍳n)⌿m ⍝ Remove extraneous all-blank rows
          brk←{ ⍝ Find next line breakpoint
              ⍵≡'':⍵
              n←(⍺+1)⌊⍴⍵ ⋄ n←¯1↑⍺,¯1+(' '=n↑⍵)/⍳n ⋄ ¯1↓(n↑⍵),CR,⍺ ∇{(∨\⍵≠' ')/⍵}n↓⍵
          }
          ⍺ brk m ⍝ Compute and insert breakpoints
      }
     
      cannot←{''≢⍵:tn put'Cannot process <',⍵,'>'}
     
      :If tn←PW←0≢t←arg.file
          :If '⍵'=¯1↑t ⋄ t←(¯1↓t),(-⊥⍨~i∊'/\')↑i←⎕WSID ⋄ :EndIf
          :Trap 22 ⍝ Handle pre-existing file
              tn←t ⎕NCREATE 0 ⍝ Create output file if warranted
          :Else
              :If arg.noprompt=0
                  ⎕←'Output file "',t,'" already exists.' ⋄ ⍞←i←'Reuse existing file? ' ⋄ →('y'∊⊃(⍴i)↓⍞)↓0
              :EndIf
              tn←t ⎕NTIE 0 ⋄ 0 ⎕NRESIZE tn ⍝ Tie and truncate file
          :EndTrap
          ⎕←'Output file = ',t ⍝ All other output goes to file
          PW←1⊃,74 arg.Switch'pw' ⍝ 74 is the max displayable chars on a letter page by default (10pt APL385)
      :EndIf
     
      done←src ⍝ list of nss processed (to avoid looping)
     
⍝ Loop to process next item.
      :While 0<⍴cmd
          nm←1⊃cmd ⋄ ok←0 ⋄ cmd←1↓cmd
          :Select ⌊c←+/src.⎕NC⊂nm
          :Case ¯1
              list←~'/'∊nm ⋄ ok←')'∊1↑nm←nm~'/'
              :If ')wsid'≡nm
                  t←{0::'' ⋄ ⎕USING←'' ⋄ t←(⎕NEW System.IO.FileInfo(⊂⎕WSID{⍺,(~'.'∊⍺)/⍵}'.dws')).LastWriteTime ⍝ Get workspace saved date (Windows only)
                      1900≥t.Year:''
                      ,'< * saved >,ZI4,2G</99>,X1,2G<99:>,ZI2'⎕FMT 1 6⍴t.(Year Month Day Hour Minute Second)}0 ⍝ Zero date for clear ws
                  tn put'      ',nm,CR,⎕WSID,t  ⍝ Emit workspace info
              :ElseIf 3≥i←')fns' ')vars' ')obs'⍳⊂nm
                  tn put'      ',nm,CR,⎕PW PW[1+tn≠0]scfmt c[j←⍋c←↑t←src.⎕NL-,0.1 0.2 0.3∘.+i⊃(3 4)2 9;] ⍝ Sort and emit names
                  cmd,⍨←list/t[j]  ⍝ If not in compression mode, prepend identifier list in sorted order
              :EndIf
          :CaseList 3 4
              :If 0∊⍴t←src.⎕VR nm⊣ok←1            ⍝ Function (or operator):  get vector rep and check scope
                  t←'     ⍫ ',nm,CR,'     ⍫'      ⍝ Compose canonical locked rep
              :ElseIf 326∊⎕DR t
                  t←src ⎕SE.Dyalog.Utils.drvSrc nm
              :Else
                  t←'(∇|^\[\d+\]   ) *'⎕R'\1'⊢t
                  :If ' '≠1↑t↓⍨i←t⍳'∇' ⋄ t←t[⍳i],' ',i↓t ⋄ :EndIf ⍝ nice header display
                  :If '.'∊nm ⋄ mod←,
                      :If 0.1=1|c⊣i+←+/∧\' '=i↓t  ⍝ don't do this for Dfns
                          mod←chgAPL
                      :EndIf
                      t←t[⍳i],(nm↓⍨-⊥⍨'.'≠nm)mod i↓t
                  :EndIf
                  (i j)←0 1 0 1/src.⎕AT nm ⋄ t,⍨←(×⍴j)/j,(,'I6,2G</99>,X1,2G<99:>,ZI2'⎕FMT 1 6⍴i),CR,CR ⍝ Prepend genealogy header
                  :If arg.xref
                      t,←src Xref nm
                  :EndIf
              :EndIf
              tn put((c=3.3)/'      ',nm,'←'),⍕t  ⍝ Emit function (special case for derived fn)
          :Case 2
              t←src⍎nm                     ⍝ Variable:  get value
              j←'Ref'                      ⍝ Compute data type
              i←10|⎕DR t
              :If (0∊⍴⍴t)⍲(0=≡t)∧i=6
                  j←'CBCI?FPD?X'[⎕IO+i]
              :EndIf
              j←'      ',nm,1⌽')  (type=',j,' ⍴⍴=',(⍕⍴⍴t),' ⍴=',(⍕⍴t),(0=⍴⍴t)/'⍬' ⍝ Name, rank, shape
              tn put j,,CR,⎕FMT t  ⍝ Emit variable
              ok←1
          :Case 9
              :If ok←c∊9.4 9.5 ⋄ tn put 1↓⊃,/CR,¨⎕SRC src⍎nm ⍝ Class/interface:  display source script
              :ElseIf ok←c∊9.1
              :AndIf ~(j←src⍎nm)∊done ⋄ done,←j
                  t←j.⎕NL ¯2 3 4 9      ⍝ Namespace:  prepend name list
                  cmd,⍨←(⊂nm,'.'),¨t{⍵:⍺ ⋄ ('SALT'∘≢¨4↑¨⍺)/⍺}items∊⍨⊂'salt'
                  tn put'      ',nm,CR,⍕src⍎nm  ⍝ Emit canonical display form before diving into contents
              :EndIf
          :EndSelect
          cannot(~ok)/nm
      :EndWhile
     
      ⎕NUNTIE tn ⍝ Untie output file before exiting
    ∇

    ∇ r←ns chgAPL t;i;j;b
      i←0 ⋄ j←rTb ¯1↓(⌊/t⍳'⍝;',CR)↑t    ⍝ If not in global scope, extract syntactic part of header
      j↓⍨←i+←{(∨/b)×1⍳⍨b←⍵∊'←'}j        ⍝ remove result. If no ' ' or ) in the string we're done
      :If ∨/b←j∊') '
          j↓⍨←-1+⊥⍨~j∊(1+¯1↑b)⊃') ' '(' ⍝ drop ra, if it ends with a ) we have an op
          :If ~'('∊j ⋄ i+←(⍴j)-⊥⍨~j∊' }'
          :Else ⋄ i+←1⍳⍨+\(j=' ')>⌽∨\'('=⌽j
          :EndIf
      :EndIf
      r←(i↑t),ns,i↓t                    ⍝ Introduce scoping structure to name
    ∇


    ⍝                    --------------- Xref code --------------

    FAC←⎕UCS 102+300×82≠⎕DR'' ⍝ 'f' symbol
    Qvn←xCut' ⎕AV ⎕AVU ⎕CT ⎕D ⎕DCT ⎕DIV ⎕DM ⎕DMX ⎕FR ⎕IO ⎕LX ⎕ML ⎕PATH ⎕PP ⎕PW ⎕RL ⎕RTL ⎕SD ⎕SM ⎕TC ⎕TRAP ⎕USING ⎕WSID ⎕WX' ⍝ System vars

      screenXref←{ ⍝ Find references and screen out bad ones
         ⍝ ⍵ is a ns containing match info
          s←⍴0⊃(s Bn O B L N)←⍵.(Match BlockNum Offsets Block Lengths Names)
          ⍺←1 ⋄ L O,←⊂0 0 ⋄ L⌈←0
          get←{L[i]↑O[i←N⍳⊂⍵]↓B}        ⍝ get match by name
         ⍝ If a name is within a Dfn we may not allow it
          dfok←⍺∨{~Dm[NLpos[¯1+1 0/⍵]+1+0 1/⍵]}Bn,1↑O  ⍝ line/pos (⍵) is NOT within a Dfn
         ⍝ Do we have a dotted name first?
          (stem m)←get¨'Stem' 'Symb' ⋄ rp←')'=¯1↑m ⍝ ...x)←?
         ⍝ We must take into account the nesting of parens, e.g. "(b c) d (e f) g←...", only e f g is certain
          ln←0,⍨∧\⌽~' )'∊⍨m←m∩VC,' :()' ⍝ last name always ok (if not a fn itself)
          ps←⌽ln<∧\ln∨⌽¯1↓0 0,0<-⌿+\'()'∘.=m ⋄ m←' ',{b\⍵/⍨b←~⍵∊'()'}m
          (ps m)←ps m{⍺/⍨⍵⍲1⌽⍵}¨⊂' '=m  ⍝ remove excess blanks and cut
          (ps nms)←ps m{1↓¨⍵⊂⍺}¨⊂' '=m ⋄ rp>←∨/ps←(1∊¨ps)
          dfok∨←(0∊⍴stem)≤'.'∊¨nms
          0=⍴nms←stem∘,¨dfok/nms:s↑''   ⍝ exit early if no names found
         ⍝ Parens assignment stops at the last ⎕fn (others are simple references)
          oka←⌽∧\⌽{(∨/b)≤(⊂⍵/⍨∨\b←'⎕'=⍵)∊Qvn}¨nms
         ⍝ Keep the juicy stuff, see if there was any f before ←
          rp>←e←0∊⍴ar←'[∘←'∩r←' ',get'Rez' ⋄ b←e⍱r[¯1+r⍳'←']∊VC,' :∘['
          ar,⍨←(b/FAC),':'∩r            ⍝ any function before ← or is : after?
         ⍝ Put a ( for names we KNOW are assigned, possibly including the LAST name
          ps←(dfok/(~(-⍴ps)↑1↑ln)/¨'?()'[ps+2×rp])~¨⊂(D∨e)/'?' ⍝ for Dfns the assignment is always assumed if not modified
          lab←ps,¨oka/¨⊂ar              ⍝ add ( for multiple and ? for all but the last
         ⍝ We record the data in Hits
          Hits⍪←nms,Bn,[0.1]lab         ⍝ replace by blanks the whole match
          s↑''}

    ⍝                Define the pattern to find names in a function header
    UC←(0≤⎕NC⍪⎕AV)/⎕AV                                                ⍝ all usable chars in a name

    _←'(?x)'                                                          ⍝ (?x) allows free format
    _,←CR,'(?(DEFINE) (?<C> [⎕',UC,'][',UC,'0-9]*+))'                 ⍝ define allowed characters in a name (C)
    _,←CR,'^((?<RS>[^←]*)←)?'                                         ⍝ result (RS)
    _,←CR,' (?<LA>(?<b2>\{)? \(? (?&C) (?(b2)(\s+(?&C))* \)? \}) )?'  ⍝ left arg  (LA)

    _,←CR,' \s*'                                                      ⍝ The name
    _,←CR,' (?<p3> \( )?'               ⍝ starts with a paren? If so
    _,←CR,' (?(p3)(?<LO>(?&C))\s)'      ⍝ look for the left operand
    _,←CR,'   (?<Main>(?&C))'           ⍝ look for the MAIN fn/op name  (Main)
    _,←CR,' (?(p3)(\s(?<RO>(?&C)))?\))' ⍝ look for the right operand
    _,←CR,' \s*'                        ⍝ possibly more spaces
    _,←CR,' (?(LA)(?![⍝;]|$))'          ⍝ and not at the end if we have a left arg

    _,←CR,' (?<p4>\()? (?<RA>(?&C) (?(p4) (\s(?&C))* \)) )?'          ⍝ right arg (RA)
    _,←CR,' \s*'
    _,←CR,' (?<LN>(;(?&C))*)'                                         ⍝ local names (LN)
    _,←CR,' \s*(⍝|$)'                                                 ⍝ (til) the end

    findNames←_ ⋄ ⎕ex'_'

    ∇ data←gatherAllNames w;B;typ;find;N;L;O
⍝ Find all the names mentioned in the header of a fn/op
⍝ w is a namespace containing regular expression information from a match
      (O L B N)←w.(Offsets Lengths Block Names) ⋄ data←0 2⍴0
      find←{⍺←' ' ⋄ (0≥1↑L[i])∨0∊⍴i←{⍵/⍳⍴⍵}N∊typ←⊂⍵:0 2⍴0 ⋄ typ,⍪xCut ⍺{⍵,⍨(⍺∊1↑⍵)↓⍺}(L[i]↑O[i]↓B)~'{}()'}
      data⍪←find'Main'    ⍝ The name of the fn
      data⍪←find'RS'      ⍝ The results
      data⍪←find'LA'      ⍝ The left arg
      data⍪←find'LO'      ⍝ The left operand
      data⍪←find'RO'      ⍝ The right operand
      data⍪←find'RA'      ⍝ The right arg
      data⍪←';'find'LN'   ⍝ The locals
     ⍝ A name may appear to have many types
    ∇

    ∇ xref←{srcns}Xref arg;b;c;i;j;k;nm;lns;msk;txt;⎕IO;⎕ML;type;D;n;h;sf;Hits;Set;pat;add;whr;NLpos;Dm;VC;is;S;show;fnm;LN
⍝ Compute cross-reference table for one or more functions. Original by LHG 30Mar78 modified in 2012 by DanB to use ⎕S/⎕R.
⍝ The right argument is a character array containing the names of the functions to process.
⍝ The optional switch -items specifies what is to be included in the analysis.
⍝ For ex: ⍎, if included, means that quoted strings apearing to the right of  ⍎  and <⎕TRAP> assignments are analyzed.
⍝ The optional switch -each specifies that the result will be partitioned by function analysed.
     
      ⎕ML←1 ⋄ ⎕IO←0
     
      :If 326≠⎕DR arg ⋄ arg←(⎕NEW ⎕SE.Parser'-items= -each -pw=').Parse arg ⋄ :EndIf
     
      whr←{⍵/⍳⍴⍵} ⋄ add←,∘(⊂⍣arg.each) ⋄ show←~arg.each
      is←{'(?<',⍺,'>',⍵,')'}                    ⍝ name a regular expression
      S←('Stem'is'(?&C)\.'),'?'                 ⍝ stem pattern
      VC←⎕D,⍨h←'.#⎕⍺⍵',UC                       ⍝ all valid chars in a name
      xref←''                                   ⍝ initialize result
     
     ⍝ Define the pattern defining a name: cannot start in the middle of a name (?<![',VC,']), starts with letter or #⎕⍺⍵,
     ⍝ followed by 0 or more (digits not preceded by . OR letter or .#⎕⍺⍵) and not ending with .
      Set←'(?(DEFINE)(?<C>(?<![',VC,'])[',(1↓h),']((?<!\.)[0-9]|[',h,'])*(?<!\.)))' ⍝ the pattern of an APL name
      Hits←0 3⍴0 ⋄ LN←'LN'
      :If 0=⎕NC'srcns' ⋄ srcns←⎕IO⊃⎕RSI ⋄ :EndIf     ⍝ source namespace
     
     ⍝ Process next function.
      :For fnm :In arg.Arguments                ⍝ Extract next function to process
         ⍝ Make sure we have a defined or dynamic function/operator
          :If 3.1 3.2 4.1 4.2∊⍨c←srcns.⎕NC⊂fnm
              :If 0∊⍴txt←srcns.⎕VR fnm          ⍝ Get function source and check if locked
                  xref add←show/CR,CR,'<',fnm,'> is a locked function'
              :Else
                  txt←(+/∧\txt∊' ∇')↓(-⊥⍨txt∊' ∇',CR)↓txt    ⍝ get rid of trailing and front decorators
                  txt←k↓txt↓⍨(-k←-D←0.2=1|c)×2+txt⍳'←'       ⍝ remove name from Dfns and outer {}s
                  lns←(txt=CR)∧1⌽txt='[' ⋄ msk←1             ⍝ Find line-delimiting CRs, and initialize inverse quote/comment mask
                  :If ∨/j←txt='''' ⋄ i←lns/≠\j ⋄ msk←=\j⍱lns\i≠¯1↓0,i ⋄ :EndIf         ⍝ Mark quoted strings, if any
                  :If ∨/j←msk∧txt='⍝' ⋄ i←j∨lns ⋄ k←i/j ⋄ msk>←j<≠\i\k≠¯1↓0,k ⋄ :EndIf ⍝ Mark comments, leaving ⍝'s in
                  j←msk∧txt∊'{}' ⋄ i←0≠+\¯1*'}'=j/txt ⋄ Dm←lns<¯1⌽≠\j\i≠¯1↓0,i ⍝ Mark text in D-fns
                  :If '⍎'∊arg.items
                      :If ∨/j←msk∧txt='⍎' ⋄ i←j∨lns∨msk∧txt∊'⋄⍝' ⋄ j←i/j ⋄ msk∨←≠\i\j≠¯1↓0,j ⋄ :EndIf ⍝ Handle executed quoted strings
                  :AndIf ∨/j←msk∧'⎕TRAP←'⍷txt ⋄ i←j∨lns∨msk∧txt∊'⋄⍝' ⋄ j←i/j ⋄ j←≠\i\j≠¯1↓0,j ⍝ Mark quoted strings to right of <⎕TRAP> assignment
                      i←txt='''' ⋄ msk∨←j>(¯1⌽i)∧(txt∊'CENS')∧1⌽i ⍝ Include them, less action code
                  :EndIf
                  (txt lns Dm)←msk∘/¨txt lns Dm ⍝ Compress out unwanted comments and quoted strings
                  h←D⌿4 2⍴,¨'LA' '⍺' 'LO' '⍺⍺' 'RO' '⍵⍵' 'RA' '⍵'
     
                  :If ~D                   ⍝ Parse function header in Trad fns.
                      h⍪←1↓0⊃findNames ⎕S gatherAllNames(i←txt⍳CR)↑txt ⋄ (txt lns Dm)←i↓¨txt lns Dm ⋄ NLpos←whr lns
                     ⍝ Find labels and :control structure keywords
                      sf←screenXref        ⍝ labels are always followed by :
                      txt←(Set,'^\[\d+] *\K',('Symb'is'(?&C)'),'Rez'is':')⎕R sf txt ⍝ and they are the first thing on a line
                      Hits⍪←(⊂,'→'),(+⌿NLpos∘.<whr txt='→'),[0.1]⊂''    ⍝ branch
                      txt←('(:For [',VC,' ]+) :In')⎕R'\1←   '+txt
                      txt←(Set,'Symb'is':(?&C)')⎕R sf txt               ⍝ keywords
                  :Else ⍝ Dfn
                      ((txt=':')/txt)←' '  ⍝ Ignore colons in D-fns -- not labels or control structures
                      (txt lns Dm),⍨←CR 1 0 ⍝ ensure text starts with CR
                      NLpos←whr lns
                  :EndIf
                  Hits⍪←(⊂,'⍎'),(+⌿NLpos∘.<whr txt='⍎'),[0.1]⊂''        ⍝ ⍎
     
            ⍝ Find identifiers and reference information. Keep anything in Dfns that may refer to a global.
     
                ⍝ Resolve assignment variants.
                  pat←Set,'\(((?&C)[^',VC,'()←]*←)' ⍝ first change any (X←...) by ?X←
                  txt←pat ⎕R'-\3'+txt
                  pat←Set,S,('Symb'is'\(*(?&C)\)*( ?\(*(?&C)\)*)*'),'Rez'is'∘←' ⍝ ∘ assignments (valid in Dfns)
                  txt←pat ⎕R screenXref txt
                  sf←0∘screenXref  ⍝ regular assignments (NOT valid in Dfns)
                  j←pat←pat~'∘'    ⍝ same wo the ∘
                  txt←pat ⎕R sf txt
                  pat←(¯2↓j),'[^\w\s[\]\r]+⍨?←)'   ⍝ function assignments (valid in Dfns)
                  txt←pat ⎕R screenXref txt
                 ⍝ Resolve indexed assignments.
                  pat←'[',VC,']+ [',VC,']+\K\[[^][]*\]' ⍝ eliminate any [] following vector followed by [...]
                  txt←pat ⎕R{1⌽'××',1↓¯1↓⍵.Match}txt    ⍝ to prevent false positives on A B[]
                  pat←Set,('Symb'is'(?&C)'),'Rez'is'\[' ⍝ [] assignments (valid in Dfns)
                  txt←pat ⎕R screenXref txt ⍝ not accounting for ]+←
                 ⍝ Whatever remains are simple references
                  pat←Set,S,'Symb'is'\(*(?&C)\)*( ?\(*(?&C)\)*)*' ⍝ regular refs (NOT valid in Dfns)
                  txt←pat ⎕R sf txt           ⍝ there should be no more IDs left after this
     
                 ⍝ Extract and sort identifiers.
     
                 ⍝ All the data in is Hits.
                  :If 0∊⍴Hits←Hits[S⍋⍕Hits[;⍳2];]⊣S←' :',VC   ⍝ we sort by line # within name:
                      xref add←show/CR,CR,'<',fnm,'> has no references'
                  :Else
                      c←({⍵≢¨¯1↓0,⍵}Hits[;0])⊂[0]Hits   ⍝ regroup by ID
                      (nm lns)←↓⍉↑{(⊃⍵)((⍕¨⍵[;1]-D),¨⍵[;2])}¨c   ⍝ to align numbers k wide use  (2↑⌈⌈/10⍟Hits[;1])∘⍕¨...
                     ⍝ ⎕names & :ctrl
                      type←'*' 'QF' 'KW' '*'[i←(~'.'∊¨nm)×' ⎕:'⍳⍬∘⍴¨nm] ⋄ type[k/⍨nm[k←whr i=1]∊Qvn]←⊂'QV'
                     ⍝ Labels. Mark unreferenced ones.
                      type[i←whr b←':'∊¨⍕¨0 0 1∘/¨c]←⊂'LL' ⋄ lns[i/⍨1∊¨⍴¨b/c],⍨←'?' ⋄ n←(nm⍳¨'.')↑¨nm
                     ⍝ Remove ⍺/⍵ if not a Dfn or if not there
                      :If ~D ⋄ (n nm type lns)←(~n∊,¨'⍺' '⍺⍺' '⍵' '⍵⍵')∘/¨n nm type lns ⋄ :EndIf
                     ⍝ Local names. Add any unreferenced header names.
                      :If D<1∊b←~j←n∊⍨k←h[;1]
                          (n nm lns type)←(n nm lns type),¨b∘⌿¨k k(⊂'')(h[;0])
                      :EndIf
                     ⍝ Mark all stems the same way
                      b←∨/i←⌽<\⌽n∘.≡j/k ⋄ i←⊂b/i+.×⍳+/j ⋄ type[whr b]←i⌷j/h[;0]
                      :If D ⍝⋄ type[whr b]←'LA' 'LO' 'RA' 'RO'[h⍳(b←nm∊h←,¨'⍺' '⍺⍺' '⍵' '⍵⍵')/nm]
                          b←{(⊂⍵~⎕D)∊,¨'←' '(←'}¨0⊃¨lns ⍝ locals in D-fns are those simply assigned first
                          b←b[n⍳n] ⍝ a and a.b are the same type
                      :Else ⋄ b←n∊k
                      :EndIf
                      type[whr b∧type∊'*']←⊂LN
                     ⍝ Resort need be
                      :If ∨/b ⋄ (n nm lns type)←i⌷⍨¨⊂⊂S⍋↑0⊃i←(n nm lns type) ⋄ :EndIf
                     ⍝ Show ? for locals only (if not ⎕var). ⎕ ∧ all ←:ok, ⎕ ∧ none ←:bad, ~⎕ and either all or none ←:bad
                      b←1,2≢/n ⋄ c←c/1=c←,↑⍴¨j←b⊂⍳⍴b ⍝ regroup and find non .names
                      :If 0<⍴i←whr b/type∊⊂LN ⋄ j[i]{∧/a←'←'∊¨l←⊃,/lns[⍺]:(⍺[0]⊃lns),⍨←(⍵∧0<⍴l)↓'?' ⋄ ∧/~a:(⍺[0]⊃lns),⍨←'?'}¨'⎕'=⍬∘⍴¨n[0⊃¨j[i]] ⋄ :EndIf
                     ⍝ Are the args used? If the args are spaces (seen as several .names) then it's OK.
                      :If ∨/b←c∧∨/k←type∘.≡'LO' 'RO' 'RA' 'LA'
                          (b/lns)←(b/k[;3]){⍵,⍨(∧/'←'∊¨⍵)/'?'}¨b/lns
                      :EndIf
                     ⍝ Is the result assigned?
                      :If ∨/b←type∊⊂'RS' ⋄ (b/lns)←{⍵,⍨('←'∊⊃,/⍵,⊂'')↓'?'}¨b/lns ⋄ :EndIf
                     ⍝ Can we figure out what types those *s are? (assigned global names are unusual)
                      :If ∨/b←type∊'*'
                          (b/type)←'FN' 'FN' 'GV' 'GV' '*'[i←3 4 2 9⍳⌊srcns.⎕NC b/n]
                          (b/lns)←i{⍵,⍨¨'!'/⍨¨(⍺<2)∧'←'∊¨⍵}¨b/lns ⍝ flag assigned global fns
                      :EndIf
                     ⍝ Format display
                      i←1↓⍴n←⍕nm,[0.1]type ⋄ j←,⎕PW arg.Switch'pw' ⋄ j[0]-←i+4 ⋄ j←j,(⍴j)↓0 6 1
                      txt←∊(↓n){CR,⍺,'  ',,⍵}¨j∘⎕SE.Dyalog.Utils.showRow¨∪¨lns
                      xref add←CR,CR,(show/fnm,':'),txt  ⍝ Emit cross-ref table
                  :EndIf
              :EndIf
          :Else
              xref add←show/CR,CR,'Cannot process the name <',fnm,'>'   ⍝ Not a defined function
          :EndIf
     
      :EndFor
    ∇

:EndNamespace ⍝ docum  $Revision: 1519 $
