:namespace wsutils2 ⍝ V2.01
⍝ Workspace Utilities
⍝ 2014 06 01 Unkn: DMX disabled 14/6
⍝ 2015 05 22 Adam: NS header
⍝ 2016 05 04 Modified ]defs to account for SALTed fns
⍝ 2018 01 10 JMS Revamped ]defs with -names= modifier
⍝ 2018 01 11 JMS remove mangled multi-line dfns from display
⍝ 2018 01 19 JMS prevent substitution in array definitions
⍝ 2018 01 21 JMS improved -refs display
⍝ 2018 02 11 JMS moved defs, externs and in functions to Utils
⍝ 2018 03 13 JMS [15591] ]defs didn't work unless ]boxing on
⍝ 2018 03 21 JMS [15591] improvements to ]defs
⍝ 2018 03 31 JMS replaced ]defs -names with ]TNames [off fns all]
⍝ 2018 04 06 JMS withdraw ]tnames command pending decision on its name
⍝ 2018 04 09 JMS resubmit improved ]tnames command, pending better idea for a handle
⍝ 2018 04 10 JMS moved tacit redefinition feature from ]defs to ]tnames
⍝ 2018 04 12 JMS disabled ]TNames
⍝ 2018 04 18 Adam: ]??cmd → ]cmd -??
⍝ 2019 02 01 Adam: Help
⍝ 2021 01 28 Adam: init OUTSpace
⍝ 2023 08 14 Adam: rename internal ns to match filename; rewrite and enable ]DMX as ]ErrorInfo
⍝ 2023 10 10 Adam: disable ]ErrorInfo

    ⎕IO←1 ⋄ ⎕ML←0   ⍝ Set those here to avoid inheriting them from outside
    OUTSpace ← '⎕se.Dyalog.Out'
    AllCmds←'Defs' 'TNames' 'ErrorInfo'

    ∇ r←List ⍝ this function usually returns 2 or more namespaces (here only 2)
      r←⎕NS¨0/¨AllCmds                             ⍝ create commands
      r.Name←AllCmds                               ⍝ their names
      r[1].Desc←'List single-line dfns, dops, derived functions and trains'     ⍝ descriptions
      r[2].Desc←'Tacit function name substitution'
      r[3].Desc←'Report information about a given (or the most recent) error'
      r.Group←'FN' 'OUTPUT' 'Tools'
     ⍝ Parsing rules for each:
      r[1].Parse←'-topdown -string='
      r[2].Parse←'-refs'
      r[3].Parse←''
      r←1 0 0/r                             ⍝ Defs [TNames] [ErrorInfo]
    ∇

    ∇ r←Run(Cmd Args);⎕USING;with;file;cr;t;full;ose;F;dir;Path;z;skipifempty;b;n;i;a;m;items;Items;names;ispat;O;B;U;wild;defscmd;wild;string;redef;arguments;indented;int;aplv;NV;bs;ns
      :If 0=⎕NC OUTSpace
          {}⎕SE.UCMD'box'
      :EndIf
     
      (O B U)←⎕SE.Dyalog.(Out Out.B Utils)  ⍝ handy refs for: Out Box Utils
      r←0 0⍴''                              ⍝ initially null result
     
      indented←{                              ⍝ ⍺⍺-indented
          O P←⍺⍺                              ⍝ Orientation: 1 2 ¯1 ¯2 ⋄ Parens: 0 1
          R←⍣(O<0) ⋄ D←⍣(2=|O)                ⍝ R:if-refs ⋄ D:if-dfns
          Ns Ks Ds←↓⍉↑⍵                       ⍝ names kind-trees defns
          flip←{(↓⍉↑⍺∘∊¨⍵)/¨⊂⍺}R              ⍝ inverted if called-by (-refs)
          vect←{                              ⍝ vector of names per defn
              0≠≡⍺:⊃,/⍺ ∇¨⍵                   ⍝ nested: join of each
              ⍺<0:⊂⍵                          ⍝ name: include
              ~⍺ dfn ⍵:⍬                      ⍝ not a dfn/op: ignore
              1 U.externs∘(⍵∘⊣)D ⍬            ⍝ inc non-local references from dfns
          }                                   ⍝ :: [N] ← K ∇ D
          tacit←{(~(⊃dfn¨/Ks Ds)[Ns⍳⍵])/⍵}    ⍝ filter for tacit fns
          dfn←{((⊂⍺)∊3 4)∧'{'≡⊃⍵}             ⍝ is a dfn/op?
          refs←Ns flip 1↓(¯1,Ks)vect¨0,Ds     ⍝ referenced names per defn
          vref←∪⊃,/refs                       ⍝ vector of unique refs
          ⍺←tacit R(Ns~vref)∪Ns               ⍝ default start-from names
          xtra←vref~Ns                        ⍝ refs to names not in ⍵
          names←'#',Ns∪vref                   ⍝ all names
          root←,¨(⊆⍺)∩names                   ⍝ starting-from names
          graph←(⊂root),refs,xtra⊢¨⊂⍬         ⍝ calling/called-by graph with names
          gx←names∘⍳¨graph                    ⍝ graph with indices
     
          dfs←{⊃∇⍨/⌽(⊂⍺ ⍺⍺ ⍵),⍺ ⍵⍵ ⍵}         ⍝ depth-first search
          accm←{⍺,(⍺(new∧defd)⍵)/D⊂⍵}         ⍝ collected lines and tab values
          subs←{(⍺ new ⍵)/D⊃next/⍵}           ⍝ unvisited edges
          new←{(⊃⍵)(~∊)⊃¨⍺}D                  ⍝ node unvisited?
          defd←{names[⊃⍵]∊'#',Ns}             ⍝ is this name defined?
          next←{(⍺⊃gx),¨⍵+2}                  ⍝ definition-index and indent
          srch←accm dfs subs                  ⍝ depth-first search
     
          ix ds←¯1 ¯2+↓⍉↑1↓⍬ srch 2↑⍳1        ⍝ indices and depths, without root
          defns←1 P∘U.expr∘⊂¨⍵[ix]            ⍝ defns in searched order
          uniq←⌽R{(⍵⍳⍵)=⍳⍴⍵}⌽R ix             ⍝ mask of unique defns
          ↑uniq/(ds⍴¨' '),¨defns              ⍝ unique tabbed definitions
     
        ⍝   :: ⍞; ← {[N]}(O P ∇∇)[N K D]    ⍝ char matrix of indented defns
        ⍝ O := ¯2 | ¯1 | 1 | 2              ⍝ Orientation: +ive:topdown -ive:refs
        ⍝ P := ?                            ⍝ fully Parenthesised
        ⍝ N := ⍞                            ⍝ Name
        ⍝ K := 2 | 3 | 4 | 9 | [K]          ⍝ Kind-tree
        ⍝ D := ⍞ | [D]                      ⍝ Defn-tree
     
        ⍝ First operand item (⊃⍺⍺) specifies the required tree orientation:
        ⍝   2: top-down (calling),  including dfn/ops
        ⍝   1:      ..      ..      tacit-only
        ⍝  ¯2: refs (called-by),    including dfn/ops.
        ⍝  ¯1:      ..      ..      tacit-only  (used by ]defs name←value)
        ⍝ Derived operators R and D conditionally apply their left operand:
        ⍝   R: if-Refs (orientation is "called-by")
        ⍝   D: if-Dfns (dfn/ops to be included)
        ⍝ For tacit-only definitions:
        ⍝   the graphs are acyclic and do not include the occurs-check: "new".
        ⍝   In particular:
        ⍝       the calling (topdown) graph is a Tree.
        ⍝       the called-by (refs)  graph is a DAG.
        ⍝   In the latter (called-by, DAG) case, omitting the occurs-check means
        ⍝   that vertices are typically duplicated in the result. Inner function
        ⍝   "uniq" removes leading duplicates so that definitions are followed by
        ⍝   their references. This is a requirement of the "]defs name←value" re-
        ⍝   assignment syntax, which must respecify dependent definitions in def-
        ⍝   before-ref order.
      }
     
      :Select Cmd
      :Case 'ErrorInfo'
          :If 0=≢Args
              ns←⎕DMX
              Args←'⎕DMX'
          :Else
              ns←##.THIS⍎Args  ⍝ user-supplied namespace
          :EndIf
          NV←{
              ⎕ML←1
              0=≢⍵:'' ''      ⍝ no vars
              v←⍺⍎⍵
              s←∧/{''≡0⍴⍵}¨v  ⍝ strings?
              v←∊⍤1↑⍣s⊢v      ⍝ strings→matrix
              ⍵ v
          }
          bs←⎕UCS 8
          r←(bs,':',⍨{⍵/⍨(∨\∧∘⌽∨\∘⌽)' '≠⍵}Args)''
          r⍪←ns NV⍤1{⍵['DECNMOIVH'⍋⍵;]}⍣(ns.##≡ns)↑ns.⎕NL ¯2  ⍝ sort sensibly if ⎕DMX, but handle any fields
          :If ∧/2=ns.⎕NC'EN' 'ENX'
          :AndIf 90 2≡ns.(EN ENX)
              r⍪←(bs,'⎕EXCEPTION:')''
              r⍪←⎕EXCEPTION NV⍤1↑⎕EXCEPTION.⎕NL ¯2
          :EndIf
          aplv←⎕SE.SALTUtils.APLV
          int←'APL/',3⊃aplv           ⍝ OS
          int,←'-',¯2↑'32',⎕D∩⍨⊃aplv  ⍝ bits
          int,←' ',2⊃aplv             ⍝ version
          int,←' ','Classic' 'Unicode'⊃⍨3|⎕DR''
          int,←' ',2 ⎕NQ #'GetBuildID'
          r⍪←(bs,'Interpreter:')''
          r⍪←'Dyalog'int
          r←⎕FMT r
     
      :Case 'Defs'
     
          defscmd←{                                ⍝ ucmd ]defs
              ∨/'*?'∊⍕⍵:⍺ ∇ wild ⍵                ⍝ wild-card:    ]defs a* b?c
              ⍺.string≢0:⍺ string ⍵               ⍝ string:       ]defs -s=⎕SE
              0=≢nkds←U.nkds ⎕SE.THIS:0 0⍴''     ⍝ (name kind defn)-tuples for all names
              P←B.trains≡'parens'                ⍝ fully-parenthesised?
              flat←1 P∘U.expr                    ⍝ flat list of defns with name-assignments
              tree←2 P indented                  ⍝ topdown-indented list of defns
              tnames←O.{0=⎕NC'tnames':0 ⋄ tnames}0 ⍝ tnames, default off
              nabs←singles tnames U.nabs         ⍝ name abstraction (nb: atop)
              case←0≠⍺.topdown,≢⍵                ⍝ indented, selection
              case≡0 0:flat nabs nkds        ⍝ flat, all
              case≡0 1:flat ⍵ nabs nkds        ⍝ flat, selection
              case≡1 0:tree nabs nkds        ⍝ indented, all
              case≡1 1:⍵ tree nabs nkds        ⍝ indented, selection
          }                                        ⍝ :: ⍞; ← space ∇ [arg]
     
          singles←{Ns Ks Ds←↓⍉↑⍵                   ⍝ Filter for single-line definitions
              d1←{                                 ⍝ single-line defs
                  1<≢↓⍵:0                          ⍝ multi-line component: no
                  0=≡⍺:1                           ⍝ atom: yes
                  ∧/⍺ ∇¨⍵                          ⍝ otherwise: test each component
              }                                    ⍝ for each type/defn
              nkd0←{1↓(⊂'' 0 ⍬),⍵}                 ⍝ explicit prototypical item
              nkd0((Ks d1¨Ds)>Ks∊9)/⍵              ⍝ single and not namespace
          }                                        ⍝ :: [N K D] ← ∇ [N K D]
     
          wild←{                                   ⍝ wild-card:    ]defs a* b?c
              find←⎕SE.SALTUtils.limRegexFind      ⍝ regex find utility
              names←⎕SE.THIS.⎕NL-⍳10               ⍝ all names
              hits←∪⊃,/names∘find¨⍵                ⍝ names matching patterns
              hits≡⍬:0 0⍴''                        ⍝ no hits: quit
              ⍺ ⍺⍺ names[hits]                     ⍝ retry with expanded names
          }                                        ⍝ ::
     
          string←{                                 ⍝ defns containing given string
              (args←⎕NS'').(topdown string)←0      ⍝ dummy args for defscmd
              defns←args defscmd''                ⍝ flat listing of all defns
              seln←(∨/⍺.string⍷defns)⌿defns        ⍝ selected definitions
              trim←{(∨\∨⌿⍵≠' ')/⍵}{⌽⍺⍺⌽⍺⍺ ⍵}       ⍝ without outer blank columns
              ⍺.topdown≡0:trim seln               ⍝ plain listing: done
              name←{' '~⍨(∧\⍵≠'←')/⍵}              ⍝ name from defn
              ⍺.string←0 ⋄ ⍺ defscmd name¨↓seln    ⍝ fancy listing: re-process
          }                                        ⍝ :: ⍞; ← space ∇ [arg]
     
          arguments←{(∧\'⍝'≠⊃¨⍵)/⍵}Args.Arguments  ⍝ ignoring comments
          r←Args defscmd arguments
     
      :Case 'TNames'
     
          redef←{                                       ⍝ redefinition ⍵ in space ⍺
              name←' '~⍨(∧\'←'≠⍵)/⍵                     ⍝ name from defn ⍵
              defs←2 U.nabs U.nkds ⍺                    ⍝ all defs in space ⍺
              deps←name(¯1 0 indented)defs              ⍝ dependent tacit defs in space ⍺
              (0 0⍴'')⊣⍺.{⍎⍵,'⋄0'}¨(⊂⍵),1↓↓deps         ⍝ re-assign all defs
          }                                             ⍝ :: _ ← space ∇ defn
     
          O.(⍎(0=⎕NC'tnames')/'tnames←0')               ⍝ tnames code, default: 0
          r←Args{
              '←'∊⍕⍵:⎕SE.THIS redef⍕⍵                 ⍝ redefinition: ]defs f ← g∘h
              ⍺.refs:{                                 ⍝ tacit defs dependent on ⍵
                  1≢≢⍵:'Usage: -refs name'
                  0=⎕SE.THIS.⎕NC⊃⍵:0 0⍴''
                  ⍵(¯1 0 indented)O.tnames U.nabs U.nkds ⎕SE.THIS
              }⍵
              to←{(⍺⍺⍳⍵)⊃⍵⍵}                            ⍝ translation
              states←'off' 'fns' 'all'                  ⍝ valid states
              emsg←'Arguments:',(U.ucase⍕states),'?'   ⍝ error message
              1<≢⍵:emsg                                 ⍝ too many args: quit
              was←U.ucase(0 1 2 to states)O.tnames      ⍝ current state
              (⊂⍵)∊(0⍴⊂'')(,⊂,'?'):'Is ',was           ⍝ old state
              new←U.lcase¨⍵                             ⍝ new state
              ~new∊states:emsg                          ⍝ bad state: quit
              O.tnames(states to 0 1 2)←new             ⍝ change state
              'Was ',was                                ⍝ report previous state
          }{(∧\'⍝'≠⊃¨⍵)/⍵}Args.Arguments                ⍝ ignoring comments
      :EndSelect
    ∇

    ∇ r←Level Help Cmd;t
      :Select Cmd
     
      :Case 'Defs'
          r←,⊂'List single-line dfns, dops, derived functions and trains'
          r,←⊂'    ]',Cmd,' [names] [-topdown] [-string=<text>]'
          r,←⊂''
          :Select Level
          :Case 0
              r,←⊂']',Cmd,' -??  ⍝ for details and examples'
          :Case 1
              r,←⊂'  <names>         one or more names or patterns'
              r,←⊂'  -topdown        show indented calling tree structure'
              r,←⊂'  -string=<text>  show definitions that include the given text'
              r,←⊂''
              r,←⊂'Wildcard characters are allowed in <names> and <text>: ? matches a single character and * matches one or more characters.'
              r,←⊂''
              r,←⊂'Examples:'
              r,←⊂'    ]',Cmd,'                ⍝ list all 1-line definitions'
              r,←⊂'    ]',Cmd,' avg df*        ⍝ show "avg" and definitions starting "df..."'
              r,←⊂'    ]',Cmd,' -t avg         ⍝ top-down display of "avg" and called functions'
              r,←⊂'    ]',Cmd,' -s=⍺⍺          ⍝ all definitions containing string "⍺⍺"'
              r,←⊂''
              r,←⊂']',Cmd,' -???  ⍝ for more examples'
          :Else
              r←,⊂'Examples:'
              r,←⊂''
              r,←⊂'      avl ← {(⍳×/1↓⍴⍵)~⍵×⊃⍺⌷⍺⍺}      ⍝ some definitions'
              r,←⊂'      box ← {⍵⌿⍵/⍵ ⍵⍴⍳⍵×⍵}'
              r,←⊂'      cmap ← {⊂[⍳⍴⍴⍵]1∊¨⍵∘.=⍵}'
              r,←⊂'      emt ← {(,⍵=0)/,⍳⍴⍵}'
              r,←⊂'      nxt ← {(⍺(⍺⍺ avl)⍵)⊣@(⊂⍺)¨⊂⍵}'
              r,←⊂'      nxtv ← {⊃,/⍺∘(⍺⍺ nxt)¨⍵}'
              r,←⊂'      rcb ← {(⍳⍵),¨box⊃⍵*÷2}'
              r,←⊂'      sfmt ← {⊂[3 4]1 3 2 4⍉(2/(⍴⍵)*÷2)⍴⍵}'
              r,←⊂'      sudoku ← {sfmt⊃cmap∘rcb svec ⍵}'
              r,←⊂'      svec ← {⊃(⍺⍺⍴⍵)nxtv/(emt ⍵),⊂⊂⍵}'
              r,←⊂''
              r,←⊂'      ]',Cmd,' cmap box                 ⍝ defs for "cmap" and "box"'
              r,←⊂'cmap ← {⊂[⍳⍴⍴⍵]1∊¨⍵∘.=⍵}'
              r,←⊂' box ← {⍵⌿⍵/⍵ ⍵⍴⍳⍵×⍵}'
              r,←⊂''
              r,←⊂'      ]',Cmd,' *t                       ⍝ defs for names ending in ''t'''
              r,←⊂' emt ← {(,⍵=0)/,⍳⍴⍵}'
              r,←⊂' nxt ← {(⍺(⍺⍺ avl)⍵)⊣@(⊂⍺)¨⊂⍵}'
              r,←⊂'sfmt ← {⊂[3 4]1 3 2 4⍉(2/(⍴⍵)*÷2)⍴⍵}'
              r,←⊂''
              r,←⊂'      ]',Cmd,' ???                      ⍝ defs for three-letter names'
              r,←⊂'avl ← {(⍳×/1↓⍴⍵)~⍵×⊃⍺⌷⍺⍺}'
              r,←⊂'box ← {⍵⌿⍵/⍵ ⍵⍴⍳⍵×⍵}'
              r,←⊂'emt ← {(,⍵=0)/,⍳⍴⍵}'
              r,←⊂'nxt ← {(⍺(⍺⍺ avl)⍵)⊣@(⊂⍺)¨⊂⍵}'
              r,←⊂'rcb ← {(⍳⍵),¨box⊃⍵*÷2}'
              r,←⊂''
              r,←⊂'      ]',Cmd,' -s=⍺⍺                    ⍝ defs containing string ''⍺⍺'''
              r,←⊂' avl ← {(⍳×/1↓⍴⍵)~⍵×⊃⍺⌷⍺⍺}'
              r,←⊂' nxt ← {(⍺(⍺⍺ avl)⍵)⊣@(⊂⍺)¨⊂⍵}'
              r,←⊂'nxtv ← {⊃,/⍺∘(⍺⍺ nxt)¨⍵}'
              r,←⊂'svec ← {⊃(⍺⍺⍴⍵)nxtv/(emt ⍵),⊂⊂⍵}'
              r,←⊂''
              r,←⊂'      ]',Cmd,' -topdown svec            ⍝ calling tree for "svec"'
              r,←⊂'svec ← {⊃(⍺⍺⍴⍵)nxtv/(emt ⍵),⊂⊂⍵}'
              r,←⊂'  nxtv ← {⊃,/⍺∘(⍺⍺ nxt)¨⍵}'
              r,←⊂'    nxt ← {(⍺(⍺⍺ avl)⍵)⊣@(⊂⍺)¨⊂⍵}'
              r,←⊂'      avl ← {(⍳×/1↓⍴⍵)~⍵×⊃⍺⌷⍺⍺}'
              r,←⊂'  emt ← {(,⍵=0)/,⍳⍴⍵}'
              r,←⊂''
              r,←⊂'      ]',Cmd,' -t                       ⍝ calling tree'
              r,←⊂'sudoku ← {sfmt⊃cmap∘rcb svec ⍵}'
              r,←⊂'  sfmt ← {⊂[3 4]1 3 2 4⍉(2/(⍴⍵)*÷2)⍴⍵}'
              r,←⊂'  cmap ← {⊂[⍳⍴⍴⍵]1∊¨⍵∘.=⍵}'
              r,←⊂'  rcb ← {(⍳⍵),¨box⊃⍵*÷2}'
              r,←⊂'    box ← {⍵⌿⍵/⍵ ⍵⍴⍳⍵×⍵}'
              r,←⊂'  svec ← {⊃(⍺⍺⍴⍵)nxtv/(emt ⍵),⊂⊂⍵}'
              r,←⊂'    nxtv ← {⊃,/⍺∘(⍺⍺ nxt)¨⍵}'
              r,←⊂'      nxt ← {(⍺(⍺⍺ avl)⍵)⊣@(⊂⍺)¨⊂⍵}'
              r,←⊂'        avl ← {(⍳×/1↓⍴⍵)~⍵×⊃⍺⌷⍺⍺}'
              r,←⊂'    emt ← {(,⍵=0)/,⍳⍴⍵}'
              r,←⊂''
              r,←⊂']',Cmd,' -??  ⍝ for syntax details'
          :EndSelect
     
      :Case 'TNames'
          :Select Level
          :Case 0
              r←,⊂'Enables the substitution of NAMES for component VALUES in ]Defs and ]boxing displays of tacit (trains or derived) functions.'
              r,←⊂''
              r,←⊂'NB: this substitution affects only the DISPLAY of the function and not its definition. In particular, changing the definition of a component named in the display does NOT change the function - see examples.'
              r,←⊂''
              r,←⊂'Arguments:'
              r,←⊂'  off  Show VALUES of tacit function components (default):  next ← +∘1'
              r,←⊂'  fns  Show function & operator NAMES where available:      next ← plus∘1'
              r,←⊂'  all  Include ARRAY names where available:                 next ← plus∘one'
              r,←⊂'If multiple names refer to the component value, no substitution occurs.'
              r,←⊂''
              r,←⊂'Modifier -refs displays definitions dependent on a given name.'
              r,←⊂''
              r,←⊂'Assignment: argument "name ← defn" redefines name and dependent TACIT definitions.'
              r,←⊂''
              r,←⊂']TNames -??  ⍝ for examples'
          :Case 1
              r←,⊂'Examples:'
              r,←⊂''
              r,←⊂'      avg ← +⌿ ÷ ≢           ⍝ tacit definition of average'
              r,←⊂'      sum ← +⌿               ⍝   ··    ··    ··    sum-total'
              r,←⊂'      num ← ≢                ⍝   ··    ··    ··    item-count'
              r,←⊂''
              r,←⊂'      ]Boxing -trains=box    ⍝ show boxed display of tacit functions'
              r,←⊂'Was -trains=box'
              r,←⊂''
              r,←⊂'      ]TNames off            ⍝ display VALUES of tacit function components'
              r,←⊂'Was OFF'
              r,←⊂''
              r,←⊂'      avg                    ⍝ ]boxed display showing component VALUES'
              r,←⊂'┌─────┬─┬─┐'
              r,←⊂'│┌─┬─┐│÷│≢│'
              r,←⊂'││+│⌿││ │ │'
              r,←⊂'│└─┴─┘│ │ │'
              r,←⊂'└─────┴─┴─┘'
              r,←⊂''
              r,←⊂'      ]TNames fns            ⍝ display tacit FUNCTION component NAMES'
              r,←⊂'Was OFF'
              r,←⊂''
              r,←⊂'      avg                    ⍝ ]boxed display showing component NAMES'
              r,←⊂'┌───┬─┬───┐'
              r,←⊂'│sum│÷│num│'
              r,←⊂'└───┴─┴───┘'
              r,←⊂''
              r,←⊂'      ]Defs                  ⍝ ]Defs display showing component NAMES'
              r,←⊂'avg ← sum÷num'
              r,←⊂'num ← ≢'
              r,←⊂'sum ← +⌿'
              r,←⊂''
              r,←⊂'      ]Defs -topdown avg     ⍝ calling tree for tacit function "avg"'
              r,←⊂'avg ← sum÷num'
              r,←⊂'  sum ← +⌿'
              r,←⊂'  num ← ≢'
              r,←⊂''
              r,←⊂'      ⎕cr''avg''               ⍝ NB: ]TNames DOES NOT CHANGE THE DEFINITION'
              r,←⊂'┌──┬─┬─┐'
              r,←⊂'│+⌿│÷│≢│'
              r,←⊂'└──┴─┴─┘'
              r,←⊂''
              r,←⊂'      num ← ⍴                ⍝ redefinition of num ...'
              r,←⊂''
              r,←⊂'      avg                    ⍝ "num" no longer appears in the display'
              r,←⊂'┌───┬─┬─┐'
              r,←⊂'│sum│÷│≢│'
              r,←⊂'└───┴─┴─┘'
              r,←⊂''
              r,←⊂'      next ← 1∘(plus←+)      ⍝ more definitions'
              r,←⊂'      prev ← (sub←-)∘(one←1)'
              r,←⊂'      same ← prev∘next'
              r,←⊂''
              r,←⊂'      ]Defs -t same          ⍝ calling tree for tacit function "same"'
              r,←⊂'same ← prev∘next'
              r,←⊂'  prev ← sub∘1'
              r,←⊂'    sub ← -'
              r,←⊂'  next ← 1∘plus'
              r,←⊂'    plus ← +'
              r,←⊂''
              r,←⊂'      ]tnames all            ⍝ include ARRAY names, such as "one"'
              r,←⊂'Was FNS'
              r,←⊂''
              r,←⊂'      ]Defs -t same          ⍝ tacit function calling tree, including "one"'
              r,←⊂'same ← prev∘next'
              r,←⊂'  prev ← sub∘one'
              r,←⊂'    sub ← -'
              r,←⊂'    one ← 1'
              r,←⊂'  next ← one∘plus'
              r,←⊂'    plus ← +'
              r,←⊂''
              r,←⊂'      ]tnames -refs plus     ⍝ defs dependent on "plus"'
              r,←⊂'plus ← +'
              r,←⊂'  next ← one∘plus'
              r,←⊂'    same ← prev∘next'
              r,←⊂'  sum ← plus⌿'
              r,←⊂'    avg ← sum÷≢'
              r,←⊂''
              r,←⊂'      ]tnames -r one         ⍝ defs dependent on "one"'
              r,←⊂'one ← 1'
              r,←⊂'  next ← one∘plus'
              r,←⊂'  prev ← sub∘one'
              r,←⊂'    same ← prev∘next'
              r,←⊂''
              r,←⊂']TNames -???                 ⍝ re-definition examples'
          :Else
              r←,⊂'When changing a tacit definition we may want to re-assign all DEPENDENT definitions, in order for them to benefit from the change:'
              r,←⊂''
              r,←⊂'      ]Defs plus             ⍝ definition of "plus"'
              r,←⊂'plus ← +'
              r,←⊂''
              r,←⊂'      ]tnames fns            ⍝ show function names'
              r,←⊂'Was ALL'
              r,←⊂''
              r,←⊂'      ]tnames -refs plus     ⍝ defs dependent on "plus"'
              r,←⊂'plus ← +'
              r,←⊂'  next ← 1∘plus'
              r,←⊂'    same ← prev∘next'
              r,←⊂'  sum ← plus⌿'
              r,←⊂'    avg ← sum÷≢'
              r,←⊂''
              r,←⊂'      ]tnames "plus ← -∘-"   ⍝ redefinition of "plus"'
              r,←⊂''
              r,←⊂'The above command redefines "plus", then reassigns "next" and "sum", which depend on it, and then reassigns "same" and "avg", which in turn depend on them.'
              r,←⊂''
              r,←⊂'      ]tnames off            ⍝ show VALUES in tacit definitions'
              r,←⊂'Was OFF'
              r,←⊂''
              r,←⊂'      ]Defs plus next same sum avg   ⍝ notice that "plus" is "-∘-" throughout'
              r,←⊂'plus ← -∘-'
              r,←⊂'next ← 1∘(-∘-)'
              r,←⊂'same ← -∘1∘(1∘(-∘-))'
              r,←⊂' sum ← -∘-⌿'
              r,←⊂' avg ← -∘-⌿÷≢'
              r,←⊂''
              r,←⊂'      ]tnames "plus ← +"     ⍝ restore "plus"'
              r,←⊂''
              r,←⊂'      ]Defs plus next same sum avg   ⍝ notice that "plus" is again "+"'
              r,←⊂'plus ← +'
              r,←⊂'next ← 1∘+'
              r,←⊂'same ← -∘1∘(1∘+)'
              r,←⊂' sum ← +⌿'
              r,←⊂' avg ← +⌿÷≢'
          :EndSelect
     
      :Case 'ErrorInfo'
          r←,⊂'Report information about a given (or the most recent) error.'
          r,←⊂'    ]',Cmd,' [ns]'
          r,←⊂''
          :Select Level
          :Case 0
              r,←⊂']',Cmd,' -??  ⍝ for details and examples'
          :Else
              t←'By default, information (from ⎕DMX and, if appropriate, ⎕EXCEPTION) about the immediately preceding error is reported. '
              t,←'The results of ⎕DMX or ⎕EXCEPTION can be assigned to a variable for later display, and '
              t,←']',Cmd,' can take the name of such a variable (or an expression giving such a value) as argument. '
              t,←'It will then use this information rather than that of the previous APL error.'
              r,←⊂t
     
              r,←⊂'ns  an error information namespace'
              r,←⊂''
              r,←⊂'Example:'
              r,←⊂''
              r,←⊂'          ÷0'
              r,←⊂'    DOMAIN ERROR: Divide by zero'
              r,←⊂'          ÷0'
              r,←⊂'          ∧'
              r,←⊂'          ]',Cmd
              r,←⊂'     DM                DOMAIN ERROR                               '
              r,←⊂'                             ÷0                                   '
              r,←⊂'                             ∧                                    '
              r,←⊂'     EN                11                                         '
              r,←⊂'     ENX               1                                          '
              r,←⊂'     EM                DOMAIN ERROR                               '
              r,←⊂'     Category          General                                    '
              r,←⊂'     Message           Divide by zero                             '
              r,←⊂'     OSError           0 0                                        '
              r,←⊂'     InternalLocation  scalm.cpp 354                              '
              r,←⊂'     Vendor            Dyalog                                     '
              r,←⊂'     HelpURL           https://help.dyalog.com/dmx/19.0/General/1 '
              r,←⊂'                                                                  '
              r,←⊂'     Interpreter       APL/W-64 19.0.47563.0 Unicode f38042b4     '
              r,←⊂''
              t←'Note:  Running a user command or causing an additional error will reset any previous error information. '
              t,←'It is therefore a good idea to to save the information using myerr←⎕DMX immediately after seeing an error. '
              t,←'After this, the saved error information can be viewed with:'
              r,←⊂t
              r,←⊂'           ]',Cmd,' myerr'
          :EndSelect
      :EndSelect
    ∇

:Endnamespace
 ⍝ wsutils  $Revision: 1864 $
