﻿:NameSpace Othello
⍝ Demonstrate the creation of an Othello Board
⍝ Using the OthelloSquare class (Study\GUI\OthelloSquare)
⍝ See Studys\GUI\OthelloGame.dyalog for a solution in which the game is also a class
    
    ⎕ML←3

    ∇ Game←New GridSize;Size;CellIDs;Centre
      ⍝ Initialize Controlling Variables
      ⎕SE.SALT.Load'Study\GUI\OthelloSquare -target=#'
     
      Size←50 50                     ⍝ Cell Size
      CellIDs←⍳GridSize              ⍝ Identity of each cell
     
      ⍝ Build the Board
      'Game'⎕WC'Form' 'Othello'('Size'(11+Size×GridSize))('Coord' 'Pixel')
      Game.Cells←{Game.⎕NEW #.OthelloSquare(('Size'(1+Size))('Posn'(5+Size×⍵-1))('Data'⍵))}¨CellIDs
      Game.Cells.onClick←⊂'#.Othello.Click' ⍝ Set up Callback
     
      ⍝ Set up the game:
      Centre←0 1+⌊0.5×GridSize
      Game.Cells[Centre;Centre].State←2 2⍴1 2 2 1
      Game.⎕DF'[Othello Game]'
    ∇
    
    ∇ Click msg;Cell
      ⍝ Flip the cell which was clicked on
      ⍝ Implementation of Othello rules left as exercise for the user
     
      Cell←↑msg
      Cell.(State←1+1=State) ⍝ Flip State
    ∇
    
:EndNameSpace ⍝ Othello  $Revision: 1472 $ 