﻿:Class OthelloGame
⍝ Demostrate creation of an Othello game board using an embedded class 'Square'
⍝ Which derives from the Dyalog GUI class 'Static'
    
    :Field Public Form   ⍝ Expose the game form
    :Field Public Cells  ⍝ And the array of Cells
    
    ∇ Othello GridSize;Centre
      :Access Public
      :Implements Constructor
     
      Size←50 50                     ⍝ Cell Size
      CellIDs←⍳GridSize              ⍝ Identity of each cell
     
      ⍝ Build the Board
      'Form'⎕WC'Form' 'Othello'('Size'(11+Size×GridSize))('Coord' 'Pixel')
      Cells←{Form.⎕NEW Square(('Size'(1+Size))('Posn'(5+Size×⍵-1))('Data'⍵))}¨CellIDs
      Cells.onClick←⊂'OthelloGame.Click' ⍝ Set up Callback
     
      ⍝ Set up the game:
      Centre←0 1+⌊0.5×GridSize
      Cells[Centre;Centre].State←2 2⍴1 2 2 1
      ⎕DF'[Othello Game]'
    ∇
    
    ∇ Click msg;Cell
      :Access Public Shared
      ⍝ Callback function - just flips state of cell
      ⍝ Implementation of Othello rules left as an exercise for the reader
     
      Cell←1⊃msg
      Cell.(State←1+1=State) ⍝ Flip State
    ∇
    
    :Class Square : 'Static'
    ⍝ Implements one Square on an Othello Board
        
        _State←0 ⍝ 0=Empty, 1=Black, 2=White
        :Field Public onClick←'' ⍝ "Event": Put name of Callback fn Here
        
        :Property Default State
        :Access Public
            ∇ r←Get
              r←_State
            ∇
            ∇ Set args;i
              ⎕SIGNAL(args.NewValue∊0 1 2)↓11          ⍝ Is State Valid?
              i←1+_State←args.NewValue
              Circle.FillCol←i⊃¯16(0 0 0)(255 255 255) ⍝ Button Face, Black, White
              Circle.FCol←i⊃¯16 0 0                    ⍝ Black outline if not Empty
              ⎕DF i⊃'.⍟○'                              ⍝ Set Display Form
            ∇
        :EndProperty
        
        ∇ Create args
          :Access Public
          :Implements Constructor :Base args,⊂'BCol' ¯16
          Circle←⎕NEW'Circle'(('Points'(0.5×Size))('Radius'(0.4×1⊃Size))('FStyle' 0))
          onMouseUp←Circle.onMouseUp←'Select'
          State←0 ⍝ Initially Empty (Calls 'Set' function above)
        ∇
        
        ∇ r←Select msg
          :If 3=⌊⎕NC⊂onClick         ⍝ If Callback function defined
              (⍎onClick)⎕THIS _State ⍝ Call it passing Ref to Square and Current State
          :EndIf
        ∇
        
    :EndClass ⍝ Square
:EndClass ⍝ Othello ⍝ OthelloGame  $Revision: 1472 $ 