﻿:Class OthelloSquare : 'Static'
⍝ Version 11.0.0.0
⍝ Implements one square on an Othello Board
⍝ See the Quick Introduction to Object Oriented Programming for more information
    
    _State←0 ⍝ 0=Empty, 1=Black, 2=White
    :Field Public onClick←'' ⍝ "Event": Put name of Callback fn Here
    
    :Property Default State
    :Access Public
        ∇ r←Get
          r←_State
        ∇
        ∇ Set args;i
          ⎕SIGNAL(args.NewValue∊0 1 2)↓11          ⍝ Is State Valid?
          i←1+_State←args.NewValue
          Circle.FillCol←(¯16(0 0 0)(255 255 255))[i] ⍝ Button Face, Black, White
          Circle.FCol←i⊃¯16 0 0                       ⍝ Black outline if not Empty
          ⎕DF i⊃'.⍟○'                                 ⍝ Set Display Form
        ∇
    :EndProperty
    
∇ Create args
 :Access Public
 :Implements Constructor :Base args,⊂'BCol' ¯16
 Circle←⎕NEW'Circle'(('Points'(0.5×Size))('Radius'(0.4×⊃Size))('FStyle' 0))
 onMouseUp←Circle.onMouseUp←'Select'
 State←0 ⍝ Initially Empty (Calls 'Set' function above)
∇
    
    ∇ r←Select msg
      :Access Public
      :If 3=⎕NC onClick          ⍝ If Callback function defined
          (⍎onClick)⎕THIS _State ⍝ Call it passing Ref to Square and Current State
      :EndIf
    ∇
    
:EndClass ⍝ Square ⍝ OthelloSquare  $Revision: 1472 $ 