﻿:namespace    anyname     ⍝ could be any other name like :namespace X

⍝ Implement a sample User Command to illustrate how to do create a UCMD.
    
⍝ A minimum of 3 functions is necessary to create a Spice command:
⍝ <List>, <Run> and <Help>. There may be more if necessary.
⍝ All must be SHARED PUBLIC if a class is used (it is not the case here).
    
    ⎕IO←1 ⋄ ⎕ML←0         ⍝ Set those here to avoid inheriting them from outside
    
⍝ <List> is the function that is used by the user command processor to list all commands.
⍝ When user commands are initialised all available commands in [Dyalog]\SALT\spice  
⍝ are recorded and put in a list using the result of their <List> function
⍝ which returns a series of namespaces containing 
⍝ - the command name
⍝ - a short description
⍝ - the group the command belongs to
⍝ - their parsing rules
    
    ∇ r←List ⍝ this function usually returns 1 or more namespaces (here 2)
      r←⎕NS¨2⍴⊂''                                        ⍝ create 2 commands
      r.Name←'UCMDNoParsing' 'UCMDParsing'               ⍝ their names
      r[1].Desc←'A Sample Command without parsing'       ⍝ descriptions
      r[2].Desc←'A Sample Command with    parsing'
      r.Group←⊂'Samples'                                 ⍝ same group
     ⍝ Parsing rules for each:
      r[1].Parse←''       ⍝ 'UCMDNoParsing' has no rule, the argument will be passed on "as is"
      r[2].Parse←'1 -TZ=' ⍝ 'UCMDParsing' takes 1 argument and a possible switch TZ which accepts a value
    ∇
    
⍝ <Run> is used to execute a specific command.
⍝ It will be given the full name of the command (one of the 'Name's above)
⍝ followed by possible arguments (a string following the name of the command)
⍝ For example the command 'aSample' above could accept an argument which 
⍝ may need to be checked. <Run> does that:
    
    ∇ r←Run(Cmd Args);timezone;cmdparser
      :Select Cmd
     
      :Case 'UCMDNoParsing'
          r←'This is an example of a command that receives a string as the argument.',⎕AV[4]
          r,←'Its argument is: ',Args,(' '∧.=Args)/'(empty)'
     
      :Case 'UCMDParsing'
        ⍝ If parsing is required (as per the 'Parse' variable above)
        ⍝ the processor will have performed the parsing and the argument is a Parser instance.
        ⍝ See the Parser class in ⎕SE for details.
        ⍝ Here we accept "time" possibly followed by -TZ=a number
     
          :If 'time'≡1⊃Args.Arguments
              timezone←'EST' Args.Switch 'TZ' ⍝ default TZ to 'EST'
              r←'The time is ',,'G<99:99>'⎕FMT 100⊥⎕TS[4 5]
              r,←', Time Zone=',timezone,' and all is well...'
     
        ⍝ Here we accept "date"
          :ElseIf 'date'≡1⊃Args.Arguments
              r←'Today is ',⍕3↑⎕TS
     
          :Else
             ⍝ Here we could have other possibilities
              r←'You have entered an unknown argument to ',Cmd
     
          :EndIf
     
      :EndSelect
    ∇
    
⍝ Finally, <Help> is used to provide information about a specific command
⍝ The left argument specifies the level of help desired. See command 'UCMDHelp' for an example of use.
    
    ∇ r←level Help Cmd
      :Select Cmd
      :Case 'UCMDNoParsing'
          r←'This SPICE command "',Cmd,'" is for educational purposes'
     
      :Case 'UCMDParsing'
          r←'This command is an example. Its single argument may only be "time" or "date".'
          r←↑r'It will display the time or the date as a result'
      :EndSelect
    ∇
    
:Endnamespace ⍝ anyname  $Revision: 739 $ 