﻿:Class ComponentFile
⍝ Dyalog APL Component File Wrapper Class.
⍝ This class requires .Net
    
⍝ This class opens or creates a component file, possibly
⍝ a temporary one, providing some existing functionnality
⍝ in the form of Properties.
    
    ⎕io←1 ⋄ ⎕ml←1
    
    :Field Public Shared ReadOnly Version←11.00
    :Field Private Instance tie
    :Field Private instance temp←0 ⍝ temporary File?
    
    ∇ Open(filename)
     ⍝ Open Named File
      :Implements Constructor
      :Access Public Instance
      OpenFile filename
    ∇
    
    ∇ OpenTemp;⎕USING;z
     ⍝ Default: Open temporary file; ask .Net to provide the name
      :Implements Constructor
      :Access Public Instance
     
      ⎕USING←''
      z←System.IO.Path.GetTempFileName
      z ⎕NERASE z ⎕NTIE 0 ⍝ erase the temp file which was created
      tie←z ⎕FCREATE 0
      temp←1
    ∇
    
    ∇ OpenFile filename
      ⍝ "Subroutine" of Open and OpenX
      :Trap 0
          tie←filename ⎕FSTIE 0
      :Else
          ⎕FUNTIE filename ⎕FCREATE 0 ⍝ Create and untie
          tie←filename ⎕FSTIE 0       ⍝ Then share-tie
      :EndTrap
    ∇
    
    ∇ Close
      :Implements Destructor
      :If tie∊⎕FNUMS
          :If temp ⋄ Name ⎕FERASE tie
          :Else ⋄ ⎕FUNTIE tie
          :EndIf
      :EndIf
    ∇
    
    ∇ OpenX filename   ⍝ Allow APL user to not enclose constructor argument
      :Implements Constructor
      :Access Public Instance
      OpenFile filename
    ∇
    
⍝ --- Instance Methods ---
    
    ∇ r←Append data
      :Access Public Instance
      r←data ⎕FAPPEND tie
    ∇
    
    ∇ Rename name
      :Access Public Instance
      name ⎕FRENAME tie
    ∇
    
    ∇ Replace(comp data)
      :Access Public Instance
      data ⎕FREPLACE tie,comp
    ∇
    
⍝ --- Instance Properties ---
    
    :Property Name
    :Access Public Instance
        ∇ r←Get
          :If tie∊⎕FNUMS ⋄ r←⎕FNAMES[⎕FNUMS⍳tie;]
          :Else ⋄ r←'' ⋄ :EndIf
        ∇
    :EndProperty
    
    :Property Count
    :Access Public Instance
        ∇ r←Get
          r←¯1+2⊃⎕FSIZE tie
        ∇
    :EndProperty ⍝ Count
    
    :Property Access
    :Access Public Instance
        ∇ r←Get
          r←⎕FRDAC tie
        ∇
        ∇ Set am;mat;OK
          mat←am.NewValue
          :Trap 0
              OK←(2=⍴⍴mat)∧(3=2⊃⍴mat)∧∧/,mat=⌊mat
          :Else
              OK←0
          :EndTrap
          'Bad Access Matrix '⎕SIGNAL(~OK)/11
          mat ⎕FSTAC tie
        ∇
    :EndProperty ⍝ Access
    
    :Property Numbered Default Components
    :Access Public Instance
        ∇ r←Shape args
          r←Count
        ∇
        ∇ r←Get arg
          r←⊂⎕FREAD tie,arg.Indexers
        ∇
        ∇ Set arg
          (⊃arg.NewValue)⎕FREPLACE tie,arg.Indexers
        ∇
    :EndProperty ⍝ Components
    
⍝ --- Shared Members
    
    ∇ r←Delete file;tie
      :Access Public Shared
      :Trap r←0
          tie←file ⎕FTIE 0
          file ⎕FERASE tie
          r←1
      :EndTrap
    ∇
    
:EndClass ⍝ ComponentFile ⍝ ComponentFile  $Revision: 739 $ 