﻿:Class DyalogComponentFile : ComponentFile
⍝ .Net Cover Class for ComponentFile
:Using System
    
    ∇ Open filename
      ⍝ Open Named File
      :Implements Constructor :Base filename
      :Access Public Instance
      :Signature Open String
    ∇
    
    ∇ OpenTemp;⎕USING;z
      ⍝ Default: Open temporary file
      :Implements Constructor :Base
      :Access Public Instance
    ∇
    
    ⍝ --- Instance Methods ---
    
    ∇ r←Append data
      :Access Public Instance
      :Signature Int32←Append Object
      r←⎕BASE.Append data
    ∇
    
    ∇ Rename name
      :Access Public Instance
      :Signature Rename String
      ⎕BASE.Rename name
    ∇
    
    ∇ Replace args
      :Access Public Instance
      :Signature Replace Int32 Component,Object Data
      ⎕BASE.Replace args
    ∇
    
    ⍝ --- Instance Properties ---
    
    :Property Name
    :Access Public Instance
        ∇ r←Get
          :Signature String←Get
          r←⎕BASE.Name
        ∇
    :EndProperty
    
    :Property Count
    :Access Public Instance 
        ∇ r←Get
          :Signature Int32←Get
          r←⎕BASE.Count
        ∇
    :EndProperty ⍝ Count
    
    :Property Access
    :Access Public Instance
        ∇ r←Get
          :Signature Int32[,]←Get
          r←⎕BASE.Access
        ∇
        ∇ Set args
          :Signature Set Int32[,]
          ⎕BASE.Access←args.NewValue
        ∇
    :EndProperty ⍝ Access
    
    :Property Default Numbered  Components
    :Access Public Instance    
        ∇ r←Shape args
          r←Count
        ∇
        ∇ r←Get arg
          :Signature Get Int32 Component
          r←⎕BASE.Components[arg.Indexers]
        ∇
        ∇ Set arg
          :Signature Set Int32 Component, Object NewValue
          ⎕BASE.Components[arg.Indexers]←arg.NewValue
        ∇
    :EndProperty
    
    ⍝ --- Shared Members
    
    ∇ Delete file
      :Access Public Shared
      :Signature Delete String
      ⎕BASE.Delete file
    ∇
    
:EndClass ⍝ DyalogComponentFile ⍝ DyalogComponentFile  $Revision: 739 $ 