﻿:Class KeyedFile : ComponentFile
⍝ Version 11.01
⍝∇:Require =\ComponentFile 
    
    :Field Private keys←⍬
    
    ∇ Open filename
      :Implements Constructor :Base filename
      :Access Public Instance
     
      :If 0=⎕BASE.Count ⍝ empty: Initialise
          {}⎕BASE.Append'Keyed Component File'
          {}⎕BASE.Append keys
          {}⎕BASE.Append¨3⍴⊂'Reserved'
      :Else             ⍝ not empty: Validate Format
          'Not a KeyedFile'⎕SIGNAL('Keyed Component File'≢1⊃Components)/11
          keys←2⊃Components
          'KeyedFile Damaged'⎕SIGNAL((5+⍴keys)≠⎕BASE.Count)/11
      :EndIf
    ∇
    
    ⍝ --- Instance Properties ---
    
    :Property Count
    :Access Public Instance
        ∇ r←Get
          r←⍴keys
        ∇
    :EndProperty ⍝ count
    
    :Property Keys
    :Access Public Instance
        ∇ r←Get  ⍝ provide Read Access to Keys
          r←keys
        ∇
    :EndProperty
    
    :Property Keyed Default Item
    :Access Public Instance
        ∇ r←get arg
          ⎕SIGNAL 4⍴⍨1≠⍴arg.Indexers
          r←Components[5+keys⍳1⊃arg.Indexers] ⍝ read components
        ∇
        ∇ set args;m;ix;in
          ⎕SIGNAL 4⍴⍨1≠⍴args.Indexers
          ix←1⊃args.Indexers       ⍝ extract index on 1st dimension
          :If ∨/m←~in←ix∊keys      ⍝ are any keys unknown?
              keys←keys,m/ix       ⍝ add new keys
              Components[2]←⊂keys  ⍝ rewrite key component
              {}⎕BASE.Append¨m/args.NewValue ⍝ append data
          :EndIf
          Components[5+keys⍳in/ix]←in/args.NewValue ⍝ Replace
        ∇
    :EndProperty
    
    ⍝ --- Some ComponentFile Methods Blocked Off ---
    
    ∇ r←Append data
      :Access Public
      'Please assign to Item Property'⎕SIGNAL 11
    ∇
    
    ∇ Replace(comp data)
      :Access Public
      'Please assign to Item Property'⎕SIGNAL 11
    ∇
    
:EndClass ⍝ KeyedFile ⍝ KeyedFile  $Revision: 1472 $ 