﻿:Class Complex
    
  ⍝  Complex Number class, Dyalog 2006
    
    :Field Public R←0   ⍝ Real part
    :Field Public I←0   ⍝ Imaginary part    
    
    :Field Public Shared ZeroTolerance←1e¯15
    
    ⎕pp←5
    PI2←2×PI←○1
    
    ⍝ --- Instance Functions ---
    
    ∇ r←Magnitude
      :Access Public
      r←(R I+.*2)*0.5  ⍝ single Real number
    ∇
    
    ∇ r←Reciprocal
      :Access Public
      r←⎕NEW Complex((R,-I)÷+.×⍨R I)
    ∇
    
    ∇ r←Polar;angle;⎕DIV
    ⍝ Turn R/I into Magnitude/Angle
      :Access Public
      angle←(¯3○I÷R+1E¯15×0=R)+PI×R<0
      r←Magnitude,PI2|angle  ⍝ returns 2 Real numbers
    ∇
    
    ∇ r←Conjugate
      :Access Public
      r←⎕NEW Complex(R,-I)
    ∇
    
    ∇ r←Negate
      :Access public
      r←⎕NEW Complex(-R I)
    ∇
    
    ⍝ --- Shared Functions ---
    
    ∇ r←Cartesian n      ⍝ argument is 1 or 2 Real numbers
     ⍝ Turn  value,angle  into  Real,Imaginary
      :Access Public Shared
      r←⎕NEW Complex,{⍺×2 1○⍵}/2↑n
    ∇
    
    ∇ r←a Plus b
      :Access Public Shared
      r←⎕NEW Complex,+/(Coerce¨a b).(R I)
    ∇
    
    ∇ r←a Times b;A;B
      :Access Public Shared
      A B←(Coerce¨a b).(R I)
      r←⎕NEW Complex((A-.×B)(A+.×⌽B))
    ∇
    
    ∇ r←a Divide b;A;B
      :Access Public Shared
      A B←(Coerce¨a b).(R I)
     ⍝ a÷b is (a×Conjugate b)÷(b×Conjugate b)
      r←⎕NEW Complex((A+.×B)(B-.×⌽A)÷B+.*2)
    ∇
    
    ∇ r←a Power n;am;aa;mod
      :Access Public Shared
      a n←Coerce¨a n   ⍝ Turn arrays into Complex
      (am aa)←a.Polar  ⍝ a into polar form
      :If 0≡n.I
        ⍝ Compute power using polar form: Mod*n, angle×n
          r←Cartesian(am*n.R),aa×n.R
      :Else
        ⍝ We need the polar form as well as the cartesian numbers
          mod←(am*n.R)÷*aa×n.I
          r←⎕NEW Complex,⊂mod×2 1○n.(R I)×aa,⍟am
      :EndIf
    ∇
    
    ∇ make1 r  ⍝ may be used with a single Real #
      :Access public
      :Implements constructor
      make r,0
    ∇
    
    ∇ make2(r i)
      :Implements Constructor
      :Access Public
      make r i
    ∇
    
    ∇ make(r i);ri
      ⎕SIGNAL 11↓⍨0≡⊃0⍴r+i ⍝ numbers only
      R I←ri×ZeroTolerance<|ri←r,i
      ⎕DF(⍕R),'J',⍕I    ⍝ set the display form for this number
    ∇
    
    
    ⍝ --- Private Utilities ---
    
    ∇ r←Coerce r
      :If 326≠⎕DR 1/r       ⍝ If r is not already a complex object
          r←⎕NEW Complex r  ⍝ then make it into one
      :EndIf
    ∇
    
    ∇ changeDisplay
      :Implements Trigger R,I
      ⎕DF(⍕R),'J',⍕I
    ∇
    
:EndClass ⍝ Complex ⍝ Complex  $Revision: 739 $ 