﻿:Class HTMLdoc
⍝ This class contains code to produce wsdoc type HTML pages
    :field readonly shared public Version←1.03

    ⎕IO←1 ⋄ ⎕ML←2 ⋄ ⎕WX←3

    :field shared NL←⎕AV[4]

    FS←(1+⍬⍴'Windows'⍷1⊃'.'⎕wg'APLVersion')⌷'/\'

    ∇ (id name)←nameOf code;tmp;ccode;ok;b
     ⍝ Find the name and its class from the code given
      'tmp'⎕NS''
     ⍝ Try to fix, if it fails try ⎕FIX
      :If 0∊1↑0⍴tmp.⎕FX code  ⍝ try with decorators
          :If ok←1≡≡ccode←code ⋄ ok←~0∊1↑0⍴tmp.⎕FX ccode←xcut NL,code ⋄ :EndIf
      :AndIf ~ok  ⍝ and without
          :Trap 11
              tmp.⎕FIX ccode
          :Else
      ⍝ We must remove any external ref (base class, interface, included nss)
              b←{(<\⍵)∨⌽<\⌽⍵}':'=⍬∘⍴¨ccode←{(+/∧\' '=⍵)↓⍵}¨ccode
              ccode←{⍵/⍨2>+\':'=⍵}¨b/ccode
              tmp.⎕FIX ccode
          :EndTrap
      :EndIf
      (id name)←tmp.((⎕NC⊂n),⊂n←,⎕NL⍳9)
      id←{3 4∊⍨t←⌊⍵:t ⋄ ⍵}id ⍝ all fns/ops under same id
    ∇

    ∇ str←str addTag tag
    ⍝ Add tag around string
      tag←('<'=1↑tag)↓(-'>'=¯1↑tag)↓tag ⍝ strip existing <>s
      str←'<',tag,'>',str,'</',((∧\' '≠tag)/tag),'>'
    ∇

    if←/⍨
    xcut←{⍺←1 ⋄ ⍺↓¨(⍵=1↑⍵)⊂⍵}
    adddec←{⍺←0 ⋄ f←('O<',t↑¯5↑⍺/'∇'),'>LP<[>Q<]>BI',⍕-t←-6⌈3+⌊10⍟n←⍴⍵ ⋄ (-~⍺)↓(↓f ⎕FMT 0,⍨¯1+⍳n),¨⍵,⊂''}
    isNs←{v←'x',⍨(⍵⍳NL)↑⍵ ⋄ v[(' '=v)⍳0]∊'⍝:'}
      fmt←{'∇'∊6⍴⍵:(nameOf ⍵),⊂⍵  ⍝ returns type, name, VR
          (nameOf v),1↓¨,/NL,¨v adddec⍨~isNs 1⊃v←{1≢≡⍵:⍵ ⋄ xcut NL,⍵}⍵}

    rlb←{(+/∧\' '=⍵)↓⍵}
    cEncl←{1≡≡⍵:⊂⍵⋄⍵}

      txtrep←{ ⍝ Replace substr by another
          (from to syn)←3↑⍺,0 ⍝ [3]=syntactically
          syn<1∊len←⍴,from:{b←from=v←⍵ ⋄ (b/v)←⊂to ⋄ ∊v}⍵
          (rs ls)←len ¯1⌽¨⊂syn{⍺:⍵∊(0≤⎕NC 256 1⍴⎕AV)/⎕AV ⋄ {0}¨⍵}⍵
          ~∨/hit←rs<ls<from⍷⍵:⍵
        ⍝ We have a hit, perform replacement
          strs←(1,1↓hit∨(-len)⌽hit)⊂⍵
          strs[2×⍳+/hit]←⊂to
          ∊strs
      }


    ∇ {r}←{x}PrepareCodeForHtml y;⎕IO;⎕ML;objids;ref;flag;cl;head;refs;⎕WX;n;type;names;b;nsi;titles;parms;allids;ids;code;tmp;i;t;id;nof;fname;anyleg;aplfonts
⍝ Takes APL code and creates either HTML snippets or a fully presentable HTML page.
⍝ The right argument might be one of:
⍝ 1) APL names treated as the names of functions/operators or scripts.
⍝ 2) a full path folder name or list of full path filenames
⍝ 3) nested vector of strings representing APL code (e.g. ⎕VRs)
⍝ 4) empty vector: the contents of the clipboard represents a fn/class
     
⍝ The left arg specifies how to produce the HTML:
⍝ -TITLE=: use the string as title for the HTML page produced
⍝ -FILENAME=: write result to filename specified (.html defaulted)
⍝ -FULL: a complete HTML page is created, including proper encoding information and some CSS.
⍝ otherwise an HTML snippet with <pre> around the code is created around each fn
⍝ FULL is the default if FILENAME is also supplied
⍝ -CLIPBOARD: the output goes to the clipboard
⍝ -XREF: produce a cross-reference for namespaces/classes
     
⍝ The fn will find all references and show them after each fn, producing HTML links between sections
⍝ if there are relationships and producing a legend at the bottom.
     
⍝ It also replaces all
⍝ & with &amp;
⍝ < with &lt;
⍝ > with &gt;
     
⍝ If y is empty, the contents of the clipboard is used as input. In that case the result
⍝ is written back to the clipboard as well unless a filename as been specified in the left arg
⍝ in which case an HTML-page with utf-8 encoding is created according to the rule above and written
⍝ under the filename specified.
⍝ If "filename" does not come with an extension, it defaults to "html"
⍝ Original code by Kai Jaeger ⋄ APL Team Ltd ⋄ 2009-01-09. This Version modified by DanB 01-20
     
⍝∇:Require =/../code/callingTree
     
      :If 0∊⎕NC'x' ⋄ x←'' ⋄ :EndIf
      :If 1≡≡parms←x
          parms←(⎕NEW ⎕SE.Parser'-full -filename= -title= -clipboard -xref').Parse x ⍝ parse left argument
      :EndIf
     
      :Access shared public
     
      'cl'⎕WC'Clipboard'                     ⍝ we create a Clipboard object
⍝ Let's determine what the RA is
      :If flag←0∊⍴r←y                        ⍝ if it's empty
          (type ids r)←⊂¨fmt cl.Text         ⍝ and take the text from the clipboard
      :Else ⍝ not empty
          y←,cEncl y ⋄ r←''
          :If 2∊##.⎕NC'THIS' ⋄ nsi←##.THIS
          :Else ⋄ nsi←⍎'⎕se'⎕WG'curspace'    ⍝ find where this all comes from
          :EndIf
          :If allids←∧/(⌊type←∊nsi.⎕NC y)∊3 4 9     ⍝ all code?
              ids←y~¨' ' ⋄ type←type-(1|type)×(⌊type)∊3 4
              :For id t :InEach y type       ⍝ get the code
                  :Select t
                  :CaseList 3 4              ⍝ for fns
                      r,←⊂nsi.⎕VR id
                  :CaseList 9.1 9.4 9.5      ⍝ and objects
                      r,←⊂∊NL,¨adddec nsi.⎕SRC nsi⍎id
                  :Else
                      'Right argument does not refer to code'⎕SIGNAL 11
                  :EndSelect
              :EndFor
     
          :ElseIf ∧/{'/\'∨.=1↑⍵:1 ⋄ ':\'≡2↑1↓⍵}¨r←y ⍝ are these full path filenames?
        ⍝ These may be folders. Grab all files in them
              'folder empty'⎕SIGNAL 11 if 0∊⍴r←⊃,/y{(⍺,FS)∘,¨⍵}¨fileInfo¨y
        ⍝ Read the files
              r←13 ⎕SE.SALTUtils.GetUnicodeFile¨r
        ⍝ Else it is code
          :EndIf
     
          :If ~allids ⍝ we need to find the name of each fn/class
              'Unknown APL name'⎕SIGNAL 11 if 0∊type
              (type ids r)←↓⍉⊃fmt¨r
              'Invalid object in file'⎕SIGNAL 11 if ¯1∊type
          :EndIf
     
      :EndIf
     
⍝ Each fn/class is preceeded by their name as title
      t←'Function ' 'Operator ' 'Namespace ' 'Interface ' 'Class '[3 4 9.1 9.5 9.4⍳type]
      objids←'obj'∘,¨⍕¨⍳⍴ids←,ids
      titles←(NL,¨'<hr><div id='∘,¨objids,¨'>'),¨addTag∘'h2'¨t,¨(ids addTag¨'i')
     
⍝ Find references
      code←type∊3 4
      refs←code\(code/ids){{⍵[⎕AV⍋⍕⍵;]}⍉⊃⌽⍺ ##.callingTree.Xrf ⍵}¨code/r
      r,¨←(code>0∊¨⍴¨refs)/¨⊂NL,NL,'List of references',NL
      r←r,¨120{(2/NL),⍨,NL,(n,fold×w)⍴v↑⍨w,⍨fold×n←⌈s[1]÷fold←⌊⍺÷w←2⌷s←⍴v←' ',' ',⊃,/v[;1],{' '≡⍵:'' ⋄ 1⌽') (',⍵}¨0 1↓v←⍵}¨refs
      :If parms.xref∧∨/t←type∊9.1 9.4
          (t/r),←{'Cross references',NL,,NL,(⎕NEW ##.callingTree,⊂⊂{⍵↓⍨⍵⍳' '}¨xcut NL,⍵).Xref}¨t/r
      :EndIf
     
      r←'<' '&lt;'∘txtrep¨'>' '&gt;'∘txtrep¨'&' '&amp;'∘txtrep¨r  ⍝ basic HTML replacements
     
⍝ We should be able to set up links for each fn displayed
      t←objids{⍵('<a href=#',⍺,'>',⍵,'</a>')}¨ids  ⍝ all HREFs
      n←{(⍵[;2],0)[⍵[;1]⍳ids]∊'GF'}¨refs           ⍝ only consider globals/fns
      r←r{⊃txtrep/⍵,⊂⍺}¨(code∧n∧↓∘.≠⍨⍳⍴ids)/¨⊂t,¨1 ⍝ do replacement except for themselves
     
⍝ Build the legend
      t←'G: global' '○: local' '!: unreferenced local' 'L: label' 'l: unreferenced label' 'F: function' 'R: Recursive fn'
      anyleg←0<⍴t←'  '∘,¨t[(∊1↑¨t)⍳' '~⍨∪∊0 1∘/¨refs]
      r[⍴r],←⊂anyleg/NL,'Legend',NL,∊t ⍝ put after the last display
     
⍝ We are done with the text; let's start creating the HTML
      r←∊titles,¨(r addTag¨⊂'pre'),¨⊂'</div>'
      r←'body'addTag⍨({0∊⍴⍵:'' ⋄ ⍵ addTag'h1'}parms.title~0),r
      :If parms.full
    ⍝ HEAD section; define styles
          head←{0∊⍴⍵:⍵ ⋄ ⍵ addTag'title'}parms.title~0
          head,←NL,'<meta http-equiv="Content-Type" content="text/html;charset=utf-8">',NL
          t←NL,'html {font-family: "Arial"; background-color: #F3F5F7; font-size: medium; margin:0; padding:0; }'
          aplfonts←'font-family: "APL385 Unicode", "APLX Upright", "APL2 Unicode";'
          t,←NL,'pre {',aplfonts,' font-size: medium;"}'
          head,←NL,t addTag'style type="text/css" media="screen"'
          t←NL,'html {font-family: "Arial"; font-size: x-small; margin:0; padding:0;}',NL
          head,←NL,t addTag'style type="text/css" media="print"'
          head addTag←'head'
          r←(head,NL,r)addTag'html'
      :EndIf
      :If parms.clipboard∨flag∧nof←0≡fname←parms.filename
          cl.Text←r
          :If nof ⋄ r←'Text in clipboard' ⋄ :EndIf
      :EndIf
      :If ~nof
          fname←{⍵,'.html'/⍨~'.'∊⍵↑⍨-⊥⍨~⍵∊'/\'}fname
          r ⎕SE.SALTUtils.PutUTF8File fname
          r←'Text in file "',fname,'"'
      :EndIf
    ∇

    ∇ r←{types}fileInfo name;⎕USING;f;tree
⍝ Return file information
      :Access shared
      :If 0=⎕NC'types' ⋄ :OrIf 0∊⍴types ⋄ types←'*' ⋄ :EndIf
      types←(xcut' ',types)~⊂''
      types←{'*'=c1←1↑⍵:⍵ ⋄ '.'=c1:'*',⍵ ⋄ '*.',⍵}¨types
     
      ⎕USING←'System.IO'
      r←⍬ ⋄ f←⎕NEW FileInfo,⊂⊂name
      :If f.Exists ⋄ r←f
      :ElseIf 1∊'Directory'⍷⍕f.Attributes
          f←⎕NEW DirectoryInfo,⊂⊂name
          r←⍕¨⊃,/f.GetFiles¨⊂¨types
      :EndIf
    ∇

:EndClass ⍝ HTMLdoc  $Revision: 739 $ 