﻿:Namespace UTILS

    (⎕ML ⎕IO)←1 0 ⍝ *** DO NOT change these system variables here, only after the variables definition 

⍝ === VARIABLES ===

    FNTBASE←¯10000

    _←⍬
    _,←(⎕ucs (⍳11),9014 12 13 619 94 9496 9488 9484 9492 9532 9472 9500 9508 9524 9516 9474 27 180 8739 30 31)
    _,←' !"#$%&''()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]∧_`abcdefghijklmnopqrstuvwxyz{|}~',(⎕ucs 127 8364 8867),'⊤⊥←→↑↓≤≥⍲⍱⎕⍞⌹⍙⍫∆∇⍋⍒⍕⍎⌈⌊⍀⌿⊂⊃∩∪∨',(⎕ucs 160),'¡¢£',(⎕ucs 8866 165)
    _,←'⌷§¨⍝⋄⍬≠≡⍪¯∘○⌽⍉⊖⍟¶',(⎕ucs 183),'⍺∊⍷≢⍳⍴⍵¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖ×ØÙÚÛÜÝþßàáâãäåæçèéêëìíîïðñòóôõö÷øùúûü',(⎕ucs 253 9064 9059)
    PCTT←_

    _ ←⊂'The utility programs are given here in namespace form.'
    _,←⊂'They can be configured differently, i.e. used without a'
    _,←⊂'namespace or placed elsewhere in your own namespace'
    _,←⊂'hierarchy. The only requirement is that the 7 programs'
    _,←⊂'and 2 variables exist in the same namespace. The variables are'
    _,←⊂'modifiable but not the programs.'
    _,←⊂''
    _,←⊂'Variable FNTBASE (file native tie base) is used to calculate'
    _,←⊂'the native file tie number so that it will not conflict with'
    _,←⊂'your application. As supplied (FNTBASE is -10000), FTIE 1 will'
    _,←⊂'result in ⎕NTIE ¯10001.'
    _,←⊂''
    _,←⊂'Variable PCTT (PC translate table) may also be changed if you'
    _,←⊂'have special requirements. It was derived using the default'
    _,←⊂'Dyalog translation table:   PCTT←⎕AV[⍋⎕nxlate 0]'
    _,←⊂''
    _,←⊂'Functions FTIE, FUNTIE, FSIZE, and FREAD work in their simplest'
    _,←⊂'modes only. Their use should be obvious. The purpose of these'
    _,←⊂'programs is to permit simple read access to *.SF files from within'
    _,←⊂'Dyalog APL/W. No attempt has been made to emulate an entire component'
    _,←⊂'file subsystem.'
    _,←⊂''
    _,←⊂'Make sure ⎕PATH contains ''UTILS'': '
    _,←⊂'   ⎕PATH←''UTILS'''
    Describe←∊_,¨⎕av[3]

    ⎕PATH,←' #.UTILS'

    ⎕ex '_'

⍝ === End of variables definition ===

    (⎕IO ⎕ML ⎕WX ⎕CT)←1 0 0 1E¯13

    ∇ F←FNAMES;R
      R←⍴F←(⎕NNUMS≤FNTBASE)⌿⎕NNAMES ⋄ F←,F
      F[(-⎕IO-(F='.')/⍳⍴F)∘.+⍳3]←' ' ⋄ F←0 ¯3↓R⍴F
    ∇

    ∇ T←FNUMS
      T←⎕NNUMS ⋄ T←(T≤FNTBASE)/FNTBASE-T
    ∇

    ∇ R←{Y}FREAD A;B;C;D;F;⎕IO;⎕ML;FRDAT;to83
      ⎕IO←0 ⋄ ⎕ML←3
      C←''⍴1↓A ⋄ F←FNTBASE-''⍴A
      to83←{t←⎕DR ⍵ ⋄ t=83:⍵ ⋄ t∊11 323 82:⎕IO⊃t 83 ⎕DR ⍵ ⋄ t≠163:∘ ⋄ n←⍴a←83 ⎕DR ⍵ ⋄ (n⍴1 0)/83 ⎕DR a} ⍝ 7/22/03 v10
      D←⎕NREAD F,323 19 0
      →E1⌈⍳C=.≥2↑D ⋄ A←F,323 1 ⋄ B←D[16] ⋄ C←C-1+D[13]
      →(D[18]∊0 1)⍴D[14]↓L0,L1,L2 ⋄ 'NONCE ERROR'⎕SIGNAL 500
     E1:'FILE INDEX ERROR'⎕SIGNAL 500
     L0:D←88+8×C ⋄ →L3
     L1:D←4 8 ⋄ D←D×(B÷D)⊤C ⋄ D←D[1]+⎕NREAD A,88+D[0] ⋄ →L3
     L2:D←4 4 8 ⋄ D←D×(B÷D)⊤C ⋄ D←D[2]+⎕NREAD A,D[1]+⎕NREAD A,88+D[0]
     L3:FRDAT←⎕NREAD F,83,⌽|⎕NREAD F,323 2,D    ⍝ | added 2/7/03 during wrapl tests jrg
      :If 2=⎕NC'Y'
          R←FRDAT
      :Else
          R←FRSUB 0
      :End
    ∇

    ∇ R←FRSUB A;N;P;Q;S;T
     ⍝ Recursive Subroutine for FREAD.
      T←256|FRDAT[A+10 11] ⋄ P←4×1+1↓T ⋄ T←''⍴T
      S←323 ⎕DR to83 FRDAT[(A+12)+⍳P] ⍝ 7/2/2003 for v10
      N←(''⍴S)⌈T=4 ⋄ S←1↓S ⋄ P←A+12+P
      Q←⌈N×(1 0.125 4 8 4 10)[T] ⋄ T←(0 11 323 645 1 2)[T]
      A←P↓FRDAT ⋄ A←to83 Q↑A ⋄ →T↓L0,L1,L2  ⍝ 7/2/2003
     ⍝ Numeric Array
      A←T ⎕DR A ⋄ →L5 ⍝===⍝
     ⍝ Character Array
     L0:           ⍝=== TRANSLATE CHAR DATA HERE ===⍝
      A←256|A
      A←PCTT[A]
      →T↑L3 ⋄ →L5
     ⍝ Nested Array  ('⌈T=4' above keeps templates; use '→N↓L5⋄' next if not.)
     L1:A←FRSUB¨323 ⎕DR A ⋄ →L5 ⍝===⍝===⍝
     ⍝ Heterogenous Array
     L2:Q←(0 11 323 645 1)[256|A[10×⍳N]] ⋄ N←0 2↓(N,10)⍴A
      P←(Q=0)/⍳⍴Q ⋄ A←N[P;0] ⋄ N←,/N
      →(⍴A)↓L3 ⋄ →L0 ⍝ Translate char elems and ret to L3
     L3:N[P]←A ⋄ A←N ⋄ N←0
      →(⍴P←(Q>1)/⍳⍴Q)↓L4
      A[P]←(⊂'')⍴¨Q[P]⎕DR∘to83¨A[P] ⍝===⍝===⍝
     L4:→(⍴P←(Q=1)/⍳⍴Q)↓L5
      A[P]←FRSUB¨323 ⎕DR to83,⊃4↓¨A[P] ⍝===⍝===⍝
     L5:R←S⍴A
    ∇

    ∇ F←FSIZE F
      F←(⎕NREAD(FNTBASE-1↑F),323 19 0)[⎕IO+0 1 6 15 8]
    ∇

    ∇ {T}←F FTIE T;⎕IO
    ⍝ Tie file F to tie number T
      ⎕IO←0
      :If (0=1↑T)∧0≢F
          ⎕SIGNAL⊂('EN' 11)('Message' 'APL+ does not accept tie number 0')
      :EndIf
      :If 0 0≡F T
          PCTT←⎕AV[⍋⎕NXLATE 0]
      :Else
          F←⌽{(∨\' '≠⍵)/⍵}⌽F  ⍝ dtb
          F←F,(~'.'∊F)/'.SF'
          T←FNTBASE-T ⋄ F ⎕NTIE T
      :End
    ∇

    ∇ FUNTIE T
      ⎕NUNTIE FNTBASE-T
    ∇

:EndNamespace ⍝ UTILS  $Revision$
