﻿:Namespace Windows
    
    ⎕io←⎕ml←1 ⋄ LF CR ←2↓4↑⎕av
    
    rls←{(+/∧\⍵∊' ',CR,LF)↓⍵} ⍝ remove leading spaces
    
⍝ Transform a menu definition (text) into a structure for <makeMenu>
⍝ Each definition starts with [menu] and end with [endmenu]
⍝ Each definition is made up of a series of statements separated by ';'
⍝ CRs are unimportant. 
    
⍝ Example: suppose you want to call function <#.which> when one of the
⍝ items in a menu it chosen you could define
⍝ which←{⍴⍴⍴⎕←⍵} 
⍝ and define a menu to be
⍝ button1 and submenu1 with 2 buttons like this:
⍝   txt←'[menu]b1:#.which; subm: [menu] sb1:#.which; sb2:#.which [endmenu] [endmenu]'
⍝ You then prepare the menu and call it:
⍝   popup←Windows.defineMenuItems txt    
⍝   Windows.makeMenu popup    
    
    ∇ r←defineMenuItems txt;cut;mask
    ⍝ Define each menu item in text. First remove extra spaces:
      txt←∊'\s*\[((end)?)menu\]\s*' '\s*;\s*' '\s+'⎕R'[\1menu]' ';' ' '⊢txt
      'improper format'⎕SIGNAL 11↓⍨'[endmenu][menu]'≡15↑¯9⌽txt
    ⍝ Remove also the [endmenu] string
      txt←6↓¯9↓txt ⋄ txt,←';' ⋄ ((txt=CR)/txt)←' '
    ⍝ We must determine where each item is. They all end with ';'
    ⍝ but we must not consider those between [menu]...[endmenu]:
      mask←0=(+\'[menu]'⍷txt)-+\'[endmenu]'⍷txt
      'menu/endmenu mismatch'⎕SIGNAL 11↓⍨¯1↑mask
      cut←¯1⌽mask∧';'=txt
      txt←(∨/¨r≠' ')/r←¯1↓¨cut⊂txt ⍝ remove empties
      r←↑def1item¨txt
    ∇
    
⍝ Translate item text into a 2 element structure.
⍝ An item is an entry (a string) and possibly the name of a callback fn
⍝ or another (sub)menu with the same definition
⍝ The result is therefore a string+blank (scalar) OR 2 strings OR
⍝ a string with another definition. Depth may vary.
    
    ∇ r←def1item item;arg;b;def
    ⍝ A colon MUST separate the caption from its definition
      b←∨\item=':' ⋄ arg←rls 1↓b/item ⋄ def←rls(~b)/item
      r←def' '
      →(⍴arg)↓0 ⍝ is that it?
      :If '[menu]'≡6↑arg
          arg←defineMenuItems arg
      :EndIf
      r←def arg
    ∇
    
⍝ Show a POPUP menu from list
⍝ 'list' is a series of items to show and possibly act upon
⍝ It is a 2 col table of [;0]=caption, [;1]=definition: either a callback fn
⍝ or a same type structure (recursive defn)
    
    ∇ {r}←{Obj}makeMenu list;names;M;dq;⎕IO;⎕ML;windef;Obj;cat;out
    ⍝ See <defineMenuItems> for details
      ⎕IO←⎕ML←0 ⋄ dq←'M'
      :If 0=⎕NC'Obj' ⋄ Obj←dq ⋄ :EndIf   ⍝ is there a parent for this?
      out←Obj≢dq                         ⍝ shall we get OUT after creation?
    ⍝ define each item as a menu or menu item reacting on selection
    ⍝ 1st define some utilities:
      cat←{(⊂⊂⍺),¨⊂¨⍵}       ⍝ catenate a string to a list of items
     
      windef←{nam←0⊃⍺ ⍝ ⍺ is 'id caption'
          top←⍺[0],⊂'menu'('caption'(1⊃⍺))               ⍝ top menu
          nam←(⊂nam,'.'),¨(1↑⍴⍵)↑⎕A                      ⍝ & siblings
          more←~men←1≥|≡¨⍵[;1]                           ⍝ submenus
          lis←' '≡¨evn←men/⍵[;1] ⋄ (lis/evn)←1           ⍝ report to APL those events
          lis←('caption'cat men/⍵[;0]),[0.1]('event'cat 30,¨⊂¨evn)
          lis←top⍪(men/nam),[0.1]↓(⊂'menuitem'),lis
          ~∨/more:lis                                    ⍝ any more?
          sub←↓(more/nam),[0.1]more/⍵[;0]                ⍝ yes, find them
          sub ∇¨←more⌿⍵[;1]                              ⍝ process them
          lis⍪⊃⍪/sub                                     ⍝ and add them
      }
      r←0  ⍝ default value
      names←(out,0)↓Obj'!'windef list
      names←names[⎕AV⍋↑names[;0];]                       ⍝ keep original order
      ⎕WC/names                                          ⍝ create all objects
      →out⍴0                                             ⍝ do we need this?
      →(0=⍴dq←⎕DQ Obj)⍴0                                 ⍝ no, ask now
      r←1+⎕A⍳(⍴Obj)↓'.'~⍨⊃dq                             ⍝ return object selected
    ∇
    
:EndNamespace ⍝ Windows  $Revision: 808 $ 