﻿:Namespace aplUtils
    
    condEncl←{⊂⍣(1∊≡⍵)+⍵}
    
      uDisp←{⎕IO ⎕ML←0                        ⍝ Boxed sketch of nested array.
     
          ⍺←0 ⋄ opt←⍺                         ⍝ ⍺: 0-plain boxes, 1-decorated.
     
          ul uc ur←'┌┬┐' ⋄ vt←'│'             ⍝ upper──┐ ┌───left  ⋄  vertical.
          ml mc mr←'├┼┤' ⋄ hz←'─'             ⍝ middle─┼×┼─centre  ⋄  horizontal.
          ll lc lr←'└┴┘'                      ⍝ lower──┘ └──right
     
          box←{                               ⍝ Recursively box nested array
              isOr ⍵:⎕FMT⊂⍵                   ⍝ ⎕or: '∇name'.
              1≥|≡⍵:⎕FMT open ⍵               ⍝ simple array: format.
              subs←expand ∇¨matr open ⍵       ⍝ expanded boxed sub-arrays.
              odec←(shape ⍵)outer subs        ⍝ outer type and shape decoration.
              idec←inner ⍵                    ⍝ inner type and shape decorations.
              (odec,idec)collect subs         ⍝ collected, formatted sub-arrays.
          }
     
          expand←{                            ⍝ Align and centre sub-arrays.
              rows cols←sepr⍴¨⍵               ⍝ sub-array dimensions.
              sizes←(⌈/rows)∘.,⌈⌿cols         ⍝ expanded sub-array sizes.
              v h←sepr⌈0.5×↑(⍴¨⍵)-sizes       ⍝ vertical and horizontal rotation.
              v⊖¨h⌽¨sizes↑¨⍵                  ⍝ centred expanded sub-arrays.
          }
     
          outer←{                             ⍝ Outer decoration.
              on←{⍺:⍺⍺ ⍵ ⋄ ⍵}                 ⍝ conditional function application.
              sizes←1 0{⊃↓⍺⍉on ⍵}¨sepr⍴¨⍵     ⍝ row and col sizes of sub-arrays.
              sides←sizes/¨¨vt hz             ⍝ vert and horiz cell sides.
              bords←1↓¨ml uc glue¨sides       ⍝ joined up outer borders.
              ↑,¨/(ul'')⍺ bords(ll ur)        ⍝ vertical and horizontal borders.
          }
     
          inner←{                             ⍝ Inner sub-array decorations.
              deco←{(type ⍵),shape ⍵}         ⍝ type and shape decorators.
              sepr deco¨matr open ⍵           ⍝ decorators: tt vv hh .
          }
     
          collect←{                           ⍝ Collect sub-arrays.
              lft top tt vv hh←⍺              ⍝ array and sub-array decorations.
              boxes←vv right(tt hh)lower ⍵    ⍝ cells boxed right and below.
              lft,top⍪↑⍪⌿,/open boxes         ⍝ completed collection.
          }
     
          lower←{                             ⍝ Border below each sub-array.
              bot←{⍵⍪(-1⊃⍴⍵)↑⍺ split ⍵}       ⍝ lower border.
              split←{((¯2+1⊃⍴⍵)/hz)glue ⍺}    ⍝ decorators split with horiz line.
              (matr↑,¨/⍺)bot¨matr ⍵           ⍝ cells bordered below.
          }
     
          right←{                             ⍝ Border right each sub-array.
              types←2⊥¨(⍳⍴⍵)=⊂¯1+⍴⍵           ⍝ right border lower corner types.
              chars←mc mr lc lr[types]        ⍝    ..     ..      ..      chars.
              rgt←{⍵,(¯2+⊃⍴⍵)1 1/vt,⍺}        ⍝ form right border.
              ((matr ⍺),¨chars)rgt¨⍵          ⍝ cells bordered right.
          }
     
          type←{                              ⍝ Type decoration char.
              opt<|≡⍵:hz                      ⍝ nested: '─'
              isOr ⍵:'∇'                      ⍝ ⎕or:    '∇'
              sst←{                           ⍝ simple scalar type.
                  0=opt×⍴⍴⍵:hz                ⍝ undecorated or scalar ⍕⍵: char,
                  (⊃⍵∊'¯',⎕D)⊃'#~'            ⍝ otherwise, number or space ref.
              }∘⍕                             ⍝ ⍕ distinguishes type of scalar.
              0=≡⍵:sst ⍵                      ⍝ simple scalar: type.
              {(1=⍴⍵)⊃'+'⍵}∪,sst¨open ⍵       ⍝ array: mixed or uniform type.
          }
     
          shape←{                             ⍝ Row and column shape decorators.
              0=opt×⍴⍴⍵:vt hz                 ⍝ scalar or no decoration.
              cols←(×¯1↑⍴⍵)⊃'⊖→'              ⍝ zero or more cols.
              rsig←(××/¯1↓⍴⍵)⊃'⌽↓'            ⍝ zero or more rows.
              rows←(¯1+3⌊⍴⍴⍵)⊃vt rsig'⍒'      ⍝ high rank decorator overrides.
              rows cols                       ⍝ shape decorators.
          }
     
          matr←{↑,↓⍵}                         ⍝ Matrix from non-scalar array.
          sepr←{+/¨1⊂↑⍵}                      ⍝ Vec-of-mats from mat-of-vecs.
          open←{(1⌈⍴⍵)⍴⍵}                     ⍝ Stretch to expose nulls.
          isOr←{1 ⍬≡(≡⍵)(⍴⍵)}                 ⍝ Is ⎕or of object?
          glue←{↑⍺{⍺,⍺⍺,⍵}/⍵}                 ⍝ Intersperse ⍵ with ⍺s.
     
          box ⍵                               ⍝ Recursively box nested array.
      }
    
      repObj←{             ⍝ String representation of object V0.27
     ⍝ This version accounts for ⎕TC type characters
          ⍵≡⍬:'⍬' ⋄ ⍵≡'':'''''' ⋄ ⍵≡⎕NULL:'⎕NULL'
          scal←0∊rank←+/⍴s←⍴⍵ ⋄ char←>/(simple num)←∧\~(10|⎕DR 1/⍵)∊¨6(0 2)
          scal∧1=≡R←⍵:÷⎕←'Cannot display ⎕ORs'   ⍝ no funny objects
          scal∧9=⎕NC'R':⍕⍵ ⍝ display refs as they are
     
         ⍝ Reduce object to 1 item if all same elements
          mod←(0<rank)∧(n=0)∨(5×char)<n←×/s
          mod←mod∧as←char{0∊⍴⍵:1 ⋄ ⍵∧.≡1↑⍵}obj←,⍵ ⍝ as: all the same
          obj←1(↑⍣mod)obj  ⍝ take only 1st? (grab prototype if empty)
          shape←mod{⍵≡,1:',' ⋄ (⍺∨1<⍴⍵)/'⍴',⍨⍕⍵}s
          shape←shape,(encl←simple<as)⍴'⊂'
          ⍺←0              ⍝ recursive call?
     
         ⍝ Simple scalars and char vector≠⍴1 do not need parens
          parens←⍺∧simple≤(0<⍴shape)∨(rank=1)∧num∨∨/(4↑⎕AV)∊⍵
          (lp rp)←parens⍴¨'()'
          ~simple:rp,⍨lp,shape,encl{⍺⍲'('=1↑⍵:⍵ ⋄ 1↓¯1↓⍵}1↓⊃,/' ',¨{'⎕'=1↑⍵:'(',⍵,')' ⋄ ⍵}¨1 ∇¨obj
     
         ⍝ Simple objects (char should account for ⎕TC chars et al.)
          ⎕PP←17 ⍝ for numbers
          obj←shape,num{⍺:⍵ ⋄ qu←{Q,((1+t=Q)/t←⍵),Q←''''} ⋄ ⎕ML←1 ⋄ ⎕IO←0
              ~∧/⍵∊⎕AV:'⎕UCS ',⎕UCS ⍵
              ~∨/sc←⍵∊4↑⎕AV:qu ⍵ ⍝ no special chars?
             ⍝ If only a few chars transform the whole string into ⎕AV
              av←{1⌽']⎕av[⎕io',(t≢,0)/'+',⍕t←,⎕AV⍳⍵}
             ⍝ More than a few; create a mixture of ⎕AV[...] and 'quotes'
              N←6 ⍝ how much non ⎕TC chars to include between sections; that number is subjective
              c∨←N≥∊⍴¨c←sc⊂⍨1,1↓sc≠¯1⌽sc ⍝ mark those sections
              ∧/sc←∊c:av ⍵ ⍝ are the pieces small enough to be all in ⎕AV?
              c←1,1↓sc≠¯1⌽sc
              ∊{⍺,',',⍵}/(c/sc){⍺:av ⍵ ⋄ qu ⍵}¨c⊂⍵
          }⍕obj
          lp,obj,rp
      }
    
    ∇ t←isEncl arg
    ⍝ Is arg Enclosed
      t←1<|≡arg
    ∇
    
    ∇ b←isChar obj
    ⍝ Is Object character
      b←(10|⎕DR 1/obj)∊0 2
    ∇
    
    ∇ b←isVTV v
    ⍝ Whether arg is a list (Vector) of Text Vectors
      →0↓⍨b←(1∊⍴b)>0∊b←⍴v ⋄ →0↓⍨b←326∊⎕DR 1/v
      →0↓⍨b←∧/isChar¨v ⋄ b←1∧.≥⊃,/⍴∘⍴¨v
    ∇
    
:EndNamespace ⍝ aplUtils  $Revision: 739 $ 