﻿:Namespace CodeCov

    Version←2.0

    ⎕io← ⎕ML ←0 ⍝ *** DO NOT change these system variables here, only after the variables definition

⍝ === VARIABLES ===

⍝ 0. the :statement ID
⍝ 1. if it is an 'end' statement
⍝ 2. if it causes a branch above
⍝ 3. if it is a conditional branch
⍝ 4. if this statement is the target of a branch
⍝ 5. if the next statement is the target of a branch
⍝ 6. if this statement does NOT leave a trace in ⎕MF
⍝ 7. if this statement is an unconditional branch (like :else)
⍝ 8. 200⌶ code
⍝ 9. Block code

    _← ⊂':if'        0 0 1 0 0 0 0   123  'I'
    _,←⊂':elseif'    0 0 1 1 0 0 0   126  'E'
    _,←⊂':else'      0 0 0 0 1 0 1   127  'e'
    _,←⊂':endif'     1 0 0 0 1 0 0   128  'i'
    _,←⊂':for'       0 0 0 0 1 0 0   134  'F'
    _,←⊂':endfor'    1 0 1 0 0 0 0   136  'f'
    _,←⊂':continue'  0 0 0 0 0 0 1   148  'c'
    _,←⊂':leave'     0 0 0 0 0 0 1   149  'l'
    _,←⊂':repeat'    0 0 0 0 1 0 0   131  'R'
    _,←⊂':endrepeat' 1 0 0 0 0 0 1   133  'r'
    _,←⊂':until'     0 0 1 0 0 0 0   132  'u' ⍝ could be While or Repeat
    _,←⊂':andif'     0 0 1 0 0 0 0   124  'A'
    _,←⊂':orif'      0 0 1 0 0 0 0   125  'O'
    _,←⊂':while'     0 0 1 1 0 0 0   129  'W'
    _,←⊂':endwhile'  1 0 0 0 1 0 1   130  'w'
    _,←⊂':select'    0 0 0 0 0 0 0   137  'S'
    _,←⊂':case'      0 0 1 1 0 0 0   138  'C'
    _,←⊂':caselist'  0 0 1 1 0 0 0   139  'C'
    _,←⊂':endselect' 1 0 0 0 1 0 0   141  's'
    _,←⊂':goto'      0 0 1 0 0 0 0   146  ' '
    _,←⊂':return'    0 0 0 0 0 0 1   147  '>'
    _,←⊂':trap'      0 0 0 0 0 0 0   159  'T'
    _,←⊂':endtrap'   1 0 0 0 1 0 0   160  't'

    _,←⊂':end'       1 0 0 0 0 0 0   142  '?' ⍝ this is special
    _,←⊂':with'      0 0 0 0 0 0 0   163  'Z' ⍝ these in DYW only
    _,←⊂':endwith'   1 0 0 0 0 0 0   164  'z'
    _,←⊂':hold'      0 0 0 0 0 0 0   161  'H'
    _,←⊂':endhold'   1 0 0 0 0 0 0   162  'h'
    ⍝ :in is 135, :ineach is 165
    CS←↑_

    _←⍬
    _,←⊂'   Control statements are not treated the same way for all APLs.  '
    _,←⊂'   Here is a list of differences between some of the main vendors.'
    _,←⊂''
    _,←⊂'    ⊥ means the statement immediately ABOVE acts as a branch statement'
    _,←⊂'    → means it acts as a  CONDITIONAL   branch statement'
    _,←⊂'    > means it acts as an UNCONDITIONAL branch statement'
    _,←⊂'    × means it does not appears in the ⎕mf report'
    _,←⊂'    : means is target of a branch                '
    _,←⊂'    ⊤ means next statement is target of a branch '
    _,←⊂''
    _,←⊂'    <CCfindbehav> is used to find the exact bevaviour.  '
    _,←⊂'    This will report statements like :else as branch statement but'
    _,←⊂'    it is not a CONDITIONAL branch. Same for :endfor and all branch'
    _,←⊂'    stmts (e.g. :leave)                         '
    _,←⊂'    <MakeCS> is used to build CS from this data.'
    _,←⊂'    See CCinithow for details.                  '
    _,←⊂''
    _,←⊂'   APL           Dyalog                    APL+Win'
    _,←⊂'   id            DYW                       A2K'
    _,←⊂'1  :if ⍵         →                         →  '
    _,←⊂'2  :elseif ⍵     →:                        ⊥→:'
    _,←⊂'3  :else         ⊤>                        ⊥:⊤'
    _,←⊂'4  :endif                                  ×⊤ '
    _,←⊂'5  :for x :in ⍵  ⊤                         ⊤once→      '
    _,←⊂'   "in" goes with the "for" statement (same as "ineach")'
    _,←⊂'7  :endfor       →                         →⊤:'
    _,←⊂'8  :continue     >                         ×⊥ '
    _,←⊂'9  :leave        >⍝"end"+1                 ⊥→ ⍝ "end"+1'
    _,←⊂'10 :repeat       once⊤                     ×    '
    _,←⊂'23 :endrepeat    >⍝+⊤with :continue        ⊥⊤×  '
    _,←⊂'11 :until ⍵      →                         →⊤:  '
    _,←⊂'12 :andif ⍵      → ⍝ see note 1            →⊥  '
    _,←⊂'13 :orif  ⍵      → ⍝ see note 2            →⊥  '
    _,←⊂'14 :while ⍵      →:end+1                   →:end+1'
    _,←⊂'15 :endwhile     >                         ×while⊤'
    _,←⊂'16 :select ⍵                               →once  '
    _,←⊂'17 :case   ⍵     →:                        →:     '
    _,←⊂'18 :endselect    at end only               :⊤only if no select        '
    _,←⊂'19 :goto L       →                         →  '
    _,←⊂'20 :return       >                         ⊥× '
    _,←⊂'21 :trap ⍵       once                      NA '
    _,←⊂'22 :endtrap                                NA '
    _,←⊂''
    _,←⊂'   Because × leaves no reference count in ⎕MF we must add a dummy     '
    _,←⊂'   statement on lines where they are used. This is only for APL+Win.   '
    _,←⊂''
    _,←⊂'   Note 1: only the statement following the last ANDIF in a REPEAT    '
    _,←⊂'   group can be the target of a branch.                               '
    _,←⊂''
    _,←⊂'   Note 2: only the statement following the last ORIF in any group    '
    _,←⊂'   can be the target of a branch.'
    _,←⊂'   Also, the line after :Until is the target of a branch in :While blocks.'
    _,←⊂''
    _,←⊂'→  The possible contructs are:                        '
    _,←⊂'   1 (12|13)* (2 (12|13)*)* 3? 4               ⍝ if   '
    _,←⊂'   5  (8|9|19|20)* 7                           ⍝ for  '
    _,←⊂'   10   (9|19|20)* ((11 (12|13)*)|23)          ⍝ repeat (continue also allowed but not included here)                              '
    _,←⊂'   14 (12|13)* (8|9|19|20)? (15|(11 (12|13)*)) ⍝ while        '
    _,←⊂'   16 17+ 3? 18                                ⍝ select       '
    _,←⊂'   21 3? 22                                    ⍝ trap (special)'
    ControlStmts←↑_

    C←⎕av[3]
    _←   'This namepace will help do code coverage of functions.',C
    _,←C,'This will work for functions in the current namespace:',C
    _,←C,' 1. Bring in the code which will reside in CodeCov (this namespace)',C
    _,←C,' 2. Use <CCinit> as in CCinit ''list of functions'' to report on code that prevents'
    _,←C,'<CC> (below) from doing its job properly. The rigft arg is a list of name patterns.'
    _,←C,'See <CCinithow> for details.'
    _,←C
    _,←C,'Functions will be reformatted to allow <CC> to work properly. The backup copy of e.g.'
    _,←C,'<MyFn> will be kept in ''MyFn⍙BU''.'
    _,←C,' 3. Run your code.',C
    _,←C,' 4. Use CC ''same or subset of the list of functions'''
    _,←C,'to show lines that were not used, branched into, branches NOT taken, etc.'
    _,←C,'See the accompanying Word or PDF document for details.'
    Describe←_

    _ ←⊂'Legend:'
    _,←⊂'x line never executed'
    _,←⊂'→ branch always taken'
    _,←⊂'↓ branch never  taken'
    _,←⊂': label  never used'
    _,←⊂'? questionable line'
    _,←⊂'* line ignored'
    CClegend←↑_

    CCshowlegend←1

    CCunBranchStmts←':Else' ':endrepeat' ':endwhile' ':continue' ':leave' ':return'

    CCwindow←2                            ⍝ how many lines to show before and after problems

    CCskipOK←0                            ⍝ do we skip the display of programs that are OK?

    CCseparator←'∇'

    CCextras←0                            ⍝ do not show extras by default

    ⎕ex¨'C_'

⍝ === End of variables definition ===

    ⎕IO ⎕ML ←0 2

    ∇ r←APL;⎕IO
     ⍝ Find the APL we're in
      ⎕IO←0 ⋄ r←(5 3⍴'SAMSAXDYWA2KAPX')[21 251 245 6 91⍳⎕AV⍳'←';]
    ∇

    SQZ← {⍵/⍨b∨1⌽b←' '≠⍵} ⋄ WHR← {⍵/⍳⍴⍵} ⋄ SPLIT←~∘' '¨↓ ⋄ LJUST←{(+/∧\' '=⍵)⌽⍵}

    ∇ cc←{NS}CC RA;any;b;bf;bg;bi;bo;br;c;cba;cbr;counts;cr;CRs;cs;dubious;f;F;first;Fn;for;hits;i;lab;lb4;lu;n;name;nnu;Pnames;r;rem;rlab;showlegend;skipOK;t;type;Window;Wsep;Xtra;⎕IO;⎕ML
     ⍝ Produce code coverage report for fns.
     ⍝ This program works two ways:
     ⍝ 1. with a 2 or 3 column RA: Program names, CRs, and possibly count data
     ⍝ 'CRs' is the ⎕CR of program and flags. 'RA' is list of line counts.
     ⍝ 2. with a string: program names and some switches:
     ⍝ -window=  to specify the number of lines before and after each problematic line
     ⍝ -nolegend to remove the legend
     ⍝ -ignoreok to remove all display of correct code
     
      :If 0=⎕NC'NS'
          NS←0⊃⎕RSI
      :ElseIf ~0∊⍴⍴NS ⍝ old format?
          RA←0,NS,⍪1⌷¨⍉¨RA
      :EndIf
     
      Window←CCwindow ⋄ showlegend←CCshowlegend ⋄ skipOK←CCskipOK ⋄ Wsep←CCseparator ⋄ Xtra←CCextras
     
      :If 2∊⍴⍴RA
          (Pnames CRs counts)←⊂[0]3↑[1]RA,0
      :Else
          :If ~0∊⍴RA
              RA←(⎕NEW ⎕SE.Parser'-nolegend -ignoreok -window= -separator= -extras').Parse RA
              Window←CCwindow RA.Switch'window'
              showlegend←~(~CCshowlegend)RA.Switch'nolegend'
              skipOK←CCskipOK RA.Switch'ignoreok'
              Wsep←CCseparator RA.Switch'separator'
              Xtra←CCextras RA.Switch'extras'
              RA←RA.Arguments
          :EndIf
          :If 0∊⍴RA                       ⍝ '' means all available data
              b←'⍙CR'∘≡¨¯3↑¨F←NS.⎕NL-2
              CRs←NS⍎¨b/F ⋄ Pnames←¯3↓¨b/F
          :Else
              Pnames←SPLIT NS ⎕SE.UCMD'varslike ',⍕RA,¨⊂'⍙CR'
              :If ∨/t←'.'∊⍕RA
                  Pnames←Pnames,¨⍨⊂{(-⊥⍨'.'≠⍵)↓⍵}⎕IO⊃RA
              :EndIf
              CRs←{0::{0 0⍴''}¨⍵ ⋄ NS⍎¨⍵}Pnames
              Pnames←¯3↓¨Pnames
          :EndIf
          counts←{0}¨CRs
      :EndIf
      cc←0 1⍴⊂''
      first←1
      :For name cr n :InEach Pnames CRs counts
          :If 0≡n
              {}'monitoring off'=⍳×⍴n←(NS.⎕MONITOR name)[;1]
          :EndIf
          :If '** Unable'≡9⍴cr
              →add⊣r←(1,⍴cr)⍴cr
          :EndIf
          rlab←1=lab←' :'⍳cr[;1] ⋄ cbr←'→'=br←cr[;2] ⋄ bg←'*'≠type←cr[;3] ⍝ *=ignore these lines
     
          nnu←1⌽~lu←n≠0                   ⍝ line used & next not used
     
          r←⍉⍪'** program <',name,'> was not used'
          →add if∧/nnu                    ⍝ skip section if no line was executed
     
          F←{(0,+/∧\' '∧.=⍵)↓⍵}0 4↓cr
          r←⍪' x'[lu<bg]                  ⍝ lines not executed
     
        ⍝ :For loops should only be noted if their # hits are only used once
          for←WHR f←type∊'F' ⋄ dubious←lu∧f\bf←=/n[for∘.+0 1] ⋄ for←f∨(¯1↓0,f)∧b←type=' '
          for∨←f∨b∧¯1↓0,f←type∊'f'
     
        ⍝ Following are (some "controlled") branches
          bi←0,1↓n>¯1⌽n                   ⍝ branched in
          bo←0,⍨2>/n                      ⍝ branch out
     
        ⍝ A branch is never used if it has an equal (or smaller) execution times
          t←' ↓'[for<(1⌽lab)<n≤1⌽n]       ⍝ never taken unless following line is label
          (nnu/t)←'→'                     ⍝ always taken (line used, next NOT used)
          b←bg∧lu∧cbr                     ⍝ good, used and conditional branch
          r←r,b\b/t
          r←r,' :'[Xtra∧bg∧lu∧for<rlab>bi] ⍝ all labels should be used
          f←bo∧br=' '                     ⍝ branch out without a branch statement?
          :If Xtra⊣t←' '
        ⍝ Line 0 and 1 are special
              c←1+t←'W'≠1↓2↑type          ⍝ While block on line 1?
              b←(⍴f)↑(c↑t∧≠/2↑n),c↓f∨bi>lab
        ⍝ :Select can have comments after
              c←(type='S')≤1⌽bg
              t←' ?'[lu∧c∧b] ⋄ (for/t)←' ?'[for/dubious]
          :EndIf
          r←r,t
          f[0]←skipOK≤∨/f←r∨.≠' ' ⋄ hits←f∧bg ⍝ oddnesses
          c←1+2×Window
          hits←(-c)↓↑∨/(Window-⍳c)⌽¨⊂hits,c⍴0
          f←(('P⍞[⍞Q⍞]⍞LI',⍕4+⌊10⍟c)⎕FMT⍳c←1↑⍴F),F ⍝ add line nos
          r←r,' ',(⍕((1↑⍴n),1)⍴n),' ',f
          lb4←hits<1↓hits,0               ⍝ the line before each group of hits
          bo←lb4>hits<¯1↓0,hits           ⍝ those to mark as [...]
          n←''⍴⌽⍴r                        ⍝ width of r
          r[bo/⍳⍴bo;]←(+/bo)n⍴n↑'[...]'
          r←(hits∨lb4)⌿r                  ⍝ keep the hits and the line before
          :If skipOK≤∨/hits               ⍝ don't display OK programs if so desired
     add:     cc←cc⍪⊂{first>showlegend:⍵ ⋄ ' '⍪((¯1↑⍴⍵)⍴Wsep)⍪' '⍪⍵}r
              first←0
          :EndIf
      :EndFor
      :If skipOK∧0∊⍴cc
          cc←1 1⍴⊂'* All programs seem fine'
      :ElseIf showlegend∧~0∊⍴cc
          cc←cc⍪⍨⊂cc{(b,⍨∨/b←1↓⍵[;0]∊⊃4↑[1]¨⍺)⌿⍵}CClegend
      :EndIf
    ∇

    ∇ r←{b}CCcut array;drop;⎕ML
      ⎕ML←1 ⋄ ⍎(drop←0=⎕NC'b')/'b←array=1↑array'
      r←drop↓¨b⊂[⎕IO]array
    ∇

    ∇ r←CCenlist r
      r←⊃,/r,⊂⍬
    ∇

    ∇ ids←CCextractids mat;b;i;lav;rb;stm;⎕IO
     ⍝ Extract :IDs from MATrix
      ⎕IO←0 ⋄ rb←∨/b←' APL '⍷mat ⋄ i←rb⍳1
     ⍝ The line with 'APL' is the start of the interesting information
      i←b/⍳⍴b←b<¯1⌽b←mat[i;]=' '          ⍝ that line also shows how
      mat←(2↑2+rb⍳1)↓mat[;⍳i[1]]          ⍝ all the text is divided
      mat←(mat∨.=':')⌿mat                 ⍝ these are the row with :statements
      b←0≠ids←⍎,' ','0',mat[;⍳i[0]]       ⍝ AND ids (a number)
      lav[(⎕AV⍳'A')+⍳26]←26↑(⎕AV⍳'a')↓lav←⎕AV
      mat←lav[⎕AV⍳b⌿mat]                  ⍝ ensure lowercase
      ids←⊂b/ids                          ⍝ the numbers (IDs)
      i←-b⊥¨b←' '=mat←⊂[1](0,i[0])↓mat
     ⍝ Special case for 'else' to differentiate from 'elseif'
      stm←i↓¨mat ⋄ stm[stm⍳⊂':else']←⊂':Else'
      ids←ids,⊂stm
    ∇

    ∇ r←{fmt}CCfindbehav c;b;e;i;ids;stmts;tests;⎕IO;⎕ML
     ⍝ Determine how the :stmts behave in this APL
     ⍝ Result is ID, BranchBEFORE, IsBranch, IsTarget, Is1+Target, NotUsed
      ⎕IO←1 ⋄ ⎕ML←2
      (ids stmts)←CCextractids c
      r←CCgencombs c                      ⍝ all the various possibilities
      tests←(⊂ids)⍳¨⊃,/r                  ⍝ as indices
      r←⊃⍪/r←CCteststmts¨tests⊃¨¨⊂⊂stmts  ⍝ perform all tests
      i←⍋tests←⊃,/tests ⋄ b←tests≠¯1↓0,tests←tests[i]
     ⍝ Gather results
      i←¯1↑⍴r←⊃∨⌿¨b CCcut r[i;] ⋄ r[;i-1]=←0 ⋄ i←b/tests
      e←1∊¨(⊂':end')⍷¨stmts[i]
      stmts←(¯1+b⍳¨' ')↑¨b←stmts[i]
      r←stmts,e,r
      :If 0≠⎕NC'fmt'
      :AndIf fmt
          r←(⊃stmts),' ⊥→:⊤×>'[1+1 2 3 4 5 6×[2]0 2↓r]
      :EndIf
    ∇

    ∇ r←CCgencombs c;b;E;⎕IO
     ⍝ Generate all Combinations of paths
      E←⊂⍳⎕IO←0
      :If 2∊⍴⍴c
          c←(2↑1+c[;0]⍳'→')↓c             ⍝ '→' starts the definitions
          r←CCgencombs¨⊂[1](c∨.≠' ')⌿c
      :Else
          b←b⍲1⌽b←' '=c←(c⍳'⍝')↑c
          c←1↓b/c                         ⍝ trim ends
          c←c~'+'                         ⍝ min 1
          c[b/⍳⍴b←'|'=c]←','              ⍝ catenate
          c←' ' '(\(?([0-9]+,?)+\)?)\?'⎕R'∘.,' '{E,\1}'+c
          :While '*'∊c
              c←'\(([^()]*)\)\*'⎕R'{E,\1}'+c
          :EndWhile
          b←c∊'{}' ⋄ c[b/⍳⍴b]←'()'['{}'⍳b/c]
          r←,⍎c
      :EndIf
    ∇

    ∇ r←CCinithow
      r←2 2↓⎕CR'CCinithow'
⍝ The programs to "code cover" will be checked for conformance with <CC> requirements using the left argument.
⍝ Conformance means that the program to be "code covered" must follow some rules.
⍝ For ex, ⋄ cannot be used AFTER a branch. Statements like ":if x ⋄ dothis ⋄ :end" cannot be code covered.
⍝ Therefore, <CCinit>'s right argument's values are a list of programs name patterns plus some possible switches:
⍝
⍝ -fix: programs will be modified by splitting 'bad' ⋄s (and a backup taken in 'name∆BU').
⍝ -skip: problematic lines will be skipped, the code won't be modified
⍝ -show: the representation of the modified program will be returned
⍝        this is useful when you want to see what changes will be made.
⍝ If none of these switches are supplied then if a program needs to be modified an error will be signalled.
⍝
⍝ The checks made here are for → and control statements followed by ⋄
⍝ and → followed by label on next line (the 2 statements must be separated).
⍝
⍝ On some systems like APL+Win full comment lines should have a NOOP statement
⍝ inserted BEFORE the ⍝ on the same line because comments don't count in those systems.
⍝ Some control statements are considered as conditional branches (e.g. :Until)
⍝ and others as unconditional (e.g. :Else).
⍝
⍝ The definition of all control statements is kept in 'ControlStmts',
⍝ CS is a compiled version of it and is used here instead.
⍝ It is built by doing CS←CCfindbehav ControlStmts
⍝ It contains
⍝ 0. the :statement ID
⍝ 1. if it is an 'end' statement
⍝ 2. if it causes a branch above (e.g. :ELSE in APL+)
⍝ 3. if it is a conditional branch   (e.g. :IF)
⍝ 4. if this statement is the target of a branch (e.g. :WHILE)
⍝ 5. if the next statement is the target of a branch (e.g. :FOR)
⍝ 6. if this statement does NOT leave a trace in ⎕MF (e.g. :REPEAT in APL+)
⍝ 7. if this statement is an unconditional branch (e.g. :ELSE)
⍝ and 2 more columns used by <CCinit>
⍝
⍝ <CCinit> will save a copy of the CR of the (modified) program and its line flags
⍝ in variable 'name∆CR'. Those flags will be
⍝ → branch  on this line (at the end)
⍝ ⍝ no code on this line (comment or empty line)
⍝ : label   on this line or "branched to" line
⍝ * this line not to be taken into account
⍝
⍝ Notes:
⍝ 1. in Dyalog line 1 is executed first and line 0 is (unless trapped) executed LAST
⍝ 2. the last :ORif stmt's next line is the target of a branch
    ∇

⍝ To do:
⍝ make it work with Dfns (use ⎕profile)

⍝ When used as a user cmd the call should be
⍝    ]ccinit [programs patterns]* -show -skip -fix

⍝ its Run program will parse the line and feed it to the program below

    ∇ new←{programs}CCinit RA;args;NS;pat;pn
    ⍝ RA is a string specifying the pattern of program names to use
    ⍝ LA, if supplied, can be a matrix of names or a list of names.
    ⍝ result is a 2 column matrix of program paths and their flags+CRs
     
      NS←0⊃⎕RSI ⋄ args←⎕NS'' ⋄ args.(Arguments skip show fix)←RA 0 0 0
      :If 2∊⎕NC'programs'
      :AndIf 3=10|⎕DR programs
          args.(skip fix show)←(2 1∊|programs),0>programs
      :EndIf
      :If 326∊⎕DR RA ⍝ support old format, i.e. list of CRs
          :If 2∊⎕NC'programs' ⍝ 0=Stop, 1=Fix problems, 2=Skip problem areas, <0=show
              args.(fix skip show)←(1 2=|pn),0>pn←programs ⍝ accept non parsed format
          :EndIf
      :Else
          args←(⎕NEW ⎕SE.Parser'-fix -skip -show').Parse RA
          :If 0=⎕NC'programs'
              :If 0<⍴pn←args.Arguments
            ⍝ Expand any name with a pattern
                  programs←(~pat←∨/¨pn∊¨⊂'?*')/pn
                  :If ∨/pat
                      programs,←SPLIT NS ⎕SE.UCMD'fnslike ',⍕pat/pn
                  :EndIf
                  programs←⍕programs
              :Else
                  programs←NS.⎕NL 3
              :EndIf
          :EndIf
          args.Arguments←programs
      :EndIf
     
    ⍝ In a UCMD we'd be using ##.THIS Run Args
      new←NS Run'ccinit'args
      'Some fns need fixing'⎕SIGNAL(new≡0)/11
   ⍝ line needed here because of ⎕SIGNAL above
    ∇

    ∇ new←{NU}Run(Cmd Rarg)
     ⍝ DanB 1999-2014 Initialize fns to produce Code Coverage report.
     ⍝ Rarg is a list of names of functions followed by modifiers to do code coverage on OR their ⎕CR.
     ⍝ Result: pairs of function name and its flags+⎕CR, for each function in the list if action≠0.
     ⍝ See variable CCinithow for Larg and details.
     
      :If 0=⎕NC'NU'
          NU←##.THIS
      :EndIf
     
      :Select Cmd
      :Case 'ccinit'
          new←NU Init Rarg
      :Case 'cc'
          new←NU CC Rarg
      :EndSelect
    ∇

    if←/⍨

    ∇ new←NU Init Rarg;b;B;bad;block;blocktype;body;bp1;br;bto;by;C;code;cor;cs;CScol;c200;D;DEL;dfn;dia;EBT;el;ell;end;endBlockOf;epos;F;FIX;fn;Fn;GoTo;i;iCS;lab;labels;lbi;level;lf;line;list;lpb;modified;n;nb;nl;orig;qm;rx;S;SHOW;skip;SKIP;sqz;stop;STOP;t;tmpns;type;U;UB;XCS;xCut;⎕IO;⎕ML
     ⍝ At this point everything is in 'Rarg'
      (fn SKIP SHOW FIX)←Rarg.(Arguments skip show fix)
      new←0 2⍴⎕IO←0 ⋄ ⎕ML←2 ⋄ DEL←⎕AV[0] ⋄ stop←0 ⋄ tmpns←⎕NS''
      sqz←{1↓SQZ,' ',⍵} ⋄ xCut←{⍺←1↑⍵ ⋄ 1↓¨(⍵∊⍺)⊂⍵}
     
     ⍝ We can skip problems and mark offending lines with *
     ⍝ In the end we either fix the code or reject the changes if -fix was not set
     ⍝ or simply show the result if -show was set.
      STOP←SHOW⍱FIX∨SKIP                  ⍝ if we don't have to fix or show or skip then we stop if there is an error
     
      :If 2∊|≡fn                          ⍝ a VTV can include patterns, e.g. 'S???'  'Utils*'  'abc'
      :AndIf 1∧.=∊⍴∘⍴¨fn
          list←⍬
          :For lf :In fn
              :If ∨/'?*'∊lf
                  list,←SPLIT ⎕SE.UCMD'fnslike ',lf
              :Else
                  list,←⊂lf
              :EndIf
          :EndFor
          fn←list
      :EndIf
     
      :If list←1=≡fn←1/fn                 ⍝ simple means program list
          fn←xCut SQZ,' ',fn              ⍝ can be a matrix or char vector
      :AndIf (,9)≡⌊n←NU.⎕NC fn            ⍝ is this a ns? then grab everything in it
          NU←NU⍎0⊃fn                      ⍝ define the new namespace
          fn←NU.⎕NL-3 4                   ⍝ the objects in it
      :AndIf ~list←n≠9.4                  ⍝ is it a Class?
          fn←CCclassfns ⎕SRC NU           ⍝ there are limitations to what we can do with this
      :EndIf
     
     ⍝ NOTE: originally no control statements were used throughout the CC code.
     ⍝ This was to be able to run the code in the APLs that did not support them.
     
     While1:→(⍴fn)↓EndWhile1              ⍝ obtain left justified CR
      Fn←0⊃fn
      :If ~list                           ⍝ do we need to refix the code to determine the type?
          n←tmpns.⎕NC⊂Fn←tmpns.⎕FX F←orig←Fn ⋄ tmpns.⎕EX Fn ⋄ →Nextfn if 0.1≠1||n
      :Else                               ⍝ we have a list of names
          →Nextfn if 0.1≠1||NU.⎕NC⊂Fn     ⍝ Tfns only for now
          F←orig←NU.⎕CR Fn
      :EndIf
      (body dfn)←CCbody F←F⍪(1↓⍴F)↑'⍝'    ⍝ body of fn and dfns mask
     
     ⍝ We need to work with the lowercase version of the :elements and
     ⍝ make sure there is no conflict between some of them, e.g. :else/:elseif.
     ⍝ See CCinithow for CS' definition
      GoTo←'→',t←⎕UCS 7                   ⍝ translate :GoTo into ⎕UCS 7
      F←'(?i::goto )'⎕R t↓F               ⍝ this should work under Classic too
      GoTo,←t←⎕UCS 27                     ⍝ translate ⎕SIGNAL into ⎕UCS 27
      F←⊃'(?i:⎕signal)'⎕R t⊢F
      cs←CS[;0]                           ⍝ the last 4 are blocks in DYW only
      lf←cs CClower(⊂F),(⊂body)           ⍝ 'lf' is the ⎕CR "lowered", CS is already lower
      cs[cs⍳⊂':else']←⊂':Else'
      blocktype←' '                       ⍝ nothing so far
     
     ⍝ Control statements always have a space before the colon
     ⍝ and labels are NOT always immediately followed by a space in Dyalog.
     ⍝ No label and control stmt is allowed in the same statement in APLWin.
      qm←0
     ⍝ Do we need to remove diamonds?
      →(modified←∨/1<n←+/D←1,body∧lf∊'⋄')↓l20 ⍝ any ⋄?
      C←body∧⊃∨⌿cs⍷¨⊂lf                   ⍝ all the important control statements
      B←body∧lf∊GoTo                      ⍝ where → occur in body
      →(modified←0<+/br←,0,C∨B)↓l20       ⍝ any branch or :stmt at all?
      br←(t←,D)CCorred br                 ⍝ where all occur in ⋄s
      b←⊃,/n↑¨1                           ⍝ the # of ⋄ per line
      el←(B←b⊂t CCorred,0,B)≡¨(-n)↑¨1     ⍝ pure → at the end of a line is OK
      dia←b⊂br                            ⍝ ⋄s regrouped per line
      el←el∧B≡¨dia                        ⍝ pure → only valid where no CS present on line
      bad←(dia∊⊂,1)⍱el∨0∧.=¨dia           ⍝ and only 1 or none is OK
      →(modified←∨/bad)↓l20
      :If stop∨←STOP∧1∊bad
          →Nextfn⊣⎕←'<',Fn,'> contains diamonds on lines ',⍕WHR bad
      :ElseIf SKIP
          →l20⊣qm←bad                     ⍝ leave as is, note lines in error
      :EndIf
      F←0⌿lf
     ⍝ There are diamonds (and we are NOT ignoring them) and we know there are cases where
     ⍝ there is a branch before the LAST ⋄ of each line
      :While 1∊bad
     ⍝ We split the offending lines by separating the CS or splitting after a →
          n←bad⍳1 ⋄ t←D[n;]\(n⊃B){1,1↓(⍵>⍺)∨¯1↓0,⍵}n⊃dia
          F←F⍪lf[⍳n;]⍪t CCundia lf[n;] ⋄ t←2↑n←n+1
          D←t↓D ⋄ lf←t↓lf ⋄ dia←n↓dia ⋄ B←n↓B ⋄ bad←n↓bad
      :EndWhile
      F←F⍪lf                              ⍝ whatever remains...
      lf←(0,-b⊥b←' '∧.=F)↓F               ⍝ drop last white columns
     
     ⍝ Check that no :end statement appears - they should all be matched
     ⍝ appropriately, i.e. :for ←→ :endfor
     ⍝ We can make amends by replacing all ':end's by their appropriate counterparts:
     
     l20:(body dfn)←CCbody lf
      lab←∨/t←<\body∧':'=lf               ⍝ lines with labels
      lab←lab\¯1≠⎕NC(↓~∨\lab⌿t)/¨↓lab⌿lf
      lab←t∧[0]lab                        ⍝ :'s related to labels
      end←(⊂':until'),CS[;1]/cs           ⍝ all the :end statements already lowercase
      nb←⍴block←':',¨4↓¨1↓end~⊂':end'     ⍝ various Block types
      code←CS[CS[;0]⍳block,end;8]         ⍝ the SYNTAX code for each
      c200←⊃200⌶↓lf                       ⍝ this Ibeam was introduced in V12.1
      :If 1∊b←∨/c200∊216 219,66+CS[;8]    ⍝ we do not CC those program if there are some SYNTAX problems with them
      :AndIf stop∨←STOP                   ⍝ 216 & 219 above are unmatched {}s
          →Nextfn⊣⎕←'<',Fn,'> contains some syntax problems'
      :EndIf
      qm∨←b∧SKIP                          ⍝ ignore lines in error
      bad←c200∨.=CS[CS[;0]⍳⊂':end';8]     ⍝ any lone :End?
     
      iCS←CS[;8]⍳⊣/(+/∧\3=c200)⌽c200      ⍝ code type of each line
      XCS←CS⍪{⎕ML←0 ⋄ ∊⍵}CS[1;]           ⍝ eXtended CS to index into
      CScol←{⍺←iCS ⋄ XCS[⍺;⍵]}
     
     ⍝ We mark the lines regardless of show/fix
     ⍝ Let's find matching :End blocks
      C←↓(b←∨/c200∊code)⌿c200             ⍝ all lines around a block
      t←~b/qm                             ⍝ account for skipped lines
      type←0⊃¨(t/C)∩¨⊂code                ⍝ the block type
      level←+\¯1 1[type∊nb↑code]          ⍝ nesting level
     ⍝ The last level should be 0, if it isn't there is something wrong
     ⍝ with this code and we ignore it
      :If 0≠¯1↑level
          →Add⊣lf←'** Unable to process program <',Fn,'>'
      :EndIf
      blocktype←b\t\level FindCodes type  ⍝ this tells us what kind of line it is
      C←'?'=code←qm{b\⍵/⍨b←~⍺}CScol 9
      (C/code)←C/blocktype                ⍝ correct code too
     
     ⍝ We try to fix in FIX mode:
      bad←bad>qm
      iCS[WHR bad]←i←CS[;9]⍳bad/blocktype ⍝ correct bad :end
      :If (FIX∨SHOW)∧1∊bad                ⍝ there is only one :keyword per line
          by←CS[i;0]
          (bad/t)←by{('(?i::end)'⎕R ⍺ ⎕OPT'ML' 1)⍵}¨bad⌿t←↓lf
          (body dfn)←CCbody lf←⊃t         ⍝ body of program again
      :EndIf
     
     ⍝ At this point all :struct and → are 1 per line, :struct at the beginning, → at the end
      el←(⊣/(+/∧\' '=lf)⌽lf)∊' ⍝'         ⍝ empty lines
      B←⊃cs⍷¨⊂lf ⋄ body←body>(⍴body)↑lab  ⍝ mask out the labels' colon
      br←(∨/body∧lf∊GoTo)∨CScol 3         ⍝ conditional branch out (unsure about →)
      br←br∨CScol 2                       ⍝ impure branches (branches above)
      UB←CScol 7                          ⍝ unconditional branches out
     
     ⍝ * Lines branched to. These are labels + special :Until
     ⍝ This is a bit tricky: :Until is not usually branched to unless :Continue is used
     ⍝ We check that its :While or :Repeat block contains one before stating it is branched to.
     ⍝ For this we need to know the :Level :
      nl←⍴bto←CScol 4                     ⍝ lines branched to
      (U C)←code∘=¨'uc'
      level←(+\blocktype∊'WRF')-+\blocktype∊'wrf' ⍝ these are the only blocks where leave and continue apply
      endBlockOf←{⍵++/∧\t≥1↑t←⍵↓level}
      :For i :In WHR(1∊U)/C
          bto[t]∨←U[t←endBlockOf i]
      :EndFor
     
     ⍝ We do nothing about :Leave since this only jumps to the line after the block.
     
     ⍝ * Lines branched after.
     ⍝ The If block is branched after the block but we only care if it is never used and this will only
     ⍝ happen if the block itself is never entered. But this done above. [We still mark the line following with ';']?
     ⍝ The blocks we care about are the While and Repeat loop blocks where the first line after the
     ⍝ While or Repeat is branched to unless a series of And/OrIfs are used in which case it is the
     ⍝ line right after the last one which is branched to.
     ⍝ The line after the last line of the block is also branched to under the same conditions, that is
     ⍝ if followed by And/Orifs which can only happen with an :Until.
     
      bp1←¯1↓0,+/∧\CScol 5 1              ⍝ other (following) lines branched to
      n←⍴D←code∊'WRIE'                    ⍝ blocks ':elseif' ':if' ':while' ':repeat'
      :While n>i←D⍳1
          b←1=+\D                         ⍝ avoid same level if/elseif
          :If ∨/b←b∧code='O'              ⍝ any Orifs following?
             ⍝ Any OrIfs right after?
              b←i↓b∧n↑level[i]=(endBlockOf i)↑level
          :AndIf 1∊b
              bp1[i++/∨\⌽b]←1
          :EndIf
         ⍝ Any And/OrIfs at the end?
         ⍝ Find the Until
          :If code[i]∊'WR'
          :AndIf 'u'=code[t←endBlockOf i]
             ⍝ Look at this level
              b←(-n)↑∧\t↓level[t]≤level
          :AndIf 1∊b←b∧(code∊'AO')∧level[t]=level
              bp1[+/∨\⌽b]←2
          :EndIf
          D[i]←0                          ⍝ mark done
      :EndWhile
     
      bp1[1+WHR'e'=code]←2                ⍝ lines after :Else are branched in
     
     ⍝ In some cases the same :statement is used both as a branch out and followed by branch in.
     ⍝ This makes it impossible to "cover check" properly and inserting a fake line doesn't help.
     ⍝ For some APLs, lines without code are NOT reported executed, even those with labels.
     ⍝ We should account for that.
      :If 1∊ell←∨/lab⊣labels←⍬
          n←1++/b←∧\':'≠t←ell⌿lf          ⍝ label space
          labels←1↓¨(nb=' ')CCcut nb←SQZ' ',b\(b←,b)/,t
      :EndIf
      lbi←ell∨bp1∨bto                     ⍝ all lines branched into
     
     ⍝ Find which branches are unconditional - also works when →lab is last stmt
     ⍝ A regex for this is
      rx←'[',GoTo,'](\d+',(∊'|',¨labels),') *([⍝⋄⊣,]|$|\{⍺\})?'
      UB[rx ⎕S 2⊢(↓body)/¨↓lf]←1
      br←br⌈2×UB
     
     ⍝ Find lines that should not be reported
      skip←,⊢/dfn                         ⍝ Dfns (Dyalog only)
      skip←skip∨(nb←¯1↓1,br=2)CCandscan el>lbi ⍝ e.g. →0 followed by ⍝s
      skip∨←code='e'                      ⍝ skip ':else'
     ⍝ Lines between :Select and :Case should be ignored if they have no code
      b←∊(b/t)∧{0,∧\1↓⍵}¨(b←1,1↓t←code='S')⊂el
      skip∨←b
     
     ⍝ The line following an :EndIf can be skipped if there is no label or branch
      b←blocktype∊'ist'                   ⍝ ':endif' ':endselect' ':endtrap'
      skip←skip∨b∧nb                      ⍝ :end just after a pure branch is ignored
     
     ⍝ Branching before a label prevents from determining if the label is
     ⍝ being branched to (same out of the branch as into the label for ex).
      lpb←ell∧¯1↓0,1=br                   ⍝ labelled Line Preceded by Branch
      modified←modified∨b←∨/lpb
      :If stop∨←modified∧STOP
          →Nextfn⊣⎕←'<',Fn,'> contains branches followed by labels on lines ',⍕WHR lpb
      :EndIf
      skip←skip∨qm∨SKIP∧lpb
     
     ⍝ Put flags with the code
      (skip/blocktype)←'*'
      t←code∊'CW'                         ⍝ Case and While are kinda labelled
      t←lbi∧1+t∨ell<¯1⌽blocktype∊'EeF'    ⍝ lines after :For and :Else are NOT considered branched in (;) unless a label exists
      lf←(el\'⍝'),' :;'[t],' →>'[br],blocktype,lf ⍝ columns of 4 flags
     
     ⍝ Insert a line between a pure branch and a label
      →EndIf3 if SKIP∨~∨/lpb
      n←⍴i←WHR~t←1⌽~¯1⌽≠\(1+lpb)/lpb      ⍝ create expand mask
      lf←t⍀lf                             ⍝ expand
      lf[i;3 4 5]←(n,3)⍴'*⍝⋄'             ⍝ mark lines to be skipped
      modified←1
     
     ⍝ Remove final null statement if line before has no branch
     EndIf3:
      b←SKIP∨(~bad←1∊¯2↑br)∨'f'∊¯2↑code   ⍝ no cond → or endfor at the end or are we skipping?
      modified←modified≥b
      :If stop∨←b<STOP
          →Nextfn⊣⎕←'<',Fn,'> needs an extra line at the bottom'
      :EndIf
      :If SKIP∧bad
          lf[¯2+1↑⍴lf;3]←'*'
      :EndIf
      lf←⊃(,¨1↓GoTo)⎕R':GoTo ' '⎕SIGNAL'↓(-b 0)↓lf
      qm←qm↓⍨-b
      :If modified∧FIX
          ⍎(⍕NU),'.',Fn,'⍙BU←orig'        ⍝ take a backup copy
          n←NU.⎕FX 0 4↓lf
      :EndIf
      →(list∧stop<STOP∨FIX∨SKIP)↓Else5
      ⍎(⍕NU),'.',Fn,'⍙CR←lf'
      b←(⍳1+1↑⍴lf)NU.⎕MONITOR Fn
   ⍝ When run on itself this line will have a count higher than its predecessor
      →SHOW↓Nextfn
     
     Else5:lf[WHR SKIP∧qm;3]←'*'
     Add:new←new⍪Fn lf
     Nextfn:fn←1↓fn ⋄ →While1
     
     EndWhile1:→stop↓0
      new←0
    ∇

    ∇ codes←lev FindCodes types;max;mbeg;mend;pc
     ⍝ Find the code associated with each block.
      pc←'?u'∊⍨codes←'',CS[CS[;8]⍳types;9] ⍝ '', in case empty
     ⍝ If there are no lone :End or :Until statements then it is easy
     ⍝ otherwise we need to fix those 2 problematic codes
      :While ∨/pc
          mbeg←lev⍳max←⌈/lev ⋄ mend←mbeg+(mbeg↓lev)⍳max-1
          lev[mbeg,mend]←¯1
          :If pc[mend]
            ⍝ Set matching block beginning
              codes[mend]←Lower codes[mbeg]
              pc[mend]←0
          :EndIf
      :End
    ∇

    ∇ z←a CCandscan b                     ⍝ Partitioned AND Scan
      z←~≠\a\z≠¯1↓1,z←(a←a≥b)/b
    ∇

    ∇ fns←CCclassfns src;dels;end;start
     ⍝ Return all the code of each fn/op in a class whose source is given
      →0↓⍨∨/dels←'    ∇'∘≡¨5↑¨src{⍺}fns←0⍴⊂0 0⍴''
      start←dels\≠\dels/dels
      end←start⊂dels
      fns←end{⊃(5×'     ' '    ∇'∊⍨5↑¨l)↓¨l←(~∨\0,1↓⍺)/⍵}¨start⊂src
    ∇

    ∇ z←a CCorred b
    ⍝ Partitioned OR Reduction
      z←(z/1⌽z←(a∨b)/a)≤a/b
    ∇

    abc←⎕ucs 97+⍳26

    Upper←{b←26>i←abc⍳v←⍵ ⋄ (b/v)←⎕a[b/i] ⋄ v} ⋄ Lower←{b←26>i←⎕a⍳v←⍵ ⋄ (b/v)←abc[b/i] ⋄ v}

    ∇ r←cs CClower s;az;i;ls;mask;n;rc;up;⎕IO
     ⍝ DanB return lowercase of '0⊃s' where cs exist.
     ⍝ Rarg is textmat & boolmask where code is.
     ⍝ Larg is all the possible :statements already lowercased (*)
     ⍝ Work for rank ≤2 '0⊃s'
      ⎕IO←0 ⋄ mask←,0,⊃s[1] ⋄ rc←(-⍴rc)↑0 1+rc←⍴ls←s←⊃s[0]
     ⍝ Lower 's' into 'ls'
      az←⎕UCS 97+⍳26 ⋄ n←⎕UCS 0 ⋄ up←⎕A∊⍨ls←,n,s ⋄ n←⍴s←,n,s
     ⍝ Use lowercase version to search (ls), replace in 's'.
      (up/ls)←az[⎕A⍳up/ls]
      i←0 ⋄ cs←cs,':else' ':end' '⎕signal' ⍝ ensure those are there
      :While i<⍴cs
          r←((mask∧c⍷ls)/⍳n)∘.+⍳⍴c←⊃cs[i] ⋄ s[r]←(⍴r)⍴c ⋄ i+←1
      :EndWhile
     
     ⍝ * special case: else and elseif are similar;
     ⍝ to differenciate them we change else to Else
      n←⍴i←i/⍳⍴i←mask∧(':else'⍷ls)>':elseif'⍷ls
      s[i+1]←'E'                          ⍝ make 'else' into 'Else'
      r←((-⍴rc)↑1)↓rc⍴s
    ∇

    ∇ R←{P}CCltscan V;M
     ⍝ Partitioned <\
      M←P∨V∧∨\P
      R←(V∧P)∨M\R>¯1↓0,R←M/V
    ∇

    ∇ cr←fnname CCmakefn list;a;args;b;drop;for;i;n;⎕IO;⎕ML
     ⍝ Create a program from a list of :statements  newcs
      drop←-a←'⍵'∊¨list
      ⎕IO←1 ⋄ ⎕ML←2 ⋄ args←(+/a)⍴'ABCDEFGHIJ'
      fnname←fnname,' args;null;x;t',CCenlist';',¨args
     ⍝ Reverse test after :until
      b←∨\(4↑¨a/list)∊⊂':unt' ⋄ n←b\'~'
      list←((':'≠,↑1↑¨list)⍴¨':'),¨(drop↓¨list),¨a\n,¨(⊂'0<t ∆ '),¨args,¨(⊂'←¯1+t←'),¨args
     ⍝ Check the :for statement
      list[⍳':for'≡4↑1⊃list]←⊂':for x :in ⍳A'
      list←,(list,[1.1]n),n←⊂'null'
     ⍝ Prevent looping forever with :endrepeat
      :If 1∊b←(7↑¨list)∊⊂':endrep'
          list[¯2+b⍳1]←⊂'→(x←x-1)↓l'
      :EndIf
     ⍝ Mod line for :trap atfer for 1st null stmt
      :If 1 0 1≡3↑(5↑¨list)∊':trap' ':Else'
          list←list[⍳2],(⊂'t←÷A'),2↓list
      :EndIf
      args←'null←0 0⍴x←3',⍕(0<⍴args)/'⋄(',(CCenlist' ',¨args),')←args'
      cr←⊃fnname args,list,⊂'l:null ⍝ last'
    ∇

    ∇ R←S CCorscan P;T
     ⍝ Partionned ∨\
      S←S∨P ⋄ R←≠\S\T≠¯1↓0,T←S/P
    ∇

    ∇ CCreset;del;i;v;x;⎕IO
     ⍝ Reset all definitions: remove all ⍙BU and ⍙CR variables and redefine fns
      ⎕IO←1
      ⎕CS ⎕IO⊃⎕NSI                        ⍝ return to caller env
      i←¯3↑⍳¯1↑⍴v←(-+/∧\' '=⌽v)⌽v←⎕NL 2
      →(1∊del←v[;i]∧.='⍙BU')↓l20
      x←÷~1∊⊃x←⎕FX¨⍎¨⊂[2]del⌿v
     l20:del←del∨v[;i]∧.='⍙CR'
      (⍕+/⎕EX del⌿v),' objects deleted'
    ∇

    ∇ {r}←{args}CCteststmts stmts;a;apl;b;bi;bo;col;cr;ex;f;ml;n;nla;row;sink;ubs;∆;⎕IO
     ⍝ Run a series of tests on stmts
      ⎕IO←0
      :If nla←0=⎕NC'args'
          args←⊂[1]2×⍉(n⍴2)⊤⍳2*n←+/'⍵'∊¨stmts
      :Else
          args←⊂args
      :EndIf
      sink←⎕FX cr←'f'CCmakefn stmts
      r←((⍴stmts),6)⍴0
      →(0∊⍴n←(row←n/⍳⍴n←':'=cr[;0])∘.+2 2⍴¯1 0 0 1)⍴0
      ubs←∨/⊃∨/CCunBranchStmts⍷¨⊂cr[row;]
      sink←⎕FX(1,⍴a)⍴a←'l←l ∆ r'          ⍝ <lev> fn
      apl←0                               ⍝ ((4 3⍴'DYWA2KAPXSAX')∧.=APL)⍳1
      ml←apl⊃(⍳1↑⍴cr)1 ⋄ col←1 2[apl]
      :For a :In args
          sink←ml ⎕MONITOR'f'
          f a
          ex←(⎕MONITOR'f')[;col]
          :If ~nla
              ⎕←cr,ex→0
          :EndIf
     ⍝ See if this is a branch out
          bo←>/ex[n]
     ⍝ or a branch in for line and following one
          bi←</ex[n]
          b←bo,bi
     ⍝ Make sure conditional branches are noted as such
          b[;1]>←ubs
          r←r∨(b,0<ex[row]),ubs
      :EndFor
    ∇

    ∇ (b d)←CCbody s;c;t
     ⍝ Find where the body of the program (s) is and the Dfns
      t←≠\s=''''                          ⍝ text: in APL+Win account for "
      c←∨\t<'⍝'=s                         ⍝ find comments
      b←c⍱t                               ⍝ body of program
      b←b>⌽∧\⌽b≤s∊' ⋄'                    ⍝ don't include trailing spaces & ⋄s
      d←0⍪1 0↓(⍴s)⍴0<(+\,b∧'{'=s)-+\,b∧'}'=s ⍝ includes trailing ⍝s!
      b←b>d                               ⍝ body does not include Dfns
    ∇

    ∇ block←D CCundia line;len;n;new;sp
     ⍝ Split a line of statements at the diamonds
     ⍝ D is where the offending ⋄s are.
      len←''⍴⍴line ⋄ n←+/D                ⍝ number of statements
      sp←(0,1↓n⍴¯1++/∧\' '=line)↑¨' '     ⍝ spacing for new lines
      new←1↓¨D⊂' ',line
      :If new≡block←'→(.*?)[↑⍴/](⎕LC\+1|1\+⎕LC) *(\r[^\r]+)'⎕R':if ~\1 ⍝⋄\3\r :endif\r'⎕OPT'Mode' 'D'+new
          block←⊃len↑¨sp,¨new,¨(~⌽n↑1)/¨⊂'⍝⋄'
      :Else
          block←⊃len↑¨block
      :EndIf
    ∇

    ∇ (l r)←{l}FindCScodes r;a
      :GoTo L
      :If 0
      :AndIf
          :Repeat
              :Return
          :EndRepeat
      :ElseIf
          :Select 0
          :Case 1
              :For a :In ⍬
                  :With ⎕NS''
                      :Hold ''
                          :Trap 3
                              :For a :InEach 1
                                  :While 0
                                      :Repeat
                                      :Until 1
                                      :OrIf 1
                                  :EndWhile
                                  :Leave
                              :End
                          :EndTrap
                      :EndHold
                  :EndWith
                  :Continue
              :EndFor
          :CaseList 1 1
          :Else
          :EndSelect
      :EndIf
     L: ⍝ the above code is used only to determine the control structure codes
      l←200⌶r←{(+/∧\' '=⍵)↓⍵}¨L↑⎕NR ⎕IO⊃⎕SI
      r←∪r{n←+/⍵=t←⍬⍴⍵ ⋄ (n↑⍺)t}¨l
      (l r)←↓⍉⊃1↓r ⋄ l←Lower¨l
    ∇

    CS[;8]←CS[;0]{(c v)←⍵ ⋄ v[c⍳⍺]}FindCScodes 0

    ∇ CS←{apl}MakeCS tab;ans;bv;col;cons;csl;CStable;end;ids;iv;msk;nc;⎕IO;⎕ML
     ⍝ Create variable 'CS' from 'ControlStmts'
     ⍝ 'ControlStmts' is a free format character matrix of :controlstatement followed by style for each APL
     ⍝ Row with 'id' is APL ids, rows starting with : are styles' data
      ⎕IO←0 ⋄ ⎕ML←2
      ⍎(0=⎕NC'apl')/'apl←APL'
      ans←(csl←tab[;0]∊'123456789')⌿tab
      nc←+/∧\' '≠CStable←(+/∧\ans≠':')⌽ans
      col←end>¯1⌽end←' '≠ids←,(∨/' id '⍷' ',tab)⌿tab
      col←col/⍳⍴col                       ⍝ id+:stmts start
      bv←ids[col∘.+⍳3]∧.=apl
      'unknown APL'⎕SIGNAL(1∊bv)↓11
      iv←col[iv]+⍳-/(col,⍴ids)[1 0+iv←bv⍳1]
      msk←∨\'⍝'=cons←csl⌿tab[;iv]
      end←CStable[;⍳4]∧.=':end'
      bv←end,⍉∨/msk<[1 2]'⊥→:⊤×>'∘.=cons
     ⍝ '×'=col ⍝ don't appear in ⎕MF
     ⍝ '→'=col ⍝ is a conditional →
     ⍝ '⊤'=col ⍝ next  statement is target of a branch
     ⍝ ':'=col ⍝ this  statement is target of a branch
     ⍝ '⊥'=col ⍝ above statement is target of a branch
      nc←nc↑¨⊂[1]CStable
     
      CS←nc,bv
    ∇

    ∇ NS
     ⍝ NOOP statement
    ∇

⍝ This method is to be inserted into any Class to do code coverage:

    ∇ {r}←C_C list;all;b;⎕IO              ⍝ Code Coverage in Classes
     ⍝ list: fns to Code cover or 0 (stop & clear) or -1 (stop)
     ⍝ It sets or uses 'CCdata', a 2 column matrix of names and CRs
     ⍝ Example:
     ⍝    C_C 1  ⍝ set monitoring on all trad programs and operators
     ⍝ run programs here - this assumes all programs are amenable to code coverage
     ⍝    C_C ¯1 ⍝ produce report
     ⍝ run some more programs
     ⍝    C_C 0  ⍝ produce report and remove count data
     
      :Access public shared
      ⎕IO←1
      :Trap 6
          {}CodeCov.Version               ⍝ bring in code if not present
      :Else
          ⎕SE.SALT.Load'tools\code\codecov'
      :EndTrap
     
      :If 1∊b←¯1 0∊list
          r←CodeCov.CC CCdata,⎕MONITOR¨CCdata[;1]
          →b[1]/0                         ⍝ do not reset numbers if ¯1
          →0,⍬∘⎕MONITOR¨all
      :ElseIf list≡1
          list←(⎕NL-3.1 4.1)~1↑⎕SI        ⍝ all but ourself
      :EndIf
      r←CCdata←⎕THIS CodeCov.CCSet list(⎕CR¨list←,⊂⍣(1=≡,list),list)
      (¯1+⍳999)∘⎕MONITOR¨list             ⍝ we can't do this inside CC
    ∇

:EndNamespace                             ⍝ CodeCov  $Revision: 964 $