﻿:Namespace compare
⍝ Namespace used to compare VTVs
    DELINS←'←→' ⋄ ZONE←2 ⋄ TRIM←0 ⋄ ⎕io←0 ⋄ ⎕ml←3

    dlb←{(∨\' '≠⍵)/⍵}

    ∇ b←a jdm w;i;n
     ⍝ jot-dot-match
      :If TRIM ⋄ a w←⌽∘dlb⍣2¨¨a w ⋄ :EndIf
      b←a∘.≡w
    ∇

    ∇ d←m1 compecv m2;x;r;c;del;fmt;n;b;∆
     ⍝ Enclosed Character Vectors comparison
     ⍝ Display the object m1 together with the lines from m2 which are
     ⍝ different from m1.
      x←compbool m1 jdm m2 ⋄ b←~r←∨/x ⋄ c←~∨⌿x
      del←b\''⍴DELINS ⍝ delete/insert symbols
      fmt←'⍞[⍞,Q⍞]⍞LI',⍕6⌈3+⌊10⍟1⌈(⍴r)-1⍳⍨⌽r
      n←¯1↑⍴d←del,fmt ⎕FMT⍳x←⍴r ⍝ row nos, N(≥6) wide, ←=left, →=right
      r←⍋(compind r),c/compind~c ⍝ order of display
      b←b,1⍴⍨+/c
      d←((↓d),¨m1),(n↑1↓DELINS)∘,¨c/m2 ⋄ d←d[r]
      x←(⍳1+2×ZONE)-ZONE ⍝ zone of display
      :If 0∊⍴r←r/⍳⍴r←b[r] ⋄ d←''
      :Else
          r←∪(≠/r∘.<0,1⍴⍴d)/r←,r∘.+x
          b←1=∆←1,-2-/r ⋄ b←=\(1+b=0)/b
          d←b\d[r]
          d[(~b)/⍳⍴b]←⊂' [..]'
          d←∊⎕AV[3],¨d
      :EndIf
    ∇

     ⍝ <compbool>
     ⍝ b←→boolean matrix b   m←→ is b with some of the 1's replaced by 0
     ⍝ m has the properties that:
     ⍝ (1) 1≥(+/m),+⌿m
     ⍝ (2) each 1 is below and to the right of the previous 1
     ⍝ (3) +/,m is a maximum for constraints (1) and (2)
     ⍝ NOTES ⎕io←0,   m is not necessarily the unique optimal solution of (3)
     ⍝ main algorithm calculates the boolean matrix x where :
     ⍝ max[i;j]←+/,compbool (i,j)↑b    and   x←max-0 1↓0,max
     ⍝ then uses this to calculate result thereafter

    ∇ m←compbool b;br;bc;r;c;x;y;z;i;li;s;fix;n;⎕IO;f
      b←(br←∨/b)⌿(bc←∨⌿b)/b ⍝ get rid of zero rows and columns
      m←(⍴b)⍴r←c←⎕IO←0
      :Repeat
          n←⍳+/∧\,0 0⍉b ⍝ follow diagonal as far as possible
          m[r+n;c+n]←n∘.=n ⋄ r←r+n←⍴n ⋄ c←c+n ⋄ b←(n,n)↓b
          x←+/∧\∧/~b ⋄ y←+/∧\∧⌿~b ⍝ number of adjacent 0 rows and cols
      :Until 0=⌈/x,y ⍝ no zero rows or cols
      r←r+x ⋄ c←c+y ⋄ b←(x,y)↓b  ⍝ cut back b and try diagonal again
      :OrIf 0
      :If ~0∊⍴b
          b←(fix←i,~i←</⍴b)⍉b ⍝ ensure 1st dimension is longer
          li←⍴y←∨\b[;0] ⋄ z←(1↓⍴b)⍴i←0 ⋄ x←(⍴b)⍴0 ⍝ initialise loop
          :For i :In ⍳li
              x[i;]←z≠¯1↓0,z←⌈\z⌈y[i],(¯1↓z)+1↓b[i;]
          :EndFor
          :If 0≠y←¯1↑z ⍝ y is the number of matches
              z←n←1↓⍴b ⋄ i←¯1+''⍴⍴b ⍝ initialise loop
              :Repeat
                  f←z≠s←(z↑b[i;]×+\x[i;])⍳y
                  x[i;]←(-s)⊖n↑f ⋄ z←(¯1*f)↑z,s ⋄ i←i-1
              :Until 0=y←y-f
              x[⍳i+1;]←0
              x←b←fix⍉x
              s←⍴b ⋄ m[r+⍳s[0];c++⍳s[1]]←b
          :EndIf
      :EndIf
      m←br⍀bc\m
    ∇

    ∇ n←compind b
     ⍝ return nos. from 1 to +/b for each element of b such that
     ⍝ n is strictly increasing and b/n is ⍳+/b(⎕io=1)
      n←¯1↓+\n/÷n←(1↓n)-¯1↓n←b/⍳⍴b←1,b,1
    ∇


:EndNamespace ⍝ compare  $Revision: 742 $