﻿:Namespace listsUtils
    
⍝ Namespace containing utilities to deal with lists
    
    ∇ sequence←a fromTo b;⎕IO;from;diff
    ⍝ Generate all the numbers from a to b
    ⍝ Account for the fact that a and b may be lists themselves
      ⎕IO←1
      sequence←from+(×diff)×⍳|diff←(1↑b)-from←¯1↑a
      sequence←a,sequence,1↓b ⍝ 'to' is already accounted for
    ∇
    
    ∇ shifted←n shiftList list;dir
    ⍝ Shift list n positions to the right (<0: to the left)
      dir←(0=n)-×n
      shifted←(dir×⍴list)↑(-n)↓list
    ∇
    
:EndNamespace  ⍝ listsUtils  $Revision: 739 $ 